/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TViewFrame.h"

TViewFrame::TViewFrame(QWidget* parent, Qt::WindowFlags)
: QGraphicsView(parent)
{
	image = new TViewItem();
	scene = new QGraphicsScene(this);
	scene->addItem(this->image);
	
	QPixmap *tempPixmap = new QPixmap(":img/background.png", "PNG");
	QBrush *tempBrush = new QBrush(QColor(55, 55, 55, 255));
	tempBrush->setTexture(*tempPixmap);
	scene->setBackgroundBrush(*tempBrush);
	this->setCacheMode(QGraphicsView::CacheBackground);

    this->setVisible(true);
	
	this->tempSceneBorn();
	this->setScene(tempScene);
	
	this->setDragMode(QGraphicsView::ScrollHandDrag);
}

void TViewFrame::tempSceneBorn()
{
	tempScene = new QGraphicsScene(this);
	
	QRadialGradient gradient(QPoint(70, 70), 170, QPoint(70, 70));
	gradient.setColorAt(0.05, Qt::white);
	gradient.setColorAt(1, Qt::black);
	
	tempScene->setBackgroundBrush(QBrush(gradient));
	QGraphicsPixmapItem *logoItem = new QGraphicsPixmapItem(QPixmap(":/img/logo.svg"));
	tempScene->addItem(logoItem);
}

void TViewFrame::setWorkScene()
{
	this->setScene(scene);
}

void TViewFrame::setImage(QImage &image)
{
	this->image->setImage(image);
	this->image->setScale(1);
}
