/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TPages.h"

TMainPage::TMainPage(QWidget *parent, Qt::WindowFlags f) : QWidget(parent, f)
{
	// first group
	QGroupBox *secondGroup = new QGroupBox(tr("Result picture options"));
	
	countFrames = new QSpinBox(this);
	countFrames->setMinimum(1);
	countFrames->setMaximum(100);
	countFrames->setMaximumWidth(60);
	QLabel *countFramesLabel = new QLabel(tr("Count of frames:"));
	QHBoxLayout  *countFramesLayer = new QHBoxLayout;
	countFramesLayer->addWidget(countFramesLabel);
	countFramesLayer->addWidget(countFrames);
	
	countHor = new QSpinBox(this);
	countHor->setMinimum(1);
	countHor->setMaximum(100);
	countHor->setMaximumWidth(60);
	QLabel *countHorLabel = new QLabel(tr("Count of frames (horisontal):"));
	QHBoxLayout  *countHorLayer = new QHBoxLayout;
	countHorLayer->addWidget(countHorLabel);
	countHorLayer->addWidget(countHor);
	
	indentBorder = new QSpinBox(this);
	indentBorder->setMinimum(0);
	indentBorder->setMaximum(1000);
	indentBorder->setMaximumWidth(60);
	QLabel *indentBorderLabel = new QLabel(tr("Offset:"));
	QHBoxLayout  *indentBorderLayer = new QHBoxLayout;
	indentBorderLayer->addWidget(indentBorderLabel);
	indentBorderLayer->addWidget(indentBorder);
	
	indentItems = new QSpinBox(this);
	indentItems->setMinimum(0);
	indentItems->setMaximum(1000);
	indentItems->setMaximumWidth(60);
	QLabel *indentItemsLabel = new QLabel(tr("Indention between items:"));
	QHBoxLayout  *indentItemsLayer = new QHBoxLayout;
	indentItemsLayer->addWidget(indentItemsLabel);
	indentItemsLayer->addWidget(indentItems);
	
	scale = new QSpinBox(this);
	scale->setMinimum(5);
	scale->setMaximum(100);
	scale->setMaximumWidth(60);
	QLabel *scaleLabel = new QLabel(tr("Scale of frames (%):"));
	QHBoxLayout  *scaleLayer = new QHBoxLayout;
	scaleLayer->addWidget(scaleLabel);
	scaleLayer->addWidget(scale);
	
	quality = new QSpinBox(this);
	quality->setMinimum(0);
	quality->setMaximum(100);
	quality->setMaximumWidth(60);
	QLabel *qualityLabel = new QLabel(tr("Quality of result image (0-100):"));
	QHBoxLayout  *qualityLayer = new QHBoxLayout;
	qualityLayer->addWidget(qualityLabel);
	qualityLayer->addWidget(quality);
	
	formatImg = new QComboBox(this);
	formatImg->setMaximumWidth(60);
	formatImg->addItem("png");
	formatImg->addItem("jpg");
	formatImg->addItem("xpm");
	QLabel *formatImgLabel = new QLabel(tr("Default image format"));
	QHBoxLayout *formatImgLayer = new QHBoxLayout;
	formatImgLayer->addWidget(formatImgLabel);
	formatImgLayer->addWidget(formatImg);
	
	logo = new QCheckBox(tr("Show logo"));
	
	QVBoxLayout *resultLayer = new QVBoxLayout;
	resultLayer->addLayout(countFramesLayer);
	resultLayer->addLayout(countHorLayer);
	resultLayer->addLayout(indentBorderLayer);
	resultLayer->addLayout(indentItemsLayer);
	resultLayer->addLayout(scaleLayer);
	resultLayer->addLayout(qualityLayer);
	resultLayer->addLayout(formatImgLayer);
	resultLayer->addWidget(logo);
	secondGroup->setLayout(resultLayer);
	
	
	
	QGroupBox *indentGroup = new QGroupBox(tr("Indentations"));
	
	indentTimeStart = new QTimeEdit(this);
	indentTimeStart->setMaximumWidth(100);
	QLabel *indentTimeStartLabel = new QLabel(tr("Indentftion of start:"));
	QHBoxLayout  *indentTimeStartLayer = new QHBoxLayout;
	indentTimeStartLayer->addWidget(indentTimeStartLabel);
	indentTimeStartLayer->addWidget(indentTimeStart);
	
	indentTimeFinish = new QTimeEdit(this);
	indentTimeFinish->setMaximumWidth(100);
	QLabel *indentTimeFinishLabel = new QLabel(tr("Indentation of finish:"));
	QHBoxLayout  *indentTimeFinishLayer = new QHBoxLayout;
	indentTimeFinishLayer->addWidget(indentTimeFinishLabel);
	indentTimeFinishLayer->addWidget(indentTimeFinish);
	
	QVBoxLayout *resultIndentLayer = new QVBoxLayout;
	resultIndentLayer->addLayout(indentTimeStartLayer);
	resultIndentLayer->addLayout(indentTimeFinishLayer);
	indentGroup->setLayout(resultIndentLayer);
	
	
	
	QGroupBox *styleGroup = new QGroupBox(tr("Styles"));
    QLabel *styleLabel = new QLabel(tr("Style:"));
    styleBox = new QComboBox;
	styleBox->addItem(tr("Shadowed"));
	styleBox->addItem(tr("Simple"));

    QHBoxLayout *styleLayout = new QHBoxLayout;
	styleLayout->addWidget(styleLabel);
	styleLayout->addWidget(styleBox);

    QVBoxLayout *configLayout = new QVBoxLayout;
	configLayout->addLayout(styleLayout);
	styleGroup->setLayout(configLayout);

    QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(secondGroup);
	mainLayout->addWidget(indentGroup);
	mainLayout->addWidget(styleGroup);
    mainLayout->addStretch(1);
    setLayout(mainLayout);
}

TFileInfoPage::TFileInfoPage(QWidget *parent)
	: QWidget(parent)
{
	QGroupBox *fileInfoGroup = new QGroupBox(tr("File information"));
	
	infoName = new QCheckBox(tr("Name of file"));
	infoSize = new QCheckBox(tr("Size of file"));
	infoDuration = new QCheckBox(tr("Duration"));
	infoResolution = new QCheckBox(tr("Resolution of video"));
	infoVideo = new QCheckBox(tr("Video codec information"));
	infoAudio = new QCheckBox(tr("Audio codec information"));
	
	QVBoxLayout *infoLayout = new QVBoxLayout;
	infoLayout->addWidget(infoName);
	infoLayout->addWidget(infoSize);
	infoLayout->addWidget(infoDuration);
	infoLayout->addWidget(infoResolution);
	infoLayout->addWidget(infoVideo);
	infoLayout->addWidget(infoAudio);
	fileInfoGroup->setLayout(infoLayout);
	
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(fileInfoGroup);
	
	mainLayout->addStretch(1);
	setLayout(mainLayout);
}

TFontsPage::TFontsPage(QWidget *parent)
    : QWidget(parent)
{
	// font for metainfo
	f1 = new TFontChoser(this);
    f1->setText(tr("Font for meta-information:"));

	// font for time
	f2 = new TFontChoser(this);
    f2->setText(tr("Font for timestamps:"));
    
    // adding widgets to the vertical layour
    QVBoxLayout *configLayout = new QVBoxLayout;
    QGroupBox *configGroup = new QGroupBox(tr("Fonts"));

    configLayout->addLayout(f1->getLayout());
    configLayout->addLayout(f2->getLayout());
    configGroup->setLayout(configLayout);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addWidget(configGroup);

    mainLayout->addStretch(1);
    setLayout(mainLayout);
}

TColorPage::TColorPage(QWidget *parent)
	: QWidget(parent)
{	
	colorInfoText = new TColorChoser(this);
	colorInfoText->setText(tr("Color for meta-information (first column):"));
	colorInfoInfo = new TColorChoser(this);
	colorInfoInfo->setText(tr("Color for meta-information (second column):"));
	colorBackground = new TColorChoser(this);
	colorBackground->setText(tr("Background color:"));
	
	QVBoxLayout *configLayout = new QVBoxLayout;
	QGroupBox *configGroup = new QGroupBox(tr("Colors"));

	configLayout->addLayout(colorInfoText->getLayout());
	configLayout->addLayout(colorInfoInfo->getLayout());
	configLayout->addLayout(colorBackground->getLayout());
	configGroup->setLayout(configLayout);
	
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(configGroup);
	mainLayout->addStretch(1);
	setLayout(mainLayout);
}
