// Copyright 2018-2020 opcua authors. All rights reserved.
// Use of this source code is governed by a MIT-style license that can be
// found in the LICENSE file.

// Code generated by cmd/id. DO NOT EDIT!

package id

import "strconv"

func Name(id uint32) string {
	if s, ok := name[id]; ok {
		return s
	}
	return strconv.FormatUint(uint64(id), 10)
}

const (
	Boolean                                                                                                               = 1
	SByte                                                                                                                 = 2
	Byte                                                                                                                  = 3
	Int16                                                                                                                 = 4
	UInt16                                                                                                                = 5
	Int32                                                                                                                 = 6
	UInt32                                                                                                                = 7
	Int64                                                                                                                 = 8
	UInt64                                                                                                                = 9
	Float                                                                                                                 = 10
	Double                                                                                                                = 11
	String                                                                                                                = 12
	DateTime                                                                                                              = 13
	GUID                                                                                                                  = 14
	ByteString                                                                                                            = 15
	XMLElement                                                                                                            = 16
	NodeID                                                                                                                = 17
	ExpandedNodeID                                                                                                        = 18
	StatusCode                                                                                                            = 19
	QualifiedName                                                                                                         = 20
	LocalizedText                                                                                                         = 21
	Structure                                                                                                             = 22
	DataValue                                                                                                             = 23
	BaseDataType                                                                                                          = 24
	DiagnosticInfo                                                                                                        = 25
	Number                                                                                                                = 26
	Integer                                                                                                               = 27
	UInteger                                                                                                              = 28
	Enumeration                                                                                                           = 29
	Image                                                                                                                 = 30
	References                                                                                                            = 31
	NonHierarchicalReferences                                                                                             = 32
	HierarchicalReferences                                                                                                = 33
	HasChild                                                                                                              = 34
	Organizes                                                                                                             = 35
	HasEventSource                                                                                                        = 36
	HasModellingRule                                                                                                      = 37
	HasEncoding                                                                                                           = 38
	HasDescription                                                                                                        = 39
	HasTypeDefinition                                                                                                     = 40
	GeneratesEvent                                                                                                        = 41
	Aggregates                                                                                                            = 44
	HasSubtype                                                                                                            = 45
	HasProperty                                                                                                           = 46
	HasComponent                                                                                                          = 47
	HasNotifier                                                                                                           = 48
	HasOrderedComponent                                                                                                   = 49
	Decimal                                                                                                               = 50
	FromState                                                                                                             = 51
	ToState                                                                                                               = 52
	HasCause                                                                                                              = 53
	HasEffect                                                                                                             = 54
	HasHistoricalConfiguration                                                                                            = 56
	BaseObjectType                                                                                                        = 58
	FolderType                                                                                                            = 61
	BaseVariableType                                                                                                      = 62
	BaseDataVariableType                                                                                                  = 63
	PropertyType                                                                                                          = 68
	DataTypeDescriptionType                                                                                               = 69
	DataTypeDictionaryType                                                                                                = 72
	DataTypeSystemType                                                                                                    = 75
	DataTypeEncodingType                                                                                                  = 76
	ModellingRuleType                                                                                                     = 77
	ModellingRule_Mandatory                                                                                               = 78
	ModellingRule_MandatoryShared                                                                                         = 79
	ModellingRule_Optional                                                                                                = 80
	ModellingRule_ExposesItsArray                                                                                         = 83
	RootFolder                                                                                                            = 84
	ObjectsFolder                                                                                                         = 85
	TypesFolder                                                                                                           = 86
	ViewsFolder                                                                                                           = 87
	ObjectTypesFolder                                                                                                     = 88
	VariableTypesFolder                                                                                                   = 89
	DataTypesFolder                                                                                                       = 90
	ReferenceTypesFolder                                                                                                  = 91
	XMLSchema_TypeSystem                                                                                                  = 92
	OPCBinarySchema_TypeSystem                                                                                            = 93
	PermissionType                                                                                                        = 94
	AccessRestrictionType                                                                                                 = 95
	RolePermissionType                                                                                                    = 96
	DataTypeDefinition                                                                                                    = 97
	StructureType                                                                                                         = 98
	StructureDefinition                                                                                                   = 99
	EnumDefinition                                                                                                        = 100
	StructureField                                                                                                        = 101
	EnumField                                                                                                             = 102
	DataTypeDescriptionType_DataTypeVersion                                                                               = 104
	DataTypeDescriptionType_DictionaryFragment                                                                            = 105
	DataTypeDictionaryType_DataTypeVersion                                                                                = 106
	DataTypeDictionaryType_NamespaceURI                                                                                   = 107
	ModellingRuleType_NamingRule                                                                                          = 111
	ModellingRule_Mandatory_NamingRule                                                                                    = 112
	ModellingRule_Optional_NamingRule                                                                                     = 113
	ModellingRule_ExposesItsArray_NamingRule                                                                              = 114
	ModellingRule_MandatoryShared_NamingRule                                                                              = 116
	HasSubStateMachine                                                                                                    = 117
	NamingRuleType                                                                                                        = 120
	DataTypeDefinition_Encoding_DefaultBinary                                                                             = 121
	StructureDefinition_Encoding_DefaultBinary                                                                            = 122
	EnumDefinition_Encoding_DefaultBinary                                                                                 = 123
	DataSetMetaDataType_Encoding_DefaultBinary                                                                            = 124
	DataTypeDescription_Encoding_DefaultBinary                                                                            = 125
	StructureDescription_Encoding_DefaultBinary                                                                           = 126
	EnumDescription_Encoding_DefaultBinary                                                                                = 127
	RolePermissionType_Encoding_DefaultBinary                                                                             = 128
	HasArgumentDescription                                                                                                = 129
	HasOptionalInputArgumentDescription                                                                                   = 131
	IDType                                                                                                                = 256
	NodeClass                                                                                                             = 257
	Node                                                                                                                  = 258
	Node_Encoding_DefaultXML                                                                                              = 259
	Node_Encoding_DefaultBinary                                                                                           = 260
	ObjectNode                                                                                                            = 261
	ObjectNode_Encoding_DefaultXML                                                                                        = 262
	ObjectNode_Encoding_DefaultBinary                                                                                     = 263
	ObjectTypeNode                                                                                                        = 264
	ObjectTypeNode_Encoding_DefaultXML                                                                                    = 265
	ObjectTypeNode_Encoding_DefaultBinary                                                                                 = 266
	VariableNode                                                                                                          = 267
	VariableNode_Encoding_DefaultXML                                                                                      = 268
	VariableNode_Encoding_DefaultBinary                                                                                   = 269
	VariableTypeNode                                                                                                      = 270
	VariableTypeNode_Encoding_DefaultXML                                                                                  = 271
	VariableTypeNode_Encoding_DefaultBinary                                                                               = 272
	ReferenceTypeNode                                                                                                     = 273
	ReferenceTypeNode_Encoding_DefaultXML                                                                                 = 274
	ReferenceTypeNode_Encoding_DefaultBinary                                                                              = 275
	MethodNode                                                                                                            = 276
	MethodNode_Encoding_DefaultXML                                                                                        = 277
	MethodNode_Encoding_DefaultBinary                                                                                     = 278
	ViewNode                                                                                                              = 279
	ViewNode_Encoding_DefaultXML                                                                                          = 280
	ViewNode_Encoding_DefaultBinary                                                                                       = 281
	DataTypeNode                                                                                                          = 282
	DataTypeNode_Encoding_DefaultXML                                                                                      = 283
	DataTypeNode_Encoding_DefaultBinary                                                                                   = 284
	ReferenceNode                                                                                                         = 285
	ReferenceNode_Encoding_DefaultXML                                                                                     = 286
	ReferenceNode_Encoding_DefaultBinary                                                                                  = 287
	IntegerID                                                                                                             = 288
	Counter                                                                                                               = 289
	Duration                                                                                                              = 290
	NumericRange                                                                                                          = 291
	Time                                                                                                                  = 292
	Date                                                                                                                  = 293
	UtcTime                                                                                                               = 294
	LocaleID                                                                                                              = 295
	Argument                                                                                                              = 296
	Argument_Encoding_DefaultXML                                                                                          = 297
	Argument_Encoding_DefaultBinary                                                                                       = 298
	StatusResult                                                                                                          = 299
	StatusResult_Encoding_DefaultXML                                                                                      = 300
	StatusResult_Encoding_DefaultBinary                                                                                   = 301
	MessageSecurityMode                                                                                                   = 302
	UserTokenType                                                                                                         = 303
	UserTokenPolicy                                                                                                       = 304
	UserTokenPolicy_Encoding_DefaultXML                                                                                   = 305
	UserTokenPolicy_Encoding_DefaultBinary                                                                                = 306
	ApplicationType                                                                                                       = 307
	ApplicationDescription                                                                                                = 308
	ApplicationDescription_Encoding_DefaultXML                                                                            = 309
	ApplicationDescription_Encoding_DefaultBinary                                                                         = 310
	ApplicationInstanceCertificate                                                                                        = 311
	EndpointDescription                                                                                                   = 312
	EndpointDescription_Encoding_DefaultXML                                                                               = 313
	EndpointDescription_Encoding_DefaultBinary                                                                            = 314
	SecurityTokenRequestType                                                                                              = 315
	UserIdentityToken                                                                                                     = 316
	UserIdentityToken_Encoding_DefaultXML                                                                                 = 317
	UserIdentityToken_Encoding_DefaultBinary                                                                              = 318
	AnonymousIdentityToken                                                                                                = 319
	AnonymousIdentityToken_Encoding_DefaultXML                                                                            = 320
	AnonymousIdentityToken_Encoding_DefaultBinary                                                                         = 321
	UserNameIdentityToken                                                                                                 = 322
	UserNameIdentityToken_Encoding_DefaultXML                                                                             = 323
	UserNameIdentityToken_Encoding_DefaultBinary                                                                          = 324
	X509IdentityToken                                                                                                     = 325
	X509IdentityToken_Encoding_DefaultXML                                                                                 = 326
	X509IdentityToken_Encoding_DefaultBinary                                                                              = 327
	EndpointConfiguration                                                                                                 = 331
	EndpointConfiguration_Encoding_DefaultXML                                                                             = 332
	EndpointConfiguration_Encoding_DefaultBinary                                                                          = 333
	BuildInfo                                                                                                             = 338
	BuildInfo_Encoding_DefaultXML                                                                                         = 339
	BuildInfo_Encoding_DefaultBinary                                                                                      = 340
	SignedSoftwareCertificate                                                                                             = 344
	SignedSoftwareCertificate_Encoding_DefaultXML                                                                         = 345
	SignedSoftwareCertificate_Encoding_DefaultBinary                                                                      = 346
	AttributeWriteMask                                                                                                    = 347
	NodeAttributesMask                                                                                                    = 348
	NodeAttributes                                                                                                        = 349
	NodeAttributes_Encoding_DefaultXML                                                                                    = 350
	NodeAttributes_Encoding_DefaultBinary                                                                                 = 351
	ObjectAttributes                                                                                                      = 352
	ObjectAttributes_Encoding_DefaultXML                                                                                  = 353
	ObjectAttributes_Encoding_DefaultBinary                                                                               = 354
	VariableAttributes                                                                                                    = 355
	VariableAttributes_Encoding_DefaultXML                                                                                = 356
	VariableAttributes_Encoding_DefaultBinary                                                                             = 357
	MethodAttributes                                                                                                      = 358
	MethodAttributes_Encoding_DefaultXML                                                                                  = 359
	MethodAttributes_Encoding_DefaultBinary                                                                               = 360
	ObjectTypeAttributes                                                                                                  = 361
	ObjectTypeAttributes_Encoding_DefaultXML                                                                              = 362
	ObjectTypeAttributes_Encoding_DefaultBinary                                                                           = 363
	VariableTypeAttributes                                                                                                = 364
	VariableTypeAttributes_Encoding_DefaultXML                                                                            = 365
	VariableTypeAttributes_Encoding_DefaultBinary                                                                         = 366
	ReferenceTypeAttributes                                                                                               = 367
	ReferenceTypeAttributes_Encoding_DefaultXML                                                                           = 368
	ReferenceTypeAttributes_Encoding_DefaultBinary                                                                        = 369
	DataTypeAttributes                                                                                                    = 370
	DataTypeAttributes_Encoding_DefaultXML                                                                                = 371
	DataTypeAttributes_Encoding_DefaultBinary                                                                             = 372
	ViewAttributes                                                                                                        = 373
	ViewAttributes_Encoding_DefaultXML                                                                                    = 374
	ViewAttributes_Encoding_DefaultBinary                                                                                 = 375
	AddNodesItem                                                                                                          = 376
	AddNodesItem_Encoding_DefaultXML                                                                                      = 377
	AddNodesItem_Encoding_DefaultBinary                                                                                   = 378
	AddReferencesItem                                                                                                     = 379
	AddReferencesItem_Encoding_DefaultXML                                                                                 = 380
	AddReferencesItem_Encoding_DefaultBinary                                                                              = 381
	DeleteNodesItem                                                                                                       = 382
	DeleteNodesItem_Encoding_DefaultXML                                                                                   = 383
	DeleteNodesItem_Encoding_DefaultBinary                                                                                = 384
	DeleteReferencesItem                                                                                                  = 385
	DeleteReferencesItem_Encoding_DefaultXML                                                                              = 386
	DeleteReferencesItem_Encoding_DefaultBinary                                                                           = 387
	SessionAuthenticationToken                                                                                            = 388
	RequestHeader                                                                                                         = 389
	RequestHeader_Encoding_DefaultXML                                                                                     = 390
	RequestHeader_Encoding_DefaultBinary                                                                                  = 391
	ResponseHeader                                                                                                        = 392
	ResponseHeader_Encoding_DefaultXML                                                                                    = 393
	ResponseHeader_Encoding_DefaultBinary                                                                                 = 394
	ServiceFault                                                                                                          = 395
	ServiceFault_Encoding_DefaultXML                                                                                      = 396
	ServiceFault_Encoding_DefaultBinary                                                                                   = 397
	FindServersRequest                                                                                                    = 420
	FindServersRequest_Encoding_DefaultXML                                                                                = 421
	FindServersRequest_Encoding_DefaultBinary                                                                             = 422
	FindServersResponse                                                                                                   = 423
	FindServersResponse_Encoding_DefaultXML                                                                               = 424
	FindServersResponse_Encoding_DefaultBinary                                                                            = 425
	GetEndpointsRequest                                                                                                   = 426
	GetEndpointsRequest_Encoding_DefaultXML                                                                               = 427
	GetEndpointsRequest_Encoding_DefaultBinary                                                                            = 428
	GetEndpointsResponse                                                                                                  = 429
	GetEndpointsResponse_Encoding_DefaultXML                                                                              = 430
	GetEndpointsResponse_Encoding_DefaultBinary                                                                           = 431
	RegisteredServer                                                                                                      = 432
	RegisteredServer_Encoding_DefaultXML                                                                                  = 433
	RegisteredServer_Encoding_DefaultBinary                                                                               = 434
	RegisterServerRequest                                                                                                 = 435
	RegisterServerRequest_Encoding_DefaultXML                                                                             = 436
	RegisterServerRequest_Encoding_DefaultBinary                                                                          = 437
	RegisterServerResponse                                                                                                = 438
	RegisterServerResponse_Encoding_DefaultXML                                                                            = 439
	RegisterServerResponse_Encoding_DefaultBinary                                                                         = 440
	ChannelSecurityToken                                                                                                  = 441
	ChannelSecurityToken_Encoding_DefaultXML                                                                              = 442
	ChannelSecurityToken_Encoding_DefaultBinary                                                                           = 443
	OpenSecureChannelRequest                                                                                              = 444
	OpenSecureChannelRequest_Encoding_DefaultXML                                                                          = 445
	OpenSecureChannelRequest_Encoding_DefaultBinary                                                                       = 446
	OpenSecureChannelResponse                                                                                             = 447
	OpenSecureChannelResponse_Encoding_DefaultXML                                                                         = 448
	OpenSecureChannelResponse_Encoding_DefaultBinary                                                                      = 449
	CloseSecureChannelRequest                                                                                             = 450
	CloseSecureChannelRequest_Encoding_DefaultXML                                                                         = 451
	CloseSecureChannelRequest_Encoding_DefaultBinary                                                                      = 452
	CloseSecureChannelResponse                                                                                            = 453
	CloseSecureChannelResponse_Encoding_DefaultXML                                                                        = 454
	CloseSecureChannelResponse_Encoding_DefaultBinary                                                                     = 455
	SignatureData                                                                                                         = 456
	SignatureData_Encoding_DefaultXML                                                                                     = 457
	SignatureData_Encoding_DefaultBinary                                                                                  = 458
	CreateSessionRequest                                                                                                  = 459
	CreateSessionRequest_Encoding_DefaultXML                                                                              = 460
	CreateSessionRequest_Encoding_DefaultBinary                                                                           = 461
	CreateSessionResponse                                                                                                 = 462
	CreateSessionResponse_Encoding_DefaultXML                                                                             = 463
	CreateSessionResponse_Encoding_DefaultBinary                                                                          = 464
	ActivateSessionRequest                                                                                                = 465
	ActivateSessionRequest_Encoding_DefaultXML                                                                            = 466
	ActivateSessionRequest_Encoding_DefaultBinary                                                                         = 467
	ActivateSessionResponse                                                                                               = 468
	ActivateSessionResponse_Encoding_DefaultXML                                                                           = 469
	ActivateSessionResponse_Encoding_DefaultBinary                                                                        = 470
	CloseSessionRequest                                                                                                   = 471
	CloseSessionRequest_Encoding_DefaultXML                                                                               = 472
	CloseSessionRequest_Encoding_DefaultBinary                                                                            = 473
	CloseSessionResponse                                                                                                  = 474
	CloseSessionResponse_Encoding_DefaultXML                                                                              = 475
	CloseSessionResponse_Encoding_DefaultBinary                                                                           = 476
	CancelRequest                                                                                                         = 477
	CancelRequest_Encoding_DefaultXML                                                                                     = 478
	CancelRequest_Encoding_DefaultBinary                                                                                  = 479
	CancelResponse                                                                                                        = 480
	CancelResponse_Encoding_DefaultXML                                                                                    = 481
	CancelResponse_Encoding_DefaultBinary                                                                                 = 482
	AddNodesResult                                                                                                        = 483
	AddNodesResult_Encoding_DefaultXML                                                                                    = 484
	AddNodesResult_Encoding_DefaultBinary                                                                                 = 485
	AddNodesRequest                                                                                                       = 486
	AddNodesRequest_Encoding_DefaultXML                                                                                   = 487
	AddNodesRequest_Encoding_DefaultBinary                                                                                = 488
	AddNodesResponse                                                                                                      = 489
	AddNodesResponse_Encoding_DefaultXML                                                                                  = 490
	AddNodesResponse_Encoding_DefaultBinary                                                                               = 491
	AddReferencesRequest                                                                                                  = 492
	AddReferencesRequest_Encoding_DefaultXML                                                                              = 493
	AddReferencesRequest_Encoding_DefaultBinary                                                                           = 494
	AddReferencesResponse                                                                                                 = 495
	AddReferencesResponse_Encoding_DefaultXML                                                                             = 496
	AddReferencesResponse_Encoding_DefaultBinary                                                                          = 497
	DeleteNodesRequest                                                                                                    = 498
	DeleteNodesRequest_Encoding_DefaultXML                                                                                = 499
	DeleteNodesRequest_Encoding_DefaultBinary                                                                             = 500
	DeleteNodesResponse                                                                                                   = 501
	DeleteNodesResponse_Encoding_DefaultXML                                                                               = 502
	DeleteNodesResponse_Encoding_DefaultBinary                                                                            = 503
	DeleteReferencesRequest                                                                                               = 504
	DeleteReferencesRequest_Encoding_DefaultXML                                                                           = 505
	DeleteReferencesRequest_Encoding_DefaultBinary                                                                        = 506
	DeleteReferencesResponse                                                                                              = 507
	DeleteReferencesResponse_Encoding_DefaultXML                                                                          = 508
	DeleteReferencesResponse_Encoding_DefaultBinary                                                                       = 509
	BrowseDirection                                                                                                       = 510
	ViewDescription                                                                                                       = 511
	ViewDescription_Encoding_DefaultXML                                                                                   = 512
	ViewDescription_Encoding_DefaultBinary                                                                                = 513
	BrowseDescription                                                                                                     = 514
	BrowseDescription_Encoding_DefaultXML                                                                                 = 515
	BrowseDescription_Encoding_DefaultBinary                                                                              = 516
	BrowseResultMask                                                                                                      = 517
	ReferenceDescription                                                                                                  = 518
	ReferenceDescription_Encoding_DefaultXML                                                                              = 519
	ReferenceDescription_Encoding_DefaultBinary                                                                           = 520
	ContinuationPoint                                                                                                     = 521
	BrowseResult                                                                                                          = 522
	BrowseResult_Encoding_DefaultXML                                                                                      = 523
	BrowseResult_Encoding_DefaultBinary                                                                                   = 524
	BrowseRequest                                                                                                         = 525
	BrowseRequest_Encoding_DefaultXML                                                                                     = 526
	BrowseRequest_Encoding_DefaultBinary                                                                                  = 527
	BrowseResponse                                                                                                        = 528
	BrowseResponse_Encoding_DefaultXML                                                                                    = 529
	BrowseResponse_Encoding_DefaultBinary                                                                                 = 530
	BrowseNextRequest                                                                                                     = 531
	BrowseNextRequest_Encoding_DefaultXML                                                                                 = 532
	BrowseNextRequest_Encoding_DefaultBinary                                                                              = 533
	BrowseNextResponse                                                                                                    = 534
	BrowseNextResponse_Encoding_DefaultXML                                                                                = 535
	BrowseNextResponse_Encoding_DefaultBinary                                                                             = 536
	RelativePathElement                                                                                                   = 537
	RelativePathElement_Encoding_DefaultXML                                                                               = 538
	RelativePathElement_Encoding_DefaultBinary                                                                            = 539
	RelativePath                                                                                                          = 540
	RelativePath_Encoding_DefaultXML                                                                                      = 541
	RelativePath_Encoding_DefaultBinary                                                                                   = 542
	BrowsePath                                                                                                            = 543
	BrowsePath_Encoding_DefaultXML                                                                                        = 544
	BrowsePath_Encoding_DefaultBinary                                                                                     = 545
	BrowsePathTarget                                                                                                      = 546
	BrowsePathTarget_Encoding_DefaultXML                                                                                  = 547
	BrowsePathTarget_Encoding_DefaultBinary                                                                               = 548
	BrowsePathResult                                                                                                      = 549
	BrowsePathResult_Encoding_DefaultXML                                                                                  = 550
	BrowsePathResult_Encoding_DefaultBinary                                                                               = 551
	TranslateBrowsePathsToNodeIDsRequest                                                                                  = 552
	TranslateBrowsePathsToNodeIDsRequest_Encoding_DefaultXML                                                              = 553
	TranslateBrowsePathsToNodeIDsRequest_Encoding_DefaultBinary                                                           = 554
	TranslateBrowsePathsToNodeIDsResponse                                                                                 = 555
	TranslateBrowsePathsToNodeIDsResponse_Encoding_DefaultXML                                                             = 556
	TranslateBrowsePathsToNodeIDsResponse_Encoding_DefaultBinary                                                          = 557
	RegisterNodesRequest                                                                                                  = 558
	RegisterNodesRequest_Encoding_DefaultXML                                                                              = 559
	RegisterNodesRequest_Encoding_DefaultBinary                                                                           = 560
	RegisterNodesResponse                                                                                                 = 561
	RegisterNodesResponse_Encoding_DefaultXML                                                                             = 562
	RegisterNodesResponse_Encoding_DefaultBinary                                                                          = 563
	UnregisterNodesRequest                                                                                                = 564
	UnregisterNodesRequest_Encoding_DefaultXML                                                                            = 565
	UnregisterNodesRequest_Encoding_DefaultBinary                                                                         = 566
	UnregisterNodesResponse                                                                                               = 567
	UnregisterNodesResponse_Encoding_DefaultXML                                                                           = 568
	UnregisterNodesResponse_Encoding_DefaultBinary                                                                        = 569
	QueryDataDescription                                                                                                  = 570
	QueryDataDescription_Encoding_DefaultXML                                                                              = 571
	QueryDataDescription_Encoding_DefaultBinary                                                                           = 572
	NodeTypeDescription                                                                                                   = 573
	NodeTypeDescription_Encoding_DefaultXML                                                                               = 574
	NodeTypeDescription_Encoding_DefaultBinary                                                                            = 575
	FilterOperator                                                                                                        = 576
	QueryDataSet                                                                                                          = 577
	QueryDataSet_Encoding_DefaultXML                                                                                      = 578
	QueryDataSet_Encoding_DefaultBinary                                                                                   = 579
	NodeReference                                                                                                         = 580
	NodeReference_Encoding_DefaultXML                                                                                     = 581
	NodeReference_Encoding_DefaultBinary                                                                                  = 582
	ContentFilterElement                                                                                                  = 583
	ContentFilterElement_Encoding_DefaultXML                                                                              = 584
	ContentFilterElement_Encoding_DefaultBinary                                                                           = 585
	ContentFilter                                                                                                         = 586
	ContentFilter_Encoding_DefaultXML                                                                                     = 587
	ContentFilter_Encoding_DefaultBinary                                                                                  = 588
	FilterOperand                                                                                                         = 589
	FilterOperand_Encoding_DefaultXML                                                                                     = 590
	FilterOperand_Encoding_DefaultBinary                                                                                  = 591
	ElementOperand                                                                                                        = 592
	ElementOperand_Encoding_DefaultXML                                                                                    = 593
	ElementOperand_Encoding_DefaultBinary                                                                                 = 594
	LiteralOperand                                                                                                        = 595
	LiteralOperand_Encoding_DefaultXML                                                                                    = 596
	LiteralOperand_Encoding_DefaultBinary                                                                                 = 597
	AttributeOperand                                                                                                      = 598
	AttributeOperand_Encoding_DefaultXML                                                                                  = 599
	AttributeOperand_Encoding_DefaultBinary                                                                               = 600
	SimpleAttributeOperand                                                                                                = 601
	SimpleAttributeOperand_Encoding_DefaultXML                                                                            = 602
	SimpleAttributeOperand_Encoding_DefaultBinary                                                                         = 603
	ContentFilterElementResult                                                                                            = 604
	ContentFilterElementResult_Encoding_DefaultXML                                                                        = 605
	ContentFilterElementResult_Encoding_DefaultBinary                                                                     = 606
	ContentFilterResult                                                                                                   = 607
	ContentFilterResult_Encoding_DefaultXML                                                                               = 608
	ContentFilterResult_Encoding_DefaultBinary                                                                            = 609
	ParsingResult                                                                                                         = 610
	ParsingResult_Encoding_DefaultXML                                                                                     = 611
	ParsingResult_Encoding_DefaultBinary                                                                                  = 612
	QueryFirstRequest                                                                                                     = 613
	QueryFirstRequest_Encoding_DefaultXML                                                                                 = 614
	QueryFirstRequest_Encoding_DefaultBinary                                                                              = 615
	QueryFirstResponse                                                                                                    = 616
	QueryFirstResponse_Encoding_DefaultXML                                                                                = 617
	QueryFirstResponse_Encoding_DefaultBinary                                                                             = 618
	QueryNextRequest                                                                                                      = 619
	QueryNextRequest_Encoding_DefaultXML                                                                                  = 620
	QueryNextRequest_Encoding_DefaultBinary                                                                               = 621
	QueryNextResponse                                                                                                     = 622
	QueryNextResponse_Encoding_DefaultXML                                                                                 = 623
	QueryNextResponse_Encoding_DefaultBinary                                                                              = 624
	TimestampsToReturn                                                                                                    = 625
	ReadValueID                                                                                                           = 626
	ReadValueID_Encoding_DefaultXML                                                                                       = 627
	ReadValueID_Encoding_DefaultBinary                                                                                    = 628
	ReadRequest                                                                                                           = 629
	ReadRequest_Encoding_DefaultXML                                                                                       = 630
	ReadRequest_Encoding_DefaultBinary                                                                                    = 631
	ReadResponse                                                                                                          = 632
	ReadResponse_Encoding_DefaultXML                                                                                      = 633
	ReadResponse_Encoding_DefaultBinary                                                                                   = 634
	HistoryReadValueID                                                                                                    = 635
	HistoryReadValueID_Encoding_DefaultXML                                                                                = 636
	HistoryReadValueID_Encoding_DefaultBinary                                                                             = 637
	HistoryReadResult                                                                                                     = 638
	HistoryReadResult_Encoding_DefaultXML                                                                                 = 639
	HistoryReadResult_Encoding_DefaultBinary                                                                              = 640
	HistoryReadDetails                                                                                                    = 641
	HistoryReadDetails_Encoding_DefaultXML                                                                                = 642
	HistoryReadDetails_Encoding_DefaultBinary                                                                             = 643
	ReadEventDetails                                                                                                      = 644
	ReadEventDetails_Encoding_DefaultXML                                                                                  = 645
	ReadEventDetails_Encoding_DefaultBinary                                                                               = 646
	ReadRawModifiedDetails                                                                                                = 647
	ReadRawModifiedDetails_Encoding_DefaultXML                                                                            = 648
	ReadRawModifiedDetails_Encoding_DefaultBinary                                                                         = 649
	ReadProcessedDetails                                                                                                  = 650
	ReadProcessedDetails_Encoding_DefaultXML                                                                              = 651
	ReadProcessedDetails_Encoding_DefaultBinary                                                                           = 652
	ReadAtTimeDetails                                                                                                     = 653
	ReadAtTimeDetails_Encoding_DefaultXML                                                                                 = 654
	ReadAtTimeDetails_Encoding_DefaultBinary                                                                              = 655
	HistoryData                                                                                                           = 656
	HistoryData_Encoding_DefaultXML                                                                                       = 657
	HistoryData_Encoding_DefaultBinary                                                                                    = 658
	HistoryEvent                                                                                                          = 659
	HistoryEvent_Encoding_DefaultXML                                                                                      = 660
	HistoryEvent_Encoding_DefaultBinary                                                                                   = 661
	HistoryReadRequest                                                                                                    = 662
	HistoryReadRequest_Encoding_DefaultXML                                                                                = 663
	HistoryReadRequest_Encoding_DefaultBinary                                                                             = 664
	HistoryReadResponse                                                                                                   = 665
	HistoryReadResponse_Encoding_DefaultXML                                                                               = 666
	HistoryReadResponse_Encoding_DefaultBinary                                                                            = 667
	WriteValue                                                                                                            = 668
	WriteValue_Encoding_DefaultXML                                                                                        = 669
	WriteValue_Encoding_DefaultBinary                                                                                     = 670
	WriteRequest                                                                                                          = 671
	WriteRequest_Encoding_DefaultXML                                                                                      = 672
	WriteRequest_Encoding_DefaultBinary                                                                                   = 673
	WriteResponse                                                                                                         = 674
	WriteResponse_Encoding_DefaultXML                                                                                     = 675
	WriteResponse_Encoding_DefaultBinary                                                                                  = 676
	HistoryUpdateDetails                                                                                                  = 677
	HistoryUpdateDetails_Encoding_DefaultXML                                                                              = 678
	HistoryUpdateDetails_Encoding_DefaultBinary                                                                           = 679
	UpdateDataDetails                                                                                                     = 680
	UpdateDataDetails_Encoding_DefaultXML                                                                                 = 681
	UpdateDataDetails_Encoding_DefaultBinary                                                                              = 682
	UpdateEventDetails                                                                                                    = 683
	UpdateEventDetails_Encoding_DefaultXML                                                                                = 684
	UpdateEventDetails_Encoding_DefaultBinary                                                                             = 685
	DeleteRawModifiedDetails                                                                                              = 686
	DeleteRawModifiedDetails_Encoding_DefaultXML                                                                          = 687
	DeleteRawModifiedDetails_Encoding_DefaultBinary                                                                       = 688
	DeleteAtTimeDetails                                                                                                   = 689
	DeleteAtTimeDetails_Encoding_DefaultXML                                                                               = 690
	DeleteAtTimeDetails_Encoding_DefaultBinary                                                                            = 691
	DeleteEventDetails                                                                                                    = 692
	DeleteEventDetails_Encoding_DefaultXML                                                                                = 693
	DeleteEventDetails_Encoding_DefaultBinary                                                                             = 694
	HistoryUpdateResult                                                                                                   = 695
	HistoryUpdateResult_Encoding_DefaultXML                                                                               = 696
	HistoryUpdateResult_Encoding_DefaultBinary                                                                            = 697
	HistoryUpdateRequest                                                                                                  = 698
	HistoryUpdateRequest_Encoding_DefaultXML                                                                              = 699
	HistoryUpdateRequest_Encoding_DefaultBinary                                                                           = 700
	HistoryUpdateResponse                                                                                                 = 701
	HistoryUpdateResponse_Encoding_DefaultXML                                                                             = 702
	HistoryUpdateResponse_Encoding_DefaultBinary                                                                          = 703
	CallMethodRequest                                                                                                     = 704
	CallMethodRequest_Encoding_DefaultXML                                                                                 = 705
	CallMethodRequest_Encoding_DefaultBinary                                                                              = 706
	CallMethodResult                                                                                                      = 707
	CallMethodResult_Encoding_DefaultXML                                                                                  = 708
	CallMethodResult_Encoding_DefaultBinary                                                                               = 709
	CallRequest                                                                                                           = 710
	CallRequest_Encoding_DefaultXML                                                                                       = 711
	CallRequest_Encoding_DefaultBinary                                                                                    = 712
	CallResponse                                                                                                          = 713
	CallResponse_Encoding_DefaultXML                                                                                      = 714
	CallResponse_Encoding_DefaultBinary                                                                                   = 715
	MonitoringMode                                                                                                        = 716
	DataChangeTrigger                                                                                                     = 717
	DeadbandType                                                                                                          = 718
	MonitoringFilter                                                                                                      = 719
	MonitoringFilter_Encoding_DefaultXML                                                                                  = 720
	MonitoringFilter_Encoding_DefaultBinary                                                                               = 721
	DataChangeFilter                                                                                                      = 722
	DataChangeFilter_Encoding_DefaultXML                                                                                  = 723
	DataChangeFilter_Encoding_DefaultBinary                                                                               = 724
	EventFilter                                                                                                           = 725
	EventFilter_Encoding_DefaultXML                                                                                       = 726
	EventFilter_Encoding_DefaultBinary                                                                                    = 727
	AggregateFilter                                                                                                       = 728
	AggregateFilter_Encoding_DefaultXML                                                                                   = 729
	AggregateFilter_Encoding_DefaultBinary                                                                                = 730
	MonitoringFilterResult                                                                                                = 731
	MonitoringFilterResult_Encoding_DefaultXML                                                                            = 732
	MonitoringFilterResult_Encoding_DefaultBinary                                                                         = 733
	EventFilterResult                                                                                                     = 734
	EventFilterResult_Encoding_DefaultXML                                                                                 = 735
	EventFilterResult_Encoding_DefaultBinary                                                                              = 736
	AggregateFilterResult                                                                                                 = 737
	AggregateFilterResult_Encoding_DefaultXML                                                                             = 738
	AggregateFilterResult_Encoding_DefaultBinary                                                                          = 739
	MonitoringParameters                                                                                                  = 740
	MonitoringParameters_Encoding_DefaultXML                                                                              = 741
	MonitoringParameters_Encoding_DefaultBinary                                                                           = 742
	MonitoredItemCreateRequest                                                                                            = 743
	MonitoredItemCreateRequest_Encoding_DefaultXML                                                                        = 744
	MonitoredItemCreateRequest_Encoding_DefaultBinary                                                                     = 745
	MonitoredItemCreateResult                                                                                             = 746
	MonitoredItemCreateResult_Encoding_DefaultXML                                                                         = 747
	MonitoredItemCreateResult_Encoding_DefaultBinary                                                                      = 748
	CreateMonitoredItemsRequest                                                                                           = 749
	CreateMonitoredItemsRequest_Encoding_DefaultXML                                                                       = 750
	CreateMonitoredItemsRequest_Encoding_DefaultBinary                                                                    = 751
	CreateMonitoredItemsResponse                                                                                          = 752
	CreateMonitoredItemsResponse_Encoding_DefaultXML                                                                      = 753
	CreateMonitoredItemsResponse_Encoding_DefaultBinary                                                                   = 754
	MonitoredItemModifyRequest                                                                                            = 755
	MonitoredItemModifyRequest_Encoding_DefaultXML                                                                        = 756
	MonitoredItemModifyRequest_Encoding_DefaultBinary                                                                     = 757
	MonitoredItemModifyResult                                                                                             = 758
	MonitoredItemModifyResult_Encoding_DefaultXML                                                                         = 759
	MonitoredItemModifyResult_Encoding_DefaultBinary                                                                      = 760
	ModifyMonitoredItemsRequest                                                                                           = 761
	ModifyMonitoredItemsRequest_Encoding_DefaultXML                                                                       = 762
	ModifyMonitoredItemsRequest_Encoding_DefaultBinary                                                                    = 763
	ModifyMonitoredItemsResponse                                                                                          = 764
	ModifyMonitoredItemsResponse_Encoding_DefaultXML                                                                      = 765
	ModifyMonitoredItemsResponse_Encoding_DefaultBinary                                                                   = 766
	SetMonitoringModeRequest                                                                                              = 767
	SetMonitoringModeRequest_Encoding_DefaultXML                                                                          = 768
	SetMonitoringModeRequest_Encoding_DefaultBinary                                                                       = 769
	SetMonitoringModeResponse                                                                                             = 770
	SetMonitoringModeResponse_Encoding_DefaultXML                                                                         = 771
	SetMonitoringModeResponse_Encoding_DefaultBinary                                                                      = 772
	SetTriggeringRequest                                                                                                  = 773
	SetTriggeringRequest_Encoding_DefaultXML                                                                              = 774
	SetTriggeringRequest_Encoding_DefaultBinary                                                                           = 775
	SetTriggeringResponse                                                                                                 = 776
	SetTriggeringResponse_Encoding_DefaultXML                                                                             = 777
	SetTriggeringResponse_Encoding_DefaultBinary                                                                          = 778
	DeleteMonitoredItemsRequest                                                                                           = 779
	DeleteMonitoredItemsRequest_Encoding_DefaultXML                                                                       = 780
	DeleteMonitoredItemsRequest_Encoding_DefaultBinary                                                                    = 781
	DeleteMonitoredItemsResponse                                                                                          = 782
	DeleteMonitoredItemsResponse_Encoding_DefaultXML                                                                      = 783
	DeleteMonitoredItemsResponse_Encoding_DefaultBinary                                                                   = 784
	CreateSubscriptionRequest                                                                                             = 785
	CreateSubscriptionRequest_Encoding_DefaultXML                                                                         = 786
	CreateSubscriptionRequest_Encoding_DefaultBinary                                                                      = 787
	CreateSubscriptionResponse                                                                                            = 788
	CreateSubscriptionResponse_Encoding_DefaultXML                                                                        = 789
	CreateSubscriptionResponse_Encoding_DefaultBinary                                                                     = 790
	ModifySubscriptionRequest                                                                                             = 791
	ModifySubscriptionRequest_Encoding_DefaultXML                                                                         = 792
	ModifySubscriptionRequest_Encoding_DefaultBinary                                                                      = 793
	ModifySubscriptionResponse                                                                                            = 794
	ModifySubscriptionResponse_Encoding_DefaultXML                                                                        = 795
	ModifySubscriptionResponse_Encoding_DefaultBinary                                                                     = 796
	SetPublishingModeRequest                                                                                              = 797
	SetPublishingModeRequest_Encoding_DefaultXML                                                                          = 798
	SetPublishingModeRequest_Encoding_DefaultBinary                                                                       = 799
	SetPublishingModeResponse                                                                                             = 800
	SetPublishingModeResponse_Encoding_DefaultXML                                                                         = 801
	SetPublishingModeResponse_Encoding_DefaultBinary                                                                      = 802
	NotificationMessage                                                                                                   = 803
	NotificationMessage_Encoding_DefaultXML                                                                               = 804
	NotificationMessage_Encoding_DefaultBinary                                                                            = 805
	MonitoredItemNotification                                                                                             = 806
	MonitoredItemNotification_Encoding_DefaultXML                                                                         = 807
	MonitoredItemNotification_Encoding_DefaultBinary                                                                      = 808
	DataChangeNotification                                                                                                = 809
	DataChangeNotification_Encoding_DefaultXML                                                                            = 810
	DataChangeNotification_Encoding_DefaultBinary                                                                         = 811
	StatusChangeNotification                                                                                              = 818
	StatusChangeNotification_Encoding_DefaultXML                                                                          = 819
	StatusChangeNotification_Encoding_DefaultBinary                                                                       = 820
	SubscriptionAcknowledgement                                                                                           = 821
	SubscriptionAcknowledgement_Encoding_DefaultXML                                                                       = 822
	SubscriptionAcknowledgement_Encoding_DefaultBinary                                                                    = 823
	PublishRequest                                                                                                        = 824
	PublishRequest_Encoding_DefaultXML                                                                                    = 825
	PublishRequest_Encoding_DefaultBinary                                                                                 = 826
	PublishResponse                                                                                                       = 827
	PublishResponse_Encoding_DefaultXML                                                                                   = 828
	PublishResponse_Encoding_DefaultBinary                                                                                = 829
	RepublishRequest                                                                                                      = 830
	RepublishRequest_Encoding_DefaultXML                                                                                  = 831
	RepublishRequest_Encoding_DefaultBinary                                                                               = 832
	RepublishResponse                                                                                                     = 833
	RepublishResponse_Encoding_DefaultXML                                                                                 = 834
	RepublishResponse_Encoding_DefaultBinary                                                                              = 835
	TransferResult                                                                                                        = 836
	TransferResult_Encoding_DefaultXML                                                                                    = 837
	TransferResult_Encoding_DefaultBinary                                                                                 = 838
	TransferSubscriptionsRequest                                                                                          = 839
	TransferSubscriptionsRequest_Encoding_DefaultXML                                                                      = 840
	TransferSubscriptionsRequest_Encoding_DefaultBinary                                                                   = 841
	TransferSubscriptionsResponse                                                                                         = 842
	TransferSubscriptionsResponse_Encoding_DefaultXML                                                                     = 843
	TransferSubscriptionsResponse_Encoding_DefaultBinary                                                                  = 844
	DeleteSubscriptionsRequest                                                                                            = 845
	DeleteSubscriptionsRequest_Encoding_DefaultXML                                                                        = 846
	DeleteSubscriptionsRequest_Encoding_DefaultBinary                                                                     = 847
	DeleteSubscriptionsResponse                                                                                           = 848
	DeleteSubscriptionsResponse_Encoding_DefaultXML                                                                       = 849
	DeleteSubscriptionsResponse_Encoding_DefaultBinary                                                                    = 850
	RedundancySupport                                                                                                     = 851
	ServerState                                                                                                           = 852
	RedundantServerDataType                                                                                               = 853
	RedundantServerDataType_Encoding_DefaultXML                                                                           = 854
	RedundantServerDataType_Encoding_DefaultBinary                                                                        = 855
	SamplingIntervalDiagnosticsDataType                                                                                   = 856
	SamplingIntervalDiagnosticsDataType_Encoding_DefaultXML                                                               = 857
	SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary                                                            = 858
	ServerDiagnosticsSummaryDataType                                                                                      = 859
	ServerDiagnosticsSummaryDataType_Encoding_DefaultXML                                                                  = 860
	ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary                                                               = 861
	ServerStatusDataType                                                                                                  = 862
	ServerStatusDataType_Encoding_DefaultXML                                                                              = 863
	ServerStatusDataType_Encoding_DefaultBinary                                                                           = 864
	SessionDiagnosticsDataType                                                                                            = 865
	SessionDiagnosticsDataType_Encoding_DefaultXML                                                                        = 866
	SessionDiagnosticsDataType_Encoding_DefaultBinary                                                                     = 867
	SessionSecurityDiagnosticsDataType                                                                                    = 868
	SessionSecurityDiagnosticsDataType_Encoding_DefaultXML                                                                = 869
	SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary                                                             = 870
	ServiceCounterDataType                                                                                                = 871
	ServiceCounterDataType_Encoding_DefaultXML                                                                            = 872
	ServiceCounterDataType_Encoding_DefaultBinary                                                                         = 873
	SubscriptionDiagnosticsDataType                                                                                       = 874
	SubscriptionDiagnosticsDataType_Encoding_DefaultXML                                                                   = 875
	SubscriptionDiagnosticsDataType_Encoding_DefaultBinary                                                                = 876
	ModelChangeStructureDataType                                                                                          = 877
	ModelChangeStructureDataType_Encoding_DefaultXML                                                                      = 878
	ModelChangeStructureDataType_Encoding_DefaultBinary                                                                   = 879
	Range                                                                                                                 = 884
	Range_Encoding_DefaultXML                                                                                             = 885
	Range_Encoding_DefaultBinary                                                                                          = 886
	EUInformation                                                                                                         = 887
	EUInformation_Encoding_DefaultXML                                                                                     = 888
	EUInformation_Encoding_DefaultBinary                                                                                  = 889
	ExceptionDeviationFormat                                                                                              = 890
	Annotation                                                                                                            = 891
	Annotation_Encoding_DefaultXML                                                                                        = 892
	Annotation_Encoding_DefaultBinary                                                                                     = 893
	ProgramDiagnosticDataType                                                                                             = 894
	ProgramDiagnosticDataType_Encoding_DefaultXML                                                                         = 895
	ProgramDiagnosticDataType_Encoding_DefaultBinary                                                                      = 896
	SemanticChangeStructureDataType                                                                                       = 897
	SemanticChangeStructureDataType_Encoding_DefaultXML                                                                   = 898
	SemanticChangeStructureDataType_Encoding_DefaultBinary                                                                = 899
	EventNotificationList                                                                                                 = 914
	EventNotificationList_Encoding_DefaultXML                                                                             = 915
	EventNotificationList_Encoding_DefaultBinary                                                                          = 916
	EventFieldList                                                                                                        = 917
	EventFieldList_Encoding_DefaultXML                                                                                    = 918
	EventFieldList_Encoding_DefaultBinary                                                                                 = 919
	HistoryEventFieldList                                                                                                 = 920
	HistoryEventFieldList_Encoding_DefaultXML                                                                             = 921
	HistoryEventFieldList_Encoding_DefaultBinary                                                                          = 922
	IssuedIdentityToken                                                                                                   = 938
	IssuedIdentityToken_Encoding_DefaultXML                                                                               = 939
	IssuedIdentityToken_Encoding_DefaultBinary                                                                            = 940
	NotificationData                                                                                                      = 945
	NotificationData_Encoding_DefaultXML                                                                                  = 946
	NotificationData_Encoding_DefaultBinary                                                                               = 947
	AggregateConfiguration                                                                                                = 948
	AggregateConfiguration_Encoding_DefaultXML                                                                            = 949
	AggregateConfiguration_Encoding_DefaultBinary                                                                         = 950
	ImageBMP                                                                                                              = 2000
	ImageGIF                                                                                                              = 2001
	ImageJPG                                                                                                              = 2002
	ImagePNG                                                                                                              = 2003
	ServerType                                                                                                            = 2004
	ServerType_ServerArray                                                                                                = 2005
	ServerType_NamespaceArray                                                                                             = 2006
	ServerType_ServerStatus                                                                                               = 2007
	ServerType_ServiceLevel                                                                                               = 2008
	ServerType_ServerCapabilities                                                                                         = 2009
	ServerType_ServerDiagnostics                                                                                          = 2010
	ServerType_VendorServerInfo                                                                                           = 2011
	ServerType_ServerRedundancy                                                                                           = 2012
	ServerCapabilitiesType                                                                                                = 2013
	ServerCapabilitiesType_ServerProfileArray                                                                             = 2014
	ServerCapabilitiesType_LocaleIDArray                                                                                  = 2016
	ServerCapabilitiesType_MinSupportedSampleRate                                                                         = 2017
	ServerCapabilitiesType_ModellingRules                                                                                 = 2019
	ServerDiagnosticsType                                                                                                 = 2020
	ServerDiagnosticsType_ServerDiagnosticsSummary                                                                        = 2021
	ServerDiagnosticsType_SamplingIntervalDiagnosticsArray                                                                = 2022
	ServerDiagnosticsType_SubscriptionDiagnosticsArray                                                                    = 2023
	ServerDiagnosticsType_EnabledFlag                                                                                     = 2025
	SessionsDiagnosticsSummaryType                                                                                        = 2026
	SessionsDiagnosticsSummaryType_SessionDiagnosticsArray                                                                = 2027
	SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray                                                        = 2028
	SessionDiagnosticsObjectType                                                                                          = 2029
	SessionDiagnosticsObjectType_SessionDiagnostics                                                                       = 2030
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics                                                               = 2031
	SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray                                                             = 2032
	VendorServerInfoType                                                                                                  = 2033
	ServerRedundancyType                                                                                                  = 2034
	ServerRedundancyType_RedundancySupport                                                                                = 2035
	TransparentRedundancyType                                                                                             = 2036
	TransparentRedundancyType_CurrentServerID                                                                             = 2037
	TransparentRedundancyType_RedundantServerArray                                                                        = 2038
	NonTransparentRedundancyType                                                                                          = 2039
	NonTransparentRedundancyType_ServerURIArray                                                                           = 2040
	BaseEventType                                                                                                         = 2041
	BaseEventType_EventID                                                                                                 = 2042
	BaseEventType_EventType                                                                                               = 2043
	BaseEventType_SourceNode                                                                                              = 2044
	BaseEventType_SourceName                                                                                              = 2045
	BaseEventType_Time                                                                                                    = 2046
	BaseEventType_ReceiveTime                                                                                             = 2047
	BaseEventType_Message                                                                                                 = 2050
	BaseEventType_Severity                                                                                                = 2051
	AuditEventType                                                                                                        = 2052
	AuditEventType_ActionTimeStamp                                                                                        = 2053
	AuditEventType_Status                                                                                                 = 2054
	AuditEventType_ServerID                                                                                               = 2055
	AuditEventType_ClientAuditEntryID                                                                                     = 2056
	AuditEventType_ClientUserID                                                                                           = 2057
	AuditSecurityEventType                                                                                                = 2058
	AuditChannelEventType                                                                                                 = 2059
	AuditOpenSecureChannelEventType                                                                                       = 2060
	AuditOpenSecureChannelEventType_ClientCertificate                                                                     = 2061
	AuditOpenSecureChannelEventType_RequestType                                                                           = 2062
	AuditOpenSecureChannelEventType_SecurityPolicyURI                                                                     = 2063
	AuditOpenSecureChannelEventType_SecurityMode                                                                          = 2065
	AuditOpenSecureChannelEventType_RequestedLifetime                                                                     = 2066
	AuditSessionEventType                                                                                                 = 2069
	AuditSessionEventType_SessionID                                                                                       = 2070
	AuditCreateSessionEventType                                                                                           = 2071
	AuditCreateSessionEventType_SecureChannelID                                                                           = 2072
	AuditCreateSessionEventType_ClientCertificate                                                                         = 2073
	AuditCreateSessionEventType_RevisedSessionTimeout                                                                     = 2074
	AuditActivateSessionEventType                                                                                         = 2075
	AuditActivateSessionEventType_ClientSoftwareCertificates                                                              = 2076
	AuditActivateSessionEventType_UserIdentityToken                                                                       = 2077
	AuditCancelEventType                                                                                                  = 2078
	AuditCancelEventType_RequestHandle                                                                                    = 2079
	AuditCertificateEventType                                                                                             = 2080
	AuditCertificateEventType_Certificate                                                                                 = 2081
	AuditCertificateDataMismatchEventType                                                                                 = 2082
	AuditCertificateDataMismatchEventType_InvalidHostname                                                                 = 2083
	AuditCertificateDataMismatchEventType_InvalidURI                                                                      = 2084
	AuditCertificateExpiredEventType                                                                                      = 2085
	AuditCertificateInvalidEventType                                                                                      = 2086
	AuditCertificateUntrustedEventType                                                                                    = 2087
	AuditCertificateRevokedEventType                                                                                      = 2088
	AuditCertificateMismatchEventType                                                                                     = 2089
	AuditNodeManagementEventType                                                                                          = 2090
	AuditAddNodesEventType                                                                                                = 2091
	AuditAddNodesEventType_NodesToAdd                                                                                     = 2092
	AuditDeleteNodesEventType                                                                                             = 2093
	AuditDeleteNodesEventType_NodesToDelete                                                                               = 2094
	AuditAddReferencesEventType                                                                                           = 2095
	AuditAddReferencesEventType_ReferencesToAdd                                                                           = 2096
	AuditDeleteReferencesEventType                                                                                        = 2097
	AuditDeleteReferencesEventType_ReferencesToDelete                                                                     = 2098
	AuditUpdateEventType                                                                                                  = 2099
	AuditWriteUpdateEventType                                                                                             = 2100
	AuditWriteUpdateEventType_IndexRange                                                                                  = 2101
	AuditWriteUpdateEventType_OldValue                                                                                    = 2102
	AuditWriteUpdateEventType_NewValue                                                                                    = 2103
	AuditHistoryUpdateEventType                                                                                           = 2104
	AuditUpdateMethodEventType                                                                                            = 2127
	AuditUpdateMethodEventType_MethodID                                                                                   = 2128
	AuditUpdateMethodEventType_InputArguments                                                                             = 2129
	SystemEventType                                                                                                       = 2130
	DeviceFailureEventType                                                                                                = 2131
	BaseModelChangeEventType                                                                                              = 2132
	GeneralModelChangeEventType                                                                                           = 2133
	GeneralModelChangeEventType_Changes                                                                                   = 2134
	ServerVendorCapabilityType                                                                                            = 2137
	ServerStatusType                                                                                                      = 2138
	ServerStatusType_StartTime                                                                                            = 2139
	ServerStatusType_CurrentTime                                                                                          = 2140
	ServerStatusType_State                                                                                                = 2141
	ServerStatusType_BuildInfo                                                                                            = 2142
	ServerDiagnosticsSummaryType                                                                                          = 2150
	ServerDiagnosticsSummaryType_ServerViewCount                                                                          = 2151
	ServerDiagnosticsSummaryType_CurrentSessionCount                                                                      = 2152
	ServerDiagnosticsSummaryType_CumulatedSessionCount                                                                    = 2153
	ServerDiagnosticsSummaryType_SecurityRejectedSessionCount                                                             = 2154
	ServerDiagnosticsSummaryType_RejectedSessionCount                                                                     = 2155
	ServerDiagnosticsSummaryType_SessionTimeoutCount                                                                      = 2156
	ServerDiagnosticsSummaryType_SessionAbortCount                                                                        = 2157
	ServerDiagnosticsSummaryType_PublishingIntervalCount                                                                  = 2159
	ServerDiagnosticsSummaryType_CurrentSubscriptionCount                                                                 = 2160
	ServerDiagnosticsSummaryType_CumulatedSubscriptionCount                                                               = 2161
	ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount                                                            = 2162
	ServerDiagnosticsSummaryType_RejectedRequestsCount                                                                    = 2163
	SamplingIntervalDiagnosticsArrayType                                                                                  = 2164
	SamplingIntervalDiagnosticsType                                                                                       = 2165
	SamplingIntervalDiagnosticsType_SamplingInterval                                                                      = 2166
	SubscriptionDiagnosticsArrayType                                                                                      = 2171
	SubscriptionDiagnosticsType                                                                                           = 2172
	SubscriptionDiagnosticsType_SessionID                                                                                 = 2173
	SubscriptionDiagnosticsType_SubscriptionID                                                                            = 2174
	SubscriptionDiagnosticsType_Priority                                                                                  = 2175
	SubscriptionDiagnosticsType_PublishingInterval                                                                        = 2176
	SubscriptionDiagnosticsType_MaxKeepAliveCount                                                                         = 2177
	SubscriptionDiagnosticsType_MaxNotificationsPerPublish                                                                = 2179
	SubscriptionDiagnosticsType_PublishingEnabled                                                                         = 2180
	SubscriptionDiagnosticsType_ModifyCount                                                                               = 2181
	SubscriptionDiagnosticsType_EnableCount                                                                               = 2182
	SubscriptionDiagnosticsType_DisableCount                                                                              = 2183
	SubscriptionDiagnosticsType_RepublishRequestCount                                                                     = 2184
	SubscriptionDiagnosticsType_RepublishMessageRequestCount                                                              = 2185
	SubscriptionDiagnosticsType_RepublishMessageCount                                                                     = 2186
	SubscriptionDiagnosticsType_TransferRequestCount                                                                      = 2187
	SubscriptionDiagnosticsType_TransferredToAltClientCount                                                               = 2188
	SubscriptionDiagnosticsType_TransferredToSameClientCount                                                              = 2189
	SubscriptionDiagnosticsType_PublishRequestCount                                                                       = 2190
	SubscriptionDiagnosticsType_DataChangeNotificationsCount                                                              = 2191
	SubscriptionDiagnosticsType_NotificationsCount                                                                        = 2193
	SessionDiagnosticsArrayType                                                                                           = 2196
	SessionDiagnosticsVariableType                                                                                        = 2197
	SessionDiagnosticsVariableType_SessionID                                                                              = 2198
	SessionDiagnosticsVariableType_SessionName                                                                            = 2199
	SessionDiagnosticsVariableType_ClientDescription                                                                      = 2200
	SessionDiagnosticsVariableType_ServerURI                                                                              = 2201
	SessionDiagnosticsVariableType_EndpointURL                                                                            = 2202
	SessionDiagnosticsVariableType_LocaleIDs                                                                              = 2203
	SessionDiagnosticsVariableType_ActualSessionTimeout                                                                   = 2204
	SessionDiagnosticsVariableType_ClientConnectionTime                                                                   = 2205
	SessionDiagnosticsVariableType_ClientLastContactTime                                                                  = 2206
	SessionDiagnosticsVariableType_CurrentSubscriptionsCount                                                              = 2207
	SessionDiagnosticsVariableType_CurrentMonitoredItemsCount                                                             = 2208
	SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue                                                          = 2209
	SessionDiagnosticsVariableType_ReadCount                                                                              = 2217
	SessionDiagnosticsVariableType_HistoryReadCount                                                                       = 2218
	SessionDiagnosticsVariableType_WriteCount                                                                             = 2219
	SessionDiagnosticsVariableType_HistoryUpdateCount                                                                     = 2220
	SessionDiagnosticsVariableType_CallCount                                                                              = 2221
	SessionDiagnosticsVariableType_CreateMonitoredItemsCount                                                              = 2222
	SessionDiagnosticsVariableType_ModifyMonitoredItemsCount                                                              = 2223
	SessionDiagnosticsVariableType_SetMonitoringModeCount                                                                 = 2224
	SessionDiagnosticsVariableType_SetTriggeringCount                                                                     = 2225
	SessionDiagnosticsVariableType_DeleteMonitoredItemsCount                                                              = 2226
	SessionDiagnosticsVariableType_CreateSubscriptionCount                                                                = 2227
	SessionDiagnosticsVariableType_ModifySubscriptionCount                                                                = 2228
	SessionDiagnosticsVariableType_SetPublishingModeCount                                                                 = 2229
	SessionDiagnosticsVariableType_PublishCount                                                                           = 2230
	SessionDiagnosticsVariableType_RepublishCount                                                                         = 2231
	SessionDiagnosticsVariableType_TransferSubscriptionsCount                                                             = 2232
	SessionDiagnosticsVariableType_DeleteSubscriptionsCount                                                               = 2233
	SessionDiagnosticsVariableType_AddNodesCount                                                                          = 2234
	SessionDiagnosticsVariableType_AddReferencesCount                                                                     = 2235
	SessionDiagnosticsVariableType_DeleteNodesCount                                                                       = 2236
	SessionDiagnosticsVariableType_DeleteReferencesCount                                                                  = 2237
	SessionDiagnosticsVariableType_BrowseCount                                                                            = 2238
	SessionDiagnosticsVariableType_BrowseNextCount                                                                        = 2239
	SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIDsCount                                                     = 2240
	SessionDiagnosticsVariableType_QueryFirstCount                                                                        = 2241
	SessionDiagnosticsVariableType_QueryNextCount                                                                         = 2242
	SessionSecurityDiagnosticsArrayType                                                                                   = 2243
	SessionSecurityDiagnosticsType                                                                                        = 2244
	SessionSecurityDiagnosticsType_SessionID                                                                              = 2245
	SessionSecurityDiagnosticsType_ClientUserIDOfSession                                                                  = 2246
	SessionSecurityDiagnosticsType_ClientUserIDHistory                                                                    = 2247
	SessionSecurityDiagnosticsType_AuthenticationMechanism                                                                = 2248
	SessionSecurityDiagnosticsType_Encoding                                                                               = 2249
	SessionSecurityDiagnosticsType_TransportProtocol                                                                      = 2250
	SessionSecurityDiagnosticsType_SecurityMode                                                                           = 2251
	SessionSecurityDiagnosticsType_SecurityPolicyURI                                                                      = 2252
	Server                                                                                                                = 2253
	Server_ServerArray                                                                                                    = 2254
	Server_NamespaceArray                                                                                                 = 2255
	Server_ServerStatus                                                                                                   = 2256
	Server_ServerStatus_StartTime                                                                                         = 2257
	Server_ServerStatus_CurrentTime                                                                                       = 2258
	Server_ServerStatus_State                                                                                             = 2259
	Server_ServerStatus_BuildInfo                                                                                         = 2260
	Server_ServerStatus_BuildInfo_ProductName                                                                             = 2261
	Server_ServerStatus_BuildInfo_ProductURI                                                                              = 2262
	Server_ServerStatus_BuildInfo_ManufacturerName                                                                        = 2263
	Server_ServerStatus_BuildInfo_SoftwareVersion                                                                         = 2264
	Server_ServerStatus_BuildInfo_BuildNumber                                                                             = 2265
	Server_ServerStatus_BuildInfo_BuildDate                                                                               = 2266
	Server_ServiceLevel                                                                                                   = 2267
	Server_ServerCapabilities                                                                                             = 2268
	Server_ServerCapabilities_ServerProfileArray                                                                          = 2269
	Server_ServerCapabilities_LocaleIDArray                                                                               = 2271
	Server_ServerCapabilities_MinSupportedSampleRate                                                                      = 2272
	Server_ServerDiagnostics                                                                                              = 2274
	Server_ServerDiagnostics_ServerDiagnosticsSummary                                                                     = 2275
	Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount                                                     = 2276
	Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount                                                 = 2277
	Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount                                               = 2278
	Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount                                        = 2279
	Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount                                                 = 2281
	Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount                                                   = 2282
	Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount                                             = 2284
	Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount                                            = 2285
	Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount                                          = 2286
	Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount                                       = 2287
	Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount                                               = 2288
	Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray                                                             = 2289
	Server_ServerDiagnostics_SubscriptionDiagnosticsArray                                                                 = 2290
	Server_ServerDiagnostics_EnabledFlag                                                                                  = 2294
	Server_VendorServerInfo                                                                                               = 2295
	Server_ServerRedundancy                                                                                               = 2296
	StateMachineType                                                                                                      = 2299
	StateType                                                                                                             = 2307
	StateType_StateNumber                                                                                                 = 2308
	InitialStateType                                                                                                      = 2309
	TransitionType                                                                                                        = 2310
	TransitionEventType                                                                                                   = 2311
	TransitionType_TransitionNumber                                                                                       = 2312
	AuditUpdateStateEventType                                                                                             = 2315
	HistoricalDataConfigurationType                                                                                       = 2318
	HistoricalDataConfigurationType_Stepped                                                                               = 2323
	HistoricalDataConfigurationType_Definition                                                                            = 2324
	HistoricalDataConfigurationType_MaxTimeInterval                                                                       = 2325
	HistoricalDataConfigurationType_MinTimeInterval                                                                       = 2326
	HistoricalDataConfigurationType_ExceptionDeviation                                                                    = 2327
	HistoricalDataConfigurationType_ExceptionDeviationFormat                                                              = 2328
	HistoryServerCapabilitiesType                                                                                         = 2330
	HistoryServerCapabilitiesType_AccessHistoryDataCapability                                                             = 2331
	HistoryServerCapabilitiesType_AccessHistoryEventsCapability                                                           = 2332
	HistoryServerCapabilitiesType_InsertDataCapability                                                                    = 2334
	HistoryServerCapabilitiesType_ReplaceDataCapability                                                                   = 2335
	HistoryServerCapabilitiesType_UpdateDataCapability                                                                    = 2336
	HistoryServerCapabilitiesType_DeleteRawCapability                                                                     = 2337
	HistoryServerCapabilitiesType_DeleteAtTimeCapability                                                                  = 2338
	AggregateFunctionType                                                                                                 = 2340
	AggregateFunction_Interpolative                                                                                       = 2341
	AggregateFunction_Average                                                                                             = 2342
	AggregateFunction_TimeAverage                                                                                         = 2343
	AggregateFunction_Total                                                                                               = 2344
	AggregateFunction_Minimum                                                                                             = 2346
	AggregateFunction_Maximum                                                                                             = 2347
	AggregateFunction_MinimumActualTime                                                                                   = 2348
	AggregateFunction_MaximumActualTime                                                                                   = 2349
	AggregateFunction_Range                                                                                               = 2350
	AggregateFunction_AnnotationCount                                                                                     = 2351
	AggregateFunction_Count                                                                                               = 2352
	AggregateFunction_NumberOfTransitions                                                                                 = 2355
	AggregateFunction_Start                                                                                               = 2357
	AggregateFunction_End                                                                                                 = 2358
	AggregateFunction_Delta                                                                                               = 2359
	AggregateFunction_DurationGood                                                                                        = 2360
	AggregateFunction_DurationBad                                                                                         = 2361
	AggregateFunction_PercentGood                                                                                         = 2362
	AggregateFunction_PercentBad                                                                                          = 2363
	AggregateFunction_WorstQuality                                                                                        = 2364
	DataItemType                                                                                                          = 2365
	DataItemType_Definition                                                                                               = 2366
	DataItemType_ValuePrecision                                                                                           = 2367
	AnalogItemType                                                                                                        = 2368
	AnalogItemType_EURange                                                                                                = 2369
	AnalogItemType_InstrumentRange                                                                                        = 2370
	AnalogItemType_EngineeringUnits                                                                                       = 2371
	DiscreteItemType                                                                                                      = 2372
	TwoStateDiscreteType                                                                                                  = 2373
	TwoStateDiscreteType_FalseState                                                                                       = 2374
	TwoStateDiscreteType_TrueState                                                                                        = 2375
	MultiStateDiscreteType                                                                                                = 2376
	MultiStateDiscreteType_EnumStrings                                                                                    = 2377
	ProgramTransitionEventType                                                                                            = 2378
	ProgramTransitionEventType_IntermediateResult                                                                         = 2379
	ProgramDiagnosticType                                                                                                 = 2380
	ProgramDiagnosticType_CreateSessionID                                                                                 = 2381
	ProgramDiagnosticType_CreateClientName                                                                                = 2382
	ProgramDiagnosticType_InvocationCreationTime                                                                          = 2383
	ProgramDiagnosticType_LastTransitionTime                                                                              = 2384
	ProgramDiagnosticType_LastMethodCall                                                                                  = 2385
	ProgramDiagnosticType_LastMethodSessionID                                                                             = 2386
	ProgramDiagnosticType_LastMethodInputArguments                                                                        = 2387
	ProgramDiagnosticType_LastMethodOutputArguments                                                                       = 2388
	ProgramDiagnosticType_LastMethodCallTime                                                                              = 2389
	ProgramDiagnosticType_LastMethodReturnStatus                                                                          = 2390
	ProgramStateMachineType                                                                                               = 2391
	ProgramStateMachineType_Creatable                                                                                     = 2392
	ProgramStateMachineType_Deletable                                                                                     = 2393
	ProgramStateMachineType_AutoDelete                                                                                    = 2394
	ProgramStateMachineType_RecycleCount                                                                                  = 2395
	ProgramStateMachineType_InstanceCount                                                                                 = 2396
	ProgramStateMachineType_MaxInstanceCount                                                                              = 2397
	ProgramStateMachineType_MaxRecycleCount                                                                               = 2398
	ProgramStateMachineType_ProgramDiagnostic                                                                             = 2399
	ProgramStateMachineType_Ready                                                                                         = 2400
	ProgramStateMachineType_Ready_StateNumber                                                                             = 2401
	ProgramStateMachineType_Running                                                                                       = 2402
	ProgramStateMachineType_Running_StateNumber                                                                           = 2403
	ProgramStateMachineType_Suspended                                                                                     = 2404
	ProgramStateMachineType_Suspended_StateNumber                                                                         = 2405
	ProgramStateMachineType_Halted                                                                                        = 2406
	ProgramStateMachineType_Halted_StateNumber                                                                            = 2407
	ProgramStateMachineType_HaltedToReady                                                                                 = 2408
	ProgramStateMachineType_HaltedToReady_TransitionNumber                                                                = 2409
	ProgramStateMachineType_ReadyToRunning                                                                                = 2410
	ProgramStateMachineType_ReadyToRunning_TransitionNumber                                                               = 2411
	ProgramStateMachineType_RunningToHalted                                                                               = 2412
	ProgramStateMachineType_RunningToHalted_TransitionNumber                                                              = 2413
	ProgramStateMachineType_RunningToReady                                                                                = 2414
	ProgramStateMachineType_RunningToReady_TransitionNumber                                                               = 2415
	ProgramStateMachineType_RunningToSuspended                                                                            = 2416
	ProgramStateMachineType_RunningToSuspended_TransitionNumber                                                           = 2417
	ProgramStateMachineType_SuspendedToRunning                                                                            = 2418
	ProgramStateMachineType_SuspendedToRunning_TransitionNumber                                                           = 2419
	ProgramStateMachineType_SuspendedToHalted                                                                             = 2420
	ProgramStateMachineType_SuspendedToHalted_TransitionNumber                                                            = 2421
	ProgramStateMachineType_SuspendedToReady                                                                              = 2422
	ProgramStateMachineType_SuspendedToReady_TransitionNumber                                                             = 2423
	ProgramStateMachineType_ReadyToHalted                                                                                 = 2424
	ProgramStateMachineType_ReadyToHalted_TransitionNumber                                                                = 2425
	ProgramStateMachineType_Start                                                                                         = 2426
	ProgramStateMachineType_Suspend                                                                                       = 2427
	ProgramStateMachineType_Resume                                                                                        = 2428
	ProgramStateMachineType_Halt                                                                                          = 2429
	ProgramStateMachineType_Reset                                                                                         = 2430
	SessionDiagnosticsVariableType_RegisterNodesCount                                                                     = 2730
	SessionDiagnosticsVariableType_UnregisterNodesCount                                                                   = 2731
	ServerCapabilitiesType_MaxBrowseContinuationPoints                                                                    = 2732
	ServerCapabilitiesType_MaxQueryContinuationPoints                                                                     = 2733
	ServerCapabilitiesType_MaxHistoryContinuationPoints                                                                   = 2734
	Server_ServerCapabilities_MaxBrowseContinuationPoints                                                                 = 2735
	Server_ServerCapabilities_MaxQueryContinuationPoints                                                                  = 2736
	Server_ServerCapabilities_MaxHistoryContinuationPoints                                                                = 2737
	SemanticChangeEventType                                                                                               = 2738
	SemanticChangeEventType_Changes                                                                                       = 2739
	ServerType_Auditing                                                                                                   = 2742
	ServerDiagnosticsType_SessionsDiagnosticsSummary                                                                      = 2744
	AuditChannelEventType_SecureChannelID                                                                                 = 2745
	AuditOpenSecureChannelEventType_ClientCertificateThumbprint                                                           = 2746
	AuditCreateSessionEventType_ClientCertificateThumbprint                                                               = 2747
	AuditURLMismatchEventType                                                                                             = 2748
	AuditURLMismatchEventType_EndpointURL                                                                                 = 2749
	AuditWriteUpdateEventType_AttributeID                                                                                 = 2750
	AuditHistoryUpdateEventType_ParameterDataTypeID                                                                       = 2751
	ServerStatusType_SecondsTillShutdown                                                                                  = 2752
	ServerStatusType_ShutdownReason                                                                                       = 2753
	ServerCapabilitiesType_AggregateFunctions                                                                             = 2754
	StateVariableType                                                                                                     = 2755
	StateVariableType_ID                                                                                                  = 2756
	StateVariableType_Name                                                                                                = 2757
	StateVariableType_Number                                                                                              = 2758
	StateVariableType_EffectiveDisplayName                                                                                = 2759
	FiniteStateVariableType                                                                                               = 2760
	FiniteStateVariableType_ID                                                                                            = 2761
	TransitionVariableType                                                                                                = 2762
	TransitionVariableType_ID                                                                                             = 2763
	TransitionVariableType_Name                                                                                           = 2764
	TransitionVariableType_Number                                                                                         = 2765
	TransitionVariableType_TransitionTime                                                                                 = 2766
	FiniteTransitionVariableType                                                                                          = 2767
	FiniteTransitionVariableType_ID                                                                                       = 2768
	StateMachineType_CurrentState                                                                                         = 2769
	StateMachineType_LastTransition                                                                                       = 2770
	FiniteStateMachineType                                                                                                = 2771
	FiniteStateMachineType_CurrentState                                                                                   = 2772
	FiniteStateMachineType_LastTransition                                                                                 = 2773
	TransitionEventType_Transition                                                                                        = 2774
	TransitionEventType_FromState                                                                                         = 2775
	TransitionEventType_ToState                                                                                           = 2776
	AuditUpdateStateEventType_OldStateID                                                                                  = 2777
	AuditUpdateStateEventType_NewStateID                                                                                  = 2778
	ConditionType                                                                                                         = 2782
	RefreshStartEventType                                                                                                 = 2787
	RefreshEndEventType                                                                                                   = 2788
	RefreshRequiredEventType                                                                                              = 2789
	AuditConditionEventType                                                                                               = 2790
	AuditConditionEnableEventType                                                                                         = 2803
	AuditConditionCommentEventType                                                                                        = 2829
	DialogConditionType                                                                                                   = 2830
	DialogConditionType_Prompt                                                                                            = 2831
	AcknowledgeableConditionType                                                                                          = 2881
	AlarmConditionType                                                                                                    = 2915
	ShelvedStateMachineType                                                                                               = 2929
	ShelvedStateMachineType_Unshelved                                                                                     = 2930
	ShelvedStateMachineType_TimedShelved                                                                                  = 2932
	ShelvedStateMachineType_OneShotShelved                                                                                = 2933
	ShelvedStateMachineType_UnshelvedToTimedShelved                                                                       = 2935
	ShelvedStateMachineType_UnshelvedToOneShotShelved                                                                     = 2936
	ShelvedStateMachineType_TimedShelvedToUnshelved                                                                       = 2940
	ShelvedStateMachineType_TimedShelvedToOneShotShelved                                                                  = 2942
	ShelvedStateMachineType_OneShotShelvedToUnshelved                                                                     = 2943
	ShelvedStateMachineType_OneShotShelvedToTimedShelved                                                                  = 2945
	ShelvedStateMachineType_Unshelve                                                                                      = 2947
	ShelvedStateMachineType_OneShotShelve                                                                                 = 2948
	ShelvedStateMachineType_TimedShelve                                                                                   = 2949
	LimitAlarmType                                                                                                        = 2955
	ShelvedStateMachineType_TimedShelve_InputArguments                                                                    = 2991
	Server_ServerStatus_SecondsTillShutdown                                                                               = 2992
	Server_ServerStatus_ShutdownReason                                                                                    = 2993
	Server_Auditing                                                                                                       = 2994
	Server_ServerCapabilities_ModellingRules                                                                              = 2996
	Server_ServerCapabilities_AggregateFunctions                                                                          = 2997
	SubscriptionDiagnosticsType_EventNotificationsCount                                                                   = 2998
	AuditHistoryEventUpdateEventType                                                                                      = 2999
	AuditHistoryEventUpdateEventType_Filter                                                                               = 3003
	AuditHistoryValueUpdateEventType                                                                                      = 3006
	AuditHistoryDeleteEventType                                                                                           = 3012
	AuditHistoryRawModifyDeleteEventType                                                                                  = 3014
	AuditHistoryRawModifyDeleteEventType_IsDeleteModified                                                                 = 3015
	AuditHistoryRawModifyDeleteEventType_StartTime                                                                        = 3016
	AuditHistoryRawModifyDeleteEventType_EndTime                                                                          = 3017
	AuditHistoryAtTimeDeleteEventType                                                                                     = 3019
	AuditHistoryAtTimeDeleteEventType_ReqTimes                                                                            = 3020
	AuditHistoryAtTimeDeleteEventType_OldValues                                                                           = 3021
	AuditHistoryEventDeleteEventType                                                                                      = 3022
	AuditHistoryEventDeleteEventType_EventIDs                                                                             = 3023
	AuditHistoryEventDeleteEventType_OldValues                                                                            = 3024
	AuditHistoryEventUpdateEventType_UpdatedNode                                                                          = 3025
	AuditHistoryValueUpdateEventType_UpdatedNode                                                                          = 3026
	AuditHistoryDeleteEventType_UpdatedNode                                                                               = 3027
	AuditHistoryEventUpdateEventType_PerformInsertReplace                                                                 = 3028
	AuditHistoryEventUpdateEventType_NewValues                                                                            = 3029
	AuditHistoryEventUpdateEventType_OldValues                                                                            = 3030
	AuditHistoryValueUpdateEventType_PerformInsertReplace                                                                 = 3031
	AuditHistoryValueUpdateEventType_NewValues                                                                            = 3032
	AuditHistoryValueUpdateEventType_OldValues                                                                            = 3033
	AuditHistoryRawModifyDeleteEventType_OldValues                                                                        = 3034
	EventQueueOverflowEventType                                                                                           = 3035
	EventTypesFolder                                                                                                      = 3048
	ServerCapabilitiesType_SoftwareCertificates                                                                           = 3049
	SessionDiagnosticsVariableType_MaxResponseMessageSize                                                                 = 3050
	BuildInfoType                                                                                                         = 3051
	BuildInfoType_ProductURI                                                                                              = 3052
	BuildInfoType_ManufacturerName                                                                                        = 3053
	BuildInfoType_ProductName                                                                                             = 3054
	BuildInfoType_SoftwareVersion                                                                                         = 3055
	BuildInfoType_BuildNumber                                                                                             = 3056
	BuildInfoType_BuildDate                                                                                               = 3057
	SessionSecurityDiagnosticsType_ClientCertificate                                                                      = 3058
	HistoricalDataConfigurationType_AggregateConfiguration                                                                = 3059
	DefaultBinary                                                                                                         = 3062
	DefaultXML                                                                                                            = 3063
	AlwaysGeneratesEvent                                                                                                  = 3065
	Icon                                                                                                                  = 3067
	NodeVersion                                                                                                           = 3068
	LocalTime                                                                                                             = 3069
	AllowNulls                                                                                                            = 3070
	EnumValues                                                                                                            = 3071
	InputArguments                                                                                                        = 3072
	OutputArguments                                                                                                       = 3073
	ServerType_ServerStatus_StartTime                                                                                     = 3074
	ServerType_ServerStatus_CurrentTime                                                                                   = 3075
	ServerType_ServerStatus_State                                                                                         = 3076
	ServerType_ServerStatus_BuildInfo                                                                                     = 3077
	ServerType_ServerStatus_BuildInfo_ProductURI                                                                          = 3078
	ServerType_ServerStatus_BuildInfo_ManufacturerName                                                                    = 3079
	ServerType_ServerStatus_BuildInfo_ProductName                                                                         = 3080
	ServerType_ServerStatus_BuildInfo_SoftwareVersion                                                                     = 3081
	ServerType_ServerStatus_BuildInfo_BuildNumber                                                                         = 3082
	ServerType_ServerStatus_BuildInfo_BuildDate                                                                           = 3083
	ServerType_ServerStatus_SecondsTillShutdown                                                                           = 3084
	ServerType_ServerStatus_ShutdownReason                                                                                = 3085
	ServerType_ServerCapabilities_ServerProfileArray                                                                      = 3086
	ServerType_ServerCapabilities_LocaleIDArray                                                                           = 3087
	ServerType_ServerCapabilities_MinSupportedSampleRate                                                                  = 3088
	ServerType_ServerCapabilities_MaxBrowseContinuationPoints                                                             = 3089
	ServerType_ServerCapabilities_MaxQueryContinuationPoints                                                              = 3090
	ServerType_ServerCapabilities_MaxHistoryContinuationPoints                                                            = 3091
	ServerType_ServerCapabilities_SoftwareCertificates                                                                    = 3092
	ServerType_ServerCapabilities_ModellingRules                                                                          = 3093
	ServerType_ServerCapabilities_AggregateFunctions                                                                      = 3094
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary                                                                 = 3095
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount                                                 = 3096
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount                                             = 3097
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount                                           = 3098
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount                                    = 3099
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount                                            = 3100
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount                                             = 3101
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount                                               = 3102
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount                                         = 3104
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount                                        = 3105
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount                                      = 3106
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount                                   = 3107
	ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount                                           = 3108
	ServerType_ServerDiagnostics_SamplingIntervalDiagnosticsArray                                                         = 3109
	ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray                                                             = 3110
	ServerType_ServerDiagnostics_SessionsDiagnosticsSummary                                                               = 3111
	ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray                                       = 3112
	ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray                               = 3113
	ServerType_ServerDiagnostics_EnabledFlag                                                                              = 3114
	ServerType_ServerRedundancy_RedundancySupport                                                                         = 3115
	ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount                                                        = 3116
	ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount                                                    = 3117
	ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount                                                  = 3118
	ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount                                           = 3119
	ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount                                                   = 3120
	ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount                                                    = 3121
	ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount                                                      = 3122
	ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount                                                = 3124
	ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount                                               = 3125
	ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount                                             = 3126
	ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount                                          = 3127
	ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount                                                  = 3128
	ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray                                              = 3129
	ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray                                      = 3130
	SessionDiagnosticsObjectType_SessionDiagnostics_SessionID                                                             = 3131
	SessionDiagnosticsObjectType_SessionDiagnostics_SessionName                                                           = 3132
	SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription                                                     = 3133
	SessionDiagnosticsObjectType_SessionDiagnostics_ServerURI                                                             = 3134
	SessionDiagnosticsObjectType_SessionDiagnostics_EndpointURL                                                           = 3135
	SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIDs                                                             = 3136
	SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout                                                  = 3137
	SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize                                                = 3138
	SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime                                                  = 3139
	SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime                                                 = 3140
	SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount                                             = 3141
	SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount                                            = 3142
	SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue                                         = 3143
	SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount                                                             = 3151
	SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount                                                      = 3152
	SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount                                                            = 3153
	SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount                                                    = 3154
	SessionDiagnosticsObjectType_SessionDiagnostics_CallCount                                                             = 3155
	SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount                                             = 3156
	SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount                                             = 3157
	SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount                                                = 3158
	SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount                                                    = 3159
	SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount                                             = 3160
	SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount                                               = 3161
	SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount                                               = 3162
	SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount                                                = 3163
	SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount                                                          = 3164
	SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount                                                        = 3165
	SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount                                            = 3166
	SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount                                              = 3167
	SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount                                                         = 3168
	SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount                                                    = 3169
	SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount                                                      = 3170
	SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount                                                 = 3171
	SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount                                                           = 3172
	SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount                                                       = 3173
	SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIDsCount                                    = 3174
	SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount                                                       = 3175
	SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount                                                        = 3176
	SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount                                                    = 3177
	SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount                                                  = 3178
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionID                                                     = 3179
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIDOfSession                                         = 3180
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIDHistory                                           = 3181
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism                                       = 3182
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding                                                      = 3183
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol                                             = 3184
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode                                                  = 3185
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyURI                                             = 3186
	SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate                                             = 3187
	TransparentRedundancyType_RedundancySupport                                                                           = 3188
	NonTransparentRedundancyType_RedundancySupport                                                                        = 3189
	BaseEventType_LocalTime                                                                                               = 3190
	EventQueueOverflowEventType_EventID                                                                                   = 3191
	EventQueueOverflowEventType_EventType                                                                                 = 3192
	EventQueueOverflowEventType_SourceNode                                                                                = 3193
	EventQueueOverflowEventType_SourceName                                                                                = 3194
	EventQueueOverflowEventType_Time                                                                                      = 3195
	EventQueueOverflowEventType_ReceiveTime                                                                               = 3196
	EventQueueOverflowEventType_LocalTime                                                                                 = 3197
	EventQueueOverflowEventType_Message                                                                                   = 3198
	EventQueueOverflowEventType_Severity                                                                                  = 3199
	AuditEventType_EventID                                                                                                = 3200
	AuditEventType_EventType                                                                                              = 3201
	AuditEventType_SourceNode                                                                                             = 3202
	AuditEventType_SourceName                                                                                             = 3203
	AuditEventType_Time                                                                                                   = 3204
	AuditEventType_ReceiveTime                                                                                            = 3205
	AuditEventType_LocalTime                                                                                              = 3206
	AuditEventType_Message                                                                                                = 3207
	AuditEventType_Severity                                                                                               = 3208
	AuditSecurityEventType_EventID                                                                                        = 3209
	AuditSecurityEventType_EventType                                                                                      = 3210
	AuditSecurityEventType_SourceNode                                                                                     = 3211
	AuditSecurityEventType_SourceName                                                                                     = 3212
	AuditSecurityEventType_Time                                                                                           = 3213
	AuditSecurityEventType_ReceiveTime                                                                                    = 3214
	AuditSecurityEventType_LocalTime                                                                                      = 3215
	AuditSecurityEventType_Message                                                                                        = 3216
	AuditSecurityEventType_Severity                                                                                       = 3217
	AuditSecurityEventType_ActionTimeStamp                                                                                = 3218
	AuditSecurityEventType_Status                                                                                         = 3219
	AuditSecurityEventType_ServerID                                                                                       = 3220
	AuditSecurityEventType_ClientAuditEntryID                                                                             = 3221
	AuditSecurityEventType_ClientUserID                                                                                   = 3222
	AuditChannelEventType_EventID                                                                                         = 3223
	AuditChannelEventType_EventType                                                                                       = 3224
	AuditChannelEventType_SourceNode                                                                                      = 3225
	AuditChannelEventType_SourceName                                                                                      = 3226
	AuditChannelEventType_Time                                                                                            = 3227
	AuditChannelEventType_ReceiveTime                                                                                     = 3228
	AuditChannelEventType_LocalTime                                                                                       = 3229
	AuditChannelEventType_Message                                                                                         = 3230
	AuditChannelEventType_Severity                                                                                        = 3231
	AuditChannelEventType_ActionTimeStamp                                                                                 = 3232
	AuditChannelEventType_Status                                                                                          = 3233
	AuditChannelEventType_ServerID                                                                                        = 3234
	AuditChannelEventType_ClientAuditEntryID                                                                              = 3235
	AuditChannelEventType_ClientUserID                                                                                    = 3236
	AuditOpenSecureChannelEventType_EventID                                                                               = 3237
	AuditOpenSecureChannelEventType_EventType                                                                             = 3238
	AuditOpenSecureChannelEventType_SourceNode                                                                            = 3239
	AuditOpenSecureChannelEventType_SourceName                                                                            = 3240
	AuditOpenSecureChannelEventType_Time                                                                                  = 3241
	AuditOpenSecureChannelEventType_ReceiveTime                                                                           = 3242
	AuditOpenSecureChannelEventType_LocalTime                                                                             = 3243
	AuditOpenSecureChannelEventType_Message                                                                               = 3244
	AuditOpenSecureChannelEventType_Severity                                                                              = 3245
	AuditOpenSecureChannelEventType_ActionTimeStamp                                                                       = 3246
	AuditOpenSecureChannelEventType_Status                                                                                = 3247
	AuditOpenSecureChannelEventType_ServerID                                                                              = 3248
	AuditOpenSecureChannelEventType_ClientAuditEntryID                                                                    = 3249
	AuditOpenSecureChannelEventType_ClientUserID                                                                          = 3250
	AuditOpenSecureChannelEventType_SecureChannelID                                                                       = 3251
	AuditSessionEventType_EventID                                                                                         = 3252
	AuditSessionEventType_EventType                                                                                       = 3253
	AuditSessionEventType_SourceNode                                                                                      = 3254
	AuditSessionEventType_SourceName                                                                                      = 3255
	AuditSessionEventType_Time                                                                                            = 3256
	AuditSessionEventType_ReceiveTime                                                                                     = 3257
	AuditSessionEventType_LocalTime                                                                                       = 3258
	AuditSessionEventType_Message                                                                                         = 3259
	AuditSessionEventType_Severity                                                                                        = 3260
	AuditSessionEventType_ActionTimeStamp                                                                                 = 3261
	AuditSessionEventType_Status                                                                                          = 3262
	AuditSessionEventType_ServerID                                                                                        = 3263
	AuditSessionEventType_ClientAuditEntryID                                                                              = 3264
	AuditSessionEventType_ClientUserID                                                                                    = 3265
	AuditCreateSessionEventType_EventID                                                                                   = 3266
	AuditCreateSessionEventType_EventType                                                                                 = 3267
	AuditCreateSessionEventType_SourceNode                                                                                = 3268
	AuditCreateSessionEventType_SourceName                                                                                = 3269
	AuditCreateSessionEventType_Time                                                                                      = 3270
	AuditCreateSessionEventType_ReceiveTime                                                                               = 3271
	AuditCreateSessionEventType_LocalTime                                                                                 = 3272
	AuditCreateSessionEventType_Message                                                                                   = 3273
	AuditCreateSessionEventType_Severity                                                                                  = 3274
	AuditCreateSessionEventType_ActionTimeStamp                                                                           = 3275
	AuditCreateSessionEventType_Status                                                                                    = 3276
	AuditCreateSessionEventType_ServerID                                                                                  = 3277
	AuditCreateSessionEventType_ClientAuditEntryID                                                                        = 3278
	AuditCreateSessionEventType_ClientUserID                                                                              = 3279
	AuditURLMismatchEventType_EventID                                                                                     = 3281
	AuditURLMismatchEventType_EventType                                                                                   = 3282
	AuditURLMismatchEventType_SourceNode                                                                                  = 3283
	AuditURLMismatchEventType_SourceName                                                                                  = 3284
	AuditURLMismatchEventType_Time                                                                                        = 3285
	AuditURLMismatchEventType_ReceiveTime                                                                                 = 3286
	AuditURLMismatchEventType_LocalTime                                                                                   = 3287
	AuditURLMismatchEventType_Message                                                                                     = 3288
	AuditURLMismatchEventType_Severity                                                                                    = 3289
	AuditURLMismatchEventType_ActionTimeStamp                                                                             = 3290
	AuditURLMismatchEventType_Status                                                                                      = 3291
	AuditURLMismatchEventType_ServerID                                                                                    = 3292
	AuditURLMismatchEventType_ClientAuditEntryID                                                                          = 3293
	AuditURLMismatchEventType_ClientUserID                                                                                = 3294
	AuditURLMismatchEventType_SecureChannelID                                                                             = 3296
	AuditURLMismatchEventType_ClientCertificate                                                                           = 3297
	AuditURLMismatchEventType_ClientCertificateThumbprint                                                                 = 3298
	AuditURLMismatchEventType_RevisedSessionTimeout                                                                       = 3299
	AuditActivateSessionEventType_EventID                                                                                 = 3300
	AuditActivateSessionEventType_EventType                                                                               = 3301
	AuditActivateSessionEventType_SourceNode                                                                              = 3302
	AuditActivateSessionEventType_SourceName                                                                              = 3303
	AuditActivateSessionEventType_Time                                                                                    = 3304
	AuditActivateSessionEventType_ReceiveTime                                                                             = 3305
	AuditActivateSessionEventType_LocalTime                                                                               = 3306
	AuditActivateSessionEventType_Message                                                                                 = 3307
	AuditActivateSessionEventType_Severity                                                                                = 3308
	AuditActivateSessionEventType_ActionTimeStamp                                                                         = 3309
	AuditActivateSessionEventType_Status                                                                                  = 3310
	AuditActivateSessionEventType_ServerID                                                                                = 3311
	AuditActivateSessionEventType_ClientAuditEntryID                                                                      = 3312
	AuditActivateSessionEventType_ClientUserID                                                                            = 3313
	AuditActivateSessionEventType_SessionID                                                                               = 3314
	AuditCancelEventType_EventID                                                                                          = 3315
	AuditCancelEventType_EventType                                                                                        = 3316
	AuditCancelEventType_SourceNode                                                                                       = 3317
	AuditCancelEventType_SourceName                                                                                       = 3318
	AuditCancelEventType_Time                                                                                             = 3319
	AuditCancelEventType_ReceiveTime                                                                                      = 3320
	AuditCancelEventType_LocalTime                                                                                        = 3321
	AuditCancelEventType_Message                                                                                          = 3322
	AuditCancelEventType_Severity                                                                                         = 3323
	AuditCancelEventType_ActionTimeStamp                                                                                  = 3324
	AuditCancelEventType_Status                                                                                           = 3325
	AuditCancelEventType_ServerID                                                                                         = 3326
	AuditCancelEventType_ClientAuditEntryID                                                                               = 3327
	AuditCancelEventType_ClientUserID                                                                                     = 3328
	AuditCancelEventType_SessionID                                                                                        = 3329
	AuditCertificateEventType_EventID                                                                                     = 3330
	AuditCertificateEventType_EventType                                                                                   = 3331
	AuditCertificateEventType_SourceNode                                                                                  = 3332
	AuditCertificateEventType_SourceName                                                                                  = 3333
	AuditCertificateEventType_Time                                                                                        = 3334
	AuditCertificateEventType_ReceiveTime                                                                                 = 3335
	AuditCertificateEventType_LocalTime                                                                                   = 3336
	AuditCertificateEventType_Message                                                                                     = 3337
	AuditCertificateEventType_Severity                                                                                    = 3338
	AuditCertificateEventType_ActionTimeStamp                                                                             = 3339
	AuditCertificateEventType_Status                                                                                      = 3340
	AuditCertificateEventType_ServerID                                                                                    = 3341
	AuditCertificateEventType_ClientAuditEntryID                                                                          = 3342
	AuditCertificateEventType_ClientUserID                                                                                = 3343
	AuditCertificateDataMismatchEventType_EventID                                                                         = 3344
	AuditCertificateDataMismatchEventType_EventType                                                                       = 3345
	AuditCertificateDataMismatchEventType_SourceNode                                                                      = 3346
	AuditCertificateDataMismatchEventType_SourceName                                                                      = 3347
	AuditCertificateDataMismatchEventType_Time                                                                            = 3348
	AuditCertificateDataMismatchEventType_ReceiveTime                                                                     = 3349
	AuditCertificateDataMismatchEventType_LocalTime                                                                       = 3350
	AuditCertificateDataMismatchEventType_Message                                                                         = 3351
	AuditCertificateDataMismatchEventType_Severity                                                                        = 3352
	AuditCertificateDataMismatchEventType_ActionTimeStamp                                                                 = 3353
	AuditCertificateDataMismatchEventType_Status                                                                          = 3354
	AuditCertificateDataMismatchEventType_ServerID                                                                        = 3355
	AuditCertificateDataMismatchEventType_ClientAuditEntryID                                                              = 3356
	AuditCertificateDataMismatchEventType_ClientUserID                                                                    = 3357
	AuditCertificateDataMismatchEventType_Certificate                                                                     = 3358
	AuditCertificateExpiredEventType_EventID                                                                              = 3359
	AuditCertificateExpiredEventType_EventType                                                                            = 3360
	AuditCertificateExpiredEventType_SourceNode                                                                           = 3361
	AuditCertificateExpiredEventType_SourceName                                                                           = 3362
	AuditCertificateExpiredEventType_Time                                                                                 = 3363
	AuditCertificateExpiredEventType_ReceiveTime                                                                          = 3364
	AuditCertificateExpiredEventType_LocalTime                                                                            = 3365
	AuditCertificateExpiredEventType_Message                                                                              = 3366
	AuditCertificateExpiredEventType_Severity                                                                             = 3367
	AuditCertificateExpiredEventType_ActionTimeStamp                                                                      = 3368
	AuditCertificateExpiredEventType_Status                                                                               = 3369
	AuditCertificateExpiredEventType_ServerID                                                                             = 3370
	AuditCertificateExpiredEventType_ClientAuditEntryID                                                                   = 3371
	AuditCertificateExpiredEventType_ClientUserID                                                                         = 3372
	AuditCertificateExpiredEventType_Certificate                                                                          = 3373
	AuditCertificateInvalidEventType_EventID                                                                              = 3374
	AuditCertificateInvalidEventType_EventType                                                                            = 3375
	AuditCertificateInvalidEventType_SourceNode                                                                           = 3376
	AuditCertificateInvalidEventType_SourceName                                                                           = 3377
	AuditCertificateInvalidEventType_Time                                                                                 = 3378
	AuditCertificateInvalidEventType_ReceiveTime                                                                          = 3379
	AuditCertificateInvalidEventType_LocalTime                                                                            = 3380
	AuditCertificateInvalidEventType_Message                                                                              = 3381
	AuditCertificateInvalidEventType_Severity                                                                             = 3382
	AuditCertificateInvalidEventType_ActionTimeStamp                                                                      = 3383
	AuditCertificateInvalidEventType_Status                                                                               = 3384
	AuditCertificateInvalidEventType_ServerID                                                                             = 3385
	AuditCertificateInvalidEventType_ClientAuditEntryID                                                                   = 3386
	AuditCertificateInvalidEventType_ClientUserID                                                                         = 3387
	AuditCertificateInvalidEventType_Certificate                                                                          = 3388
	AuditCertificateUntrustedEventType_EventID                                                                            = 3389
	AuditCertificateUntrustedEventType_EventType                                                                          = 3390
	AuditCertificateUntrustedEventType_SourceNode                                                                         = 3391
	AuditCertificateUntrustedEventType_SourceName                                                                         = 3392
	AuditCertificateUntrustedEventType_Time                                                                               = 3393
	AuditCertificateUntrustedEventType_ReceiveTime                                                                        = 3394
	AuditCertificateUntrustedEventType_LocalTime                                                                          = 3395
	AuditCertificateUntrustedEventType_Message                                                                            = 3396
	AuditCertificateUntrustedEventType_Severity                                                                           = 3397
	AuditCertificateUntrustedEventType_ActionTimeStamp                                                                    = 3398
	AuditCertificateUntrustedEventType_Status                                                                             = 3399
	AuditCertificateUntrustedEventType_ServerID                                                                           = 3400
	AuditCertificateUntrustedEventType_ClientAuditEntryID                                                                 = 3401
	AuditCertificateUntrustedEventType_ClientUserID                                                                       = 3402
	AuditCertificateUntrustedEventType_Certificate                                                                        = 3403
	AuditCertificateRevokedEventType_EventID                                                                              = 3404
	AuditCertificateRevokedEventType_EventType                                                                            = 3405
	AuditCertificateRevokedEventType_SourceNode                                                                           = 3406
	AuditCertificateRevokedEventType_SourceName                                                                           = 3407
	AuditCertificateRevokedEventType_Time                                                                                 = 3408
	AuditCertificateRevokedEventType_ReceiveTime                                                                          = 3409
	AuditCertificateRevokedEventType_LocalTime                                                                            = 3410
	AuditCertificateRevokedEventType_Message                                                                              = 3411
	AuditCertificateRevokedEventType_Severity                                                                             = 3412
	AuditCertificateRevokedEventType_ActionTimeStamp                                                                      = 3413
	AuditCertificateRevokedEventType_Status                                                                               = 3414
	AuditCertificateRevokedEventType_ServerID                                                                             = 3415
	AuditCertificateRevokedEventType_ClientAuditEntryID                                                                   = 3416
	AuditCertificateRevokedEventType_ClientUserID                                                                         = 3417
	AuditCertificateRevokedEventType_Certificate                                                                          = 3418
	AuditCertificateMismatchEventType_EventID                                                                             = 3419
	AuditCertificateMismatchEventType_EventType                                                                           = 3420
	AuditCertificateMismatchEventType_SourceNode                                                                          = 3421
	AuditCertificateMismatchEventType_SourceName                                                                          = 3422
	AuditCertificateMismatchEventType_Time                                                                                = 3423
	AuditCertificateMismatchEventType_ReceiveTime                                                                         = 3424
	AuditCertificateMismatchEventType_LocalTime                                                                           = 3425
	AuditCertificateMismatchEventType_Message                                                                             = 3426
	AuditCertificateMismatchEventType_Severity                                                                            = 3427
	AuditCertificateMismatchEventType_ActionTimeStamp                                                                     = 3428
	AuditCertificateMismatchEventType_Status                                                                              = 3429
	AuditCertificateMismatchEventType_ServerID                                                                            = 3430
	AuditCertificateMismatchEventType_ClientAuditEntryID                                                                  = 3431
	AuditCertificateMismatchEventType_ClientUserID                                                                        = 3432
	AuditCertificateMismatchEventType_Certificate                                                                         = 3433
	AuditNodeManagementEventType_EventID                                                                                  = 3434
	AuditNodeManagementEventType_EventType                                                                                = 3435
	AuditNodeManagementEventType_SourceNode                                                                               = 3436
	AuditNodeManagementEventType_SourceName                                                                               = 3437
	AuditNodeManagementEventType_Time                                                                                     = 3438
	AuditNodeManagementEventType_ReceiveTime                                                                              = 3439
	AuditNodeManagementEventType_LocalTime                                                                                = 3440
	AuditNodeManagementEventType_Message                                                                                  = 3441
	AuditNodeManagementEventType_Severity                                                                                 = 3442
	AuditNodeManagementEventType_ActionTimeStamp                                                                          = 3443
	AuditNodeManagementEventType_Status                                                                                   = 3444
	AuditNodeManagementEventType_ServerID                                                                                 = 3445
	AuditNodeManagementEventType_ClientAuditEntryID                                                                       = 3446
	AuditNodeManagementEventType_ClientUserID                                                                             = 3447
	AuditAddNodesEventType_EventID                                                                                        = 3448
	AuditAddNodesEventType_EventType                                                                                      = 3449
	AuditAddNodesEventType_SourceNode                                                                                     = 3450
	AuditAddNodesEventType_SourceName                                                                                     = 3451
	AuditAddNodesEventType_Time                                                                                           = 3452
	AuditAddNodesEventType_ReceiveTime                                                                                    = 3453
	AuditAddNodesEventType_LocalTime                                                                                      = 3454
	AuditAddNodesEventType_Message                                                                                        = 3455
	AuditAddNodesEventType_Severity                                                                                       = 3456
	AuditAddNodesEventType_ActionTimeStamp                                                                                = 3457
	AuditAddNodesEventType_Status                                                                                         = 3458
	AuditAddNodesEventType_ServerID                                                                                       = 3459
	AuditAddNodesEventType_ClientAuditEntryID                                                                             = 3460
	AuditAddNodesEventType_ClientUserID                                                                                   = 3461
	AuditDeleteNodesEventType_EventID                                                                                     = 3462
	AuditDeleteNodesEventType_EventType                                                                                   = 3463
	AuditDeleteNodesEventType_SourceNode                                                                                  = 3464
	AuditDeleteNodesEventType_SourceName                                                                                  = 3465
	AuditDeleteNodesEventType_Time                                                                                        = 3466
	AuditDeleteNodesEventType_ReceiveTime                                                                                 = 3467
	AuditDeleteNodesEventType_LocalTime                                                                                   = 3468
	AuditDeleteNodesEventType_Message                                                                                     = 3469
	AuditDeleteNodesEventType_Severity                                                                                    = 3470
	AuditDeleteNodesEventType_ActionTimeStamp                                                                             = 3471
	AuditDeleteNodesEventType_Status                                                                                      = 3472
	AuditDeleteNodesEventType_ServerID                                                                                    = 3473
	AuditDeleteNodesEventType_ClientAuditEntryID                                                                          = 3474
	AuditDeleteNodesEventType_ClientUserID                                                                                = 3475
	AuditAddReferencesEventType_EventID                                                                                   = 3476
	AuditAddReferencesEventType_EventType                                                                                 = 3477
	AuditAddReferencesEventType_SourceNode                                                                                = 3478
	AuditAddReferencesEventType_SourceName                                                                                = 3479
	AuditAddReferencesEventType_Time                                                                                      = 3480
	AuditAddReferencesEventType_ReceiveTime                                                                               = 3481
	AuditAddReferencesEventType_LocalTime                                                                                 = 3482
	AuditAddReferencesEventType_Message                                                                                   = 3483
	AuditAddReferencesEventType_Severity                                                                                  = 3484
	AuditAddReferencesEventType_ActionTimeStamp                                                                           = 3485
	AuditAddReferencesEventType_Status                                                                                    = 3486
	AuditAddReferencesEventType_ServerID                                                                                  = 3487
	AuditAddReferencesEventType_ClientAuditEntryID                                                                        = 3488
	AuditAddReferencesEventType_ClientUserID                                                                              = 3489
	AuditDeleteReferencesEventType_EventID                                                                                = 3490
	AuditDeleteReferencesEventType_EventType                                                                              = 3491
	AuditDeleteReferencesEventType_SourceNode                                                                             = 3492
	AuditDeleteReferencesEventType_SourceName                                                                             = 3493
	AuditDeleteReferencesEventType_Time                                                                                   = 3494
	AuditDeleteReferencesEventType_ReceiveTime                                                                            = 3495
	AuditDeleteReferencesEventType_LocalTime                                                                              = 3496
	AuditDeleteReferencesEventType_Message                                                                                = 3497
	AuditDeleteReferencesEventType_Severity                                                                               = 3498
	AuditDeleteReferencesEventType_ActionTimeStamp                                                                        = 3499
	AuditDeleteReferencesEventType_Status                                                                                 = 3500
	AuditDeleteReferencesEventType_ServerID                                                                               = 3501
	AuditDeleteReferencesEventType_ClientAuditEntryID                                                                     = 3502
	AuditDeleteReferencesEventType_ClientUserID                                                                           = 3503
	AuditUpdateEventType_EventID                                                                                          = 3504
	AuditUpdateEventType_EventType                                                                                        = 3505
	AuditUpdateEventType_SourceNode                                                                                       = 3506
	AuditUpdateEventType_SourceName                                                                                       = 3507
	AuditUpdateEventType_Time                                                                                             = 3508
	AuditUpdateEventType_ReceiveTime                                                                                      = 3509
	AuditUpdateEventType_LocalTime                                                                                        = 3510
	AuditUpdateEventType_Message                                                                                          = 3511
	AuditUpdateEventType_Severity                                                                                         = 3512
	AuditUpdateEventType_ActionTimeStamp                                                                                  = 3513
	AuditUpdateEventType_Status                                                                                           = 3514
	AuditUpdateEventType_ServerID                                                                                         = 3515
	AuditUpdateEventType_ClientAuditEntryID                                                                               = 3516
	AuditUpdateEventType_ClientUserID                                                                                     = 3517
	AuditWriteUpdateEventType_EventID                                                                                     = 3518
	AuditWriteUpdateEventType_EventType                                                                                   = 3519
	AuditWriteUpdateEventType_SourceNode                                                                                  = 3520
	AuditWriteUpdateEventType_SourceName                                                                                  = 3521
	AuditWriteUpdateEventType_Time                                                                                        = 3522
	AuditWriteUpdateEventType_ReceiveTime                                                                                 = 3523
	AuditWriteUpdateEventType_LocalTime                                                                                   = 3524
	AuditWriteUpdateEventType_Message                                                                                     = 3525
	AuditWriteUpdateEventType_Severity                                                                                    = 3526
	AuditWriteUpdateEventType_ActionTimeStamp                                                                             = 3527
	AuditWriteUpdateEventType_Status                                                                                      = 3528
	AuditWriteUpdateEventType_ServerID                                                                                    = 3529
	AuditWriteUpdateEventType_ClientAuditEntryID                                                                          = 3530
	AuditWriteUpdateEventType_ClientUserID                                                                                = 3531
	AuditHistoryUpdateEventType_EventID                                                                                   = 3532
	AuditHistoryUpdateEventType_EventType                                                                                 = 3533
	AuditHistoryUpdateEventType_SourceNode                                                                                = 3534
	AuditHistoryUpdateEventType_SourceName                                                                                = 3535
	AuditHistoryUpdateEventType_Time                                                                                      = 3536
	AuditHistoryUpdateEventType_ReceiveTime                                                                               = 3537
	AuditHistoryUpdateEventType_LocalTime                                                                                 = 3538
	AuditHistoryUpdateEventType_Message                                                                                   = 3539
	AuditHistoryUpdateEventType_Severity                                                                                  = 3540
	AuditHistoryUpdateEventType_ActionTimeStamp                                                                           = 3541
	AuditHistoryUpdateEventType_Status                                                                                    = 3542
	AuditHistoryUpdateEventType_ServerID                                                                                  = 3543
	AuditHistoryUpdateEventType_ClientAuditEntryID                                                                        = 3544
	AuditHistoryUpdateEventType_ClientUserID                                                                              = 3545
	AuditHistoryEventUpdateEventType_EventID                                                                              = 3546
	AuditHistoryEventUpdateEventType_EventType                                                                            = 3547
	AuditHistoryEventUpdateEventType_SourceNode                                                                           = 3548
	AuditHistoryEventUpdateEventType_SourceName                                                                           = 3549
	AuditHistoryEventUpdateEventType_Time                                                                                 = 3550
	AuditHistoryEventUpdateEventType_ReceiveTime                                                                          = 3551
	AuditHistoryEventUpdateEventType_LocalTime                                                                            = 3552
	AuditHistoryEventUpdateEventType_Message                                                                              = 3553
	AuditHistoryEventUpdateEventType_Severity                                                                             = 3554
	AuditHistoryEventUpdateEventType_ActionTimeStamp                                                                      = 3555
	AuditHistoryEventUpdateEventType_Status                                                                               = 3556
	AuditHistoryEventUpdateEventType_ServerID                                                                             = 3557
	AuditHistoryEventUpdateEventType_ClientAuditEntryID                                                                   = 3558
	AuditHistoryEventUpdateEventType_ClientUserID                                                                         = 3559
	AuditHistoryEventUpdateEventType_ParameterDataTypeID                                                                  = 3560
	AuditHistoryValueUpdateEventType_EventID                                                                              = 3561
	AuditHistoryValueUpdateEventType_EventType                                                                            = 3562
	AuditHistoryValueUpdateEventType_SourceNode                                                                           = 3563
	AuditHistoryValueUpdateEventType_SourceName                                                                           = 3564
	AuditHistoryValueUpdateEventType_Time                                                                                 = 3565
	AuditHistoryValueUpdateEventType_ReceiveTime                                                                          = 3566
	AuditHistoryValueUpdateEventType_LocalTime                                                                            = 3567
	AuditHistoryValueUpdateEventType_Message                                                                              = 3568
	AuditHistoryValueUpdateEventType_Severity                                                                             = 3569
	AuditHistoryValueUpdateEventType_ActionTimeStamp                                                                      = 3570
	AuditHistoryValueUpdateEventType_Status                                                                               = 3571
	AuditHistoryValueUpdateEventType_ServerID                                                                             = 3572
	AuditHistoryValueUpdateEventType_ClientAuditEntryID                                                                   = 3573
	AuditHistoryValueUpdateEventType_ClientUserID                                                                         = 3574
	AuditHistoryValueUpdateEventType_ParameterDataTypeID                                                                  = 3575
	AuditHistoryDeleteEventType_EventID                                                                                   = 3576
	AuditHistoryDeleteEventType_EventType                                                                                 = 3577
	AuditHistoryDeleteEventType_SourceNode                                                                                = 3578
	AuditHistoryDeleteEventType_SourceName                                                                                = 3579
	AuditHistoryDeleteEventType_Time                                                                                      = 3580
	AuditHistoryDeleteEventType_ReceiveTime                                                                               = 3581
	AuditHistoryDeleteEventType_LocalTime                                                                                 = 3582
	AuditHistoryDeleteEventType_Message                                                                                   = 3583
	AuditHistoryDeleteEventType_Severity                                                                                  = 3584
	AuditHistoryDeleteEventType_ActionTimeStamp                                                                           = 3585
	AuditHistoryDeleteEventType_Status                                                                                    = 3586
	AuditHistoryDeleteEventType_ServerID                                                                                  = 3587
	AuditHistoryDeleteEventType_ClientAuditEntryID                                                                        = 3588
	AuditHistoryDeleteEventType_ClientUserID                                                                              = 3589
	AuditHistoryDeleteEventType_ParameterDataTypeID                                                                       = 3590
	AuditHistoryRawModifyDeleteEventType_EventID                                                                          = 3591
	AuditHistoryRawModifyDeleteEventType_EventType                                                                        = 3592
	AuditHistoryRawModifyDeleteEventType_SourceNode                                                                       = 3593
	AuditHistoryRawModifyDeleteEventType_SourceName                                                                       = 3594
	AuditHistoryRawModifyDeleteEventType_Time                                                                             = 3595
	AuditHistoryRawModifyDeleteEventType_ReceiveTime                                                                      = 3596
	AuditHistoryRawModifyDeleteEventType_LocalTime                                                                        = 3597
	AuditHistoryRawModifyDeleteEventType_Message                                                                          = 3598
	AuditHistoryRawModifyDeleteEventType_Severity                                                                         = 3599
	AuditHistoryRawModifyDeleteEventType_ActionTimeStamp                                                                  = 3600
	AuditHistoryRawModifyDeleteEventType_Status                                                                           = 3601
	AuditHistoryRawModifyDeleteEventType_ServerID                                                                         = 3602
	AuditHistoryRawModifyDeleteEventType_ClientAuditEntryID                                                               = 3603
	AuditHistoryRawModifyDeleteEventType_ClientUserID                                                                     = 3604
	AuditHistoryRawModifyDeleteEventType_ParameterDataTypeID                                                              = 3605
	AuditHistoryRawModifyDeleteEventType_UpdatedNode                                                                      = 3606
	AuditHistoryAtTimeDeleteEventType_EventID                                                                             = 3607
	AuditHistoryAtTimeDeleteEventType_EventType                                                                           = 3608
	AuditHistoryAtTimeDeleteEventType_SourceNode                                                                          = 3609
	AuditHistoryAtTimeDeleteEventType_SourceName                                                                          = 3610
	AuditHistoryAtTimeDeleteEventType_Time                                                                                = 3611
	AuditHistoryAtTimeDeleteEventType_ReceiveTime                                                                         = 3612
	AuditHistoryAtTimeDeleteEventType_LocalTime                                                                           = 3613
	AuditHistoryAtTimeDeleteEventType_Message                                                                             = 3614
	AuditHistoryAtTimeDeleteEventType_Severity                                                                            = 3615
	AuditHistoryAtTimeDeleteEventType_ActionTimeStamp                                                                     = 3616
	AuditHistoryAtTimeDeleteEventType_Status                                                                              = 3617
	AuditHistoryAtTimeDeleteEventType_ServerID                                                                            = 3618
	AuditHistoryAtTimeDeleteEventType_ClientAuditEntryID                                                                  = 3619
	AuditHistoryAtTimeDeleteEventType_ClientUserID                                                                        = 3620
	AuditHistoryAtTimeDeleteEventType_ParameterDataTypeID                                                                 = 3621
	AuditHistoryAtTimeDeleteEventType_UpdatedNode                                                                         = 3622
	AuditHistoryEventDeleteEventType_EventID                                                                              = 3623
	AuditHistoryEventDeleteEventType_EventType                                                                            = 3624
	AuditHistoryEventDeleteEventType_SourceNode                                                                           = 3625
	AuditHistoryEventDeleteEventType_SourceName                                                                           = 3626
	AuditHistoryEventDeleteEventType_Time                                                                                 = 3627
	AuditHistoryEventDeleteEventType_ReceiveTime                                                                          = 3628
	AuditHistoryEventDeleteEventType_LocalTime                                                                            = 3629
	AuditHistoryEventDeleteEventType_Message                                                                              = 3630
	AuditHistoryEventDeleteEventType_Severity                                                                             = 3631
	AuditHistoryEventDeleteEventType_ActionTimeStamp                                                                      = 3632
	AuditHistoryEventDeleteEventType_Status                                                                               = 3633
	AuditHistoryEventDeleteEventType_ServerID                                                                             = 3634
	AuditHistoryEventDeleteEventType_ClientAuditEntryID                                                                   = 3635
	AuditHistoryEventDeleteEventType_ClientUserID                                                                         = 3636
	AuditHistoryEventDeleteEventType_ParameterDataTypeID                                                                  = 3637
	AuditHistoryEventDeleteEventType_UpdatedNode                                                                          = 3638
	AuditUpdateMethodEventType_EventID                                                                                    = 3639
	AuditUpdateMethodEventType_EventType                                                                                  = 3640
	AuditUpdateMethodEventType_SourceNode                                                                                 = 3641
	AuditUpdateMethodEventType_SourceName                                                                                 = 3642
	AuditUpdateMethodEventType_Time                                                                                       = 3643
	AuditUpdateMethodEventType_ReceiveTime                                                                                = 3644
	AuditUpdateMethodEventType_LocalTime                                                                                  = 3645
	AuditUpdateMethodEventType_Message                                                                                    = 3646
	AuditUpdateMethodEventType_Severity                                                                                   = 3647
	AuditUpdateMethodEventType_ActionTimeStamp                                                                            = 3648
	AuditUpdateMethodEventType_Status                                                                                     = 3649
	AuditUpdateMethodEventType_ServerID                                                                                   = 3650
	AuditUpdateMethodEventType_ClientAuditEntryID                                                                         = 3651
	AuditUpdateMethodEventType_ClientUserID                                                                               = 3652
	SystemEventType_EventID                                                                                               = 3653
	SystemEventType_EventType                                                                                             = 3654
	SystemEventType_SourceNode                                                                                            = 3655
	SystemEventType_SourceName                                                                                            = 3656
	SystemEventType_Time                                                                                                  = 3657
	SystemEventType_ReceiveTime                                                                                           = 3658
	SystemEventType_LocalTime                                                                                             = 3659
	SystemEventType_Message                                                                                               = 3660
	SystemEventType_Severity                                                                                              = 3661
	DeviceFailureEventType_EventID                                                                                        = 3662
	DeviceFailureEventType_EventType                                                                                      = 3663
	DeviceFailureEventType_SourceNode                                                                                     = 3664
	DeviceFailureEventType_SourceName                                                                                     = 3665
	DeviceFailureEventType_Time                                                                                           = 3666
	DeviceFailureEventType_ReceiveTime                                                                                    = 3667
	DeviceFailureEventType_LocalTime                                                                                      = 3668
	DeviceFailureEventType_Message                                                                                        = 3669
	DeviceFailureEventType_Severity                                                                                       = 3670
	BaseModelChangeEventType_EventID                                                                                      = 3671
	BaseModelChangeEventType_EventType                                                                                    = 3672
	BaseModelChangeEventType_SourceNode                                                                                   = 3673
	BaseModelChangeEventType_SourceName                                                                                   = 3674
	BaseModelChangeEventType_Time                                                                                         = 3675
	BaseModelChangeEventType_ReceiveTime                                                                                  = 3676
	BaseModelChangeEventType_LocalTime                                                                                    = 3677
	BaseModelChangeEventType_Message                                                                                      = 3678
	BaseModelChangeEventType_Severity                                                                                     = 3679
	GeneralModelChangeEventType_EventID                                                                                   = 3680
	GeneralModelChangeEventType_EventType                                                                                 = 3681
	GeneralModelChangeEventType_SourceNode                                                                                = 3682
	GeneralModelChangeEventType_SourceName                                                                                = 3683
	GeneralModelChangeEventType_Time                                                                                      = 3684
	GeneralModelChangeEventType_ReceiveTime                                                                               = 3685
	GeneralModelChangeEventType_LocalTime                                                                                 = 3686
	GeneralModelChangeEventType_Message                                                                                   = 3687
	GeneralModelChangeEventType_Severity                                                                                  = 3688
	SemanticChangeEventType_EventID                                                                                       = 3689
	SemanticChangeEventType_EventType                                                                                     = 3690
	SemanticChangeEventType_SourceNode                                                                                    = 3691
	SemanticChangeEventType_SourceName                                                                                    = 3692
	SemanticChangeEventType_Time                                                                                          = 3693
	SemanticChangeEventType_ReceiveTime                                                                                   = 3694
	SemanticChangeEventType_LocalTime                                                                                     = 3695
	SemanticChangeEventType_Message                                                                                       = 3696
	SemanticChangeEventType_Severity                                                                                      = 3697
	ServerStatusType_BuildInfo_ProductURI                                                                                 = 3698
	ServerStatusType_BuildInfo_ManufacturerName                                                                           = 3699
	ServerStatusType_BuildInfo_ProductName                                                                                = 3700
	ServerStatusType_BuildInfo_SoftwareVersion                                                                            = 3701
	ServerStatusType_BuildInfo_BuildNumber                                                                                = 3702
	ServerStatusType_BuildInfo_BuildDate                                                                                  = 3703
	Server_ServerCapabilities_SoftwareCertificates                                                                        = 3704
	Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount                                                = 3705
	Server_ServerDiagnostics_SessionsDiagnosticsSummary                                                                   = 3706
	Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray                                           = 3707
	Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray                                   = 3708
	Server_ServerRedundancy_RedundancySupport                                                                             = 3709
	FiniteStateVariableType_Name                                                                                          = 3714
	FiniteStateVariableType_Number                                                                                        = 3715
	FiniteStateVariableType_EffectiveDisplayName                                                                          = 3716
	FiniteTransitionVariableType_Name                                                                                     = 3717
	FiniteTransitionVariableType_Number                                                                                   = 3718
	FiniteTransitionVariableType_TransitionTime                                                                           = 3719
	StateMachineType_CurrentState_ID                                                                                      = 3720
	StateMachineType_CurrentState_Name                                                                                    = 3721
	StateMachineType_CurrentState_Number                                                                                  = 3722
	StateMachineType_CurrentState_EffectiveDisplayName                                                                    = 3723
	StateMachineType_LastTransition_ID                                                                                    = 3724
	StateMachineType_LastTransition_Name                                                                                  = 3725
	StateMachineType_LastTransition_Number                                                                                = 3726
	StateMachineType_LastTransition_TransitionTime                                                                        = 3727
	FiniteStateMachineType_CurrentState_ID                                                                                = 3728
	FiniteStateMachineType_CurrentState_Name                                                                              = 3729
	FiniteStateMachineType_CurrentState_Number                                                                            = 3730
	FiniteStateMachineType_CurrentState_EffectiveDisplayName                                                              = 3731
	FiniteStateMachineType_LastTransition_ID                                                                              = 3732
	FiniteStateMachineType_LastTransition_Name                                                                            = 3733
	FiniteStateMachineType_LastTransition_Number                                                                          = 3734
	FiniteStateMachineType_LastTransition_TransitionTime                                                                  = 3735
	InitialStateType_StateNumber                                                                                          = 3736
	TransitionEventType_EventID                                                                                           = 3737
	TransitionEventType_EventType                                                                                         = 3738
	TransitionEventType_SourceNode                                                                                        = 3739
	TransitionEventType_SourceName                                                                                        = 3740
	TransitionEventType_Time                                                                                              = 3741
	TransitionEventType_ReceiveTime                                                                                       = 3742
	TransitionEventType_LocalTime                                                                                         = 3743
	TransitionEventType_Message                                                                                           = 3744
	TransitionEventType_Severity                                                                                          = 3745
	TransitionEventType_FromState_ID                                                                                      = 3746
	TransitionEventType_FromState_Name                                                                                    = 3747
	TransitionEventType_FromState_Number                                                                                  = 3748
	TransitionEventType_FromState_EffectiveDisplayName                                                                    = 3749
	TransitionEventType_ToState_ID                                                                                        = 3750
	TransitionEventType_ToState_Name                                                                                      = 3751
	TransitionEventType_ToState_Number                                                                                    = 3752
	TransitionEventType_ToState_EffectiveDisplayName                                                                      = 3753
	TransitionEventType_Transition_ID                                                                                     = 3754
	TransitionEventType_Transition_Name                                                                                   = 3755
	TransitionEventType_Transition_Number                                                                                 = 3756
	TransitionEventType_Transition_TransitionTime                                                                         = 3757
	AuditUpdateStateEventType_EventID                                                                                     = 3758
	AuditUpdateStateEventType_EventType                                                                                   = 3759
	AuditUpdateStateEventType_SourceNode                                                                                  = 3760
	AuditUpdateStateEventType_SourceName                                                                                  = 3761
	AuditUpdateStateEventType_Time                                                                                        = 3762
	AuditUpdateStateEventType_ReceiveTime                                                                                 = 3763
	AuditUpdateStateEventType_LocalTime                                                                                   = 3764
	AuditUpdateStateEventType_Message                                                                                     = 3765
	AuditUpdateStateEventType_Severity                                                                                    = 3766
	AuditUpdateStateEventType_ActionTimeStamp                                                                             = 3767
	AuditUpdateStateEventType_Status                                                                                      = 3768
	AuditUpdateStateEventType_ServerID                                                                                    = 3769
	AuditUpdateStateEventType_ClientAuditEntryID                                                                          = 3770
	AuditUpdateStateEventType_ClientUserID                                                                                = 3771
	AuditUpdateStateEventType_MethodID                                                                                    = 3772
	AuditUpdateStateEventType_InputArguments                                                                              = 3773
	AnalogItemType_Definition                                                                                             = 3774
	AnalogItemType_ValuePrecision                                                                                         = 3775
	DiscreteItemType_Definition                                                                                           = 3776
	DiscreteItemType_ValuePrecision                                                                                       = 3777
	TwoStateDiscreteType_Definition                                                                                       = 3778
	TwoStateDiscreteType_ValuePrecision                                                                                   = 3779
	MultiStateDiscreteType_Definition                                                                                     = 3780
	MultiStateDiscreteType_ValuePrecision                                                                                 = 3781
	ProgramTransitionEventType_EventID                                                                                    = 3782
	ProgramTransitionEventType_EventType                                                                                  = 3783
	ProgramTransitionEventType_SourceNode                                                                                 = 3784
	ProgramTransitionEventType_SourceName                                                                                 = 3785
	ProgramTransitionEventType_Time                                                                                       = 3786
	ProgramTransitionEventType_ReceiveTime                                                                                = 3787
	ProgramTransitionEventType_LocalTime                                                                                  = 3788
	ProgramTransitionEventType_Message                                                                                    = 3789
	ProgramTransitionEventType_Severity                                                                                   = 3790
	ProgramTransitionEventType_FromState                                                                                  = 3791
	ProgramTransitionEventType_FromState_ID                                                                               = 3792
	ProgramTransitionEventType_FromState_Name                                                                             = 3793
	ProgramTransitionEventType_FromState_Number                                                                           = 3794
	ProgramTransitionEventType_FromState_EffectiveDisplayName                                                             = 3795
	ProgramTransitionEventType_ToState                                                                                    = 3796
	ProgramTransitionEventType_ToState_ID                                                                                 = 3797
	ProgramTransitionEventType_ToState_Name                                                                               = 3798
	ProgramTransitionEventType_ToState_Number                                                                             = 3799
	ProgramTransitionEventType_ToState_EffectiveDisplayName                                                               = 3800
	ProgramTransitionEventType_Transition                                                                                 = 3801
	ProgramTransitionEventType_Transition_ID                                                                              = 3802
	ProgramTransitionEventType_Transition_Name                                                                            = 3803
	ProgramTransitionEventType_Transition_Number                                                                          = 3804
	ProgramTransitionEventType_Transition_TransitionTime                                                                  = 3805
	ProgramTransitionAuditEventType                                                                                       = 3806
	ProgramTransitionAuditEventType_EventID                                                                               = 3807
	ProgramTransitionAuditEventType_EventType                                                                             = 3808
	ProgramTransitionAuditEventType_SourceNode                                                                            = 3809
	ProgramTransitionAuditEventType_SourceName                                                                            = 3810
	ProgramTransitionAuditEventType_Time                                                                                  = 3811
	ProgramTransitionAuditEventType_ReceiveTime                                                                           = 3812
	ProgramTransitionAuditEventType_LocalTime                                                                             = 3813
	ProgramTransitionAuditEventType_Message                                                                               = 3814
	ProgramTransitionAuditEventType_Severity                                                                              = 3815
	ProgramTransitionAuditEventType_ActionTimeStamp                                                                       = 3816
	ProgramTransitionAuditEventType_Status                                                                                = 3817
	ProgramTransitionAuditEventType_ServerID                                                                              = 3818
	ProgramTransitionAuditEventType_ClientAuditEntryID                                                                    = 3819
	ProgramTransitionAuditEventType_ClientUserID                                                                          = 3820
	ProgramTransitionAuditEventType_MethodID                                                                              = 3821
	ProgramTransitionAuditEventType_InputArguments                                                                        = 3822
	ProgramTransitionAuditEventType_OldStateID                                                                            = 3823
	ProgramTransitionAuditEventType_NewStateID                                                                            = 3824
	ProgramTransitionAuditEventType_Transition                                                                            = 3825
	ProgramTransitionAuditEventType_Transition_ID                                                                         = 3826
	ProgramTransitionAuditEventType_Transition_Name                                                                       = 3827
	ProgramTransitionAuditEventType_Transition_Number                                                                     = 3828
	ProgramTransitionAuditEventType_Transition_TransitionTime                                                             = 3829
	ProgramStateMachineType_CurrentState                                                                                  = 3830
	ProgramStateMachineType_CurrentState_ID                                                                               = 3831
	ProgramStateMachineType_CurrentState_Name                                                                             = 3832
	ProgramStateMachineType_CurrentState_Number                                                                           = 3833
	ProgramStateMachineType_CurrentState_EffectiveDisplayName                                                             = 3834
	ProgramStateMachineType_LastTransition                                                                                = 3835
	ProgramStateMachineType_LastTransition_ID                                                                             = 3836
	ProgramStateMachineType_LastTransition_Name                                                                           = 3837
	ProgramStateMachineType_LastTransition_Number                                                                         = 3838
	ProgramStateMachineType_LastTransition_TransitionTime                                                                 = 3839
	ProgramStateMachineType_ProgramDiagnostic_CreateSessionID                                                             = 3840
	ProgramStateMachineType_ProgramDiagnostic_CreateClientName                                                            = 3841
	ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime                                                      = 3842
	ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime                                                          = 3843
	ProgramStateMachineType_ProgramDiagnostic_LastMethodCall                                                              = 3844
	ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionID                                                         = 3845
	ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments                                                    = 3846
	ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments                                                   = 3847
	ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime                                                          = 3848
	ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus                                                      = 3849
	ProgramStateMachineType_FinalResultData                                                                               = 3850
	AddCommentMethodType                                                                                                  = 3863
	AddCommentMethodType_InputArguments                                                                                   = 3864
	ConditionType_EventID                                                                                                 = 3865
	ConditionType_EventType                                                                                               = 3866
	ConditionType_SourceNode                                                                                              = 3867
	ConditionType_SourceName                                                                                              = 3868
	ConditionType_Time                                                                                                    = 3869
	ConditionType_ReceiveTime                                                                                             = 3870
	ConditionType_LocalTime                                                                                               = 3871
	ConditionType_Message                                                                                                 = 3872
	ConditionType_Severity                                                                                                = 3873
	ConditionType_Retain                                                                                                  = 3874
	ConditionType_ConditionRefresh                                                                                        = 3875
	ConditionType_ConditionRefresh_InputArguments                                                                         = 3876
	RefreshStartEventType_EventID                                                                                         = 3969
	RefreshStartEventType_EventType                                                                                       = 3970
	RefreshStartEventType_SourceNode                                                                                      = 3971
	RefreshStartEventType_SourceName                                                                                      = 3972
	RefreshStartEventType_Time                                                                                            = 3973
	RefreshStartEventType_ReceiveTime                                                                                     = 3974
	RefreshStartEventType_LocalTime                                                                                       = 3975
	RefreshStartEventType_Message                                                                                         = 3976
	RefreshStartEventType_Severity                                                                                        = 3977
	RefreshEndEventType_EventID                                                                                           = 3978
	RefreshEndEventType_EventType                                                                                         = 3979
	RefreshEndEventType_SourceNode                                                                                        = 3980
	RefreshEndEventType_SourceName                                                                                        = 3981
	RefreshEndEventType_Time                                                                                              = 3982
	RefreshEndEventType_ReceiveTime                                                                                       = 3983
	RefreshEndEventType_LocalTime                                                                                         = 3984
	RefreshEndEventType_Message                                                                                           = 3985
	RefreshEndEventType_Severity                                                                                          = 3986
	RefreshRequiredEventType_EventID                                                                                      = 3987
	RefreshRequiredEventType_EventType                                                                                    = 3988
	RefreshRequiredEventType_SourceNode                                                                                   = 3989
	RefreshRequiredEventType_SourceName                                                                                   = 3990
	RefreshRequiredEventType_Time                                                                                         = 3991
	RefreshRequiredEventType_ReceiveTime                                                                                  = 3992
	RefreshRequiredEventType_LocalTime                                                                                    = 3993
	RefreshRequiredEventType_Message                                                                                      = 3994
	RefreshRequiredEventType_Severity                                                                                     = 3995
	AuditConditionEventType_EventID                                                                                       = 3996
	AuditConditionEventType_EventType                                                                                     = 3997
	AuditConditionEventType_SourceNode                                                                                    = 3998
	AuditConditionEventType_SourceName                                                                                    = 3999
	AuditConditionEventType_Time                                                                                          = 4000
	AuditConditionEventType_ReceiveTime                                                                                   = 4001
	AuditConditionEventType_LocalTime                                                                                     = 4002
	AuditConditionEventType_Message                                                                                       = 4003
	AuditConditionEventType_Severity                                                                                      = 4004
	AuditConditionEventType_ActionTimeStamp                                                                               = 4005
	AuditConditionEventType_Status                                                                                        = 4006
	AuditConditionEventType_ServerID                                                                                      = 4007
	AuditConditionEventType_ClientAuditEntryID                                                                            = 4008
	AuditConditionEventType_ClientUserID                                                                                  = 4009
	AuditConditionEventType_MethodID                                                                                      = 4010
	AuditConditionEventType_InputArguments                                                                                = 4011
	AuditConditionEnableEventType_EventID                                                                                 = 4106
	AuditConditionEnableEventType_EventType                                                                               = 4107
	AuditConditionEnableEventType_SourceNode                                                                              = 4108
	AuditConditionEnableEventType_SourceName                                                                              = 4109
	AuditConditionEnableEventType_Time                                                                                    = 4110
	AuditConditionEnableEventType_ReceiveTime                                                                             = 4111
	AuditConditionEnableEventType_LocalTime                                                                               = 4112
	AuditConditionEnableEventType_Message                                                                                 = 4113
	AuditConditionEnableEventType_Severity                                                                                = 4114
	AuditConditionEnableEventType_ActionTimeStamp                                                                         = 4115
	AuditConditionEnableEventType_Status                                                                                  = 4116
	AuditConditionEnableEventType_ServerID                                                                                = 4117
	AuditConditionEnableEventType_ClientAuditEntryID                                                                      = 4118
	AuditConditionEnableEventType_ClientUserID                                                                            = 4119
	AuditConditionEnableEventType_MethodID                                                                                = 4120
	AuditConditionEnableEventType_InputArguments                                                                          = 4121
	AuditConditionCommentEventType_EventID                                                                                = 4170
	AuditConditionCommentEventType_EventType                                                                              = 4171
	AuditConditionCommentEventType_SourceNode                                                                             = 4172
	AuditConditionCommentEventType_SourceName                                                                             = 4173
	AuditConditionCommentEventType_Time                                                                                   = 4174
	AuditConditionCommentEventType_ReceiveTime                                                                            = 4175
	AuditConditionCommentEventType_LocalTime                                                                              = 4176
	AuditConditionCommentEventType_Message                                                                                = 4177
	AuditConditionCommentEventType_Severity                                                                               = 4178
	AuditConditionCommentEventType_ActionTimeStamp                                                                        = 4179
	AuditConditionCommentEventType_Status                                                                                 = 4180
	AuditConditionCommentEventType_ServerID                                                                               = 4181
	AuditConditionCommentEventType_ClientAuditEntryID                                                                     = 4182
	AuditConditionCommentEventType_ClientUserID                                                                           = 4183
	AuditConditionCommentEventType_MethodID                                                                               = 4184
	AuditConditionCommentEventType_InputArguments                                                                         = 4185
	DialogConditionType_EventID                                                                                           = 4188
	DialogConditionType_EventType                                                                                         = 4189
	DialogConditionType_SourceNode                                                                                        = 4190
	DialogConditionType_SourceName                                                                                        = 4191
	DialogConditionType_Time                                                                                              = 4192
	DialogConditionType_ReceiveTime                                                                                       = 4193
	DialogConditionType_LocalTime                                                                                         = 4194
	DialogConditionType_Message                                                                                           = 4195
	DialogConditionType_Severity                                                                                          = 4196
	DialogConditionType_Retain                                                                                            = 4197
	DialogConditionType_ConditionRefresh                                                                                  = 4198
	DialogConditionType_ConditionRefresh_InputArguments                                                                   = 4199
	AcknowledgeableConditionType_EventID                                                                                  = 5113
	AcknowledgeableConditionType_EventType                                                                                = 5114
	AcknowledgeableConditionType_SourceNode                                                                               = 5115
	AcknowledgeableConditionType_SourceName                                                                               = 5116
	AcknowledgeableConditionType_Time                                                                                     = 5117
	AcknowledgeableConditionType_ReceiveTime                                                                              = 5118
	AcknowledgeableConditionType_LocalTime                                                                                = 5119
	AcknowledgeableConditionType_Message                                                                                  = 5120
	AcknowledgeableConditionType_Severity                                                                                 = 5121
	AcknowledgeableConditionType_Retain                                                                                   = 5122
	AcknowledgeableConditionType_ConditionRefresh                                                                         = 5123
	AcknowledgeableConditionType_ConditionRefresh_InputArguments                                                          = 5124
	AlarmConditionType_EventID                                                                                            = 5540
	AlarmConditionType_EventType                                                                                          = 5541
	AlarmConditionType_SourceNode                                                                                         = 5542
	AlarmConditionType_SourceName                                                                                         = 5543
	AlarmConditionType_Time                                                                                               = 5544
	AlarmConditionType_ReceiveTime                                                                                        = 5545
	AlarmConditionType_LocalTime                                                                                          = 5546
	AlarmConditionType_Message                                                                                            = 5547
	AlarmConditionType_Severity                                                                                           = 5548
	AlarmConditionType_Retain                                                                                             = 5549
	AlarmConditionType_ConditionRefresh                                                                                   = 5550
	AlarmConditionType_ConditionRefresh_InputArguments                                                                    = 5551
	ShelvedStateMachineType_CurrentState                                                                                  = 6088
	ShelvedStateMachineType_CurrentState_ID                                                                               = 6089
	ShelvedStateMachineType_CurrentState_Name                                                                             = 6090
	ShelvedStateMachineType_CurrentState_Number                                                                           = 6091
	ShelvedStateMachineType_CurrentState_EffectiveDisplayName                                                             = 6092
	ShelvedStateMachineType_LastTransition                                                                                = 6093
	ShelvedStateMachineType_LastTransition_ID                                                                             = 6094
	ShelvedStateMachineType_LastTransition_Name                                                                           = 6095
	ShelvedStateMachineType_LastTransition_Number                                                                         = 6096
	ShelvedStateMachineType_LastTransition_TransitionTime                                                                 = 6097
	ShelvedStateMachineType_Unshelved_StateNumber                                                                         = 6098
	ShelvedStateMachineType_TimedShelved_StateNumber                                                                      = 6100
	ShelvedStateMachineType_OneShotShelved_StateNumber                                                                    = 6101
	TimedShelveMethodType                                                                                                 = 6102
	TimedShelveMethodType_InputArguments                                                                                  = 6103
	LimitAlarmType_EventID                                                                                                = 6116
	LimitAlarmType_EventType                                                                                              = 6117
	LimitAlarmType_SourceNode                                                                                             = 6118
	LimitAlarmType_SourceName                                                                                             = 6119
	LimitAlarmType_Time                                                                                                   = 6120
	LimitAlarmType_ReceiveTime                                                                                            = 6121
	LimitAlarmType_LocalTime                                                                                              = 6122
	LimitAlarmType_Message                                                                                                = 6123
	LimitAlarmType_Severity                                                                                               = 6124
	LimitAlarmType_Retain                                                                                                 = 6125
	LimitAlarmType_ConditionRefresh                                                                                       = 6126
	LimitAlarmType_ConditionRefresh_InputArguments                                                                        = 6127
	IDType_EnumStrings                                                                                                    = 7591
	EnumValueType                                                                                                         = 7594
	MessageSecurityMode_EnumStrings                                                                                       = 7595
	UserTokenType_EnumStrings                                                                                             = 7596
	ApplicationType_EnumStrings                                                                                           = 7597
	SecurityTokenRequestType_EnumStrings                                                                                  = 7598
	BrowseDirection_EnumStrings                                                                                           = 7603
	FilterOperator_EnumStrings                                                                                            = 7605
	TimestampsToReturn_EnumStrings                                                                                        = 7606
	MonitoringMode_EnumStrings                                                                                            = 7608
	DataChangeTrigger_EnumStrings                                                                                         = 7609
	DeadbandType_EnumStrings                                                                                              = 7610
	RedundancySupport_EnumStrings                                                                                         = 7611
	ServerState_EnumStrings                                                                                               = 7612
	ExceptionDeviationFormat_EnumStrings                                                                                  = 7614
	EnumValueType_Encoding_DefaultXML                                                                                     = 7616
	OpcUa_BinarySchema                                                                                                    = 7617
	OpcUa_BinarySchema_DataTypeVersion                                                                                    = 7618
	OpcUa_BinarySchema_NamespaceURI                                                                                       = 7619
	OpcUa_BinarySchema_Argument                                                                                           = 7650
	OpcUa_BinarySchema_Argument_DataTypeVersion                                                                           = 7651
	OpcUa_BinarySchema_Argument_DictionaryFragment                                                                        = 7652
	OpcUa_BinarySchema_EnumValueType                                                                                      = 7656
	OpcUa_BinarySchema_EnumValueType_DataTypeVersion                                                                      = 7657
	OpcUa_BinarySchema_EnumValueType_DictionaryFragment                                                                   = 7658
	OpcUa_BinarySchema_StatusResult                                                                                       = 7659
	OpcUa_BinarySchema_StatusResult_DataTypeVersion                                                                       = 7660
	OpcUa_BinarySchema_StatusResult_DictionaryFragment                                                                    = 7661
	OpcUa_BinarySchema_UserTokenPolicy                                                                                    = 7662
	OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion                                                                    = 7663
	OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment                                                                 = 7664
	OpcUa_BinarySchema_ApplicationDescription                                                                             = 7665
	OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion                                                             = 7666
	OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment                                                          = 7667
	OpcUa_BinarySchema_EndpointDescription                                                                                = 7668
	OpcUa_BinarySchema_EndpointDescription_DataTypeVersion                                                                = 7669
	OpcUa_BinarySchema_EndpointDescription_DictionaryFragment                                                             = 7670
	OpcUa_BinarySchema_UserIdentityToken                                                                                  = 7671
	OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion                                                                  = 7672
	OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment                                                               = 7673
	OpcUa_BinarySchema_AnonymousIdentityToken                                                                             = 7674
	OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion                                                             = 7675
	OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment                                                          = 7676
	OpcUa_BinarySchema_UserNameIdentityToken                                                                              = 7677
	OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion                                                              = 7678
	OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment                                                           = 7679
	OpcUa_BinarySchema_X509IdentityToken                                                                                  = 7680
	OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion                                                                  = 7681
	OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment                                                               = 7682
	OpcUa_BinarySchema_IssuedIdentityToken                                                                                = 7683
	OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion                                                                = 7684
	OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment                                                             = 7685
	OpcUa_BinarySchema_EndpointConfiguration                                                                              = 7686
	OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion                                                              = 7687
	OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment                                                           = 7688
	OpcUa_BinarySchema_BuildInfo                                                                                          = 7692
	OpcUa_BinarySchema_BuildInfo_DataTypeVersion                                                                          = 7693
	OpcUa_BinarySchema_BuildInfo_DictionaryFragment                                                                       = 7694
	OpcUa_BinarySchema_SignedSoftwareCertificate                                                                          = 7698
	OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion                                                          = 7699
	OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment                                                       = 7700
	OpcUa_BinarySchema_AddNodesItem                                                                                       = 7728
	OpcUa_BinarySchema_AddNodesItem_DataTypeVersion                                                                       = 7729
	OpcUa_BinarySchema_AddNodesItem_DictionaryFragment                                                                    = 7730
	OpcUa_BinarySchema_AddReferencesItem                                                                                  = 7731
	OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion                                                                  = 7732
	OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment                                                               = 7733
	OpcUa_BinarySchema_DeleteNodesItem                                                                                    = 7734
	OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion                                                                    = 7735
	OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment                                                                 = 7736
	OpcUa_BinarySchema_DeleteReferencesItem                                                                               = 7737
	OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion                                                               = 7738
	OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment                                                            = 7739
	OpcUa_BinarySchema_RegisteredServer                                                                                   = 7782
	OpcUa_BinarySchema_RegisteredServer_DataTypeVersion                                                                   = 7783
	OpcUa_BinarySchema_RegisteredServer_DictionaryFragment                                                                = 7784
	OpcUa_BinarySchema_ContentFilterElement                                                                               = 7929
	OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion                                                               = 7930
	OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment                                                            = 7931
	OpcUa_BinarySchema_ContentFilter                                                                                      = 7932
	OpcUa_BinarySchema_ContentFilter_DataTypeVersion                                                                      = 7933
	OpcUa_BinarySchema_ContentFilter_DictionaryFragment                                                                   = 7934
	OpcUa_BinarySchema_FilterOperand                                                                                      = 7935
	OpcUa_BinarySchema_FilterOperand_DataTypeVersion                                                                      = 7936
	OpcUa_BinarySchema_FilterOperand_DictionaryFragment                                                                   = 7937
	OpcUa_BinarySchema_ElementOperand                                                                                     = 7938
	OpcUa_BinarySchema_ElementOperand_DataTypeVersion                                                                     = 7939
	OpcUa_BinarySchema_ElementOperand_DictionaryFragment                                                                  = 7940
	OpcUa_BinarySchema_LiteralOperand                                                                                     = 7941
	OpcUa_BinarySchema_LiteralOperand_DataTypeVersion                                                                     = 7942
	OpcUa_BinarySchema_LiteralOperand_DictionaryFragment                                                                  = 7943
	OpcUa_BinarySchema_AttributeOperand                                                                                   = 7944
	OpcUa_BinarySchema_AttributeOperand_DataTypeVersion                                                                   = 7945
	OpcUa_BinarySchema_AttributeOperand_DictionaryFragment                                                                = 7946
	OpcUa_BinarySchema_SimpleAttributeOperand                                                                             = 7947
	OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion                                                             = 7948
	OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment                                                          = 7949
	OpcUa_BinarySchema_HistoryEvent                                                                                       = 8004
	OpcUa_BinarySchema_HistoryEvent_DataTypeVersion                                                                       = 8005
	OpcUa_BinarySchema_HistoryEvent_DictionaryFragment                                                                    = 8006
	OpcUa_BinarySchema_MonitoringFilter                                                                                   = 8067
	OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion                                                                   = 8068
	OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment                                                                = 8069
	OpcUa_BinarySchema_EventFilter                                                                                        = 8073
	OpcUa_BinarySchema_EventFilter_DataTypeVersion                                                                        = 8074
	OpcUa_BinarySchema_EventFilter_DictionaryFragment                                                                     = 8075
	OpcUa_BinarySchema_AggregateConfiguration                                                                             = 8076
	OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion                                                             = 8077
	OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment                                                          = 8078
	OpcUa_BinarySchema_HistoryEventFieldList                                                                              = 8172
	OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion                                                              = 8173
	OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment                                                           = 8174
	OpcUa_BinarySchema_RedundantServerDataType                                                                            = 8208
	OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion                                                            = 8209
	OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment                                                         = 8210
	OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType                                                                = 8211
	OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion                                                = 8212
	OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment                                             = 8213
	OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType                                                                   = 8214
	OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion                                                   = 8215
	OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment                                                = 8216
	OpcUa_BinarySchema_ServerStatusDataType                                                                               = 8217
	OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion                                                               = 8218
	OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment                                                            = 8219
	OpcUa_BinarySchema_SessionDiagnosticsDataType                                                                         = 8220
	OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion                                                         = 8221
	OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment                                                      = 8222
	OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType                                                                 = 8223
	OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion                                                 = 8224
	OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment                                              = 8225
	OpcUa_BinarySchema_ServiceCounterDataType                                                                             = 8226
	OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion                                                             = 8227
	OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment                                                          = 8228
	OpcUa_BinarySchema_SubscriptionDiagnosticsDataType                                                                    = 8229
	OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion                                                    = 8230
	OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment                                                 = 8231
	OpcUa_BinarySchema_ModelChangeStructureDataType                                                                       = 8232
	OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion                                                       = 8233
	OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment                                                    = 8234
	OpcUa_BinarySchema_SemanticChangeStructureDataType                                                                    = 8235
	OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion                                                    = 8236
	OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment                                                 = 8237
	OpcUa_BinarySchema_Range                                                                                              = 8238
	OpcUa_BinarySchema_Range_DataTypeVersion                                                                              = 8239
	OpcUa_BinarySchema_Range_DictionaryFragment                                                                           = 8240
	OpcUa_BinarySchema_EUInformation                                                                                      = 8241
	OpcUa_BinarySchema_EUInformation_DataTypeVersion                                                                      = 8242
	OpcUa_BinarySchema_EUInformation_DictionaryFragment                                                                   = 8243
	OpcUa_BinarySchema_Annotation                                                                                         = 8244
	OpcUa_BinarySchema_Annotation_DataTypeVersion                                                                         = 8245
	OpcUa_BinarySchema_Annotation_DictionaryFragment                                                                      = 8246
	OpcUa_BinarySchema_ProgramDiagnosticDataType                                                                          = 8247
	OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion                                                          = 8248
	OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment                                                       = 8249
	EnumValueType_Encoding_DefaultBinary                                                                                  = 8251
	OpcUa_XMLSchema                                                                                                       = 8252
	OpcUa_XMLSchema_DataTypeVersion                                                                                       = 8253
	OpcUa_XMLSchema_NamespaceURI                                                                                          = 8254
	OpcUa_XMLSchema_Argument                                                                                              = 8285
	OpcUa_XMLSchema_Argument_DataTypeVersion                                                                              = 8286
	OpcUa_XMLSchema_Argument_DictionaryFragment                                                                           = 8287
	OpcUa_XMLSchema_EnumValueType                                                                                         = 8291
	OpcUa_XMLSchema_EnumValueType_DataTypeVersion                                                                         = 8292
	OpcUa_XMLSchema_EnumValueType_DictionaryFragment                                                                      = 8293
	OpcUa_XMLSchema_StatusResult                                                                                          = 8294
	OpcUa_XMLSchema_StatusResult_DataTypeVersion                                                                          = 8295
	OpcUa_XMLSchema_StatusResult_DictionaryFragment                                                                       = 8296
	OpcUa_XMLSchema_UserTokenPolicy                                                                                       = 8297
	OpcUa_XMLSchema_UserTokenPolicy_DataTypeVersion                                                                       = 8298
	OpcUa_XMLSchema_UserTokenPolicy_DictionaryFragment                                                                    = 8299
	OpcUa_XMLSchema_ApplicationDescription                                                                                = 8300
	OpcUa_XMLSchema_ApplicationDescription_DataTypeVersion                                                                = 8301
	OpcUa_XMLSchema_ApplicationDescription_DictionaryFragment                                                             = 8302
	OpcUa_XMLSchema_EndpointDescription                                                                                   = 8303
	OpcUa_XMLSchema_EndpointDescription_DataTypeVersion                                                                   = 8304
	OpcUa_XMLSchema_EndpointDescription_DictionaryFragment                                                                = 8305
	OpcUa_XMLSchema_UserIdentityToken                                                                                     = 8306
	OpcUa_XMLSchema_UserIdentityToken_DataTypeVersion                                                                     = 8307
	OpcUa_XMLSchema_UserIdentityToken_DictionaryFragment                                                                  = 8308
	OpcUa_XMLSchema_AnonymousIdentityToken                                                                                = 8309
	OpcUa_XMLSchema_AnonymousIdentityToken_DataTypeVersion                                                                = 8310
	OpcUa_XMLSchema_AnonymousIdentityToken_DictionaryFragment                                                             = 8311
	OpcUa_XMLSchema_UserNameIdentityToken                                                                                 = 8312
	OpcUa_XMLSchema_UserNameIdentityToken_DataTypeVersion                                                                 = 8313
	OpcUa_XMLSchema_UserNameIdentityToken_DictionaryFragment                                                              = 8314
	OpcUa_XMLSchema_X509IdentityToken                                                                                     = 8315
	OpcUa_XMLSchema_X509IdentityToken_DataTypeVersion                                                                     = 8316
	OpcUa_XMLSchema_X509IdentityToken_DictionaryFragment                                                                  = 8317
	OpcUa_XMLSchema_IssuedIdentityToken                                                                                   = 8318
	OpcUa_XMLSchema_IssuedIdentityToken_DataTypeVersion                                                                   = 8319
	OpcUa_XMLSchema_IssuedIdentityToken_DictionaryFragment                                                                = 8320
	OpcUa_XMLSchema_EndpointConfiguration                                                                                 = 8321
	OpcUa_XMLSchema_EndpointConfiguration_DataTypeVersion                                                                 = 8322
	OpcUa_XMLSchema_EndpointConfiguration_DictionaryFragment                                                              = 8323
	OpcUa_XMLSchema_BuildInfo                                                                                             = 8327
	OpcUa_XMLSchema_BuildInfo_DataTypeVersion                                                                             = 8328
	OpcUa_XMLSchema_BuildInfo_DictionaryFragment                                                                          = 8329
	OpcUa_XMLSchema_SignedSoftwareCertificate                                                                             = 8333
	OpcUa_XMLSchema_SignedSoftwareCertificate_DataTypeVersion                                                             = 8334
	OpcUa_XMLSchema_SignedSoftwareCertificate_DictionaryFragment                                                          = 8335
	OpcUa_XMLSchema_AddNodesItem                                                                                          = 8363
	OpcUa_XMLSchema_AddNodesItem_DataTypeVersion                                                                          = 8364
	OpcUa_XMLSchema_AddNodesItem_DictionaryFragment                                                                       = 8365
	OpcUa_XMLSchema_AddReferencesItem                                                                                     = 8366
	OpcUa_XMLSchema_AddReferencesItem_DataTypeVersion                                                                     = 8367
	OpcUa_XMLSchema_AddReferencesItem_DictionaryFragment                                                                  = 8368
	OpcUa_XMLSchema_DeleteNodesItem                                                                                       = 8369
	OpcUa_XMLSchema_DeleteNodesItem_DataTypeVersion                                                                       = 8370
	OpcUa_XMLSchema_DeleteNodesItem_DictionaryFragment                                                                    = 8371
	OpcUa_XMLSchema_DeleteReferencesItem                                                                                  = 8372
	OpcUa_XMLSchema_DeleteReferencesItem_DataTypeVersion                                                                  = 8373
	OpcUa_XMLSchema_DeleteReferencesItem_DictionaryFragment                                                               = 8374
	OpcUa_XMLSchema_RegisteredServer                                                                                      = 8417
	OpcUa_XMLSchema_RegisteredServer_DataTypeVersion                                                                      = 8418
	OpcUa_XMLSchema_RegisteredServer_DictionaryFragment                                                                   = 8419
	OpcUa_XMLSchema_ContentFilterElement                                                                                  = 8564
	OpcUa_XMLSchema_ContentFilterElement_DataTypeVersion                                                                  = 8565
	OpcUa_XMLSchema_ContentFilterElement_DictionaryFragment                                                               = 8566
	OpcUa_XMLSchema_ContentFilter                                                                                         = 8567
	OpcUa_XMLSchema_ContentFilter_DataTypeVersion                                                                         = 8568
	OpcUa_XMLSchema_ContentFilter_DictionaryFragment                                                                      = 8569
	OpcUa_XMLSchema_FilterOperand                                                                                         = 8570
	OpcUa_XMLSchema_FilterOperand_DataTypeVersion                                                                         = 8571
	OpcUa_XMLSchema_FilterOperand_DictionaryFragment                                                                      = 8572
	OpcUa_XMLSchema_ElementOperand                                                                                        = 8573
	OpcUa_XMLSchema_ElementOperand_DataTypeVersion                                                                        = 8574
	OpcUa_XMLSchema_ElementOperand_DictionaryFragment                                                                     = 8575
	OpcUa_XMLSchema_LiteralOperand                                                                                        = 8576
	OpcUa_XMLSchema_LiteralOperand_DataTypeVersion                                                                        = 8577
	OpcUa_XMLSchema_LiteralOperand_DictionaryFragment                                                                     = 8578
	OpcUa_XMLSchema_AttributeOperand                                                                                      = 8579
	OpcUa_XMLSchema_AttributeOperand_DataTypeVersion                                                                      = 8580
	OpcUa_XMLSchema_AttributeOperand_DictionaryFragment                                                                   = 8581
	OpcUa_XMLSchema_SimpleAttributeOperand                                                                                = 8582
	OpcUa_XMLSchema_SimpleAttributeOperand_DataTypeVersion                                                                = 8583
	OpcUa_XMLSchema_SimpleAttributeOperand_DictionaryFragment                                                             = 8584
	OpcUa_XMLSchema_HistoryEvent                                                                                          = 8639
	OpcUa_XMLSchema_HistoryEvent_DataTypeVersion                                                                          = 8640
	OpcUa_XMLSchema_HistoryEvent_DictionaryFragment                                                                       = 8641
	OpcUa_XMLSchema_MonitoringFilter                                                                                      = 8702
	OpcUa_XMLSchema_MonitoringFilter_DataTypeVersion                                                                      = 8703
	OpcUa_XMLSchema_MonitoringFilter_DictionaryFragment                                                                   = 8704
	OpcUa_XMLSchema_EventFilter                                                                                           = 8708
	OpcUa_XMLSchema_EventFilter_DataTypeVersion                                                                           = 8709
	OpcUa_XMLSchema_EventFilter_DictionaryFragment                                                                        = 8710
	OpcUa_XMLSchema_AggregateConfiguration                                                                                = 8711
	OpcUa_XMLSchema_AggregateConfiguration_DataTypeVersion                                                                = 8712
	OpcUa_XMLSchema_AggregateConfiguration_DictionaryFragment                                                             = 8713
	OpcUa_XMLSchema_HistoryEventFieldList                                                                                 = 8807
	OpcUa_XMLSchema_HistoryEventFieldList_DataTypeVersion                                                                 = 8808
	OpcUa_XMLSchema_HistoryEventFieldList_DictionaryFragment                                                              = 8809
	OpcUa_XMLSchema_RedundantServerDataType                                                                               = 8843
	OpcUa_XMLSchema_RedundantServerDataType_DataTypeVersion                                                               = 8844
	OpcUa_XMLSchema_RedundantServerDataType_DictionaryFragment                                                            = 8845
	OpcUa_XMLSchema_SamplingIntervalDiagnosticsDataType                                                                   = 8846
	OpcUa_XMLSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion                                                   = 8847
	OpcUa_XMLSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment                                                = 8848
	OpcUa_XMLSchema_ServerDiagnosticsSummaryDataType                                                                      = 8849
	OpcUa_XMLSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion                                                      = 8850
	OpcUa_XMLSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment                                                   = 8851
	OpcUa_XMLSchema_ServerStatusDataType                                                                                  = 8852
	OpcUa_XMLSchema_ServerStatusDataType_DataTypeVersion                                                                  = 8853
	OpcUa_XMLSchema_ServerStatusDataType_DictionaryFragment                                                               = 8854
	OpcUa_XMLSchema_SessionDiagnosticsDataType                                                                            = 8855
	OpcUa_XMLSchema_SessionDiagnosticsDataType_DataTypeVersion                                                            = 8856
	OpcUa_XMLSchema_SessionDiagnosticsDataType_DictionaryFragment                                                         = 8857
	OpcUa_XMLSchema_SessionSecurityDiagnosticsDataType                                                                    = 8858
	OpcUa_XMLSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion                                                    = 8859
	OpcUa_XMLSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment                                                 = 8860
	OpcUa_XMLSchema_ServiceCounterDataType                                                                                = 8861
	OpcUa_XMLSchema_ServiceCounterDataType_DataTypeVersion                                                                = 8862
	OpcUa_XMLSchema_ServiceCounterDataType_DictionaryFragment                                                             = 8863
	OpcUa_XMLSchema_SubscriptionDiagnosticsDataType                                                                       = 8864
	OpcUa_XMLSchema_SubscriptionDiagnosticsDataType_DataTypeVersion                                                       = 8865
	OpcUa_XMLSchema_SubscriptionDiagnosticsDataType_DictionaryFragment                                                    = 8866
	OpcUa_XMLSchema_ModelChangeStructureDataType                                                                          = 8867
	OpcUa_XMLSchema_ModelChangeStructureDataType_DataTypeVersion                                                          = 8868
	OpcUa_XMLSchema_ModelChangeStructureDataType_DictionaryFragment                                                       = 8869
	OpcUa_XMLSchema_SemanticChangeStructureDataType                                                                       = 8870
	OpcUa_XMLSchema_SemanticChangeStructureDataType_DataTypeVersion                                                       = 8871
	OpcUa_XMLSchema_SemanticChangeStructureDataType_DictionaryFragment                                                    = 8872
	OpcUa_XMLSchema_Range                                                                                                 = 8873
	OpcUa_XMLSchema_Range_DataTypeVersion                                                                                 = 8874
	OpcUa_XMLSchema_Range_DictionaryFragment                                                                              = 8875
	OpcUa_XMLSchema_EUInformation                                                                                         = 8876
	OpcUa_XMLSchema_EUInformation_DataTypeVersion                                                                         = 8877
	OpcUa_XMLSchema_EUInformation_DictionaryFragment                                                                      = 8878
	OpcUa_XMLSchema_Annotation                                                                                            = 8879
	OpcUa_XMLSchema_Annotation_DataTypeVersion                                                                            = 8880
	OpcUa_XMLSchema_Annotation_DictionaryFragment                                                                         = 8881
	OpcUa_XMLSchema_ProgramDiagnosticDataType                                                                             = 8882
	OpcUa_XMLSchema_ProgramDiagnosticDataType_DataTypeVersion                                                             = 8883
	OpcUa_XMLSchema_ProgramDiagnosticDataType_DictionaryFragment                                                          = 8884
	SubscriptionDiagnosticsType_MaxLifetimeCount                                                                          = 8888
	SubscriptionDiagnosticsType_LatePublishRequestCount                                                                   = 8889
	SubscriptionDiagnosticsType_CurrentKeepAliveCount                                                                     = 8890
	SubscriptionDiagnosticsType_CurrentLifetimeCount                                                                      = 8891
	SubscriptionDiagnosticsType_UnacknowledgedMessageCount                                                                = 8892
	SubscriptionDiagnosticsType_DiscardedMessageCount                                                                     = 8893
	SubscriptionDiagnosticsType_MonitoredItemCount                                                                        = 8894
	SubscriptionDiagnosticsType_DisabledMonitoredItemCount                                                                = 8895
	SubscriptionDiagnosticsType_MonitoringQueueOverflowCount                                                              = 8896
	SubscriptionDiagnosticsType_NextSequenceNumber                                                                        = 8897
	SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount                                                     = 8898
	SessionDiagnosticsVariableType_TotalRequestCount                                                                      = 8900
	SubscriptionDiagnosticsType_EventQueueOverflowCount                                                                   = 8902
	TimeZoneDataType                                                                                                      = 8912
	TimeZoneDataType_Encoding_DefaultXML                                                                                  = 8913
	OpcUa_BinarySchema_TimeZoneDataType                                                                                   = 8914
	OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion                                                                   = 8915
	OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment                                                                = 8916
	TimeZoneDataType_Encoding_DefaultBinary                                                                               = 8917
	OpcUa_XMLSchema_TimeZoneDataType                                                                                      = 8918
	OpcUa_XMLSchema_TimeZoneDataType_DataTypeVersion                                                                      = 8919
	OpcUa_XMLSchema_TimeZoneDataType_DictionaryFragment                                                                   = 8920
	AuditConditionRespondEventType                                                                                        = 8927
	AuditConditionRespondEventType_EventID                                                                                = 8928
	AuditConditionRespondEventType_EventType                                                                              = 8929
	AuditConditionRespondEventType_SourceNode                                                                             = 8930
	AuditConditionRespondEventType_SourceName                                                                             = 8931
	AuditConditionRespondEventType_Time                                                                                   = 8932
	AuditConditionRespondEventType_ReceiveTime                                                                            = 8933
	AuditConditionRespondEventType_LocalTime                                                                              = 8934
	AuditConditionRespondEventType_Message                                                                                = 8935
	AuditConditionRespondEventType_Severity                                                                               = 8936
	AuditConditionRespondEventType_ActionTimeStamp                                                                        = 8937
	AuditConditionRespondEventType_Status                                                                                 = 8938
	AuditConditionRespondEventType_ServerID                                                                               = 8939
	AuditConditionRespondEventType_ClientAuditEntryID                                                                     = 8940
	AuditConditionRespondEventType_ClientUserID                                                                           = 8941
	AuditConditionRespondEventType_MethodID                                                                               = 8942
	AuditConditionRespondEventType_InputArguments                                                                         = 8943
	AuditConditionAcknowledgeEventType                                                                                    = 8944
	AuditConditionAcknowledgeEventType_EventID                                                                            = 8945
	AuditConditionAcknowledgeEventType_EventType                                                                          = 8946
	AuditConditionAcknowledgeEventType_SourceNode                                                                         = 8947
	AuditConditionAcknowledgeEventType_SourceName                                                                         = 8948
	AuditConditionAcknowledgeEventType_Time                                                                               = 8949
	AuditConditionAcknowledgeEventType_ReceiveTime                                                                        = 8950
	AuditConditionAcknowledgeEventType_LocalTime                                                                          = 8951
	AuditConditionAcknowledgeEventType_Message                                                                            = 8952
	AuditConditionAcknowledgeEventType_Severity                                                                           = 8953
	AuditConditionAcknowledgeEventType_ActionTimeStamp                                                                    = 8954
	AuditConditionAcknowledgeEventType_Status                                                                             = 8955
	AuditConditionAcknowledgeEventType_ServerID                                                                           = 8956
	AuditConditionAcknowledgeEventType_ClientAuditEntryID                                                                 = 8957
	AuditConditionAcknowledgeEventType_ClientUserID                                                                       = 8958
	AuditConditionAcknowledgeEventType_MethodID                                                                           = 8959
	AuditConditionAcknowledgeEventType_InputArguments                                                                     = 8960
	AuditConditionConfirmEventType                                                                                        = 8961
	AuditConditionConfirmEventType_EventID                                                                                = 8962
	AuditConditionConfirmEventType_EventType                                                                              = 8963
	AuditConditionConfirmEventType_SourceNode                                                                             = 8964
	AuditConditionConfirmEventType_SourceName                                                                             = 8965
	AuditConditionConfirmEventType_Time                                                                                   = 8966
	AuditConditionConfirmEventType_ReceiveTime                                                                            = 8967
	AuditConditionConfirmEventType_LocalTime                                                                              = 8968
	AuditConditionConfirmEventType_Message                                                                                = 8969
	AuditConditionConfirmEventType_Severity                                                                               = 8970
	AuditConditionConfirmEventType_ActionTimeStamp                                                                        = 8971
	AuditConditionConfirmEventType_Status                                                                                 = 8972
	AuditConditionConfirmEventType_ServerID                                                                               = 8973
	AuditConditionConfirmEventType_ClientAuditEntryID                                                                     = 8974
	AuditConditionConfirmEventType_ClientUserID                                                                           = 8975
	AuditConditionConfirmEventType_MethodID                                                                               = 8976
	AuditConditionConfirmEventType_InputArguments                                                                         = 8977
	TwoStateVariableType                                                                                                  = 8995
	TwoStateVariableType_ID                                                                                               = 8996
	TwoStateVariableType_Name                                                                                             = 8997
	TwoStateVariableType_Number                                                                                           = 8998
	TwoStateVariableType_EffectiveDisplayName                                                                             = 8999
	TwoStateVariableType_TransitionTime                                                                                   = 9000
	TwoStateVariableType_EffectiveTransitionTime                                                                          = 9001
	ConditionVariableType                                                                                                 = 9002
	ConditionVariableType_SourceTimestamp                                                                                 = 9003
	HasTrueSubState                                                                                                       = 9004
	HasFalseSubState                                                                                                      = 9005
	HasCondition                                                                                                          = 9006
	ConditionRefreshMethodType                                                                                            = 9007
	ConditionRefreshMethodType_InputArguments                                                                             = 9008
	ConditionType_ConditionName                                                                                           = 9009
	ConditionType_BranchID                                                                                                = 9010
	ConditionType_EnabledState                                                                                            = 9011
	ConditionType_EnabledState_ID                                                                                         = 9012
	ConditionType_EnabledState_Name                                                                                       = 9013
	ConditionType_EnabledState_Number                                                                                     = 9014
	ConditionType_EnabledState_EffectiveDisplayName                                                                       = 9015
	ConditionType_EnabledState_TransitionTime                                                                             = 9016
	ConditionType_EnabledState_EffectiveTransitionTime                                                                    = 9017
	ConditionType_EnabledState_TrueState                                                                                  = 9018
	ConditionType_EnabledState_FalseState                                                                                 = 9019
	ConditionType_Quality                                                                                                 = 9020
	ConditionType_Quality_SourceTimestamp                                                                                 = 9021
	ConditionType_LastSeverity                                                                                            = 9022
	ConditionType_LastSeverity_SourceTimestamp                                                                            = 9023
	ConditionType_Comment                                                                                                 = 9024
	ConditionType_Comment_SourceTimestamp                                                                                 = 9025
	ConditionType_ClientUserID                                                                                            = 9026
	ConditionType_Enable                                                                                                  = 9027
	ConditionType_Disable                                                                                                 = 9028
	ConditionType_AddComment                                                                                              = 9029
	ConditionType_AddComment_InputArguments                                                                               = 9030
	DialogResponseMethodType                                                                                              = 9031
	DialogResponseMethodType_InputArguments                                                                               = 9032
	DialogConditionType_ConditionName                                                                                     = 9033
	DialogConditionType_BranchID                                                                                          = 9034
	DialogConditionType_EnabledState                                                                                      = 9035
	DialogConditionType_EnabledState_ID                                                                                   = 9036
	DialogConditionType_EnabledState_Name                                                                                 = 9037
	DialogConditionType_EnabledState_Number                                                                               = 9038
	DialogConditionType_EnabledState_EffectiveDisplayName                                                                 = 9039
	DialogConditionType_EnabledState_TransitionTime                                                                       = 9040
	DialogConditionType_EnabledState_EffectiveTransitionTime                                                              = 9041
	DialogConditionType_EnabledState_TrueState                                                                            = 9042
	DialogConditionType_EnabledState_FalseState                                                                           = 9043
	DialogConditionType_Quality                                                                                           = 9044
	DialogConditionType_Quality_SourceTimestamp                                                                           = 9045
	DialogConditionType_LastSeverity                                                                                      = 9046
	DialogConditionType_LastSeverity_SourceTimestamp                                                                      = 9047
	DialogConditionType_Comment                                                                                           = 9048
	DialogConditionType_Comment_SourceTimestamp                                                                           = 9049
	DialogConditionType_ClientUserID                                                                                      = 9050
	DialogConditionType_Enable                                                                                            = 9051
	DialogConditionType_Disable                                                                                           = 9052
	DialogConditionType_AddComment                                                                                        = 9053
	DialogConditionType_AddComment_InputArguments                                                                         = 9054
	DialogConditionType_DialogState                                                                                       = 9055
	DialogConditionType_DialogState_ID                                                                                    = 9056
	DialogConditionType_DialogState_Name                                                                                  = 9057
	DialogConditionType_DialogState_Number                                                                                = 9058
	DialogConditionType_DialogState_EffectiveDisplayName                                                                  = 9059
	DialogConditionType_DialogState_TransitionTime                                                                        = 9060
	DialogConditionType_DialogState_EffectiveTransitionTime                                                               = 9061
	DialogConditionType_DialogState_TrueState                                                                             = 9062
	DialogConditionType_DialogState_FalseState                                                                            = 9063
	DialogConditionType_ResponseOptionSet                                                                                 = 9064
	DialogConditionType_DefaultResponse                                                                                   = 9065
	DialogConditionType_OkResponse                                                                                        = 9066
	DialogConditionType_CancelResponse                                                                                    = 9067
	DialogConditionType_LastResponse                                                                                      = 9068
	DialogConditionType_Respond                                                                                           = 9069
	DialogConditionType_Respond_InputArguments                                                                            = 9070
	AcknowledgeableConditionType_ConditionName                                                                            = 9071
	AcknowledgeableConditionType_BranchID                                                                                 = 9072
	AcknowledgeableConditionType_EnabledState                                                                             = 9073
	AcknowledgeableConditionType_EnabledState_ID                                                                          = 9074
	AcknowledgeableConditionType_EnabledState_Name                                                                        = 9075
	AcknowledgeableConditionType_EnabledState_Number                                                                      = 9076
	AcknowledgeableConditionType_EnabledState_EffectiveDisplayName                                                        = 9077
	AcknowledgeableConditionType_EnabledState_TransitionTime                                                              = 9078
	AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime                                                     = 9079
	AcknowledgeableConditionType_EnabledState_TrueState                                                                   = 9080
	AcknowledgeableConditionType_EnabledState_FalseState                                                                  = 9081
	AcknowledgeableConditionType_Quality                                                                                  = 9082
	AcknowledgeableConditionType_Quality_SourceTimestamp                                                                  = 9083
	AcknowledgeableConditionType_LastSeverity                                                                             = 9084
	AcknowledgeableConditionType_LastSeverity_SourceTimestamp                                                             = 9085
	AcknowledgeableConditionType_Comment                                                                                  = 9086
	AcknowledgeableConditionType_Comment_SourceTimestamp                                                                  = 9087
	AcknowledgeableConditionType_ClientUserID                                                                             = 9088
	AcknowledgeableConditionType_Enable                                                                                   = 9089
	AcknowledgeableConditionType_Disable                                                                                  = 9090
	AcknowledgeableConditionType_AddComment                                                                               = 9091
	AcknowledgeableConditionType_AddComment_InputArguments                                                                = 9092
	AcknowledgeableConditionType_AckedState                                                                               = 9093
	AcknowledgeableConditionType_AckedState_ID                                                                            = 9094
	AcknowledgeableConditionType_AckedState_Name                                                                          = 9095
	AcknowledgeableConditionType_AckedState_Number                                                                        = 9096
	AcknowledgeableConditionType_AckedState_EffectiveDisplayName                                                          = 9097
	AcknowledgeableConditionType_AckedState_TransitionTime                                                                = 9098
	AcknowledgeableConditionType_AckedState_EffectiveTransitionTime                                                       = 9099
	AcknowledgeableConditionType_AckedState_TrueState                                                                     = 9100
	AcknowledgeableConditionType_AckedState_FalseState                                                                    = 9101
	AcknowledgeableConditionType_ConfirmedState                                                                           = 9102
	AcknowledgeableConditionType_ConfirmedState_ID                                                                        = 9103
	AcknowledgeableConditionType_ConfirmedState_Name                                                                      = 9104
	AcknowledgeableConditionType_ConfirmedState_Number                                                                    = 9105
	AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName                                                      = 9106
	AcknowledgeableConditionType_ConfirmedState_TransitionTime                                                            = 9107
	AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime                                                   = 9108
	AcknowledgeableConditionType_ConfirmedState_TrueState                                                                 = 9109
	AcknowledgeableConditionType_ConfirmedState_FalseState                                                                = 9110
	AcknowledgeableConditionType_Acknowledge                                                                              = 9111
	AcknowledgeableConditionType_Acknowledge_InputArguments                                                               = 9112
	AcknowledgeableConditionType_Confirm                                                                                  = 9113
	AcknowledgeableConditionType_Confirm_InputArguments                                                                   = 9114
	ShelvedStateMachineType_UnshelveTime                                                                                  = 9115
	AlarmConditionType_ConditionName                                                                                      = 9116
	AlarmConditionType_BranchID                                                                                           = 9117
	AlarmConditionType_EnabledState                                                                                       = 9118
	AlarmConditionType_EnabledState_ID                                                                                    = 9119
	AlarmConditionType_EnabledState_Name                                                                                  = 9120
	AlarmConditionType_EnabledState_Number                                                                                = 9121
	AlarmConditionType_EnabledState_EffectiveDisplayName                                                                  = 9122
	AlarmConditionType_EnabledState_TransitionTime                                                                        = 9123
	AlarmConditionType_EnabledState_EffectiveTransitionTime                                                               = 9124
	AlarmConditionType_EnabledState_TrueState                                                                             = 9125
	AlarmConditionType_EnabledState_FalseState                                                                            = 9126
	AlarmConditionType_Quality                                                                                            = 9127
	AlarmConditionType_Quality_SourceTimestamp                                                                            = 9128
	AlarmConditionType_LastSeverity                                                                                       = 9129
	AlarmConditionType_LastSeverity_SourceTimestamp                                                                       = 9130
	AlarmConditionType_Comment                                                                                            = 9131
	AlarmConditionType_Comment_SourceTimestamp                                                                            = 9132
	AlarmConditionType_ClientUserID                                                                                       = 9133
	AlarmConditionType_Enable                                                                                             = 9134
	AlarmConditionType_Disable                                                                                            = 9135
	AlarmConditionType_AddComment                                                                                         = 9136
	AlarmConditionType_AddComment_InputArguments                                                                          = 9137
	AlarmConditionType_AckedState                                                                                         = 9138
	AlarmConditionType_AckedState_ID                                                                                      = 9139
	AlarmConditionType_AckedState_Name                                                                                    = 9140
	AlarmConditionType_AckedState_Number                                                                                  = 9141
	AlarmConditionType_AckedState_EffectiveDisplayName                                                                    = 9142
	AlarmConditionType_AckedState_TransitionTime                                                                          = 9143
	AlarmConditionType_AckedState_EffectiveTransitionTime                                                                 = 9144
	AlarmConditionType_AckedState_TrueState                                                                               = 9145
	AlarmConditionType_AckedState_FalseState                                                                              = 9146
	AlarmConditionType_ConfirmedState                                                                                     = 9147
	AlarmConditionType_ConfirmedState_ID                                                                                  = 9148
	AlarmConditionType_ConfirmedState_Name                                                                                = 9149
	AlarmConditionType_ConfirmedState_Number                                                                              = 9150
	AlarmConditionType_ConfirmedState_EffectiveDisplayName                                                                = 9151
	AlarmConditionType_ConfirmedState_TransitionTime                                                                      = 9152
	AlarmConditionType_ConfirmedState_EffectiveTransitionTime                                                             = 9153
	AlarmConditionType_ConfirmedState_TrueState                                                                           = 9154
	AlarmConditionType_ConfirmedState_FalseState                                                                          = 9155
	AlarmConditionType_Acknowledge                                                                                        = 9156
	AlarmConditionType_Acknowledge_InputArguments                                                                         = 9157
	AlarmConditionType_Confirm                                                                                            = 9158
	AlarmConditionType_Confirm_InputArguments                                                                             = 9159
	AlarmConditionType_ActiveState                                                                                        = 9160
	AlarmConditionType_ActiveState_ID                                                                                     = 9161
	AlarmConditionType_ActiveState_Name                                                                                   = 9162
	AlarmConditionType_ActiveState_Number                                                                                 = 9163
	AlarmConditionType_ActiveState_EffectiveDisplayName                                                                   = 9164
	AlarmConditionType_ActiveState_TransitionTime                                                                         = 9165
	AlarmConditionType_ActiveState_EffectiveTransitionTime                                                                = 9166
	AlarmConditionType_ActiveState_TrueState                                                                              = 9167
	AlarmConditionType_ActiveState_FalseState                                                                             = 9168
	AlarmConditionType_SuppressedState                                                                                    = 9169
	AlarmConditionType_SuppressedState_ID                                                                                 = 9170
	AlarmConditionType_SuppressedState_Name                                                                               = 9171
	AlarmConditionType_SuppressedState_Number                                                                             = 9172
	AlarmConditionType_SuppressedState_EffectiveDisplayName                                                               = 9173
	AlarmConditionType_SuppressedState_TransitionTime                                                                     = 9174
	AlarmConditionType_SuppressedState_EffectiveTransitionTime                                                            = 9175
	AlarmConditionType_SuppressedState_TrueState                                                                          = 9176
	AlarmConditionType_SuppressedState_FalseState                                                                         = 9177
	AlarmConditionType_ShelvingState                                                                                      = 9178
	AlarmConditionType_ShelvingState_CurrentState                                                                         = 9179
	AlarmConditionType_ShelvingState_CurrentState_ID                                                                      = 9180
	AlarmConditionType_ShelvingState_CurrentState_Name                                                                    = 9181
	AlarmConditionType_ShelvingState_CurrentState_Number                                                                  = 9182
	AlarmConditionType_ShelvingState_CurrentState_EffectiveDisplayName                                                    = 9183
	AlarmConditionType_ShelvingState_LastTransition                                                                       = 9184
	AlarmConditionType_ShelvingState_LastTransition_ID                                                                    = 9185
	AlarmConditionType_ShelvingState_LastTransition_Name                                                                  = 9186
	AlarmConditionType_ShelvingState_LastTransition_Number                                                                = 9187
	AlarmConditionType_ShelvingState_LastTransition_TransitionTime                                                        = 9188
	AlarmConditionType_ShelvingState_UnshelveTime                                                                         = 9189
	AlarmConditionType_ShelvingState_Unshelve                                                                             = 9211
	AlarmConditionType_ShelvingState_OneShotShelve                                                                        = 9212
	AlarmConditionType_ShelvingState_TimedShelve                                                                          = 9213
	AlarmConditionType_ShelvingState_TimedShelve_InputArguments                                                           = 9214
	AlarmConditionType_SuppressedOrShelved                                                                                = 9215
	AlarmConditionType_MaxTimeShelved                                                                                     = 9216
	LimitAlarmType_ConditionName                                                                                          = 9217
	LimitAlarmType_BranchID                                                                                               = 9218
	LimitAlarmType_EnabledState                                                                                           = 9219
	LimitAlarmType_EnabledState_ID                                                                                        = 9220
	LimitAlarmType_EnabledState_Name                                                                                      = 9221
	LimitAlarmType_EnabledState_Number                                                                                    = 9222
	LimitAlarmType_EnabledState_EffectiveDisplayName                                                                      = 9223
	LimitAlarmType_EnabledState_TransitionTime                                                                            = 9224
	LimitAlarmType_EnabledState_EffectiveTransitionTime                                                                   = 9225
	LimitAlarmType_EnabledState_TrueState                                                                                 = 9226
	LimitAlarmType_EnabledState_FalseState                                                                                = 9227
	LimitAlarmType_Quality                                                                                                = 9228
	LimitAlarmType_Quality_SourceTimestamp                                                                                = 9229
	LimitAlarmType_LastSeverity                                                                                           = 9230
	LimitAlarmType_LastSeverity_SourceTimestamp                                                                           = 9231
	LimitAlarmType_Comment                                                                                                = 9232
	LimitAlarmType_Comment_SourceTimestamp                                                                                = 9233
	LimitAlarmType_ClientUserID                                                                                           = 9234
	LimitAlarmType_Enable                                                                                                 = 9235
	LimitAlarmType_Disable                                                                                                = 9236
	LimitAlarmType_AddComment                                                                                             = 9237
	LimitAlarmType_AddComment_InputArguments                                                                              = 9238
	LimitAlarmType_AckedState                                                                                             = 9239
	LimitAlarmType_AckedState_ID                                                                                          = 9240
	LimitAlarmType_AckedState_Name                                                                                        = 9241
	LimitAlarmType_AckedState_Number                                                                                      = 9242
	LimitAlarmType_AckedState_EffectiveDisplayName                                                                        = 9243
	LimitAlarmType_AckedState_TransitionTime                                                                              = 9244
	LimitAlarmType_AckedState_EffectiveTransitionTime                                                                     = 9245
	LimitAlarmType_AckedState_TrueState                                                                                   = 9246
	LimitAlarmType_AckedState_FalseState                                                                                  = 9247
	LimitAlarmType_ConfirmedState                                                                                         = 9248
	LimitAlarmType_ConfirmedState_ID                                                                                      = 9249
	LimitAlarmType_ConfirmedState_Name                                                                                    = 9250
	LimitAlarmType_ConfirmedState_Number                                                                                  = 9251
	LimitAlarmType_ConfirmedState_EffectiveDisplayName                                                                    = 9252
	LimitAlarmType_ConfirmedState_TransitionTime                                                                          = 9253
	LimitAlarmType_ConfirmedState_EffectiveTransitionTime                                                                 = 9254
	LimitAlarmType_ConfirmedState_TrueState                                                                               = 9255
	LimitAlarmType_ConfirmedState_FalseState                                                                              = 9256
	LimitAlarmType_Acknowledge                                                                                            = 9257
	LimitAlarmType_Acknowledge_InputArguments                                                                             = 9258
	LimitAlarmType_Confirm                                                                                                = 9259
	LimitAlarmType_Confirm_InputArguments                                                                                 = 9260
	LimitAlarmType_ActiveState                                                                                            = 9261
	LimitAlarmType_ActiveState_ID                                                                                         = 9262
	LimitAlarmType_ActiveState_Name                                                                                       = 9263
	LimitAlarmType_ActiveState_Number                                                                                     = 9264
	LimitAlarmType_ActiveState_EffectiveDisplayName                                                                       = 9265
	LimitAlarmType_ActiveState_TransitionTime                                                                             = 9266
	LimitAlarmType_ActiveState_EffectiveTransitionTime                                                                    = 9267
	LimitAlarmType_ActiveState_TrueState                                                                                  = 9268
	LimitAlarmType_ActiveState_FalseState                                                                                 = 9269
	LimitAlarmType_SuppressedState                                                                                        = 9270
	LimitAlarmType_SuppressedState_ID                                                                                     = 9271
	LimitAlarmType_SuppressedState_Name                                                                                   = 9272
	LimitAlarmType_SuppressedState_Number                                                                                 = 9273
	LimitAlarmType_SuppressedState_EffectiveDisplayName                                                                   = 9274
	LimitAlarmType_SuppressedState_TransitionTime                                                                         = 9275
	LimitAlarmType_SuppressedState_EffectiveTransitionTime                                                                = 9276
	LimitAlarmType_SuppressedState_TrueState                                                                              = 9277
	LimitAlarmType_SuppressedState_FalseState                                                                             = 9278
	LimitAlarmType_ShelvingState                                                                                          = 9279
	LimitAlarmType_ShelvingState_CurrentState                                                                             = 9280
	LimitAlarmType_ShelvingState_CurrentState_ID                                                                          = 9281
	LimitAlarmType_ShelvingState_CurrentState_Name                                                                        = 9282
	LimitAlarmType_ShelvingState_CurrentState_Number                                                                      = 9283
	LimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                                        = 9284
	LimitAlarmType_ShelvingState_LastTransition                                                                           = 9285
	LimitAlarmType_ShelvingState_LastTransition_ID                                                                        = 9286
	LimitAlarmType_ShelvingState_LastTransition_Name                                                                      = 9287
	LimitAlarmType_ShelvingState_LastTransition_Number                                                                    = 9288
	LimitAlarmType_ShelvingState_LastTransition_TransitionTime                                                            = 9289
	LimitAlarmType_ShelvingState_UnshelveTime                                                                             = 9290
	LimitAlarmType_ShelvingState_Unshelve                                                                                 = 9312
	LimitAlarmType_ShelvingState_OneShotShelve                                                                            = 9313
	LimitAlarmType_ShelvingState_TimedShelve                                                                              = 9314
	LimitAlarmType_ShelvingState_TimedShelve_InputArguments                                                               = 9315
	LimitAlarmType_SuppressedOrShelved                                                                                    = 9316
	LimitAlarmType_MaxTimeShelved                                                                                         = 9317
	ExclusiveLimitStateMachineType                                                                                        = 9318
	ExclusiveLimitStateMachineType_CurrentState                                                                           = 9319
	ExclusiveLimitStateMachineType_CurrentState_ID                                                                        = 9320
	ExclusiveLimitStateMachineType_CurrentState_Name                                                                      = 9321
	ExclusiveLimitStateMachineType_CurrentState_Number                                                                    = 9322
	ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName                                                      = 9323
	ExclusiveLimitStateMachineType_LastTransition                                                                         = 9324
	ExclusiveLimitStateMachineType_LastTransition_ID                                                                      = 9325
	ExclusiveLimitStateMachineType_LastTransition_Name                                                                    = 9326
	ExclusiveLimitStateMachineType_LastTransition_Number                                                                  = 9327
	ExclusiveLimitStateMachineType_LastTransition_TransitionTime                                                          = 9328
	ExclusiveLimitStateMachineType_HighHigh                                                                               = 9329
	ExclusiveLimitStateMachineType_HighHigh_StateNumber                                                                   = 9330
	ExclusiveLimitStateMachineType_High                                                                                   = 9331
	ExclusiveLimitStateMachineType_High_StateNumber                                                                       = 9332
	ExclusiveLimitStateMachineType_Low                                                                                    = 9333
	ExclusiveLimitStateMachineType_Low_StateNumber                                                                        = 9334
	ExclusiveLimitStateMachineType_LowLow                                                                                 = 9335
	ExclusiveLimitStateMachineType_LowLow_StateNumber                                                                     = 9336
	ExclusiveLimitStateMachineType_LowLowToLow                                                                            = 9337
	ExclusiveLimitStateMachineType_LowToLowLow                                                                            = 9338
	ExclusiveLimitStateMachineType_HighHighToHigh                                                                         = 9339
	ExclusiveLimitStateMachineType_HighToHighHigh                                                                         = 9340
	ExclusiveLimitAlarmType                                                                                               = 9341
	ExclusiveLimitAlarmType_EventID                                                                                       = 9342
	ExclusiveLimitAlarmType_EventType                                                                                     = 9343
	ExclusiveLimitAlarmType_SourceNode                                                                                    = 9344
	ExclusiveLimitAlarmType_SourceName                                                                                    = 9345
	ExclusiveLimitAlarmType_Time                                                                                          = 9346
	ExclusiveLimitAlarmType_ReceiveTime                                                                                   = 9347
	ExclusiveLimitAlarmType_LocalTime                                                                                     = 9348
	ExclusiveLimitAlarmType_Message                                                                                       = 9349
	ExclusiveLimitAlarmType_Severity                                                                                      = 9350
	ExclusiveLimitAlarmType_ConditionName                                                                                 = 9351
	ExclusiveLimitAlarmType_BranchID                                                                                      = 9352
	ExclusiveLimitAlarmType_Retain                                                                                        = 9353
	ExclusiveLimitAlarmType_EnabledState                                                                                  = 9354
	ExclusiveLimitAlarmType_EnabledState_ID                                                                               = 9355
	ExclusiveLimitAlarmType_EnabledState_Name                                                                             = 9356
	ExclusiveLimitAlarmType_EnabledState_Number                                                                           = 9357
	ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName                                                             = 9358
	ExclusiveLimitAlarmType_EnabledState_TransitionTime                                                                   = 9359
	ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime                                                          = 9360
	ExclusiveLimitAlarmType_EnabledState_TrueState                                                                        = 9361
	ExclusiveLimitAlarmType_EnabledState_FalseState                                                                       = 9362
	ExclusiveLimitAlarmType_Quality                                                                                       = 9363
	ExclusiveLimitAlarmType_Quality_SourceTimestamp                                                                       = 9364
	ExclusiveLimitAlarmType_LastSeverity                                                                                  = 9365
	ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp                                                                  = 9366
	ExclusiveLimitAlarmType_Comment                                                                                       = 9367
	ExclusiveLimitAlarmType_Comment_SourceTimestamp                                                                       = 9368
	ExclusiveLimitAlarmType_ClientUserID                                                                                  = 9369
	ExclusiveLimitAlarmType_Enable                                                                                        = 9370
	ExclusiveLimitAlarmType_Disable                                                                                       = 9371
	ExclusiveLimitAlarmType_AddComment                                                                                    = 9372
	ExclusiveLimitAlarmType_AddComment_InputArguments                                                                     = 9373
	ExclusiveLimitAlarmType_ConditionRefresh                                                                              = 9374
	ExclusiveLimitAlarmType_ConditionRefresh_InputArguments                                                               = 9375
	ExclusiveLimitAlarmType_AckedState                                                                                    = 9376
	ExclusiveLimitAlarmType_AckedState_ID                                                                                 = 9377
	ExclusiveLimitAlarmType_AckedState_Name                                                                               = 9378
	ExclusiveLimitAlarmType_AckedState_Number                                                                             = 9379
	ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName                                                               = 9380
	ExclusiveLimitAlarmType_AckedState_TransitionTime                                                                     = 9381
	ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime                                                            = 9382
	ExclusiveLimitAlarmType_AckedState_TrueState                                                                          = 9383
	ExclusiveLimitAlarmType_AckedState_FalseState                                                                         = 9384
	ExclusiveLimitAlarmType_ConfirmedState                                                                                = 9385
	ExclusiveLimitAlarmType_ConfirmedState_ID                                                                             = 9386
	ExclusiveLimitAlarmType_ConfirmedState_Name                                                                           = 9387
	ExclusiveLimitAlarmType_ConfirmedState_Number                                                                         = 9388
	ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName                                                           = 9389
	ExclusiveLimitAlarmType_ConfirmedState_TransitionTime                                                                 = 9390
	ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime                                                        = 9391
	ExclusiveLimitAlarmType_ConfirmedState_TrueState                                                                      = 9392
	ExclusiveLimitAlarmType_ConfirmedState_FalseState                                                                     = 9393
	ExclusiveLimitAlarmType_Acknowledge                                                                                   = 9394
	ExclusiveLimitAlarmType_Acknowledge_InputArguments                                                                    = 9395
	ExclusiveLimitAlarmType_Confirm                                                                                       = 9396
	ExclusiveLimitAlarmType_Confirm_InputArguments                                                                        = 9397
	ExclusiveLimitAlarmType_ActiveState                                                                                   = 9398
	ExclusiveLimitAlarmType_ActiveState_ID                                                                                = 9399
	ExclusiveLimitAlarmType_ActiveState_Name                                                                              = 9400
	ExclusiveLimitAlarmType_ActiveState_Number                                                                            = 9401
	ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName                                                              = 9402
	ExclusiveLimitAlarmType_ActiveState_TransitionTime                                                                    = 9403
	ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime                                                           = 9404
	ExclusiveLimitAlarmType_ActiveState_TrueState                                                                         = 9405
	ExclusiveLimitAlarmType_ActiveState_FalseState                                                                        = 9406
	ExclusiveLimitAlarmType_SuppressedState                                                                               = 9407
	ExclusiveLimitAlarmType_SuppressedState_ID                                                                            = 9408
	ExclusiveLimitAlarmType_SuppressedState_Name                                                                          = 9409
	ExclusiveLimitAlarmType_SuppressedState_Number                                                                        = 9410
	ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName                                                          = 9411
	ExclusiveLimitAlarmType_SuppressedState_TransitionTime                                                                = 9412
	ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime                                                       = 9413
	ExclusiveLimitAlarmType_SuppressedState_TrueState                                                                     = 9414
	ExclusiveLimitAlarmType_SuppressedState_FalseState                                                                    = 9415
	ExclusiveLimitAlarmType_ShelvingState                                                                                 = 9416
	ExclusiveLimitAlarmType_ShelvingState_CurrentState                                                                    = 9417
	ExclusiveLimitAlarmType_ShelvingState_CurrentState_ID                                                                 = 9418
	ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name                                                               = 9419
	ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number                                                             = 9420
	ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                               = 9421
	ExclusiveLimitAlarmType_ShelvingState_LastTransition                                                                  = 9422
	ExclusiveLimitAlarmType_ShelvingState_LastTransition_ID                                                               = 9423
	ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name                                                             = 9424
	ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number                                                           = 9425
	ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime                                                   = 9426
	ExclusiveLimitAlarmType_ShelvingState_UnshelveTime                                                                    = 9427
	ExclusiveLimitAlarmType_ShelvingState_Unshelve                                                                        = 9449
	ExclusiveLimitAlarmType_ShelvingState_OneShotShelve                                                                   = 9450
	ExclusiveLimitAlarmType_ShelvingState_TimedShelve                                                                     = 9451
	ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments                                                      = 9452
	ExclusiveLimitAlarmType_SuppressedOrShelved                                                                           = 9453
	ExclusiveLimitAlarmType_MaxTimeShelved                                                                                = 9454
	ExclusiveLimitAlarmType_LimitState                                                                                    = 9455
	ExclusiveLimitAlarmType_LimitState_CurrentState                                                                       = 9456
	ExclusiveLimitAlarmType_LimitState_CurrentState_ID                                                                    = 9457
	ExclusiveLimitAlarmType_LimitState_CurrentState_Name                                                                  = 9458
	ExclusiveLimitAlarmType_LimitState_CurrentState_Number                                                                = 9459
	ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName                                                  = 9460
	ExclusiveLimitAlarmType_LimitState_LastTransition                                                                     = 9461
	ExclusiveLimitAlarmType_LimitState_LastTransition_ID                                                                  = 9462
	ExclusiveLimitAlarmType_LimitState_LastTransition_Name                                                                = 9463
	ExclusiveLimitAlarmType_LimitState_LastTransition_Number                                                              = 9464
	ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime                                                      = 9465
	ExclusiveLimitAlarmType_HighHighLimit                                                                                 = 9478
	ExclusiveLimitAlarmType_HighLimit                                                                                     = 9479
	ExclusiveLimitAlarmType_LowLimit                                                                                      = 9480
	ExclusiveLimitAlarmType_LowLowLimit                                                                                   = 9481
	ExclusiveLevelAlarmType                                                                                               = 9482
	ExclusiveLevelAlarmType_EventID                                                                                       = 9483
	ExclusiveLevelAlarmType_EventType                                                                                     = 9484
	ExclusiveLevelAlarmType_SourceNode                                                                                    = 9485
	ExclusiveLevelAlarmType_SourceName                                                                                    = 9486
	ExclusiveLevelAlarmType_Time                                                                                          = 9487
	ExclusiveLevelAlarmType_ReceiveTime                                                                                   = 9488
	ExclusiveLevelAlarmType_LocalTime                                                                                     = 9489
	ExclusiveLevelAlarmType_Message                                                                                       = 9490
	ExclusiveLevelAlarmType_Severity                                                                                      = 9491
	ExclusiveLevelAlarmType_ConditionName                                                                                 = 9492
	ExclusiveLevelAlarmType_BranchID                                                                                      = 9493
	ExclusiveLevelAlarmType_Retain                                                                                        = 9494
	ExclusiveLevelAlarmType_EnabledState                                                                                  = 9495
	ExclusiveLevelAlarmType_EnabledState_ID                                                                               = 9496
	ExclusiveLevelAlarmType_EnabledState_Name                                                                             = 9497
	ExclusiveLevelAlarmType_EnabledState_Number                                                                           = 9498
	ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName                                                             = 9499
	ExclusiveLevelAlarmType_EnabledState_TransitionTime                                                                   = 9500
	ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime                                                          = 9501
	ExclusiveLevelAlarmType_EnabledState_TrueState                                                                        = 9502
	ExclusiveLevelAlarmType_EnabledState_FalseState                                                                       = 9503
	ExclusiveLevelAlarmType_Quality                                                                                       = 9504
	ExclusiveLevelAlarmType_Quality_SourceTimestamp                                                                       = 9505
	ExclusiveLevelAlarmType_LastSeverity                                                                                  = 9506
	ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp                                                                  = 9507
	ExclusiveLevelAlarmType_Comment                                                                                       = 9508
	ExclusiveLevelAlarmType_Comment_SourceTimestamp                                                                       = 9509
	ExclusiveLevelAlarmType_ClientUserID                                                                                  = 9510
	ExclusiveLevelAlarmType_Enable                                                                                        = 9511
	ExclusiveLevelAlarmType_Disable                                                                                       = 9512
	ExclusiveLevelAlarmType_AddComment                                                                                    = 9513
	ExclusiveLevelAlarmType_AddComment_InputArguments                                                                     = 9514
	ExclusiveLevelAlarmType_ConditionRefresh                                                                              = 9515
	ExclusiveLevelAlarmType_ConditionRefresh_InputArguments                                                               = 9516
	ExclusiveLevelAlarmType_AckedState                                                                                    = 9517
	ExclusiveLevelAlarmType_AckedState_ID                                                                                 = 9518
	ExclusiveLevelAlarmType_AckedState_Name                                                                               = 9519
	ExclusiveLevelAlarmType_AckedState_Number                                                                             = 9520
	ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName                                                               = 9521
	ExclusiveLevelAlarmType_AckedState_TransitionTime                                                                     = 9522
	ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime                                                            = 9523
	ExclusiveLevelAlarmType_AckedState_TrueState                                                                          = 9524
	ExclusiveLevelAlarmType_AckedState_FalseState                                                                         = 9525
	ExclusiveLevelAlarmType_ConfirmedState                                                                                = 9526
	ExclusiveLevelAlarmType_ConfirmedState_ID                                                                             = 9527
	ExclusiveLevelAlarmType_ConfirmedState_Name                                                                           = 9528
	ExclusiveLevelAlarmType_ConfirmedState_Number                                                                         = 9529
	ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName                                                           = 9530
	ExclusiveLevelAlarmType_ConfirmedState_TransitionTime                                                                 = 9531
	ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime                                                        = 9532
	ExclusiveLevelAlarmType_ConfirmedState_TrueState                                                                      = 9533
	ExclusiveLevelAlarmType_ConfirmedState_FalseState                                                                     = 9534
	ExclusiveLevelAlarmType_Acknowledge                                                                                   = 9535
	ExclusiveLevelAlarmType_Acknowledge_InputArguments                                                                    = 9536
	ExclusiveLevelAlarmType_Confirm                                                                                       = 9537
	ExclusiveLevelAlarmType_Confirm_InputArguments                                                                        = 9538
	ExclusiveLevelAlarmType_ActiveState                                                                                   = 9539
	ExclusiveLevelAlarmType_ActiveState_ID                                                                                = 9540
	ExclusiveLevelAlarmType_ActiveState_Name                                                                              = 9541
	ExclusiveLevelAlarmType_ActiveState_Number                                                                            = 9542
	ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName                                                              = 9543
	ExclusiveLevelAlarmType_ActiveState_TransitionTime                                                                    = 9544
	ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime                                                           = 9545
	ExclusiveLevelAlarmType_ActiveState_TrueState                                                                         = 9546
	ExclusiveLevelAlarmType_ActiveState_FalseState                                                                        = 9547
	ExclusiveLevelAlarmType_SuppressedState                                                                               = 9548
	ExclusiveLevelAlarmType_SuppressedState_ID                                                                            = 9549
	ExclusiveLevelAlarmType_SuppressedState_Name                                                                          = 9550
	ExclusiveLevelAlarmType_SuppressedState_Number                                                                        = 9551
	ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName                                                          = 9552
	ExclusiveLevelAlarmType_SuppressedState_TransitionTime                                                                = 9553
	ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime                                                       = 9554
	ExclusiveLevelAlarmType_SuppressedState_TrueState                                                                     = 9555
	ExclusiveLevelAlarmType_SuppressedState_FalseState                                                                    = 9556
	ExclusiveLevelAlarmType_ShelvingState                                                                                 = 9557
	ExclusiveLevelAlarmType_ShelvingState_CurrentState                                                                    = 9558
	ExclusiveLevelAlarmType_ShelvingState_CurrentState_ID                                                                 = 9559
	ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name                                                               = 9560
	ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number                                                             = 9561
	ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                               = 9562
	ExclusiveLevelAlarmType_ShelvingState_LastTransition                                                                  = 9563
	ExclusiveLevelAlarmType_ShelvingState_LastTransition_ID                                                               = 9564
	ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name                                                             = 9565
	ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number                                                           = 9566
	ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime                                                   = 9567
	ExclusiveLevelAlarmType_ShelvingState_UnshelveTime                                                                    = 9568
	ExclusiveLevelAlarmType_ShelvingState_Unshelve                                                                        = 9590
	ExclusiveLevelAlarmType_ShelvingState_OneShotShelve                                                                   = 9591
	ExclusiveLevelAlarmType_ShelvingState_TimedShelve                                                                     = 9592
	ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments                                                      = 9593
	ExclusiveLevelAlarmType_SuppressedOrShelved                                                                           = 9594
	ExclusiveLevelAlarmType_MaxTimeShelved                                                                                = 9595
	ExclusiveLevelAlarmType_LimitState                                                                                    = 9596
	ExclusiveLevelAlarmType_LimitState_CurrentState                                                                       = 9597
	ExclusiveLevelAlarmType_LimitState_CurrentState_ID                                                                    = 9598
	ExclusiveLevelAlarmType_LimitState_CurrentState_Name                                                                  = 9599
	ExclusiveLevelAlarmType_LimitState_CurrentState_Number                                                                = 9600
	ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName                                                  = 9601
	ExclusiveLevelAlarmType_LimitState_LastTransition                                                                     = 9602
	ExclusiveLevelAlarmType_LimitState_LastTransition_ID                                                                  = 9603
	ExclusiveLevelAlarmType_LimitState_LastTransition_Name                                                                = 9604
	ExclusiveLevelAlarmType_LimitState_LastTransition_Number                                                              = 9605
	ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime                                                      = 9606
	ExclusiveLevelAlarmType_HighHighLimit                                                                                 = 9619
	ExclusiveLevelAlarmType_HighLimit                                                                                     = 9620
	ExclusiveLevelAlarmType_LowLimit                                                                                      = 9621
	ExclusiveLevelAlarmType_LowLowLimit                                                                                   = 9622
	ExclusiveRateOfChangeAlarmType                                                                                        = 9623
	ExclusiveRateOfChangeAlarmType_EventID                                                                                = 9624
	ExclusiveRateOfChangeAlarmType_EventType                                                                              = 9625
	ExclusiveRateOfChangeAlarmType_SourceNode                                                                             = 9626
	ExclusiveRateOfChangeAlarmType_SourceName                                                                             = 9627
	ExclusiveRateOfChangeAlarmType_Time                                                                                   = 9628
	ExclusiveRateOfChangeAlarmType_ReceiveTime                                                                            = 9629
	ExclusiveRateOfChangeAlarmType_LocalTime                                                                              = 9630
	ExclusiveRateOfChangeAlarmType_Message                                                                                = 9631
	ExclusiveRateOfChangeAlarmType_Severity                                                                               = 9632
	ExclusiveRateOfChangeAlarmType_ConditionName                                                                          = 9633
	ExclusiveRateOfChangeAlarmType_BranchID                                                                               = 9634
	ExclusiveRateOfChangeAlarmType_Retain                                                                                 = 9635
	ExclusiveRateOfChangeAlarmType_EnabledState                                                                           = 9636
	ExclusiveRateOfChangeAlarmType_EnabledState_ID                                                                        = 9637
	ExclusiveRateOfChangeAlarmType_EnabledState_Name                                                                      = 9638
	ExclusiveRateOfChangeAlarmType_EnabledState_Number                                                                    = 9639
	ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName                                                      = 9640
	ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime                                                            = 9641
	ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime                                                   = 9642
	ExclusiveRateOfChangeAlarmType_EnabledState_TrueState                                                                 = 9643
	ExclusiveRateOfChangeAlarmType_EnabledState_FalseState                                                                = 9644
	ExclusiveRateOfChangeAlarmType_Quality                                                                                = 9645
	ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp                                                                = 9646
	ExclusiveRateOfChangeAlarmType_LastSeverity                                                                           = 9647
	ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp                                                           = 9648
	ExclusiveRateOfChangeAlarmType_Comment                                                                                = 9649
	ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp                                                                = 9650
	ExclusiveRateOfChangeAlarmType_ClientUserID                                                                           = 9651
	ExclusiveRateOfChangeAlarmType_Enable                                                                                 = 9652
	ExclusiveRateOfChangeAlarmType_Disable                                                                                = 9653
	ExclusiveRateOfChangeAlarmType_AddComment                                                                             = 9654
	ExclusiveRateOfChangeAlarmType_AddComment_InputArguments                                                              = 9655
	ExclusiveRateOfChangeAlarmType_ConditionRefresh                                                                       = 9656
	ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments                                                        = 9657
	ExclusiveRateOfChangeAlarmType_AckedState                                                                             = 9658
	ExclusiveRateOfChangeAlarmType_AckedState_ID                                                                          = 9659
	ExclusiveRateOfChangeAlarmType_AckedState_Name                                                                        = 9660
	ExclusiveRateOfChangeAlarmType_AckedState_Number                                                                      = 9661
	ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName                                                        = 9662
	ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime                                                              = 9663
	ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime                                                     = 9664
	ExclusiveRateOfChangeAlarmType_AckedState_TrueState                                                                   = 9665
	ExclusiveRateOfChangeAlarmType_AckedState_FalseState                                                                  = 9666
	ExclusiveRateOfChangeAlarmType_ConfirmedState                                                                         = 9667
	ExclusiveRateOfChangeAlarmType_ConfirmedState_ID                                                                      = 9668
	ExclusiveRateOfChangeAlarmType_ConfirmedState_Name                                                                    = 9669
	ExclusiveRateOfChangeAlarmType_ConfirmedState_Number                                                                  = 9670
	ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName                                                    = 9671
	ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime                                                          = 9672
	ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime                                                 = 9673
	ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState                                                               = 9674
	ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState                                                              = 9675
	ExclusiveRateOfChangeAlarmType_Acknowledge                                                                            = 9676
	ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments                                                             = 9677
	ExclusiveRateOfChangeAlarmType_Confirm                                                                                = 9678
	ExclusiveRateOfChangeAlarmType_Confirm_InputArguments                                                                 = 9679
	ExclusiveRateOfChangeAlarmType_ActiveState                                                                            = 9680
	ExclusiveRateOfChangeAlarmType_ActiveState_ID                                                                         = 9681
	ExclusiveRateOfChangeAlarmType_ActiveState_Name                                                                       = 9682
	ExclusiveRateOfChangeAlarmType_ActiveState_Number                                                                     = 9683
	ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName                                                       = 9684
	ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime                                                             = 9685
	ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime                                                    = 9686
	ExclusiveRateOfChangeAlarmType_ActiveState_TrueState                                                                  = 9687
	ExclusiveRateOfChangeAlarmType_ActiveState_FalseState                                                                 = 9688
	ExclusiveRateOfChangeAlarmType_SuppressedState                                                                        = 9689
	ExclusiveRateOfChangeAlarmType_SuppressedState_ID                                                                     = 9690
	ExclusiveRateOfChangeAlarmType_SuppressedState_Name                                                                   = 9691
	ExclusiveRateOfChangeAlarmType_SuppressedState_Number                                                                 = 9692
	ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName                                                   = 9693
	ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime                                                         = 9694
	ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime                                                = 9695
	ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState                                                              = 9696
	ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState                                                             = 9697
	ExclusiveRateOfChangeAlarmType_ShelvingState                                                                          = 9698
	ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState                                                             = 9699
	ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_ID                                                          = 9700
	ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name                                                        = 9701
	ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number                                                      = 9702
	ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                        = 9703
	ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition                                                           = 9704
	ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_ID                                                        = 9705
	ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name                                                      = 9706
	ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number                                                    = 9707
	ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime                                            = 9708
	ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime                                                             = 9709
	ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve                                                                 = 9731
	ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve                                                            = 9732
	ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve                                                              = 9733
	ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments                                               = 9734
	ExclusiveRateOfChangeAlarmType_SuppressedOrShelved                                                                    = 9735
	ExclusiveRateOfChangeAlarmType_MaxTimeShelved                                                                         = 9736
	ExclusiveRateOfChangeAlarmType_LimitState                                                                             = 9737
	ExclusiveRateOfChangeAlarmType_LimitState_CurrentState                                                                = 9738
	ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_ID                                                             = 9739
	ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name                                                           = 9740
	ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number                                                         = 9741
	ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName                                           = 9742
	ExclusiveRateOfChangeAlarmType_LimitState_LastTransition                                                              = 9743
	ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_ID                                                           = 9744
	ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name                                                         = 9745
	ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number                                                       = 9746
	ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime                                               = 9747
	ExclusiveRateOfChangeAlarmType_HighHighLimit                                                                          = 9760
	ExclusiveRateOfChangeAlarmType_HighLimit                                                                              = 9761
	ExclusiveRateOfChangeAlarmType_LowLimit                                                                               = 9762
	ExclusiveRateOfChangeAlarmType_LowLowLimit                                                                            = 9763
	ExclusiveDeviationAlarmType                                                                                           = 9764
	ExclusiveDeviationAlarmType_EventID                                                                                   = 9765
	ExclusiveDeviationAlarmType_EventType                                                                                 = 9766
	ExclusiveDeviationAlarmType_SourceNode                                                                                = 9767
	ExclusiveDeviationAlarmType_SourceName                                                                                = 9768
	ExclusiveDeviationAlarmType_Time                                                                                      = 9769
	ExclusiveDeviationAlarmType_ReceiveTime                                                                               = 9770
	ExclusiveDeviationAlarmType_LocalTime                                                                                 = 9771
	ExclusiveDeviationAlarmType_Message                                                                                   = 9772
	ExclusiveDeviationAlarmType_Severity                                                                                  = 9773
	ExclusiveDeviationAlarmType_ConditionName                                                                             = 9774
	ExclusiveDeviationAlarmType_BranchID                                                                                  = 9775
	ExclusiveDeviationAlarmType_Retain                                                                                    = 9776
	ExclusiveDeviationAlarmType_EnabledState                                                                              = 9777
	ExclusiveDeviationAlarmType_EnabledState_ID                                                                           = 9778
	ExclusiveDeviationAlarmType_EnabledState_Name                                                                         = 9779
	ExclusiveDeviationAlarmType_EnabledState_Number                                                                       = 9780
	ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName                                                         = 9781
	ExclusiveDeviationAlarmType_EnabledState_TransitionTime                                                               = 9782
	ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime                                                      = 9783
	ExclusiveDeviationAlarmType_EnabledState_TrueState                                                                    = 9784
	ExclusiveDeviationAlarmType_EnabledState_FalseState                                                                   = 9785
	ExclusiveDeviationAlarmType_Quality                                                                                   = 9786
	ExclusiveDeviationAlarmType_Quality_SourceTimestamp                                                                   = 9787
	ExclusiveDeviationAlarmType_LastSeverity                                                                              = 9788
	ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp                                                              = 9789
	ExclusiveDeviationAlarmType_Comment                                                                                   = 9790
	ExclusiveDeviationAlarmType_Comment_SourceTimestamp                                                                   = 9791
	ExclusiveDeviationAlarmType_ClientUserID                                                                              = 9792
	ExclusiveDeviationAlarmType_Enable                                                                                    = 9793
	ExclusiveDeviationAlarmType_Disable                                                                                   = 9794
	ExclusiveDeviationAlarmType_AddComment                                                                                = 9795
	ExclusiveDeviationAlarmType_AddComment_InputArguments                                                                 = 9796
	ExclusiveDeviationAlarmType_ConditionRefresh                                                                          = 9797
	ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments                                                           = 9798
	ExclusiveDeviationAlarmType_AckedState                                                                                = 9799
	ExclusiveDeviationAlarmType_AckedState_ID                                                                             = 9800
	ExclusiveDeviationAlarmType_AckedState_Name                                                                           = 9801
	ExclusiveDeviationAlarmType_AckedState_Number                                                                         = 9802
	ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName                                                           = 9803
	ExclusiveDeviationAlarmType_AckedState_TransitionTime                                                                 = 9804
	ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime                                                        = 9805
	ExclusiveDeviationAlarmType_AckedState_TrueState                                                                      = 9806
	ExclusiveDeviationAlarmType_AckedState_FalseState                                                                     = 9807
	ExclusiveDeviationAlarmType_ConfirmedState                                                                            = 9808
	ExclusiveDeviationAlarmType_ConfirmedState_ID                                                                         = 9809
	ExclusiveDeviationAlarmType_ConfirmedState_Name                                                                       = 9810
	ExclusiveDeviationAlarmType_ConfirmedState_Number                                                                     = 9811
	ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName                                                       = 9812
	ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime                                                             = 9813
	ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime                                                    = 9814
	ExclusiveDeviationAlarmType_ConfirmedState_TrueState                                                                  = 9815
	ExclusiveDeviationAlarmType_ConfirmedState_FalseState                                                                 = 9816
	ExclusiveDeviationAlarmType_Acknowledge                                                                               = 9817
	ExclusiveDeviationAlarmType_Acknowledge_InputArguments                                                                = 9818
	ExclusiveDeviationAlarmType_Confirm                                                                                   = 9819
	ExclusiveDeviationAlarmType_Confirm_InputArguments                                                                    = 9820
	ExclusiveDeviationAlarmType_ActiveState                                                                               = 9821
	ExclusiveDeviationAlarmType_ActiveState_ID                                                                            = 9822
	ExclusiveDeviationAlarmType_ActiveState_Name                                                                          = 9823
	ExclusiveDeviationAlarmType_ActiveState_Number                                                                        = 9824
	ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName                                                          = 9825
	ExclusiveDeviationAlarmType_ActiveState_TransitionTime                                                                = 9826
	ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime                                                       = 9827
	ExclusiveDeviationAlarmType_ActiveState_TrueState                                                                     = 9828
	ExclusiveDeviationAlarmType_ActiveState_FalseState                                                                    = 9829
	ExclusiveDeviationAlarmType_SuppressedState                                                                           = 9830
	ExclusiveDeviationAlarmType_SuppressedState_ID                                                                        = 9831
	ExclusiveDeviationAlarmType_SuppressedState_Name                                                                      = 9832
	ExclusiveDeviationAlarmType_SuppressedState_Number                                                                    = 9833
	ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName                                                      = 9834
	ExclusiveDeviationAlarmType_SuppressedState_TransitionTime                                                            = 9835
	ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime                                                   = 9836
	ExclusiveDeviationAlarmType_SuppressedState_TrueState                                                                 = 9837
	ExclusiveDeviationAlarmType_SuppressedState_FalseState                                                                = 9838
	ExclusiveDeviationAlarmType_ShelvingState                                                                             = 9839
	ExclusiveDeviationAlarmType_ShelvingState_CurrentState                                                                = 9840
	ExclusiveDeviationAlarmType_ShelvingState_CurrentState_ID                                                             = 9841
	ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name                                                           = 9842
	ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number                                                         = 9843
	ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                           = 9844
	ExclusiveDeviationAlarmType_ShelvingState_LastTransition                                                              = 9845
	ExclusiveDeviationAlarmType_ShelvingState_LastTransition_ID                                                           = 9846
	ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name                                                         = 9847
	ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number                                                       = 9848
	ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime                                               = 9849
	ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime                                                                = 9850
	ExclusiveDeviationAlarmType_ShelvingState_Unshelve                                                                    = 9872
	ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve                                                               = 9873
	ExclusiveDeviationAlarmType_ShelvingState_TimedShelve                                                                 = 9874
	ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments                                                  = 9875
	ExclusiveDeviationAlarmType_SuppressedOrShelved                                                                       = 9876
	ExclusiveDeviationAlarmType_MaxTimeShelved                                                                            = 9877
	ExclusiveDeviationAlarmType_LimitState                                                                                = 9878
	ExclusiveDeviationAlarmType_LimitState_CurrentState                                                                   = 9879
	ExclusiveDeviationAlarmType_LimitState_CurrentState_ID                                                                = 9880
	ExclusiveDeviationAlarmType_LimitState_CurrentState_Name                                                              = 9881
	ExclusiveDeviationAlarmType_LimitState_CurrentState_Number                                                            = 9882
	ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName                                              = 9883
	ExclusiveDeviationAlarmType_LimitState_LastTransition                                                                 = 9884
	ExclusiveDeviationAlarmType_LimitState_LastTransition_ID                                                              = 9885
	ExclusiveDeviationAlarmType_LimitState_LastTransition_Name                                                            = 9886
	ExclusiveDeviationAlarmType_LimitState_LastTransition_Number                                                          = 9887
	ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime                                                  = 9888
	ExclusiveDeviationAlarmType_HighHighLimit                                                                             = 9901
	ExclusiveDeviationAlarmType_HighLimit                                                                                 = 9902
	ExclusiveDeviationAlarmType_LowLimit                                                                                  = 9903
	ExclusiveDeviationAlarmType_LowLowLimit                                                                               = 9904
	ExclusiveDeviationAlarmType_SetpointNode                                                                              = 9905
	NonExclusiveLimitAlarmType                                                                                            = 9906
	NonExclusiveLimitAlarmType_EventID                                                                                    = 9907
	NonExclusiveLimitAlarmType_EventType                                                                                  = 9908
	NonExclusiveLimitAlarmType_SourceNode                                                                                 = 9909
	NonExclusiveLimitAlarmType_SourceName                                                                                 = 9910
	NonExclusiveLimitAlarmType_Time                                                                                       = 9911
	NonExclusiveLimitAlarmType_ReceiveTime                                                                                = 9912
	NonExclusiveLimitAlarmType_LocalTime                                                                                  = 9913
	NonExclusiveLimitAlarmType_Message                                                                                    = 9914
	NonExclusiveLimitAlarmType_Severity                                                                                   = 9915
	NonExclusiveLimitAlarmType_ConditionName                                                                              = 9916
	NonExclusiveLimitAlarmType_BranchID                                                                                   = 9917
	NonExclusiveLimitAlarmType_Retain                                                                                     = 9918
	NonExclusiveLimitAlarmType_EnabledState                                                                               = 9919
	NonExclusiveLimitAlarmType_EnabledState_ID                                                                            = 9920
	NonExclusiveLimitAlarmType_EnabledState_Name                                                                          = 9921
	NonExclusiveLimitAlarmType_EnabledState_Number                                                                        = 9922
	NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName                                                          = 9923
	NonExclusiveLimitAlarmType_EnabledState_TransitionTime                                                                = 9924
	NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime                                                       = 9925
	NonExclusiveLimitAlarmType_EnabledState_TrueState                                                                     = 9926
	NonExclusiveLimitAlarmType_EnabledState_FalseState                                                                    = 9927
	NonExclusiveLimitAlarmType_Quality                                                                                    = 9928
	NonExclusiveLimitAlarmType_Quality_SourceTimestamp                                                                    = 9929
	NonExclusiveLimitAlarmType_LastSeverity                                                                               = 9930
	NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp                                                               = 9931
	NonExclusiveLimitAlarmType_Comment                                                                                    = 9932
	NonExclusiveLimitAlarmType_Comment_SourceTimestamp                                                                    = 9933
	NonExclusiveLimitAlarmType_ClientUserID                                                                               = 9934
	NonExclusiveLimitAlarmType_Enable                                                                                     = 9935
	NonExclusiveLimitAlarmType_Disable                                                                                    = 9936
	NonExclusiveLimitAlarmType_AddComment                                                                                 = 9937
	NonExclusiveLimitAlarmType_AddComment_InputArguments                                                                  = 9938
	NonExclusiveLimitAlarmType_ConditionRefresh                                                                           = 9939
	NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments                                                            = 9940
	NonExclusiveLimitAlarmType_AckedState                                                                                 = 9941
	NonExclusiveLimitAlarmType_AckedState_ID                                                                              = 9942
	NonExclusiveLimitAlarmType_AckedState_Name                                                                            = 9943
	NonExclusiveLimitAlarmType_AckedState_Number                                                                          = 9944
	NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName                                                            = 9945
	NonExclusiveLimitAlarmType_AckedState_TransitionTime                                                                  = 9946
	NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime                                                         = 9947
	NonExclusiveLimitAlarmType_AckedState_TrueState                                                                       = 9948
	NonExclusiveLimitAlarmType_AckedState_FalseState                                                                      = 9949
	NonExclusiveLimitAlarmType_ConfirmedState                                                                             = 9950
	NonExclusiveLimitAlarmType_ConfirmedState_ID                                                                          = 9951
	NonExclusiveLimitAlarmType_ConfirmedState_Name                                                                        = 9952
	NonExclusiveLimitAlarmType_ConfirmedState_Number                                                                      = 9953
	NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName                                                        = 9954
	NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime                                                              = 9955
	NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime                                                     = 9956
	NonExclusiveLimitAlarmType_ConfirmedState_TrueState                                                                   = 9957
	NonExclusiveLimitAlarmType_ConfirmedState_FalseState                                                                  = 9958
	NonExclusiveLimitAlarmType_Acknowledge                                                                                = 9959
	NonExclusiveLimitAlarmType_Acknowledge_InputArguments                                                                 = 9960
	NonExclusiveLimitAlarmType_Confirm                                                                                    = 9961
	NonExclusiveLimitAlarmType_Confirm_InputArguments                                                                     = 9962
	NonExclusiveLimitAlarmType_ActiveState                                                                                = 9963
	NonExclusiveLimitAlarmType_ActiveState_ID                                                                             = 9964
	NonExclusiveLimitAlarmType_ActiveState_Name                                                                           = 9965
	NonExclusiveLimitAlarmType_ActiveState_Number                                                                         = 9966
	NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName                                                           = 9967
	NonExclusiveLimitAlarmType_ActiveState_TransitionTime                                                                 = 9968
	NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime                                                        = 9969
	NonExclusiveLimitAlarmType_ActiveState_TrueState                                                                      = 9970
	NonExclusiveLimitAlarmType_ActiveState_FalseState                                                                     = 9971
	NonExclusiveLimitAlarmType_SuppressedState                                                                            = 9972
	NonExclusiveLimitAlarmType_SuppressedState_ID                                                                         = 9973
	NonExclusiveLimitAlarmType_SuppressedState_Name                                                                       = 9974
	NonExclusiveLimitAlarmType_SuppressedState_Number                                                                     = 9975
	NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName                                                       = 9976
	NonExclusiveLimitAlarmType_SuppressedState_TransitionTime                                                             = 9977
	NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime                                                    = 9978
	NonExclusiveLimitAlarmType_SuppressedState_TrueState                                                                  = 9979
	NonExclusiveLimitAlarmType_SuppressedState_FalseState                                                                 = 9980
	NonExclusiveLimitAlarmType_ShelvingState                                                                              = 9981
	NonExclusiveLimitAlarmType_ShelvingState_CurrentState                                                                 = 9982
	NonExclusiveLimitAlarmType_ShelvingState_CurrentState_ID                                                              = 9983
	NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name                                                            = 9984
	NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number                                                          = 9985
	NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                            = 9986
	NonExclusiveLimitAlarmType_ShelvingState_LastTransition                                                               = 9987
	NonExclusiveLimitAlarmType_ShelvingState_LastTransition_ID                                                            = 9988
	NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name                                                          = 9989
	NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number                                                        = 9990
	NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime                                                = 9991
	NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime                                                                 = 9992
	NonExclusiveLimitAlarmType_ShelvingState_Unshelve                                                                     = 10014
	NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve                                                                = 10015
	NonExclusiveLimitAlarmType_ShelvingState_TimedShelve                                                                  = 10016
	NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments                                                   = 10017
	NonExclusiveLimitAlarmType_SuppressedOrShelved                                                                        = 10018
	NonExclusiveLimitAlarmType_MaxTimeShelved                                                                             = 10019
	NonExclusiveLimitAlarmType_HighHighState                                                                              = 10020
	NonExclusiveLimitAlarmType_HighHighState_ID                                                                           = 10021
	NonExclusiveLimitAlarmType_HighHighState_Name                                                                         = 10022
	NonExclusiveLimitAlarmType_HighHighState_Number                                                                       = 10023
	NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName                                                         = 10024
	NonExclusiveLimitAlarmType_HighHighState_TransitionTime                                                               = 10025
	NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime                                                      = 10026
	NonExclusiveLimitAlarmType_HighHighState_TrueState                                                                    = 10027
	NonExclusiveLimitAlarmType_HighHighState_FalseState                                                                   = 10028
	NonExclusiveLimitAlarmType_HighState                                                                                  = 10029
	NonExclusiveLimitAlarmType_HighState_ID                                                                               = 10030
	NonExclusiveLimitAlarmType_HighState_Name                                                                             = 10031
	NonExclusiveLimitAlarmType_HighState_Number                                                                           = 10032
	NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName                                                             = 10033
	NonExclusiveLimitAlarmType_HighState_TransitionTime                                                                   = 10034
	NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime                                                          = 10035
	NonExclusiveLimitAlarmType_HighState_TrueState                                                                        = 10036
	NonExclusiveLimitAlarmType_HighState_FalseState                                                                       = 10037
	NonExclusiveLimitAlarmType_LowState                                                                                   = 10038
	NonExclusiveLimitAlarmType_LowState_ID                                                                                = 10039
	NonExclusiveLimitAlarmType_LowState_Name                                                                              = 10040
	NonExclusiveLimitAlarmType_LowState_Number                                                                            = 10041
	NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName                                                              = 10042
	NonExclusiveLimitAlarmType_LowState_TransitionTime                                                                    = 10043
	NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime                                                           = 10044
	NonExclusiveLimitAlarmType_LowState_TrueState                                                                         = 10045
	NonExclusiveLimitAlarmType_LowState_FalseState                                                                        = 10046
	NonExclusiveLimitAlarmType_LowLowState                                                                                = 10047
	NonExclusiveLimitAlarmType_LowLowState_ID                                                                             = 10048
	NonExclusiveLimitAlarmType_LowLowState_Name                                                                           = 10049
	NonExclusiveLimitAlarmType_LowLowState_Number                                                                         = 10050
	NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName                                                           = 10051
	NonExclusiveLimitAlarmType_LowLowState_TransitionTime                                                                 = 10052
	NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime                                                        = 10053
	NonExclusiveLimitAlarmType_LowLowState_TrueState                                                                      = 10054
	NonExclusiveLimitAlarmType_LowLowState_FalseState                                                                     = 10055
	NonExclusiveLimitAlarmType_HighHighLimit                                                                              = 10056
	NonExclusiveLimitAlarmType_HighLimit                                                                                  = 10057
	NonExclusiveLimitAlarmType_LowLimit                                                                                   = 10058
	NonExclusiveLimitAlarmType_LowLowLimit                                                                                = 10059
	NonExclusiveLevelAlarmType                                                                                            = 10060
	NonExclusiveLevelAlarmType_EventID                                                                                    = 10061
	NonExclusiveLevelAlarmType_EventType                                                                                  = 10062
	NonExclusiveLevelAlarmType_SourceNode                                                                                 = 10063
	NonExclusiveLevelAlarmType_SourceName                                                                                 = 10064
	NonExclusiveLevelAlarmType_Time                                                                                       = 10065
	NonExclusiveLevelAlarmType_ReceiveTime                                                                                = 10066
	NonExclusiveLevelAlarmType_LocalTime                                                                                  = 10067
	NonExclusiveLevelAlarmType_Message                                                                                    = 10068
	NonExclusiveLevelAlarmType_Severity                                                                                   = 10069
	NonExclusiveLevelAlarmType_ConditionName                                                                              = 10070
	NonExclusiveLevelAlarmType_BranchID                                                                                   = 10071
	NonExclusiveLevelAlarmType_Retain                                                                                     = 10072
	NonExclusiveLevelAlarmType_EnabledState                                                                               = 10073
	NonExclusiveLevelAlarmType_EnabledState_ID                                                                            = 10074
	NonExclusiveLevelAlarmType_EnabledState_Name                                                                          = 10075
	NonExclusiveLevelAlarmType_EnabledState_Number                                                                        = 10076
	NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName                                                          = 10077
	NonExclusiveLevelAlarmType_EnabledState_TransitionTime                                                                = 10078
	NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime                                                       = 10079
	NonExclusiveLevelAlarmType_EnabledState_TrueState                                                                     = 10080
	NonExclusiveLevelAlarmType_EnabledState_FalseState                                                                    = 10081
	NonExclusiveLevelAlarmType_Quality                                                                                    = 10082
	NonExclusiveLevelAlarmType_Quality_SourceTimestamp                                                                    = 10083
	NonExclusiveLevelAlarmType_LastSeverity                                                                               = 10084
	NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp                                                               = 10085
	NonExclusiveLevelAlarmType_Comment                                                                                    = 10086
	NonExclusiveLevelAlarmType_Comment_SourceTimestamp                                                                    = 10087
	NonExclusiveLevelAlarmType_ClientUserID                                                                               = 10088
	NonExclusiveLevelAlarmType_Enable                                                                                     = 10089
	NonExclusiveLevelAlarmType_Disable                                                                                    = 10090
	NonExclusiveLevelAlarmType_AddComment                                                                                 = 10091
	NonExclusiveLevelAlarmType_AddComment_InputArguments                                                                  = 10092
	NonExclusiveLevelAlarmType_ConditionRefresh                                                                           = 10093
	NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments                                                            = 10094
	NonExclusiveLevelAlarmType_AckedState                                                                                 = 10095
	NonExclusiveLevelAlarmType_AckedState_ID                                                                              = 10096
	NonExclusiveLevelAlarmType_AckedState_Name                                                                            = 10097
	NonExclusiveLevelAlarmType_AckedState_Number                                                                          = 10098
	NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName                                                            = 10099
	NonExclusiveLevelAlarmType_AckedState_TransitionTime                                                                  = 10100
	NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime                                                         = 10101
	NonExclusiveLevelAlarmType_AckedState_TrueState                                                                       = 10102
	NonExclusiveLevelAlarmType_AckedState_FalseState                                                                      = 10103
	NonExclusiveLevelAlarmType_ConfirmedState                                                                             = 10104
	NonExclusiveLevelAlarmType_ConfirmedState_ID                                                                          = 10105
	NonExclusiveLevelAlarmType_ConfirmedState_Name                                                                        = 10106
	NonExclusiveLevelAlarmType_ConfirmedState_Number                                                                      = 10107
	NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName                                                        = 10108
	NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime                                                              = 10109
	NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime                                                     = 10110
	NonExclusiveLevelAlarmType_ConfirmedState_TrueState                                                                   = 10111
	NonExclusiveLevelAlarmType_ConfirmedState_FalseState                                                                  = 10112
	NonExclusiveLevelAlarmType_Acknowledge                                                                                = 10113
	NonExclusiveLevelAlarmType_Acknowledge_InputArguments                                                                 = 10114
	NonExclusiveLevelAlarmType_Confirm                                                                                    = 10115
	NonExclusiveLevelAlarmType_Confirm_InputArguments                                                                     = 10116
	NonExclusiveLevelAlarmType_ActiveState                                                                                = 10117
	NonExclusiveLevelAlarmType_ActiveState_ID                                                                             = 10118
	NonExclusiveLevelAlarmType_ActiveState_Name                                                                           = 10119
	NonExclusiveLevelAlarmType_ActiveState_Number                                                                         = 10120
	NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName                                                           = 10121
	NonExclusiveLevelAlarmType_ActiveState_TransitionTime                                                                 = 10122
	NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime                                                        = 10123
	NonExclusiveLevelAlarmType_ActiveState_TrueState                                                                      = 10124
	NonExclusiveLevelAlarmType_ActiveState_FalseState                                                                     = 10125
	NonExclusiveLevelAlarmType_SuppressedState                                                                            = 10126
	NonExclusiveLevelAlarmType_SuppressedState_ID                                                                         = 10127
	NonExclusiveLevelAlarmType_SuppressedState_Name                                                                       = 10128
	NonExclusiveLevelAlarmType_SuppressedState_Number                                                                     = 10129
	NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName                                                       = 10130
	NonExclusiveLevelAlarmType_SuppressedState_TransitionTime                                                             = 10131
	NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime                                                    = 10132
	NonExclusiveLevelAlarmType_SuppressedState_TrueState                                                                  = 10133
	NonExclusiveLevelAlarmType_SuppressedState_FalseState                                                                 = 10134
	NonExclusiveLevelAlarmType_ShelvingState                                                                              = 10135
	NonExclusiveLevelAlarmType_ShelvingState_CurrentState                                                                 = 10136
	NonExclusiveLevelAlarmType_ShelvingState_CurrentState_ID                                                              = 10137
	NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name                                                            = 10138
	NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number                                                          = 10139
	NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                            = 10140
	NonExclusiveLevelAlarmType_ShelvingState_LastTransition                                                               = 10141
	NonExclusiveLevelAlarmType_ShelvingState_LastTransition_ID                                                            = 10142
	NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name                                                          = 10143
	NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number                                                        = 10144
	NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime                                                = 10145
	NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime                                                                 = 10146
	NonExclusiveLevelAlarmType_ShelvingState_Unshelve                                                                     = 10168
	NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve                                                                = 10169
	NonExclusiveLevelAlarmType_ShelvingState_TimedShelve                                                                  = 10170
	NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments                                                   = 10171
	NonExclusiveLevelAlarmType_SuppressedOrShelved                                                                        = 10172
	NonExclusiveLevelAlarmType_MaxTimeShelved                                                                             = 10173
	NonExclusiveLevelAlarmType_HighHighState                                                                              = 10174
	NonExclusiveLevelAlarmType_HighHighState_ID                                                                           = 10175
	NonExclusiveLevelAlarmType_HighHighState_Name                                                                         = 10176
	NonExclusiveLevelAlarmType_HighHighState_Number                                                                       = 10177
	NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName                                                         = 10178
	NonExclusiveLevelAlarmType_HighHighState_TransitionTime                                                               = 10179
	NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime                                                      = 10180
	NonExclusiveLevelAlarmType_HighHighState_TrueState                                                                    = 10181
	NonExclusiveLevelAlarmType_HighHighState_FalseState                                                                   = 10182
	NonExclusiveLevelAlarmType_HighState                                                                                  = 10183
	NonExclusiveLevelAlarmType_HighState_ID                                                                               = 10184
	NonExclusiveLevelAlarmType_HighState_Name                                                                             = 10185
	NonExclusiveLevelAlarmType_HighState_Number                                                                           = 10186
	NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName                                                             = 10187
	NonExclusiveLevelAlarmType_HighState_TransitionTime                                                                   = 10188
	NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime                                                          = 10189
	NonExclusiveLevelAlarmType_HighState_TrueState                                                                        = 10190
	NonExclusiveLevelAlarmType_HighState_FalseState                                                                       = 10191
	NonExclusiveLevelAlarmType_LowState                                                                                   = 10192
	NonExclusiveLevelAlarmType_LowState_ID                                                                                = 10193
	NonExclusiveLevelAlarmType_LowState_Name                                                                              = 10194
	NonExclusiveLevelAlarmType_LowState_Number                                                                            = 10195
	NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName                                                              = 10196
	NonExclusiveLevelAlarmType_LowState_TransitionTime                                                                    = 10197
	NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime                                                           = 10198
	NonExclusiveLevelAlarmType_LowState_TrueState                                                                         = 10199
	NonExclusiveLevelAlarmType_LowState_FalseState                                                                        = 10200
	NonExclusiveLevelAlarmType_LowLowState                                                                                = 10201
	NonExclusiveLevelAlarmType_LowLowState_ID                                                                             = 10202
	NonExclusiveLevelAlarmType_LowLowState_Name                                                                           = 10203
	NonExclusiveLevelAlarmType_LowLowState_Number                                                                         = 10204
	NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName                                                           = 10205
	NonExclusiveLevelAlarmType_LowLowState_TransitionTime                                                                 = 10206
	NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime                                                        = 10207
	NonExclusiveLevelAlarmType_LowLowState_TrueState                                                                      = 10208
	NonExclusiveLevelAlarmType_LowLowState_FalseState                                                                     = 10209
	NonExclusiveLevelAlarmType_HighHighLimit                                                                              = 10210
	NonExclusiveLevelAlarmType_HighLimit                                                                                  = 10211
	NonExclusiveLevelAlarmType_LowLimit                                                                                   = 10212
	NonExclusiveLevelAlarmType_LowLowLimit                                                                                = 10213
	NonExclusiveRateOfChangeAlarmType                                                                                     = 10214
	NonExclusiveRateOfChangeAlarmType_EventID                                                                             = 10215
	NonExclusiveRateOfChangeAlarmType_EventType                                                                           = 10216
	NonExclusiveRateOfChangeAlarmType_SourceNode                                                                          = 10217
	NonExclusiveRateOfChangeAlarmType_SourceName                                                                          = 10218
	NonExclusiveRateOfChangeAlarmType_Time                                                                                = 10219
	NonExclusiveRateOfChangeAlarmType_ReceiveTime                                                                         = 10220
	NonExclusiveRateOfChangeAlarmType_LocalTime                                                                           = 10221
	NonExclusiveRateOfChangeAlarmType_Message                                                                             = 10222
	NonExclusiveRateOfChangeAlarmType_Severity                                                                            = 10223
	NonExclusiveRateOfChangeAlarmType_ConditionName                                                                       = 10224
	NonExclusiveRateOfChangeAlarmType_BranchID                                                                            = 10225
	NonExclusiveRateOfChangeAlarmType_Retain                                                                              = 10226
	NonExclusiveRateOfChangeAlarmType_EnabledState                                                                        = 10227
	NonExclusiveRateOfChangeAlarmType_EnabledState_ID                                                                     = 10228
	NonExclusiveRateOfChangeAlarmType_EnabledState_Name                                                                   = 10229
	NonExclusiveRateOfChangeAlarmType_EnabledState_Number                                                                 = 10230
	NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName                                                   = 10231
	NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime                                                         = 10232
	NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime                                                = 10233
	NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState                                                              = 10234
	NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState                                                             = 10235
	NonExclusiveRateOfChangeAlarmType_Quality                                                                             = 10236
	NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp                                                             = 10237
	NonExclusiveRateOfChangeAlarmType_LastSeverity                                                                        = 10238
	NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp                                                        = 10239
	NonExclusiveRateOfChangeAlarmType_Comment                                                                             = 10240
	NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp                                                             = 10241
	NonExclusiveRateOfChangeAlarmType_ClientUserID                                                                        = 10242
	NonExclusiveRateOfChangeAlarmType_Enable                                                                              = 10243
	NonExclusiveRateOfChangeAlarmType_Disable                                                                             = 10244
	NonExclusiveRateOfChangeAlarmType_AddComment                                                                          = 10245
	NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments                                                           = 10246
	NonExclusiveRateOfChangeAlarmType_ConditionRefresh                                                                    = 10247
	NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments                                                     = 10248
	NonExclusiveRateOfChangeAlarmType_AckedState                                                                          = 10249
	NonExclusiveRateOfChangeAlarmType_AckedState_ID                                                                       = 10250
	NonExclusiveRateOfChangeAlarmType_AckedState_Name                                                                     = 10251
	NonExclusiveRateOfChangeAlarmType_AckedState_Number                                                                   = 10252
	NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName                                                     = 10253
	NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime                                                           = 10254
	NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime                                                  = 10255
	NonExclusiveRateOfChangeAlarmType_AckedState_TrueState                                                                = 10256
	NonExclusiveRateOfChangeAlarmType_AckedState_FalseState                                                               = 10257
	NonExclusiveRateOfChangeAlarmType_ConfirmedState                                                                      = 10258
	NonExclusiveRateOfChangeAlarmType_ConfirmedState_ID                                                                   = 10259
	NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name                                                                 = 10260
	NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number                                                               = 10261
	NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName                                                 = 10262
	NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime                                                       = 10263
	NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime                                              = 10264
	NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState                                                            = 10265
	NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState                                                           = 10266
	NonExclusiveRateOfChangeAlarmType_Acknowledge                                                                         = 10267
	NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments                                                          = 10268
	NonExclusiveRateOfChangeAlarmType_Confirm                                                                             = 10269
	NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments                                                              = 10270
	NonExclusiveRateOfChangeAlarmType_ActiveState                                                                         = 10271
	NonExclusiveRateOfChangeAlarmType_ActiveState_ID                                                                      = 10272
	NonExclusiveRateOfChangeAlarmType_ActiveState_Name                                                                    = 10273
	NonExclusiveRateOfChangeAlarmType_ActiveState_Number                                                                  = 10274
	NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName                                                    = 10275
	NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime                                                          = 10276
	NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime                                                 = 10277
	NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState                                                               = 10278
	NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState                                                              = 10279
	NonExclusiveRateOfChangeAlarmType_SuppressedState                                                                     = 10280
	NonExclusiveRateOfChangeAlarmType_SuppressedState_ID                                                                  = 10281
	NonExclusiveRateOfChangeAlarmType_SuppressedState_Name                                                                = 10282
	NonExclusiveRateOfChangeAlarmType_SuppressedState_Number                                                              = 10283
	NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName                                                = 10284
	NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime                                                      = 10285
	NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime                                             = 10286
	NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState                                                           = 10287
	NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState                                                          = 10288
	NonExclusiveRateOfChangeAlarmType_ShelvingState                                                                       = 10289
	NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState                                                          = 10290
	NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_ID                                                       = 10291
	NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name                                                     = 10292
	NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number                                                   = 10293
	NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                     = 10294
	NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition                                                        = 10295
	NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_ID                                                     = 10296
	NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name                                                   = 10297
	NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number                                                 = 10298
	NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime                                         = 10299
	NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime                                                          = 10300
	NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve                                                              = 10322
	NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve                                                         = 10323
	NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve                                                           = 10324
	NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments                                            = 10325
	NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved                                                                 = 10326
	NonExclusiveRateOfChangeAlarmType_MaxTimeShelved                                                                      = 10327
	NonExclusiveRateOfChangeAlarmType_HighHighState                                                                       = 10328
	NonExclusiveRateOfChangeAlarmType_HighHighState_ID                                                                    = 10329
	NonExclusiveRateOfChangeAlarmType_HighHighState_Name                                                                  = 10330
	NonExclusiveRateOfChangeAlarmType_HighHighState_Number                                                                = 10331
	NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName                                                  = 10332
	NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime                                                        = 10333
	NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime                                               = 10334
	NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState                                                             = 10335
	NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState                                                            = 10336
	NonExclusiveRateOfChangeAlarmType_HighState                                                                           = 10337
	NonExclusiveRateOfChangeAlarmType_HighState_ID                                                                        = 10338
	NonExclusiveRateOfChangeAlarmType_HighState_Name                                                                      = 10339
	NonExclusiveRateOfChangeAlarmType_HighState_Number                                                                    = 10340
	NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName                                                      = 10341
	NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime                                                            = 10342
	NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime                                                   = 10343
	NonExclusiveRateOfChangeAlarmType_HighState_TrueState                                                                 = 10344
	NonExclusiveRateOfChangeAlarmType_HighState_FalseState                                                                = 10345
	NonExclusiveRateOfChangeAlarmType_LowState                                                                            = 10346
	NonExclusiveRateOfChangeAlarmType_LowState_ID                                                                         = 10347
	NonExclusiveRateOfChangeAlarmType_LowState_Name                                                                       = 10348
	NonExclusiveRateOfChangeAlarmType_LowState_Number                                                                     = 10349
	NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName                                                       = 10350
	NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime                                                             = 10351
	NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime                                                    = 10352
	NonExclusiveRateOfChangeAlarmType_LowState_TrueState                                                                  = 10353
	NonExclusiveRateOfChangeAlarmType_LowState_FalseState                                                                 = 10354
	NonExclusiveRateOfChangeAlarmType_LowLowState                                                                         = 10355
	NonExclusiveRateOfChangeAlarmType_LowLowState_ID                                                                      = 10356
	NonExclusiveRateOfChangeAlarmType_LowLowState_Name                                                                    = 10357
	NonExclusiveRateOfChangeAlarmType_LowLowState_Number                                                                  = 10358
	NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName                                                    = 10359
	NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime                                                          = 10360
	NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime                                                 = 10361
	NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState                                                               = 10362
	NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState                                                              = 10363
	NonExclusiveRateOfChangeAlarmType_HighHighLimit                                                                       = 10364
	NonExclusiveRateOfChangeAlarmType_HighLimit                                                                           = 10365
	NonExclusiveRateOfChangeAlarmType_LowLimit                                                                            = 10366
	NonExclusiveRateOfChangeAlarmType_LowLowLimit                                                                         = 10367
	NonExclusiveDeviationAlarmType                                                                                        = 10368
	NonExclusiveDeviationAlarmType_EventID                                                                                = 10369
	NonExclusiveDeviationAlarmType_EventType                                                                              = 10370
	NonExclusiveDeviationAlarmType_SourceNode                                                                             = 10371
	NonExclusiveDeviationAlarmType_SourceName                                                                             = 10372
	NonExclusiveDeviationAlarmType_Time                                                                                   = 10373
	NonExclusiveDeviationAlarmType_ReceiveTime                                                                            = 10374
	NonExclusiveDeviationAlarmType_LocalTime                                                                              = 10375
	NonExclusiveDeviationAlarmType_Message                                                                                = 10376
	NonExclusiveDeviationAlarmType_Severity                                                                               = 10377
	NonExclusiveDeviationAlarmType_ConditionName                                                                          = 10378
	NonExclusiveDeviationAlarmType_BranchID                                                                               = 10379
	NonExclusiveDeviationAlarmType_Retain                                                                                 = 10380
	NonExclusiveDeviationAlarmType_EnabledState                                                                           = 10381
	NonExclusiveDeviationAlarmType_EnabledState_ID                                                                        = 10382
	NonExclusiveDeviationAlarmType_EnabledState_Name                                                                      = 10383
	NonExclusiveDeviationAlarmType_EnabledState_Number                                                                    = 10384
	NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName                                                      = 10385
	NonExclusiveDeviationAlarmType_EnabledState_TransitionTime                                                            = 10386
	NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime                                                   = 10387
	NonExclusiveDeviationAlarmType_EnabledState_TrueState                                                                 = 10388
	NonExclusiveDeviationAlarmType_EnabledState_FalseState                                                                = 10389
	NonExclusiveDeviationAlarmType_Quality                                                                                = 10390
	NonExclusiveDeviationAlarmType_Quality_SourceTimestamp                                                                = 10391
	NonExclusiveDeviationAlarmType_LastSeverity                                                                           = 10392
	NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp                                                           = 10393
	NonExclusiveDeviationAlarmType_Comment                                                                                = 10394
	NonExclusiveDeviationAlarmType_Comment_SourceTimestamp                                                                = 10395
	NonExclusiveDeviationAlarmType_ClientUserID                                                                           = 10396
	NonExclusiveDeviationAlarmType_Enable                                                                                 = 10397
	NonExclusiveDeviationAlarmType_Disable                                                                                = 10398
	NonExclusiveDeviationAlarmType_AddComment                                                                             = 10399
	NonExclusiveDeviationAlarmType_AddComment_InputArguments                                                              = 10400
	NonExclusiveDeviationAlarmType_ConditionRefresh                                                                       = 10401
	NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments                                                        = 10402
	NonExclusiveDeviationAlarmType_AckedState                                                                             = 10403
	NonExclusiveDeviationAlarmType_AckedState_ID                                                                          = 10404
	NonExclusiveDeviationAlarmType_AckedState_Name                                                                        = 10405
	NonExclusiveDeviationAlarmType_AckedState_Number                                                                      = 10406
	NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName                                                        = 10407
	NonExclusiveDeviationAlarmType_AckedState_TransitionTime                                                              = 10408
	NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime                                                     = 10409
	NonExclusiveDeviationAlarmType_AckedState_TrueState                                                                   = 10410
	NonExclusiveDeviationAlarmType_AckedState_FalseState                                                                  = 10411
	NonExclusiveDeviationAlarmType_ConfirmedState                                                                         = 10412
	NonExclusiveDeviationAlarmType_ConfirmedState_ID                                                                      = 10413
	NonExclusiveDeviationAlarmType_ConfirmedState_Name                                                                    = 10414
	NonExclusiveDeviationAlarmType_ConfirmedState_Number                                                                  = 10415
	NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName                                                    = 10416
	NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime                                                          = 10417
	NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime                                                 = 10418
	NonExclusiveDeviationAlarmType_ConfirmedState_TrueState                                                               = 10419
	NonExclusiveDeviationAlarmType_ConfirmedState_FalseState                                                              = 10420
	NonExclusiveDeviationAlarmType_Acknowledge                                                                            = 10421
	NonExclusiveDeviationAlarmType_Acknowledge_InputArguments                                                             = 10422
	NonExclusiveDeviationAlarmType_Confirm                                                                                = 10423
	NonExclusiveDeviationAlarmType_Confirm_InputArguments                                                                 = 10424
	NonExclusiveDeviationAlarmType_ActiveState                                                                            = 10425
	NonExclusiveDeviationAlarmType_ActiveState_ID                                                                         = 10426
	NonExclusiveDeviationAlarmType_ActiveState_Name                                                                       = 10427
	NonExclusiveDeviationAlarmType_ActiveState_Number                                                                     = 10428
	NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName                                                       = 10429
	NonExclusiveDeviationAlarmType_ActiveState_TransitionTime                                                             = 10430
	NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime                                                    = 10431
	NonExclusiveDeviationAlarmType_ActiveState_TrueState                                                                  = 10432
	NonExclusiveDeviationAlarmType_ActiveState_FalseState                                                                 = 10433
	NonExclusiveDeviationAlarmType_SuppressedState                                                                        = 10434
	NonExclusiveDeviationAlarmType_SuppressedState_ID                                                                     = 10435
	NonExclusiveDeviationAlarmType_SuppressedState_Name                                                                   = 10436
	NonExclusiveDeviationAlarmType_SuppressedState_Number                                                                 = 10437
	NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName                                                   = 10438
	NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime                                                         = 10439
	NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime                                                = 10440
	NonExclusiveDeviationAlarmType_SuppressedState_TrueState                                                              = 10441
	NonExclusiveDeviationAlarmType_SuppressedState_FalseState                                                             = 10442
	NonExclusiveDeviationAlarmType_ShelvingState                                                                          = 10443
	NonExclusiveDeviationAlarmType_ShelvingState_CurrentState                                                             = 10444
	NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_ID                                                          = 10445
	NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name                                                        = 10446
	NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number                                                      = 10447
	NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                        = 10448
	NonExclusiveDeviationAlarmType_ShelvingState_LastTransition                                                           = 10449
	NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_ID                                                        = 10450
	NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name                                                      = 10451
	NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number                                                    = 10452
	NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime                                            = 10453
	NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime                                                             = 10454
	NonExclusiveDeviationAlarmType_ShelvingState_Unshelve                                                                 = 10476
	NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve                                                            = 10477
	NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve                                                              = 10478
	NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments                                               = 10479
	NonExclusiveDeviationAlarmType_SuppressedOrShelved                                                                    = 10480
	NonExclusiveDeviationAlarmType_MaxTimeShelved                                                                         = 10481
	NonExclusiveDeviationAlarmType_HighHighState                                                                          = 10482
	NonExclusiveDeviationAlarmType_HighHighState_ID                                                                       = 10483
	NonExclusiveDeviationAlarmType_HighHighState_Name                                                                     = 10484
	NonExclusiveDeviationAlarmType_HighHighState_Number                                                                   = 10485
	NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName                                                     = 10486
	NonExclusiveDeviationAlarmType_HighHighState_TransitionTime                                                           = 10487
	NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime                                                  = 10488
	NonExclusiveDeviationAlarmType_HighHighState_TrueState                                                                = 10489
	NonExclusiveDeviationAlarmType_HighHighState_FalseState                                                               = 10490
	NonExclusiveDeviationAlarmType_HighState                                                                              = 10491
	NonExclusiveDeviationAlarmType_HighState_ID                                                                           = 10492
	NonExclusiveDeviationAlarmType_HighState_Name                                                                         = 10493
	NonExclusiveDeviationAlarmType_HighState_Number                                                                       = 10494
	NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName                                                         = 10495
	NonExclusiveDeviationAlarmType_HighState_TransitionTime                                                               = 10496
	NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime                                                      = 10497
	NonExclusiveDeviationAlarmType_HighState_TrueState                                                                    = 10498
	NonExclusiveDeviationAlarmType_HighState_FalseState                                                                   = 10499
	NonExclusiveDeviationAlarmType_LowState                                                                               = 10500
	NonExclusiveDeviationAlarmType_LowState_ID                                                                            = 10501
	NonExclusiveDeviationAlarmType_LowState_Name                                                                          = 10502
	NonExclusiveDeviationAlarmType_LowState_Number                                                                        = 10503
	NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName                                                          = 10504
	NonExclusiveDeviationAlarmType_LowState_TransitionTime                                                                = 10505
	NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime                                                       = 10506
	NonExclusiveDeviationAlarmType_LowState_TrueState                                                                     = 10507
	NonExclusiveDeviationAlarmType_LowState_FalseState                                                                    = 10508
	NonExclusiveDeviationAlarmType_LowLowState                                                                            = 10509
	NonExclusiveDeviationAlarmType_LowLowState_ID                                                                         = 10510
	NonExclusiveDeviationAlarmType_LowLowState_Name                                                                       = 10511
	NonExclusiveDeviationAlarmType_LowLowState_Number                                                                     = 10512
	NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName                                                       = 10513
	NonExclusiveDeviationAlarmType_LowLowState_TransitionTime                                                             = 10514
	NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime                                                    = 10515
	NonExclusiveDeviationAlarmType_LowLowState_TrueState                                                                  = 10516
	NonExclusiveDeviationAlarmType_LowLowState_FalseState                                                                 = 10517
	NonExclusiveDeviationAlarmType_HighHighLimit                                                                          = 10518
	NonExclusiveDeviationAlarmType_HighLimit                                                                              = 10519
	NonExclusiveDeviationAlarmType_LowLimit                                                                               = 10520
	NonExclusiveDeviationAlarmType_LowLowLimit                                                                            = 10521
	NonExclusiveDeviationAlarmType_SetpointNode                                                                           = 10522
	DiscreteAlarmType                                                                                                     = 10523
	DiscreteAlarmType_EventID                                                                                             = 10524
	DiscreteAlarmType_EventType                                                                                           = 10525
	DiscreteAlarmType_SourceNode                                                                                          = 10526
	DiscreteAlarmType_SourceName                                                                                          = 10527
	DiscreteAlarmType_Time                                                                                                = 10528
	DiscreteAlarmType_ReceiveTime                                                                                         = 10529
	DiscreteAlarmType_LocalTime                                                                                           = 10530
	DiscreteAlarmType_Message                                                                                             = 10531
	DiscreteAlarmType_Severity                                                                                            = 10532
	DiscreteAlarmType_ConditionName                                                                                       = 10533
	DiscreteAlarmType_BranchID                                                                                            = 10534
	DiscreteAlarmType_Retain                                                                                              = 10535
	DiscreteAlarmType_EnabledState                                                                                        = 10536
	DiscreteAlarmType_EnabledState_ID                                                                                     = 10537
	DiscreteAlarmType_EnabledState_Name                                                                                   = 10538
	DiscreteAlarmType_EnabledState_Number                                                                                 = 10539
	DiscreteAlarmType_EnabledState_EffectiveDisplayName                                                                   = 10540
	DiscreteAlarmType_EnabledState_TransitionTime                                                                         = 10541
	DiscreteAlarmType_EnabledState_EffectiveTransitionTime                                                                = 10542
	DiscreteAlarmType_EnabledState_TrueState                                                                              = 10543
	DiscreteAlarmType_EnabledState_FalseState                                                                             = 10544
	DiscreteAlarmType_Quality                                                                                             = 10545
	DiscreteAlarmType_Quality_SourceTimestamp                                                                             = 10546
	DiscreteAlarmType_LastSeverity                                                                                        = 10547
	DiscreteAlarmType_LastSeverity_SourceTimestamp                                                                        = 10548
	DiscreteAlarmType_Comment                                                                                             = 10549
	DiscreteAlarmType_Comment_SourceTimestamp                                                                             = 10550
	DiscreteAlarmType_ClientUserID                                                                                        = 10551
	DiscreteAlarmType_Enable                                                                                              = 10552
	DiscreteAlarmType_Disable                                                                                             = 10553
	DiscreteAlarmType_AddComment                                                                                          = 10554
	DiscreteAlarmType_AddComment_InputArguments                                                                           = 10555
	DiscreteAlarmType_ConditionRefresh                                                                                    = 10556
	DiscreteAlarmType_ConditionRefresh_InputArguments                                                                     = 10557
	DiscreteAlarmType_AckedState                                                                                          = 10558
	DiscreteAlarmType_AckedState_ID                                                                                       = 10559
	DiscreteAlarmType_AckedState_Name                                                                                     = 10560
	DiscreteAlarmType_AckedState_Number                                                                                   = 10561
	DiscreteAlarmType_AckedState_EffectiveDisplayName                                                                     = 10562
	DiscreteAlarmType_AckedState_TransitionTime                                                                           = 10563
	DiscreteAlarmType_AckedState_EffectiveTransitionTime                                                                  = 10564
	DiscreteAlarmType_AckedState_TrueState                                                                                = 10565
	DiscreteAlarmType_AckedState_FalseState                                                                               = 10566
	DiscreteAlarmType_ConfirmedState                                                                                      = 10567
	DiscreteAlarmType_ConfirmedState_ID                                                                                   = 10568
	DiscreteAlarmType_ConfirmedState_Name                                                                                 = 10569
	DiscreteAlarmType_ConfirmedState_Number                                                                               = 10570
	DiscreteAlarmType_ConfirmedState_EffectiveDisplayName                                                                 = 10571
	DiscreteAlarmType_ConfirmedState_TransitionTime                                                                       = 10572
	DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime                                                              = 10573
	DiscreteAlarmType_ConfirmedState_TrueState                                                                            = 10574
	DiscreteAlarmType_ConfirmedState_FalseState                                                                           = 10575
	DiscreteAlarmType_Acknowledge                                                                                         = 10576
	DiscreteAlarmType_Acknowledge_InputArguments                                                                          = 10577
	DiscreteAlarmType_Confirm                                                                                             = 10578
	DiscreteAlarmType_Confirm_InputArguments                                                                              = 10579
	DiscreteAlarmType_ActiveState                                                                                         = 10580
	DiscreteAlarmType_ActiveState_ID                                                                                      = 10581
	DiscreteAlarmType_ActiveState_Name                                                                                    = 10582
	DiscreteAlarmType_ActiveState_Number                                                                                  = 10583
	DiscreteAlarmType_ActiveState_EffectiveDisplayName                                                                    = 10584
	DiscreteAlarmType_ActiveState_TransitionTime                                                                          = 10585
	DiscreteAlarmType_ActiveState_EffectiveTransitionTime                                                                 = 10586
	DiscreteAlarmType_ActiveState_TrueState                                                                               = 10587
	DiscreteAlarmType_ActiveState_FalseState                                                                              = 10588
	DiscreteAlarmType_SuppressedState                                                                                     = 10589
	DiscreteAlarmType_SuppressedState_ID                                                                                  = 10590
	DiscreteAlarmType_SuppressedState_Name                                                                                = 10591
	DiscreteAlarmType_SuppressedState_Number                                                                              = 10592
	DiscreteAlarmType_SuppressedState_EffectiveDisplayName                                                                = 10593
	DiscreteAlarmType_SuppressedState_TransitionTime                                                                      = 10594
	DiscreteAlarmType_SuppressedState_EffectiveTransitionTime                                                             = 10595
	DiscreteAlarmType_SuppressedState_TrueState                                                                           = 10596
	DiscreteAlarmType_SuppressedState_FalseState                                                                          = 10597
	DiscreteAlarmType_ShelvingState                                                                                       = 10598
	DiscreteAlarmType_ShelvingState_CurrentState                                                                          = 10599
	DiscreteAlarmType_ShelvingState_CurrentState_ID                                                                       = 10600
	DiscreteAlarmType_ShelvingState_CurrentState_Name                                                                     = 10601
	DiscreteAlarmType_ShelvingState_CurrentState_Number                                                                   = 10602
	DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                                     = 10603
	DiscreteAlarmType_ShelvingState_LastTransition                                                                        = 10604
	DiscreteAlarmType_ShelvingState_LastTransition_ID                                                                     = 10605
	DiscreteAlarmType_ShelvingState_LastTransition_Name                                                                   = 10606
	DiscreteAlarmType_ShelvingState_LastTransition_Number                                                                 = 10607
	DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime                                                         = 10608
	DiscreteAlarmType_ShelvingState_UnshelveTime                                                                          = 10609
	DiscreteAlarmType_ShelvingState_Unshelve                                                                              = 10631
	DiscreteAlarmType_ShelvingState_OneShotShelve                                                                         = 10632
	DiscreteAlarmType_ShelvingState_TimedShelve                                                                           = 10633
	DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments                                                            = 10634
	DiscreteAlarmType_SuppressedOrShelved                                                                                 = 10635
	DiscreteAlarmType_MaxTimeShelved                                                                                      = 10636
	OffNormalAlarmType                                                                                                    = 10637
	OffNormalAlarmType_EventID                                                                                            = 10638
	OffNormalAlarmType_EventType                                                                                          = 10639
	OffNormalAlarmType_SourceNode                                                                                         = 10640
	OffNormalAlarmType_SourceName                                                                                         = 10641
	OffNormalAlarmType_Time                                                                                               = 10642
	OffNormalAlarmType_ReceiveTime                                                                                        = 10643
	OffNormalAlarmType_LocalTime                                                                                          = 10644
	OffNormalAlarmType_Message                                                                                            = 10645
	OffNormalAlarmType_Severity                                                                                           = 10646
	OffNormalAlarmType_ConditionName                                                                                      = 10647
	OffNormalAlarmType_BranchID                                                                                           = 10648
	OffNormalAlarmType_Retain                                                                                             = 10649
	OffNormalAlarmType_EnabledState                                                                                       = 10650
	OffNormalAlarmType_EnabledState_ID                                                                                    = 10651
	OffNormalAlarmType_EnabledState_Name                                                                                  = 10652
	OffNormalAlarmType_EnabledState_Number                                                                                = 10653
	OffNormalAlarmType_EnabledState_EffectiveDisplayName                                                                  = 10654
	OffNormalAlarmType_EnabledState_TransitionTime                                                                        = 10655
	OffNormalAlarmType_EnabledState_EffectiveTransitionTime                                                               = 10656
	OffNormalAlarmType_EnabledState_TrueState                                                                             = 10657
	OffNormalAlarmType_EnabledState_FalseState                                                                            = 10658
	OffNormalAlarmType_Quality                                                                                            = 10659
	OffNormalAlarmType_Quality_SourceTimestamp                                                                            = 10660
	OffNormalAlarmType_LastSeverity                                                                                       = 10661
	OffNormalAlarmType_LastSeverity_SourceTimestamp                                                                       = 10662
	OffNormalAlarmType_Comment                                                                                            = 10663
	OffNormalAlarmType_Comment_SourceTimestamp                                                                            = 10664
	OffNormalAlarmType_ClientUserID                                                                                       = 10665
	OffNormalAlarmType_Enable                                                                                             = 10666
	OffNormalAlarmType_Disable                                                                                            = 10667
	OffNormalAlarmType_AddComment                                                                                         = 10668
	OffNormalAlarmType_AddComment_InputArguments                                                                          = 10669
	OffNormalAlarmType_ConditionRefresh                                                                                   = 10670
	OffNormalAlarmType_ConditionRefresh_InputArguments                                                                    = 10671
	OffNormalAlarmType_AckedState                                                                                         = 10672
	OffNormalAlarmType_AckedState_ID                                                                                      = 10673
	OffNormalAlarmType_AckedState_Name                                                                                    = 10674
	OffNormalAlarmType_AckedState_Number                                                                                  = 10675
	OffNormalAlarmType_AckedState_EffectiveDisplayName                                                                    = 10676
	OffNormalAlarmType_AckedState_TransitionTime                                                                          = 10677
	OffNormalAlarmType_AckedState_EffectiveTransitionTime                                                                 = 10678
	OffNormalAlarmType_AckedState_TrueState                                                                               = 10679
	OffNormalAlarmType_AckedState_FalseState                                                                              = 10680
	OffNormalAlarmType_ConfirmedState                                                                                     = 10681
	OffNormalAlarmType_ConfirmedState_ID                                                                                  = 10682
	OffNormalAlarmType_ConfirmedState_Name                                                                                = 10683
	OffNormalAlarmType_ConfirmedState_Number                                                                              = 10684
	OffNormalAlarmType_ConfirmedState_EffectiveDisplayName                                                                = 10685
	OffNormalAlarmType_ConfirmedState_TransitionTime                                                                      = 10686
	OffNormalAlarmType_ConfirmedState_EffectiveTransitionTime                                                             = 10687
	OffNormalAlarmType_ConfirmedState_TrueState                                                                           = 10688
	OffNormalAlarmType_ConfirmedState_FalseState                                                                          = 10689
	OffNormalAlarmType_Acknowledge                                                                                        = 10690
	OffNormalAlarmType_Acknowledge_InputArguments                                                                         = 10691
	OffNormalAlarmType_Confirm                                                                                            = 10692
	OffNormalAlarmType_Confirm_InputArguments                                                                             = 10693
	OffNormalAlarmType_ActiveState                                                                                        = 10694
	OffNormalAlarmType_ActiveState_ID                                                                                     = 10695
	OffNormalAlarmType_ActiveState_Name                                                                                   = 10696
	OffNormalAlarmType_ActiveState_Number                                                                                 = 10697
	OffNormalAlarmType_ActiveState_EffectiveDisplayName                                                                   = 10698
	OffNormalAlarmType_ActiveState_TransitionTime                                                                         = 10699
	OffNormalAlarmType_ActiveState_EffectiveTransitionTime                                                                = 10700
	OffNormalAlarmType_ActiveState_TrueState                                                                              = 10701
	OffNormalAlarmType_ActiveState_FalseState                                                                             = 10702
	OffNormalAlarmType_SuppressedState                                                                                    = 10703
	OffNormalAlarmType_SuppressedState_ID                                                                                 = 10704
	OffNormalAlarmType_SuppressedState_Name                                                                               = 10705
	OffNormalAlarmType_SuppressedState_Number                                                                             = 10706
	OffNormalAlarmType_SuppressedState_EffectiveDisplayName                                                               = 10707
	OffNormalAlarmType_SuppressedState_TransitionTime                                                                     = 10708
	OffNormalAlarmType_SuppressedState_EffectiveTransitionTime                                                            = 10709
	OffNormalAlarmType_SuppressedState_TrueState                                                                          = 10710
	OffNormalAlarmType_SuppressedState_FalseState                                                                         = 10711
	OffNormalAlarmType_ShelvingState                                                                                      = 10712
	OffNormalAlarmType_ShelvingState_CurrentState                                                                         = 10713
	OffNormalAlarmType_ShelvingState_CurrentState_ID                                                                      = 10714
	OffNormalAlarmType_ShelvingState_CurrentState_Name                                                                    = 10715
	OffNormalAlarmType_ShelvingState_CurrentState_Number                                                                  = 10716
	OffNormalAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                                    = 10717
	OffNormalAlarmType_ShelvingState_LastTransition                                                                       = 10718
	OffNormalAlarmType_ShelvingState_LastTransition_ID                                                                    = 10719
	OffNormalAlarmType_ShelvingState_LastTransition_Name                                                                  = 10720
	OffNormalAlarmType_ShelvingState_LastTransition_Number                                                                = 10721
	OffNormalAlarmType_ShelvingState_LastTransition_TransitionTime                                                        = 10722
	OffNormalAlarmType_ShelvingState_UnshelveTime                                                                         = 10723
	OffNormalAlarmType_ShelvingState_Unshelve                                                                             = 10745
	OffNormalAlarmType_ShelvingState_OneShotShelve                                                                        = 10746
	OffNormalAlarmType_ShelvingState_TimedShelve                                                                          = 10747
	OffNormalAlarmType_ShelvingState_TimedShelve_InputArguments                                                           = 10748
	OffNormalAlarmType_SuppressedOrShelved                                                                                = 10749
	OffNormalAlarmType_MaxTimeShelved                                                                                     = 10750
	TripAlarmType                                                                                                         = 10751
	TripAlarmType_EventID                                                                                                 = 10752
	TripAlarmType_EventType                                                                                               = 10753
	TripAlarmType_SourceNode                                                                                              = 10754
	TripAlarmType_SourceName                                                                                              = 10755
	TripAlarmType_Time                                                                                                    = 10756
	TripAlarmType_ReceiveTime                                                                                             = 10757
	TripAlarmType_LocalTime                                                                                               = 10758
	TripAlarmType_Message                                                                                                 = 10759
	TripAlarmType_Severity                                                                                                = 10760
	TripAlarmType_ConditionName                                                                                           = 10761
	TripAlarmType_BranchID                                                                                                = 10762
	TripAlarmType_Retain                                                                                                  = 10763
	TripAlarmType_EnabledState                                                                                            = 10764
	TripAlarmType_EnabledState_ID                                                                                         = 10765
	TripAlarmType_EnabledState_Name                                                                                       = 10766
	TripAlarmType_EnabledState_Number                                                                                     = 10767
	TripAlarmType_EnabledState_EffectiveDisplayName                                                                       = 10768
	TripAlarmType_EnabledState_TransitionTime                                                                             = 10769
	TripAlarmType_EnabledState_EffectiveTransitionTime                                                                    = 10770
	TripAlarmType_EnabledState_TrueState                                                                                  = 10771
	TripAlarmType_EnabledState_FalseState                                                                                 = 10772
	TripAlarmType_Quality                                                                                                 = 10773
	TripAlarmType_Quality_SourceTimestamp                                                                                 = 10774
	TripAlarmType_LastSeverity                                                                                            = 10775
	TripAlarmType_LastSeverity_SourceTimestamp                                                                            = 10776
	TripAlarmType_Comment                                                                                                 = 10777
	TripAlarmType_Comment_SourceTimestamp                                                                                 = 10778
	TripAlarmType_ClientUserID                                                                                            = 10779
	TripAlarmType_Enable                                                                                                  = 10780
	TripAlarmType_Disable                                                                                                 = 10781
	TripAlarmType_AddComment                                                                                              = 10782
	TripAlarmType_AddComment_InputArguments                                                                               = 10783
	TripAlarmType_ConditionRefresh                                                                                        = 10784
	TripAlarmType_ConditionRefresh_InputArguments                                                                         = 10785
	TripAlarmType_AckedState                                                                                              = 10786
	TripAlarmType_AckedState_ID                                                                                           = 10787
	TripAlarmType_AckedState_Name                                                                                         = 10788
	TripAlarmType_AckedState_Number                                                                                       = 10789
	TripAlarmType_AckedState_EffectiveDisplayName                                                                         = 10790
	TripAlarmType_AckedState_TransitionTime                                                                               = 10791
	TripAlarmType_AckedState_EffectiveTransitionTime                                                                      = 10792
	TripAlarmType_AckedState_TrueState                                                                                    = 10793
	TripAlarmType_AckedState_FalseState                                                                                   = 10794
	TripAlarmType_ConfirmedState                                                                                          = 10795
	TripAlarmType_ConfirmedState_ID                                                                                       = 10796
	TripAlarmType_ConfirmedState_Name                                                                                     = 10797
	TripAlarmType_ConfirmedState_Number                                                                                   = 10798
	TripAlarmType_ConfirmedState_EffectiveDisplayName                                                                     = 10799
	TripAlarmType_ConfirmedState_TransitionTime                                                                           = 10800
	TripAlarmType_ConfirmedState_EffectiveTransitionTime                                                                  = 10801
	TripAlarmType_ConfirmedState_TrueState                                                                                = 10802
	TripAlarmType_ConfirmedState_FalseState                                                                               = 10803
	TripAlarmType_Acknowledge                                                                                             = 10804
	TripAlarmType_Acknowledge_InputArguments                                                                              = 10805
	TripAlarmType_Confirm                                                                                                 = 10806
	TripAlarmType_Confirm_InputArguments                                                                                  = 10807
	TripAlarmType_ActiveState                                                                                             = 10808
	TripAlarmType_ActiveState_ID                                                                                          = 10809
	TripAlarmType_ActiveState_Name                                                                                        = 10810
	TripAlarmType_ActiveState_Number                                                                                      = 10811
	TripAlarmType_ActiveState_EffectiveDisplayName                                                                        = 10812
	TripAlarmType_ActiveState_TransitionTime                                                                              = 10813
	TripAlarmType_ActiveState_EffectiveTransitionTime                                                                     = 10814
	TripAlarmType_ActiveState_TrueState                                                                                   = 10815
	TripAlarmType_ActiveState_FalseState                                                                                  = 10816
	TripAlarmType_SuppressedState                                                                                         = 10817
	TripAlarmType_SuppressedState_ID                                                                                      = 10818
	TripAlarmType_SuppressedState_Name                                                                                    = 10819
	TripAlarmType_SuppressedState_Number                                                                                  = 10820
	TripAlarmType_SuppressedState_EffectiveDisplayName                                                                    = 10821
	TripAlarmType_SuppressedState_TransitionTime                                                                          = 10822
	TripAlarmType_SuppressedState_EffectiveTransitionTime                                                                 = 10823
	TripAlarmType_SuppressedState_TrueState                                                                               = 10824
	TripAlarmType_SuppressedState_FalseState                                                                              = 10825
	TripAlarmType_ShelvingState                                                                                           = 10826
	TripAlarmType_ShelvingState_CurrentState                                                                              = 10827
	TripAlarmType_ShelvingState_CurrentState_ID                                                                           = 10828
	TripAlarmType_ShelvingState_CurrentState_Name                                                                         = 10829
	TripAlarmType_ShelvingState_CurrentState_Number                                                                       = 10830
	TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                                         = 10831
	TripAlarmType_ShelvingState_LastTransition                                                                            = 10832
	TripAlarmType_ShelvingState_LastTransition_ID                                                                         = 10833
	TripAlarmType_ShelvingState_LastTransition_Name                                                                       = 10834
	TripAlarmType_ShelvingState_LastTransition_Number                                                                     = 10835
	TripAlarmType_ShelvingState_LastTransition_TransitionTime                                                             = 10836
	TripAlarmType_ShelvingState_UnshelveTime                                                                              = 10837
	TripAlarmType_ShelvingState_Unshelve                                                                                  = 10859
	TripAlarmType_ShelvingState_OneShotShelve                                                                             = 10860
	TripAlarmType_ShelvingState_TimedShelve                                                                               = 10861
	TripAlarmType_ShelvingState_TimedShelve_InputArguments                                                                = 10862
	TripAlarmType_SuppressedOrShelved                                                                                     = 10863
	TripAlarmType_MaxTimeShelved                                                                                          = 10864
	AuditConditionShelvingEventType                                                                                       = 11093
	AuditConditionShelvingEventType_EventID                                                                               = 11094
	AuditConditionShelvingEventType_EventType                                                                             = 11095
	AuditConditionShelvingEventType_SourceNode                                                                            = 11096
	AuditConditionShelvingEventType_SourceName                                                                            = 11097
	AuditConditionShelvingEventType_Time                                                                                  = 11098
	AuditConditionShelvingEventType_ReceiveTime                                                                           = 11099
	AuditConditionShelvingEventType_LocalTime                                                                             = 11100
	AuditConditionShelvingEventType_Message                                                                               = 11101
	AuditConditionShelvingEventType_Severity                                                                              = 11102
	AuditConditionShelvingEventType_ActionTimeStamp                                                                       = 11103
	AuditConditionShelvingEventType_Status                                                                                = 11104
	AuditConditionShelvingEventType_ServerID                                                                              = 11105
	AuditConditionShelvingEventType_ClientAuditEntryID                                                                    = 11106
	AuditConditionShelvingEventType_ClientUserID                                                                          = 11107
	AuditConditionShelvingEventType_MethodID                                                                              = 11108
	AuditConditionShelvingEventType_InputArguments                                                                        = 11109
	TwoStateVariableType_TrueState                                                                                        = 11110
	TwoStateVariableType_FalseState                                                                                       = 11111
	ConditionType_ConditionClassID                                                                                        = 11112
	ConditionType_ConditionClassName                                                                                      = 11113
	DialogConditionType_ConditionClassID                                                                                  = 11114
	DialogConditionType_ConditionClassName                                                                                = 11115
	AcknowledgeableConditionType_ConditionClassID                                                                         = 11116
	AcknowledgeableConditionType_ConditionClassName                                                                       = 11117
	AlarmConditionType_ConditionClassID                                                                                   = 11118
	AlarmConditionType_ConditionClassName                                                                                 = 11119
	AlarmConditionType_InputNode                                                                                          = 11120
	LimitAlarmType_ConditionClassID                                                                                       = 11121
	LimitAlarmType_ConditionClassName                                                                                     = 11122
	LimitAlarmType_InputNode                                                                                              = 11123
	LimitAlarmType_HighHighLimit                                                                                          = 11124
	LimitAlarmType_HighLimit                                                                                              = 11125
	LimitAlarmType_LowLimit                                                                                               = 11126
	LimitAlarmType_LowLowLimit                                                                                            = 11127
	ExclusiveLimitAlarmType_ConditionClassID                                                                              = 11128
	ExclusiveLimitAlarmType_ConditionClassName                                                                            = 11129
	ExclusiveLimitAlarmType_InputNode                                                                                     = 11130
	ExclusiveLevelAlarmType_ConditionClassID                                                                              = 11131
	ExclusiveLevelAlarmType_ConditionClassName                                                                            = 11132
	ExclusiveLevelAlarmType_InputNode                                                                                     = 11133
	ExclusiveRateOfChangeAlarmType_ConditionClassID                                                                       = 11134
	ExclusiveRateOfChangeAlarmType_ConditionClassName                                                                     = 11135
	ExclusiveRateOfChangeAlarmType_InputNode                                                                              = 11136
	ExclusiveDeviationAlarmType_ConditionClassID                                                                          = 11137
	ExclusiveDeviationAlarmType_ConditionClassName                                                                        = 11138
	ExclusiveDeviationAlarmType_InputNode                                                                                 = 11139
	NonExclusiveLimitAlarmType_ConditionClassID                                                                           = 11140
	NonExclusiveLimitAlarmType_ConditionClassName                                                                         = 11141
	NonExclusiveLimitAlarmType_InputNode                                                                                  = 11142
	NonExclusiveLevelAlarmType_ConditionClassID                                                                           = 11143
	NonExclusiveLevelAlarmType_ConditionClassName                                                                         = 11144
	NonExclusiveLevelAlarmType_InputNode                                                                                  = 11145
	NonExclusiveRateOfChangeAlarmType_ConditionClassID                                                                    = 11146
	NonExclusiveRateOfChangeAlarmType_ConditionClassName                                                                  = 11147
	NonExclusiveRateOfChangeAlarmType_InputNode                                                                           = 11148
	NonExclusiveDeviationAlarmType_ConditionClassID                                                                       = 11149
	NonExclusiveDeviationAlarmType_ConditionClassName                                                                     = 11150
	NonExclusiveDeviationAlarmType_InputNode                                                                              = 11151
	DiscreteAlarmType_ConditionClassID                                                                                    = 11152
	DiscreteAlarmType_ConditionClassName                                                                                  = 11153
	DiscreteAlarmType_InputNode                                                                                           = 11154
	OffNormalAlarmType_ConditionClassID                                                                                   = 11155
	OffNormalAlarmType_ConditionClassName                                                                                 = 11156
	OffNormalAlarmType_InputNode                                                                                          = 11157
	OffNormalAlarmType_NormalState                                                                                        = 11158
	TripAlarmType_ConditionClassID                                                                                        = 11159
	TripAlarmType_ConditionClassName                                                                                      = 11160
	TripAlarmType_InputNode                                                                                               = 11161
	TripAlarmType_NormalState                                                                                             = 11162
	BaseConditionClassType                                                                                                = 11163
	ProcessConditionClassType                                                                                             = 11164
	MaintenanceConditionClassType                                                                                         = 11165
	SystemConditionClassType                                                                                              = 11166
	HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad                                            = 11168
	HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad                                                 = 11169
	HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood                                                = 11170
	HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation                                         = 11171
	HistoryServerCapabilitiesType_AggregateFunctions                                                                      = 11172
	AggregateConfigurationType                                                                                            = 11187
	AggregateConfigurationType_TreatUncertainAsBad                                                                        = 11188
	AggregateConfigurationType_PercentDataBad                                                                             = 11189
	AggregateConfigurationType_PercentDataGood                                                                            = 11190
	AggregateConfigurationType_UseSlopedExtrapolation                                                                     = 11191
	HistoryServerCapabilities                                                                                             = 11192
	HistoryServerCapabilities_AccessHistoryDataCapability                                                                 = 11193
	HistoryServerCapabilities_InsertDataCapability                                                                        = 11196
	HistoryServerCapabilities_ReplaceDataCapability                                                                       = 11197
	HistoryServerCapabilities_UpdateDataCapability                                                                        = 11198
	HistoryServerCapabilities_DeleteRawCapability                                                                         = 11199
	HistoryServerCapabilities_DeleteAtTimeCapability                                                                      = 11200
	HistoryServerCapabilities_AggregateFunctions                                                                          = 11201
	HAConfiguration                                                                                                       = 11202
	HAConfiguration_AggregateConfiguration                                                                                = 11203
	HAConfiguration_AggregateConfiguration_TreatUncertainAsBad                                                            = 11204
	HAConfiguration_AggregateConfiguration_PercentDataBad                                                                 = 11205
	HAConfiguration_AggregateConfiguration_PercentDataGood                                                                = 11206
	HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation                                                         = 11207
	HAConfiguration_Stepped                                                                                               = 11208
	HAConfiguration_Definition                                                                                            = 11209
	HAConfiguration_MaxTimeInterval                                                                                       = 11210
	HAConfiguration_MinTimeInterval                                                                                       = 11211
	HAConfiguration_ExceptionDeviation                                                                                    = 11212
	HAConfiguration_ExceptionDeviationFormat                                                                              = 11213
	Annotations                                                                                                           = 11214
	HistoricalEventFilter                                                                                                 = 11215
	ModificationInfo                                                                                                      = 11216
	HistoryModifiedData                                                                                                   = 11217
	ModificationInfo_Encoding_DefaultXML                                                                                  = 11218
	HistoryModifiedData_Encoding_DefaultXML                                                                               = 11219
	ModificationInfo_Encoding_DefaultBinary                                                                               = 11226
	HistoryModifiedData_Encoding_DefaultBinary                                                                            = 11227
	HistoryUpdateType                                                                                                     = 11234
	MultiStateValueDiscreteType                                                                                           = 11238
	MultiStateValueDiscreteType_Definition                                                                                = 11239
	MultiStateValueDiscreteType_ValuePrecision                                                                            = 11240
	MultiStateValueDiscreteType_EnumValues                                                                                = 11241
	HistoryServerCapabilities_AccessHistoryEventsCapability                                                               = 11242
	HistoryServerCapabilitiesType_MaxReturnDataValues                                                                     = 11268
	HistoryServerCapabilitiesType_MaxReturnEventValues                                                                    = 11269
	HistoryServerCapabilitiesType_InsertAnnotationCapability                                                              = 11270
	HistoryServerCapabilities_MaxReturnDataValues                                                                         = 11273
	HistoryServerCapabilities_MaxReturnEventValues                                                                        = 11274
	HistoryServerCapabilities_InsertAnnotationCapability                                                                  = 11275
	HistoryServerCapabilitiesType_InsertEventCapability                                                                   = 11278
	HistoryServerCapabilitiesType_ReplaceEventCapability                                                                  = 11279
	HistoryServerCapabilitiesType_UpdateEventCapability                                                                   = 11280
	HistoryServerCapabilities_InsertEventCapability                                                                       = 11281
	HistoryServerCapabilities_ReplaceEventCapability                                                                      = 11282
	HistoryServerCapabilities_UpdateEventCapability                                                                       = 11283
	AggregateFunction_TimeAverage2                                                                                        = 11285
	AggregateFunction_Minimum2                                                                                            = 11286
	AggregateFunction_Maximum2                                                                                            = 11287
	AggregateFunction_Range2                                                                                              = 11288
	AggregateFunction_WorstQuality2                                                                                       = 11292
	PerformUpdateType                                                                                                     = 11293
	UpdateStructureDataDetails                                                                                            = 11295
	UpdateStructureDataDetails_Encoding_DefaultXML                                                                        = 11296
	UpdateStructureDataDetails_Encoding_DefaultBinary                                                                     = 11300
	AggregateFunction_Total2                                                                                              = 11304
	AggregateFunction_MinimumActualTime2                                                                                  = 11305
	AggregateFunction_MaximumActualTime2                                                                                  = 11306
	AggregateFunction_DurationInStateZero                                                                                 = 11307
	AggregateFunction_DurationInStateNonZero                                                                              = 11308
	Server_ServerRedundancy_CurrentServerID                                                                               = 11312
	Server_ServerRedundancy_RedundantServerArray                                                                          = 11313
	Server_ServerRedundancy_ServerURIArray                                                                                = 11314
	ShelvedStateMachineType_UnshelvedToTimedShelved_TransitionNumber                                                      = 11322
	ShelvedStateMachineType_UnshelvedToOneShotShelved_TransitionNumber                                                    = 11323
	ShelvedStateMachineType_TimedShelvedToUnshelved_TransitionNumber                                                      = 11324
	ShelvedStateMachineType_TimedShelvedToOneShotShelved_TransitionNumber                                                 = 11325
	ShelvedStateMachineType_OneShotShelvedToUnshelved_TransitionNumber                                                    = 11326
	ShelvedStateMachineType_OneShotShelvedToTimedShelved_TransitionNumber                                                 = 11327
	ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber                                                           = 11340
	ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber                                                           = 11341
	ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber                                                        = 11342
	ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber                                                        = 11343
	AggregateFunction_StandardDeviationSample                                                                             = 11426
	AggregateFunction_StandardDeviationPopulation                                                                         = 11427
	AggregateFunction_VarianceSample                                                                                      = 11428
	AggregateFunction_VariancePopulation                                                                                  = 11429
	EnumStrings                                                                                                           = 11432
	ValueAsText                                                                                                           = 11433
	ProgressEventType                                                                                                     = 11436
	ProgressEventType_EventID                                                                                             = 11437
	ProgressEventType_EventType                                                                                           = 11438
	ProgressEventType_SourceNode                                                                                          = 11439
	ProgressEventType_SourceName                                                                                          = 11440
	ProgressEventType_Time                                                                                                = 11441
	ProgressEventType_ReceiveTime                                                                                         = 11442
	ProgressEventType_LocalTime                                                                                           = 11443
	ProgressEventType_Message                                                                                             = 11444
	ProgressEventType_Severity                                                                                            = 11445
	SystemStatusChangeEventType                                                                                           = 11446
	SystemStatusChangeEventType_EventID                                                                                   = 11447
	SystemStatusChangeEventType_EventType                                                                                 = 11448
	SystemStatusChangeEventType_SourceNode                                                                                = 11449
	SystemStatusChangeEventType_SourceName                                                                                = 11450
	SystemStatusChangeEventType_Time                                                                                      = 11451
	SystemStatusChangeEventType_ReceiveTime                                                                               = 11452
	SystemStatusChangeEventType_LocalTime                                                                                 = 11453
	SystemStatusChangeEventType_Message                                                                                   = 11454
	SystemStatusChangeEventType_Severity                                                                                  = 11455
	TransitionVariableType_EffectiveTransitionTime                                                                        = 11456
	FiniteTransitionVariableType_EffectiveTransitionTime                                                                  = 11457
	StateMachineType_LastTransition_EffectiveTransitionTime                                                               = 11458
	FiniteStateMachineType_LastTransition_EffectiveTransitionTime                                                         = 11459
	TransitionEventType_Transition_EffectiveTransitionTime                                                                = 11460
	MultiStateValueDiscreteType_ValueAsText                                                                               = 11461
	ProgramTransitionEventType_Transition_EffectiveTransitionTime                                                         = 11462
	ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime                                                    = 11463
	ProgramStateMachineType_LastTransition_EffectiveTransitionTime                                                        = 11464
	ShelvedStateMachineType_LastTransition_EffectiveTransitionTime                                                        = 11465
	AlarmConditionType_ShelvingState_LastTransition_EffectiveTransitionTime                                               = 11466
	LimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                                   = 11467
	ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime                                                 = 11468
	ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                          = 11469
	ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime                                             = 11470
	ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                          = 11471
	ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime                                             = 11472
	ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                   = 11473
	ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime                                      = 11474
	ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                      = 11475
	ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime                                         = 11476
	NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                       = 11477
	NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                       = 11478
	NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                = 11479
	NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                   = 11480
	DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                                = 11481
	OffNormalAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                               = 11482
	TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                                    = 11483
	AuditActivateSessionEventType_SecureChannelID                                                                         = 11485
	OptionSetType                                                                                                         = 11487
	OptionSetType_OptionSetValues                                                                                         = 11488
	ServerType_GetMonitoredItems                                                                                          = 11489
	ServerType_GetMonitoredItems_InputArguments                                                                           = 11490
	ServerType_GetMonitoredItems_OutputArguments                                                                          = 11491
	Server_GetMonitoredItems                                                                                              = 11492
	Server_GetMonitoredItems_InputArguments                                                                               = 11493
	Server_GetMonitoredItems_OutputArguments                                                                              = 11494
	GetMonitoredItemsMethodType                                                                                           = 11495
	GetMonitoredItemsMethodType_InputArguments                                                                            = 11496
	GetMonitoredItemsMethodType_OutputArguments                                                                           = 11497
	MaxStringLength                                                                                                       = 11498
	HistoricalDataConfigurationType_StartOfArchive                                                                        = 11499
	HistoricalDataConfigurationType_StartOfOnlineArchive                                                                  = 11500
	HistoryServerCapabilitiesType_DeleteEventCapability                                                                   = 11501
	HistoryServerCapabilities_DeleteEventCapability                                                                       = 11502
	HAConfiguration_StartOfArchive                                                                                        = 11503
	HAConfiguration_StartOfOnlineArchive                                                                                  = 11504
	AggregateFunction_StartBound                                                                                          = 11505
	AggregateFunction_EndBound                                                                                            = 11506
	AggregateFunction_DeltaBounds                                                                                         = 11507
	ModellingRule_OptionalPlaceholder                                                                                     = 11508
	ModellingRule_OptionalPlaceholder_NamingRule                                                                          = 11509
	ModellingRule_MandatoryPlaceholder                                                                                    = 11510
	ModellingRule_MandatoryPlaceholder_NamingRule                                                                         = 11511
	MaxArrayLength                                                                                                        = 11512
	EngineeringUnits                                                                                                      = 11513
	ServerType_ServerCapabilities_MaxArrayLength                                                                          = 11514
	ServerType_ServerCapabilities_MaxStringLength                                                                         = 11515
	ServerType_ServerCapabilities_OperationLimits                                                                         = 11516
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRead                                                         = 11517
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerWrite                                                        = 11519
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall                                                   = 11521
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerBrowse                                                       = 11522
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes                                                = 11523
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIDs                                = 11524
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement                                               = 11525
	ServerType_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall                                                = 11526
	ServerType_Namespaces                                                                                                 = 11527
	ServerCapabilitiesType_MaxArrayLength                                                                                 = 11549
	ServerCapabilitiesType_MaxStringLength                                                                                = 11550
	ServerCapabilitiesType_OperationLimits                                                                                = 11551
	ServerCapabilitiesType_OperationLimits_MaxNodesPerRead                                                                = 11552
	ServerCapabilitiesType_OperationLimits_MaxNodesPerWrite                                                               = 11554
	ServerCapabilitiesType_OperationLimits_MaxNodesPerMethodCall                                                          = 11556
	ServerCapabilitiesType_OperationLimits_MaxNodesPerBrowse                                                              = 11557
	ServerCapabilitiesType_OperationLimits_MaxNodesPerRegisterNodes                                                       = 11558
	ServerCapabilitiesType_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIDs                                       = 11559
	ServerCapabilitiesType_OperationLimits_MaxNodesPerNodeManagement                                                      = 11560
	ServerCapabilitiesType_OperationLimits_MaxMonitoredItemsPerCall                                                       = 11561
	ServerCapabilitiesType_VendorCapability_Placeholder                                                                   = 11562
	OperationLimitsType                                                                                                   = 11564
	OperationLimitsType_MaxNodesPerRead                                                                                   = 11565
	OperationLimitsType_MaxNodesPerWrite                                                                                  = 11567
	OperationLimitsType_MaxNodesPerMethodCall                                                                             = 11569
	OperationLimitsType_MaxNodesPerBrowse                                                                                 = 11570
	OperationLimitsType_MaxNodesPerRegisterNodes                                                                          = 11571
	OperationLimitsType_MaxNodesPerTranslateBrowsePathsToNodeIDs                                                          = 11572
	OperationLimitsType_MaxNodesPerNodeManagement                                                                         = 11573
	OperationLimitsType_MaxMonitoredItemsPerCall                                                                          = 11574
	FileType                                                                                                              = 11575
	FileType_Size                                                                                                         = 11576
	FileType_OpenCount                                                                                                    = 11579
	FileType_Open                                                                                                         = 11580
	FileType_Open_InputArguments                                                                                          = 11581
	FileType_Open_OutputArguments                                                                                         = 11582
	FileType_Close                                                                                                        = 11583
	FileType_Close_InputArguments                                                                                         = 11584
	FileType_Read                                                                                                         = 11585
	FileType_Read_InputArguments                                                                                          = 11586
	FileType_Read_OutputArguments                                                                                         = 11587
	FileType_Write                                                                                                        = 11588
	FileType_Write_InputArguments                                                                                         = 11589
	FileType_GetPosition                                                                                                  = 11590
	FileType_GetPosition_InputArguments                                                                                   = 11591
	FileType_GetPosition_OutputArguments                                                                                  = 11592
	FileType_SetPosition                                                                                                  = 11593
	FileType_SetPosition_InputArguments                                                                                   = 11594
	AddressSpaceFileType                                                                                                  = 11595
	AddressSpaceFileType_Size                                                                                             = 11596
	AddressSpaceFileType_OpenCount                                                                                        = 11599
	AddressSpaceFileType_Open                                                                                             = 11600
	AddressSpaceFileType_Open_InputArguments                                                                              = 11601
	AddressSpaceFileType_Open_OutputArguments                                                                             = 11602
	AddressSpaceFileType_Close                                                                                            = 11603
	AddressSpaceFileType_Close_InputArguments                                                                             = 11604
	AddressSpaceFileType_Read                                                                                             = 11605
	AddressSpaceFileType_Read_InputArguments                                                                              = 11606
	AddressSpaceFileType_Read_OutputArguments                                                                             = 11607
	AddressSpaceFileType_Write                                                                                            = 11608
	AddressSpaceFileType_Write_InputArguments                                                                             = 11609
	AddressSpaceFileType_GetPosition                                                                                      = 11610
	AddressSpaceFileType_GetPosition_InputArguments                                                                       = 11611
	AddressSpaceFileType_GetPosition_OutputArguments                                                                      = 11612
	AddressSpaceFileType_SetPosition                                                                                      = 11613
	AddressSpaceFileType_SetPosition_InputArguments                                                                       = 11614
	AddressSpaceFileType_ExportNamespace                                                                                  = 11615
	NamespaceMetadataType                                                                                                 = 11616
	NamespaceMetadataType_NamespaceURI                                                                                    = 11617
	NamespaceMetadataType_NamespaceVersion                                                                                = 11618
	NamespaceMetadataType_NamespacePublicationDate                                                                        = 11619
	NamespaceMetadataType_IsNamespaceSubset                                                                               = 11620
	NamespaceMetadataType_StaticNodeIDTypes                                                                               = 11621
	NamespaceMetadataType_StaticNumericNodeIDRange                                                                        = 11622
	NamespaceMetadataType_StaticStringNodeIDPattern                                                                       = 11623
	NamespaceMetadataType_NamespaceFile                                                                                   = 11624
	NamespaceMetadataType_NamespaceFile_Size                                                                              = 11625
	NamespaceMetadataType_NamespaceFile_OpenCount                                                                         = 11628
	NamespaceMetadataType_NamespaceFile_Open                                                                              = 11629
	NamespaceMetadataType_NamespaceFile_Open_InputArguments                                                               = 11630
	NamespaceMetadataType_NamespaceFile_Open_OutputArguments                                                              = 11631
	NamespaceMetadataType_NamespaceFile_Close                                                                             = 11632
	NamespaceMetadataType_NamespaceFile_Close_InputArguments                                                              = 11633
	NamespaceMetadataType_NamespaceFile_Read                                                                              = 11634
	NamespaceMetadataType_NamespaceFile_Read_InputArguments                                                               = 11635
	NamespaceMetadataType_NamespaceFile_Read_OutputArguments                                                              = 11636
	NamespaceMetadataType_NamespaceFile_Write                                                                             = 11637
	NamespaceMetadataType_NamespaceFile_Write_InputArguments                                                              = 11638
	NamespaceMetadataType_NamespaceFile_GetPosition                                                                       = 11639
	NamespaceMetadataType_NamespaceFile_GetPosition_InputArguments                                                        = 11640
	NamespaceMetadataType_NamespaceFile_GetPosition_OutputArguments                                                       = 11641
	NamespaceMetadataType_NamespaceFile_SetPosition                                                                       = 11642
	NamespaceMetadataType_NamespaceFile_SetPosition_InputArguments                                                        = 11643
	NamespaceMetadataType_NamespaceFile_ExportNamespace                                                                   = 11644
	NamespacesType                                                                                                        = 11645
	NamespacesType_NamespaceIDentifier_Placeholder                                                                        = 11646
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceURI                                                           = 11647
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceVersion                                                       = 11648
	NamespacesType_NamespaceIDentifier_Placeholder_NamespacePublicationDate                                               = 11649
	NamespacesType_NamespaceIDentifier_Placeholder_IsNamespaceSubset                                                      = 11650
	NamespacesType_NamespaceIDentifier_Placeholder_StaticNodeIDTypes                                                      = 11651
	NamespacesType_NamespaceIDentifier_Placeholder_StaticNumericNodeIDRange                                               = 11652
	NamespacesType_NamespaceIDentifier_Placeholder_StaticStringNodeIDPattern                                              = 11653
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile                                                          = 11654
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Size                                                     = 11655
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_OpenCount                                                = 11658
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Open                                                     = 11659
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Open_InputArguments                                      = 11660
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Open_OutputArguments                                     = 11661
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Close                                                    = 11662
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Close_InputArguments                                     = 11663
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Read                                                     = 11664
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Read_InputArguments                                      = 11665
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Read_OutputArguments                                     = 11666
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Write                                                    = 11667
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Write_InputArguments                                     = 11668
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_GetPosition                                              = 11669
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_GetPosition_InputArguments                               = 11670
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_GetPosition_OutputArguments                              = 11671
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_SetPosition                                              = 11672
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_SetPosition_InputArguments                               = 11673
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_ExportNamespace                                          = 11674
	SystemStatusChangeEventType_SystemState                                                                               = 11696
	SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount                                                            = 11697
	SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount                                                         = 11698
	SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount                                                   = 11699
	OptionSetType_BitMask                                                                                                 = 11701
	Server_ServerCapabilities_MaxArrayLength                                                                              = 11702
	Server_ServerCapabilities_MaxStringLength                                                                             = 11703
	Server_ServerCapabilities_OperationLimits                                                                             = 11704
	Server_ServerCapabilities_OperationLimits_MaxNodesPerRead                                                             = 11705
	Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite                                                            = 11707
	Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall                                                       = 11709
	Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse                                                           = 11710
	Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes                                                    = 11711
	Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIDs                                    = 11712
	Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement                                                   = 11713
	Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall                                                    = 11714
	Server_Namespaces                                                                                                     = 11715
	BitFieldMaskDataType                                                                                                  = 11737
	OpenMethodType                                                                                                        = 11738
	OpenMethodType_InputArguments                                                                                         = 11739
	OpenMethodType_OutputArguments                                                                                        = 11740
	CloseMethodType                                                                                                       = 11741
	CloseMethodType_InputArguments                                                                                        = 11742
	ReadMethodType                                                                                                        = 11743
	ReadMethodType_InputArguments                                                                                         = 11744
	ReadMethodType_OutputArguments                                                                                        = 11745
	WriteMethodType                                                                                                       = 11746
	WriteMethodType_InputArguments                                                                                        = 11747
	GetPositionMethodType                                                                                                 = 11748
	GetPositionMethodType_InputArguments                                                                                  = 11749
	GetPositionMethodType_OutputArguments                                                                                 = 11750
	SetPositionMethodType                                                                                                 = 11751
	SetPositionMethodType_InputArguments                                                                                  = 11752
	SystemOffNormalAlarmType                                                                                              = 11753
	SystemOffNormalAlarmType_EventID                                                                                      = 11754
	SystemOffNormalAlarmType_EventType                                                                                    = 11755
	SystemOffNormalAlarmType_SourceNode                                                                                   = 11756
	SystemOffNormalAlarmType_SourceName                                                                                   = 11757
	SystemOffNormalAlarmType_Time                                                                                         = 11758
	SystemOffNormalAlarmType_ReceiveTime                                                                                  = 11759
	SystemOffNormalAlarmType_LocalTime                                                                                    = 11760
	SystemOffNormalAlarmType_Message                                                                                      = 11761
	SystemOffNormalAlarmType_Severity                                                                                     = 11762
	SystemOffNormalAlarmType_ConditionClassID                                                                             = 11763
	SystemOffNormalAlarmType_ConditionClassName                                                                           = 11764
	SystemOffNormalAlarmType_ConditionName                                                                                = 11765
	SystemOffNormalAlarmType_BranchID                                                                                     = 11766
	SystemOffNormalAlarmType_Retain                                                                                       = 11767
	SystemOffNormalAlarmType_EnabledState                                                                                 = 11768
	SystemOffNormalAlarmType_EnabledState_ID                                                                              = 11769
	SystemOffNormalAlarmType_EnabledState_Name                                                                            = 11770
	SystemOffNormalAlarmType_EnabledState_Number                                                                          = 11771
	SystemOffNormalAlarmType_EnabledState_EffectiveDisplayName                                                            = 11772
	SystemOffNormalAlarmType_EnabledState_TransitionTime                                                                  = 11773
	SystemOffNormalAlarmType_EnabledState_EffectiveTransitionTime                                                         = 11774
	SystemOffNormalAlarmType_EnabledState_TrueState                                                                       = 11775
	SystemOffNormalAlarmType_EnabledState_FalseState                                                                      = 11776
	SystemOffNormalAlarmType_Quality                                                                                      = 11777
	SystemOffNormalAlarmType_Quality_SourceTimestamp                                                                      = 11778
	SystemOffNormalAlarmType_LastSeverity                                                                                 = 11779
	SystemOffNormalAlarmType_LastSeverity_SourceTimestamp                                                                 = 11780
	SystemOffNormalAlarmType_Comment                                                                                      = 11781
	SystemOffNormalAlarmType_Comment_SourceTimestamp                                                                      = 11782
	SystemOffNormalAlarmType_ClientUserID                                                                                 = 11783
	SystemOffNormalAlarmType_Disable                                                                                      = 11784
	SystemOffNormalAlarmType_Enable                                                                                       = 11785
	SystemOffNormalAlarmType_AddComment                                                                                   = 11786
	SystemOffNormalAlarmType_AddComment_InputArguments                                                                    = 11787
	SystemOffNormalAlarmType_ConditionRefresh                                                                             = 11788
	SystemOffNormalAlarmType_ConditionRefresh_InputArguments                                                              = 11789
	SystemOffNormalAlarmType_AckedState                                                                                   = 11790
	SystemOffNormalAlarmType_AckedState_ID                                                                                = 11791
	SystemOffNormalAlarmType_AckedState_Name                                                                              = 11792
	SystemOffNormalAlarmType_AckedState_Number                                                                            = 11793
	SystemOffNormalAlarmType_AckedState_EffectiveDisplayName                                                              = 11794
	SystemOffNormalAlarmType_AckedState_TransitionTime                                                                    = 11795
	SystemOffNormalAlarmType_AckedState_EffectiveTransitionTime                                                           = 11796
	SystemOffNormalAlarmType_AckedState_TrueState                                                                         = 11797
	SystemOffNormalAlarmType_AckedState_FalseState                                                                        = 11798
	SystemOffNormalAlarmType_ConfirmedState                                                                               = 11799
	SystemOffNormalAlarmType_ConfirmedState_ID                                                                            = 11800
	SystemOffNormalAlarmType_ConfirmedState_Name                                                                          = 11801
	SystemOffNormalAlarmType_ConfirmedState_Number                                                                        = 11802
	SystemOffNormalAlarmType_ConfirmedState_EffectiveDisplayName                                                          = 11803
	SystemOffNormalAlarmType_ConfirmedState_TransitionTime                                                                = 11804
	SystemOffNormalAlarmType_ConfirmedState_EffectiveTransitionTime                                                       = 11805
	SystemOffNormalAlarmType_ConfirmedState_TrueState                                                                     = 11806
	SystemOffNormalAlarmType_ConfirmedState_FalseState                                                                    = 11807
	SystemOffNormalAlarmType_Acknowledge                                                                                  = 11808
	SystemOffNormalAlarmType_Acknowledge_InputArguments                                                                   = 11809
	SystemOffNormalAlarmType_Confirm                                                                                      = 11810
	SystemOffNormalAlarmType_Confirm_InputArguments                                                                       = 11811
	SystemOffNormalAlarmType_ActiveState                                                                                  = 11812
	SystemOffNormalAlarmType_ActiveState_ID                                                                               = 11813
	SystemOffNormalAlarmType_ActiveState_Name                                                                             = 11814
	SystemOffNormalAlarmType_ActiveState_Number                                                                           = 11815
	SystemOffNormalAlarmType_ActiveState_EffectiveDisplayName                                                             = 11816
	SystemOffNormalAlarmType_ActiveState_TransitionTime                                                                   = 11817
	SystemOffNormalAlarmType_ActiveState_EffectiveTransitionTime                                                          = 11818
	SystemOffNormalAlarmType_ActiveState_TrueState                                                                        = 11819
	SystemOffNormalAlarmType_ActiveState_FalseState                                                                       = 11820
	SystemOffNormalAlarmType_InputNode                                                                                    = 11821
	SystemOffNormalAlarmType_SuppressedState                                                                              = 11822
	SystemOffNormalAlarmType_SuppressedState_ID                                                                           = 11823
	SystemOffNormalAlarmType_SuppressedState_Name                                                                         = 11824
	SystemOffNormalAlarmType_SuppressedState_Number                                                                       = 11825
	SystemOffNormalAlarmType_SuppressedState_EffectiveDisplayName                                                         = 11826
	SystemOffNormalAlarmType_SuppressedState_TransitionTime                                                               = 11827
	SystemOffNormalAlarmType_SuppressedState_EffectiveTransitionTime                                                      = 11828
	SystemOffNormalAlarmType_SuppressedState_TrueState                                                                    = 11829
	SystemOffNormalAlarmType_SuppressedState_FalseState                                                                   = 11830
	SystemOffNormalAlarmType_ShelvingState                                                                                = 11831
	SystemOffNormalAlarmType_ShelvingState_CurrentState                                                                   = 11832
	SystemOffNormalAlarmType_ShelvingState_CurrentState_ID                                                                = 11833
	SystemOffNormalAlarmType_ShelvingState_CurrentState_Name                                                              = 11834
	SystemOffNormalAlarmType_ShelvingState_CurrentState_Number                                                            = 11835
	SystemOffNormalAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                              = 11836
	SystemOffNormalAlarmType_ShelvingState_LastTransition                                                                 = 11837
	SystemOffNormalAlarmType_ShelvingState_LastTransition_ID                                                              = 11838
	SystemOffNormalAlarmType_ShelvingState_LastTransition_Name                                                            = 11839
	SystemOffNormalAlarmType_ShelvingState_LastTransition_Number                                                          = 11840
	SystemOffNormalAlarmType_ShelvingState_LastTransition_TransitionTime                                                  = 11841
	SystemOffNormalAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                         = 11842
	SystemOffNormalAlarmType_ShelvingState_UnshelveTime                                                                   = 11843
	SystemOffNormalAlarmType_ShelvingState_Unshelve                                                                       = 11844
	SystemOffNormalAlarmType_ShelvingState_OneShotShelve                                                                  = 11845
	SystemOffNormalAlarmType_ShelvingState_TimedShelve                                                                    = 11846
	SystemOffNormalAlarmType_ShelvingState_TimedShelve_InputArguments                                                     = 11847
	SystemOffNormalAlarmType_SuppressedOrShelved                                                                          = 11848
	SystemOffNormalAlarmType_MaxTimeShelved                                                                               = 11849
	SystemOffNormalAlarmType_NormalState                                                                                  = 11850
	AuditConditionCommentEventType_Comment                                                                                = 11851
	AuditConditionRespondEventType_SelectedResponse                                                                       = 11852
	AuditConditionAcknowledgeEventType_Comment                                                                            = 11853
	AuditConditionConfirmEventType_Comment                                                                                = 11854
	AuditConditionShelvingEventType_ShelvingTime                                                                          = 11855
	AuditProgramTransitionEventType                                                                                       = 11856
	AuditProgramTransitionEventType_EventID                                                                               = 11857
	AuditProgramTransitionEventType_EventType                                                                             = 11858
	AuditProgramTransitionEventType_SourceNode                                                                            = 11859
	AuditProgramTransitionEventType_SourceName                                                                            = 11860
	AuditProgramTransitionEventType_Time                                                                                  = 11861
	AuditProgramTransitionEventType_ReceiveTime                                                                           = 11862
	AuditProgramTransitionEventType_LocalTime                                                                             = 11863
	AuditProgramTransitionEventType_Message                                                                               = 11864
	AuditProgramTransitionEventType_Severity                                                                              = 11865
	AuditProgramTransitionEventType_ActionTimeStamp                                                                       = 11866
	AuditProgramTransitionEventType_Status                                                                                = 11867
	AuditProgramTransitionEventType_ServerID                                                                              = 11868
	AuditProgramTransitionEventType_ClientAuditEntryID                                                                    = 11869
	AuditProgramTransitionEventType_ClientUserID                                                                          = 11870
	AuditProgramTransitionEventType_MethodID                                                                              = 11871
	AuditProgramTransitionEventType_InputArguments                                                                        = 11872
	AuditProgramTransitionEventType_OldStateID                                                                            = 11873
	AuditProgramTransitionEventType_NewStateID                                                                            = 11874
	AuditProgramTransitionEventType_TransitionNumber                                                                      = 11875
	HistoricalDataConfigurationType_AggregateFunctions                                                                    = 11876
	HAConfiguration_AggregateFunctions                                                                                    = 11877
	NodeClass_EnumValues                                                                                                  = 11878
	InstanceNode                                                                                                          = 11879
	TypeNode                                                                                                              = 11880
	NodeAttributesMask_EnumValues                                                                                         = 11881
	BrowseResultMask_EnumValues                                                                                           = 11883
	HistoryUpdateType_EnumValues                                                                                          = 11884
	PerformUpdateType_EnumValues                                                                                          = 11885
	InstanceNode_Encoding_DefaultXML                                                                                      = 11887
	TypeNode_Encoding_DefaultXML                                                                                          = 11888
	InstanceNode_Encoding_DefaultBinary                                                                                   = 11889
	TypeNode_Encoding_DefaultBinary                                                                                       = 11890
	SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount                                              = 11891
	SessionDiagnosticsVariableType_UnauthorizedRequestCount                                                               = 11892
	OpenFileMode                                                                                                          = 11939
	OpenFileMode_EnumValues                                                                                               = 11940
	ModelChangeStructureVerbMask                                                                                          = 11941
	ModelChangeStructureVerbMask_EnumValues                                                                               = 11942
	EndpointURLListDataType                                                                                               = 11943
	NetworkGroupDataType                                                                                                  = 11944
	NonTransparentNetworkRedundancyType                                                                                   = 11945
	NonTransparentNetworkRedundancyType_RedundancySupport                                                                 = 11946
	NonTransparentNetworkRedundancyType_ServerURIArray                                                                    = 11947
	NonTransparentNetworkRedundancyType_ServerNetworkGroups                                                               = 11948
	EndpointURLListDataType_Encoding_DefaultXML                                                                           = 11949
	NetworkGroupDataType_Encoding_DefaultXML                                                                              = 11950
	OpcUa_XMLSchema_EndpointURLListDataType                                                                               = 11951
	OpcUa_XMLSchema_EndpointURLListDataType_DataTypeVersion                                                               = 11952
	OpcUa_XMLSchema_EndpointURLListDataType_DictionaryFragment                                                            = 11953
	OpcUa_XMLSchema_NetworkGroupDataType                                                                                  = 11954
	OpcUa_XMLSchema_NetworkGroupDataType_DataTypeVersion                                                                  = 11955
	OpcUa_XMLSchema_NetworkGroupDataType_DictionaryFragment                                                               = 11956
	EndpointURLListDataType_Encoding_DefaultBinary                                                                        = 11957
	NetworkGroupDataType_Encoding_DefaultBinary                                                                           = 11958
	OpcUa_BinarySchema_EndpointURLListDataType                                                                            = 11959
	OpcUa_BinarySchema_EndpointURLListDataType_DataTypeVersion                                                            = 11960
	OpcUa_BinarySchema_EndpointURLListDataType_DictionaryFragment                                                         = 11961
	OpcUa_BinarySchema_NetworkGroupDataType                                                                               = 11962
	OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion                                                               = 11963
	OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment                                                            = 11964
	ArrayItemType                                                                                                         = 12021
	ArrayItemType_Definition                                                                                              = 12022
	ArrayItemType_ValuePrecision                                                                                          = 12023
	ArrayItemType_InstrumentRange                                                                                         = 12024
	ArrayItemType_EURange                                                                                                 = 12025
	ArrayItemType_EngineeringUnits                                                                                        = 12026
	ArrayItemType_Title                                                                                                   = 12027
	ArrayItemType_AxisScaleType                                                                                           = 12028
	YArrayItemType                                                                                                        = 12029
	YArrayItemType_Definition                                                                                             = 12030
	YArrayItemType_ValuePrecision                                                                                         = 12031
	YArrayItemType_InstrumentRange                                                                                        = 12032
	YArrayItemType_EURange                                                                                                = 12033
	YArrayItemType_EngineeringUnits                                                                                       = 12034
	YArrayItemType_Title                                                                                                  = 12035
	YArrayItemType_AxisScaleType                                                                                          = 12036
	YArrayItemType_XAxisDefinition                                                                                        = 12037
	XYArrayItemType                                                                                                       = 12038
	XYArrayItemType_Definition                                                                                            = 12039
	XYArrayItemType_ValuePrecision                                                                                        = 12040
	XYArrayItemType_InstrumentRange                                                                                       = 12041
	XYArrayItemType_EURange                                                                                               = 12042
	XYArrayItemType_EngineeringUnits                                                                                      = 12043
	XYArrayItemType_Title                                                                                                 = 12044
	XYArrayItemType_AxisScaleType                                                                                         = 12045
	XYArrayItemType_XAxisDefinition                                                                                       = 12046
	ImageItemType                                                                                                         = 12047
	ImageItemType_Definition                                                                                              = 12048
	ImageItemType_ValuePrecision                                                                                          = 12049
	ImageItemType_InstrumentRange                                                                                         = 12050
	ImageItemType_EURange                                                                                                 = 12051
	ImageItemType_EngineeringUnits                                                                                        = 12052
	ImageItemType_Title                                                                                                   = 12053
	ImageItemType_AxisScaleType                                                                                           = 12054
	ImageItemType_XAxisDefinition                                                                                         = 12055
	ImageItemType_YAxisDefinition                                                                                         = 12056
	CubeItemType                                                                                                          = 12057
	CubeItemType_Definition                                                                                               = 12058
	CubeItemType_ValuePrecision                                                                                           = 12059
	CubeItemType_InstrumentRange                                                                                          = 12060
	CubeItemType_EURange                                                                                                  = 12061
	CubeItemType_EngineeringUnits                                                                                         = 12062
	CubeItemType_Title                                                                                                    = 12063
	CubeItemType_AxisScaleType                                                                                            = 12064
	CubeItemType_XAxisDefinition                                                                                          = 12065
	CubeItemType_YAxisDefinition                                                                                          = 12066
	CubeItemType_ZAxisDefinition                                                                                          = 12067
	NDimensionArrayItemType                                                                                               = 12068
	NDimensionArrayItemType_Definition                                                                                    = 12069
	NDimensionArrayItemType_ValuePrecision                                                                                = 12070
	NDimensionArrayItemType_InstrumentRange                                                                               = 12071
	NDimensionArrayItemType_EURange                                                                                       = 12072
	NDimensionArrayItemType_EngineeringUnits                                                                              = 12073
	NDimensionArrayItemType_Title                                                                                         = 12074
	NDimensionArrayItemType_AxisScaleType                                                                                 = 12075
	NDimensionArrayItemType_AxisDefinition                                                                                = 12076
	AxisScaleEnumeration                                                                                                  = 12077
	AxisScaleEnumeration_EnumStrings                                                                                      = 12078
	AxisInformation                                                                                                       = 12079
	XVType                                                                                                                = 12080
	AxisInformation_Encoding_DefaultXML                                                                                   = 12081
	XVType_Encoding_DefaultXML                                                                                            = 12082
	OpcUa_XMLSchema_AxisInformation                                                                                       = 12083
	OpcUa_XMLSchema_AxisInformation_DataTypeVersion                                                                       = 12084
	OpcUa_XMLSchema_AxisInformation_DictionaryFragment                                                                    = 12085
	OpcUa_XMLSchema_XVType                                                                                                = 12086
	OpcUa_XMLSchema_XVType_DataTypeVersion                                                                                = 12087
	OpcUa_XMLSchema_XVType_DictionaryFragment                                                                             = 12088
	AxisInformation_Encoding_DefaultBinary                                                                                = 12089
	XVType_Encoding_DefaultBinary                                                                                         = 12090
	OpcUa_BinarySchema_AxisInformation                                                                                    = 12091
	OpcUa_BinarySchema_AxisInformation_DataTypeVersion                                                                    = 12092
	OpcUa_BinarySchema_AxisInformation_DictionaryFragment                                                                 = 12093
	OpcUa_BinarySchema_XVType                                                                                             = 12094
	OpcUa_BinarySchema_XVType_DataTypeVersion                                                                             = 12095
	OpcUa_BinarySchema_XVType_DictionaryFragment                                                                          = 12096
	SessionsDiagnosticsSummaryType_ClientName_Placeholder                                                                 = 12097
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics                                              = 12098
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionID                                    = 12099
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName                                  = 12100
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription                            = 12101
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerURI                                    = 12102
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointURL                                  = 12103
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIDs                                    = 12104
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout                         = 12105
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize                       = 12106
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime                         = 12107
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime                        = 12108
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount                    = 12109
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount                   = 12110
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue                = 12111
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount                            = 12112
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount                     = 12113
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount                                    = 12114
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount                             = 12115
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount                                   = 12116
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount                           = 12117
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount                                    = 12118
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount                    = 12119
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount                    = 12120
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount                       = 12121
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount                           = 12122
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount                    = 12123
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount                      = 12124
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount                      = 12125
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount                       = 12126
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount                                 = 12127
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount                               = 12128
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount                   = 12129
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount                     = 12130
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount                                = 12131
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount                           = 12132
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount                             = 12133
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount                        = 12134
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount                                  = 12135
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount                              = 12136
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIDsCount           = 12137
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount                              = 12138
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount                               = 12139
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount                           = 12140
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount                         = 12141
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics                                      = 12142
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionID                            = 12143
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIDOfSession                = 12144
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIDHistory                  = 12145
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism              = 12146
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding                             = 12147
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol                    = 12148
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode                         = 12149
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyURI                    = 12150
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate                    = 12151
	SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray                                    = 12152
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData                                              = 12153
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents                                            = 12154
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData                                            = 12155
	ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents                                          = 12156
	ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadData                                                     = 12157
	ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadEvents                                                   = 12158
	ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateData                                                   = 12159
	ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateEvents                                                 = 12160
	OperationLimitsType_MaxNodesPerHistoryReadData                                                                        = 12161
	OperationLimitsType_MaxNodesPerHistoryReadEvents                                                                      = 12162
	OperationLimitsType_MaxNodesPerHistoryUpdateData                                                                      = 12163
	OperationLimitsType_MaxNodesPerHistoryUpdateEvents                                                                    = 12164
	Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData                                                  = 12165
	Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents                                                = 12166
	Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData                                                = 12167
	Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents                                              = 12168
	NamingRuleType_EnumValues                                                                                             = 12169
	ViewVersion                                                                                                           = 12170
	ComplexNumberType                                                                                                     = 12171
	DoubleComplexNumberType                                                                                               = 12172
	ComplexNumberType_Encoding_DefaultXML                                                                                 = 12173
	DoubleComplexNumberType_Encoding_DefaultXML                                                                           = 12174
	OpcUa_XMLSchema_ComplexNumberType                                                                                     = 12175
	OpcUa_XMLSchema_ComplexNumberType_DataTypeVersion                                                                     = 12176
	OpcUa_XMLSchema_ComplexNumberType_DictionaryFragment                                                                  = 12177
	OpcUa_XMLSchema_DoubleComplexNumberType                                                                               = 12178
	OpcUa_XMLSchema_DoubleComplexNumberType_DataTypeVersion                                                               = 12179
	OpcUa_XMLSchema_DoubleComplexNumberType_DictionaryFragment                                                            = 12180
	ComplexNumberType_Encoding_DefaultBinary                                                                              = 12181
	DoubleComplexNumberType_Encoding_DefaultBinary                                                                        = 12182
	OpcUa_BinarySchema_ComplexNumberType                                                                                  = 12183
	OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion                                                                  = 12184
	OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment                                                               = 12185
	OpcUa_BinarySchema_DoubleComplexNumberType                                                                            = 12186
	OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion                                                            = 12187
	OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment                                                         = 12188
	ServerOnNetwork                                                                                                       = 12189
	FindServersOnNetworkRequest                                                                                           = 12190
	FindServersOnNetworkResponse                                                                                          = 12191
	RegisterServer2Request                                                                                                = 12193
	RegisterServer2Response                                                                                               = 12194
	ServerOnNetwork_Encoding_DefaultXML                                                                                   = 12195
	FindServersOnNetworkRequest_Encoding_DefaultXML                                                                       = 12196
	FindServersOnNetworkResponse_Encoding_DefaultXML                                                                      = 12197
	RegisterServer2Request_Encoding_DefaultXML                                                                            = 12199
	RegisterServer2Response_Encoding_DefaultXML                                                                           = 12200
	OpcUa_XMLSchema_ServerOnNetwork                                                                                       = 12201
	OpcUa_XMLSchema_ServerOnNetwork_DataTypeVersion                                                                       = 12202
	OpcUa_XMLSchema_ServerOnNetwork_DictionaryFragment                                                                    = 12203
	ServerOnNetwork_Encoding_DefaultBinary                                                                                = 12207
	FindServersOnNetworkRequest_Encoding_DefaultBinary                                                                    = 12208
	FindServersOnNetworkResponse_Encoding_DefaultBinary                                                                   = 12209
	RegisterServer2Request_Encoding_DefaultBinary                                                                         = 12211
	RegisterServer2Response_Encoding_DefaultBinary                                                                        = 12212
	OpcUa_BinarySchema_ServerOnNetwork                                                                                    = 12213
	OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion                                                                    = 12214
	OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment                                                                 = 12215
	ProgressEventType_Context                                                                                             = 12502
	ProgressEventType_Progress                                                                                            = 12503
	OpenWithMasksMethodType                                                                                               = 12513
	OpenWithMasksMethodType_InputArguments                                                                                = 12514
	OpenWithMasksMethodType_OutputArguments                                                                               = 12515
	CloseAndUpdateMethodType                                                                                              = 12516
	CloseAndUpdateMethodType_OutputArguments                                                                              = 12517
	AddCertificateMethodType                                                                                              = 12518
	AddCertificateMethodType_InputArguments                                                                               = 12519
	RemoveCertificateMethodType                                                                                           = 12520
	RemoveCertificateMethodType_InputArguments                                                                            = 12521
	TrustListType                                                                                                         = 12522
	TrustListType_Size                                                                                                    = 12523
	TrustListType_OpenCount                                                                                               = 12526
	TrustListType_Open                                                                                                    = 12527
	TrustListType_Open_InputArguments                                                                                     = 12528
	TrustListType_Open_OutputArguments                                                                                    = 12529
	TrustListType_Close                                                                                                   = 12530
	TrustListType_Close_InputArguments                                                                                    = 12531
	TrustListType_Read                                                                                                    = 12532
	TrustListType_Read_InputArguments                                                                                     = 12533
	TrustListType_Read_OutputArguments                                                                                    = 12534
	TrustListType_Write                                                                                                   = 12535
	TrustListType_Write_InputArguments                                                                                    = 12536
	TrustListType_GetPosition                                                                                             = 12537
	TrustListType_GetPosition_InputArguments                                                                              = 12538
	TrustListType_GetPosition_OutputArguments                                                                             = 12539
	TrustListType_SetPosition                                                                                             = 12540
	TrustListType_SetPosition_InputArguments                                                                              = 12541
	TrustListType_LastUpdateTime                                                                                          = 12542
	TrustListType_OpenWithMasks                                                                                           = 12543
	TrustListType_OpenWithMasks_InputArguments                                                                            = 12544
	TrustListType_OpenWithMasks_OutputArguments                                                                           = 12545
	TrustListType_CloseAndUpdate                                                                                          = 12546
	TrustListType_CloseAndUpdate_OutputArguments                                                                          = 12547
	TrustListType_AddCertificate                                                                                          = 12548
	TrustListType_AddCertificate_InputArguments                                                                           = 12549
	TrustListType_RemoveCertificate                                                                                       = 12550
	TrustListType_RemoveCertificate_InputArguments                                                                        = 12551
	TrustListMasks                                                                                                        = 12552
	TrustListMasks_EnumValues                                                                                             = 12553
	TrustListDataType                                                                                                     = 12554
	CertificateGroupType                                                                                                  = 12555
	CertificateType                                                                                                       = 12556
	ApplicationCertificateType                                                                                            = 12557
	HttpsCertificateType                                                                                                  = 12558
	RsaMinApplicationCertificateType                                                                                      = 12559
	RsaSha256ApplicationCertificateType                                                                                   = 12560
	TrustListUpdatedAuditEventType                                                                                        = 12561
	TrustListUpdatedAuditEventType_EventID                                                                                = 12562
	TrustListUpdatedAuditEventType_EventType                                                                              = 12563
	TrustListUpdatedAuditEventType_SourceNode                                                                             = 12564
	TrustListUpdatedAuditEventType_SourceName                                                                             = 12565
	TrustListUpdatedAuditEventType_Time                                                                                   = 12566
	TrustListUpdatedAuditEventType_ReceiveTime                                                                            = 12567
	TrustListUpdatedAuditEventType_LocalTime                                                                              = 12568
	TrustListUpdatedAuditEventType_Message                                                                                = 12569
	TrustListUpdatedAuditEventType_Severity                                                                               = 12570
	TrustListUpdatedAuditEventType_ActionTimeStamp                                                                        = 12571
	TrustListUpdatedAuditEventType_Status                                                                                 = 12572
	TrustListUpdatedAuditEventType_ServerID                                                                               = 12573
	TrustListUpdatedAuditEventType_ClientAuditEntryID                                                                     = 12574
	TrustListUpdatedAuditEventType_ClientUserID                                                                           = 12575
	TrustListUpdatedAuditEventType_MethodID                                                                               = 12576
	TrustListUpdatedAuditEventType_InputArguments                                                                         = 12577
	UpdateCertificateMethodType                                                                                           = 12578
	UpdateCertificateMethodType_InputArguments                                                                            = 12579
	UpdateCertificateMethodType_OutputArguments                                                                           = 12580
	ServerConfigurationType                                                                                               = 12581
	ServerConfigurationType_SupportedPrivateKeyFormats                                                                    = 12583
	ServerConfigurationType_MaxTrustListSize                                                                              = 12584
	ServerConfigurationType_MulticastDnsEnabled                                                                           = 12585
	ServerConfigurationType_UpdateCertificate                                                                             = 12616
	ServerConfigurationType_UpdateCertificate_InputArguments                                                              = 12617
	ServerConfigurationType_UpdateCertificate_OutputArguments                                                             = 12618
	CertificateUpdatedAuditEventType                                                                                      = 12620
	CertificateUpdatedAuditEventType_EventID                                                                              = 12621
	CertificateUpdatedAuditEventType_EventType                                                                            = 12622
	CertificateUpdatedAuditEventType_SourceNode                                                                           = 12623
	CertificateUpdatedAuditEventType_SourceName                                                                           = 12624
	CertificateUpdatedAuditEventType_Time                                                                                 = 12625
	CertificateUpdatedAuditEventType_ReceiveTime                                                                          = 12626
	CertificateUpdatedAuditEventType_LocalTime                                                                            = 12627
	CertificateUpdatedAuditEventType_Message                                                                              = 12628
	CertificateUpdatedAuditEventType_Severity                                                                             = 12629
	CertificateUpdatedAuditEventType_ActionTimeStamp                                                                      = 12630
	CertificateUpdatedAuditEventType_Status                                                                               = 12631
	CertificateUpdatedAuditEventType_ServerID                                                                             = 12632
	CertificateUpdatedAuditEventType_ClientAuditEntryID                                                                   = 12633
	CertificateUpdatedAuditEventType_ClientUserID                                                                         = 12634
	CertificateUpdatedAuditEventType_MethodID                                                                             = 12635
	CertificateUpdatedAuditEventType_InputArguments                                                                       = 12636
	ServerConfiguration                                                                                                   = 12637
	ServerConfiguration_SupportedPrivateKeyFormats                                                                        = 12639
	ServerConfiguration_MaxTrustListSize                                                                                  = 12640
	ServerConfiguration_MulticastDnsEnabled                                                                               = 12641
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList                                               = 12642
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Size                                          = 12643
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount                                     = 12646
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                          = 12647
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments                           = 12648
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments                          = 12649
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                         = 12650
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments                          = 12651
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                          = 12652
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments                           = 12653
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments                          = 12654
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                         = 12655
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments                          = 12656
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                                   = 12657
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments                    = 12658
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments                   = 12659
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                                   = 12660
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments                    = 12661
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime                                = 12662
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                                 = 12663
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments                  = 12664
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments                 = 12665
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                                = 12666
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments                = 12667
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                                = 12668
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments                 = 12669
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                             = 12670
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments              = 12671
	TrustListDataType_Encoding_DefaultXML                                                                                 = 12676
	OpcUa_XMLSchema_TrustListDataType                                                                                     = 12677
	OpcUa_XMLSchema_TrustListDataType_DataTypeVersion                                                                     = 12678
	OpcUa_XMLSchema_TrustListDataType_DictionaryFragment                                                                  = 12679
	TrustListDataType_Encoding_DefaultBinary                                                                              = 12680
	OpcUa_BinarySchema_TrustListDataType                                                                                  = 12681
	OpcUa_BinarySchema_TrustListDataType_DataTypeVersion                                                                  = 12682
	OpcUa_BinarySchema_TrustListDataType_DictionaryFragment                                                               = 12683
	FileType_Writable                                                                                                     = 12686
	FileType_UserWritable                                                                                                 = 12687
	AddressSpaceFileType_Writable                                                                                         = 12688
	AddressSpaceFileType_UserWritable                                                                                     = 12689
	NamespaceMetadataType_NamespaceFile_Writable                                                                          = 12690
	NamespaceMetadataType_NamespaceFile_UserWritable                                                                      = 12691
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_Writable                                                 = 12692
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_UserWritable                                             = 12693
	TrustListType_Writable                                                                                                = 12698
	TrustListType_UserWritable                                                                                            = 12699
	CloseAndUpdateMethodType_InputArguments                                                                               = 12704
	TrustListType_CloseAndUpdate_InputArguments                                                                           = 12705
	ServerConfigurationType_ServerCapabilities                                                                            = 12708
	ServerConfiguration_ServerCapabilities                                                                                = 12710
	OpcUa_XMLSchema_RelativePathElement                                                                                   = 12712
	OpcUa_XMLSchema_RelativePathElement_DataTypeVersion                                                                   = 12713
	OpcUa_XMLSchema_RelativePathElement_DictionaryFragment                                                                = 12714
	OpcUa_XMLSchema_RelativePath                                                                                          = 12715
	OpcUa_XMLSchema_RelativePath_DataTypeVersion                                                                          = 12716
	OpcUa_XMLSchema_RelativePath_DictionaryFragment                                                                       = 12717
	OpcUa_BinarySchema_RelativePathElement                                                                                = 12718
	OpcUa_BinarySchema_RelativePathElement_DataTypeVersion                                                                = 12719
	OpcUa_BinarySchema_RelativePathElement_DictionaryFragment                                                             = 12720
	OpcUa_BinarySchema_RelativePath                                                                                       = 12721
	OpcUa_BinarySchema_RelativePath_DataTypeVersion                                                                       = 12722
	OpcUa_BinarySchema_RelativePath_DictionaryFragment                                                                    = 12723
	ServerConfigurationType_CreateSigningRequest                                                                          = 12731
	ServerConfigurationType_CreateSigningRequest_InputArguments                                                           = 12732
	ServerConfigurationType_CreateSigningRequest_OutputArguments                                                          = 12733
	ServerConfigurationType_ApplyChanges                                                                                  = 12734
	ServerConfiguration_CreateSigningRequest                                                                              = 12737
	ServerConfiguration_CreateSigningRequest_InputArguments                                                               = 12738
	ServerConfiguration_CreateSigningRequest_OutputArguments                                                              = 12739
	ServerConfiguration_ApplyChanges                                                                                      = 12740
	CreateSigningRequestMethodType                                                                                        = 12741
	CreateSigningRequestMethodType_InputArguments                                                                         = 12742
	CreateSigningRequestMethodType_OutputArguments                                                                        = 12743
	OptionSetValues                                                                                                       = 12745
	ServerType_SetSubscriptionDurable                                                                                     = 12746
	ServerType_SetSubscriptionDurable_InputArguments                                                                      = 12747
	ServerType_SetSubscriptionDurable_OutputArguments                                                                     = 12748
	Server_SetSubscriptionDurable                                                                                         = 12749
	Server_SetSubscriptionDurable_InputArguments                                                                          = 12750
	Server_SetSubscriptionDurable_OutputArguments                                                                         = 12751
	SetSubscriptionDurableMethodType                                                                                      = 12752
	SetSubscriptionDurableMethodType_InputArguments                                                                       = 12753
	SetSubscriptionDurableMethodType_OutputArguments                                                                      = 12754
	OptionSet                                                                                                             = 12755
	Union                                                                                                                 = 12756
	OptionSet_Encoding_DefaultXML                                                                                         = 12757
	Union_Encoding_DefaultXML                                                                                             = 12758
	OpcUa_XMLSchema_OptionSet                                                                                             = 12759
	OpcUa_XMLSchema_OptionSet_DataTypeVersion                                                                             = 12760
	OpcUa_XMLSchema_OptionSet_DictionaryFragment                                                                          = 12761
	OpcUa_XMLSchema_Union                                                                                                 = 12762
	OpcUa_XMLSchema_Union_DataTypeVersion                                                                                 = 12763
	OpcUa_XMLSchema_Union_DictionaryFragment                                                                              = 12764
	OptionSet_Encoding_DefaultBinary                                                                                      = 12765
	Union_Encoding_DefaultBinary                                                                                          = 12766
	OpcUa_BinarySchema_OptionSet                                                                                          = 12767
	OpcUa_BinarySchema_OptionSet_DataTypeVersion                                                                          = 12768
	OpcUa_BinarySchema_OptionSet_DictionaryFragment                                                                       = 12769
	OpcUa_BinarySchema_Union                                                                                              = 12770
	OpcUa_BinarySchema_Union_DataTypeVersion                                                                              = 12771
	OpcUa_BinarySchema_Union_DictionaryFragment                                                                           = 12772
	GetRejectedListMethodType                                                                                             = 12773
	GetRejectedListMethodType_OutputArguments                                                                             = 12774
	ServerConfigurationType_GetRejectedList                                                                               = 12775
	ServerConfigurationType_GetRejectedList_OutputArguments                                                               = 12776
	ServerConfiguration_GetRejectedList                                                                                   = 12777
	ServerConfiguration_GetRejectedList_OutputArguments                                                                   = 12778
	SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics                                                      = 12779
	SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval                                     = 12780
	SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount                           = 12781
	SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount                        = 12782
	SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount                  = 12783
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics                                                              = 12784
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionID                                                    = 12785
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionID                                               = 12786
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority                                                     = 12787
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval                                           = 12788
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount                                            = 12789
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount                                             = 12790
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish                                   = 12791
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled                                            = 12792
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount                                                  = 12793
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount                                                  = 12794
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount                                                 = 12795
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount                                        = 12796
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount                                 = 12797
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount                                        = 12798
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount                                         = 12799
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount                                  = 12800
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount                                 = 12801
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount                                          = 12802
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount                                 = 12803
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount                                      = 12804
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount                                           = 12805
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount                                      = 12806
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount                                        = 12807
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount                                         = 12808
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount                                   = 12809
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount                                        = 12810
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount                                           = 12811
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount                                   = 12812
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount                                 = 12813
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber                                           = 12814
	SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount                                      = 12815
	SessionDiagnosticsArrayType_SessionDiagnostics                                                                        = 12816
	SessionDiagnosticsArrayType_SessionDiagnostics_SessionID                                                              = 12817
	SessionDiagnosticsArrayType_SessionDiagnostics_SessionName                                                            = 12818
	SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription                                                      = 12819
	SessionDiagnosticsArrayType_SessionDiagnostics_ServerURI                                                              = 12820
	SessionDiagnosticsArrayType_SessionDiagnostics_EndpointURL                                                            = 12821
	SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIDs                                                              = 12822
	SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout                                                   = 12823
	SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize                                                 = 12824
	SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime                                                   = 12825
	SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime                                                  = 12826
	SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount                                              = 12827
	SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount                                             = 12828
	SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue                                          = 12829
	SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount                                                      = 12830
	SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount                                               = 12831
	SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount                                                              = 12832
	SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount                                                       = 12833
	SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount                                                             = 12834
	SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount                                                     = 12835
	SessionDiagnosticsArrayType_SessionDiagnostics_CallCount                                                              = 12836
	SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount                                              = 12837
	SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount                                              = 12838
	SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount                                                 = 12839
	SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount                                                     = 12840
	SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount                                              = 12841
	SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount                                                = 12842
	SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount                                                = 12843
	SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount                                                 = 12844
	SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount                                                           = 12845
	SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount                                                         = 12846
	SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount                                             = 12847
	SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount                                               = 12848
	SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount                                                          = 12849
	SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount                                                     = 12850
	SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount                                                       = 12851
	SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount                                                  = 12852
	SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount                                                            = 12853
	SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount                                                        = 12854
	SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIDsCount                                     = 12855
	SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount                                                        = 12856
	SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount                                                         = 12857
	SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount                                                     = 12858
	SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount                                                   = 12859
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics                                                        = 12860
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionID                                              = 12861
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIDOfSession                                  = 12862
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIDHistory                                    = 12863
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism                                = 12864
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding                                               = 12865
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol                                      = 12866
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode                                           = 12867
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyURI                                      = 12868
	SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate                                      = 12869
	ServerType_ResendData                                                                                                 = 12871
	ServerType_ResendData_InputArguments                                                                                  = 12872
	Server_ResendData                                                                                                     = 12873
	Server_ResendData_InputArguments                                                                                      = 12874
	ResendDataMethodType                                                                                                  = 12875
	ResendDataMethodType_InputArguments                                                                                   = 12876
	NormalizedString                                                                                                      = 12877
	DecimalString                                                                                                         = 12878
	DurationString                                                                                                        = 12879
	TimeString                                                                                                            = 12880
	DateString                                                                                                            = 12881
	ServerType_EstimatedReturnTime                                                                                        = 12882
	ServerType_RequestServerStateChange                                                                                   = 12883
	ServerType_RequestServerStateChange_InputArguments                                                                    = 12884
	Server_EstimatedReturnTime                                                                                            = 12885
	Server_RequestServerStateChange                                                                                       = 12886
	Server_RequestServerStateChange_InputArguments                                                                        = 12887
	RequestServerStateChangeMethodType                                                                                    = 12888
	RequestServerStateChangeMethodType_InputArguments                                                                     = 12889
	DiscoveryConfiguration                                                                                                = 12890
	MdnsDiscoveryConfiguration                                                                                            = 12891
	DiscoveryConfiguration_Encoding_DefaultXML                                                                            = 12892
	MdnsDiscoveryConfiguration_Encoding_DefaultXML                                                                        = 12893
	OpcUa_XMLSchema_DiscoveryConfiguration                                                                                = 12894
	OpcUa_XMLSchema_DiscoveryConfiguration_DataTypeVersion                                                                = 12895
	OpcUa_XMLSchema_DiscoveryConfiguration_DictionaryFragment                                                             = 12896
	OpcUa_XMLSchema_MdnsDiscoveryConfiguration                                                                            = 12897
	OpcUa_XMLSchema_MdnsDiscoveryConfiguration_DataTypeVersion                                                            = 12898
	OpcUa_XMLSchema_MdnsDiscoveryConfiguration_DictionaryFragment                                                         = 12899
	DiscoveryConfiguration_Encoding_DefaultBinary                                                                         = 12900
	MdnsDiscoveryConfiguration_Encoding_DefaultBinary                                                                     = 12901
	OpcUa_BinarySchema_DiscoveryConfiguration                                                                             = 12902
	OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion                                                             = 12903
	OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment                                                          = 12904
	OpcUa_BinarySchema_MdnsDiscoveryConfiguration                                                                         = 12905
	OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion                                                         = 12906
	OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment                                                      = 12907
	MaxByteStringLength                                                                                                   = 12908
	ServerType_ServerCapabilities_MaxByteStringLength                                                                     = 12909
	ServerCapabilitiesType_MaxByteStringLength                                                                            = 12910
	Server_ServerCapabilities_MaxByteStringLength                                                                         = 12911
	ConditionType_ConditionRefresh2                                                                                       = 12912
	ConditionType_ConditionRefresh2_InputArguments                                                                        = 12913
	ConditionRefresh2MethodType                                                                                           = 12914
	ConditionRefresh2MethodType_InputArguments                                                                            = 12915
	DialogConditionType_ConditionRefresh2                                                                                 = 12916
	DialogConditionType_ConditionRefresh2_InputArguments                                                                  = 12917
	AcknowledgeableConditionType_ConditionRefresh2                                                                        = 12918
	AcknowledgeableConditionType_ConditionRefresh2_InputArguments                                                         = 12919
	AlarmConditionType_ConditionRefresh2                                                                                  = 12984
	AlarmConditionType_ConditionRefresh2_InputArguments                                                                   = 12985
	LimitAlarmType_ConditionRefresh2                                                                                      = 12986
	LimitAlarmType_ConditionRefresh2_InputArguments                                                                       = 12987
	ExclusiveLimitAlarmType_ConditionRefresh2                                                                             = 12988
	ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments                                                              = 12989
	NonExclusiveLimitAlarmType_ConditionRefresh2                                                                          = 12990
	NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments                                                           = 12991
	NonExclusiveLevelAlarmType_ConditionRefresh2                                                                          = 12992
	NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments                                                           = 12993
	ExclusiveLevelAlarmType_ConditionRefresh2                                                                             = 12994
	ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments                                                              = 12995
	NonExclusiveDeviationAlarmType_ConditionRefresh2                                                                      = 12996
	NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments                                                       = 12997
	ExclusiveDeviationAlarmType_ConditionRefresh2                                                                         = 12998
	ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments                                                          = 12999
	NonExclusiveRateOfChangeAlarmType_ConditionRefresh2                                                                   = 13000
	NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments                                                    = 13001
	ExclusiveRateOfChangeAlarmType_ConditionRefresh2                                                                      = 13002
	ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments                                                       = 13003
	DiscreteAlarmType_ConditionRefresh2                                                                                   = 13004
	DiscreteAlarmType_ConditionRefresh2_InputArguments                                                                    = 13005
	OffNormalAlarmType_ConditionRefresh2                                                                                  = 13006
	OffNormalAlarmType_ConditionRefresh2_InputArguments                                                                   = 13007
	SystemOffNormalAlarmType_ConditionRefresh2                                                                            = 13008
	SystemOffNormalAlarmType_ConditionRefresh2_InputArguments                                                             = 13009
	TripAlarmType_ConditionRefresh2                                                                                       = 13010
	TripAlarmType_ConditionRefresh2_InputArguments                                                                        = 13011
	CertificateExpirationAlarmType                                                                                        = 13225
	CertificateExpirationAlarmType_EventID                                                                                = 13226
	CertificateExpirationAlarmType_EventType                                                                              = 13227
	CertificateExpirationAlarmType_SourceNode                                                                             = 13228
	CertificateExpirationAlarmType_SourceName                                                                             = 13229
	CertificateExpirationAlarmType_Time                                                                                   = 13230
	CertificateExpirationAlarmType_ReceiveTime                                                                            = 13231
	CertificateExpirationAlarmType_LocalTime                                                                              = 13232
	CertificateExpirationAlarmType_Message                                                                                = 13233
	CertificateExpirationAlarmType_Severity                                                                               = 13234
	CertificateExpirationAlarmType_ConditionClassID                                                                       = 13235
	CertificateExpirationAlarmType_ConditionClassName                                                                     = 13236
	CertificateExpirationAlarmType_ConditionName                                                                          = 13237
	CertificateExpirationAlarmType_BranchID                                                                               = 13238
	CertificateExpirationAlarmType_Retain                                                                                 = 13239
	CertificateExpirationAlarmType_EnabledState                                                                           = 13240
	CertificateExpirationAlarmType_EnabledState_ID                                                                        = 13241
	CertificateExpirationAlarmType_EnabledState_Name                                                                      = 13242
	CertificateExpirationAlarmType_EnabledState_Number                                                                    = 13243
	CertificateExpirationAlarmType_EnabledState_EffectiveDisplayName                                                      = 13244
	CertificateExpirationAlarmType_EnabledState_TransitionTime                                                            = 13245
	CertificateExpirationAlarmType_EnabledState_EffectiveTransitionTime                                                   = 13246
	CertificateExpirationAlarmType_EnabledState_TrueState                                                                 = 13247
	CertificateExpirationAlarmType_EnabledState_FalseState                                                                = 13248
	CertificateExpirationAlarmType_Quality                                                                                = 13249
	CertificateExpirationAlarmType_Quality_SourceTimestamp                                                                = 13250
	CertificateExpirationAlarmType_LastSeverity                                                                           = 13251
	CertificateExpirationAlarmType_LastSeverity_SourceTimestamp                                                           = 13252
	CertificateExpirationAlarmType_Comment                                                                                = 13253
	CertificateExpirationAlarmType_Comment_SourceTimestamp                                                                = 13254
	CertificateExpirationAlarmType_ClientUserID                                                                           = 13255
	CertificateExpirationAlarmType_Disable                                                                                = 13256
	CertificateExpirationAlarmType_Enable                                                                                 = 13257
	CertificateExpirationAlarmType_AddComment                                                                             = 13258
	CertificateExpirationAlarmType_AddComment_InputArguments                                                              = 13259
	CertificateExpirationAlarmType_ConditionRefresh                                                                       = 13260
	CertificateExpirationAlarmType_ConditionRefresh_InputArguments                                                        = 13261
	CertificateExpirationAlarmType_ConditionRefresh2                                                                      = 13262
	CertificateExpirationAlarmType_ConditionRefresh2_InputArguments                                                       = 13263
	CertificateExpirationAlarmType_AckedState                                                                             = 13264
	CertificateExpirationAlarmType_AckedState_ID                                                                          = 13265
	CertificateExpirationAlarmType_AckedState_Name                                                                        = 13266
	CertificateExpirationAlarmType_AckedState_Number                                                                      = 13267
	CertificateExpirationAlarmType_AckedState_EffectiveDisplayName                                                        = 13268
	CertificateExpirationAlarmType_AckedState_TransitionTime                                                              = 13269
	CertificateExpirationAlarmType_AckedState_EffectiveTransitionTime                                                     = 13270
	CertificateExpirationAlarmType_AckedState_TrueState                                                                   = 13271
	CertificateExpirationAlarmType_AckedState_FalseState                                                                  = 13272
	CertificateExpirationAlarmType_ConfirmedState                                                                         = 13273
	CertificateExpirationAlarmType_ConfirmedState_ID                                                                      = 13274
	CertificateExpirationAlarmType_ConfirmedState_Name                                                                    = 13275
	CertificateExpirationAlarmType_ConfirmedState_Number                                                                  = 13276
	CertificateExpirationAlarmType_ConfirmedState_EffectiveDisplayName                                                    = 13277
	CertificateExpirationAlarmType_ConfirmedState_TransitionTime                                                          = 13278
	CertificateExpirationAlarmType_ConfirmedState_EffectiveTransitionTime                                                 = 13279
	CertificateExpirationAlarmType_ConfirmedState_TrueState                                                               = 13280
	CertificateExpirationAlarmType_ConfirmedState_FalseState                                                              = 13281
	CertificateExpirationAlarmType_Acknowledge                                                                            = 13282
	CertificateExpirationAlarmType_Acknowledge_InputArguments                                                             = 13283
	CertificateExpirationAlarmType_Confirm                                                                                = 13284
	CertificateExpirationAlarmType_Confirm_InputArguments                                                                 = 13285
	CertificateExpirationAlarmType_ActiveState                                                                            = 13286
	CertificateExpirationAlarmType_ActiveState_ID                                                                         = 13287
	CertificateExpirationAlarmType_ActiveState_Name                                                                       = 13288
	CertificateExpirationAlarmType_ActiveState_Number                                                                     = 13289
	CertificateExpirationAlarmType_ActiveState_EffectiveDisplayName                                                       = 13290
	CertificateExpirationAlarmType_ActiveState_TransitionTime                                                             = 13291
	CertificateExpirationAlarmType_ActiveState_EffectiveTransitionTime                                                    = 13292
	CertificateExpirationAlarmType_ActiveState_TrueState                                                                  = 13293
	CertificateExpirationAlarmType_ActiveState_FalseState                                                                 = 13294
	CertificateExpirationAlarmType_InputNode                                                                              = 13295
	CertificateExpirationAlarmType_SuppressedState                                                                        = 13296
	CertificateExpirationAlarmType_SuppressedState_ID                                                                     = 13297
	CertificateExpirationAlarmType_SuppressedState_Name                                                                   = 13298
	CertificateExpirationAlarmType_SuppressedState_Number                                                                 = 13299
	CertificateExpirationAlarmType_SuppressedState_EffectiveDisplayName                                                   = 13300
	CertificateExpirationAlarmType_SuppressedState_TransitionTime                                                         = 13301
	CertificateExpirationAlarmType_SuppressedState_EffectiveTransitionTime                                                = 13302
	CertificateExpirationAlarmType_SuppressedState_TrueState                                                              = 13303
	CertificateExpirationAlarmType_SuppressedState_FalseState                                                             = 13304
	CertificateExpirationAlarmType_ShelvingState                                                                          = 13305
	CertificateExpirationAlarmType_ShelvingState_CurrentState                                                             = 13306
	CertificateExpirationAlarmType_ShelvingState_CurrentState_ID                                                          = 13307
	CertificateExpirationAlarmType_ShelvingState_CurrentState_Name                                                        = 13308
	CertificateExpirationAlarmType_ShelvingState_CurrentState_Number                                                      = 13309
	CertificateExpirationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName                                        = 13310
	CertificateExpirationAlarmType_ShelvingState_LastTransition                                                           = 13311
	CertificateExpirationAlarmType_ShelvingState_LastTransition_ID                                                        = 13312
	CertificateExpirationAlarmType_ShelvingState_LastTransition_Name                                                      = 13313
	CertificateExpirationAlarmType_ShelvingState_LastTransition_Number                                                    = 13314
	CertificateExpirationAlarmType_ShelvingState_LastTransition_TransitionTime                                            = 13315
	CertificateExpirationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime                                   = 13316
	CertificateExpirationAlarmType_ShelvingState_UnshelveTime                                                             = 13317
	CertificateExpirationAlarmType_ShelvingState_Unshelve                                                                 = 13318
	CertificateExpirationAlarmType_ShelvingState_OneShotShelve                                                            = 13319
	CertificateExpirationAlarmType_ShelvingState_TimedShelve                                                              = 13320
	CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments                                               = 13321
	CertificateExpirationAlarmType_SuppressedOrShelved                                                                    = 13322
	CertificateExpirationAlarmType_MaxTimeShelved                                                                         = 13323
	CertificateExpirationAlarmType_NormalState                                                                            = 13324
	CertificateExpirationAlarmType_ExpirationDate                                                                         = 13325
	CertificateExpirationAlarmType_CertificateType                                                                        = 13326
	CertificateExpirationAlarmType_Certificate                                                                            = 13327
	FileType_MimeType                                                                                                     = 13341
	CreateDirectoryMethodType                                                                                             = 13342
	CreateDirectoryMethodType_InputArguments                                                                              = 13343
	CreateDirectoryMethodType_OutputArguments                                                                             = 13344
	CreateFileMethodType                                                                                                  = 13345
	CreateFileMethodType_InputArguments                                                                                   = 13346
	CreateFileMethodType_OutputArguments                                                                                  = 13347
	DeleteFileMethodType                                                                                                  = 13348
	DeleteFileMethodType_InputArguments                                                                                   = 13349
	MoveOrCopyMethodType                                                                                                  = 13350
	MoveOrCopyMethodType_InputArguments                                                                                   = 13351
	MoveOrCopyMethodType_OutputArguments                                                                                  = 13352
	FileDirectoryType                                                                                                     = 13353
	FileDirectoryType_FileDirectoryName_Placeholder                                                                       = 13354
	FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory                                                       = 13355
	FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments                                        = 13356
	FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments                                       = 13357
	FileDirectoryType_FileDirectoryName_Placeholder_CreateFile                                                            = 13358
	FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments                                             = 13359
	FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments                                            = 13360
	FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy                                                            = 13363
	FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments                                             = 13364
	FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments                                            = 13365
	FileDirectoryType_FileName_Placeholder                                                                                = 13366
	FileDirectoryType_FileName_Placeholder_Size                                                                           = 13367
	FileDirectoryType_FileName_Placeholder_Writable                                                                       = 13368
	FileDirectoryType_FileName_Placeholder_UserWritable                                                                   = 13369
	FileDirectoryType_FileName_Placeholder_OpenCount                                                                      = 13370
	FileDirectoryType_FileName_Placeholder_MimeType                                                                       = 13371
	FileDirectoryType_FileName_Placeholder_Open                                                                           = 13372
	FileDirectoryType_FileName_Placeholder_Open_InputArguments                                                            = 13373
	FileDirectoryType_FileName_Placeholder_Open_OutputArguments                                                           = 13374
	FileDirectoryType_FileName_Placeholder_Close                                                                          = 13375
	FileDirectoryType_FileName_Placeholder_Close_InputArguments                                                           = 13376
	FileDirectoryType_FileName_Placeholder_Read                                                                           = 13377
	FileDirectoryType_FileName_Placeholder_Read_InputArguments                                                            = 13378
	FileDirectoryType_FileName_Placeholder_Read_OutputArguments                                                           = 13379
	FileDirectoryType_FileName_Placeholder_Write                                                                          = 13380
	FileDirectoryType_FileName_Placeholder_Write_InputArguments                                                           = 13381
	FileDirectoryType_FileName_Placeholder_GetPosition                                                                    = 13382
	FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments                                                     = 13383
	FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments                                                    = 13384
	FileDirectoryType_FileName_Placeholder_SetPosition                                                                    = 13385
	FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments                                                     = 13386
	FileDirectoryType_CreateDirectory                                                                                     = 13387
	FileDirectoryType_CreateDirectory_InputArguments                                                                      = 13388
	FileDirectoryType_CreateDirectory_OutputArguments                                                                     = 13389
	FileDirectoryType_CreateFile                                                                                          = 13390
	FileDirectoryType_CreateFile_InputArguments                                                                           = 13391
	FileDirectoryType_CreateFile_OutputArguments                                                                          = 13392
	FileDirectoryType_DeleteFileSystemObject                                                                              = 13393
	FileDirectoryType_DeleteFileSystemObject_InputArguments                                                               = 13394
	FileDirectoryType_MoveOrCopy                                                                                          = 13395
	FileDirectoryType_MoveOrCopy_InputArguments                                                                           = 13396
	FileDirectoryType_MoveOrCopy_OutputArguments                                                                          = 13397
	AddressSpaceFileType_MimeType                                                                                         = 13398
	NamespaceMetadataType_NamespaceFile_MimeType                                                                          = 13399
	NamespacesType_NamespaceIDentifier_Placeholder_NamespaceFile_MimeType                                                 = 13400
	TrustListType_MimeType                                                                                                = 13403
	CertificateGroupType_TrustList                                                                                        = 13599
	CertificateGroupType_TrustList_Size                                                                                   = 13600
	CertificateGroupType_TrustList_Writable                                                                               = 13601
	CertificateGroupType_TrustList_UserWritable                                                                           = 13602
	CertificateGroupType_TrustList_OpenCount                                                                              = 13603
	CertificateGroupType_TrustList_MimeType                                                                               = 13604
	CertificateGroupType_TrustList_Open                                                                                   = 13605
	CertificateGroupType_TrustList_Open_InputArguments                                                                    = 13606
	CertificateGroupType_TrustList_Open_OutputArguments                                                                   = 13607
	CertificateGroupType_TrustList_Close                                                                                  = 13608
	CertificateGroupType_TrustList_Close_InputArguments                                                                   = 13609
	CertificateGroupType_TrustList_Read                                                                                   = 13610
	CertificateGroupType_TrustList_Read_InputArguments                                                                    = 13611
	CertificateGroupType_TrustList_Read_OutputArguments                                                                   = 13612
	CertificateGroupType_TrustList_Write                                                                                  = 13613
	CertificateGroupType_TrustList_Write_InputArguments                                                                   = 13614
	CertificateGroupType_TrustList_GetPosition                                                                            = 13615
	CertificateGroupType_TrustList_GetPosition_InputArguments                                                             = 13616
	CertificateGroupType_TrustList_GetPosition_OutputArguments                                                            = 13617
	CertificateGroupType_TrustList_SetPosition                                                                            = 13618
	CertificateGroupType_TrustList_SetPosition_InputArguments                                                             = 13619
	CertificateGroupType_TrustList_LastUpdateTime                                                                         = 13620
	CertificateGroupType_TrustList_OpenWithMasks                                                                          = 13621
	CertificateGroupType_TrustList_OpenWithMasks_InputArguments                                                           = 13622
	CertificateGroupType_TrustList_OpenWithMasks_OutputArguments                                                          = 13623
	CertificateGroupType_TrustList_CloseAndUpdate                                                                         = 13624
	CertificateGroupType_TrustList_CloseAndUpdate_InputArguments                                                          = 13625
	CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments                                                         = 13626
	CertificateGroupType_TrustList_AddCertificate                                                                         = 13627
	CertificateGroupType_TrustList_AddCertificate_InputArguments                                                          = 13628
	CertificateGroupType_TrustList_RemoveCertificate                                                                      = 13629
	CertificateGroupType_TrustList_RemoveCertificate_InputArguments                                                       = 13630
	CertificateGroupType_CertificateTypes                                                                                 = 13631
	CertificateUpdatedAuditEventType_CertificateGroup                                                                     = 13735
	CertificateUpdatedAuditEventType_CertificateType                                                                      = 13736
	ServerConfiguration_UpdateCertificate                                                                                 = 13737
	ServerConfiguration_UpdateCertificate_InputArguments                                                                  = 13738
	ServerConfiguration_UpdateCertificate_OutputArguments                                                                 = 13739
	CertificateGroupFolderType                                                                                            = 13813
	CertificateGroupFolderType_DefaultApplicationGroup                                                                    = 13814
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList                                                          = 13815
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size                                                     = 13816
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable                                                 = 13817
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable                                             = 13818
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount                                                = 13819
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MimeType                                                 = 13820
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open                                                     = 13821
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments                                      = 13822
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments                                     = 13823
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close                                                    = 13824
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments                                     = 13825
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read                                                     = 13826
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments                                      = 13827
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments                                     = 13828
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write                                                    = 13829
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments                                     = 13830
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition                                              = 13831
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments                               = 13832
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments                              = 13833
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition                                              = 13834
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments                               = 13835
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime                                           = 13836
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks                                            = 13837
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments                             = 13838
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments                            = 13839
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate                                           = 13840
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments                            = 13841
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments                           = 13842
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate                                           = 13843
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments                            = 13844
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate                                        = 13845
	CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments                         = 13846
	CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes                                                   = 13847
	CertificateGroupFolderType_DefaultHttpsGroup                                                                          = 13848
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList                                                                = 13849
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size                                                           = 13850
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable                                                       = 13851
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable                                                   = 13852
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount                                                      = 13853
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MimeType                                                       = 13854
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open                                                           = 13855
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments                                            = 13856
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments                                           = 13857
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close                                                          = 13858
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments                                           = 13859
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read                                                           = 13860
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments                                            = 13861
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments                                           = 13862
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write                                                          = 13863
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments                                           = 13864
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition                                                    = 13865
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments                                     = 13866
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments                                    = 13867
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition                                                    = 13868
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments                                     = 13869
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime                                                 = 13870
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks                                                  = 13871
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments                                   = 13872
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments                                  = 13873
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate                                                 = 13874
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments                                  = 13875
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments                                 = 13876
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate                                                 = 13877
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments                                  = 13878
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate                                              = 13879
	CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments                               = 13880
	CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes                                                         = 13881
	CertificateGroupFolderType_DefaultUserTokenGroup                                                                      = 13882
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList                                                            = 13883
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size                                                       = 13884
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable                                                   = 13885
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable                                               = 13886
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount                                                  = 13887
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MimeType                                                   = 13888
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open                                                       = 13889
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments                                        = 13890
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments                                       = 13891
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close                                                      = 13892
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments                                       = 13893
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read                                                       = 13894
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments                                        = 13895
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments                                       = 13896
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write                                                      = 13897
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments                                       = 13898
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition                                                = 13899
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments                                 = 13900
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments                                = 13901
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition                                                = 13902
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments                                 = 13903
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime                                             = 13904
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks                                              = 13905
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments                               = 13906
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments                              = 13907
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                             = 13908
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments                              = 13909
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments                             = 13910
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate                                             = 13911
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments                              = 13912
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate                                          = 13913
	CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments                           = 13914
	CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes                                                     = 13915
	CertificateGroupFolderType_AdditionalGroup_Placeholder                                                                = 13916
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList                                                      = 13917
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size                                                 = 13918
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable                                             = 13919
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable                                         = 13920
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount                                            = 13921
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MimeType                                             = 13922
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open                                                 = 13923
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments                                  = 13924
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments                                 = 13925
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close                                                = 13926
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments                                 = 13927
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read                                                 = 13928
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments                                  = 13929
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments                                 = 13930
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write                                                = 13931
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments                                 = 13932
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition                                          = 13933
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments                           = 13934
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments                          = 13935
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition                                          = 13936
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments                           = 13937
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime                                       = 13938
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks                                        = 13939
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments                         = 13940
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments                        = 13941
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate                                       = 13942
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments                        = 13943
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments                       = 13944
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate                                       = 13945
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments                        = 13946
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate                                    = 13947
	CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments                     = 13948
	CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes                                               = 13949
	ServerConfigurationType_CertificateGroups                                                                             = 13950
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup                                                     = 13951
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList                                           = 13952
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size                                      = 13953
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable                                  = 13954
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable                              = 13955
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount                                 = 13956
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType                                  = 13957
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open                                      = 13958
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments                       = 13959
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments                      = 13960
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close                                     = 13961
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments                      = 13962
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read                                      = 13963
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments                       = 13964
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments                      = 13965
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write                                     = 13966
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments                      = 13967
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition                               = 13968
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments                = 13969
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments               = 13970
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition                               = 13971
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments                = 13972
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime                            = 13973
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks                             = 13974
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments              = 13975
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments             = 13976
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate                            = 13977
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments             = 13978
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments            = 13979
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate                            = 13980
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments             = 13981
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate                         = 13982
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments          = 13983
	ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes                                    = 13984
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup                                                           = 13985
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList                                                 = 13986
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size                                            = 13987
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable                                        = 13988
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable                                    = 13989
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount                                       = 13990
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType                                        = 13991
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                            = 13992
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments                             = 13993
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments                            = 13994
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                           = 13995
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments                            = 13996
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                            = 13997
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments                             = 13998
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments                            = 13999
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                           = 14000
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments                            = 14001
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                     = 14002
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments                      = 14003
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments                     = 14004
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                     = 14005
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments                      = 14006
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime                                  = 14007
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                   = 14008
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments                    = 14009
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments                   = 14010
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                  = 14011
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments                   = 14012
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments                  = 14013
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                  = 14014
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments                   = 14015
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                               = 14016
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments                = 14017
	ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes                                          = 14018
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup                                                       = 14019
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList                                             = 14020
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size                                        = 14021
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable                                    = 14022
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable                                = 14023
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount                                   = 14024
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType                                    = 14025
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                        = 14026
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments                         = 14027
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments                        = 14028
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                       = 14029
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments                        = 14030
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                        = 14031
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments                         = 14032
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments                        = 14033
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                       = 14034
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments                        = 14035
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                 = 14036
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments                  = 14037
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments                 = 14038
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                 = 14039
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments                  = 14040
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime                              = 14041
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                               = 14042
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments                = 14043
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments               = 14044
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                              = 14045
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments               = 14046
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments              = 14047
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                              = 14048
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments               = 14049
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                           = 14050
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments            = 14051
	ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes                                      = 14052
	ServerConfiguration_CertificateGroups                                                                                 = 14053
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup                                                               = 14088
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList                                                     = 14089
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Size                                                = 14090
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Writable                                            = 14091
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable                                        = 14092
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount                                           = 14093
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType                                            = 14094
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open                                                = 14095
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments                                 = 14096
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments                                = 14097
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close                                               = 14098
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments                                = 14099
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read                                                = 14100
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments                                 = 14101
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments                                = 14102
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write                                               = 14103
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments                                = 14104
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition                                         = 14105
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments                          = 14106
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments                         = 14107
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition                                         = 14108
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments                          = 14109
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime                                      = 14110
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks                                       = 14111
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments                        = 14112
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments                       = 14113
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate                                      = 14114
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments                       = 14115
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments                      = 14116
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate                                      = 14117
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments                       = 14118
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate                                   = 14119
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments                    = 14120
	ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateTypes                                              = 14121
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup                                                           = 14122
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList                                                 = 14123
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Size                                            = 14124
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable                                        = 14125
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable                                    = 14126
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount                                       = 14127
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType                                        = 14128
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open                                            = 14129
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments                             = 14130
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments                            = 14131
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close                                           = 14132
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments                            = 14133
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read                                            = 14134
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments                             = 14135
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments                            = 14136
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write                                           = 14137
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments                            = 14138
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition                                     = 14139
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments                      = 14140
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments                     = 14141
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition                                     = 14142
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments                      = 14143
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime                                  = 14144
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks                                   = 14145
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments                    = 14146
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments                   = 14147
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate                                  = 14148
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments                   = 14149
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments                  = 14150
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate                                  = 14151
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments                   = 14152
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate                               = 14153
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments                = 14154
	ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateTypes                                          = 14155
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup                                                         = 14156
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Writable                                      = 14157
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable                                  = 14158
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType                                      = 14159
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments                 = 14160
	ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateTypes                                        = 14161
	RemoveConnectionMethodType                                                                                            = 14183
	RemoveConnectionMethodType_InputArguments                                                                             = 14184
	PubSubConnectionType                                                                                                  = 14209
	PubSubConnectionType_Address                                                                                          = 14221
	PubSubConnectionType_RemoveGroup                                                                                      = 14225
	PubSubConnectionType_RemoveGroup_InputArguments                                                                       = 14226
	PubSubGroupType                                                                                                       = 14232
	PublishedVariableDataType                                                                                             = 14273
	PublishedVariableDataType_Encoding_DefaultXML                                                                         = 14319
	OpcUa_XMLSchema_PublishedVariableDataType                                                                             = 14320
	OpcUa_XMLSchema_PublishedVariableDataType_DataTypeVersion                                                             = 14321
	OpcUa_XMLSchema_PublishedVariableDataType_DictionaryFragment                                                          = 14322
	PublishedVariableDataType_Encoding_DefaultBinary                                                                      = 14323
	OpcUa_BinarySchema_PublishedVariableDataType                                                                          = 14324
	OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion                                                          = 14325
	OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment                                                       = 14326
	AuditCreateSessionEventType_SessionID                                                                                 = 14413
	AuditURLMismatchEventType_SessionID                                                                                   = 14414
	Server_ServerRedundancy_ServerNetworkGroups                                                                           = 14415
	PublishSubscribeType                                                                                                  = 14416
	PublishSubscribeType_ConnectionName_Placeholder                                                                       = 14417
	PublishSubscribeType_ConnectionName_Placeholder_PublisherID                                                           = 14418
	PublishSubscribeType_ConnectionName_Placeholder_Status                                                                = 14419
	PublishSubscribeType_ConnectionName_Placeholder_Status_State                                                          = 14420
	PublishSubscribeType_ConnectionName_Placeholder_Status_Enable                                                         = 14421
	PublishSubscribeType_ConnectionName_Placeholder_Status_Disable                                                        = 14422
	PublishSubscribeType_ConnectionName_Placeholder_Address                                                               = 14423
	PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup                                                           = 14424
	PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments                                            = 14425
	PublishSubscribeType_RemoveConnection                                                                                 = 14432
	PublishSubscribeType_RemoveConnection_InputArguments                                                                  = 14433
	PublishSubscribeType_PublishedDataSets                                                                                = 14434
	PublishSubscribeType_PublishedDataSets_AddPublishedDataItems                                                          = 14435
	PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments                                           = 14436
	PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments                                          = 14437
	PublishSubscribeType_PublishedDataSets_AddPublishedEvents                                                             = 14438
	PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments                                              = 14439
	PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments                                             = 14440
	PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet                                                         = 14441
	PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments                                          = 14442
	PublishSubscribe                                                                                                      = 14443
	HasPubSubConnection                                                                                                   = 14476
	DataSetFolderType                                                                                                     = 14477
	DataSetFolderType_DataSetFolderName_Placeholder                                                                       = 14478
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems                                                 = 14479
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems_InputArguments                                  = 14480
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems_OutputArguments                                 = 14481
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents                                                    = 14482
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents_InputArguments                                     = 14483
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents_OutputArguments                                    = 14484
	DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet                                                = 14485
	DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet_InputArguments                                 = 14486
	DataSetFolderType_PublishedDataSetName_Placeholder                                                                    = 14487
	DataSetFolderType_PublishedDataSetName_Placeholder_ConfigurationVersion                                               = 14489
	DataSetFolderType_AddPublishedDataItems                                                                               = 14493
	DataSetFolderType_AddPublishedDataItems_InputArguments                                                                = 14494
	DataSetFolderType_AddPublishedDataItems_OutputArguments                                                               = 14495
	DataSetFolderType_AddPublishedEvents                                                                                  = 14496
	DataSetFolderType_AddPublishedEvents_InputArguments                                                                   = 14497
	DataSetFolderType_AddPublishedEvents_OutputArguments                                                                  = 14498
	DataSetFolderType_RemovePublishedDataSet                                                                              = 14499
	DataSetFolderType_RemovePublishedDataSet_InputArguments                                                               = 14500
	AddPublishedDataItemsMethodType                                                                                       = 14501
	AddPublishedDataItemsMethodType_InputArguments                                                                        = 14502
	AddPublishedDataItemsMethodType_OutputArguments                                                                       = 14503
	AddPublishedEventsMethodType                                                                                          = 14504
	AddPublishedEventsMethodType_InputArguments                                                                           = 14505
	AddPublishedEventsMethodType_OutputArguments                                                                          = 14506
	RemovePublishedDataSetMethodType                                                                                      = 14507
	RemovePublishedDataSetMethodType_InputArguments                                                                       = 14508
	PublishedDataSetType                                                                                                  = 14509
	PublishedDataSetType_ConfigurationVersion                                                                             = 14519
	DataSetMetaDataType                                                                                                   = 14523
	FieldMetaData                                                                                                         = 14524
	DataTypeDescription                                                                                                   = 14525
	StructureType_EnumStrings                                                                                             = 14528
	KeyValuePair                                                                                                          = 14533
	PublishedDataItemsType                                                                                                = 14534
	PublishedDataItemsType_ConfigurationVersion                                                                           = 14544
	PublishedDataItemsType_PublishedData                                                                                  = 14548
	PublishedDataItemsType_AddVariables                                                                                   = 14555
	PublishedDataItemsType_AddVariables_InputArguments                                                                    = 14556
	PublishedDataItemsType_AddVariables_OutputArguments                                                                   = 14557
	PublishedDataItemsType_RemoveVariables                                                                                = 14558
	PublishedDataItemsType_RemoveVariables_InputArguments                                                                 = 14559
	PublishedDataItemsType_RemoveVariables_OutputArguments                                                                = 14560
	PublishedDataItemsAddVariablesMethodType                                                                              = 14564
	PublishedDataItemsAddVariablesMethodType_InputArguments                                                               = 14565
	PublishedDataItemsAddVariablesMethodType_OutputArguments                                                              = 14566
	PublishedDataItemsRemoveVariablesMethodType                                                                           = 14567
	PublishedDataItemsRemoveVariablesMethodType_InputArguments                                                            = 14568
	PublishedDataItemsRemoveVariablesMethodType_OutputArguments                                                           = 14569
	PublishedEventsType                                                                                                   = 14572
	PublishedEventsType_ConfigurationVersion                                                                              = 14582
	PublishedEventsType_PubSubEventNotifier                                                                               = 14586
	PublishedEventsType_SelectedFields                                                                                    = 14587
	PublishedEventsType_Filter                                                                                            = 14588
	ConfigurationVersionDataType                                                                                          = 14593
	PubSubConnectionType_PublisherID                                                                                      = 14595
	PubSubConnectionType_Status                                                                                           = 14600
	PubSubConnectionType_Status_State                                                                                     = 14601
	PubSubConnectionType_Status_Enable                                                                                    = 14602
	PubSubConnectionType_Status_Disable                                                                                   = 14603
	PubSubConnectionTypeRemoveGroupMethodType                                                                             = 14604
	PubSubConnectionTypeRemoveGroupMethodType_InputArguments                                                              = 14605
	PubSubGroupTypeRemoveWriterMethodType                                                                                 = 14623
	PubSubGroupTypeRemoveWriterMethodType_InputArguments                                                                  = 14624
	PubSubGroupTypeRemoveReaderMethodType                                                                                 = 14625
	PubSubGroupTypeRemoveReaderMethodType_InputArguments                                                                  = 14626
	PubSubStatusType                                                                                                      = 14643
	PubSubStatusType_State                                                                                                = 14644
	PubSubStatusType_Enable                                                                                               = 14645
	PubSubStatusType_Disable                                                                                              = 14646
	PubSubState                                                                                                           = 14647
	PubSubState_EnumStrings                                                                                               = 14648
	FieldTargetDataType                                                                                                   = 14744
	DataSetMetaDataType_Encoding_DefaultXML                                                                               = 14794
	FieldMetaData_Encoding_DefaultXML                                                                                     = 14795
	DataTypeDescription_Encoding_DefaultXML                                                                               = 14796
	DataTypeDefinition_Encoding_DefaultXML                                                                                = 14797
	StructureDefinition_Encoding_DefaultXML                                                                               = 14798
	EnumDefinition_Encoding_DefaultXML                                                                                    = 14799
	StructureField_Encoding_DefaultXML                                                                                    = 14800
	EnumField_Encoding_DefaultXML                                                                                         = 14801
	KeyValuePair_Encoding_DefaultXML                                                                                      = 14802
	ConfigurationVersionDataType_Encoding_DefaultXML                                                                      = 14803
	FieldTargetDataType_Encoding_DefaultXML                                                                               = 14804
	OpcUa_XMLSchema_DataSetMetaDataType                                                                                   = 14805
	OpcUa_XMLSchema_DataSetMetaDataType_DataTypeVersion                                                                   = 14806
	OpcUa_XMLSchema_DataSetMetaDataType_DictionaryFragment                                                                = 14807
	OpcUa_XMLSchema_FieldMetaData                                                                                         = 14808
	OpcUa_XMLSchema_FieldMetaData_DataTypeVersion                                                                         = 14809
	OpcUa_XMLSchema_FieldMetaData_DictionaryFragment                                                                      = 14810
	OpcUa_XMLSchema_DataTypeDescription                                                                                   = 14811
	OpcUa_XMLSchema_DataTypeDescription_DataTypeVersion                                                                   = 14812
	OpcUa_XMLSchema_DataTypeDescription_DictionaryFragment                                                                = 14813
	OpcUa_XMLSchema_EnumField                                                                                             = 14826
	OpcUa_XMLSchema_EnumField_DataTypeVersion                                                                             = 14827
	OpcUa_XMLSchema_EnumField_DictionaryFragment                                                                          = 14828
	OpcUa_XMLSchema_KeyValuePair                                                                                          = 14829
	OpcUa_XMLSchema_KeyValuePair_DataTypeVersion                                                                          = 14830
	OpcUa_XMLSchema_KeyValuePair_DictionaryFragment                                                                       = 14831
	OpcUa_XMLSchema_ConfigurationVersionDataType                                                                          = 14832
	OpcUa_XMLSchema_ConfigurationVersionDataType_DataTypeVersion                                                          = 14833
	OpcUa_XMLSchema_ConfigurationVersionDataType_DictionaryFragment                                                       = 14834
	OpcUa_XMLSchema_FieldTargetDataType                                                                                   = 14835
	OpcUa_XMLSchema_FieldTargetDataType_DataTypeVersion                                                                   = 14836
	OpcUa_XMLSchema_FieldTargetDataType_DictionaryFragment                                                                = 14837
	FieldMetaData_Encoding_DefaultBinary                                                                                  = 14839
	StructureField_Encoding_DefaultBinary                                                                                 = 14844
	EnumField_Encoding_DefaultBinary                                                                                      = 14845
	KeyValuePair_Encoding_DefaultBinary                                                                                   = 14846
	ConfigurationVersionDataType_Encoding_DefaultBinary                                                                   = 14847
	FieldTargetDataType_Encoding_DefaultBinary                                                                            = 14848
	OpcUa_BinarySchema_DataSetMetaDataType                                                                                = 14849
	OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion                                                                = 14850
	OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment                                                             = 14851
	OpcUa_BinarySchema_FieldMetaData                                                                                      = 14852
	OpcUa_BinarySchema_FieldMetaData_DataTypeVersion                                                                      = 14853
	OpcUa_BinarySchema_FieldMetaData_DictionaryFragment                                                                   = 14854
	OpcUa_BinarySchema_DataTypeDescription                                                                                = 14855
	OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion                                                                = 14856
	OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment                                                             = 14857
	OpcUa_BinarySchema_EnumField                                                                                          = 14870
	OpcUa_BinarySchema_EnumField_DataTypeVersion                                                                          = 14871
	OpcUa_BinarySchema_EnumField_DictionaryFragment                                                                       = 14872
	OpcUa_BinarySchema_KeyValuePair                                                                                       = 14873
	OpcUa_BinarySchema_KeyValuePair_DataTypeVersion                                                                       = 14874
	OpcUa_BinarySchema_KeyValuePair_DictionaryFragment                                                                    = 14875
	OpcUa_BinarySchema_ConfigurationVersionDataType                                                                       = 14876
	OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion                                                       = 14877
	OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment                                                    = 14878
	OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion                                                                = 14880
	OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment                                                             = 14881
	CertificateExpirationAlarmType_ExpirationLimit                                                                        = 14900
	DataSetToWriter                                                                                                       = 14936
	DataTypeDictionaryType_Deprecated                                                                                     = 15001
	MaxCharacters                                                                                                         = 15002
	ServerType_URIsVersion                                                                                                = 15003
	Server_URIsVersion                                                                                                    = 15004
	SimpleTypeDescription                                                                                                 = 15005
	UABinaryFileDataType                                                                                                  = 15006
	BrokerConnectionTransportDataType                                                                                     = 15007
	BrokerTransportQoS                                                                                                    = 15008
	BrokerTransportQoS_EnumStrings                                                                                        = 15009
	SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime                                                     = 15010
	SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyURI                                               = 15011
	SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount                                               = 15012
	AuditConditionResetEventType                                                                                          = 15013
	AuditConditionResetEventType_EventID                                                                                  = 15014
	AuditConditionResetEventType_EventType                                                                                = 15015
	AuditConditionResetEventType_SourceNode                                                                               = 15016
	AuditConditionResetEventType_SourceName                                                                               = 15017
	AuditConditionResetEventType_Time                                                                                     = 15018
	AuditConditionResetEventType_ReceiveTime                                                                              = 15019
	AuditConditionResetEventType_LocalTime                                                                                = 15020
	AuditConditionResetEventType_Message                                                                                  = 15021
	AuditConditionResetEventType_Severity                                                                                 = 15022
	AuditConditionResetEventType_ActionTimeStamp                                                                          = 15023
	AuditConditionResetEventType_Status                                                                                   = 15024
	AuditConditionResetEventType_ServerID                                                                                 = 15025
	AuditConditionResetEventType_ClientAuditEntryID                                                                       = 15026
	AuditConditionResetEventType_ClientUserID                                                                             = 15027
	AuditConditionResetEventType_MethodID                                                                                 = 15028
	AuditConditionResetEventType_InputArguments                                                                           = 15029
	PermissionType_OptionSetValues                                                                                        = 15030
	AccessLevelType                                                                                                       = 15031
	AccessLevelType_OptionSetValues                                                                                       = 15032
	EventNotifierType                                                                                                     = 15033
	EventNotifierType_OptionSetValues                                                                                     = 15034
	AccessRestrictionType_OptionSetValues                                                                                 = 15035
	AttributeWriteMask_OptionSetValues                                                                                    = 15036
	OpcUa_BinarySchema_Deprecated                                                                                         = 15037
	ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues                                                       = 15038
	OpcUa_XMLSchema_Deprecated                                                                                            = 15039
	ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues                                                      = 15040
	KeyValuePair_Encoding_DefaultJSON                                                                                     = 15041
	IdentityMappingRuleType_Encoding_DefaultJSON                                                                          = 15042
	SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount                                                 = 15043
	TrustListDataType_Encoding_DefaultJSON                                                                                = 15044
	DecimalDataType_Encoding_DefaultJSON                                                                                  = 15045
	SecurityGroupType_KeyLifetime                                                                                         = 15046
	SecurityGroupType_SecurityPolicyURI                                                                                   = 15047
	SecurityGroupType_MaxFutureKeyCount                                                                                   = 15048
	ConfigurationVersionDataType_Encoding_DefaultJSON                                                                     = 15049
	DataSetMetaDataType_Encoding_DefaultJSON                                                                              = 15050
	FieldMetaData_Encoding_DefaultJSON                                                                                    = 15051
	PublishedEventsType_ModifyFieldSelection                                                                              = 15052
	PublishedEventsType_ModifyFieldSelection_InputArguments                                                               = 15053
	PublishedEventsTypeModifyFieldSelectionMethodType                                                                     = 15054
	PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments                                                      = 15055
	SecurityGroupType_MaxPastKeyCount                                                                                     = 15056
	DataTypeDescription_Encoding_DefaultJSON                                                                              = 15057
	StructureDescription_Encoding_DefaultJSON                                                                             = 15058
	EnumDescription_Encoding_DefaultJSON                                                                                  = 15059
	PublishedVariableDataType_Encoding_DefaultJSON                                                                        = 15060
	FieldTargetDataType_Encoding_DefaultJSON                                                                              = 15061
	RolePermissionType_Encoding_DefaultJSON                                                                               = 15062
	DataTypeDefinition_Encoding_DefaultJSON                                                                               = 15063
	DatagramConnectionTransportType                                                                                       = 15064
	StructureField_Encoding_DefaultJSON                                                                                   = 15065
	StructureDefinition_Encoding_DefaultJSON                                                                              = 15066
	EnumDefinition_Encoding_DefaultJSON                                                                                   = 15067
	Node_Encoding_DefaultJSON                                                                                             = 15068
	InstanceNode_Encoding_DefaultJSON                                                                                     = 15069
	TypeNode_Encoding_DefaultJSON                                                                                         = 15070
	ObjectNode_Encoding_DefaultJSON                                                                                       = 15071
	DatagramConnectionTransportType_DiscoveryAddress                                                                      = 15072
	ObjectTypeNode_Encoding_DefaultJSON                                                                                   = 15073
	VariableNode_Encoding_DefaultJSON                                                                                     = 15074
	VariableTypeNode_Encoding_DefaultJSON                                                                                 = 15075
	ReferenceTypeNode_Encoding_DefaultJSON                                                                                = 15076
	MethodNode_Encoding_DefaultJSON                                                                                       = 15077
	ViewNode_Encoding_DefaultJSON                                                                                         = 15078
	DataTypeNode_Encoding_DefaultJSON                                                                                     = 15079
	ReferenceNode_Encoding_DefaultJSON                                                                                    = 15080
	Argument_Encoding_DefaultJSON                                                                                         = 15081
	EnumValueType_Encoding_DefaultJSON                                                                                    = 15082
	EnumField_Encoding_DefaultJSON                                                                                        = 15083
	OptionSet_Encoding_DefaultJSON                                                                                        = 15084
	Union_Encoding_DefaultJSON                                                                                            = 15085
	TimeZoneDataType_Encoding_DefaultJSON                                                                                 = 15086
	ApplicationDescription_Encoding_DefaultJSON                                                                           = 15087
	RequestHeader_Encoding_DefaultJSON                                                                                    = 15088
	ResponseHeader_Encoding_DefaultJSON                                                                                   = 15089
	ServiceFault_Encoding_DefaultJSON                                                                                     = 15090
	SessionlessInvokeRequestType_Encoding_DefaultJSON                                                                     = 15091
	SessionlessInvokeResponseType_Encoding_DefaultJSON                                                                    = 15092
	FindServersRequest_Encoding_DefaultJSON                                                                               = 15093
	FindServersResponse_Encoding_DefaultJSON                                                                              = 15094
	ServerOnNetwork_Encoding_DefaultJSON                                                                                  = 15095
	FindServersOnNetworkRequest_Encoding_DefaultJSON                                                                      = 15096
	FindServersOnNetworkResponse_Encoding_DefaultJSON                                                                     = 15097
	UserTokenPolicy_Encoding_DefaultJSON                                                                                  = 15098
	EndpointDescription_Encoding_DefaultJSON                                                                              = 15099
	GetEndpointsRequest_Encoding_DefaultJSON                                                                              = 15100
	GetEndpointsResponse_Encoding_DefaultJSON                                                                             = 15101
	RegisteredServer_Encoding_DefaultJSON                                                                                 = 15102
	RegisterServerRequest_Encoding_DefaultJSON                                                                            = 15103
	RegisterServerResponse_Encoding_DefaultJSON                                                                           = 15104
	DiscoveryConfiguration_Encoding_DefaultJSON                                                                           = 15105
	MdnsDiscoveryConfiguration_Encoding_DefaultJSON                                                                       = 15106
	RegisterServer2Request_Encoding_DefaultJSON                                                                           = 15107
	SubscribedDataSetType                                                                                                 = 15108
	ChoiceStateType                                                                                                       = 15109
	ChoiceStateType_StateNumber                                                                                           = 15110
	TargetVariablesType                                                                                                   = 15111
	HasGuard                                                                                                              = 15112
	GuardVariableType                                                                                                     = 15113
	TargetVariablesType_TargetVariables                                                                                   = 15114
	TargetVariablesType_AddTargetVariables                                                                                = 15115
	TargetVariablesType_AddTargetVariables_InputArguments                                                                 = 15116
	TargetVariablesType_AddTargetVariables_OutputArguments                                                                = 15117
	TargetVariablesType_RemoveTargetVariables                                                                             = 15118
	TargetVariablesType_RemoveTargetVariables_InputArguments                                                              = 15119
	TargetVariablesType_RemoveTargetVariables_OutputArguments                                                             = 15120
	TargetVariablesTypeAddTargetVariablesMethodType                                                                       = 15121
	TargetVariablesTypeAddTargetVariablesMethodType_InputArguments                                                        = 15122
	TargetVariablesTypeAddTargetVariablesMethodType_OutputArguments                                                       = 15123
	TargetVariablesTypeRemoveTargetVariablesMethodType                                                                    = 15124
	TargetVariablesTypeRemoveTargetVariablesMethodType_InputArguments                                                     = 15125
	TargetVariablesTypeRemoveTargetVariablesMethodType_OutputArguments                                                    = 15126
	SubscribedDataSetMirrorType                                                                                           = 15127
	ExpressionGuardVariableType                                                                                           = 15128
	ExpressionGuardVariableType_Expression                                                                                = 15129
	RegisterServer2Response_Encoding_DefaultJSON                                                                          = 15130
	ChannelSecurityToken_Encoding_DefaultJSON                                                                             = 15131
	OpenSecureChannelRequest_Encoding_DefaultJSON                                                                         = 15132
	OpenSecureChannelResponse_Encoding_DefaultJSON                                                                        = 15133
	CloseSecureChannelRequest_Encoding_DefaultJSON                                                                        = 15134
	CloseSecureChannelResponse_Encoding_DefaultJSON                                                                       = 15135
	SignedSoftwareCertificate_Encoding_DefaultJSON                                                                        = 15136
	SignatureData_Encoding_DefaultJSON                                                                                    = 15137
	CreateSessionRequest_Encoding_DefaultJSON                                                                             = 15138
	CreateSessionResponse_Encoding_DefaultJSON                                                                            = 15139
	UserIdentityToken_Encoding_DefaultJSON                                                                                = 15140
	AnonymousIdentityToken_Encoding_DefaultJSON                                                                           = 15141
	UserNameIdentityToken_Encoding_DefaultJSON                                                                            = 15142
	X509IdentityToken_Encoding_DefaultJSON                                                                                = 15143
	IssuedIdentityToken_Encoding_DefaultJSON                                                                              = 15144
	ActivateSessionRequest_Encoding_DefaultJSON                                                                           = 15145
	ActivateSessionResponse_Encoding_DefaultJSON                                                                          = 15146
	CloseSessionRequest_Encoding_DefaultJSON                                                                              = 15147
	CloseSessionResponse_Encoding_DefaultJSON                                                                             = 15148
	CancelRequest_Encoding_DefaultJSON                                                                                    = 15149
	CancelResponse_Encoding_DefaultJSON                                                                                   = 15150
	NodeAttributes_Encoding_DefaultJSON                                                                                   = 15151
	ObjectAttributes_Encoding_DefaultJSON                                                                                 = 15152
	VariableAttributes_Encoding_DefaultJSON                                                                               = 15153
	DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface                                                     = 15154
	BrokerConnectionTransportType                                                                                         = 15155
	BrokerConnectionTransportType_ResourceURI                                                                             = 15156
	MethodAttributes_Encoding_DefaultJSON                                                                                 = 15157
	ObjectTypeAttributes_Encoding_DefaultJSON                                                                             = 15158
	VariableTypeAttributes_Encoding_DefaultJSON                                                                           = 15159
	ReferenceTypeAttributes_Encoding_DefaultJSON                                                                          = 15160
	DataTypeAttributes_Encoding_DefaultJSON                                                                               = 15161
	ViewAttributes_Encoding_DefaultJSON                                                                                   = 15162
	GenericAttributeValue_Encoding_DefaultJSON                                                                            = 15163
	GenericAttributes_Encoding_DefaultJSON                                                                                = 15164
	AddNodesItem_Encoding_DefaultJSON                                                                                     = 15165
	AddNodesResult_Encoding_DefaultJSON                                                                                   = 15166
	AddNodesRequest_Encoding_DefaultJSON                                                                                  = 15167
	AddNodesResponse_Encoding_DefaultJSON                                                                                 = 15168
	AddReferencesItem_Encoding_DefaultJSON                                                                                = 15169
	AddReferencesRequest_Encoding_DefaultJSON                                                                             = 15170
	AddReferencesResponse_Encoding_DefaultJSON                                                                            = 15171
	DeleteNodesItem_Encoding_DefaultJSON                                                                                  = 15172
	DeleteNodesRequest_Encoding_DefaultJSON                                                                               = 15173
	DeleteNodesResponse_Encoding_DefaultJSON                                                                              = 15174
	DeleteReferencesItem_Encoding_DefaultJSON                                                                             = 15175
	DeleteReferencesRequest_Encoding_DefaultJSON                                                                          = 15176
	DeleteReferencesResponse_Encoding_DefaultJSON                                                                         = 15177
	BrokerConnectionTransportType_AuthenticationProfileURI                                                                = 15178
	ViewDescription_Encoding_DefaultJSON                                                                                  = 15179
	BrowseDescription_Encoding_DefaultJSON                                                                                = 15180
	UserCredentialCertificateType                                                                                         = 15181
	ReferenceDescription_Encoding_DefaultJSON                                                                             = 15182
	BrowseResult_Encoding_DefaultJSON                                                                                     = 15183
	BrowseRequest_Encoding_DefaultJSON                                                                                    = 15184
	BrowseResponse_Encoding_DefaultJSON                                                                                   = 15185
	BrowseNextRequest_Encoding_DefaultJSON                                                                                = 15186
	BrowseNextResponse_Encoding_DefaultJSON                                                                               = 15187
	RelativePathElement_Encoding_DefaultJSON                                                                              = 15188
	RelativePath_Encoding_DefaultJSON                                                                                     = 15189
	BrowsePath_Encoding_DefaultJSON                                                                                       = 15190
	BrowsePathTarget_Encoding_DefaultJSON                                                                                 = 15191
	BrowsePathResult_Encoding_DefaultJSON                                                                                 = 15192
	TranslateBrowsePathsToNodeIDsRequest_Encoding_DefaultJSON                                                             = 15193
	TranslateBrowsePathsToNodeIDsResponse_Encoding_DefaultJSON                                                            = 15194
	RegisterNodesRequest_Encoding_DefaultJSON                                                                             = 15195
	RegisterNodesResponse_Encoding_DefaultJSON                                                                            = 15196
	UnregisterNodesRequest_Encoding_DefaultJSON                                                                           = 15197
	UnregisterNodesResponse_Encoding_DefaultJSON                                                                          = 15198
	EndpointConfiguration_Encoding_DefaultJSON                                                                            = 15199
	QueryDataDescription_Encoding_DefaultJSON                                                                             = 15200
	NodeTypeDescription_Encoding_DefaultJSON                                                                              = 15201
	QueryDataSet_Encoding_DefaultJSON                                                                                     = 15202
	NodeReference_Encoding_DefaultJSON                                                                                    = 15203
	ContentFilterElement_Encoding_DefaultJSON                                                                             = 15204
	ContentFilter_Encoding_DefaultJSON                                                                                    = 15205
	FilterOperand_Encoding_DefaultJSON                                                                                    = 15206
	ElementOperand_Encoding_DefaultJSON                                                                                   = 15207
	LiteralOperand_Encoding_DefaultJSON                                                                                   = 15208
	AttributeOperand_Encoding_DefaultJSON                                                                                 = 15209
	SimpleAttributeOperand_Encoding_DefaultJSON                                                                           = 15210
	ContentFilterElementResult_Encoding_DefaultJSON                                                                       = 15211
	PublishSubscribeType_GetSecurityKeys                                                                                  = 15212
	PublishSubscribeType_GetSecurityKeys_InputArguments                                                                   = 15213
	PublishSubscribeType_GetSecurityKeys_OutputArguments                                                                  = 15214
	PublishSubscribe_GetSecurityKeys                                                                                      = 15215
	PublishSubscribe_GetSecurityKeys_InputArguments                                                                       = 15216
	PublishSubscribe_GetSecurityKeys_OutputArguments                                                                      = 15217
	GetSecurityKeysMethodType                                                                                             = 15218
	GetSecurityKeysMethodType_InputArguments                                                                              = 15219
	GetSecurityKeysMethodType_OutputArguments                                                                             = 15220
	DataSetFolderType_PublishedDataSetName_Placeholder_DataSetMetaData                                                    = 15221
	PublishedDataSetType_DataSetWriterName_Placeholder                                                                    = 15222
	PublishedDataSetType_DataSetWriterName_Placeholder_Status                                                             = 15223
	PublishedDataSetType_DataSetWriterName_Placeholder_Status_State                                                       = 15224
	PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable                                                      = 15225
	PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable                                                     = 15226
	PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings                                                  = 15227
	ContentFilterResult_Encoding_DefaultJSON                                                                              = 15228
	PublishedDataSetType_DataSetMetaData                                                                                  = 15229
	PublishedDataItemsType_DataSetWriterName_Placeholder                                                                  = 15230
	PublishedDataItemsType_DataSetWriterName_Placeholder_Status                                                           = 15231
	PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State                                                     = 15232
	PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Enable                                                    = 15233
	PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Disable                                                   = 15234
	PublishedDataItemsType_DataSetWriterName_Placeholder_TransportSettings                                                = 15235
	ParsingResult_Encoding_DefaultJSON                                                                                    = 15236
	PublishedDataItemsType_DataSetMetaData                                                                                = 15237
	PublishedEventsType_DataSetWriterName_Placeholder                                                                     = 15238
	PublishedEventsType_DataSetWriterName_Placeholder_Status                                                              = 15239
	PublishedEventsType_DataSetWriterName_Placeholder_Status_State                                                        = 15240
	PublishedEventsType_DataSetWriterName_Placeholder_Status_Enable                                                       = 15241
	PublishedEventsType_DataSetWriterName_Placeholder_Status_Disable                                                      = 15242
	PublishedEventsType_DataSetWriterName_Placeholder_TransportSettings                                                   = 15243
	QueryFirstRequest_Encoding_DefaultJSON                                                                                = 15244
	PublishedEventsType_DataSetMetaData                                                                                   = 15245
	BrokerWriterGroupTransportType_ResourceURI                                                                            = 15246
	BrokerWriterGroupTransportType_AuthenticationProfileURI                                                               = 15247
	CreateCredentialMethodType                                                                                            = 15248
	BrokerWriterGroupTransportType_RequestedDeliveryGuarantee                                                             = 15249
	BrokerDataSetWriterTransportType_ResourceURI                                                                          = 15250
	BrokerDataSetWriterTransportType_AuthenticationProfileURI                                                             = 15251
	QueryFirstResponse_Encoding_DefaultJSON                                                                               = 15252
	CreateCredentialMethodType_InputArguments                                                                             = 15253
	QueryNextRequest_Encoding_DefaultJSON                                                                                 = 15254
	QueryNextResponse_Encoding_DefaultJSON                                                                                = 15255
	ReadValueID_Encoding_DefaultJSON                                                                                      = 15256
	ReadRequest_Encoding_DefaultJSON                                                                                      = 15257
	ReadResponse_Encoding_DefaultJSON                                                                                     = 15258
	HistoryReadValueID_Encoding_DefaultJSON                                                                               = 15259
	HistoryReadResult_Encoding_DefaultJSON                                                                                = 15260
	HistoryReadDetails_Encoding_DefaultJSON                                                                               = 15261
	ReadEventDetails_Encoding_DefaultJSON                                                                                 = 15262
	ReadRawModifiedDetails_Encoding_DefaultJSON                                                                           = 15263
	ReadProcessedDetails_Encoding_DefaultJSON                                                                             = 15264
	PubSubGroupType_Status                                                                                                = 15265
	PubSubGroupType_Status_State                                                                                          = 15266
	PubSubGroupType_Status_Enable                                                                                         = 15267
	PubSubGroupType_Status_Disable                                                                                        = 15268
	ReadAtTimeDetails_Encoding_DefaultJSON                                                                                = 15269
	HistoryData_Encoding_DefaultJSON                                                                                      = 15270
	ModificationInfo_Encoding_DefaultJSON                                                                                 = 15271
	HistoryModifiedData_Encoding_DefaultJSON                                                                              = 15272
	HistoryEvent_Encoding_DefaultJSON                                                                                     = 15273
	HistoryReadRequest_Encoding_DefaultJSON                                                                               = 15274
	HistoryReadResponse_Encoding_DefaultJSON                                                                              = 15275
	WriteValue_Encoding_DefaultJSON                                                                                       = 15276
	WriteRequest_Encoding_DefaultJSON                                                                                     = 15277
	WriteResponse_Encoding_DefaultJSON                                                                                    = 15278
	HistoryUpdateDetails_Encoding_DefaultJSON                                                                             = 15279
	UpdateDataDetails_Encoding_DefaultJSON                                                                                = 15280
	UpdateStructureDataDetails_Encoding_DefaultJSON                                                                       = 15281
	UpdateEventDetails_Encoding_DefaultJSON                                                                               = 15282
	DeleteRawModifiedDetails_Encoding_DefaultJSON                                                                         = 15283
	DeleteAtTimeDetails_Encoding_DefaultJSON                                                                              = 15284
	DeleteEventDetails_Encoding_DefaultJSON                                                                               = 15285
	HistoryUpdateResult_Encoding_DefaultJSON                                                                              = 15286
	HistoryUpdateRequest_Encoding_DefaultJSON                                                                             = 15287
	HistoryUpdateResponse_Encoding_DefaultJSON                                                                            = 15288
	CallMethodRequest_Encoding_DefaultJSON                                                                                = 15289
	CallMethodResult_Encoding_DefaultJSON                                                                                 = 15290
	CallRequest_Encoding_DefaultJSON                                                                                      = 15291
	CallResponse_Encoding_DefaultJSON                                                                                     = 15292
	MonitoringFilter_Encoding_DefaultJSON                                                                                 = 15293
	DataChangeFilter_Encoding_DefaultJSON                                                                                 = 15294
	EventFilter_Encoding_DefaultJSON                                                                                      = 15295
	HasDataSetWriter                                                                                                      = 15296
	HasDataSetReader                                                                                                      = 15297
	DataSetWriterType                                                                                                     = 15298
	DataSetWriterType_Status                                                                                              = 15299
	DataSetWriterType_Status_State                                                                                        = 15300
	DataSetWriterType_Status_Enable                                                                                       = 15301
	DataSetWriterType_Status_Disable                                                                                      = 15302
	DataSetWriterType_TransportSettings                                                                                   = 15303
	AggregateConfiguration_Encoding_DefaultJSON                                                                           = 15304
	DataSetWriterTransportType                                                                                            = 15305
	DataSetReaderType                                                                                                     = 15306
	DataSetReaderType_Status                                                                                              = 15307
	DataSetReaderType_Status_State                                                                                        = 15308
	DataSetReaderType_Status_Enable                                                                                       = 15309
	DataSetReaderType_Status_Disable                                                                                      = 15310
	DataSetReaderType_TransportSettings                                                                                   = 15311
	AggregateFilter_Encoding_DefaultJSON                                                                                  = 15312
	MonitoringFilterResult_Encoding_DefaultJSON                                                                           = 15313
	EventFilterResult_Encoding_DefaultJSON                                                                                = 15314
	AggregateFilterResult_Encoding_DefaultJSON                                                                            = 15315
	DataSetReaderType_SubscribedDataSet                                                                                   = 15316
	ElseGuardVariableType                                                                                                 = 15317
	BaseAnalogType                                                                                                        = 15318
	DataSetReaderTransportType                                                                                            = 15319
	MonitoringParameters_Encoding_DefaultJSON                                                                             = 15320
	MonitoredItemCreateRequest_Encoding_DefaultJSON                                                                       = 15321
	MonitoredItemCreateResult_Encoding_DefaultJSON                                                                        = 15322
	CreateMonitoredItemsRequest_Encoding_DefaultJSON                                                                      = 15323
	CreateMonitoredItemsResponse_Encoding_DefaultJSON                                                                     = 15324
	MonitoredItemModifyRequest_Encoding_DefaultJSON                                                                       = 15325
	MonitoredItemModifyResult_Encoding_DefaultJSON                                                                        = 15326
	ModifyMonitoredItemsRequest_Encoding_DefaultJSON                                                                      = 15327
	ModifyMonitoredItemsResponse_Encoding_DefaultJSON                                                                     = 15328
	SetMonitoringModeRequest_Encoding_DefaultJSON                                                                         = 15329
	BrokerDataSetWriterTransportType_RequestedDeliveryGuarantee                                                           = 15330
	SetMonitoringModeResponse_Encoding_DefaultJSON                                                                        = 15331
	SetTriggeringRequest_Encoding_DefaultJSON                                                                             = 15332
	SetTriggeringResponse_Encoding_DefaultJSON                                                                            = 15333
	BrokerDataSetReaderTransportType_ResourceURI                                                                          = 15334
	DeleteMonitoredItemsRequest_Encoding_DefaultJSON                                                                      = 15335
	DeleteMonitoredItemsResponse_Encoding_DefaultJSON                                                                     = 15336
	CreateSubscriptionRequest_Encoding_DefaultJSON                                                                        = 15337
	CreateSubscriptionResponse_Encoding_DefaultJSON                                                                       = 15338
	ModifySubscriptionRequest_Encoding_DefaultJSON                                                                        = 15339
	ModifySubscriptionResponse_Encoding_DefaultJSON                                                                       = 15340
	SetPublishingModeRequest_Encoding_DefaultJSON                                                                         = 15341
	SetPublishingModeResponse_Encoding_DefaultJSON                                                                        = 15342
	NotificationMessage_Encoding_DefaultJSON                                                                              = 15343
	NotificationData_Encoding_DefaultJSON                                                                                 = 15344
	DataChangeNotification_Encoding_DefaultJSON                                                                           = 15345
	MonitoredItemNotification_Encoding_DefaultJSON                                                                        = 15346
	EventNotificationList_Encoding_DefaultJSON                                                                            = 15347
	EventFieldList_Encoding_DefaultJSON                                                                                   = 15348
	HistoryEventFieldList_Encoding_DefaultJSON                                                                            = 15349
	StatusChangeNotification_Encoding_DefaultJSON                                                                         = 15350
	SubscriptionAcknowledgement_Encoding_DefaultJSON                                                                      = 15351
	PublishRequest_Encoding_DefaultJSON                                                                                   = 15352
	PublishResponse_Encoding_DefaultJSON                                                                                  = 15353
	RepublishRequest_Encoding_DefaultJSON                                                                                 = 15354
	RepublishResponse_Encoding_DefaultJSON                                                                                = 15355
	TransferResult_Encoding_DefaultJSON                                                                                   = 15356
	TransferSubscriptionsRequest_Encoding_DefaultJSON                                                                     = 15357
	TransferSubscriptionsResponse_Encoding_DefaultJSON                                                                    = 15358
	DeleteSubscriptionsRequest_Encoding_DefaultJSON                                                                       = 15359
	DeleteSubscriptionsResponse_Encoding_DefaultJSON                                                                      = 15360
	BuildInfo_Encoding_DefaultJSON                                                                                        = 15361
	RedundantServerDataType_Encoding_DefaultJSON                                                                          = 15362
	EndpointURLListDataType_Encoding_DefaultJSON                                                                          = 15363
	NetworkGroupDataType_Encoding_DefaultJSON                                                                             = 15364
	SamplingIntervalDiagnosticsDataType_Encoding_DefaultJSON                                                              = 15365
	ServerDiagnosticsSummaryDataType_Encoding_DefaultJSON                                                                 = 15366
	ServerStatusDataType_Encoding_DefaultJSON                                                                             = 15367
	SessionDiagnosticsDataType_Encoding_DefaultJSON                                                                       = 15368
	SessionSecurityDiagnosticsDataType_Encoding_DefaultJSON                                                               = 15369
	ServiceCounterDataType_Encoding_DefaultJSON                                                                           = 15370
	StatusResult_Encoding_DefaultJSON                                                                                     = 15371
	SubscriptionDiagnosticsDataType_Encoding_DefaultJSON                                                                  = 15372
	ModelChangeStructureDataType_Encoding_DefaultJSON                                                                     = 15373
	SemanticChangeStructureDataType_Encoding_DefaultJSON                                                                  = 15374
	Range_Encoding_DefaultJSON                                                                                            = 15375
	EUInformation_Encoding_DefaultJSON                                                                                    = 15376
	ComplexNumberType_Encoding_DefaultJSON                                                                                = 15377
	DoubleComplexNumberType_Encoding_DefaultJSON                                                                          = 15378
	AxisInformation_Encoding_DefaultJSON                                                                                  = 15379
	XVType_Encoding_DefaultJSON                                                                                           = 15380
	ProgramDiagnosticDataType_Encoding_DefaultJSON                                                                        = 15381
	Annotation_Encoding_DefaultJSON                                                                                       = 15382
	ProgramDiagnostic2Type                                                                                                = 15383
	ProgramDiagnostic2Type_CreateSessionID                                                                                = 15384
	ProgramDiagnostic2Type_CreateClientName                                                                               = 15385
	ProgramDiagnostic2Type_InvocationCreationTime                                                                         = 15386
	ProgramDiagnostic2Type_LastTransitionTime                                                                             = 15387
	ProgramDiagnostic2Type_LastMethodCall                                                                                 = 15388
	ProgramDiagnostic2Type_LastMethodSessionID                                                                            = 15389
	ProgramDiagnostic2Type_LastMethodInputArguments                                                                       = 15390
	ProgramDiagnostic2Type_LastMethodOutputArguments                                                                      = 15391
	ProgramDiagnostic2Type_LastMethodInputValues                                                                          = 15392
	ProgramDiagnostic2Type_LastMethodOutputValues                                                                         = 15393
	ProgramDiagnostic2Type_LastMethodCallTime                                                                             = 15394
	ProgramDiagnostic2Type_LastMethodReturnStatus                                                                         = 15395
	ProgramDiagnostic2DataType                                                                                            = 15396
	ProgramDiagnostic2DataType_Encoding_DefaultBinary                                                                     = 15397
	OpcUa_BinarySchema_ProgramDiagnostic2DataType                                                                         = 15398
	OpcUa_BinarySchema_ProgramDiagnostic2DataType_DataTypeVersion                                                         = 15399
	OpcUa_BinarySchema_ProgramDiagnostic2DataType_DictionaryFragment                                                      = 15400
	ProgramDiagnostic2DataType_Encoding_DefaultXML                                                                        = 15401
	OpcUa_XMLSchema_ProgramDiagnostic2DataType                                                                            = 15402
	OpcUa_XMLSchema_ProgramDiagnostic2DataType_DataTypeVersion                                                            = 15403
	OpcUa_XMLSchema_ProgramDiagnostic2DataType_DictionaryFragment                                                         = 15404
	ProgramDiagnostic2DataType_Encoding_DefaultJSON                                                                       = 15405
	AccessLevelExType                                                                                                     = 15406
	AccessLevelExType_OptionSetValues                                                                                     = 15407
	RoleSetType_RoleName_Placeholder_ApplicationsExclude                                                                  = 15408
	RoleSetType_RoleName_Placeholder_EndpointsExclude                                                                     = 15409
	RoleType_ApplicationsExclude                                                                                          = 15410
	RoleType_EndpointsExclude                                                                                             = 15411
	WellKnownRole_Anonymous_ApplicationsExclude                                                                           = 15412
	WellKnownRole_Anonymous_EndpointsExclude                                                                              = 15413
	WellKnownRole_AuthenticatedUser_ApplicationsExclude                                                                   = 15414
	WellKnownRole_AuthenticatedUser_EndpointsExclude                                                                      = 15415
	WellKnownRole_Observer_ApplicationsExclude                                                                            = 15416
	WellKnownRole_Observer_EndpointsExclude                                                                               = 15417
	WellKnownRole_Operator_ApplicationsExclude                                                                            = 15418
	BrokerDataSetReaderTransportType_AuthenticationProfileURI                                                             = 15419
	BrokerDataSetReaderTransportType_RequestedDeliveryGuarantee                                                           = 15420
	SimpleTypeDescription_Encoding_DefaultBinary                                                                          = 15421
	UABinaryFileDataType_Encoding_DefaultBinary                                                                           = 15422
	WellKnownRole_Operator_EndpointsExclude                                                                               = 15423
	WellKnownRole_Engineer_ApplicationsExclude                                                                            = 15424
	WellKnownRole_Engineer_EndpointsExclude                                                                               = 15425
	WellKnownRole_Supervisor_ApplicationsExclude                                                                          = 15426
	WellKnownRole_Supervisor_EndpointsExclude                                                                             = 15427
	WellKnownRole_ConfigureAdmin_ApplicationsExclude                                                                      = 15428
	WellKnownRole_ConfigureAdmin_EndpointsExclude                                                                         = 15429
	WellKnownRole_SecurityAdmin_ApplicationsExclude                                                                       = 15430
	PublishSubscribeType_GetSecurityGroup                                                                                 = 15431
	PublishSubscribeType_GetSecurityGroup_InputArguments                                                                  = 15432
	PublishSubscribeType_GetSecurityGroup_OutputArguments                                                                 = 15433
	PublishSubscribeType_SecurityGroups                                                                                   = 15434
	PublishSubscribeType_SecurityGroups_AddSecurityGroup                                                                  = 15435
	PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments                                                   = 15436
	PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments                                                  = 15437
	PublishSubscribeType_SecurityGroups_RemoveSecurityGroup                                                               = 15438
	PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments                                                = 15439
	PublishSubscribe_GetSecurityGroup                                                                                     = 15440
	PublishSubscribe_GetSecurityGroup_InputArguments                                                                      = 15441
	PublishSubscribe_GetSecurityGroup_OutputArguments                                                                     = 15442
	PublishSubscribe_SecurityGroups                                                                                       = 15443
	PublishSubscribe_SecurityGroups_AddSecurityGroup                                                                      = 15444
	PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments                                                       = 15445
	PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments                                                      = 15446
	PublishSubscribe_SecurityGroups_RemoveSecurityGroup                                                                   = 15447
	PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments                                                    = 15448
	GetSecurityGroupMethodType                                                                                            = 15449
	GetSecurityGroupMethodType_InputArguments                                                                             = 15450
	GetSecurityGroupMethodType_OutputArguments                                                                            = 15451
	SecurityGroupFolderType                                                                                               = 15452
	SecurityGroupFolderType_SecurityGroupFolderName_Placeholder                                                           = 15453
	SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup                                          = 15454
	SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments                           = 15455
	SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments                          = 15456
	SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup                                       = 15457
	SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments                        = 15458
	SecurityGroupFolderType_SecurityGroupName_Placeholder                                                                 = 15459
	SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupID                                                 = 15460
	SecurityGroupFolderType_AddSecurityGroup                                                                              = 15461
	SecurityGroupFolderType_AddSecurityGroup_InputArguments                                                               = 15462
	SecurityGroupFolderType_AddSecurityGroup_OutputArguments                                                              = 15463
	SecurityGroupFolderType_RemoveSecurityGroup                                                                           = 15464
	SecurityGroupFolderType_RemoveSecurityGroup_InputArguments                                                            = 15465
	AddSecurityGroupMethodType                                                                                            = 15466
	AddSecurityGroupMethodType_InputArguments                                                                             = 15467
	AddSecurityGroupMethodType_OutputArguments                                                                            = 15468
	RemoveSecurityGroupMethodType                                                                                         = 15469
	RemoveSecurityGroupMethodType_InputArguments                                                                          = 15470
	SecurityGroupType                                                                                                     = 15471
	SecurityGroupType_SecurityGroupID                                                                                     = 15472
	DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields                                                    = 15473
	DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField                                  = 15474
	DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField_InputArguments                   = 15475
	DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField_OutputArguments                  = 15476
	DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField                               = 15477
	DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField_InputArguments                = 15478
	BrokerConnectionTransportDataType_Encoding_DefaultBinary                                                              = 15479
	WriterGroupDataType                                                                                                   = 15480
	PublishedDataSetType_ExtensionFields                                                                                  = 15481
	PublishedDataSetType_ExtensionFields_AddExtensionField                                                                = 15482
	PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments                                                 = 15483
	PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments                                                = 15484
	PublishedDataSetType_ExtensionFields_RemoveExtensionField                                                             = 15485
	PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments                                              = 15486
	StructureDescription                                                                                                  = 15487
	EnumDescription                                                                                                       = 15488
	ExtensionFieldsType                                                                                                   = 15489
	ExtensionFieldsType_ExtensionFieldName_Placeholder                                                                    = 15490
	ExtensionFieldsType_AddExtensionField                                                                                 = 15491
	ExtensionFieldsType_AddExtensionField_InputArguments                                                                  = 15492
	ExtensionFieldsType_AddExtensionField_OutputArguments                                                                 = 15493
	ExtensionFieldsType_RemoveExtensionField                                                                              = 15494
	ExtensionFieldsType_RemoveExtensionField_InputArguments                                                               = 15495
	AddExtensionFieldMethodType                                                                                           = 15496
	AddExtensionFieldMethodType_InputArguments                                                                            = 15497
	AddExtensionFieldMethodType_OutputArguments                                                                           = 15498
	RemoveExtensionFieldMethodType                                                                                        = 15499
	RemoveExtensionFieldMethodType_InputArguments                                                                         = 15500
	OpcUa_BinarySchema_SimpleTypeDescription                                                                              = 15501
	NetworkAddressDataType                                                                                                = 15502
	PublishedDataItemsType_ExtensionFields                                                                                = 15503
	PublishedDataItemsType_ExtensionFields_AddExtensionField                                                              = 15504
	PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments                                               = 15505
	PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments                                              = 15506
	PublishedDataItemsType_ExtensionFields_RemoveExtensionField                                                           = 15507
	PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments                                            = 15508
	OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion                                                              = 15509
	NetworkAddressURLDataType                                                                                             = 15510
	PublishedEventsType_ExtensionFields                                                                                   = 15511
	PublishedEventsType_ExtensionFields_AddExtensionField                                                                 = 15512
	PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments                                                  = 15513
	PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments                                                 = 15514
	PublishedEventsType_ExtensionFields_RemoveExtensionField                                                              = 15515
	PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments                                               = 15516
	PublishedEventsType_ModifyFieldSelection_OutputArguments                                                              = 15517
	PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments                                                     = 15518
	OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment                                                           = 15519
	ReaderGroupDataType                                                                                                   = 15520
	OpcUa_BinarySchema_UABinaryFileDataType                                                                               = 15521
	OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion                                                               = 15522
	OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment                                                            = 15523
	OpcUa_BinarySchema_BrokerConnectionTransportDataType                                                                  = 15524
	OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion                                                  = 15525
	OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment                                               = 15526
	WellKnownRole_SecurityAdmin_EndpointsExclude                                                                          = 15527
	EndpointType                                                                                                          = 15528
	SimpleTypeDescription_Encoding_DefaultXML                                                                             = 15529
	PubSubConfigurationDataType                                                                                           = 15530
	UABinaryFileDataType_Encoding_DefaultXML                                                                              = 15531
	DatagramWriterGroupTransportDataType                                                                                  = 15532
	PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface                                              = 15533
	DataTypeSchemaHeader                                                                                                  = 15534
	PubSubStatusEventType                                                                                                 = 15535
	PubSubStatusEventType_EventID                                                                                         = 15536
	PubSubStatusEventType_EventType                                                                                       = 15537
	PubSubStatusEventType_SourceNode                                                                                      = 15538
	PubSubStatusEventType_SourceName                                                                                      = 15539
	PubSubStatusEventType_Time                                                                                            = 15540
	PubSubStatusEventType_ReceiveTime                                                                                     = 15541
	PubSubStatusEventType_LocalTime                                                                                       = 15542
	PubSubStatusEventType_Message                                                                                         = 15543
	PubSubStatusEventType_Severity                                                                                        = 15544
	PubSubStatusEventType_ConnectionID                                                                                    = 15545
	PubSubStatusEventType_GroupID                                                                                         = 15546
	PubSubStatusEventType_State                                                                                           = 15547
	PubSubTransportLimitsExceedEventType                                                                                  = 15548
	PubSubTransportLimitsExceedEventType_EventID                                                                          = 15549
	PubSubTransportLimitsExceedEventType_EventType                                                                        = 15550
	PubSubTransportLimitsExceedEventType_SourceNode                                                                       = 15551
	PubSubTransportLimitsExceedEventType_SourceName                                                                       = 15552
	PubSubTransportLimitsExceedEventType_Time                                                                             = 15553
	PubSubTransportLimitsExceedEventType_ReceiveTime                                                                      = 15554
	PubSubTransportLimitsExceedEventType_LocalTime                                                                        = 15555
	PubSubTransportLimitsExceedEventType_Message                                                                          = 15556
	PubSubTransportLimitsExceedEventType_Severity                                                                         = 15557
	PubSubTransportLimitsExceedEventType_ConnectionID                                                                     = 15558
	PubSubTransportLimitsExceedEventType_GroupID                                                                          = 15559
	PubSubTransportLimitsExceedEventType_State                                                                            = 15560
	PubSubTransportLimitsExceedEventType_Actual                                                                           = 15561
	PubSubTransportLimitsExceedEventType_Maximum                                                                          = 15562
	PubSubCommunicationFailureEventType                                                                                   = 15563
	PubSubCommunicationFailureEventType_EventID                                                                           = 15564
	PubSubCommunicationFailureEventType_EventType                                                                         = 15565
	PubSubCommunicationFailureEventType_SourceNode                                                                        = 15566
	PubSubCommunicationFailureEventType_SourceName                                                                        = 15567
	PubSubCommunicationFailureEventType_Time                                                                              = 15568
	PubSubCommunicationFailureEventType_ReceiveTime                                                                       = 15569
	PubSubCommunicationFailureEventType_LocalTime                                                                         = 15570
	PubSubCommunicationFailureEventType_Message                                                                           = 15571
	PubSubCommunicationFailureEventType_Severity                                                                          = 15572
	PubSubCommunicationFailureEventType_ConnectionID                                                                      = 15573
	PubSubCommunicationFailureEventType_GroupID                                                                           = 15574
	PubSubCommunicationFailureEventType_State                                                                             = 15575
	PubSubCommunicationFailureEventType_Error                                                                             = 15576
	DataSetFieldFlags_OptionSetValues                                                                                     = 15577
	PublishedDataSetDataType                                                                                              = 15578
	BrokerConnectionTransportDataType_Encoding_DefaultXML                                                                 = 15579
	PublishedDataSetSourceDataType                                                                                        = 15580
	PublishedDataItemsDataType                                                                                            = 15581
	PublishedEventsDataType                                                                                               = 15582
	DataSetFieldContentMask                                                                                               = 15583
	DataSetFieldContentMask_OptionSetValues                                                                               = 15584
	OpcUa_XMLSchema_SimpleTypeDescription                                                                                 = 15585
	OpcUa_XMLSchema_SimpleTypeDescription_DataTypeVersion                                                                 = 15586
	OpcUa_XMLSchema_SimpleTypeDescription_DictionaryFragment                                                              = 15587
	OpcUa_XMLSchema_UABinaryFileDataType                                                                                  = 15588
	StructureDescription_Encoding_DefaultXML                                                                              = 15589
	EnumDescription_Encoding_DefaultXML                                                                                   = 15590
	OpcUa_XMLSchema_StructureDescription                                                                                  = 15591
	OpcUa_XMLSchema_StructureDescription_DataTypeVersion                                                                  = 15592
	OpcUa_XMLSchema_StructureDescription_DictionaryFragment                                                               = 15593
	OpcUa_XMLSchema_EnumDescription                                                                                       = 15594
	OpcUa_XMLSchema_EnumDescription_DataTypeVersion                                                                       = 15595
	OpcUa_XMLSchema_EnumDescription_DictionaryFragment                                                                    = 15596
	DataSetWriterDataType                                                                                                 = 15597
	DataSetWriterTransportDataType                                                                                        = 15598
	OpcUa_BinarySchema_StructureDescription                                                                               = 15599
	OpcUa_BinarySchema_StructureDescription_DataTypeVersion                                                               = 15600
	OpcUa_BinarySchema_StructureDescription_DictionaryFragment                                                            = 15601
	OpcUa_BinarySchema_EnumDescription                                                                                    = 15602
	OpcUa_BinarySchema_EnumDescription_DataTypeVersion                                                                    = 15603
	OpcUa_BinarySchema_EnumDescription_DictionaryFragment                                                                 = 15604
	DataSetWriterMessageDataType                                                                                          = 15605
	Server_ServerCapabilities_RoleSet                                                                                     = 15606
	RoleSetType                                                                                                           = 15607
	RoleSetType_RoleName_Placeholder                                                                                      = 15608
	PubSubGroupDataType                                                                                                   = 15609
	OpcUa_XMLSchema_UABinaryFileDataType_DataTypeVersion                                                                  = 15610
	WriterGroupTransportDataType                                                                                          = 15611
	RoleSetType_RoleName_Placeholder_AddIdentity                                                                          = 15612
	RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments                                                           = 15613
	RoleSetType_RoleName_Placeholder_RemoveIdentity                                                                       = 15614
	RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments                                                        = 15615
	WriterGroupMessageDataType                                                                                            = 15616
	PubSubConnectionDataType                                                                                              = 15617
	ConnectionTransportDataType                                                                                           = 15618
	OpcUa_XMLSchema_UABinaryFileDataType_DictionaryFragment                                                               = 15619
	RoleType                                                                                                              = 15620
	ReaderGroupTransportDataType                                                                                          = 15621
	ReaderGroupMessageDataType                                                                                            = 15622
	DataSetReaderDataType                                                                                                 = 15623
	RoleType_AddIdentity                                                                                                  = 15624
	RoleType_AddIdentity_InputArguments                                                                                   = 15625
	RoleType_RemoveIdentity                                                                                               = 15626
	RoleType_RemoveIdentity_InputArguments                                                                                = 15627
	DataSetReaderTransportDataType                                                                                        = 15628
	DataSetReaderMessageDataType                                                                                          = 15629
	SubscribedDataSetDataType                                                                                             = 15630
	TargetVariablesDataType                                                                                               = 15631
	IdentityCriteriaType                                                                                                  = 15632
	IdentityCriteriaType_EnumValues                                                                                       = 15633
	IdentityMappingRuleType                                                                                               = 15634
	SubscribedDataSetMirrorDataType                                                                                       = 15635
	AddIdentityMethodType                                                                                                 = 15636
	AddIdentityMethodType_InputArguments                                                                                  = 15637
	RemoveIdentityMethodType                                                                                              = 15638
	RemoveIdentityMethodType_InputArguments                                                                               = 15639
	OpcUa_XMLSchema_BrokerConnectionTransportDataType                                                                     = 15640
	DataSetOrderingType_EnumStrings                                                                                       = 15641
	UADPNetworkMessageContentMask                                                                                         = 15642
	UADPNetworkMessageContentMask_OptionSetValues                                                                         = 15643
	WellKnownRole_Anonymous                                                                                               = 15644
	UADPWriterGroupMessageDataType                                                                                        = 15645
	UADPDataSetMessageContentMask                                                                                         = 15646
	UADPDataSetMessageContentMask_OptionSetValues                                                                         = 15647
	WellKnownRole_Anonymous_AddIdentity                                                                                   = 15648
	WellKnownRole_Anonymous_AddIdentity_InputArguments                                                                    = 15649
	WellKnownRole_Anonymous_RemoveIdentity                                                                                = 15650
	WellKnownRole_Anonymous_RemoveIdentity_InputArguments                                                                 = 15651
	UADPDataSetWriterMessageDataType                                                                                      = 15652
	UADPDataSetReaderMessageDataType                                                                                      = 15653
	JSONNetworkMessageContentMask                                                                                         = 15654
	JSONNetworkMessageContentMask_OptionSetValues                                                                         = 15655
	WellKnownRole_AuthenticatedUser                                                                                       = 15656
	JSONWriterGroupMessageDataType                                                                                        = 15657
	JSONDataSetMessageContentMask                                                                                         = 15658
	JSONDataSetMessageContentMask_OptionSetValues                                                                         = 15659
	WellKnownRole_AuthenticatedUser_AddIdentity                                                                           = 15660
	WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments                                                            = 15661
	WellKnownRole_AuthenticatedUser_RemoveIdentity                                                                        = 15662
	WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments                                                         = 15663
	JSONDataSetWriterMessageDataType                                                                                      = 15664
	JSONDataSetReaderMessageDataType                                                                                      = 15665
	OpcUa_XMLSchema_BrokerConnectionTransportDataType_DataTypeVersion                                                     = 15666
	BrokerWriterGroupTransportDataType                                                                                    = 15667
	WellKnownRole_Observer                                                                                                = 15668
	BrokerDataSetWriterTransportDataType                                                                                  = 15669
	BrokerDataSetReaderTransportDataType                                                                                  = 15670
	EndpointType_Encoding_DefaultBinary                                                                                   = 15671
	WellKnownRole_Observer_AddIdentity                                                                                    = 15672
	WellKnownRole_Observer_AddIdentity_InputArguments                                                                     = 15673
	WellKnownRole_Observer_RemoveIdentity                                                                                 = 15674
	WellKnownRole_Observer_RemoveIdentity_InputArguments                                                                  = 15675
	DataTypeSchemaHeader_Encoding_DefaultBinary                                                                           = 15676
	PublishedDataSetDataType_Encoding_DefaultBinary                                                                       = 15677
	PublishedDataSetSourceDataType_Encoding_DefaultBinary                                                                 = 15678
	PublishedDataItemsDataType_Encoding_DefaultBinary                                                                     = 15679
	WellKnownRole_Operator                                                                                                = 15680
	PublishedEventsDataType_Encoding_DefaultBinary                                                                        = 15681
	DataSetWriterDataType_Encoding_DefaultBinary                                                                          = 15682
	DataSetWriterTransportDataType_Encoding_DefaultBinary                                                                 = 15683
	WellKnownRole_Operator_AddIdentity                                                                                    = 15684
	WellKnownRole_Operator_AddIdentity_InputArguments                                                                     = 15685
	WellKnownRole_Operator_RemoveIdentity                                                                                 = 15686
	WellKnownRole_Operator_RemoveIdentity_InputArguments                                                                  = 15687
	DataSetWriterMessageDataType_Encoding_DefaultBinary                                                                   = 15688
	PubSubGroupDataType_Encoding_DefaultBinary                                                                            = 15689
	OpcUa_XMLSchema_BrokerConnectionTransportDataType_DictionaryFragment                                                  = 15690
	WriterGroupTransportDataType_Encoding_DefaultBinary                                                                   = 15691
	WellKnownRole_Supervisor                                                                                              = 15692
	WriterGroupMessageDataType_Encoding_DefaultBinary                                                                     = 15693
	PubSubConnectionDataType_Encoding_DefaultBinary                                                                       = 15694
	ConnectionTransportDataType_Encoding_DefaultBinary                                                                    = 15695
	WellKnownRole_Supervisor_AddIdentity                                                                                  = 15696
	WellKnownRole_Supervisor_AddIdentity_InputArguments                                                                   = 15697
	WellKnownRole_Supervisor_RemoveIdentity                                                                               = 15698
	WellKnownRole_Supervisor_RemoveIdentity_InputArguments                                                                = 15699
	SimpleTypeDescription_Encoding_DefaultJSON                                                                            = 15700
	ReaderGroupTransportDataType_Encoding_DefaultBinary                                                                   = 15701
	ReaderGroupMessageDataType_Encoding_DefaultBinary                                                                     = 15702
	DataSetReaderDataType_Encoding_DefaultBinary                                                                          = 15703
	WellKnownRole_SecurityAdmin                                                                                           = 15704
	DataSetReaderTransportDataType_Encoding_DefaultBinary                                                                 = 15705
	DataSetReaderMessageDataType_Encoding_DefaultBinary                                                                   = 15706
	SubscribedDataSetDataType_Encoding_DefaultBinary                                                                      = 15707
	WellKnownRole_SecurityAdmin_AddIdentity                                                                               = 15708
	WellKnownRole_SecurityAdmin_AddIdentity_InputArguments                                                                = 15709
	WellKnownRole_SecurityAdmin_RemoveIdentity                                                                            = 15710
	WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments                                                             = 15711
	TargetVariablesDataType_Encoding_DefaultBinary                                                                        = 15712
	SubscribedDataSetMirrorDataType_Encoding_DefaultBinary                                                                = 15713
	UABinaryFileDataType_Encoding_DefaultJSON                                                                             = 15714
	UADPWriterGroupMessageDataType_Encoding_DefaultBinary                                                                 = 15715
	WellKnownRole_ConfigureAdmin                                                                                          = 15716
	UADPDataSetWriterMessageDataType_Encoding_DefaultBinary                                                               = 15717
	UADPDataSetReaderMessageDataType_Encoding_DefaultBinary                                                               = 15718
	JSONWriterGroupMessageDataType_Encoding_DefaultBinary                                                                 = 15719
	WellKnownRole_ConfigureAdmin_AddIdentity                                                                              = 15720
	WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments                                                               = 15721
	WellKnownRole_ConfigureAdmin_RemoveIdentity                                                                           = 15722
	WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments                                                            = 15723
	JSONDataSetWriterMessageDataType_Encoding_DefaultBinary                                                               = 15724
	JSONDataSetReaderMessageDataType_Encoding_DefaultBinary                                                               = 15725
	BrokerConnectionTransportDataType_Encoding_DefaultJSON                                                                = 15726
	BrokerWriterGroupTransportDataType_Encoding_DefaultBinary                                                             = 15727
	IdentityMappingRuleType_Encoding_DefaultXML                                                                           = 15728
	BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary                                                           = 15729
	OpcUa_XMLSchema_IdentityMappingRuleType                                                                               = 15730
	OpcUa_XMLSchema_IdentityMappingRuleType_DataTypeVersion                                                               = 15731
	OpcUa_XMLSchema_IdentityMappingRuleType_DictionaryFragment                                                            = 15732
	BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary                                                           = 15733
	OpcUa_BinarySchema_EndpointType                                                                                       = 15734
	OpcUa_BinarySchema_EndpointType_DataTypeVersion                                                                       = 15735
	IdentityMappingRuleType_Encoding_DefaultBinary                                                                        = 15736
	OpcUa_BinarySchema_EndpointType_DictionaryFragment                                                                    = 15737
	OpcUa_BinarySchema_IdentityMappingRuleType                                                                            = 15738
	OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion                                                            = 15739
	OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment                                                         = 15740
	OpcUa_BinarySchema_DataTypeSchemaHeader                                                                               = 15741
	OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion                                                               = 15742
	OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment                                                            = 15743
	TemporaryFileTransferType                                                                                             = 15744
	TemporaryFileTransferType_ClientProcessingTimeout                                                                     = 15745
	TemporaryFileTransferType_GenerateFileForRead                                                                         = 15746
	TemporaryFileTransferType_GenerateFileForRead_InputArguments                                                          = 15747
	TemporaryFileTransferType_GenerateFileForRead_OutputArguments                                                         = 15748
	TemporaryFileTransferType_GenerateFileForWrite                                                                        = 15749
	TemporaryFileTransferType_GenerateFileForWrite_OutputArguments                                                        = 15750
	TemporaryFileTransferType_CloseAndCommit                                                                              = 15751
	TemporaryFileTransferType_CloseAndCommit_InputArguments                                                               = 15752
	TemporaryFileTransferType_CloseAndCommit_OutputArguments                                                              = 15753
	TemporaryFileTransferType_TransferState_Placeholder                                                                   = 15754
	TemporaryFileTransferType_TransferState_Placeholder_CurrentState                                                      = 15755
	TemporaryFileTransferType_TransferState_Placeholder_CurrentState_ID                                                   = 15756
	TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Name                                                 = 15757
	TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Number                                               = 15758
	TemporaryFileTransferType_TransferState_Placeholder_CurrentState_EffectiveDisplayName                                 = 15759
	TemporaryFileTransferType_TransferState_Placeholder_LastTransition                                                    = 15760
	TemporaryFileTransferType_TransferState_Placeholder_LastTransition_ID                                                 = 15761
	TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Name                                               = 15762
	TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Number                                             = 15763
	TemporaryFileTransferType_TransferState_Placeholder_LastTransition_TransitionTime                                     = 15764
	TemporaryFileTransferType_TransferState_Placeholder_LastTransition_EffectiveTransitionTime                            = 15765
	OpcUa_BinarySchema_PublishedDataSetDataType                                                                           = 15766
	OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion                                                           = 15767
	OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment                                                        = 15768
	OpcUa_BinarySchema_PublishedDataSetSourceDataType                                                                     = 15769
	OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion                                                     = 15770
	OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment                                                  = 15771
	OpcUa_BinarySchema_PublishedDataItemsDataType                                                                         = 15772
	OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion                                                         = 15773
	OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment                                                      = 15774
	OpcUa_BinarySchema_PublishedEventsDataType                                                                            = 15775
	OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion                                                            = 15776
	OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment                                                         = 15777
	OpcUa_BinarySchema_DataSetWriterDataType                                                                              = 15778
	OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion                                                              = 15779
	OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment                                                           = 15780
	OpcUa_BinarySchema_DataSetWriterTransportDataType                                                                     = 15781
	OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion                                                     = 15782
	OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment                                                  = 15783
	OpcUa_BinarySchema_DataSetWriterMessageDataType                                                                       = 15784
	OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion                                                       = 15785
	OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment                                                    = 15786
	OpcUa_BinarySchema_PubSubGroupDataType                                                                                = 15787
	OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion                                                                = 15788
	OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment                                                             = 15789
	PublishSubscribe_ConnectionName_Placeholder                                                                           = 15790
	PublishSubscribe_ConnectionName_Placeholder_PublisherID                                                               = 15791
	PublishSubscribe_ConnectionName_Placeholder_TransportProfileURI                                                       = 15792
	OpcUa_BinarySchema_WriterGroupTransportDataType                                                                       = 15793
	TemporaryFileTransferType_TransferState_Placeholder_Reset                                                             = 15794
	GenerateFileForReadMethodType                                                                                         = 15795
	GenerateFileForReadMethodType_InputArguments                                                                          = 15796
	GenerateFileForReadMethodType_OutputArguments                                                                         = 15797
	GenerateFileForWriteMethodType                                                                                        = 15798
	GenerateFileForWriteMethodType_OutputArguments                                                                        = 15799
	CloseAndCommitMethodType                                                                                              = 15800
	CloseAndCommitMethodType_InputArguments                                                                               = 15801
	CloseAndCommitMethodType_OutputArguments                                                                              = 15802
	FileTransferStateMachineType                                                                                          = 15803
	FileTransferStateMachineType_CurrentState                                                                             = 15804
	FileTransferStateMachineType_CurrentState_ID                                                                          = 15805
	FileTransferStateMachineType_CurrentState_Name                                                                        = 15806
	FileTransferStateMachineType_CurrentState_Number                                                                      = 15807
	FileTransferStateMachineType_CurrentState_EffectiveDisplayName                                                        = 15808
	FileTransferStateMachineType_LastTransition                                                                           = 15809
	FileTransferStateMachineType_LastTransition_ID                                                                        = 15810
	FileTransferStateMachineType_LastTransition_Name                                                                      = 15811
	FileTransferStateMachineType_LastTransition_Number                                                                    = 15812
	FileTransferStateMachineType_LastTransition_TransitionTime                                                            = 15813
	FileTransferStateMachineType_LastTransition_EffectiveTransitionTime                                                   = 15814
	FileTransferStateMachineType_IDle                                                                                     = 15815
	FileTransferStateMachineType_IDle_StateNumber                                                                         = 15816
	FileTransferStateMachineType_ReadPrepare                                                                              = 15817
	FileTransferStateMachineType_ReadPrepare_StateNumber                                                                  = 15818
	FileTransferStateMachineType_ReadTransfer                                                                             = 15819
	FileTransferStateMachineType_ReadTransfer_StateNumber                                                                 = 15820
	FileTransferStateMachineType_ApplyWrite                                                                               = 15821
	FileTransferStateMachineType_ApplyWrite_StateNumber                                                                   = 15822
	FileTransferStateMachineType_Error                                                                                    = 15823
	FileTransferStateMachineType_Error_StateNumber                                                                        = 15824
	FileTransferStateMachineType_IDleToReadPrepare                                                                        = 15825
	FileTransferStateMachineType_IDleToReadPrepare_TransitionNumber                                                       = 15826
	FileTransferStateMachineType_ReadPrepareToReadTransfer                                                                = 15827
	FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber                                               = 15828
	FileTransferStateMachineType_ReadTransferToIDle                                                                       = 15829
	FileTransferStateMachineType_ReadTransferToIDle_TransitionNumber                                                      = 15830
	FileTransferStateMachineType_IDleToApplyWrite                                                                         = 15831
	FileTransferStateMachineType_IDleToApplyWrite_TransitionNumber                                                        = 15832
	FileTransferStateMachineType_ApplyWriteToIDle                                                                         = 15833
	FileTransferStateMachineType_ApplyWriteToIDle_TransitionNumber                                                        = 15834
	FileTransferStateMachineType_ReadPrepareToError                                                                       = 15835
	FileTransferStateMachineType_ReadPrepareToError_TransitionNumber                                                      = 15836
	FileTransferStateMachineType_ReadTransferToError                                                                      = 15837
	FileTransferStateMachineType_ReadTransferToError_TransitionNumber                                                     = 15838
	FileTransferStateMachineType_ApplyWriteToError                                                                        = 15839
	FileTransferStateMachineType_ApplyWriteToError_TransitionNumber                                                       = 15840
	FileTransferStateMachineType_ErrorToIDle                                                                              = 15841
	FileTransferStateMachineType_ErrorToIDle_TransitionNumber                                                             = 15842
	FileTransferStateMachineType_Reset                                                                                    = 15843
	PublishSubscribeType_Status                                                                                           = 15844
	PublishSubscribeType_Status_State                                                                                     = 15845
	PublishSubscribeType_Status_Enable                                                                                    = 15846
	PublishSubscribeType_Status_Disable                                                                                   = 15847
	PublishSubscribe_ConnectionName_Placeholder_TransportProfileURI_Selections                                            = 15848
	PublishSubscribe_ConnectionName_Placeholder_TransportProfileURI_SelectionDescriptions                                 = 15849
	PublishSubscribe_ConnectionName_Placeholder_TransportProfileURI_RestrictToList                                        = 15850
	PublishSubscribe_ConnectionName_Placeholder_Address                                                                   = 15851
	OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion                                                       = 15852
	OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment                                                    = 15853
	OpcUa_BinarySchema_WriterGroupMessageDataType                                                                         = 15854
	OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion                                                         = 15855
	OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment                                                      = 15856
	OpcUa_BinarySchema_PubSubConnectionDataType                                                                           = 15857
	OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion                                                           = 15858
	OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment                                                        = 15859
	OpcUa_BinarySchema_ConnectionTransportDataType                                                                        = 15860
	OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion                                                        = 15861
	OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment                                                     = 15862
	PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface                                                  = 15863
	PublishSubscribe_ConnectionName_Placeholder_TransportSettings                                                         = 15864
	PublishSubscribe_ConnectionName_Placeholder_Status                                                                    = 15865
	OpcUa_BinarySchema_ReaderGroupTransportDataType                                                                       = 15866
	OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion                                                       = 15867
	OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment                                                    = 15868
	OpcUa_BinarySchema_ReaderGroupMessageDataType                                                                         = 15869
	OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion                                                         = 15870
	OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment                                                      = 15871
	OpcUa_BinarySchema_DataSetReaderDataType                                                                              = 15872
	OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion                                                              = 15873
	OverrideValueHandling                                                                                                 = 15874
	OverrideValueHandling_EnumStrings                                                                                     = 15875
	OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment                                                           = 15876
	OpcUa_BinarySchema_DataSetReaderTransportDataType                                                                     = 15877
	OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion                                                     = 15878
	OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment                                                  = 15879
	OpcUa_BinarySchema_DataSetReaderMessageDataType                                                                       = 15880
	OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion                                                       = 15881
	OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment                                                    = 15882
	OpcUa_BinarySchema_SubscribedDataSetDataType                                                                          = 15883
	OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion                                                          = 15884
	OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment                                                       = 15885
	OpcUa_BinarySchema_TargetVariablesDataType                                                                            = 15886
	OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion                                                            = 15887
	OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment                                                         = 15888
	OpcUa_BinarySchema_SubscribedDataSetMirrorDataType                                                                    = 15889
	OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion                                                    = 15890
	OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment                                                 = 15891
	PublishSubscribe_ConnectionName_Placeholder_Status_State                                                              = 15892
	PublishSubscribe_ConnectionName_Placeholder_Status_Enable                                                             = 15893
	PublishSubscribe_ConnectionName_Placeholder_Status_Disable                                                            = 15894
	OpcUa_BinarySchema_UADPWriterGroupMessageDataType                                                                     = 15895
	OpcUa_BinarySchema_UADPWriterGroupMessageDataType_DataTypeVersion                                                     = 15896
	OpcUa_BinarySchema_UADPWriterGroupMessageDataType_DictionaryFragment                                                  = 15897
	OpcUa_BinarySchema_UADPDataSetWriterMessageDataType                                                                   = 15898
	OpcUa_BinarySchema_UADPDataSetWriterMessageDataType_DataTypeVersion                                                   = 15899
	OpcUa_BinarySchema_UADPDataSetWriterMessageDataType_DictionaryFragment                                                = 15900
	SessionlessInvokeRequestType                                                                                          = 15901
	SessionlessInvokeRequestType_Encoding_DefaultXML                                                                      = 15902
	SessionlessInvokeRequestType_Encoding_DefaultBinary                                                                   = 15903
	DataSetFieldFlags                                                                                                     = 15904
	PublishSubscribeType_ConnectionName_Placeholder_TransportSettings                                                     = 15905
	PubSubKeyServiceType                                                                                                  = 15906
	PubSubKeyServiceType_GetSecurityKeys                                                                                  = 15907
	PubSubKeyServiceType_GetSecurityKeys_InputArguments                                                                   = 15908
	PubSubKeyServiceType_GetSecurityKeys_OutputArguments                                                                  = 15909
	PubSubKeyServiceType_GetSecurityGroup                                                                                 = 15910
	PubSubKeyServiceType_GetSecurityGroup_InputArguments                                                                  = 15911
	PubSubKeyServiceType_GetSecurityGroup_OutputArguments                                                                 = 15912
	PubSubKeyServiceType_SecurityGroups                                                                                   = 15913
	PubSubKeyServiceType_SecurityGroups_AddSecurityGroup                                                                  = 15914
	PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments                                                   = 15915
	PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments                                                  = 15916
	PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup                                                               = 15917
	PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments                                                = 15918
	OpcUa_BinarySchema_UADPDataSetReaderMessageDataType                                                                   = 15919
	OpcUa_BinarySchema_UADPDataSetReaderMessageDataType_DataTypeVersion                                                   = 15920
	OpcUa_BinarySchema_UADPDataSetReaderMessageDataType_DictionaryFragment                                                = 15921
	OpcUa_BinarySchema_JSONWriterGroupMessageDataType                                                                     = 15922
	OpcUa_BinarySchema_JSONWriterGroupMessageDataType_DataTypeVersion                                                     = 15923
	OpcUa_BinarySchema_JSONWriterGroupMessageDataType_DictionaryFragment                                                  = 15924
	OpcUa_BinarySchema_JSONDataSetWriterMessageDataType                                                                   = 15925
	PubSubGroupType_SecurityMode                                                                                          = 15926
	PubSubGroupType_SecurityGroupID                                                                                       = 15927
	PubSubGroupType_SecurityKeyServices                                                                                   = 15928
	OpcUa_BinarySchema_JSONDataSetWriterMessageDataType_DataTypeVersion                                                   = 15929
	OpcUa_BinarySchema_JSONDataSetWriterMessageDataType_DictionaryFragment                                                = 15930
	OpcUa_BinarySchema_JSONDataSetReaderMessageDataType                                                                   = 15931
	DataSetReaderType_SecurityMode                                                                                        = 15932
	DataSetReaderType_SecurityGroupID                                                                                     = 15933
	DataSetReaderType_SecurityKeyServices                                                                                 = 15934
	OpcUa_BinarySchema_JSONDataSetReaderMessageDataType_DataTypeVersion                                                   = 15935
	OpcUa_BinarySchema_JSONDataSetReaderMessageDataType_DictionaryFragment                                                = 15936
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics                                                               = 15937
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel                                              = 15938
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation                                              = 15939
	OpcUa_BinarySchema_BrokerWriterGroupTransportDataType                                                                 = 15940
	OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion                                                 = 15941
	OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment                                              = 15942
	OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType                                                               = 15943
	OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion                                               = 15944
	OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment                                            = 15945
	OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType                                                               = 15946
	OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion                                               = 15947
	OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment                                            = 15948
	EndpointType_Encoding_DefaultXML                                                                                      = 15949
	DataTypeSchemaHeader_Encoding_DefaultXML                                                                              = 15950
	PublishedDataSetDataType_Encoding_DefaultXML                                                                          = 15951
	PublishedDataSetSourceDataType_Encoding_DefaultXML                                                                    = 15952
	PublishedDataItemsDataType_Encoding_DefaultXML                                                                        = 15953
	PublishedEventsDataType_Encoding_DefaultXML                                                                           = 15954
	DataSetWriterDataType_Encoding_DefaultXML                                                                             = 15955
	DataSetWriterTransportDataType_Encoding_DefaultXML                                                                    = 15956
	OPCUANamespaceMetadata                                                                                                = 15957
	OPCUANamespaceMetadata_NamespaceURI                                                                                   = 15958
	OPCUANamespaceMetadata_NamespaceVersion                                                                               = 15959
	OPCUANamespaceMetadata_NamespacePublicationDate                                                                       = 15960
	OPCUANamespaceMetadata_IsNamespaceSubset                                                                              = 15961
	OPCUANamespaceMetadata_StaticNodeIDTypes                                                                              = 15962
	OPCUANamespaceMetadata_StaticNumericNodeIDRange                                                                       = 15963
	OPCUANamespaceMetadata_StaticStringNodeIDPattern                                                                      = 15964
	OPCUANamespaceMetadata_NamespaceFile                                                                                  = 15965
	OPCUANamespaceMetadata_NamespaceFile_Size                                                                             = 15966
	OPCUANamespaceMetadata_NamespaceFile_Writable                                                                         = 15967
	OPCUANamespaceMetadata_NamespaceFile_UserWritable                                                                     = 15968
	OPCUANamespaceMetadata_NamespaceFile_OpenCount                                                                        = 15969
	OPCUANamespaceMetadata_NamespaceFile_MimeType                                                                         = 15970
	OPCUANamespaceMetadata_NamespaceFile_Open                                                                             = 15971
	OPCUANamespaceMetadata_NamespaceFile_Open_InputArguments                                                              = 15972
	OPCUANamespaceMetadata_NamespaceFile_Open_OutputArguments                                                             = 15973
	OPCUANamespaceMetadata_NamespaceFile_Close                                                                            = 15974
	OPCUANamespaceMetadata_NamespaceFile_Close_InputArguments                                                             = 15975
	OPCUANamespaceMetadata_NamespaceFile_Read                                                                             = 15976
	OPCUANamespaceMetadata_NamespaceFile_Read_InputArguments                                                              = 15977
	OPCUANamespaceMetadata_NamespaceFile_Read_OutputArguments                                                             = 15978
	OPCUANamespaceMetadata_NamespaceFile_Write                                                                            = 15979
	OPCUANamespaceMetadata_NamespaceFile_Write_InputArguments                                                             = 15980
	OPCUANamespaceMetadata_NamespaceFile_GetPosition                                                                      = 15981
	OPCUANamespaceMetadata_NamespaceFile_GetPosition_InputArguments                                                       = 15982
	OPCUANamespaceMetadata_NamespaceFile_GetPosition_OutputArguments                                                      = 15983
	OPCUANamespaceMetadata_NamespaceFile_SetPosition                                                                      = 15984
	OPCUANamespaceMetadata_NamespaceFile_SetPosition_InputArguments                                                       = 15985
	OPCUANamespaceMetadata_NamespaceFile_ExportNamespace                                                                  = 15986
	DataSetWriterMessageDataType_Encoding_DefaultXML                                                                      = 15987
	PubSubGroupDataType_Encoding_DefaultXML                                                                               = 15988
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active                                       = 15989
	WriterGroupTransportDataType_Encoding_DefaultXML                                                                      = 15990
	WriterGroupMessageDataType_Encoding_DefaultXML                                                                        = 15991
	PubSubConnectionDataType_Encoding_DefaultXML                                                                          = 15992
	ConnectionTransportDataType_Encoding_DefaultXML                                                                       = 15993
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification                               = 15994
	ReaderGroupTransportDataType_Encoding_DefaultXML                                                                      = 15995
	ReaderGroupMessageDataType_Encoding_DefaultXML                                                                        = 15996
	RoleSetType_AddRole                                                                                                   = 15997
	RoleSetType_AddRole_InputArguments                                                                                    = 15998
	RoleSetType_AddRole_OutputArguments                                                                                   = 15999
	RoleSetType_RemoveRole                                                                                                = 16000
	RoleSetType_RemoveRole_InputArguments                                                                                 = 16001
	AddRoleMethodType                                                                                                     = 16002
	AddRoleMethodType_InputArguments                                                                                      = 16003
	AddRoleMethodType_OutputArguments                                                                                     = 16004
	RemoveRoleMethodType                                                                                                  = 16005
	RemoveRoleMethodType_InputArguments                                                                                   = 16006
	DataSetReaderDataType_Encoding_DefaultXML                                                                             = 16007
	DataSetReaderTransportDataType_Encoding_DefaultXML                                                                    = 16008
	DataSetReaderMessageDataType_Encoding_DefaultXML                                                                      = 16009
	SubscribedDataSetDataType_Encoding_DefaultXML                                                                         = 16010
	TargetVariablesDataType_Encoding_DefaultXML                                                                           = 16011
	SubscribedDataSetMirrorDataType_Encoding_DefaultXML                                                                   = 16012
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel                             = 16013
	UADPWriterGroupMessageDataType_Encoding_DefaultXML                                                                    = 16014
	UADPDataSetWriterMessageDataType_Encoding_DefaultXML                                                                  = 16015
	UADPDataSetReaderMessageDataType_Encoding_DefaultXML                                                                  = 16016
	JSONWriterGroupMessageDataType_Encoding_DefaultXML                                                                    = 16017
	JSONDataSetWriterMessageDataType_Encoding_DefaultXML                                                                  = 16018
	JSONDataSetReaderMessageDataType_Encoding_DefaultXML                                                                  = 16019
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange                              = 16020
	BrokerWriterGroupTransportDataType_Encoding_DefaultXML                                                                = 16021
	BrokerDataSetWriterTransportDataType_Encoding_DefaultXML                                                              = 16022
	BrokerDataSetReaderTransportDataType_Encoding_DefaultXML                                                              = 16023
	OpcUa_XMLSchema_EndpointType                                                                                          = 16024
	OpcUa_XMLSchema_EndpointType_DataTypeVersion                                                                          = 16025
	OpcUa_XMLSchema_EndpointType_DictionaryFragment                                                                       = 16026
	OpcUa_XMLSchema_DataTypeSchemaHeader                                                                                  = 16027
	OpcUa_XMLSchema_DataTypeSchemaHeader_DataTypeVersion                                                                  = 16028
	OpcUa_XMLSchema_DataTypeSchemaHeader_DictionaryFragment                                                               = 16029
	OpcUa_XMLSchema_PublishedDataSetDataType                                                                              = 16030
	OpcUa_XMLSchema_PublishedDataSetDataType_DataTypeVersion                                                              = 16031
	OpcUa_XMLSchema_PublishedDataSetDataType_DictionaryFragment                                                           = 16032
	OpcUa_XMLSchema_PublishedDataSetSourceDataType                                                                        = 16033
	OpcUa_XMLSchema_PublishedDataSetSourceDataType_DataTypeVersion                                                        = 16034
	OpcUa_XMLSchema_PublishedDataSetSourceDataType_DictionaryFragment                                                     = 16035
	WellKnownRole_Engineer                                                                                                = 16036
	OpcUa_XMLSchema_PublishedDataItemsDataType                                                                            = 16037
	OpcUa_XMLSchema_PublishedDataItemsDataType_DataTypeVersion                                                            = 16038
	OpcUa_XMLSchema_PublishedDataItemsDataType_DictionaryFragment                                                         = 16039
	OpcUa_XMLSchema_PublishedEventsDataType                                                                               = 16040
	WellKnownRole_Engineer_AddIdentity                                                                                    = 16041
	WellKnownRole_Engineer_AddIdentity_InputArguments                                                                     = 16042
	WellKnownRole_Engineer_RemoveIdentity                                                                                 = 16043
	WellKnownRole_Engineer_RemoveIdentity_InputArguments                                                                  = 16044
	OpcUa_XMLSchema_PublishedEventsDataType_DataTypeVersion                                                               = 16045
	OpcUa_XMLSchema_PublishedEventsDataType_DictionaryFragment                                                            = 16046
	OpcUa_XMLSchema_DataSetWriterDataType                                                                                 = 16047
	OpcUa_XMLSchema_DataSetWriterDataType_DataTypeVersion                                                                 = 16048
	OpcUa_XMLSchema_DataSetWriterDataType_DictionaryFragment                                                              = 16049
	OpcUa_XMLSchema_DataSetWriterTransportDataType                                                                        = 16050
	OpcUa_XMLSchema_DataSetWriterTransportDataType_DataTypeVersion                                                        = 16051
	OpcUa_XMLSchema_DataSetWriterTransportDataType_DictionaryFragment                                                     = 16052
	OpcUa_XMLSchema_DataSetWriterMessageDataType                                                                          = 16053
	OpcUa_XMLSchema_DataSetWriterMessageDataType_DataTypeVersion                                                          = 16054
	OpcUa_XMLSchema_DataSetWriterMessageDataType_DictionaryFragment                                                       = 16055
	OpcUa_XMLSchema_PubSubGroupDataType                                                                                   = 16056
	OpcUa_XMLSchema_PubSubGroupDataType_DataTypeVersion                                                                   = 16057
	OpcUa_XMLSchema_PubSubGroupDataType_DictionaryFragment                                                                = 16058
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError                                                    = 16059
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active                                             = 16060
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification                                     = 16061
	OpcUa_XMLSchema_WriterGroupTransportDataType                                                                          = 16062
	OpcUa_XMLSchema_WriterGroupTransportDataType_DataTypeVersion                                                          = 16063
	OpcUa_XMLSchema_WriterGroupTransportDataType_DictionaryFragment                                                       = 16064
	OpcUa_XMLSchema_WriterGroupMessageDataType                                                                            = 16065
	OpcUa_XMLSchema_WriterGroupMessageDataType_DataTypeVersion                                                            = 16066
	OpcUa_XMLSchema_WriterGroupMessageDataType_DictionaryFragment                                                         = 16067
	OpcUa_XMLSchema_PubSubConnectionDataType                                                                              = 16068
	OpcUa_XMLSchema_PubSubConnectionDataType_DataTypeVersion                                                              = 16069
	OpcUa_XMLSchema_PubSubConnectionDataType_DictionaryFragment                                                           = 16070
	OpcUa_XMLSchema_ConnectionTransportDataType                                                                           = 16071
	OpcUa_XMLSchema_ConnectionTransportDataType_DataTypeVersion                                                           = 16072
	OpcUa_XMLSchema_ConnectionTransportDataType_DictionaryFragment                                                        = 16073
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel                                   = 16074
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange                                    = 16075
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset                                                         = 16076
	OpcUa_XMLSchema_ReaderGroupTransportDataType                                                                          = 16077
	OpcUa_XMLSchema_ReaderGroupTransportDataType_DataTypeVersion                                                          = 16078
	OpcUa_XMLSchema_ReaderGroupTransportDataType_DictionaryFragment                                                       = 16079
	OpcUa_XMLSchema_ReaderGroupMessageDataType                                                                            = 16080
	OpcUa_XMLSchema_ReaderGroupMessageDataType_DataTypeVersion                                                            = 16081
	OpcUa_XMLSchema_ReaderGroupMessageDataType_DictionaryFragment                                                         = 16082
	OpcUa_XMLSchema_DataSetReaderDataType                                                                                 = 16083
	OpcUa_XMLSchema_DataSetReaderDataType_DataTypeVersion                                                                 = 16084
	OpcUa_XMLSchema_DataSetReaderDataType_DictionaryFragment                                                              = 16085
	OpcUa_XMLSchema_DataSetReaderTransportDataType                                                                        = 16086
	OpcUa_XMLSchema_DataSetReaderTransportDataType_DataTypeVersion                                                        = 16087
	OpcUa_XMLSchema_DataSetReaderTransportDataType_DictionaryFragment                                                     = 16088
	OpcUa_XMLSchema_DataSetReaderMessageDataType                                                                          = 16089
	OpcUa_XMLSchema_DataSetReaderMessageDataType_DataTypeVersion                                                          = 16090
	OpcUa_XMLSchema_DataSetReaderMessageDataType_DictionaryFragment                                                       = 16091
	OpcUa_XMLSchema_SubscribedDataSetDataType                                                                             = 16092
	OpcUa_XMLSchema_SubscribedDataSetDataType_DataTypeVersion                                                             = 16093
	OpcUa_XMLSchema_SubscribedDataSetDataType_DictionaryFragment                                                          = 16094
	OpcUa_XMLSchema_TargetVariablesDataType                                                                               = 16095
	OpcUa_XMLSchema_TargetVariablesDataType_DataTypeVersion                                                               = 16096
	OpcUa_XMLSchema_TargetVariablesDataType_DictionaryFragment                                                            = 16097
	OpcUa_XMLSchema_SubscribedDataSetMirrorDataType                                                                       = 16098
	OpcUa_XMLSchema_SubscribedDataSetMirrorDataType_DataTypeVersion                                                       = 16099
	OpcUa_XMLSchema_SubscribedDataSetMirrorDataType_DictionaryFragment                                                    = 16100
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError                                                      = 16101
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters                                                      = 16102
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError                                           = 16103
	OpcUa_XMLSchema_UADPWriterGroupMessageDataType                                                                        = 16104
	OpcUa_XMLSchema_UADPWriterGroupMessageDataType_DataTypeVersion                                                        = 16105
	OpcUa_XMLSchema_UADPWriterGroupMessageDataType_DictionaryFragment                                                     = 16106
	OpcUa_XMLSchema_UADPDataSetWriterMessageDataType                                                                      = 16107
	OpcUa_XMLSchema_UADPDataSetWriterMessageDataType_DataTypeVersion                                                      = 16108
	OpcUa_XMLSchema_UADPDataSetWriterMessageDataType_DictionaryFragment                                                   = 16109
	OpcUa_XMLSchema_UADPDataSetReaderMessageDataType                                                                      = 16110
	OpcUa_XMLSchema_UADPDataSetReaderMessageDataType_DataTypeVersion                                                      = 16111
	OpcUa_XMLSchema_UADPDataSetReaderMessageDataType_DictionaryFragment                                                   = 16112
	OpcUa_XMLSchema_JSONWriterGroupMessageDataType                                                                        = 16113
	OpcUa_XMLSchema_JSONWriterGroupMessageDataType_DataTypeVersion                                                        = 16114
	OpcUa_XMLSchema_JSONWriterGroupMessageDataType_DictionaryFragment                                                     = 16115
	OpcUa_XMLSchema_JSONDataSetWriterMessageDataType                                                                      = 16116
	OpcUa_XMLSchema_JSONDataSetWriterMessageDataType_DataTypeVersion                                                      = 16117
	OpcUa_XMLSchema_JSONDataSetWriterMessageDataType_DictionaryFragment                                                   = 16118
	OpcUa_XMLSchema_JSONDataSetReaderMessageDataType                                                                      = 16119
	OpcUa_XMLSchema_JSONDataSetReaderMessageDataType_DataTypeVersion                                                      = 16120
	OpcUa_XMLSchema_JSONDataSetReaderMessageDataType_DictionaryFragment                                                   = 16121
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active                                    = 16122
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification                            = 16123
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel                          = 16124
	OpcUa_XMLSchema_BrokerWriterGroupTransportDataType                                                                    = 16125
	RolePermissionType_Encoding_DefaultXML                                                                                = 16126
	OpcUa_XMLSchema_RolePermissionType                                                                                    = 16127
	OpcUa_XMLSchema_RolePermissionType_DataTypeVersion                                                                    = 16128
	OpcUa_XMLSchema_RolePermissionType_DictionaryFragment                                                                 = 16129
	OpcUa_XMLSchema_BrokerWriterGroupTransportDataType_DataTypeVersion                                                    = 16130
	OpcUa_BinarySchema_RolePermissionType                                                                                 = 16131
	OpcUa_BinarySchema_RolePermissionType_DataTypeVersion                                                                 = 16132
	OpcUa_BinarySchema_RolePermissionType_DictionaryFragment                                                              = 16133
	OPCUANamespaceMetadata_DefaultRolePermissions                                                                         = 16134
	OPCUANamespaceMetadata_DefaultUserRolePermissions                                                                     = 16135
	OPCUANamespaceMetadata_DefaultAccessRestrictions                                                                      = 16136
	NamespaceMetadataType_DefaultRolePermissions                                                                          = 16137
	NamespaceMetadataType_DefaultUserRolePermissions                                                                      = 16138
	NamespaceMetadataType_DefaultAccessRestrictions                                                                       = 16139
	NamespacesType_NamespaceIDentifier_Placeholder_DefaultRolePermissions                                                 = 16140
	NamespacesType_NamespaceIDentifier_Placeholder_DefaultUserRolePermissions                                             = 16141
	NamespacesType_NamespaceIDentifier_Placeholder_DefaultAccessRestrictions                                              = 16142
	OpcUa_XMLSchema_BrokerWriterGroupTransportDataType_DictionaryFragment                                                 = 16143
	OpcUa_XMLSchema_BrokerDataSetWriterTransportDataType                                                                  = 16144
	OpcUa_XMLSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion                                                  = 16145
	OpcUa_XMLSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment                                               = 16146
	OpcUa_XMLSchema_BrokerDataSetReaderTransportDataType                                                                  = 16147
	OpcUa_XMLSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion                                                  = 16148
	OpcUa_XMLSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment                                               = 16149
	EndpointType_Encoding_DefaultJSON                                                                                     = 16150
	DataTypeSchemaHeader_Encoding_DefaultJSON                                                                             = 16151
	PublishedDataSetDataType_Encoding_DefaultJSON                                                                         = 16152
	PublishedDataSetSourceDataType_Encoding_DefaultJSON                                                                   = 16153
	PublishedDataItemsDataType_Encoding_DefaultJSON                                                                       = 16154
	PublishedEventsDataType_Encoding_DefaultJSON                                                                          = 16155
	DataSetWriterDataType_Encoding_DefaultJSON                                                                            = 16156
	DataSetWriterTransportDataType_Encoding_DefaultJSON                                                                   = 16157
	DataSetWriterMessageDataType_Encoding_DefaultJSON                                                                     = 16158
	PubSubGroupDataType_Encoding_DefaultJSON                                                                              = 16159
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange                           = 16160
	WriterGroupTransportDataType_Encoding_DefaultJSON                                                                     = 16161
	RoleSetType_RoleName_Placeholder_IDentities                                                                           = 16162
	RoleSetType_RoleName_Placeholder_Applications                                                                         = 16163
	RoleSetType_RoleName_Placeholder_Endpoints                                                                            = 16164
	RoleSetType_RoleName_Placeholder_AddApplication                                                                       = 16165
	RoleSetType_RoleName_Placeholder_AddApplication_InputArguments                                                        = 16166
	RoleSetType_RoleName_Placeholder_RemoveApplication                                                                    = 16167
	RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments                                                     = 16168
	RoleSetType_RoleName_Placeholder_AddEndpoint                                                                          = 16169
	RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments                                                           = 16170
	RoleSetType_RoleName_Placeholder_RemoveEndpoint                                                                       = 16171
	RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments                                                        = 16172
	RoleType_IDentities                                                                                                   = 16173
	RoleType_Applications                                                                                                 = 16174
	RoleType_Endpoints                                                                                                    = 16175
	RoleType_AddApplication                                                                                               = 16176
	RoleType_AddApplication_InputArguments                                                                                = 16177
	RoleType_RemoveApplication                                                                                            = 16178
	RoleType_RemoveApplication_InputArguments                                                                             = 16179
	RoleType_AddEndpoint                                                                                                  = 16180
	RoleType_AddEndpoint_InputArguments                                                                                   = 16181
	RoleType_RemoveEndpoint                                                                                               = 16182
	RoleType_RemoveEndpoint_InputArguments                                                                                = 16183
	AddApplicationMethodType                                                                                              = 16184
	AddApplicationMethodType_InputArguments                                                                               = 16185
	RemoveApplicationMethodType                                                                                           = 16186
	RemoveApplicationMethodType_InputArguments                                                                            = 16187
	AddEndpointMethodType                                                                                                 = 16188
	AddEndpointMethodType_InputArguments                                                                                  = 16189
	RemoveEndpointMethodType                                                                                              = 16190
	RemoveEndpointMethodType_InputArguments                                                                               = 16191
	WellKnownRole_Anonymous_IDentities                                                                                    = 16192
	WellKnownRole_Anonymous_Applications                                                                                  = 16193
	WellKnownRole_Anonymous_Endpoints                                                                                     = 16194
	WellKnownRole_Anonymous_AddApplication                                                                                = 16195
	WellKnownRole_Anonymous_AddApplication_InputArguments                                                                 = 16196
	WellKnownRole_Anonymous_RemoveApplication                                                                             = 16197
	WellKnownRole_Anonymous_RemoveApplication_InputArguments                                                              = 16198
	WellKnownRole_Anonymous_AddEndpoint                                                                                   = 16199
	WellKnownRole_Anonymous_AddEndpoint_InputArguments                                                                    = 16200
	WellKnownRole_Anonymous_RemoveEndpoint                                                                                = 16201
	WellKnownRole_Anonymous_RemoveEndpoint_InputArguments                                                                 = 16202
	WellKnownRole_AuthenticatedUser_IDentities                                                                            = 16203
	WellKnownRole_AuthenticatedUser_Applications                                                                          = 16204
	WellKnownRole_AuthenticatedUser_Endpoints                                                                             = 16205
	WellKnownRole_AuthenticatedUser_AddApplication                                                                        = 16206
	WellKnownRole_AuthenticatedUser_AddApplication_InputArguments                                                         = 16207
	WellKnownRole_AuthenticatedUser_RemoveApplication                                                                     = 16208
	WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments                                                      = 16209
	WellKnownRole_AuthenticatedUser_AddEndpoint                                                                           = 16210
	WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments                                                            = 16211
	WellKnownRole_AuthenticatedUser_RemoveEndpoint                                                                        = 16212
	WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments                                                         = 16213
	WellKnownRole_Observer_IDentities                                                                                     = 16214
	WellKnownRole_Observer_Applications                                                                                   = 16215
	WellKnownRole_Observer_Endpoints                                                                                      = 16216
	WellKnownRole_Observer_AddApplication                                                                                 = 16217
	WellKnownRole_Observer_AddApplication_InputArguments                                                                  = 16218
	WellKnownRole_Observer_RemoveApplication                                                                              = 16219
	WellKnownRole_Observer_RemoveApplication_InputArguments                                                               = 16220
	WellKnownRole_Observer_AddEndpoint                                                                                    = 16221
	WellKnownRole_Observer_AddEndpoint_InputArguments                                                                     = 16222
	WellKnownRole_Observer_RemoveEndpoint                                                                                 = 16223
	WellKnownRole_Observer_RemoveEndpoint_InputArguments                                                                  = 16224
	WellKnownRole_Operator_IDentities                                                                                     = 16225
	WellKnownRole_Operator_Applications                                                                                   = 16226
	WellKnownRole_Operator_Endpoints                                                                                      = 16227
	WellKnownRole_Operator_AddApplication                                                                                 = 16228
	WellKnownRole_Operator_AddApplication_InputArguments                                                                  = 16229
	WellKnownRole_Operator_RemoveApplication                                                                              = 16230
	WellKnownRole_Operator_RemoveApplication_InputArguments                                                               = 16231
	WellKnownRole_Operator_AddEndpoint                                                                                    = 16232
	WellKnownRole_Operator_AddEndpoint_InputArguments                                                                     = 16233
	WellKnownRole_Operator_RemoveEndpoint                                                                                 = 16234
	WellKnownRole_Operator_RemoveEndpoint_InputArguments                                                                  = 16235
	WellKnownRole_Engineer_IDentities                                                                                     = 16236
	WellKnownRole_Engineer_Applications                                                                                   = 16237
	WellKnownRole_Engineer_Endpoints                                                                                      = 16238
	WellKnownRole_Engineer_AddApplication                                                                                 = 16239
	WellKnownRole_Engineer_AddApplication_InputArguments                                                                  = 16240
	WellKnownRole_Engineer_RemoveApplication                                                                              = 16241
	WellKnownRole_Engineer_RemoveApplication_InputArguments                                                               = 16242
	WellKnownRole_Engineer_AddEndpoint                                                                                    = 16243
	WellKnownRole_Engineer_AddEndpoint_InputArguments                                                                     = 16244
	WellKnownRole_Engineer_RemoveEndpoint                                                                                 = 16245
	WellKnownRole_Engineer_RemoveEndpoint_InputArguments                                                                  = 16246
	WellKnownRole_Supervisor_IDentities                                                                                   = 16247
	WellKnownRole_Supervisor_Applications                                                                                 = 16248
	WellKnownRole_Supervisor_Endpoints                                                                                    = 16249
	WellKnownRole_Supervisor_AddApplication                                                                               = 16250
	WellKnownRole_Supervisor_AddApplication_InputArguments                                                                = 16251
	WellKnownRole_Supervisor_RemoveApplication                                                                            = 16252
	WellKnownRole_Supervisor_RemoveApplication_InputArguments                                                             = 16253
	WellKnownRole_Supervisor_AddEndpoint                                                                                  = 16254
	WellKnownRole_Supervisor_AddEndpoint_InputArguments                                                                   = 16255
	WellKnownRole_Supervisor_RemoveEndpoint                                                                               = 16256
	WellKnownRole_Supervisor_RemoveEndpoint_InputArguments                                                                = 16257
	WellKnownRole_SecurityAdmin_IDentities                                                                                = 16258
	WellKnownRole_SecurityAdmin_Applications                                                                              = 16259
	WellKnownRole_SecurityAdmin_Endpoints                                                                                 = 16260
	WellKnownRole_SecurityAdmin_AddApplication                                                                            = 16261
	WellKnownRole_SecurityAdmin_AddApplication_InputArguments                                                             = 16262
	WellKnownRole_SecurityAdmin_RemoveApplication                                                                         = 16263
	WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments                                                          = 16264
	WellKnownRole_SecurityAdmin_AddEndpoint                                                                               = 16265
	WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments                                                                = 16266
	WellKnownRole_SecurityAdmin_RemoveEndpoint                                                                            = 16267
	WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments                                                             = 16268
	WellKnownRole_ConfigureAdmin_IDentities                                                                               = 16269
	WellKnownRole_ConfigureAdmin_Applications                                                                             = 16270
	WellKnownRole_ConfigureAdmin_Endpoints                                                                                = 16271
	WellKnownRole_ConfigureAdmin_AddApplication                                                                           = 16272
	WellKnownRole_ConfigureAdmin_AddApplication_InputArguments                                                            = 16273
	WellKnownRole_ConfigureAdmin_RemoveApplication                                                                        = 16274
	WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments                                                         = 16275
	WellKnownRole_ConfigureAdmin_AddEndpoint                                                                              = 16276
	WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments                                                               = 16277
	WellKnownRole_ConfigureAdmin_RemoveEndpoint                                                                           = 16278
	WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments                                                            = 16279
	WriterGroupMessageDataType_Encoding_DefaultJSON                                                                       = 16280
	PubSubConnectionDataType_Encoding_DefaultJSON                                                                         = 16281
	ConnectionTransportDataType_Encoding_DefaultJSON                                                                      = 16282
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod                             = 16283
	ReaderGroupTransportDataType_Encoding_DefaultJSON                                                                     = 16284
	ReaderGroupMessageDataType_Encoding_DefaultJSON                                                                       = 16285
	DataSetReaderDataType_Encoding_DefaultJSON                                                                            = 16286
	DataSetReaderTransportDataType_Encoding_DefaultJSON                                                                   = 16287
	DataSetReaderMessageDataType_Encoding_DefaultJSON                                                                     = 16288
	ServerType_ServerCapabilities_RoleSet                                                                                 = 16289
	ServerType_ServerCapabilities_RoleSet_AddRole                                                                         = 16290
	ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments                                                          = 16291
	ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments                                                         = 16292
	ServerType_ServerCapabilities_RoleSet_RemoveRole                                                                      = 16293
	ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments                                                       = 16294
	ServerCapabilitiesType_RoleSet                                                                                        = 16295
	ServerCapabilitiesType_RoleSet_AddRole                                                                                = 16296
	ServerCapabilitiesType_RoleSet_AddRole_InputArguments                                                                 = 16297
	ServerCapabilitiesType_RoleSet_AddRole_OutputArguments                                                                = 16298
	ServerCapabilitiesType_RoleSet_RemoveRole                                                                             = 16299
	ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments                                                              = 16300
	Server_ServerCapabilities_RoleSet_AddRole                                                                             = 16301
	Server_ServerCapabilities_RoleSet_AddRole_InputArguments                                                              = 16302
	Server_ServerCapabilities_RoleSet_AddRole_OutputArguments                                                             = 16303
	Server_ServerCapabilities_RoleSet_RemoveRole                                                                          = 16304
	Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments                                                           = 16305
	DefaultInputValues                                                                                                    = 16306
	AudioDataType                                                                                                         = 16307
	SubscribedDataSetDataType_Encoding_DefaultJSON                                                                        = 16308
	SelectionListType                                                                                                     = 16309
	TargetVariablesDataType_Encoding_DefaultJSON                                                                          = 16310
	SubscribedDataSetMirrorDataType_Encoding_DefaultJSON                                                                  = 16311
	SelectionListType_RestrictToList                                                                                      = 16312
	AdditionalParametersType                                                                                              = 16313
	FileSystem                                                                                                            = 16314
	FileSystem_FileDirectoryName_Placeholder                                                                              = 16315
	FileSystem_FileDirectoryName_Placeholder_CreateDirectory                                                              = 16316
	FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments                                               = 16317
	FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments                                              = 16318
	FileSystem_FileDirectoryName_Placeholder_CreateFile                                                                   = 16319
	FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments                                                    = 16320
	FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments                                                   = 16321
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active                      = 16322
	UADPWriterGroupMessageDataType_Encoding_DefaultJSON                                                                   = 16323
	FileSystem_FileDirectoryName_Placeholder_MoveOrCopy                                                                   = 16324
	FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments                                                    = 16325
	FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments                                                   = 16326
	FileSystem_FileName_Placeholder                                                                                       = 16327
	FileSystem_FileName_Placeholder_Size                                                                                  = 16328
	FileSystem_FileName_Placeholder_Writable                                                                              = 16329
	FileSystem_FileName_Placeholder_UserWritable                                                                          = 16330
	FileSystem_FileName_Placeholder_OpenCount                                                                             = 16331
	FileSystem_FileName_Placeholder_MimeType                                                                              = 16332
	FileSystem_FileName_Placeholder_Open                                                                                  = 16333
	FileSystem_FileName_Placeholder_Open_InputArguments                                                                   = 16334
	FileSystem_FileName_Placeholder_Open_OutputArguments                                                                  = 16335
	FileSystem_FileName_Placeholder_Close                                                                                 = 16336
	FileSystem_FileName_Placeholder_Close_InputArguments                                                                  = 16337
	FileSystem_FileName_Placeholder_Read                                                                                  = 16338
	FileSystem_FileName_Placeholder_Read_InputArguments                                                                   = 16339
	FileSystem_FileName_Placeholder_Read_OutputArguments                                                                  = 16340
	FileSystem_FileName_Placeholder_Write                                                                                 = 16341
	FileSystem_FileName_Placeholder_Write_InputArguments                                                                  = 16342
	FileSystem_FileName_Placeholder_GetPosition                                                                           = 16343
	FileSystem_FileName_Placeholder_GetPosition_InputArguments                                                            = 16344
	FileSystem_FileName_Placeholder_GetPosition_OutputArguments                                                           = 16345
	FileSystem_FileName_Placeholder_SetPosition                                                                           = 16346
	FileSystem_FileName_Placeholder_SetPosition_InputArguments                                                            = 16347
	FileSystem_CreateDirectory                                                                                            = 16348
	FileSystem_CreateDirectory_InputArguments                                                                             = 16349
	FileSystem_CreateDirectory_OutputArguments                                                                            = 16350
	FileSystem_CreateFile                                                                                                 = 16351
	FileSystem_CreateFile_InputArguments                                                                                  = 16352
	FileSystem_CreateFile_OutputArguments                                                                                 = 16353
	FileSystem_DeleteFileSystemObject                                                                                     = 16354
	FileSystem_DeleteFileSystemObject_InputArguments                                                                      = 16355
	FileSystem_MoveOrCopy                                                                                                 = 16356
	FileSystem_MoveOrCopy_InputArguments                                                                                  = 16357
	FileSystem_MoveOrCopy_OutputArguments                                                                                 = 16358
	TemporaryFileTransferType_GenerateFileForWrite_InputArguments                                                         = 16359
	GenerateFileForWriteMethodType_InputArguments                                                                         = 16360
	HasAlarmSuppressionGroup                                                                                              = 16361
	AlarmGroupMember                                                                                                      = 16362
	ConditionType_ConditionSubClassID                                                                                     = 16363
	ConditionType_ConditionSubClassName                                                                                   = 16364
	DialogConditionType_ConditionSubClassID                                                                               = 16365
	DialogConditionType_ConditionSubClassName                                                                             = 16366
	AcknowledgeableConditionType_ConditionSubClassID                                                                      = 16367
	AcknowledgeableConditionType_ConditionSubClassName                                                                    = 16368
	AlarmConditionType_ConditionSubClassID                                                                                = 16369
	AlarmConditionType_ConditionSubClassName                                                                              = 16370
	AlarmConditionType_OutOfServiceState                                                                                  = 16371
	AlarmConditionType_OutOfServiceState_ID                                                                               = 16372
	AlarmConditionType_OutOfServiceState_Name                                                                             = 16373
	AlarmConditionType_OutOfServiceState_Number                                                                           = 16374
	AlarmConditionType_OutOfServiceState_EffectiveDisplayName                                                             = 16375
	AlarmConditionType_OutOfServiceState_TransitionTime                                                                   = 16376
	AlarmConditionType_OutOfServiceState_EffectiveTransitionTime                                                          = 16377
	AlarmConditionType_OutOfServiceState_TrueState                                                                        = 16378
	AlarmConditionType_OutOfServiceState_FalseState                                                                       = 16379
	AlarmConditionType_SilenceState                                                                                       = 16380
	AlarmConditionType_SilenceState_ID                                                                                    = 16381
	AlarmConditionType_SilenceState_Name                                                                                  = 16382
	AlarmConditionType_SilenceState_Number                                                                                = 16383
	AlarmConditionType_SilenceState_EffectiveDisplayName                                                                  = 16384
	AlarmConditionType_SilenceState_TransitionTime                                                                        = 16385
	AlarmConditionType_SilenceState_EffectiveTransitionTime                                                               = 16386
	AlarmConditionType_SilenceState_TrueState                                                                             = 16387
	AlarmConditionType_SilenceState_FalseState                                                                            = 16388
	AlarmConditionType_AudibleEnabled                                                                                     = 16389
	AlarmConditionType_AudibleSound                                                                                       = 16390
	UADPDataSetWriterMessageDataType_Encoding_DefaultJSON                                                                 = 16391
	UADPDataSetReaderMessageDataType_Encoding_DefaultJSON                                                                 = 16392
	JSONWriterGroupMessageDataType_Encoding_DefaultJSON                                                                   = 16393
	JSONDataSetWriterMessageDataType_Encoding_DefaultJSON                                                                 = 16394
	AlarmConditionType_OnDelay                                                                                            = 16395
	AlarmConditionType_OffDelay                                                                                           = 16396
	AlarmConditionType_FirstInGroupFlag                                                                                   = 16397
	AlarmConditionType_FirstInGroup                                                                                       = 16398
	AlarmConditionType_AlarmGroup_Placeholder                                                                             = 16399
	AlarmConditionType_ReAlarmTime                                                                                        = 16400
	AlarmConditionType_ReAlarmRepeatCount                                                                                 = 16401
	AlarmConditionType_Silence                                                                                            = 16402
	AlarmConditionType_Suppress                                                                                           = 16403
	JSONDataSetReaderMessageDataType_Encoding_DefaultJSON                                                                 = 16404
	AlarmGroupType                                                                                                        = 16405
	AlarmGroupType_AlarmConditionInstance_Placeholder                                                                     = 16406
	AlarmGroupType_AlarmConditionInstance_Placeholder_EventID                                                             = 16407
	AlarmGroupType_AlarmConditionInstance_Placeholder_EventType                                                           = 16408
	AlarmGroupType_AlarmConditionInstance_Placeholder_SourceNode                                                          = 16409
	AlarmGroupType_AlarmConditionInstance_Placeholder_SourceName                                                          = 16410
	AlarmGroupType_AlarmConditionInstance_Placeholder_Time                                                                = 16411
	AlarmGroupType_AlarmConditionInstance_Placeholder_ReceiveTime                                                         = 16412
	AlarmGroupType_AlarmConditionInstance_Placeholder_LocalTime                                                           = 16413
	AlarmGroupType_AlarmConditionInstance_Placeholder_Message                                                             = 16414
	AlarmGroupType_AlarmConditionInstance_Placeholder_Severity                                                            = 16415
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassID                                                    = 16416
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassName                                                  = 16417
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionSubClassID                                                 = 16418
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionSubClassName                                               = 16419
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionName                                                       = 16420
	AlarmGroupType_AlarmConditionInstance_Placeholder_BranchID                                                            = 16421
	AlarmGroupType_AlarmConditionInstance_Placeholder_Retain                                                              = 16422
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState                                                        = 16423
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_ID                                                     = 16424
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Name                                                   = 16425
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Number                                                 = 16426
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_EffectiveDisplayName                                   = 16427
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_TransitionTime                                         = 16428
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_EffectiveTransitionTime                                = 16429
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_TrueState                                              = 16430
	AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_FalseState                                             = 16431
	AlarmGroupType_AlarmConditionInstance_Placeholder_Quality                                                             = 16432
	AlarmGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp                                             = 16433
	AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity                                                        = 16434
	AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp                                        = 16435
	AlarmGroupType_AlarmConditionInstance_Placeholder_Comment                                                             = 16436
	AlarmGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp                                             = 16437
	AlarmGroupType_AlarmConditionInstance_Placeholder_ClientUserID                                                        = 16438
	AlarmGroupType_AlarmConditionInstance_Placeholder_Disable                                                             = 16439
	AlarmGroupType_AlarmConditionInstance_Placeholder_Enable                                                              = 16440
	AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment                                                          = 16441
	AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments                                           = 16442
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState                                                          = 16443
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_ID                                                       = 16444
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Name                                                     = 16445
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Number                                                   = 16446
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_EffectiveDisplayName                                     = 16447
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_TransitionTime                                           = 16448
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_EffectiveTransitionTime                                  = 16449
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_TrueState                                                = 16450
	AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_FalseState                                               = 16451
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState                                                      = 16452
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_ID                                                   = 16453
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Name                                                 = 16454
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Number                                               = 16455
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_EffectiveDisplayName                                 = 16456
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_TransitionTime                                       = 16457
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_EffectiveTransitionTime                              = 16458
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_TrueState                                            = 16459
	AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_FalseState                                           = 16460
	AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge                                                         = 16461
	AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments                                          = 16462
	AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm                                                             = 16463
	AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments                                              = 16464
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState                                                         = 16465
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_ID                                                      = 16466
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Name                                                    = 16467
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Number                                                  = 16468
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_EffectiveDisplayName                                    = 16469
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_TransitionTime                                          = 16470
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_EffectiveTransitionTime                                 = 16471
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_TrueState                                               = 16472
	AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_FalseState                                              = 16473
	AlarmGroupType_AlarmConditionInstance_Placeholder_InputNode                                                           = 16474
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState                                                     = 16475
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_ID                                                  = 16476
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Name                                                = 16477
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Number                                              = 16478
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_EffectiveDisplayName                                = 16479
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_TransitionTime                                      = 16480
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_EffectiveTransitionTime                             = 16481
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_TrueState                                           = 16482
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_FalseState                                          = 16483
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState                                                   = 16484
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_ID                                                = 16485
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Name                                              = 16486
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Number                                            = 16487
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_EffectiveDisplayName                              = 16488
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_TransitionTime                                    = 16489
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_EffectiveTransitionTime                           = 16490
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_TrueState                                         = 16491
	AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_FalseState                                        = 16492
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState                                                        = 16493
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_ID                                                     = 16494
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Name                                                   = 16495
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Number                                                 = 16496
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_EffectiveDisplayName                                   = 16497
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_TransitionTime                                         = 16498
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_EffectiveTransitionTime                                = 16499
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_TrueState                                              = 16500
	AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_FalseState                                             = 16501
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState                                                       = 16502
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState                                          = 16503
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_ID                                       = 16504
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Name                                     = 16505
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Number                                   = 16506
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_EffectiveDisplayName                     = 16507
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition                                        = 16508
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_ID                                     = 16509
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Name                                   = 16510
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Number                                 = 16511
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_TransitionTime                         = 16512
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_EffectiveTransitionTime                = 16513
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime                                          = 16514
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve                                              = 16515
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve                                         = 16516
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve                                           = 16517
	AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments                            = 16518
	AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved                                                 = 16519
	AlarmGroupType_AlarmConditionInstance_Placeholder_MaxTimeShelved                                                      = 16520
	AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleEnabled                                                      = 16521
	AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound                                                        = 16522
	PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification              = 16523
	BrokerWriterGroupTransportDataType_Encoding_DefaultJSON                                                               = 16524
	BrokerDataSetWriterTransportDataType_Encoding_DefaultJSON                                                             = 16525
	BrokerDataSetReaderTransportDataType_Encoding_DefaultJSON                                                             = 16526
	AlarmGroupType_AlarmConditionInstance_Placeholder_OnDelay                                                             = 16527
	AlarmGroupType_AlarmConditionInstance_Placeholder_OffDelay                                                            = 16528
	AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroupFlag                                                    = 16529
	AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup                                                        = 16530
	AlarmGroupType_AlarmConditionInstance_Placeholder_ReAlarmTime                                                         = 16531
	AlarmGroupType_AlarmConditionInstance_Placeholder_ReAlarmRepeatCount                                                  = 16532
	AlarmGroupType_AlarmConditionInstance_Placeholder_Silence                                                             = 16533
	AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress                                                            = 16534
	PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup                                                        = 16535
	LimitAlarmType_ConditionSubClassID                                                                                    = 16536
	LimitAlarmType_ConditionSubClassName                                                                                  = 16537
	LimitAlarmType_OutOfServiceState                                                                                      = 16538
	LimitAlarmType_OutOfServiceState_ID                                                                                   = 16539
	LimitAlarmType_OutOfServiceState_Name                                                                                 = 16540
	LimitAlarmType_OutOfServiceState_Number                                                                               = 16541
	LimitAlarmType_OutOfServiceState_EffectiveDisplayName                                                                 = 16542
	LimitAlarmType_OutOfServiceState_TransitionTime                                                                       = 16543
	LimitAlarmType_OutOfServiceState_EffectiveTransitionTime                                                              = 16544
	LimitAlarmType_OutOfServiceState_TrueState                                                                            = 16545
	LimitAlarmType_OutOfServiceState_FalseState                                                                           = 16546
	LimitAlarmType_SilenceState                                                                                           = 16547
	LimitAlarmType_SilenceState_ID                                                                                        = 16548
	LimitAlarmType_SilenceState_Name                                                                                      = 16549
	LimitAlarmType_SilenceState_Number                                                                                    = 16550
	LimitAlarmType_SilenceState_EffectiveDisplayName                                                                      = 16551
	LimitAlarmType_SilenceState_TransitionTime                                                                            = 16552
	LimitAlarmType_SilenceState_EffectiveTransitionTime                                                                   = 16553
	LimitAlarmType_SilenceState_TrueState                                                                                 = 16554
	LimitAlarmType_SilenceState_FalseState                                                                                = 16555
	LimitAlarmType_AudibleEnabled                                                                                         = 16556
	LimitAlarmType_AudibleSound                                                                                           = 16557
	PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments                                         = 16558
	PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments                                        = 16559
	PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup                                                        = 16560
	PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments                                         = 16561
	LimitAlarmType_OnDelay                                                                                                = 16562
	LimitAlarmType_OffDelay                                                                                               = 16563
	LimitAlarmType_FirstInGroupFlag                                                                                       = 16564
	LimitAlarmType_FirstInGroup                                                                                           = 16565
	LimitAlarmType_AlarmGroup_Placeholder                                                                                 = 16566
	LimitAlarmType_ReAlarmTime                                                                                            = 16567
	LimitAlarmType_ReAlarmRepeatCount                                                                                     = 16568
	LimitAlarmType_Silence                                                                                                = 16569
	LimitAlarmType_Suppress                                                                                               = 16570
	PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments                                        = 16571
	LimitAlarmType_BaseHighHighLimit                                                                                      = 16572
	LimitAlarmType_BaseHighLimit                                                                                          = 16573
	LimitAlarmType_BaseLowLimit                                                                                           = 16574
	LimitAlarmType_BaseLowLowLimit                                                                                        = 16575
	ExclusiveLimitAlarmType_ConditionSubClassID                                                                           = 16576
	ExclusiveLimitAlarmType_ConditionSubClassName                                                                         = 16577
	ExclusiveLimitAlarmType_OutOfServiceState                                                                             = 16578
	ExclusiveLimitAlarmType_OutOfServiceState_ID                                                                          = 16579
	ExclusiveLimitAlarmType_OutOfServiceState_Name                                                                        = 16580
	ExclusiveLimitAlarmType_OutOfServiceState_Number                                                                      = 16581
	ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName                                                        = 16582
	ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime                                                              = 16583
	ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime                                                     = 16584
	ExclusiveLimitAlarmType_OutOfServiceState_TrueState                                                                   = 16585
	ExclusiveLimitAlarmType_OutOfServiceState_FalseState                                                                  = 16586
	ExclusiveLimitAlarmType_SilenceState                                                                                  = 16587
	ExclusiveLimitAlarmType_SilenceState_ID                                                                               = 16588
	ExclusiveLimitAlarmType_SilenceState_Name                                                                             = 16589
	ExclusiveLimitAlarmType_SilenceState_Number                                                                           = 16590
	ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName                                                             = 16591
	ExclusiveLimitAlarmType_SilenceState_TransitionTime                                                                   = 16592
	ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime                                                          = 16593
	ExclusiveLimitAlarmType_SilenceState_TrueState                                                                        = 16594
	ExclusiveLimitAlarmType_SilenceState_FalseState                                                                       = 16595
	ExclusiveLimitAlarmType_AudibleEnabled                                                                                = 16596
	ExclusiveLimitAlarmType_AudibleSound                                                                                  = 16597
	PublishSubscribeType_AddConnection                                                                                    = 16598
	PublishSubscribeType_AddConnection_InputArguments                                                                     = 16599
	PublishSubscribeType_AddConnection_OutputArguments                                                                    = 16600
	PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate                                                  = 16601
	ExclusiveLimitAlarmType_OnDelay                                                                                       = 16602
	ExclusiveLimitAlarmType_OffDelay                                                                                      = 16603
	ExclusiveLimitAlarmType_FirstInGroupFlag                                                                              = 16604
	ExclusiveLimitAlarmType_FirstInGroup                                                                                  = 16605
	ExclusiveLimitAlarmType_AlarmGroup_Placeholder                                                                        = 16606
	ExclusiveLimitAlarmType_ReAlarmTime                                                                                   = 16607
	ExclusiveLimitAlarmType_ReAlarmRepeatCount                                                                            = 16608
	ExclusiveLimitAlarmType_Silence                                                                                       = 16609
	ExclusiveLimitAlarmType_Suppress                                                                                      = 16610
	PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments                                   = 16611
	ExclusiveLimitAlarmType_BaseHighHighLimit                                                                             = 16612
	ExclusiveLimitAlarmType_BaseHighLimit                                                                                 = 16613
	ExclusiveLimitAlarmType_BaseLowLimit                                                                                  = 16614
	ExclusiveLimitAlarmType_BaseLowLowLimit                                                                               = 16615
	NonExclusiveLimitAlarmType_ConditionSubClassID                                                                        = 16616
	NonExclusiveLimitAlarmType_ConditionSubClassName                                                                      = 16617
	NonExclusiveLimitAlarmType_OutOfServiceState                                                                          = 16618
	NonExclusiveLimitAlarmType_OutOfServiceState_ID                                                                       = 16619
	NonExclusiveLimitAlarmType_OutOfServiceState_Name                                                                     = 16620
	NonExclusiveLimitAlarmType_OutOfServiceState_Number                                                                   = 16621
	NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName                                                     = 16622
	NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime                                                           = 16623
	NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime                                                  = 16624
	NonExclusiveLimitAlarmType_OutOfServiceState_TrueState                                                                = 16625
	NonExclusiveLimitAlarmType_OutOfServiceState_FalseState                                                               = 16626
	NonExclusiveLimitAlarmType_SilenceState                                                                               = 16627
	NonExclusiveLimitAlarmType_SilenceState_ID                                                                            = 16628
	NonExclusiveLimitAlarmType_SilenceState_Name                                                                          = 16629
	NonExclusiveLimitAlarmType_SilenceState_Number                                                                        = 16630
	NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName                                                          = 16631
	NonExclusiveLimitAlarmType_SilenceState_TransitionTime                                                                = 16632
	NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime                                                       = 16633
	NonExclusiveLimitAlarmType_SilenceState_TrueState                                                                     = 16634
	NonExclusiveLimitAlarmType_SilenceState_FalseState                                                                    = 16635
	NonExclusiveLimitAlarmType_AudibleEnabled                                                                             = 16636
	NonExclusiveLimitAlarmType_AudibleSound                                                                               = 16637
	PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments                                  = 16638
	PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate                                                     = 16639
	PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments                                      = 16640
	PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments                                     = 16641
	NonExclusiveLimitAlarmType_OnDelay                                                                                    = 16642
	NonExclusiveLimitAlarmType_OffDelay                                                                                   = 16643
	NonExclusiveLimitAlarmType_FirstInGroupFlag                                                                           = 16644
	NonExclusiveLimitAlarmType_FirstInGroup                                                                               = 16645
	NonExclusiveLimitAlarmType_AlarmGroup_Placeholder                                                                     = 16646
	NonExclusiveLimitAlarmType_ReAlarmTime                                                                                = 16647
	NonExclusiveLimitAlarmType_ReAlarmRepeatCount                                                                         = 16648
	NonExclusiveLimitAlarmType_Silence                                                                                    = 16649
	NonExclusiveLimitAlarmType_Suppress                                                                                   = 16650
	PublishSubscribeType_PublishedDataSets_AddDataSetFolder                                                               = 16651
	NonExclusiveLimitAlarmType_BaseHighHighLimit                                                                          = 16652
	NonExclusiveLimitAlarmType_BaseHighLimit                                                                              = 16653
	NonExclusiveLimitAlarmType_BaseLowLimit                                                                               = 16654
	NonExclusiveLimitAlarmType_BaseLowLowLimit                                                                            = 16655
	NonExclusiveLevelAlarmType_ConditionSubClassID                                                                        = 16656
	NonExclusiveLevelAlarmType_ConditionSubClassName                                                                      = 16657
	NonExclusiveLevelAlarmType_OutOfServiceState                                                                          = 16658
	NonExclusiveLevelAlarmType_OutOfServiceState_ID                                                                       = 16659
	NonExclusiveLevelAlarmType_OutOfServiceState_Name                                                                     = 16660
	NonExclusiveLevelAlarmType_OutOfServiceState_Number                                                                   = 16661
	NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName                                                     = 16662
	NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime                                                           = 16663
	NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime                                                  = 16664
	NonExclusiveLevelAlarmType_OutOfServiceState_TrueState                                                                = 16665
	NonExclusiveLevelAlarmType_OutOfServiceState_FalseState                                                               = 16666
	NonExclusiveLevelAlarmType_SilenceState                                                                               = 16667
	NonExclusiveLevelAlarmType_SilenceState_ID                                                                            = 16668
	NonExclusiveLevelAlarmType_SilenceState_Name                                                                          = 16669
	NonExclusiveLevelAlarmType_SilenceState_Number                                                                        = 16670
	NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName                                                          = 16671
	NonExclusiveLevelAlarmType_SilenceState_TransitionTime                                                                = 16672
	NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime                                                       = 16673
	NonExclusiveLevelAlarmType_SilenceState_TrueState                                                                     = 16674
	NonExclusiveLevelAlarmType_SilenceState_FalseState                                                                    = 16675
	NonExclusiveLevelAlarmType_AudibleEnabled                                                                             = 16676
	NonExclusiveLevelAlarmType_AudibleSound                                                                               = 16677
	PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments                                                = 16678
	PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments                                               = 16679
	PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder                                                            = 16680
	PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments                                             = 16681
	NonExclusiveLevelAlarmType_OnDelay                                                                                    = 16682
	NonExclusiveLevelAlarmType_OffDelay                                                                                   = 16683
	NonExclusiveLevelAlarmType_FirstInGroupFlag                                                                           = 16684
	NonExclusiveLevelAlarmType_FirstInGroup                                                                               = 16685
	NonExclusiveLevelAlarmType_AlarmGroup_Placeholder                                                                     = 16686
	NonExclusiveLevelAlarmType_ReAlarmTime                                                                                = 16687
	NonExclusiveLevelAlarmType_ReAlarmRepeatCount                                                                         = 16688
	NonExclusiveLevelAlarmType_Silence                                                                                    = 16689
	NonExclusiveLevelAlarmType_Suppress                                                                                   = 16690
	AddConnectionMethodType                                                                                               = 16691
	NonExclusiveLevelAlarmType_BaseHighHighLimit                                                                          = 16692
	NonExclusiveLevelAlarmType_BaseHighLimit                                                                              = 16693
	NonExclusiveLevelAlarmType_BaseLowLimit                                                                               = 16694
	NonExclusiveLevelAlarmType_BaseLowLowLimit                                                                            = 16695
	ExclusiveLevelAlarmType_ConditionSubClassID                                                                           = 16696
	ExclusiveLevelAlarmType_ConditionSubClassName                                                                         = 16697
	ExclusiveLevelAlarmType_OutOfServiceState                                                                             = 16698
	ExclusiveLevelAlarmType_OutOfServiceState_ID                                                                          = 16699
	ExclusiveLevelAlarmType_OutOfServiceState_Name                                                                        = 16700
	ExclusiveLevelAlarmType_OutOfServiceState_Number                                                                      = 16701
	ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName                                                        = 16702
	ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime                                                              = 16703
	ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime                                                     = 16704
	ExclusiveLevelAlarmType_OutOfServiceState_TrueState                                                                   = 16705
	ExclusiveLevelAlarmType_OutOfServiceState_FalseState                                                                  = 16706
	ExclusiveLevelAlarmType_SilenceState                                                                                  = 16707
	ExclusiveLevelAlarmType_SilenceState_ID                                                                               = 16708
	ExclusiveLevelAlarmType_SilenceState_Name                                                                             = 16709
	ExclusiveLevelAlarmType_SilenceState_Number                                                                           = 16710
	ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName                                                             = 16711
	ExclusiveLevelAlarmType_SilenceState_TransitionTime                                                                   = 16712
	ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime                                                          = 16713
	ExclusiveLevelAlarmType_SilenceState_TrueState                                                                        = 16714
	ExclusiveLevelAlarmType_SilenceState_FalseState                                                                       = 16715
	ExclusiveLevelAlarmType_AudibleEnabled                                                                                = 16716
	ExclusiveLevelAlarmType_AudibleSound                                                                                  = 16717
	AddConnectionMethodType_InputArguments                                                                                = 16718
	AddConnectionMethodType_OutputArguments                                                                               = 16719
	PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterID                                                    = 16720
	PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask                                            = 16721
	ExclusiveLevelAlarmType_OnDelay                                                                                       = 16722
	ExclusiveLevelAlarmType_OffDelay                                                                                      = 16723
	ExclusiveLevelAlarmType_FirstInGroupFlag                                                                              = 16724
	ExclusiveLevelAlarmType_FirstInGroup                                                                                  = 16725
	ExclusiveLevelAlarmType_AlarmGroup_Placeholder                                                                        = 16726
	ExclusiveLevelAlarmType_ReAlarmTime                                                                                   = 16727
	ExclusiveLevelAlarmType_ReAlarmRepeatCount                                                                            = 16728
	ExclusiveLevelAlarmType_Silence                                                                                       = 16729
	ExclusiveLevelAlarmType_Suppress                                                                                      = 16730
	PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount                                                      = 16731
	ExclusiveLevelAlarmType_BaseHighHighLimit                                                                             = 16732
	ExclusiveLevelAlarmType_BaseHighLimit                                                                                 = 16733
	ExclusiveLevelAlarmType_BaseLowLimit                                                                                  = 16734
	ExclusiveLevelAlarmType_BaseLowLowLimit                                                                               = 16735
	NonExclusiveDeviationAlarmType_ConditionSubClassID                                                                    = 16736
	NonExclusiveDeviationAlarmType_ConditionSubClassName                                                                  = 16737
	NonExclusiveDeviationAlarmType_OutOfServiceState                                                                      = 16738
	NonExclusiveDeviationAlarmType_OutOfServiceState_ID                                                                   = 16739
	NonExclusiveDeviationAlarmType_OutOfServiceState_Name                                                                 = 16740
	NonExclusiveDeviationAlarmType_OutOfServiceState_Number                                                               = 16741
	NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName                                                 = 16742
	NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime                                                       = 16743
	NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime                                              = 16744
	NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState                                                            = 16745
	NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState                                                           = 16746
	NonExclusiveDeviationAlarmType_SilenceState                                                                           = 16747
	NonExclusiveDeviationAlarmType_SilenceState_ID                                                                        = 16748
	NonExclusiveDeviationAlarmType_SilenceState_Name                                                                      = 16749
	NonExclusiveDeviationAlarmType_SilenceState_Number                                                                    = 16750
	NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName                                                      = 16751
	NonExclusiveDeviationAlarmType_SilenceState_TransitionTime                                                            = 16752
	NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime                                                   = 16753
	NonExclusiveDeviationAlarmType_SilenceState_TrueState                                                                 = 16754
	NonExclusiveDeviationAlarmType_SilenceState_FalseState                                                                = 16755
	NonExclusiveDeviationAlarmType_AudibleEnabled                                                                         = 16756
	NonExclusiveDeviationAlarmType_AudibleSound                                                                           = 16757
	PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings                                                    = 16758
	PublishedDataSetType_DataSetClassID                                                                                   = 16759
	PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterID                                                  = 16760
	PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask                                          = 16761
	NonExclusiveDeviationAlarmType_OnDelay                                                                                = 16762
	NonExclusiveDeviationAlarmType_OffDelay                                                                               = 16763
	NonExclusiveDeviationAlarmType_FirstInGroupFlag                                                                       = 16764
	NonExclusiveDeviationAlarmType_FirstInGroup                                                                           = 16765
	NonExclusiveDeviationAlarmType_AlarmGroup_Placeholder                                                                 = 16766
	NonExclusiveDeviationAlarmType_ReAlarmTime                                                                            = 16767
	NonExclusiveDeviationAlarmType_ReAlarmRepeatCount                                                                     = 16768
	NonExclusiveDeviationAlarmType_Silence                                                                                = 16769
	NonExclusiveDeviationAlarmType_Suppress                                                                               = 16770
	PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount                                                    = 16771
	NonExclusiveDeviationAlarmType_BaseHighHighLimit                                                                      = 16772
	NonExclusiveDeviationAlarmType_BaseHighLimit                                                                          = 16773
	NonExclusiveDeviationAlarmType_BaseLowLimit                                                                           = 16774
	NonExclusiveDeviationAlarmType_BaseLowLowLimit                                                                        = 16775
	NonExclusiveDeviationAlarmType_BaseSetpointNode                                                                       = 16776
	ExclusiveDeviationAlarmType_ConditionSubClassID                                                                       = 16777
	ExclusiveDeviationAlarmType_ConditionSubClassName                                                                     = 16778
	ExclusiveDeviationAlarmType_OutOfServiceState                                                                         = 16779
	ExclusiveDeviationAlarmType_OutOfServiceState_ID                                                                      = 16780
	ExclusiveDeviationAlarmType_OutOfServiceState_Name                                                                    = 16781
	ExclusiveDeviationAlarmType_OutOfServiceState_Number                                                                  = 16782
	ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName                                                    = 16783
	ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime                                                          = 16784
	ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime                                                 = 16785
	ExclusiveDeviationAlarmType_OutOfServiceState_TrueState                                                               = 16786
	ExclusiveDeviationAlarmType_OutOfServiceState_FalseState                                                              = 16787
	ExclusiveDeviationAlarmType_SilenceState                                                                              = 16788
	ExclusiveDeviationAlarmType_SilenceState_ID                                                                           = 16789
	ExclusiveDeviationAlarmType_SilenceState_Name                                                                         = 16790
	ExclusiveDeviationAlarmType_SilenceState_Number                                                                       = 16791
	ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName                                                         = 16792
	ExclusiveDeviationAlarmType_SilenceState_TransitionTime                                                               = 16793
	ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime                                                      = 16794
	ExclusiveDeviationAlarmType_SilenceState_TrueState                                                                    = 16795
	ExclusiveDeviationAlarmType_SilenceState_FalseState                                                                   = 16796
	ExclusiveDeviationAlarmType_AudibleEnabled                                                                            = 16797
	ExclusiveDeviationAlarmType_AudibleSound                                                                              = 16798
	PublishedDataItemsType_DataSetWriterName_Placeholder_MessageSettings                                                  = 16799
	PublishedDataItemsType_DataSetClassID                                                                                 = 16800
	PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterID                                                     = 16801
	PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask                                             = 16802
	ExclusiveDeviationAlarmType_OnDelay                                                                                   = 16803
	ExclusiveDeviationAlarmType_OffDelay                                                                                  = 16804
	ExclusiveDeviationAlarmType_FirstInGroupFlag                                                                          = 16805
	ExclusiveDeviationAlarmType_FirstInGroup                                                                              = 16806
	ExclusiveDeviationAlarmType_AlarmGroup_Placeholder                                                                    = 16807
	ExclusiveDeviationAlarmType_ReAlarmTime                                                                               = 16808
	ExclusiveDeviationAlarmType_ReAlarmRepeatCount                                                                        = 16809
	ExclusiveDeviationAlarmType_Silence                                                                                   = 16810
	ExclusiveDeviationAlarmType_Suppress                                                                                  = 16811
	PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount                                                       = 16812
	ExclusiveDeviationAlarmType_BaseHighHighLimit                                                                         = 16813
	ExclusiveDeviationAlarmType_BaseHighLimit                                                                             = 16814
	ExclusiveDeviationAlarmType_BaseLowLimit                                                                              = 16815
	ExclusiveDeviationAlarmType_BaseLowLowLimit                                                                           = 16816
	ExclusiveDeviationAlarmType_BaseSetpointNode                                                                          = 16817
	NonExclusiveRateOfChangeAlarmType_ConditionSubClassID                                                                 = 16818
	NonExclusiveRateOfChangeAlarmType_ConditionSubClassName                                                               = 16819
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState                                                                   = 16820
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState_ID                                                                = 16821
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name                                                              = 16822
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number                                                            = 16823
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName                                              = 16824
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime                                                    = 16825
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime                                           = 16826
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState                                                         = 16827
	NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState                                                        = 16828
	NonExclusiveRateOfChangeAlarmType_SilenceState                                                                        = 16829
	NonExclusiveRateOfChangeAlarmType_SilenceState_ID                                                                     = 16830
	NonExclusiveRateOfChangeAlarmType_SilenceState_Name                                                                   = 16831
	NonExclusiveRateOfChangeAlarmType_SilenceState_Number                                                                 = 16832
	NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName                                                   = 16833
	NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime                                                         = 16834
	NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime                                                = 16835
	NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState                                                              = 16836
	NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState                                                             = 16837
	NonExclusiveRateOfChangeAlarmType_AudibleEnabled                                                                      = 16838
	NonExclusiveRateOfChangeAlarmType_AudibleSound                                                                        = 16839
	PublishedEventsType_DataSetWriterName_Placeholder_MessageSettings                                                     = 16840
	PublishedEventsType_DataSetClassID                                                                                    = 16841
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate                                         = 16842
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate_InputArguments                          = 16843
	NonExclusiveRateOfChangeAlarmType_OnDelay                                                                             = 16844
	NonExclusiveRateOfChangeAlarmType_OffDelay                                                                            = 16845
	NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag                                                                    = 16846
	NonExclusiveRateOfChangeAlarmType_FirstInGroup                                                                        = 16847
	NonExclusiveRateOfChangeAlarmType_AlarmGroup_Placeholder                                                              = 16848
	NonExclusiveRateOfChangeAlarmType_ReAlarmTime                                                                         = 16849
	NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount                                                                  = 16850
	NonExclusiveRateOfChangeAlarmType_Silence                                                                             = 16851
	NonExclusiveRateOfChangeAlarmType_Suppress                                                                            = 16852
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate_OutputArguments                         = 16853
	NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit                                                                   = 16854
	NonExclusiveRateOfChangeAlarmType_BaseHighLimit                                                                       = 16855
	NonExclusiveRateOfChangeAlarmType_BaseLowLimit                                                                        = 16856
	NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit                                                                     = 16857
	NonExclusiveRateOfChangeAlarmType_EngineeringUnits                                                                    = 16858
	ExclusiveRateOfChangeAlarmType_ConditionSubClassID                                                                    = 16859
	ExclusiveRateOfChangeAlarmType_ConditionSubClassName                                                                  = 16860
	ExclusiveRateOfChangeAlarmType_OutOfServiceState                                                                      = 16861
	ExclusiveRateOfChangeAlarmType_OutOfServiceState_ID                                                                   = 16862
	ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name                                                                 = 16863
	ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number                                                               = 16864
	ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName                                                 = 16865
	ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime                                                       = 16866
	ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime                                              = 16867
	ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState                                                            = 16868
	ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState                                                           = 16869
	ExclusiveRateOfChangeAlarmType_SilenceState                                                                           = 16870
	ExclusiveRateOfChangeAlarmType_SilenceState_ID                                                                        = 16871
	ExclusiveRateOfChangeAlarmType_SilenceState_Name                                                                      = 16872
	ExclusiveRateOfChangeAlarmType_SilenceState_Number                                                                    = 16873
	ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName                                                      = 16874
	ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime                                                            = 16875
	ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime                                                   = 16876
	ExclusiveRateOfChangeAlarmType_SilenceState_TrueState                                                                 = 16877
	ExclusiveRateOfChangeAlarmType_SilenceState_FalseState                                                                = 16878
	ExclusiveRateOfChangeAlarmType_AudibleEnabled                                                                         = 16879
	ExclusiveRateOfChangeAlarmType_AudibleSound                                                                           = 16880
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate                                            = 16881
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate_InputArguments                             = 16882
	DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate_OutputArguments                            = 16883
	DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder                                                      = 16884
	ExclusiveRateOfChangeAlarmType_OnDelay                                                                                = 16885
	ExclusiveRateOfChangeAlarmType_OffDelay                                                                               = 16886
	ExclusiveRateOfChangeAlarmType_FirstInGroupFlag                                                                       = 16887
	ExclusiveRateOfChangeAlarmType_FirstInGroup                                                                           = 16888
	ExclusiveRateOfChangeAlarmType_AlarmGroup_Placeholder                                                                 = 16889
	ExclusiveRateOfChangeAlarmType_ReAlarmTime                                                                            = 16890
	ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount                                                                     = 16891
	ExclusiveRateOfChangeAlarmType_Silence                                                                                = 16892
	ExclusiveRateOfChangeAlarmType_Suppress                                                                               = 16893
	DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder_InputArguments                                       = 16894
	ExclusiveRateOfChangeAlarmType_BaseHighHighLimit                                                                      = 16895
	ExclusiveRateOfChangeAlarmType_BaseHighLimit                                                                          = 16896
	ExclusiveRateOfChangeAlarmType_BaseLowLimit                                                                           = 16897
	ExclusiveRateOfChangeAlarmType_BaseLowLowLimit                                                                        = 16898
	ExclusiveRateOfChangeAlarmType_EngineeringUnits                                                                       = 16899
	DiscreteAlarmType_ConditionSubClassID                                                                                 = 16900
	DiscreteAlarmType_ConditionSubClassName                                                                               = 16901
	DiscreteAlarmType_OutOfServiceState                                                                                   = 16902
	DiscreteAlarmType_OutOfServiceState_ID                                                                                = 16903
	DiscreteAlarmType_OutOfServiceState_Name                                                                              = 16904
	DiscreteAlarmType_OutOfServiceState_Number                                                                            = 16905
	DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName                                                              = 16906
	DiscreteAlarmType_OutOfServiceState_TransitionTime                                                                    = 16907
	DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime                                                           = 16908
	DiscreteAlarmType_OutOfServiceState_TrueState                                                                         = 16909
	DiscreteAlarmType_OutOfServiceState_FalseState                                                                        = 16910
	DiscreteAlarmType_SilenceState                                                                                        = 16911
	DiscreteAlarmType_SilenceState_ID                                                                                     = 16912
	DiscreteAlarmType_SilenceState_Name                                                                                   = 16913
	DiscreteAlarmType_SilenceState_Number                                                                                 = 16914
	DiscreteAlarmType_SilenceState_EffectiveDisplayName                                                                   = 16915
	DiscreteAlarmType_SilenceState_TransitionTime                                                                         = 16916
	DiscreteAlarmType_SilenceState_EffectiveTransitionTime                                                                = 16917
	DiscreteAlarmType_SilenceState_TrueState                                                                              = 16918
	DiscreteAlarmType_SilenceState_FalseState                                                                             = 16919
	DiscreteAlarmType_AudibleEnabled                                                                                      = 16920
	DiscreteAlarmType_AudibleSound                                                                                        = 16921
	DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder_OutputArguments                                      = 16922
	DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder                                                   = 16923
	DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder_InputArguments                                    = 16924
	DataSetFolderType_PublishedDataSetName_Placeholder_DataSetClassID                                                     = 16925
	DiscreteAlarmType_OnDelay                                                                                             = 16926
	DiscreteAlarmType_OffDelay                                                                                            = 16927
	DiscreteAlarmType_FirstInGroupFlag                                                                                    = 16928
	DiscreteAlarmType_FirstInGroup                                                                                        = 16929
	DiscreteAlarmType_AlarmGroup_Placeholder                                                                              = 16930
	DiscreteAlarmType_ReAlarmTime                                                                                         = 16931
	DiscreteAlarmType_ReAlarmRepeatCount                                                                                  = 16932
	DiscreteAlarmType_Silence                                                                                             = 16933
	DiscreteAlarmType_Suppress                                                                                            = 16934
	DataSetFolderType_AddPublishedDataItemsTemplate                                                                       = 16935
	OffNormalAlarmType_ConditionSubClassID                                                                                = 16936
	OffNormalAlarmType_ConditionSubClassName                                                                              = 16937
	OffNormalAlarmType_OutOfServiceState                                                                                  = 16938
	OffNormalAlarmType_OutOfServiceState_ID                                                                               = 16939
	OffNormalAlarmType_OutOfServiceState_Name                                                                             = 16940
	OffNormalAlarmType_OutOfServiceState_Number                                                                           = 16941
	OffNormalAlarmType_OutOfServiceState_EffectiveDisplayName                                                             = 16942
	OffNormalAlarmType_OutOfServiceState_TransitionTime                                                                   = 16943
	OffNormalAlarmType_OutOfServiceState_EffectiveTransitionTime                                                          = 16944
	OffNormalAlarmType_OutOfServiceState_TrueState                                                                        = 16945
	OffNormalAlarmType_OutOfServiceState_FalseState                                                                       = 16946
	OffNormalAlarmType_SilenceState                                                                                       = 16947
	OffNormalAlarmType_SilenceState_ID                                                                                    = 16948
	OffNormalAlarmType_SilenceState_Name                                                                                  = 16949
	OffNormalAlarmType_SilenceState_Number                                                                                = 16950
	OffNormalAlarmType_SilenceState_EffectiveDisplayName                                                                  = 16951
	OffNormalAlarmType_SilenceState_TransitionTime                                                                        = 16952
	OffNormalAlarmType_SilenceState_EffectiveTransitionTime                                                               = 16953
	OffNormalAlarmType_SilenceState_TrueState                                                                             = 16954
	OffNormalAlarmType_SilenceState_FalseState                                                                            = 16955
	OffNormalAlarmType_AudibleEnabled                                                                                     = 16956
	OffNormalAlarmType_AudibleSound                                                                                       = 16957
	DataSetFolderType_AddPublishedDataItemsTemplate_InputArguments                                                        = 16958
	DataSetFolderType_AddPublishedDataItemsTemplate_OutputArguments                                                       = 16959
	DataSetFolderType_AddPublishedEventsTemplate                                                                          = 16960
	DataSetFolderType_AddPublishedEventsTemplate_InputArguments                                                           = 16961
	OffNormalAlarmType_OnDelay                                                                                            = 16962
	OffNormalAlarmType_OffDelay                                                                                           = 16963
	OffNormalAlarmType_FirstInGroupFlag                                                                                   = 16964
	OffNormalAlarmType_FirstInGroup                                                                                       = 16965
	OffNormalAlarmType_AlarmGroup_Placeholder                                                                             = 16966
	OffNormalAlarmType_ReAlarmTime                                                                                        = 16967
	OffNormalAlarmType_ReAlarmRepeatCount                                                                                 = 16968
	OffNormalAlarmType_Silence                                                                                            = 16969
	OffNormalAlarmType_Suppress                                                                                           = 16970
	DataSetFolderType_AddPublishedEventsTemplate_OutputArguments                                                          = 16971
	SystemOffNormalAlarmType_ConditionSubClassID                                                                          = 16972
	SystemOffNormalAlarmType_ConditionSubClassName                                                                        = 16973
	SystemOffNormalAlarmType_OutOfServiceState                                                                            = 16974
	SystemOffNormalAlarmType_OutOfServiceState_ID                                                                         = 16975
	SystemOffNormalAlarmType_OutOfServiceState_Name                                                                       = 16976
	SystemOffNormalAlarmType_OutOfServiceState_Number                                                                     = 16977
	SystemOffNormalAlarmType_OutOfServiceState_EffectiveDisplayName                                                       = 16978
	SystemOffNormalAlarmType_OutOfServiceState_TransitionTime                                                             = 16979
	SystemOffNormalAlarmType_OutOfServiceState_EffectiveTransitionTime                                                    = 16980
	SystemOffNormalAlarmType_OutOfServiceState_TrueState                                                                  = 16981
	SystemOffNormalAlarmType_OutOfServiceState_FalseState                                                                 = 16982
	SystemOffNormalAlarmType_SilenceState                                                                                 = 16983
	SystemOffNormalAlarmType_SilenceState_ID                                                                              = 16984
	SystemOffNormalAlarmType_SilenceState_Name                                                                            = 16985
	SystemOffNormalAlarmType_SilenceState_Number                                                                          = 16986
	SystemOffNormalAlarmType_SilenceState_EffectiveDisplayName                                                            = 16987
	SystemOffNormalAlarmType_SilenceState_TransitionTime                                                                  = 16988
	SystemOffNormalAlarmType_SilenceState_EffectiveTransitionTime                                                         = 16989
	SystemOffNormalAlarmType_SilenceState_TrueState                                                                       = 16990
	SystemOffNormalAlarmType_SilenceState_FalseState                                                                      = 16991
	SystemOffNormalAlarmType_AudibleEnabled                                                                               = 16992
	SystemOffNormalAlarmType_AudibleSound                                                                                 = 16993
	DataSetFolderType_AddDataSetFolder                                                                                    = 16994
	DataSetFolderType_AddDataSetFolder_InputArguments                                                                     = 16995
	DataSetFolderType_AddDataSetFolder_OutputArguments                                                                    = 16996
	DataSetFolderType_RemoveDataSetFolder                                                                                 = 16997
	SystemOffNormalAlarmType_OnDelay                                                                                      = 16998
	SystemOffNormalAlarmType_OffDelay                                                                                     = 16999
	SystemOffNormalAlarmType_FirstInGroupFlag                                                                             = 17000
	SystemOffNormalAlarmType_FirstInGroup                                                                                 = 17001
	SystemOffNormalAlarmType_AlarmGroup_Placeholder                                                                       = 17002
	SystemOffNormalAlarmType_ReAlarmTime                                                                                  = 17003
	SystemOffNormalAlarmType_ReAlarmRepeatCount                                                                           = 17004
	SystemOffNormalAlarmType_Silence                                                                                      = 17005
	SystemOffNormalAlarmType_Suppress                                                                                     = 17006
	DataSetFolderType_RemoveDataSetFolder_InputArguments                                                                  = 17007
	TripAlarmType_ConditionSubClassID                                                                                     = 17008
	TripAlarmType_ConditionSubClassName                                                                                   = 17009
	TripAlarmType_OutOfServiceState                                                                                       = 17010
	TripAlarmType_OutOfServiceState_ID                                                                                    = 17011
	TripAlarmType_OutOfServiceState_Name                                                                                  = 17012
	TripAlarmType_OutOfServiceState_Number                                                                                = 17013
	TripAlarmType_OutOfServiceState_EffectiveDisplayName                                                                  = 17014
	TripAlarmType_OutOfServiceState_TransitionTime                                                                        = 17015
	TripAlarmType_OutOfServiceState_EffectiveTransitionTime                                                               = 17016
	TripAlarmType_OutOfServiceState_TrueState                                                                             = 17017
	TripAlarmType_OutOfServiceState_FalseState                                                                            = 17018
	TripAlarmType_SilenceState                                                                                            = 17019
	TripAlarmType_SilenceState_ID                                                                                         = 17020
	TripAlarmType_SilenceState_Name                                                                                       = 17021
	TripAlarmType_SilenceState_Number                                                                                     = 17022
	TripAlarmType_SilenceState_EffectiveDisplayName                                                                       = 17023
	TripAlarmType_SilenceState_TransitionTime                                                                             = 17024
	TripAlarmType_SilenceState_EffectiveTransitionTime                                                                    = 17025
	TripAlarmType_SilenceState_TrueState                                                                                  = 17026
	TripAlarmType_SilenceState_FalseState                                                                                 = 17027
	TripAlarmType_AudibleEnabled                                                                                          = 17028
	TripAlarmType_AudibleSound                                                                                            = 17029
	AddPublishedDataItemsTemplateMethodType                                                                               = 17030
	AddPublishedDataItemsTemplateMethodType_InputArguments                                                                = 17031
	AddPublishedDataItemsTemplateMethodType_OutputArguments                                                               = 17032
	AddPublishedEventsTemplateMethodType                                                                                  = 17033
	TripAlarmType_OnDelay                                                                                                 = 17034
	TripAlarmType_OffDelay                                                                                                = 17035
	TripAlarmType_FirstInGroupFlag                                                                                        = 17036
	TripAlarmType_FirstInGroup                                                                                            = 17037
	TripAlarmType_AlarmGroup_Placeholder                                                                                  = 17038
	TripAlarmType_ReAlarmTime                                                                                             = 17039
	TripAlarmType_ReAlarmRepeatCount                                                                                      = 17040
	TripAlarmType_Silence                                                                                                 = 17041
	TripAlarmType_Suppress                                                                                                = 17042
	AddPublishedEventsTemplateMethodType_InputArguments                                                                   = 17043
	CertificateExpirationAlarmType_ConditionSubClassID                                                                    = 17044
	CertificateExpirationAlarmType_ConditionSubClassName                                                                  = 17045
	CertificateExpirationAlarmType_OutOfServiceState                                                                      = 17046
	CertificateExpirationAlarmType_OutOfServiceState_ID                                                                   = 17047
	CertificateExpirationAlarmType_OutOfServiceState_Name                                                                 = 17048
	CertificateExpirationAlarmType_OutOfServiceState_Number                                                               = 17049
	CertificateExpirationAlarmType_OutOfServiceState_EffectiveDisplayName                                                 = 17050
	CertificateExpirationAlarmType_OutOfServiceState_TransitionTime                                                       = 17051
	CertificateExpirationAlarmType_OutOfServiceState_EffectiveTransitionTime                                              = 17052
	CertificateExpirationAlarmType_OutOfServiceState_TrueState                                                            = 17053
	CertificateExpirationAlarmType_OutOfServiceState_FalseState                                                           = 17054
	CertificateExpirationAlarmType_SilenceState                                                                           = 17055
	CertificateExpirationAlarmType_SilenceState_ID                                                                        = 17056
	CertificateExpirationAlarmType_SilenceState_Name                                                                      = 17057
	CertificateExpirationAlarmType_SilenceState_Number                                                                    = 17058
	CertificateExpirationAlarmType_SilenceState_EffectiveDisplayName                                                      = 17059
	CertificateExpirationAlarmType_SilenceState_TransitionTime                                                            = 17060
	CertificateExpirationAlarmType_SilenceState_EffectiveTransitionTime                                                   = 17061
	CertificateExpirationAlarmType_SilenceState_TrueState                                                                 = 17062
	CertificateExpirationAlarmType_SilenceState_FalseState                                                                = 17063
	CertificateExpirationAlarmType_AudibleEnabled                                                                         = 17064
	CertificateExpirationAlarmType_AudibleSound                                                                           = 17065
	AddPublishedEventsTemplateMethodType_OutputArguments                       