// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef SYMBOL_FACTORY_IS_INCLUDED
#define SYMBOL_FACTORY_IS_INCLUDED

#include <string>

#include <ginac/ginac.h>

namespace SyFi
{

	// TODO: make a class SymbolSpace or something
	/*
	class SpaceSymbols
	{
	public:
	  SpaceSymbols(int nsd_, const std::string & base_name);

	int nsd() const;
	GiNaC::symbol x(int i) const;
	GiNaC::symbol t() const;
	};

	ex diff(e, i, ss=default_ss, ss2=default_ss2);
	ex div(e, ss=default_ss, ss2=default_ss2);
	ex grad(e, ss=default_ss, ss2=default_ss2);
	*/

	// Initialize global variables of SyFi
	void initSyFi(unsigned int nsd);

	// spacial variables, used by differential operators
	extern unsigned int nsd;
	extern GiNaC::symbol x;
	extern GiNaC::symbol y;
	extern GiNaC::symbol z;
	extern GiNaC::symbol t;
	extern GiNaC::lst    p;

	// utility symbols
	extern GiNaC::symbol infinity;
	extern GiNaC::symbol DUMMY;

	// ===== symbol factory

	// TODO: is it useful to make a singleton for this?

	bool symbol_exists(const std::string & name);

	// TODO: we don't need the const & ?
	const GiNaC::symbol & get_symbol(const std::string & name);

	const GiNaC::symbol & isymb(const std::string & a, int b);
	const GiNaC::symbol & isymb(const std::string & a, int b, int c);

	GiNaC::ex get_symbolic_vector(int m, const std::string & basename);

	GiNaC::ex get_symbolic_matrix(int m, int n, const std::string & basename);

}								 // namespace SyFi
#endif
