/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CATCMD_H
#define _SC_CATCMD_H

// sc
#include "ScCmd.h"
class CatParam;
class CmdResultCallback;


/**
 * Command for cating files or dirs from the repository or a working copy.
 */
class CatCmd : public ScCmd
{
public:
  /**
   * Construct an CatCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  CatCmd( CatParam* param, CmdResultCallback* cb );
  ~CatCmd();

  void run();

private:
  // in
  CatParam*          _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_CATCMD_H
