# Contributing to [SQLGlot](https://github.com/tobymao/sqlglot/blob/main/README.md)

SQLGLot is open source software. We value feedback and we want to make contributing to this project as
easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features

## We develop with Github
We use github to host code, to track issues and feature requests, as well as accept pull requests.

## Submitting code changes
Pull requests are the best way to propose changes to the codebase. We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite & linter [checks](https://github.com/tobymao/sqlglot/blob/main/README.md#run-tests-and-lint) pass.
5. Issue that pull request and wait for it to be reviewed by a maintainer or contributor!

Note: make sure to follow the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) guidelines when creating a PR.

## Report bugs using Github's [issues](https://github.com/tobymao/sqlglot/issues)
We use GitHub issues to track public bugs. Report a bug by opening a new issue.

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give sample code if you can
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)
- References (e.g. documentation pages related to the issue)

## Start a discussion using Github's [discussions](https://github.com/tobymao/sqlglot/discussions)
[We use GitHub discussions](https://github.com/tobymao/sqlglot/discussions/190) to discuss about the current state
of the code. If you want to propose a new feature, this is the right place to do it! Just start a discussion, and
let us know why you think this feature would be a good addition to SQLGlot (by possibly including some usage examples).

## [License](https://github.com/tobymao/sqlglot/blob/main/LICENSE)
By contributing, you agree that your contributions will be licensed under its MIT License.

## References
This document was adapted from [briandk's template](https://gist.github.com/briandk/3d2e8b3ec8daf5a27a62).
