2.4 Durées avec enveloppes

# Durées avec enveloppes

Dans une section précédente, nous avons vu comment nous pouvions utiliser
la commande sleep pour contrôler le moment du déclenchement de nos sons.
Toutefois, nous n'avons pas encore été capables de contrôler la durée
des sons.

Dans le but de nous offrir des moyens simples mais puissants de
*contrôle de durée* de nos sons, Sonic Pi fournit la technique
d'*enveloppe d'amplitude ADSR* (nous expliquerons ce que ADSR signifie
plus loin dans cette section). Une enveloppe d'amplitude offre deux
moyens utiles de contrôle :

* contrôle sur la durée d'un son
* contrôle sur l'amplitude d'un son

## Durée

La durée est le temps pendant lequel le son se maintient. Une
longue durée signifie que vous entendez le son plus longtemps. Les sons
de Sonic Pi ont tous une enveloppe d'amplitude, et la durée totale de
cette enveloppe est la durée du son. Ainsi, en contrôlant l'enveloppe,
vous contrôlez la durée.

## Amplitude

L'enveloppe ADSR non seulement contrôle la durée, mais vous donne aussi
*un contrôle fin sur l'amplitude du son*. Tous les sons commencent et
finissent par le silence, avec une part non silencieuse entre. Les
enveloppes vous permettent de faire évoluer ou de maintenir l'amplitude
des parties non-silencieuses du son. C'est comme si vous donniez à
quelqu'un des instructions sur comment augmenter ou diminuer le volume
d'une musique. Par exemple, vous pourriez demander à quelqu'un de commencer
en silence, d'augmenter lentement le volume jusqu'au maximum, le 
maintenir un moment, puis revenir rapidement au silence. Sonic Pi vous 
permet de programmer ceci avec les enveloppes.

Comme nous l'avions vu dans une section précédente, une amplitude de 
0 est le silence et une amplitude de 1 est le volume normal.

## Durée d'extinction (Release)

Par défaut, tous les synthés ont une durée de "release" de 1. Ce qui 
signifie qu'ils ont une durée d'un temps musical (qui par défaut est 1 seconde)
avant extinction. Nous pouvons changer cette durée en passant l'argument
`release:` à nos appels à `play`. Par exemple, pour faire jouer un synthé
pendant 2 temps, nous spécifions un `release:` de `2`:

```
play 60, release: 2
```

Nous pouvons faire jouer un synthé pendant une très courte durée en 
utilisant une durée de "release" très petite :

```
play 60, release: 0.2
```

Ainsi, qu'est-ce que la durée de "release" ? C'est la durée que prend 
le son pour passer de l'amplitude totale (typiquement une valeur de 1) 
à l'amplitude 0. C'est appelé la *phase d'extinction* et c'est une
transition linéaire (une courbe en ligne droite). Le schéma suivant
illustre cette transition :

![release envelope](../images/tutorial/env-release.png)


La ligne verticale à gauche du schéma montre que le son part de 
l'amplitude 0, mais monte jusqu'à l'amplitude totale immédiatement 
(c'est la phase d'attaque que nous couvrirons en suivant). Une fois à 
l'amplitude totale, il évolue en ligne droite jusqu'à zéro en 
prenant le temps spécifié par `release:`. *Des durées de "release" 
longues produisent des fondus d'extinction de synthé longs*.

Vous pouvez ainsi changer la durée de vos sons en changeant la durée 
d'extinction. Jouez un moment en ajoutant des durées de "release" à 
votre musique.

## Durée d'Attaque

Par défaut, la phase d'attaque est fixée à 0 pour tous les synthés, ce qui 
signifie qu'ils évoluent de l'amplitude 0 à l'amplitude 1 immédiatement. 
Cela donne initialement au synthé un son percussif. Toutefois, vous 
pouvez souhaiter une montée progressive de votre son. Ceci peut être 
obtenu avec l'argument `attack:`. Essayez des montées progressives de 
quelques sons :

```
play 60, attack: 2
sleep 3
play 65, attack: 0.5
```

Vous pouvez utiliser des arguments multiples en même temps. Par 
exemple, pour une attaque courte et une lente extinction, essayez :

```
play 60, attack: 0.7, release: 4
```

Cette courte attaque et cette lente extinction sont illustrées dans le 
schéma suivant :

![attack release envelope](../images/tutorial/env-attack-release.png)

Bien entendu, vous pouvez inverser les choses. Essayez une attaque 
longue et une exctinction rapide :

```
play 60, attack: 4, release: 0.7
```

![long attack short release envelope](../images/tutorial/env-long-attack-short-release.png)

Finalement, vous pouvez aussi avoir à la fois une attaque et une 
exctinction rapides pour des sons plus courts :

```
play 60, attack: 0.5, release: 0.5
```

![short attack short release envelope](../images/tutorial/env-short-attack-short-release.png)

## Durée de soutien ("Sustain")

En plus de spécifier des durées d'attaque et d'extinction, vous 
pouvez aussi spécifier une durée de soutien. C'est la durée pendant 
laquelle le son est maintenu à l'amplitude totale entre les phases 
d'attaque et d'extinction.

```
play 60, attack: 0.3, sustain: 1, release: 1
```

![ASR envelope](../images/tutorial/env-attack-sustain-release.png)

La durée de soutien est utile pour des sons importants auxquels vous 
voulez donner une présence permanente dans le mixage avant d'entrer 
dans une optionnelle phase d'extinction. Bien entendu, c'est 
entièrement valide de fixer à la fois les arguments d'attaque et 
d'extinction à 0 et d'utiliser seulement le soutien pour n'avoir 
absolument pas de montée et d'extinction progressives. Cependant, 
faites attention, une durée d'extinction de 0 peut produire des clics 
dans l'écoute et c'est souvent mieux d'utiliser une très petite 
valeur comme 0.2.

## Durée de déclin ("Decay")


Finalement, pour les cas où vous aurez besoin d'un niveau de 
contrôle supplémentaire, vous pourrez aussi spécifier une durée de 
déclin. C'est la phase de l'enveloppe qui s'intercale entre les phases 
d'attaque et de soutien et qui spécifie la durée pendant laquelle l'amplitude va 
descendre du niveau `attack_level` jusqu'au niveau `sustain_level`.
Par défaut, l'argument "decay" est à 0 et à la fois les niveaux "attack" et 
"sustain" sont à 1. Ainsi vous aurez besoin de les spécifier en plus 
de la durée de déclin pour obtenir un effet :

```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, sustain_level: 0.4, sustain: 1, release: 0.5
```

![ADSR envelope](../images/tutorial/env-attack-decay-sustain-release.png)

## Enveloppes ADSR 

Ainsi pour résumer, les enveloppes de Sonic Pi ont les phases suivantes :

1. *attack* - durée de passage de l'amplitude 0 jusqu'au niveau `attack_level`,
2. *decay* - durée pour passer l'amplitude du niveau `attack_level` 
   jusqu'au niveau `sustain_level`,
3. *sustain* - durée pour maintenir l'amplitude au niveau `sustain_level`,
4. *release* - durée pour passer l'amplitude du niveau `sustain_level` 
   au niveau 0


Il est important de noter que la durée d'un son est la somme des 
durées de chacune de ces phases. Ainsi le son suivant aura une durée 
de 0.5 + 1 + 2 + 0.5 = 4 temps musicaux :

```
play 60, attack: 0.5, decay: 1, sustain_level: 0.4, sustain: 2, release: 0.5
```

Maintenant, allez et jouez un moment en ajoutant des enveloppes à vos sons.
