/* Public domain. */

#include <errno.h>
#include "stralloc.h"
#include "env.h"

char const *ucspi_get_tmp (char const *s, stralloc *tmp)
{
  unsigned int tmpbase = tmp->len ;
  char const *x = env_get("PROTO") ;
  if (!x) return (errno = EINVAL, (char const *)0) ;
  if (!stralloc_cats(tmp, x)) return 0 ;
  if (!stralloc_cats(tmp, s) || !stralloc_0(tmp))
  {
    tmp->len = tmpbase ;
    return 0 ;
  }
  x = env_get(tmp->s + tmpbase) ;
  tmp->len = tmpbase ;
  if (!x) errno = EINVAL ;
  return x ;
}
