/* Public domain. */

#include <errno.h>
#include "error.h"
#include "dns_helper.h"

unsigned int dns_packet_skipname (char const *buf, unsigned int len, unsigned int pos)
{
  for (;;)
  {
    register unsigned char ch ;
    if (pos >= len) break ;
    ch = buf[pos++] ;
    if (ch >= 192) return pos + 1 ;
    if (ch >= 64) break ;
    if (!ch) return pos ;
    pos += ch ;
  }
  errno = EPROTO ;
  return 0 ;
}
