/* Public domain. */

#ifndef AVLTREE_H
#define AVLTREE_H

#include "gccattributes.h"
#include "avlnodebunch.h"


#define AVLTREE_ZERO { GEN_BUNCH_ZERO, 0 }
#define avltree_i(t, i) ((i) ? ((t)->x.x.s[i].data) : 0)
#define avltree_len(t) ((t)->x.n - 1)
#define avltree_root(t) ((t)->x.x.s[0].left)
#define avltree_setroot(t, r) ((t)->x.x.s[0].left = (r))

typedef struct avltree avltree, *avltree_ref ;
struct avltree
{
  avlnodebunch x ;
  int (*cmp)(unsigned int, unsigned int) ;
} ;


extern void avltree_free (avltree_ref) ;
extern int avltree_init (avltree_ref, int (*)(unsigned int, unsigned int)) ;
extern unsigned int avltree_search (avltree const *, unsigned int) gccattr_pure ;
extern unsigned int avltree_insert (avltree_ref, unsigned int) ;
extern unsigned int avltree_delete (avltree_ref, unsigned int) ;
extern unsigned int avltree_deletenode (avltree_ref, unsigned int) ;
extern unsigned int avltree_height (avltree const *) gccattr_pure ;
extern int avltree_iter (avltree_ref, int (*)(unsigned int, unsigned int, void *), void *) ;


#endif
