/* Public domain. */

#include "uint32.h"
#include "uint64.h"
#include "biguint.h"

static inline unsigned char uint32_subc (register uint32 *c, register uint32 a, register uint32 b, register unsigned char carry)
{
  register uint64 t = 1 ;
  t <<= 32 ;
  t += a ;
  t -= b ;
  if (carry) t-- ;
  *c = (uint32)t ;
  return (t <= 0xffffffffUL) ;
}

unsigned char bu_subc (register uint32 *c, register uint32 const *a, register uint32 const *b, register unsigned int n, register unsigned char carry)
{
  register unsigned int i = 0 ;
  for (; i < n ; i++)
    carry = uint32_subc(c+i, a[i], b[i], carry) ;
  return carry ;
}
