/* Public domain. */

#include "uint32.h"
#include "biguint.h"

void bu_div_unsafe (uint32 const *a, uint32 const *b, uint32 *q, uint32 *r, unsigned int n)
{
  uint32 btmp[BIGUINT_MAXLIMBS] ;
  unsigned int alen = bu_len(a, n) ;
  unsigned int blen = bu_len(b, n) ;
  unsigned int i = alen - blen ;
  unsigned char bshift = 0 ;

  bu_copy(r, a, n) ;
  bu_zero(btmp, i) ;
  bu_copy(btmp + i, b, blen) ;
  bu_zero(btmp + alen, BIGUINT_MAXLIMBS - alen) ;
  while (!(btmp[alen-1] & 0x80000000UL))
  {
    bu_slb(btmp, alen) ;
    bshift++ ;
  }

  i++ ;
  while (i--)
  {
    unsigned int j = 0 ;
    q[i] = 0 ;
    for (; j < 32 ; j++)
    {
      q[i] <<= 1 ;
      if (bu_cmp(r, btmp, blen + i) >= 0)
      {
        bu_sub(r, r, btmp, blen + i) ;
        q[i] |= 1 ;
      }
      bu_srb(btmp, blen + i) ;
    }
  }

  while (bshift--)
  {
    bu_slb(q, alen - blen + 1) ;
    if (bu_cmp(r, btmp, blen) >= 0)
    {
      bu_sub(r, r, btmp, blen) ;
      q[0] |= 1 ;
    }
    bu_srb(btmp, blen) ;
  }
}
