/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace Supernova {

static const Screen::ImageInfo imageInfo[] = {
	{ 0,  0}, { 0,  1}, { 0,  2},
	{ 1,  0},
	{ 2,  0},
	{ 3,  0}, { 3,  1}, { 3,  2}, { 3,  3}, { 3,  4}, { 3,  5},
	{ 3,  6}, { 3,  7}, { 3,  8}, { 3,  9}, { 3, 10}, { 3, 11},
	{ 4,  0}, { 4,  1}, { 4,  2}, { 4,  3},
	{ 5,  0}, { 5,  1}, { 5,  2}, { 5,  3}, { 5,  4}, { 5,  5},
	{ 5,  6}, { 5,  7}, { 5,  8}, { 5,  9},
	{ 6,  0}, { 6,  1}, { 6,  2}, { 6,  3}, { 6,  4}, { 6,  5},
	{ 6,  6}, { 6,  7}, { 6,  8}, { 6,  9}, { 6, 10}, { 6, 11},
	{ 6, 12}, { 6, 13}, { 6, 14}, { 6, 15}, { 6, 16}, { 6, 17},
	{ 6, 18}, { 6, 19}, { 6, 20}, { 6, 21},
	{ 7,  0}, { 7,  1}, { 7,  2}, { 7,  3}, { 7,  4}, { 7,  5},
	{ 7,  6}, { 7,  7}, { 7,  8}, { 7,  9}, { 7, 10}, { 7, 11},
	{ 7, 12}, { 7, 13}, { 7, 14}, { 7, 15}, { 7, 16}, { 7, 17},
	{ 7, 18}, { 7, 19}, { 7, 20}, { 7, 21}, { 7, 22},
	{ 8,  0}, { 8,  1}, { 8,  2}, { 8,  3}, { 8,  4}, { 8,  5},
	{ 8,  6}, { 8,  7}, { 8,  8}, { 8,  9}, { 8, 10}, { 8, 11},
	{ 8, 12},
	{ 9,  0}, { 9,  1}, { 9,  2}, { 9,  3}, { 9,  4}, { 9,  5},
	{ 9,  6}, { 9,  7}, { 9,  8}, { 9,  9}, { 9, 10}, { 9, 11},
	{ 9, 12}, { 9, 13}, { 9, 14}, { 9, 15}, { 9, 16}, { 9, 17},
	{ 9, 18}, { 9, 19}, { 9, 20}, { 9, 21}, { 9, 22}, { 9, 23},
	{10,  0}, {10,  1}, {10,  2}, {10,  3}, {10,  4}, {10,  5},
	{10,  6}, {10,  7}, {10,  8}, {10,  9}, {10, 10}, {10, 11},
	{10, 12}, {10, 13}, {10, 14}, {10, 15}, {10, 16},
	{11,  0},
	{12,  0}, {12,  1}, {12,  2}, {12,  3},
	{13,  0}, {13,  1}, {13,  2}, {13,  3}, {13,  4}, {13,  5},
	{13,  6}, {13,  7}, {13,  8}, {13,  9}, {13, 10}, {13, 11},
	{13, 12}, {13, 13},
	{14,  0}, {14,  1}, {14,  2}, {14,  3}, {14,  4}, {14,  5},
	{14,  6}, {14,  7}, {14,  8}, {14,  9}, {14, 10}, {14, 11},
	{14, 12}, {14, 13}, {14, 14}, {14, 15}, {14, 16}, {14, 17},
	{14, 18}, {14, 19},
	{15,  0}, {15,  1}, {15,  2}, {15,  3}, {15,  4}, {15,  5},
	{16,  0}, {16,  1}, {16,  2}, {16,  3}, {16,  4}, {16,  5},
	{16,  6}, {16,  7}, {16,  8}, {16,  9}, {16, 10}, {16, 11},
	{16, 12}, {16, 13}, {16, 14}, {16, 15}, {16, 16}, {16, 17},
	{16, 18}, {16, 19}, {16, 20}, {16, 21}, {16, 22}, {16, 23},
	{16, 24}, {16, 25}, {16, 26}, {16, 27}, {16, 28}, {16, 29},
	{16, 30}, {16, 31}, {16, 32}, {16, 33},
	{17,  0}, {17,  1}, {17,  2}, {17,  3}, {17,  4}, {17,  5},
	{17,  6}, {17,  7}, {17,  8}, {17,  9}, {17, 10}, {17, 11},
	{17, 12}, {17, 13}, {17, 14}, {17, 15},
	{18,  0}, {18,  1}, {18,  2}, {18,  3}, {18,  4}, {18,  5},
	{18,  6}, {18,  7}, {18,  8}, {18,  9}, {18, 10}, {18, 11},
	{18, 12}, {18, 13}, {18, 14}, {18, 15}, {18, 16}, {18, 17},
	{18, 18}, {18, 19}, {18, 20}, {18, 21},
	{19,  0}, {19,  1}, {19,  2}, {19,  3}, {19,  4}, {19,  5},
	{19,  6}, {19,  7}, {19,  8}, {19,  9}, {19, 10}, {19, 11},
	{19, 12}, {19, 13}, {19, 14}, {19, 15}, {19, 16}, {19, 17},
	{19, 18}, {19, 19}, {19, 20}, {19, 21}, {19, 22}, {19, 23},
	{19, 24}, {19, 25}, {19, 26}, {19, 27}, {19, 28}, {19, 29},
	{19, 30}, {19, 31}, {19, 32}, {19, 33}, {19, 34}, {19, 35},
	{19, 36}, {19, 37}, {19, 38}, {19, 39}, {19, 40},
	{20,  0},
	{21,  0}, {21,  1}, {21,  2}, {21,  3}, {21,  4}, {21,  5},
	{21,  6}, {21,  7}, {21,  8}, {21,  9}, {21, 10}, {21, 11},
	{21, 12}, {21, 13}, {21, 14}, {21, 15}, {21, 16}, {21, 17},
	{21, 18}, {21, 19}, {21, 20}, {21, 21}, {21, 22}, {21, 23},
	{21, 24}, {21, 25}, {21, 26}, {21, 27}, {21, 28}, {21, 29},
	{21, 30}, {21, 31}, {21, 32}, {21, 33}, {21, 34}, {21, 35},
	{21, 36}, {21, 37}, {21, 38},
	{22,  0}, {22,  1}, {22,  2}, {22,  3}, {22,  4}, {22,  5},
	{22,  6}, {22,  7}, {22,  8}, {22,  9}, {22, 10}, {22, 11},
	{22, 12}, {22, 13}, {22, 14}, {22, 15}, {22, 16}, {22, 17},
	{22, 18},
	{23,  0},
	{24,  0}, {24,  1}, {24,  2}, {24,  3}, {24,  4}, {24,  5},
	{24,  6}, {24,  7}, {24,  8},
	{25,  0}, {25,  1}, {25,  2}, {25,  3}, {25,  4}, {25,  5},
	{25,  6}, {25,  7}, {25,  8}, {25,  9}, {25, 10}, {25, 11},
	{25, 12}, {25, 13}, {25, 14}, {25, 15}, {25, 16}, {25, 17},
	{25, 18},
	{26,  0},
	{27,  0},
	{28,  0}, {28,  1}, {28,  2}, {28,  3}, {28,  4}, {28,  5},
	{28,  6}, {28,  7}, {28,  8}, {28,  9}, {28, 10}, {28, 11},
	{28, 12}, {28, 13}, {28, 14}, {28, 15}, {28, 16}, {28, 17},
	{28, 18}, {28, 19}, {28, 20}, {28, 21}, {28, 22},
	{29,  0}, {29,  1}, {29,  2}, {29,  3}, {29,  4}, {29,  5},
	{29,  6}, {29,  7}, {29,  8}, {29,  9}, {29, 10}, {29, 11},
	{29, 12}, {29, 13},
	{30,  0}, {30,  1},
	{31,  0}, {31,  1}, {31,  2}, {31,  3}, {31,  4}, {31,  5},
	{31,  6},
	{32,  0}, {32,  1}, {32,  2}, {32,  3},
	{33,  0}, {33,  1}, {33,  2}, {33,  3}, {33,  4}, {33,  5},
	{34,  0}, {34,  1}, {34,  2}, {34,  3}, {34,  4}, {34,  5},
	{34,  6}, {34,  7}, {34,  8}, {34,  9}, {34, 10}, {34, 11},
	{34, 12}, {34, 13}, {34, 14}, {34, 15}, {34, 16}, {34, 17},
	{35,  0}, {35,  1}, {35,  2}, {35,  3}, {35,  4}, {35,  5},
	{35,  6}, {35,  7}, {35,  8}, {35,  9}, {35, 10}, {35, 11},
	{35, 12}, {35, 13}, {35, 14}, {35, 15}, {35, 16}, {35, 17},
	{35, 18}, {35, 19}, {35, 20}, {35, 21},
	{36,  0}, {36,  1}, {36,  2}, {36,  3}, {36,  4}, {36,  5},
	{37,  0}, {37,  1}, {37,  2}, {37,  3}, {37,  4}, {37,  5},
	{37,  6}, {37,  7}, {37,  8}, {37,  9}, {37, 10}, {37, 11},
	{37, 12}, {37, 13}, {37, 14}, {37, 15}, {37, 16}, {37, 17},
	{37, 18}, {37, 19}, {37, 20}, {37, 21}, {37, 22}, {37, 23},
	{37, 24}, {37, 25}, {37, 26},
	{38,  0}, {38,  1}, {38,  2}, {38,  3}, {38,  4}, {38,  5},
	{38,  6}, {38,  7}, {38,  8}, {38,  9}, {38, 10}, {38, 11},
	{38, 12},
	{39,  0},
	{40,  0}, {40,  1}, {40,  2}, {40,  3}, {40,  4}, {40,  5},
	{40,  6}, {40,  7},
	{41,  0}, {41,  1}, {41,  2}, {41,  3},
	{42,  0}, {42,  1}, {42,  2}, {42,  3}, {42,  4}, {42,  5},
	{42,  6}, {42,  7},	{42,  8}, {42,  9}, {42, 10}, {42, 11},
	{43,  0}, {43,  1}, {43,  2}, {43,  3}, {43,  4}, {43,  5},
	{43,  6}, {43,  7}, {43,  8}, {43,  9}, {43, 10}, {43, 11},
	{43, 12}, {43, 13}, {43, 14}, {43, 15}, {43, 16}, {43, 17},
	{43, 18}, {43, 19}, {43, 20}, {43, 21}, {43, 22}, {43, 23},
	{43, 24}, {43, 25}, {43, 26}, {43, 27}, {43, 28}, {43, 29},
	{43, 30}, {43, 31},
	{55,  0}
};

// Default palette
static const byte initVGAPalette[768] = {
	0x00, 0x00, 0x00,
	0x40, 0x40, 0x40,
	0x58, 0x58, 0x58,
	0x70, 0x70, 0x70,
	0xfc, 0xfc, 0xfc,
	0x00, 0xd0, 0x00,
	0x00, 0xfc, 0x00,
	0xd8, 0x00, 0x00,
	0xfc, 0x00, 0x00,
	0x00, 0x00, 0x78,
	0x00, 0x00, 0xb0,
	0xa0, 0xa0, 0xa0,
	0x50, 0xc8, 0xfc,
	0x28, 0xfc, 0x28,
	0xf0, 0xf0, 0x00,
	0xfc, 0x28, 0x28,
	0x00, 0x00, 0x00,
	0x14, 0x14, 0x14,
	0x20, 0x20, 0x20,
	0x2c, 0x2c, 0x2c,
	0x38, 0x38, 0x38,
	0x44, 0x44, 0x44,
	0x50, 0x50, 0x50,
	0x60, 0x60, 0x60,
	0x70, 0x70, 0x70,
	0x80, 0x80, 0x80,
	0x90, 0x90, 0x90,
	0xa0, 0xa0, 0xa0,
	0xb4, 0xb4, 0xb4,
	0xc8, 0xc8, 0xc8,
	0xe0, 0xe0, 0xe0,
	0xfc, 0xfc, 0xfc,
	0x00, 0x00, 0xfc,
	0x40, 0x00, 0xfc,
	0x7c, 0x00, 0xfc,
	0xbc, 0x00, 0xfc,
	0xfc, 0x00, 0xfc,
	0xfc, 0x00, 0xbc,
	0xfc, 0x00, 0x7c,
	0xfc, 0x00, 0x40,
	0xfc, 0x00, 0x00,
	0xfc, 0x40, 0x00,
	0xfc, 0x7c, 0x00,
	0xfc, 0xbc, 0x00,
	0xfc, 0xfc, 0x00,
	0xbc, 0xfc, 0x00,
	0x7c, 0xfc, 0x00,
	0x40, 0xfc, 0x00,
	0x00, 0xfc, 0x00,
	0x00, 0xfc, 0x40,
	0x00, 0xfc, 0x7c,
	0x00, 0xfc, 0xbc,
	0x00, 0xfc, 0xfc,
	0x00, 0xbc, 0xfc,
	0x00, 0x7c, 0xfc,
	0x00, 0x40, 0xfc,
	0x7c, 0x7c, 0xfc,
	0x9c, 0x7c, 0xfc,
	0xbc, 0x7c, 0xfc,
	0xdc, 0x7c, 0xfc,
	0xfc, 0x7c, 0xfc,
	0xfc, 0x7c, 0xdc,
	0xfc, 0x7c, 0xbc,
	0xfc, 0x7c, 0x9c,
	0xfc, 0x7c, 0x7c,
	0xfc, 0x9c, 0x7c,
	0xfc, 0xbc, 0x7c,
	0xfc, 0xdc, 0x7c,
	0xfc, 0xfc, 0x7c,
	0xdc, 0xfc, 0x7c,
	0xbc, 0xfc, 0x7c,
	0x9c, 0xfc, 0x7c,
	0x7c, 0xfc, 0x7c,
	0x7c, 0xfc, 0x9c,
	0x7c, 0xfc, 0xbc,
	0x7c, 0xfc, 0xdc,
	0x7c, 0xfc, 0xfc,
	0x7c, 0xdc, 0xfc,
	0x7c, 0xbc, 0xfc,
	0x7c, 0x9c, 0xfc,
	0xb4, 0xb4, 0xfc,
	0xc4, 0xb4, 0xfc,
	0xd8, 0xb4, 0xfc,
	0xe8, 0xb4, 0xfc,
	0xfc, 0xb4, 0xfc,
	0xfc, 0xb4, 0xe8,
	0xfc, 0xb4, 0xd8,
	0xfc, 0xb4, 0xc4,
	0xfc, 0xb4, 0xb4,
	0xfc, 0xc4, 0xb4,
	0xfc, 0xd8, 0xb4,
	0xfc, 0xe8, 0xb4,
	0xfc, 0xfc, 0xb4,
	0xe8, 0xfc, 0xb4,
	0xd8, 0xfc, 0xb4,
	0xc4, 0xfc, 0xb4,
	0xb4, 0xfc, 0xb4,
	0xb4, 0xfc, 0xc4,
	0xb4, 0xfc, 0xd8,
	0xb4, 0xfc, 0xe8,
	0xb4, 0xfc, 0xfc,
	0xb4, 0xe8, 0xfc,
	0xb4, 0xd8, 0xfc,
	0xb4, 0xc4, 0xfc,
	0x00, 0x00, 0x70,
	0x1c, 0x00, 0x70,
	0x38, 0x00, 0x70,
	0x54, 0x00, 0x70,
	0x70, 0x00, 0x70,
	0x70, 0x00, 0x54,
	0x70, 0x00, 0x38,
	0x70, 0x00, 0x1c,
	0x70, 0x00, 0x00,
	0x70, 0x1c, 0x00,
	0x70, 0x38, 0x00,
	0x70, 0x54, 0x00,
	0x70, 0x70, 0x00,
	0x54, 0x70, 0x00,
	0x38, 0x70, 0x00,
	0x1c, 0x70, 0x00,
	0x00, 0x70, 0x00,
	0x00, 0x70, 0x1c,
	0x00, 0x70, 0x38,
	0x00, 0x70, 0x54,
	0x00, 0x70, 0x70,
	0x00, 0x54, 0x70,
	0x00, 0x38, 0x70,
	0x00, 0x1c, 0x70,
	0x38, 0x38, 0x70,
	0x44, 0x38, 0x70,
	0x54, 0x38, 0x70,
	0x60, 0x38, 0x70,
	0x70, 0x38, 0x70,
	0x70, 0x38, 0x60,
	0x70, 0x38, 0x54,
	0x70, 0x38, 0x44,
	0x70, 0x38, 0x38,
	0x70, 0x44, 0x38,
	0x70, 0x54, 0x38,
	0x70, 0x60, 0x38,
	0x70, 0x70, 0x38,
	0x60, 0x70, 0x38,
	0x54, 0x70, 0x38,
	0x44, 0x70, 0x38,
	0x38, 0x70, 0x38,
	0x38, 0x70, 0x44,
	0x38, 0x70, 0x54,
	0x38, 0x70, 0x60,
	0x38, 0x70, 0x70,
	0x38, 0x60, 0x70,
	0x38, 0x54, 0x70,
	0x38, 0x44, 0x70,
	0x50, 0x50, 0x70,
	0x58, 0x50, 0x70,
	0x60, 0x50, 0x70,
	0x68, 0x50, 0x70,
	0x70, 0x50, 0x70,
	0x70, 0x50, 0x68,
	0x70, 0x50, 0x60,
	0x70, 0x50, 0x58,
	0x70, 0x50, 0x50,
	0x70, 0x58, 0x50,
	0x70, 0x60, 0x50,
	0x70, 0x68, 0x50,
	0x70, 0x70, 0x50,
	0x68, 0x70, 0x50,
	0x60, 0x70, 0x50,
	0x58, 0x70, 0x50,
	0x50, 0x70, 0x50,
	0x50, 0x70, 0x58,
	0x50, 0x70, 0x60,
	0x50, 0x70, 0x68,
	0x50, 0x70, 0x70,
	0x50, 0x68, 0x70,
	0x50, 0x60, 0x70,
	0x50, 0x58, 0x70,
	0x00, 0x00, 0x40,
	0x10, 0x00, 0x40,
	0x20, 0x00, 0x40,
	0x30, 0x00, 0x40,
	0x40, 0x00, 0x40,
	0x40, 0x00, 0x30,
	0x40, 0x00, 0x20,
	0x40, 0x00, 0x10,
	0x40, 0x00, 0x00,
	0x40, 0x10, 0x00,
	0x40, 0x20, 0x00,
	0x40, 0x30, 0x00,
	0x40, 0x40, 0x00,
	0x30, 0x40, 0x00,
	0x20, 0x40, 0x00,
	0x10, 0x40, 0x00,
	0x00, 0x40, 0x00,
	0x00, 0x40, 0x10,
	0x00, 0x40, 0x20,
	0x00, 0x40, 0x30,
	0x00, 0x40, 0x40,
	0x00, 0x30, 0x40,
	0x00, 0x20, 0x40,
	0x00, 0x10, 0x40,
	0x20, 0x20, 0x40,
	0x28, 0x20, 0x40,
	0x30, 0x20, 0x40,
	0x38, 0x20, 0x40,
	0x40, 0x20, 0x40,
	0x40, 0x20, 0x38,
	0x40, 0x20, 0x30,
	0x40, 0x20, 0x28,
	0x40, 0x20, 0x20,
	0x40, 0x28, 0x20,
	0x40, 0x30, 0x20,
	0x40, 0x38, 0x20,
	0x40, 0x40, 0x20,
	0x38, 0x40, 0x20,
	0x30, 0x40, 0x20,
	0x28, 0x40, 0x20,
	0x20, 0x40, 0x20,
	0x20, 0x40, 0x28,
	0x20, 0x40, 0x30,
	0x20, 0x40, 0x38,
	0x20, 0x40, 0x40,
	0x20, 0x38, 0x40,
	0x20, 0x30, 0x40,
	0x20, 0x28, 0x40,
	0x2c, 0x2c, 0x40,
	0x30, 0x2c, 0x40,
	0x34, 0x2c, 0x40,
	0x3c, 0x2c, 0x40,
	0x40, 0x2c, 0x40,
	0x40, 0x2c, 0x3c,
	0x40, 0x2c, 0x34,
	0x40, 0x2c, 0x30,
	0x40, 0x2c, 0x2c,
	0x40, 0x30, 0x2c,
	0x40, 0x34, 0x2c,
	0x40, 0x3c, 0x2c,
	0x40, 0x40, 0x2c,
	0x3c, 0x40, 0x2c,
	0x34, 0x40, 0x2c,
	0x30, 0x40, 0x2c,
	0x2c, 0x40, 0x2c,
	0x2c, 0x40, 0x30,
	0x2c, 0x40, 0x34,
	0x2c, 0x40, 0x3c,
	0x2c, 0x40, 0x40,
	0x2c, 0x3c, 0x40,
	0x2c, 0x34, 0x40,
	0x2c, 0x30, 0x40,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00
};

static const byte font[][5] = {
	{0x00,0x00,0x00,0xff,0x00},
	{0x5f,0xff,0x00,0x00,0x00},
	{0x03,0x00,0x03,0xff,0x00},
	{0x14,0x7f,0x14,0x7f,0x14},
	{0x24,0x2a,0x7f,0x2a,0x12},
	{0x61,0x10,0x08,0x04,0x43},
	{0x38,0x4e,0x59,0x26,0x50},
	{0x03,0xff,0x00,0x00,0x00},
	{0x3e,0x41,0xff,0x00,0x00},
	{0x41,0x3e,0xff,0x00,0x00},
	{0x10,0x54,0x38,0x54,0x10},
	{0x10,0x10,0x7c,0x10,0x10},
	{0x80,0x40,0xff,0x00,0x00},
	{0x10,0x10,0x10,0x10,0x10},
	{0x40,0xff,0x00,0x00,0x00},
	{0x60,0x10,0x08,0x04,0x03},

	{0x3e,0x41,0x41,0x41,0x3e}, /* digits */
	{0x04,0x02,0x7f,0xff,0x00},
	{0x42,0x61,0x51,0x49,0x46},
	{0x22,0x41,0x49,0x49,0x36},
	{0x18,0x14,0x12,0x7f,0x10},
	{0x27,0x45,0x45,0x45,0x39},
	{0x3e,0x49,0x49,0x49,0x32},
	{0x01,0x61,0x19,0x07,0x01},
	{0x36,0x49,0x49,0x49,0x36},
	{0x26,0x49,0x49,0x49,0x3e},

	{0x44,0xff,0x00,0x00,0x00},
	{0x80,0x44,0xff,0x00,0x00},
	{0x10,0x28,0x44,0xff,0x00},
	{0x28,0x28,0x28,0x28,0x28},
	{0x44,0x28,0x10,0xff,0x00},
	{0x02,0x01,0x51,0x09,0x06},
	{0x3e,0x41,0x5d,0x5d,0x1e},

	{0x7c,0x12,0x11,0x12,0x7c}, /* uppercase letters*/
	{0x7f,0x49,0x49,0x49,0x36},
	{0x3e,0x41,0x41,0x41,0x22},
	{0x7f,0x41,0x41,0x22,0x1c},
	{0x7f,0x49,0x49,0x49,0xff},
	{0x7f,0x09,0x09,0x09,0xff},
	{0x3e,0x41,0x41,0x49,0x3a},
	{0x7f,0x08,0x08,0x08,0x7f},
	{0x41,0x7f,0x41,0xff,0x00},
	{0x20,0x40,0x40,0x3f,0xff},
	{0x7f,0x08,0x14,0x22,0x41},
	{0x7f,0x40,0x40,0x40,0xff},
	{0x7f,0x02,0x04,0x02,0x7f},
	{0x7f,0x02,0x0c,0x10,0x7f},
	{0x3e,0x41,0x41,0x41,0x3e},
	{0x7f,0x09,0x09,0x09,0x06},
	{0x3e,0x41,0x51,0x21,0x5e},
	{0x7f,0x09,0x19,0x29,0x46},
	{0x26,0x49,0x49,0x49,0x32},
	{0x01,0x01,0x7f,0x01,0x01},
	{0x3f,0x40,0x40,0x40,0x3f},
	{0x07,0x18,0x60,0x18,0x07},
	{0x1f,0x60,0x18,0x60,0x1f},
	{0x63,0x14,0x08,0x14,0x63},
	{0x03,0x04,0x78,0x04,0x03},
	{0x61,0x51,0x49,0x45,0x43},

	{0x7f,0x41,0x41,0xff,0x00},
	{0x03,0x04,0x08,0x10,0x60},
	{0x41,0x41,0x7f,0xff,0x00},
	{0x02,0x01,0x02,0xff,0x00},
	{0x80,0x80,0x80,0x80,0x80},
	{0x01,0x02,0xff,0x00,0x00},

	{0x38,0x44,0x44,0x44,0x7c}, /* lowercase letters */
	{0x7f,0x44,0x44,0x44,0x38},
	{0x38,0x44,0x44,0x44,0x44},
	{0x38,0x44,0x44,0x44,0x7f},
	{0x38,0x54,0x54,0x54,0x58},
	{0x04,0x7e,0x05,0x01,0xff},
	{0x98,0xa4,0xa4,0xa4,0x7c},
	{0x7f,0x04,0x04,0x04,0x78},
	{0x7d,0xff,0x00,0x00,0x00},
	{0x80,0x80,0x7d,0xff,0x00},
	{0x7f,0x10,0x28,0x44,0xff},
	{0x7f,0xff,0x00,0x00,0x00},
	{0x7c,0x04,0x7c,0x04,0x78},
	{0x7c,0x04,0x04,0x04,0x78},
	{0x38,0x44,0x44,0x44,0x38},
	{0xfc,0x24,0x24,0x24,0x18},
	{0x18,0x24,0x24,0x24,0xfc},
	{0x7c,0x08,0x04,0x04,0xff},
	{0x48,0x54,0x54,0x54,0x24},
	{0x04,0x3e,0x44,0x40,0xff},
	{0x7c,0x40,0x40,0x40,0x3c},
	{0x0c,0x30,0x40,0x30,0x0c},
	{0x3c,0x40,0x3c,0x40,0x3c},
	{0x44,0x28,0x10,0x28,0x44},
	{0x9c,0xa0,0xa0,0xa0,0x7c},
	{0x44,0x64,0x54,0x4c,0x44},

	{0x08,0x36,0x41,0xff,0x00},
	{0x77,0xff,0x00,0x00,0x00},
	{0x41,0x36,0x08,0xff,0x00},
	{0x02,0x01,0x02,0x01,0xff},
	{0xff,0x00,0x00,0x00,0x00},

	{0xfe,0x49,0x49,0x4e,0x30}, /* sharp S */

	{0x7c,0x41,0x40,0x41,0x3c}, /* umlauts */

	{0x04,0x06,0x7f,0x06,0x04}, /* arrows */
	{0x20,0x60,0xfe,0x60,0x20},

	{0x38,0x45,0x44,0x45,0x7c}, /* umlauts */
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0x79,0x14,0x12,0x14,0x79},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0x38,0x45,0x44,0x45,0x38},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0xff,0x00,0x00,0x00,0x00},
	{0x3d,0x42,0x42,0x42,0x3d},
	{0x3d,0x40,0x40,0x40,0x3d},
};

}
