// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2013 - Scilab Enterprises
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// <-- Non-regression test for bug 12956 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/12956
//
// <-- Short Description -->
// url_split with no protocol in URL provokes an access violation exception
// originally splitURL
// No protocol
[proto, server, path, query, username, port, frag] = url_split("www.scilab.org");
assert_checkequal(proto, "");
assert_checkequal(server, "");
assert_checkequal(path, "www.scilab.org");
assert_checkequal(query, "");
assert_checkequal(username, "");
assert_checkequal(port, int32(0));
assert_checkequal(frag, "");
