from __future__ import print_function
from _mock import _Mock




ATTRIBUTE_QUALITY_PALETTE = _Mock()

AttrQuality = _Mock()

Attribute = _Mock()

Configuration = _Mock()

DataFormat = _Mock()

Database = _Mock()

Device = _Mock()

Object = _Mock()

PyTango = _Mock()

TaurusEventType = _Mock()

error_str = _Mock()

get_default_handlers = _Mock()

get_taurus_tornado_static_path = _Mock()

json_decode = _Mock()

json_encode = _Mock()

os = _Mock()

print_function = _Mock()

start = _Mock()



class Application(_Mock):
  pass


class AttributeNameValidator(_Mock):
  pass
  attr = "/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  complete_name = "(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})/(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  normal_name = "((?P<scheme>tango)://)?(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  protocol_prefix = 'tango://'
  short_name = "(?P<devalias>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)"
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  w = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"

class ConfigurationNameValidator(_Mock):
  pass
  complete_name = "(((?P<scheme>tango)://)?)?(?P<host>([\\w\\-_]+\\.)*[\\w\\-_]+):(?P<port>\\d{1,5})/(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?(?i)configuration(=(?P<configparam>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+))*"
  conf = "\\?(?i)configuration(=(?P<configparam>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+))*"
  normal_name = "((?P<scheme>tango)://)?(?P<devicename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+/[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?(?i)configuration(=(?P<configparam>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+))*"
  protocol_prefix = 'tango://'
  short_name = "(?P<devalias>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)/(?P<attributename>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+)\\?(?i)configuration(=(?P<configparam>[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+))*"
  tango_word = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"
  uri_gen_delims = '\\:\\/\\?\\#\\[\\]\\@'
  uri_reserved = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  uri_sub_delims = "\\!\\$\\&'\\(\\)\\*\\,\\;\\="
  w = "[^\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&'\\(\\)\\*\\,\\;\\=]+"

class RequestHandler(_Mock):
  pass


class StaticFileHandler(_Mock):
  pass
  CACHE_MAX_AGE = 315360000

class TaurusAttribute(_Mock):
  pass
  Critical = 50
  Debug = 10
  DftLogLevel = 20
  DftLogMessageFormat = '%(threadName)-14s %(levelname)-8s %(asctime)s %(name)s: %(message)s'
  Error = 40
  Fatal = 50
  Info = 20
  Trace = 5
  Warning = 30
  log_level = 10
  root_inited = True

class TaurusConfiguration(_Mock):
  pass
  Critical = 50
  Debug = 10
  DftLogLevel = 20
  DftLogMessageFormat = '%(threadName)-14s %(levelname)-8s %(asctime)s %(name)s: %(message)s'
  DftTimeToLive = 10000
  Error = 40
  Fatal = 50
  Info = 20
  Trace = 5
  Warning = 30
  log_level = 10
  no_abs_change = 'Not specified'
  no_archive_abs_change = 'Not specified'
  no_archive_period = 'Not specified'
  no_archive_rel_change = 'Not specified'
  no_cfg_value = '-----'
  no_delta_t = 'Not specified'
  no_delta_val = 'Not specified'
  no_description = 'No description'
  no_display_unit = 'No display unit'
  no_max_alarm = 'Not specified'
  no_max_value = 'Not specified'
  no_max_warning = 'Not specified'
  no_min_alarm = 'Not specified'
  no_min_value = 'Not specified'
  no_min_warning = 'Not specified'
  no_rel_change = 'Not specified'
  no_standard_unit = 'No standard unit'
  no_unit = 'No unit'
  not_specified = 'Not specified'
  root_inited = True

class TaurusDatabase(_Mock):
  pass
  Critical = 50
  Debug = 10
  DftLogLevel = 20
  DftLogMessageFormat = '%(threadName)-14s %(levelname)-8s %(asctime)s %(name)s: %(message)s'
  Error = 40
  Fatal = 50
  Info = 20
  Trace = 5
  Warning = 30
  log_level = 10
  root_inited = True

class TaurusDevice(_Mock):
  pass
  Critical = 50
  Debug = 10
  DftLogLevel = 20
  DftLogMessageFormat = '%(threadName)-14s %(levelname)-8s %(asctime)s %(name)s: %(message)s'
  Error = 40
  Fatal = 50
  Info = 20
  Trace = 5
  Warning = 30
  log_level = 10
  root_inited = True

class TaurusSocket(_Mock):
  pass


class TaurusWebAttribute(_Mock):
  pass


class TaurusWebConfiguration(_Mock):
  pass


class WebSocketHandler(_Mock):
  pass


