/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Assistance.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DRAW
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "List_font.h"
#include "global.h"
#include "culcfunc.h"
#include "Select.h"
#include "Draw.h"
#include "etc.h"
#include "Select.h"
#define _ASSISTANCE_
#include "Assistance.h"





/* -------------------------------------------------------------------
 * 寸法線をマウスで選択するときの目安となるポイントを表示する
 *	
 *	
 */
int SearchPointDraw(GtkWidget *widget, double x, double y, long color)
{
	double d;

	d = 0.3 / Mag;
	LineDraw(widget, x+d, y+d, x+d, y-d, 1, color);
	LineDraw(widget, x+d, y-d, x-d, y-d, 1, color);
	LineDraw(widget, x-d, y-d, x-d, y+d, 1, color);
	LineDraw(widget, x-d, y+d, x+d, y+d, 1, color);
	return 1;
}





/* -------------------------------------------------------------------
 * 矢印の長さを計算
 *	
 * DrawType
 *	   0 : 尺度に合わせた図面表示 (プリンターイメージ)
 *	   1 : 拡大縮小しても同じ大きさ
 *	   2 : 設定した大きさをそのまま表示
 */
double ArrowLength(int DrawType)
{
	/* 図面の縮尺表示 (プリンターイメージ) */
	if (DrawType == DRAW_DISP)
		return (sagcad_dimension.arrow_length / printer.scale);
	/* 文字サイズ固定表示 */
	else if (DrawType == DRAW_CONST) 
		return (sagcad_dimension.arrow_length / Mag);
	/* 設定した大きさをそのまま表示 */
	else if (DrawType == DRAW_REAL) 
		return sagcad_dimension.arrow_length;
	else 
		return sagcad_dimension.arrow_length;
}





/* -------------------------------------------------------------------
 * 終点に矢印 (defin = 10)
 *	
 * LineFrag
 *	   0	  : 矢印のみ
 *	   0 以外 : 矢印と直線
 *	
 */
int LineEndArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color)
{
	struct RtnDat LAH, PAPH;
	double EX1, EY1, EX2, EY2;

	/* -----------------------------------------------------
	 * LA	直線の角度
	 *		 (A.sx[1],A.SY[1]),(A.ex[1],A.EY[1])
	 *				 Ans A.ANGLE
	 */
	LAH.sx[1] = EX;
	LAH.sy[1] = EY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);
	/* -----------------------------------------------------
	 * PAP	始点と角度と距離で直線の終点を求める
	 *		 (A.sx[1] , A.sy[1]) , A.ANGLE , A.l
	 *				 Ans  (A.ex[1] , A.EY[1])
	 */
	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	/* (EX1 , EY1) */
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	/* (EX2 , EY2) */
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	if (LineFrag != 0) LineDraw(widget, SX, SY, EX, EY, 1, color);
	LineDraw(widget, EX, EY, EX1, EY1, 1, color);
	LineDraw(widget, EX, EY, EX2, EY2, 1, color);
	return 0;
}





/* -------------------------------------------------------------------
 * 両端に矢印 (defin = 20)
 *	
 * LineFrag
 *	   0	  : 矢印のみ
 *	   0 以外 : 矢印と直線
 */
int LineBothArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color)
{
	struct RtnDat LAH, PAPH;
	double EX1, EY1, EX2, EY2;


	/* LA	直線の角度 */
	LAH.sx[1] = EX;
	LAH.sy[1] = EY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);
	/* PAP	始点と角度と距離で直線の終点を求める */
	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, EX, EY, EX1, EY1, 1, color);
	LineDraw(widget, EX, EY, EX2, EY2, 1, color);

	/* LA	直線の角度 */
	LAH.sx[1] = SX;
	LAH.sy[1] = SY;
	LAH.ex[1] = EX;
	LAH.ey[1] = EY;
	la(&LAH);

	/* PAP	始点と角度と距離で直線の終点を求める */
	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, SX, SY, EX1, EY1, 1, color);
	LineDraw(widget, SX, SY, EX2, EY2, 1, color);

	if (LineFrag != 0) LineDraw(widget, SX, SY, EX, EY, 1, color);

	return 0;
}





/* -------------------------------------------------------------------
 * 両端に逆矢印 (defin = 30)
 *	
 * LineFrag
 *	   0	  : 矢印のみ
 *	   0 以外 : 矢印と直線
 */
int LineBothConverseArrow(GtkWidget *widget, double SX, double SY, double EX, double EY, int LineFrag, int DrawType, long color)
{
	struct RtnDat LAH,PAPH;
	double EX1,EY1,EX2,EY2;
	
	/* LA	直線の角度 */
	LAH.sx[1] = EX;
	LAH.sy[1] = EY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);

	/* PAP	始点と角度と距離で直線の終点を求める */
	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, SX, SY, EX1, EY1, 1, color);
	LineDraw(widget, SX, SY, EX2, EY2, 1, color);

	/* LA	直線の角度 */
	LAH.sx[1] = SX;
	LAH.sy[1] = SY;
	LAH.ex[1] = EX;
	LAH.ey[1] = EY;
	la(&LAH);
	/* PAP	始点と角度と距離で直線の終点を求める */
	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, EX, EY, EX1, EY1, 1, color);
	LineDraw(widget, EX, EY, EX2, EY2, 1, color);

	if (LineFrag != 0) LineDraw(widget, SX, SY, EX, EY, 1, color);

	return 0;
}





/* -------------------------------------------------------------------
 * 両端に矢印(円弧) (defin = 60)
 *	
 * ArcFrag
 *	   0	  : 矢印のみ
 *	   0 以外 : 矢印と直線
 */
int ArcBothArrow(GtkWidget *widget, double CX, double CY, double R, double SX, double SY, double EX, double EY, int ArcFrag, int DrawType, long color)
{
	/* Dumy = ArcBow(CX, CY, R, SA,EA, INDEX) */

	struct RtnDat PAPH, LAH;
	double SA, EA;
	double SX1, SY1, SX2, SY2;
	double EX1, EY1, EX2, EY2;


	/* 中心点から始点の線の角度 SA を求める。 */
	/* LA	  直線の角度 */
	LAH.sx[1] = CX;
	LAH.sy[1] = CY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);
	SA = LAH.angle;
	if(SA > 360) SA = SA - 360;

	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = SA + 90 - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	SX1 = PAPH.ex[1];
	SY1 = PAPH.ey[1];

	PAPH.sx[1] = SX;
	PAPH.sy[1] = SY;
	PAPH.angle = SA + 90 + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	SX2 = PAPH.ex[1];
	SY2 = PAPH.ey[1];

	LineDraw(widget, SX, SY, SX1, SY1, 5, color);
	LineDraw(widget, SX, SY, SX2, SY2, 5, color);



	/* 中心点から終点の線の角度 EA を求める。 */
	/* LA	  直線の角度 */
	LAH.sx[1] = CX;
	LAH.sy[1] = CY;
	LAH.ex[1] = EX;
	LAH.ey[1] = EY;
	la(&LAH);
	EA = LAH.angle;
	if(EA > 360) EA = EA - 360;

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = EA - 90 - sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = EA - 90 + sagcad_dimension.arrow_angle;
	PAPH.l = ArrowLength(DrawType);
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(widget, EX, EY, EX1, EY1, 5, color);
	LineDraw(widget, EX, EY, EX2, EY2, 5, color);

	if (ArcFrag != 0) ArcDraw (widget, CX, CY, R, SX, SY, EX, EY, 5, color);

	return 0;
}





/* -------------------------------------------------------------------
 * 補助線を描画   始点側:引出隙間	終点側:引出延長 (defin = 70)
 *	
 * 1 線の角度(Angle) を求める。
 * 2 線の長さ(LineLen) を求める。
 * 3 start_point を求める。
 * 4 end_point を求める。
 * 5 補助線を描画
 *	
 */
int AssistanceLine(GtkWidget *widget, double SX, double SY, double EX, double EY, int DrawType, long color)
{
	double Angle, LineLen, start_pointX, start_pointY, end_pointX, end_pointY;
	struct RtnDat a;
	int Ret;

	/* 1 線の角度(Angle) を求める。*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.ex[1] = EX;
	a.ey[1] = EY;
	Ret = la(&a);
	Angle = a.angle;

	/* 2 線の長さ(LineLen) を求める。*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.ex[1] = EX;
	a.ey[1] = EY;
	Ret = pp(&a);
	LineLen = a.l;

	/* 3 start_point を求める。*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.angle = Angle;

	/* 図面の縮尺表示 (プリンターイメージ) */
	if (DrawType == DRAW_DISP)
		a.l = sagcad_dimension.assistance_line_space / printer.scale;
	/* 文字サイズ固定表示 */
	else if (DrawType == DRAW_CONST) 
		a.l = (sagcad_dimension.assistance_line_space / Mag);
	/* 設定した大きさをそのまま表示 */
	else if (DrawType == DRAW_REAL) 
		a.l = sagcad_dimension.assistance_line_space;
	else 
		a.l = sagcad_dimension.assistance_line_space;
	Ret = pap(&a);
	start_pointX = a.ex[1];
	start_pointY = a.ey[1];

	/* 4 end_point を求める。*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.angle = Angle;

	/* 図面の縮尺表示 (プリンターイメージ) */
	if (DrawType == DRAW_DISP)
		a.l = LineLen + sagcad_dimension.assistance_line_extension / printer.scale;
	/* 文字サイズ固定表示 */
	else if (DrawType == DRAW_CONST) 
		a.l = LineLen + (sagcad_dimension.assistance_line_extension / Mag);
	/* 設定した大きさをそのまま表示 */
	else if (DrawType == DRAW_REAL) 
		a.l = LineLen + sagcad_dimension.assistance_line_extension;
	else 
		a.l = LineLen + sagcad_dimension.assistance_line_extension;
	Ret = pap(&a);
	end_pointX = a.ex[1];
	end_pointY = a.ey[1];

	/* 5 補助線を描画*/
	LineDraw(widget, start_pointX, start_pointY, end_pointX, end_pointY, 1, color);
	return 1;
}





/* -------------------------------------------------------------------
 * (矢印)補助線の延長を描画 (defin = 80)
 *	
 * (SX,SY)-(EX,EY) で指定された直線を sagcad_dimension.arrow_line_extension 
 * で指定された長さだけ終点を延長する。
 *	
 * 1 線の角度(Angle) を求める。
 * 2 線の長さ(LineLen) を求める。
 * 3 end_point を求める。
 * 4 補助線を描画
 *	
 */
int LineEndExtension(GtkWidget *widget, double SX, double SY, double EX, double EY, int DrawType, long color)
{
	double Angle, LineLen, end_pointX, end_pointY;
	struct RtnDat a;
	int Ret;

	/* 1 線の角度(Angle) を求める。*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.ex[1] = EX;
	a.ey[1] = EY;
	Ret = la(&a);
	Angle = a.angle;

	/* 2 線の長さ(LineLen) を求める。*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.ex[1] = EX;
	a.ey[1] = EY;
	Ret = pp(&a);
	LineLen = a.l;

	/* 3 end_point を求める。*/
	a.sx[1] = SX;
	a.sy[1] = SY;
	a.angle = Angle;

	/* 図面の縮尺表示 (プリンターイメージ) */
	if (DrawType == DRAW_DISP)
		a.l = LineLen + (sagcad_dimension.arrow_line_extension / printer.scale);
	/* 文字サイズ固定表示 */
	else if (DrawType == DRAW_CONST) 
		a.l = LineLen + (sagcad_dimension.arrow_line_extension / Mag);
	/* 設定した大きさをそのまま表示 */
	else if (DrawType == DRAW_REAL) 
		a.l = LineLen + sagcad_dimension.arrow_line_extension;
	else 
		a.l = LineLen + sagcad_dimension.arrow_line_extension;

	Ret = pap(&a);
	end_pointX = a.ex[1];
	end_pointY = a.ey[1];

	/* 4 補助線を描画*/
	LineDraw(widget, SX, SY, end_pointX, end_pointY, 1, color);
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Assistance.c
 * ====================================================================
 */

