# OpenPGP interoperability tests

This directory contains simple test cases to read OpenPGP keys and messages generated by a variety of implementations. The tests are declarative, and any implementation can write a driver for these tests to check for interoperability issues.

These test cases are not exhaustive by any means, and should be viewed as a simple check that messages and keys generated by various implementations can interoperate with each other.

## Format of a test case

Tests are based on a naming convention. Any file ending with `.json` is assumed to be a JSON file that declares a new test case. It _must_ have an string field called `type` that declares the type of test case.

There are currently two types of tests. An __import__ test, and a __decrypt__ test.

## Import test

This test expects the implementation to read a public key, validate it, and reject any invalid userids or subkeys. An example JSON file `mykey.json`

    {
      "type" : "import",
      "expected_uids" : ["e2ekey@example.com"],
      "expected_fingerprint": "099c5e5d3ca82dac59deb9431446c4a316225086",
      "expected_subkeys" : [{
        "expected_fingerprint": "43c788799304b2737511b41e66d2f1269199e424"
      }]
    }

The public key is located by a naming convention, and found in the same directory by replacing the `.json` extension with `.asc`. So in this example, the public key to read is `mytest.asc` within the same directory as the JSON file.

All the fields in the JSON file (except for the `type` field) are optional. But if a field is present, the implementation must confirm that after validation, it has the same information represented by the field. Unknown fields must be ignored.

`expected_uids` is an optional array of strings. This contains an array of (validated) UserID strings in the same order as was present in the key.

`expected_fingerprint` is an optional fingerprint of the primary key.

`expected_subkeys` is an optional array of objects representing each valid subkey (in the same order as was present in the key.) Each object may also include an optional `expected_fingerprint` field for the subkey fingerprint.

## Decrypt test

This test expects the implementation to decrypt a message using a provided private key, and verify it if (an optional) public key is provided. An example JSON file `mymessage.json`

    {
      "type" : "decrypt",
      "decryptKey": "mymessage-decrypt.asc",
      "passphrase": "test",
      "verifyKey": "mymessage-verify.asc",
      "filename": "hello.txt",
      "timestamp": 1418941207,
      "textcontent": "hello",
    }

The message to decrypt is located by a naming convention, and found in the same directory by replacing the `.json` extension with `.asc`. So in this example, the message to decrypt is `mymessage.asc` within the same directory as the JSON file.

`decryptKey` is a _required_ string field, and is the name of a file within the same directory. This file contains a private key that can decrypt the message.

`passphrase` is a _required_ string field, and provides a passphrase to unlock the private key.

`verifyKey` is an optional string field. If present, it is the name of a file within the same directory. This file contains a public key, and the message must be signed by it.

`filename` is an optional string field that is the filename indicated by the message.

`timestamp` is an optional numeric field that is the creation timestamp indicated by the message.

`textcontent` is an optional string field and is the expected content of the file.

## Attributions

These test cases are a community effort to improve interoperability between various OpenPGP implementations.

Copyright 2015 The OpenPGP Interoperability Project Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
