% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sortAlleles}
\alias{sortAlleles}
\title{Sort allele names}
\usage{
sortAlleles(allele_calls, method = c("name", "position"))
}
\arguments{
\item{allele_calls}{vector of strings respresenting Ig allele names.}

\item{method}{string defining the method to use when sorting alleles.
If \code{"name"} then sort in lexicographic order. If
\code{"position"} then sort by position in the locus, as
determined by the final two numbers in the gene name.}
}
\value{
A sorted vector of strings respresenting Ig allele names.
}
\description{
\code{sortAlleles} returns a sorted vector of strings respresenting Ig allele
names. Names are first sorted by gene family, then by gene, then by allele.
Duplicated genes have their alleles are sorted as if they were part of their
non-duplicated counterparts (e.g. \code{IGHV1-69D*01} comes after \code{IGHV1-69*01} 
but before \code{IGHV1-69*02}), and non-localized genes (e.g. \code{IGHV1-NL1*01}) 
come last within their gene family.
}
\examples{
# Create a list of allele names
alleles <- c("IGHV1-69D*01","IGHV1-69*01","IGHV1-2*01","IGHV1-69-2*01",
             "IGHV2-5*01","IGHV1-NL1*01", "IGHV1-2*01,IGHV1-2*05", 
             "IGHV1-2", "IGHV1-2*02", "IGHV1-69*02")

# Sort the alleles by name
sortAlleles(alleles)

# Sort the alleles by position in the locus
sortAlleles(alleles, method="pos")

}
\seealso{
Like \code{sortAlleles}, \link{updateAlleleNames} can help
         format a list of allele names.
}
