% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{getPopularMutationCount}
\alias{getPopularMutationCount}
\title{Find mutation counts for frequency sequences}
\usage{
getPopularMutationCount(
  data,
  germline_db,
  v_call = "v_call",
  seq = "sequence_alignment",
  gene_min = 0.001,
  seq_min = 50,
  seq_p_of_max = 1/8,
  full_return = FALSE
)
}
\arguments{
\item{data}{\code{data.frame} in the Change-O format. See
\link{findNovelAlleles} for a list of required
columns.}

\item{germline_db}{named list of IMGT-gapped germline sequences.}

\item{v_call}{name of the column in \code{data} with V allele calls. 
Default is \code{v_call}.}

\item{seq}{name of the column in \code{data} with the 
aligned, IMGT-numbered, V(D)J nucleotide sequence.
Default is \code{sequence_alignment}.}

\item{gene_min}{portion of all unique sequences a gene must
constitute to avoid exclusion.}

\item{seq_min}{number of copies of the V that must be present for
to avoid exclusion.}

\item{seq_p_of_max}{ror each gene, the fraction of the most common V sequence
count that a sequence must meet to avoid exclusion.}

\item{full_return}{if \code{TRUE}, will return all \code{data} columns and
will include sequences with mutation count < 1.}
}
\value{
A data frame of genes that have a frequent sequence mutation count
         above 1.
}
\description{
\code{getPopularMutationCount} determines which sequences occur frequently
for each V gene and returns the mutation count of those sequences.
}
\examples{
getPopularMutationCount(AIRRDb, SampleGermlineIGHV)

}
\seealso{
\link{getMutatedPositions} can be used to find which positions
         of a set of sequences are mutated.
}
