% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars.R
\name{peek_vars}
\alias{peek_vars}
\alias{peek_data}
\title{Peek at variables in the selection context}
\usage{
peek_vars(..., fn = NULL)

peek_data(..., fn = NULL)
}
\arguments{
\item{...}{These dots are for future extensions and must be empty.}

\item{fn}{The name of the function to use in error messages when
the helper is used in the wrong context. If not supplied, a
generic error message is used instead.}
}
\description{
\itemize{
\item \code{peek_vars()} returns the vector of names of the variables
currently available for selection.
\item \code{peek_data()} returns the whole input vector (only available with
\code{\link[=eval_select]{eval_select()}}).
}

Read the \href{https://tidyselect.r-lib.org/articles/tidyselect.html}{Get started} for
examples of how to create selection helpers with \code{peek_vars()}.

The variable names in a selection context are registered
automatically by \code{\link[=eval_select]{eval_select()}} and \code{\link[=eval_rename]{eval_rename()}} for the
duration of the evaluation. \code{peek_vars()} is the glue that connects
\link[=select_helpers]{selection helpers} to the current selection
context.
}
