% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration5.R
\name{writing-integration}
\alias{writing-integration}
\title{Writing Integration Method Functions}
\description{
Integration method functions can be written by anyone to implement any
integration method in Seurat. These methods should expect to take a
\link[SeuratObject:Assay5]{v5 assay} as input and return a named list of
objects that can be added back to a \code{Seurat} object (eg. a
\link[SeuratObject:DimReduc]{dimensional reduction} or cell-level meta data)
}
\section{Provided Parameters}{

Every integration method function should expect the following arguments:
\itemize{
 \item \dQuote{\code{object}}: an \code{\link[SeuratObject]{Assay5}} object
 \item \dQuote{\code{orig}}: \link[SeuratObject:DimReduc]{dimensional
 reduction} to correct
 \item \dQuote{\code{layers}}: names of normalized layers in \code{object}
 \item \dQuote{\code{scale.layer}}: name(s) of scaled layer(s) in
 \code{object}
 \item \dQuote{\code{features}}: a vector of features for integration
 \item \dQuote{\code{groups}}: a one-column data frame with the groups for
 each cell in \code{object}; the column name will be \dQuote{group}
}
}

\section{Method Discovery}{

The documentation for \code{\link{IntegrateLayers}()} will automatically
link to integration method functions provided by packages in the
\code{\link[base]{search}()} space. To make an integration method function
discoverable by the documentation, simply add an attribute named
\dQuote{\code{Seurat.method}} to the function with a value of
\dQuote{\code{integration}}
\preformatted{
attr(MyIntegrationFunction, which = "Seurat.method") <- "integration"
}
}

\seealso{
\code{\link{IntegrateLayers}()}
}
\concept{integration}
\keyword{internal}
