% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{weights.glmmTMB}
\alias{weights.glmmTMB}
\title{Extract weights from a glmmTMB object}
\usage{
\method{weights}{glmmTMB}(object, type = "prior", ...)
}
\arguments{
\item{object}{a fitted \code{glmmTMB} object}

\item{type}{weights type}

\item{...}{additional arguments (not used; for methods compatibility)}
}
\description{
Extract weights from a glmmTMB object
}
\details{
At present only explicitly specified
\emph{prior weights} (i.e., weights specified
in the \code{weights} argument) can be extracted from a fitted model.
\itemize{
\item Unlike other GLM-type models such as \code{\link{glm}} or
\code{\link[lme4]{glmer}}, \code{weights()} does not currently return
the total number of trials when binomial responses are specified
as a two-column matrix.
\item Since \code{glmmTMB} does not fit models via iteratively
weighted least squares, \code{working weights} (see \code{\link[stats]{weights.glm}}) are unavailable.
}
}
