% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_multicore.R
\name{batchtools_multicore}
\alias{batchtools_multicore}
\title{batchtools multicore futures}
\usage{
batchtools_multicore(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  globals = TRUE,
  label = NULL,
  workers = availableCores(constraints = "multicore"),
  registry = list(),
  ...
)
}
\arguments{
\item{expr}{The R expression to be evaluated}

\item{envir}{The environment in which global environment
should be located.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{globals}{(optional) a logical, a character vector, a named list, or a
\link[globals:Globals]{Globals} object.  If TRUE, globals are identified by code
inspection based on \code{expr} and \code{tweak} searching from environment
\code{envir}.  If FALSE, no globals are used.  If a character vector, then
globals are identified by lookup based their names \code{globals} searching
from environment \code{envir}.  If a named list or a Globals object, the
globals are used as is.}

\item{label}{(optional) Label of the future (where applicable, becomes the
job name for most job schedulers).}

\item{workers}{The number of multicore processes to be
available for concurrent batchtools multicore futures.}

\item{registry}{(optional) A named list of settings to control the setup
of the batchtools registry.}

\item{\ldots}{Additional arguments passed
to \code{\link[=BatchtoolsFuture]{BatchtoolsFuture()}}.}
}
\value{
An object of class \code{BatchtoolsFuture}.
}
\description{
A batchtools multicore future is an asynchronous multiprocess
future that will be evaluated in a background R session.\cr
\cr
\emph{We highly recommend using \link[future:multisession]{future::multisession}
(sic!) futures of the \pkg{future} package instead of
multicore batchtools futures.}
}
\details{
batchtools multicore futures rely on the batchtools backend set
up by \code{\link[batchtools:makeClusterFunctionsMulticore]{batchtools::makeClusterFunctionsMulticore()}}.
The batchtools multicore backend only works on operating systems
supporting the \code{ps} command-line tool, e.g. Linux and macOS.
}
\keyword{internal}
