% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{as_iso_year_week_day}
\alias{as_iso_year_week_day}
\title{Convert to iso-year-week-day}
\usage{
as_iso_year_week_day(x, ...)
}
\arguments{
\item{x}{\verb{[vector]}

A vector to convert to iso-year-week-day.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A iso-year-week-day vector.
}
\description{
\code{as_iso_year_week_day()} converts a vector to the iso-year-week-day
calendar. Time points, Dates, POSIXct, and other calendars can all be
converted to iso-year-week-day.
}
\examples{
# From Date
as_iso_year_week_day(as.Date("2019-01-01"))

# From POSIXct, which assumes that the naive time is what should be converted
as_iso_year_week_day(as.POSIXct("2019-01-01 02:30:30", "America/New_York"))

# From other calendars
as_iso_year_week_day(year_quarter_day(2019, quarter = 2, day = 50))
}
