% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logNormCounts.R
\name{logNormCounts}
\alias{logNormCounts}
\alias{logNormCounts,SummarizedExperiment-method}
\alias{logNormCounts,SingleCellExperiment-method}
\title{Compute log-normalized expression values}
\usage{
logNormCounts(x, ...)

\S4method{logNormCounts}{SummarizedExperiment}(
  x,
  size.factors = NULL,
  log = NULL,
  transform = c("log", "none", "asinh"),
  pseudo.count = 1,
  center.size.factors = TRUE,
  ...,
  subset.row = NULL,
  normalize.all = FALSE,
  assay.type = "counts",
  name = NULL,
  BPPARAM = SerialParam(),
  size_factors = NULL,
  pseudo_count = NULL,
  center_size_factors = NULL,
  exprs_values = NULL
)

\S4method{logNormCounts}{SingleCellExperiment}(
  x,
  size.factors = sizeFactors(x),
  log = NULL,
  transform = c("log", "none", "asinh"),
  pseudo.count = 1,
  center.size.factors = TRUE,
  ...,
  subset.row = NULL,
  normalize.all = FALSE,
  assay.type = "counts",
  use.altexps = FALSE,
  name = NULL,
  BPPARAM = SerialParam(),
  size_factors = NULL,
  pseudo_count = NULL,
  center_size_factors = NULL,
  exprs_values = NULL,
  use_altexps = NULL
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} or \linkS4class{SummarizedExperiment} object containing a count matrix.}

\item{...}{For the generic, additional arguments passed to specific methods. 

For the methods, additional arguments passed to \code{\link{normalizeCounts}}.}

\item{size.factors}{A numeric vector of cell-specific size factors.
Alternatively \code{NULL}, in which case the size factors are computed from \code{x}.}

\item{log}{Logical scalar indicating whether normalized values should be log2-transformed.
This is retained for back-compatibility and will override any setting of \code{transform}.
Users should generally use \code{transform} instead to specify the transformation.}

\item{transform}{String specifying the transformation (if any) to apply to the normalized expression values.}

\item{pseudo.count}{Numeric scalar specifying the pseudo-count to add when \code{transform="log"}.}

\item{center.size.factors}{Logical scalar indicating whether size factors should be centered at unity before being used.}

\item{subset.row}{A vector specifying the subset of rows of \code{x} for which to return normalized values.
If \code{size.factors=NULL}, the size factors are also computed from this subset.}

\item{normalize.all}{Logical scalar indicating whether to return normalized values for all genes.
If \code{TRUE}, any non-\code{NULL} value for \code{subset.row} is only used to compute the size factors.
Ignored if \code{subset.row=NULL} or \code{size.factors} is supplied.}

\item{assay.type}{A string or integer scalar specifying the assay of \code{x} containing the count matrix.}

\item{name}{String containing an assay name for storing the output normalized values.
Defaults to \code{"logcounts"} when \code{transform="log"}, \code{"ashcounts"} when \code{transform="asinh"}, and \code{"normcounts"} otherwise.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying how library size factor calculations should be parallelized.
Only used if \code{size.factors} is not specified.}

\item{size_factors}{Soft-deprecated equivalents to the arguments described previously.}

\item{pseudo_count}{Soft-deprecated equivalents to the arguments described previously.}

\item{center_size_factors}{Soft-deprecated equivalents to the arguments described previously.}

\item{exprs_values}{Soft-deprecated equivalents to the arguments described previously.}

\item{use.altexps, use_altexps}{Deprecated, use \code{\link{applySCE}} instead (see Examples).}
}
\value{
\code{x} is returned containing the (log-)normalized expression values in an additional assay named as \code{name}.

If \code{x} is a \linkS4class{SingleCellExperiment}, the size factors used for normalization are stored in \code{\link{sizeFactors}}.
These are centered if \code{center.size.factors=TRUE}.
}
\description{
Compute log-transformed normalized expression values from a count matrix in a \linkS4class{SingleCellExperiment} object.
}
\details{
This function is a convenience wrapper around \code{\link{normalizeCounts}}.
It returns a \linkS4class{SingleCellExperiment} or \linkS4class{SummarizedExperiment} containing the normalized values in a separate assay.
This makes it easier to perform normalization by avoiding book-keeping errors during a long analysis workflow.

If \code{NULL}, size factors are determined as described in \code{\link{normalizeCounts}}.
\code{subset.row} and \code{normalize.all} have the same interpretation as for \code{\link{normalizeCounts}}.
}
\examples{
example_sce <- mockSCE()

# Standard library size normalization:
example_sce2 <- logNormCounts(example_sce)
assayNames(example_sce2)
logcounts(example_sce2)[1:5,1:5]

# Without logging, the assay is 'normcounts':
example_sce2 <- logNormCounts(example_sce, log=FALSE)
assayNames(example_sce2)
normcounts(example_sce2)[1:5,1:5]

# Pre-loading with size factors:
example_sce2 <- computeMedianFactors(example_sce)
example_sce2 <- logNormCounts(example_sce2)
logcounts(example_sce2)[1:5,1:5]

# Also normalizing the alternative experiments:
example_sce2 <- applySCE(example_sce, logNormCounts)
logcounts(altExp(example_sce2))[1:5,1:5]

}
\seealso{
\code{\link{normalizeCounts}}, which is used to compute the normalized expression values.
}
\author{
Aaron Lun, based on code by Davis McCarthy
}
