// dcfmath.h
//
// The code in this file is part of Pyxplot
// <http://www.pyxplot.org.uk>
//
// Copyright (C) 2006-2012 Dominic Ford <coders@pyxplot.org.uk>
//               2008-2012 Ross Church
//
// $Id: dcfmath.h 1287 2012-08-10 17:57:31Z dcf21 $
//
// Pyxplot is free software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// You should have received a copy of the GNU General Public License along with
// Pyxplot; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA

// ----------------------------------------------------------------------------

#ifndef _DCFMATH_H
#define _DCFMATH_H 1

#ifndef _DCFMATH_C
extern double ppl_machineEpsilon;
#endif

void   ppl_makeMachineEpsilon();
double ppl_max      (double x, double y);
double ppl_min      (double x, double y);
double ppl_max3     (double x, double y, double z);
double ppl_min3     (double x, double y, double z);
int    ppl_sgn      (double x);
void   ppl_linRaster(double *out, double min, double max, int Nsteps);
void   ppl_logRaster(double *out, double min, double max, int Nsteps);
double ppl_degs     (double rad);
double ppl_rads     (double degrees);
int    ppl_dblSort  (const void *a, const void *b);
int    ppl_gcd      (int a, int b);

#endif

