#
# PySNMP MIB module UDPLITE-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/UDPLITE-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:32:25 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, SingleValueConstraint, ValueSizeConstraint, ConstraintsUnion, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsUnion", "ValueRangeConstraint")
( InetPortNumber, InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetPortNumber", "InetAddress", "InetAddressType")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( Bits, IpAddress, MibScalar, MibTable, MibTableRow, MibTableColumn, iso, NotificationType, Counter32, Unsigned32, ModuleIdentity, Counter64, Gauge32, TimeTicks, ObjectIdentity, Integer32, mib_2, MibIdentifier, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "IpAddress", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "iso", "NotificationType", "Counter32", "Unsigned32", "ModuleIdentity", "Counter64", "Gauge32", "TimeTicks", "ObjectIdentity", "Integer32", "mib-2", "MibIdentifier")
( DisplayString, TimeStamp, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TimeStamp", "TextualConvention")
udpliteMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 170)).setRevisions(("2007-12-18 00:00",))
if mibBuilder.loadTexts: udpliteMIB.setLastUpdated('200712180000Z')
if mibBuilder.loadTexts: udpliteMIB.setOrganization('IETF TSV Working Group (TSVWG)')
if mibBuilder.loadTexts: udpliteMIB.setContactInfo('IETF TSV Working Group\n            http://www.ietf.org/html.charters/tsvwg-charter.html\n            Mailing List: tsvwg@ietf.org\n\n\n\n\n            Gerrit Renker, Godred Fairhurst\n            Electronics Research Group\n            School of Engineering, University of Aberdeen\n            Fraser Noble Building, Aberdeen AB24 3UE, UK')
if mibBuilder.loadTexts: udpliteMIB.setDescription('The MIB module for managing UDP-Lite implementations.\n            Copyright (C) The IETF Trust (2008).  This version of\n            this MIB module is part of RFC 5097; see the RFC\n            itself for full legal notices.')
udplite = MibIdentifier((1, 3, 6, 1, 2, 1, 170, 1))
udpliteInDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 1), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteInDatagrams.setDescription('The total number of UDP-Lite datagrams that were\n            delivered to UDP-Lite users.\n            Discontinuities in the value of this counter can occur\n            at re-initialisation of the management system, and at\n            other times as indicated by the value of\n            udpliteStatsDiscontinuityTime.')
udpliteInPartialCov = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteInPartialCov.setDescription('The total number of UDP-Lite datagrams that were\n            delivered to UDP-Lite users (applications) and whose\n            checksum coverage was strictly less than the datagram\n            length.\n            Discontinuities in the value of this counter can occur\n            at re-initialisation of the management system, and at\n            other times as indicated by the value of\n            udpliteStatsDiscontinuityTime.')
udpliteNoPorts = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteNoPorts.setDescription('The total number of received UDP-Lite datagrams for\n            which there was no listener at the destination port.\n            Discontinuities in the value of this counter can occur\n            at re-initialisation of the management system, and at\n            other times as indicated by the value of\n            udpliteStatsDiscontinuityTime.')
udpliteInErrors = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteInErrors.setDescription('The number of received UDP-Lite datagrams that could not\n            be delivered for reasons other than the lack of an\n            application at the destination port.\n            Discontinuities in the value of this counter can occur\n            at re-initialisation of the management system, and at\n            other times as indicated by the value of\n            udpliteStatsDiscontinuityTime.')
udpliteInBadChecksum = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteInBadChecksum.setDescription('The number of received UDP-Lite datagrams whose checksum\n            could not be validated.  This includes illegal checksum\n            coverage values, as their use would lead to incorrect\n            checksums.\n            Discontinuities in the value of this counter can occur\n            at re-initialisation of the management system, and at\n            other times as indicated by the value of\n            udpliteStatsDiscontinuityTime.')
udpliteOutDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteOutDatagrams.setDescription('The total number of UDP-Lite datagrams sent from this\n            entity.\n            Discontinuities in the value of this counter can occur\n            at re-initialisation of the management system, and at\n            other times as indicated by the value of\n            udpliteStatsDiscontinuityTime.')
udpliteOutPartialCov = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteOutPartialCov.setDescription('The total number of udpliteOutDatagrams whose\n            checksum coverage was strictly less than the\n            datagram length.\n            Discontinuities in the value of this counter can occur\n            at re-initialisation of the management system, and at\n            other times as indicated by the value of\n            udpliteStatsDiscontinuityTime.')
udpliteEndpointTable = MibTable((1, 3, 6, 1, 2, 1, 170, 1, 8), )
if mibBuilder.loadTexts: udpliteEndpointTable.setDescription("A table containing information about this entity's\n            UDP-Lite endpoints on which a local application is\n            currently accepting or sending datagrams.\n\n            The address type in this table represents the address\n            type used for the communication, irrespective of the\n            higher-layer abstraction.  For example, an application\n            using IPv6 'sockets' to communicate via IPv4 between\n            ::ffff:10.0.0.1 and ::ffff:10.0.0.2 would use\n            InetAddressType ipv4(1).\n\n            Like the udpTable in RFC 4113, this table also allows\n            the representation of an application that completely\n            specifies both local and remote addresses and ports.  A\n            listening application is represented in three possible\n            ways:\n\n            1) An application that is willing to accept both IPv4\n               and IPv6 datagrams is represented by a\n               udpliteEndpointLocalAddressType of unknown(0) and a\n               udpliteEndpointLocalAddress of ''h (a zero-length\n\n\n\n               octet-string).\n\n            2) An application that is willing to accept only IPv4\n               or only IPv6 datagrams is represented by a\n               udpliteEndpointLocalAddressType of the appropriate\n               address type and a udpliteEndpointLocalAddress of\n               '0.0.0.0' or '::' respectively.\n\n            3) An application that is listening for datagrams only\n               for a specific IP address but from any remote\n               system is represented by a\n               udpliteEndpointLocalAddressType of the appropriate\n               address type, with udpliteEndpointLocalAddress\n               specifying the local address.\n\n            In all cases where the remote address is a wildcard,\n            the udpliteEndpointRemoteAddressType is unknown(0),\n            the udpliteEndpointRemoteAddress is ''h (a zero-length\n            octet-string), and the udpliteEndpointRemotePort is 0.\n\n            If the operating system is demultiplexing UDP-Lite\n            packets by remote address/port, or if the application\n            has 'connected' the socket specifying a default remote\n            address/port, the udpliteEndpointRemote* values should\n            be used to reflect this.")
udpliteEndpointEntry = MibTableRow((1, 3, 6, 1, 2, 1, 170, 1, 8, 1), ).setIndexNames((0, "UDPLITE-MIB", "udpliteEndpointLocalAddressType"), (0, "UDPLITE-MIB", "udpliteEndpointLocalAddress"), (0, "UDPLITE-MIB", "udpliteEndpointLocalPort"), (0, "UDPLITE-MIB", "udpliteEndpointRemoteAddressType"), (0, "UDPLITE-MIB", "udpliteEndpointRemoteAddress"), (0, "UDPLITE-MIB", "udpliteEndpointRemotePort"), (0, "UDPLITE-MIB", "udpliteEndpointInstance"))
if mibBuilder.loadTexts: udpliteEndpointEntry.setDescription('Information about a particular current UDP-Lite endpoint.\n            Implementers need to pay attention to the sizes of\n            udpliteEndpointLocalAddress/RemoteAddress, as Object\n            Identifiers (OIDs) of column instances in this table must\n            have no more than 128 sub-identifiers in order to remain\n             accessible with SNMPv1, SNMPv2c, and SNMPv3.')
udpliteEndpointLocalAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 1), InetAddressType())
if mibBuilder.loadTexts: udpliteEndpointLocalAddressType.setDescription('The address type of udpliteEndpointLocalAddress.  Only\n            IPv4, IPv4z, IPv6, and IPv6z addresses are expected, or\n            unknown(0) if datagrams for all local IP addresses are\n            accepted.')
udpliteEndpointLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 2), InetAddress())
if mibBuilder.loadTexts: udpliteEndpointLocalAddress.setDescription("The local IP address for this UDP-Lite endpoint.\n\n            The value of this object can be represented in three\n            possible ways, depending on the characteristics of the\n            listening application:\n\n            1. For an application that is willing to accept both\n               IPv4 and IPv6 datagrams, the value of this object\n               must be ''h (a zero-length octet-string), with\n               the value of the corresponding instance of the\n               EndpointLocalAddressType object being unknown(0).\n\n            2. For an application that is willing to accept only\n               IPv4 or only IPv6 datagrams, the value of this\n               object must be '0.0.0.0' or '::', respectively,\n               while the corresponding instance of the\n               EndpointLocalAddressType object represents the\n               appropriate address type.\n\n            3. For an application that is listening for data\n\n\n\n               destined only to a specific IP address, the value\n               of this object is the specific IP address for\n               which this node is receiving packets, with the\n               corresponding instance of the\n               EndpointLocalAddressType object representing the\n               appropriate address type.\n\n            As this object is used in the index for the\n            udpliteEndpointTable, implementors should be careful\n            not to create entries that would result in OIDs with\n            more than 128 sub-identifiers; this is because of SNMP\n            and SMI limitations.")
udpliteEndpointLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 3), InetPortNumber())
if mibBuilder.loadTexts: udpliteEndpointLocalPort.setDescription('The local port number for this UDP-Lite endpoint.')
udpliteEndpointRemoteAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 4), InetAddressType())
if mibBuilder.loadTexts: udpliteEndpointRemoteAddressType.setDescription('The address type of udpliteEndpointRemoteAddress.  Only\n            IPv4, IPv4z, IPv6, and IPv6z addresses are expected, or\n            unknown(0) if datagrams for all remote IP addresses are\n            accepted.  Also, note that some combinations of\n            udpliteEndpointLocalAdressType and\n            udpliteEndpointRemoteAddressType are not supported.  In\n            particular, if the value of this object is not\n            unknown(0), it is expected to always refer to the\n            same IP version as udpliteEndpointLocalAddressType.')
udpliteEndpointRemoteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 5), InetAddress())
if mibBuilder.loadTexts: udpliteEndpointRemoteAddress.setDescription("The remote IP address for this UDP-Lite endpoint.  If\n            datagrams from any remote system are to be accepted,\n            this value is ''h (a zero-length octet-string).\n            Otherwise, it has the type described by\n            udpliteEndpointRemoteAddressType and is the address of\n\n\n\n            the remote system from which datagrams are to be\n            accepted (or to which all datagrams will be sent).\n\n            As this object is used in the index for the\n            udpliteEndpointTable, implementors should be careful\n            not to create entries that would result in OIDs with\n            more than 128 sub-identifiers; this is because of SNMP\n            and SMI limitations.")
udpliteEndpointRemotePort = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 6), InetPortNumber())
if mibBuilder.loadTexts: udpliteEndpointRemotePort.setDescription('The remote port number for this UDP-Lite endpoint.  If\n            datagrams from any remote system are to be accepted,\n            this value is zero.')
udpliteEndpointInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: udpliteEndpointInstance.setDescription("The instance of this tuple.  This object is used to\n            distinguish among multiple processes 'connected' to\n            the same UDP-Lite endpoint.  For example, on a system\n            implementing the BSD sockets interface, this would be\n            used to support the SO_REUSEADDR and SO_REUSEPORT\n            socket options.")
udpliteEndpointProcess = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteEndpointProcess.setDescription("A unique value corresponding to a piece of software\n            running on this endpoint.\n\n            If this endpoint is associated with more than one piece\n            of software, the agent should choose one of these.  As\n            long as the representative piece of software\n            is running and still associated with the endpoint,\n            subsequent reads will consistently return the same\n            value.  The implementation may use any algorithm\n            satisfying these constraints (e.g., choosing the entity\n\n\n\n            with the oldest start time).\n\n            This identifier is platform-specific.  Wherever possible,\n            it should use the system's native, unique identification\n            number as the value.\n\n            If the SYSAPPL-MIB module is available, the value should\n            be the same as sysApplElmtRunIndex.  If not available, an\n            alternative should be used (e.g., the hrSWRunIndex of the\n            HOST-RESOURCES-MIB module).\n\n            If it is not possible to uniquely identify the pieces of\n            software associated with this endpoint, then the value\n            zero should be used.  (Note that zero is otherwise a\n            valid value for sysApplElmtRunIndex.)")
udpliteEndpointMinCoverage = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteEndpointMinCoverage.setDescription('The minimum checksum coverage expected by this endpoint.\n            A value of 0 indicates that only fully covered datagrams\n            are accepted.')
udpliteEndpointViolCoverage = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteEndpointViolCoverage.setDescription('The number of datagrams received by this endpoint whose\n            checksum coverage violated the minimum coverage threshold\n            set for this connection (i.e., all valid datagrams whose\n            checksum coverage was strictly smaller than the minimum,\n            as defined in RFC 3828).\n            Discontinuities in the value of this counter can occur\n            at re-initialisation of the management system, and at\n            other times as indicated by the value of\n            udpliteStatsDiscontinuityTime.')
udpliteStatsDiscontinuityTime = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteStatsDiscontinuityTime.setDescription('The value of sysUpTime at the most recent occasion at\n            which one or more of the UDP-Lite counters suffered a\n            discontinuity.\n            A value of zero indicates no such discontinuity has\n            occurred since the last re-initialisation of the local\n            management subsystem.')
udpliteMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 170, 2))
udpliteMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 170, 2, 1)).setObjects(*(("UDPLITE-MIB", "udpliteBaseGroup"), ("UDPLITE-MIB", "udplitePartialCsumGroup"), ("UDPLITE-MIB", "udpliteEndpointGroup"), ("UDPLITE-MIB", "udpliteAppGroup"),))
if mibBuilder.loadTexts: udpliteMIBCompliance.setDescription('The compliance statement for systems that implement\n            UDP-Lite.\n\n            There are a number of INDEX objects that cannot be\n            represented in the form of OBJECT clauses in SMIv2,\n            but for which we have the following compliance\n            requirements, expressed in OBJECT clause form in this\n            description clause:\n\n            -- OBJECT      udpliteEndpointLocalAddressType\n            -- SYNTAX      InetAddressType { unknown(0), ipv4(1),\n            --                               ipv6(2), ipv4z(3),\n            --                               ipv6z(4) }\n            -- DESCRIPTION\n            --     Support for dns(16) is not required.\n            -- OBJECT      udpliteEndpointLocalAddress\n            -- SYNTAX      InetAddress (SIZE(0|4|8|16|20))\n            -- DESCRIPTION\n            --     Support is only required for zero-length\n            --     octet-strings, and for scoped and unscoped\n            --     IPv4 and IPv6 addresses.\n            -- OBJECT      udpliteEndpointRemoteAddressType\n            -- SYNTAX      InetAddressType { unknown(0), ipv4(1),\n            --                               ipv6(2), ipv4z(3),\n            --                               ipv6z(4) }\n            -- DESCRIPTION\n            --     Support for dns(16) is not required.\n            -- OBJECT      udpliteEndpointRemoteAddress\n\n\n\n            -- SYNTAX      InetAddress (SIZE(0|4|8|16|20))\n            -- DESCRIPTION\n            --     Support is only required for zero-length\n            --     octet-strings, and for scoped and unscoped\n            --     IPv4 and IPv6 addresses.\n           ')
udpliteMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 170, 2, 2))
udpliteBaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 170, 2, 2, 1)).setObjects(*(("UDPLITE-MIB", "udpliteInDatagrams"), ("UDPLITE-MIB", "udpliteNoPorts"), ("UDPLITE-MIB", "udpliteInErrors"), ("UDPLITE-MIB", "udpliteOutDatagrams"), ("UDPLITE-MIB", "udpliteStatsDiscontinuityTime"),))
if mibBuilder.loadTexts: udpliteBaseGroup.setDescription('The group of objects providing for counters of\n            basic UDP-like statistics.')
udplitePartialCsumGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 170, 2, 2, 2)).setObjects(*(("UDPLITE-MIB", "udpliteInPartialCov"), ("UDPLITE-MIB", "udpliteInBadChecksum"), ("UDPLITE-MIB", "udpliteOutPartialCov"),))
if mibBuilder.loadTexts: udplitePartialCsumGroup.setDescription('The group of objects providing for counters of\n            transport layer statistics exclusive to UDP-Lite.')
udpliteEndpointGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 170, 2, 2, 3)).setObjects(*(("UDPLITE-MIB", "udpliteEndpointProcess"), ("UDPLITE-MIB", "udpliteEndpointMinCoverage"),))
if mibBuilder.loadTexts: udpliteEndpointGroup.setDescription("The group of objects providing for the IP version\n            independent management of UDP-Lite 'endpoints'.")
udpliteAppGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 170, 2, 2, 4)).setObjects(*(("UDPLITE-MIB", "udpliteEndpointViolCoverage"),))
if mibBuilder.loadTexts: udpliteAppGroup.setDescription("The group of objects that provide application-level\n            information for the configuration management of\n            UDP-Lite 'endpoints'.")
mibBuilder.exportSymbols("UDPLITE-MIB", udpliteAppGroup=udpliteAppGroup, udplitePartialCsumGroup=udplitePartialCsumGroup, udpliteInPartialCov=udpliteInPartialCov, udpliteOutDatagrams=udpliteOutDatagrams, udpliteEndpointMinCoverage=udpliteEndpointMinCoverage, udpliteInBadChecksum=udpliteInBadChecksum, udpliteEndpointGroup=udpliteEndpointGroup, udpliteEndpointInstance=udpliteEndpointInstance, udpliteEndpointLocalAddress=udpliteEndpointLocalAddress, udpliteBaseGroup=udpliteBaseGroup, udpliteMIBCompliance=udpliteMIBCompliance, udpliteEndpointTable=udpliteEndpointTable, udpliteEndpointRemotePort=udpliteEndpointRemotePort, udpliteInDatagrams=udpliteInDatagrams, udpliteNoPorts=udpliteNoPorts, udpliteEndpointRemoteAddress=udpliteEndpointRemoteAddress, udpliteMIBGroups=udpliteMIBGroups, udpliteEndpointViolCoverage=udpliteEndpointViolCoverage, udpliteEndpointLocalAddressType=udpliteEndpointLocalAddressType, udpliteEndpointEntry=udpliteEndpointEntry, udpliteOutPartialCov=udpliteOutPartialCov, udpliteMIB=udpliteMIB, udpliteInErrors=udpliteInErrors, udpliteEndpointRemoteAddressType=udpliteEndpointRemoteAddressType, udpliteMIBConformance=udpliteMIBConformance, PYSNMP_MODULE_ID=udpliteMIB, udpliteEndpointLocalPort=udpliteEndpointLocalPort, udplite=udplite, udpliteEndpointProcess=udpliteEndpointProcess, udpliteStatsDiscontinuityTime=udpliteStatsDiscontinuityTime)
