# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import (
    build_administration_begin_upload_test_file_request,
    build_administration_create_or_update_app_components_request,
    build_administration_create_or_update_server_metrics_config_request,
    build_administration_create_or_update_test_request,
    build_administration_delete_test_file_request,
    build_administration_delete_test_request,
    build_administration_get_app_components_request,
    build_administration_get_server_metrics_config_request,
    build_administration_get_test_file_request,
    build_administration_get_test_request,
    build_administration_list_test_files_request,
    build_administration_list_tests_request,
    build_test_run_create_or_update_app_components_request,
    build_test_run_create_or_update_server_metrics_config_request,
    build_test_run_delete_test_run_request,
    build_test_run_get_app_components_request,
    build_test_run_get_metric_definitions_request,
    build_test_run_get_metric_namespaces_request,
    build_test_run_get_server_metrics_config_request,
    build_test_run_get_test_run_file_request,
    build_test_run_get_test_run_request,
    build_test_run_list_metric_dimension_values_request,
    build_test_run_list_metrics_request,
    build_test_run_list_test_runs_request,
    build_test_run_stop_test_run_request,
    build_test_run_test_run_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AdministrationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.developer.loadtesting._generated.aio.LoadTestingClient`'s
        :attr:`administration` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_or_update_test(
        self, test_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Create a new test or update an existing test.

        Create a new test or update an existing test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Load test model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test description.
                    "displayName": "str",  # Optional. Display name of a test.
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "inputArtifacts": {
                        "additionalFileInfo": [
                            {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        ],
                        "configFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "inputArtifactsZipFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "testScriptFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "userPropFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        }
                    },
                    "keyvaultReferenceIdentityId": "str",  # Optional. Resource Id of the managed
                      identity referencing the Key vault.
                    "keyvaultReferenceIdentityType": "str",  # Optional. Type of the managed
                      identity referencing the Key vault.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testId": "str"  # Optional. Unique test name as identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test description.
                    "displayName": "str",  # Optional. Display name of a test.
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "inputArtifacts": {
                        "additionalFileInfo": [
                            {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        ],
                        "configFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "inputArtifactsZipFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "testScriptFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "userPropFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        }
                    },
                    "keyvaultReferenceIdentityId": "str",  # Optional. Resource Id of the managed
                      identity referencing the Key vault.
                    "keyvaultReferenceIdentityType": "str",  # Optional. Type of the managed
                      identity referencing the Key vault.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testId": "str"  # Optional. Unique test name as identifier.
                }
        """

    @overload
    async def create_or_update_test(
        self, test_id: str, body: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Create a new test or update an existing test.

        Create a new test or update an existing test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Load test model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test description.
                    "displayName": "str",  # Optional. Display name of a test.
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "inputArtifacts": {
                        "additionalFileInfo": [
                            {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        ],
                        "configFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "inputArtifactsZipFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "testScriptFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "userPropFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        }
                    },
                    "keyvaultReferenceIdentityId": "str",  # Optional. Resource Id of the managed
                      identity referencing the Key vault.
                    "keyvaultReferenceIdentityType": "str",  # Optional. Type of the managed
                      identity referencing the Key vault.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testId": "str"  # Optional. Unique test name as identifier.
                }
        """

    @distributed_trace_async
    async def create_or_update_test(self, test_id: str, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Create a new test or update an existing test.

        Create a new test or update an existing test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Load test model. Is either a JSON type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test description.
                    "displayName": "str",  # Optional. Display name of a test.
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "inputArtifacts": {
                        "additionalFileInfo": [
                            {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        ],
                        "configFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "inputArtifactsZipFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "testScriptFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "userPropFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        }
                    },
                    "keyvaultReferenceIdentityId": "str",  # Optional. Resource Id of the managed
                      identity referencing the Key vault.
                    "keyvaultReferenceIdentityType": "str",  # Optional. Type of the managed
                      identity referencing the Key vault.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testId": "str"  # Optional. Unique test name as identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test description.
                    "displayName": "str",  # Optional. Display name of a test.
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "inputArtifacts": {
                        "additionalFileInfo": [
                            {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        ],
                        "configFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "inputArtifactsZipFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "testScriptFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "userPropFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        }
                    },
                    "keyvaultReferenceIdentityId": "str",  # Optional. Resource Id of the managed
                      identity referencing the Key vault.
                    "keyvaultReferenceIdentityType": "str",  # Optional. Type of the managed
                      identity referencing the Key vault.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testId": "str"  # Optional. Unique test name as identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_administration_create_or_update_test_request(
            test_id=test_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def delete_test(self, test_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Delete a test by its name.

        Delete a test by its name.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_administration_delete_test_request(
            test_id=test_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def get_test(self, test_id: str, **kwargs: Any) -> JSON:
        """Get load test details by test name.

        Get load test details by test name.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test description.
                    "displayName": "str",  # Optional. Display name of a test.
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "inputArtifacts": {
                        "additionalFileInfo": [
                            {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        ],
                        "configFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "inputArtifactsZipFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "testScriptFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "userPropFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        }
                    },
                    "keyvaultReferenceIdentityId": "str",  # Optional. Resource Id of the managed
                      identity referencing the Key vault.
                    "keyvaultReferenceIdentityType": "str",  # Optional. Type of the managed
                      identity referencing the Key vault.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testId": "str"  # Optional. Unique test name as identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_administration_get_test_request(
            test_id=test_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_tests(
        self,
        *,
        orderby: Optional[str] = None,
        search: Optional[str] = None,
        last_modified_start_time: Optional[datetime.datetime] = None,
        last_modified_end_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Get all load tests by the fully qualified resource Id e.g
        subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.

        Get all load tests by the fully qualified resource Id e.g
        subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.

        :keyword orderby: Sort on the supported fields in (field asc/desc) format. eg:
         lastModifiedDateTime asc. Supported fields - lastModifiedDateTime. Default value is None.
        :paramtype orderby: str
        :keyword search: Prefix based, case sensitive search on searchable fields - displayName,
         createdBy. For example, to search for a test, with display name is Login Test, the search
         parameter can be Login. Default value is None.
        :paramtype search: str
        :keyword last_modified_start_time: Start DateTime(ISO 8601 literal format) of the last updated
         time range to filter tests. Default value is None.
        :paramtype last_modified_start_time: ~datetime.datetime
        :keyword last_modified_end_time: End DateTime(ISO 8601 literal format) of the last updated time
         range to filter tests. Default value is None.
        :paramtype last_modified_end_time: ~datetime.datetime
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test description.
                    "displayName": "str",  # Optional. Display name of a test.
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "inputArtifacts": {
                        "additionalFileInfo": [
                            {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        ],
                        "configFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "inputArtifactsZipFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "testScriptFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        },
                        "userPropFileInfo": {
                            "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry
                              time of the file (ISO 8601 literal format).
                            "fileName": "str",  # Optional. Name of the file.
                            "fileType": "str",  # Optional. File type. Known values are:
                              "JMX_FILE", "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                            "url": "str",  # Optional. File URL.
                            "validationFailureDetails": "str",  # Optional. Validation
                              failure error details.
                            "validationStatus": "str"  # Optional. Validation status of
                              the file. Known values are: "NOT_VALIDATED", "VALIDATION_SUCCESS",
                              "VALIDATION_FAILURE", "VALIDATION_INITIATED", and
                              "VALIDATION_NOT_REQUIRED".
                        }
                    },
                    "keyvaultReferenceIdentityId": "str",  # Optional. Resource Id of the managed
                      identity referencing the Key vault.
                    "keyvaultReferenceIdentityType": "str",  # Optional. Type of the managed
                      identity referencing the Key vault.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testId": "str"  # Optional. Unique test name as identifier.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_administration_list_tests_request(
                    orderby=orderby,
                    search=search,
                    last_modified_start_time=last_modified_start_time,
                    last_modified_end_time=last_modified_end_time,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def begin_upload_test_file(
        self, test_id: str, file_name: str, body: IO, *, file_type: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Upload input file for a given test name. File size can't be more than 50 MB. Existing file with
        same name for the given test will be overwritten. File should be provided in the request body
        as application/octet-stream.

        Upload input file for a given test name. File size can't be more than 50 MB. Existing file with
        same name for the given test will be overwritten. File should be provided in the request body
        as application/octet-stream.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param file_name: Unique name for test file with file extension like : App.jmx. Required.
        :type file_name: str
        :param body: The file content as application/octet-stream. Required.
        :type body: IO
        :keyword file_type: File type. Known values are: "JMX_FILE", "USER_PROPERTIES", and
         "ADDITIONAL_ARTIFACTS". Default value is None.
        :paramtype file_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201
                response == {
                    "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry time of the file
                      (ISO 8601 literal format).
                    "fileName": "str",  # Optional. Name of the file.
                    "fileType": "str",  # Optional. File type. Known values are: "JMX_FILE",
                      "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                    "url": "str",  # Optional. File URL.
                    "validationFailureDetails": "str",  # Optional. Validation failure error
                      details.
                    "validationStatus": "str"  # Optional. Validation status of the file. Known
                      values are: "NOT_VALIDATED", "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/octet-stream"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _content = body

        request = build_administration_begin_upload_test_file_request(
            test_id=test_id,
            file_name=file_name,
            file_type=file_type,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_test_file(self, test_id: str, file_name: str, **kwargs: Any) -> JSON:
        """Get test file by the file name.

        Get test file by the file name.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param file_name: File name with file extension like app.jmx. Required.
        :type file_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry time of the file
                      (ISO 8601 literal format).
                    "fileName": "str",  # Optional. Name of the file.
                    "fileType": "str",  # Optional. File type. Known values are: "JMX_FILE",
                      "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                    "url": "str",  # Optional. File URL.
                    "validationFailureDetails": "str",  # Optional. Validation failure error
                      details.
                    "validationStatus": "str"  # Optional. Validation status of the file. Known
                      values are: "NOT_VALIDATED", "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_administration_get_test_file_request(
            test_id=test_id,
            file_name=file_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_test_file(  # pylint: disable=inconsistent-return-statements
        self, test_id: str, file_name: str, **kwargs: Any
    ) -> None:
        """Delete file by the file name for a test.

        Delete file by the file name for a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param file_name: File name with file extension like app.jmx. Required.
        :type file_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_administration_delete_test_file_request(
            test_id=test_id,
            file_name=file_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_test_files(self, test_id: str, **kwargs: Any) -> AsyncIterable[JSON]:
        """Get all test files.

        Get all test files.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry time of the file
                      (ISO 8601 literal format).
                    "fileName": "str",  # Optional. Name of the file.
                    "fileType": "str",  # Optional. File type. Known values are: "JMX_FILE",
                      "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                    "url": "str",  # Optional. File URL.
                    "validationFailureDetails": "str",  # Optional. Validation failure error
                      details.
                    "validationStatus": "str"  # Optional. Validation status of the file. Known
                      values are: "NOT_VALIDATED", "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_administration_list_test_files_request(
                    test_id=test_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_or_update_app_components(
        self, test_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Associate an app component (collection of azure resources) to a test.

        Associate an app component (collection of azure resources) to a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: App Component model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testId": "str"  # Optional. Test identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testId": "str"  # Optional. Test identifier.
                }
        """

    @overload
    async def create_or_update_app_components(
        self, test_id: str, body: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Associate an app component (collection of azure resources) to a test.

        Associate an app component (collection of azure resources) to a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: App Component model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testId": "str"  # Optional. Test identifier.
                }
        """

    @distributed_trace_async
    async def create_or_update_app_components(self, test_id: str, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Associate an app component (collection of azure resources) to a test.

        Associate an app component (collection of azure resources) to a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: App Component model. Is either a JSON type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testId": "str"  # Optional. Test identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testId": "str"  # Optional. Test identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_administration_create_or_update_app_components_request(
            test_id=test_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_app_components(self, test_id: str, **kwargs: Any) -> JSON:
        """Get associated app component (collection of azure resources) for the given test.

        Get associated app component (collection of azure resources) for the given test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testId": "str"  # Optional. Test identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_administration_get_app_components_request(
            test_id=test_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update_server_metrics_config(
        self, test_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Configure server metrics for a test.

        Configure server metrics for a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Server metric configuration model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testId": "str"  # Optional. Test identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testId": "str"  # Optional. Test identifier.
                }
        """

    @overload
    async def create_or_update_server_metrics_config(
        self, test_id: str, body: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Configure server metrics for a test.

        Configure server metrics for a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Server metric configuration model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testId": "str"  # Optional. Test identifier.
                }
        """

    @distributed_trace_async
    async def create_or_update_server_metrics_config(self, test_id: str, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Configure server metrics for a test.

        Configure server metrics for a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Server metric configuration model. Is either a JSON type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testId": "str"  # Optional. Test identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testId": "str"  # Optional. Test identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_administration_create_or_update_server_metrics_config_request(
            test_id=test_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_server_metrics_config(self, test_id: str, **kwargs: Any) -> JSON:
        """List server metrics configuration for the given test.

        List server metrics configuration for the given test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testId": "str"  # Optional. Test identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_administration_get_server_metrics_config_request(
            test_id=test_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class TestRunOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.developer.loadtesting._generated.aio.LoadTestingClient`'s
        :attr:`test_run` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    async def _test_run_initial(
        self, test_run_id: str, body: Union[JSON, IO], *, old_test_run_id: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_test_run_test_run_request(
            test_run_id=test_run_id,
            old_test_run_id=old_test_run_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def begin_test_run(
        self,
        test_run_id: str,
        body: JSON,
        *,
        old_test_run_id: Optional[str] = None,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create and start a new test run with the given name.

        Create and start a new test run with the given name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Load test run model. Required.
        :type body: JSON
        :keyword old_test_run_id: Existing test run identifier that should be rerun, if this is
         provided, the test will run with the JMX file, configuration and app components from the
         existing test run. You can override the configuration values for new test run in the request
         body. Default value is None.
        :paramtype old_test_run_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test run description.
                    "displayName": "str",  # Optional. Display name of a testRun.
                    "duration": 0,  # Optional. Test run duration in milliseconds.
                    "endDateTime": "2020-02-20 00:00:00",  # Optional. The test run end
                      DateTime(ISO 8601 literal format).
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "errorDetails": [
                        {
                            "message": "str"  # Optional. Error details in case test run
                              was not successfully run.
                        }
                    ],
                    "executedDateTime": "2020-02-20 00:00:00",  # Optional. Test run initiated
                      time.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "portalUrl": "str",  # Optional. Portal url.
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "startDateTime": "2020-02-20 00:00:00",  # Optional. The test run start
                      DateTime(ISO 8601 literal format).
                    "status": "str",  # Optional. The test run status. Known values are:
                      "ACCEPTED", "NOTSTARTED", "PROVISIONING", "PROVISIONED", "CONFIGURING",
                      "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING", "DEPROVISIONED", "DONE",
                      "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
                      "VALIDATION_FAILURE".
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testArtifacts": {
                        "inputArtifacts": {
                            "additionalFileInfo": [
                                {
                                    "expireDateTime": "2020-02-20 00:00:00",  #
                                      Optional. Expiry time of the file (ISO 8601 literal format).
                                    "fileName": "str",  # Optional. Name of the
                                      file.
                                    "fileType": "str",  # Optional. File type.
                                      Known values are: "JMX_FILE", "USER_PROPERTIES", and
                                      "ADDITIONAL_ARTIFACTS".
                                    "url": "str",  # Optional. File URL.
                                    "validationFailureDetails": "str",  #
                                      Optional. Validation failure error details.
                                    "validationStatus": "str"  # Optional.
                                      Validation status of the file. Known values are: "NOT_VALIDATED",
                                      "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                                }
                            ],
                            "configFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "inputArtifactsZipFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "testScriptFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "userPropFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        },
                        "outputArtifacts": {
                            "logsFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "resultFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        }
                    },
                    "testId": "str",  # Optional. Associated test Id.
                    "testResult": "str",  # Optional. Test result for pass/Fail criteria used
                      during the test run. Known values are: "PASSED", "NOT_APPLICABLE", and "FAILED".
                    "testRunId": "str",  # Optional. Unique test run name as identifier.
                    "testRunStatistics": {
                        "str": {
                            "errorCount": 0.0,  # Optional. Error count.
                            "errorPct": 0.0,  # Optional. Error percentage.
                            "maxResTime": 0.0,  # Optional. Max response time.
                            "meanResTime": 0.0,  # Optional. Mean response time.
                            "medianResTime": 0.0,  # Optional. Median response time.
                            "minResTime": 0.0,  # Optional. Minimum response time.
                            "pct1ResTime": 0.0,  # Optional. 90 percentile response time.
                            "pct2ResTime": 0.0,  # Optional. 95 percentile response time.
                            "pct3ResTime": 0.0,  # Optional. 99 percentile response time.
                            "receivedKBytesPerSec": 0.0,  # Optional. Received network
                              bytes.
                            "sampleCount": 0.0,  # Optional. Sampler count.
                            "sentKBytesPerSec": 0.0,  # Optional. Send network bytes.
                            "throughput": 0.0,  # Optional. Throughput.
                            "transaction": "str"  # Optional. Transaction name.
                        }
                    },
                    "virtualUsers": 0  # Optional. Number of virtual users, for which test has
                      been run.
                }

                # response body for status code(s): 200, 201
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test run description.
                    "displayName": "str",  # Optional. Display name of a testRun.
                    "duration": 0,  # Optional. Test run duration in milliseconds.
                    "endDateTime": "2020-02-20 00:00:00",  # Optional. The test run end
                      DateTime(ISO 8601 literal format).
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "errorDetails": [
                        {
                            "message": "str"  # Optional. Error details in case test run
                              was not successfully run.
                        }
                    ],
                    "executedDateTime": "2020-02-20 00:00:00",  # Optional. Test run initiated
                      time.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "portalUrl": "str",  # Optional. Portal url.
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "startDateTime": "2020-02-20 00:00:00",  # Optional. The test run start
                      DateTime(ISO 8601 literal format).
                    "status": "str",  # Optional. The test run status. Known values are:
                      "ACCEPTED", "NOTSTARTED", "PROVISIONING", "PROVISIONED", "CONFIGURING",
                      "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING", "DEPROVISIONED", "DONE",
                      "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
                      "VALIDATION_FAILURE".
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testArtifacts": {
                        "inputArtifacts": {
                            "additionalFileInfo": [
                                {
                                    "expireDateTime": "2020-02-20 00:00:00",  #
                                      Optional. Expiry time of the file (ISO 8601 literal format).
                                    "fileName": "str",  # Optional. Name of the
                                      file.
                                    "fileType": "str",  # Optional. File type.
                                      Known values are: "JMX_FILE", "USER_PROPERTIES", and
                                      "ADDITIONAL_ARTIFACTS".
                                    "url": "str",  # Optional. File URL.
                                    "validationFailureDetails": "str",  #
                                      Optional. Validation failure error details.
                                    "validationStatus": "str"  # Optional.
                                      Validation status of the file. Known values are: "NOT_VALIDATED",
                                      "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                                }
                            ],
                            "configFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "inputArtifactsZipFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "testScriptFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "userPropFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        },
                        "outputArtifacts": {
                            "logsFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "resultFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        }
                    },
                    "testId": "str",  # Optional. Associated test Id.
                    "testResult": "str",  # Optional. Test result for pass/Fail criteria used
                      during the test run. Known values are: "PASSED", "NOT_APPLICABLE", and "FAILED".
                    "testRunId": "str",  # Optional. Unique test run name as identifier.
                    "testRunStatistics": {
                        "str": {
                            "errorCount": 0.0,  # Optional. Error count.
                            "errorPct": 0.0,  # Optional. Error percentage.
                            "maxResTime": 0.0,  # Optional. Max response time.
                            "meanResTime": 0.0,  # Optional. Mean response time.
                            "medianResTime": 0.0,  # Optional. Median response time.
                            "minResTime": 0.0,  # Optional. Minimum response time.
                            "pct1ResTime": 0.0,  # Optional. 90 percentile response time.
                            "pct2ResTime": 0.0,  # Optional. 95 percentile response time.
                            "pct3ResTime": 0.0,  # Optional. 99 percentile response time.
                            "receivedKBytesPerSec": 0.0,  # Optional. Received network
                              bytes.
                            "sampleCount": 0.0,  # Optional. Sampler count.
                            "sentKBytesPerSec": 0.0,  # Optional. Send network bytes.
                            "throughput": 0.0,  # Optional. Throughput.
                            "transaction": "str"  # Optional. Transaction name.
                        }
                    },
                    "virtualUsers": 0  # Optional. Number of virtual users, for which test has
                      been run.
                }
        """

    @overload
    async def begin_test_run(
        self,
        test_run_id: str,
        body: IO,
        *,
        old_test_run_id: Optional[str] = None,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create and start a new test run with the given name.

        Create and start a new test run with the given name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Load test run model. Required.
        :type body: IO
        :keyword old_test_run_id: Existing test run identifier that should be rerun, if this is
         provided, the test will run with the JMX file, configuration and app components from the
         existing test run. You can override the configuration values for new test run in the request
         body. Default value is None.
        :paramtype old_test_run_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test run description.
                    "displayName": "str",  # Optional. Display name of a testRun.
                    "duration": 0,  # Optional. Test run duration in milliseconds.
                    "endDateTime": "2020-02-20 00:00:00",  # Optional. The test run end
                      DateTime(ISO 8601 literal format).
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "errorDetails": [
                        {
                            "message": "str"  # Optional. Error details in case test run
                              was not successfully run.
                        }
                    ],
                    "executedDateTime": "2020-02-20 00:00:00",  # Optional. Test run initiated
                      time.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "portalUrl": "str",  # Optional. Portal url.
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "startDateTime": "2020-02-20 00:00:00",  # Optional. The test run start
                      DateTime(ISO 8601 literal format).
                    "status": "str",  # Optional. The test run status. Known values are:
                      "ACCEPTED", "NOTSTARTED", "PROVISIONING", "PROVISIONED", "CONFIGURING",
                      "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING", "DEPROVISIONED", "DONE",
                      "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
                      "VALIDATION_FAILURE".
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testArtifacts": {
                        "inputArtifacts": {
                            "additionalFileInfo": [
                                {
                                    "expireDateTime": "2020-02-20 00:00:00",  #
                                      Optional. Expiry time of the file (ISO 8601 literal format).
                                    "fileName": "str",  # Optional. Name of the
                                      file.
                                    "fileType": "str",  # Optional. File type.
                                      Known values are: "JMX_FILE", "USER_PROPERTIES", and
                                      "ADDITIONAL_ARTIFACTS".
                                    "url": "str",  # Optional. File URL.
                                    "validationFailureDetails": "str",  #
                                      Optional. Validation failure error details.
                                    "validationStatus": "str"  # Optional.
                                      Validation status of the file. Known values are: "NOT_VALIDATED",
                                      "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                                }
                            ],
                            "configFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "inputArtifactsZipFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "testScriptFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "userPropFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        },
                        "outputArtifacts": {
                            "logsFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "resultFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        }
                    },
                    "testId": "str",  # Optional. Associated test Id.
                    "testResult": "str",  # Optional. Test result for pass/Fail criteria used
                      during the test run. Known values are: "PASSED", "NOT_APPLICABLE", and "FAILED".
                    "testRunId": "str",  # Optional. Unique test run name as identifier.
                    "testRunStatistics": {
                        "str": {
                            "errorCount": 0.0,  # Optional. Error count.
                            "errorPct": 0.0,  # Optional. Error percentage.
                            "maxResTime": 0.0,  # Optional. Max response time.
                            "meanResTime": 0.0,  # Optional. Mean response time.
                            "medianResTime": 0.0,  # Optional. Median response time.
                            "minResTime": 0.0,  # Optional. Minimum response time.
                            "pct1ResTime": 0.0,  # Optional. 90 percentile response time.
                            "pct2ResTime": 0.0,  # Optional. 95 percentile response time.
                            "pct3ResTime": 0.0,  # Optional. 99 percentile response time.
                            "receivedKBytesPerSec": 0.0,  # Optional. Received network
                              bytes.
                            "sampleCount": 0.0,  # Optional. Sampler count.
                            "sentKBytesPerSec": 0.0,  # Optional. Send network bytes.
                            "throughput": 0.0,  # Optional. Throughput.
                            "transaction": "str"  # Optional. Transaction name.
                        }
                    },
                    "virtualUsers": 0  # Optional. Number of virtual users, for which test has
                      been run.
                }
        """

    @distributed_trace_async
    async def begin_test_run(
        self, test_run_id: str, body: Union[JSON, IO], *, old_test_run_id: Optional[str] = None, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Create and start a new test run with the given name.

        Create and start a new test run with the given name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Load test run model. Is either a JSON type or a IO type. Required.
        :type body: JSON or IO
        :keyword old_test_run_id: Existing test run identifier that should be rerun, if this is
         provided, the test will run with the JMX file, configuration and app components from the
         existing test run. You can override the configuration values for new test run in the request
         body. Default value is None.
        :paramtype old_test_run_id: str
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test run description.
                    "displayName": "str",  # Optional. Display name of a testRun.
                    "duration": 0,  # Optional. Test run duration in milliseconds.
                    "endDateTime": "2020-02-20 00:00:00",  # Optional. The test run end
                      DateTime(ISO 8601 literal format).
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "errorDetails": [
                        {
                            "message": "str"  # Optional. Error details in case test run
                              was not successfully run.
                        }
                    ],
                    "executedDateTime": "2020-02-20 00:00:00",  # Optional. Test run initiated
                      time.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "portalUrl": "str",  # Optional. Portal url.
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "startDateTime": "2020-02-20 00:00:00",  # Optional. The test run start
                      DateTime(ISO 8601 literal format).
                    "status": "str",  # Optional. The test run status. Known values are:
                      "ACCEPTED", "NOTSTARTED", "PROVISIONING", "PROVISIONED", "CONFIGURING",
                      "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING", "DEPROVISIONED", "DONE",
                      "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
                      "VALIDATION_FAILURE".
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testArtifacts": {
                        "inputArtifacts": {
                            "additionalFileInfo": [
                                {
                                    "expireDateTime": "2020-02-20 00:00:00",  #
                                      Optional. Expiry time of the file (ISO 8601 literal format).
                                    "fileName": "str",  # Optional. Name of the
                                      file.
                                    "fileType": "str",  # Optional. File type.
                                      Known values are: "JMX_FILE", "USER_PROPERTIES", and
                                      "ADDITIONAL_ARTIFACTS".
                                    "url": "str",  # Optional. File URL.
                                    "validationFailureDetails": "str",  #
                                      Optional. Validation failure error details.
                                    "validationStatus": "str"  # Optional.
                                      Validation status of the file. Known values are: "NOT_VALIDATED",
                                      "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                                }
                            ],
                            "configFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "inputArtifactsZipFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "testScriptFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "userPropFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        },
                        "outputArtifacts": {
                            "logsFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "resultFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        }
                    },
                    "testId": "str",  # Optional. Associated test Id.
                    "testResult": "str",  # Optional. Test result for pass/Fail criteria used
                      during the test run. Known values are: "PASSED", "NOT_APPLICABLE", and "FAILED".
                    "testRunId": "str",  # Optional. Unique test run name as identifier.
                    "testRunStatistics": {
                        "str": {
                            "errorCount": 0.0,  # Optional. Error count.
                            "errorPct": 0.0,  # Optional. Error percentage.
                            "maxResTime": 0.0,  # Optional. Max response time.
                            "meanResTime": 0.0,  # Optional. Mean response time.
                            "medianResTime": 0.0,  # Optional. Median response time.
                            "minResTime": 0.0,  # Optional. Minimum response time.
                            "pct1ResTime": 0.0,  # Optional. 90 percentile response time.
                            "pct2ResTime": 0.0,  # Optional. 95 percentile response time.
                            "pct3ResTime": 0.0,  # Optional. 99 percentile response time.
                            "receivedKBytesPerSec": 0.0,  # Optional. Received network
                              bytes.
                            "sampleCount": 0.0,  # Optional. Sampler count.
                            "sentKBytesPerSec": 0.0,  # Optional. Send network bytes.
                            "throughput": 0.0,  # Optional. Throughput.
                            "transaction": "str"  # Optional. Transaction name.
                        }
                    },
                    "virtualUsers": 0  # Optional. Number of virtual users, for which test has
                      been run.
                }

                # response body for status code(s): 200, 201
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test run description.
                    "displayName": "str",  # Optional. Display name of a testRun.
                    "duration": 0,  # Optional. Test run duration in milliseconds.
                    "endDateTime": "2020-02-20 00:00:00",  # Optional. The test run end
                      DateTime(ISO 8601 literal format).
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "errorDetails": [
                        {
                            "message": "str"  # Optional. Error details in case test run
                              was not successfully run.
                        }
                    ],
                    "executedDateTime": "2020-02-20 00:00:00",  # Optional. Test run initiated
                      time.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "portalUrl": "str",  # Optional. Portal url.
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "startDateTime": "2020-02-20 00:00:00",  # Optional. The test run start
                      DateTime(ISO 8601 literal format).
                    "status": "str",  # Optional. The test run status. Known values are:
                      "ACCEPTED", "NOTSTARTED", "PROVISIONING", "PROVISIONED", "CONFIGURING",
                      "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING", "DEPROVISIONED", "DONE",
                      "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
                      "VALIDATION_FAILURE".
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testArtifacts": {
                        "inputArtifacts": {
                            "additionalFileInfo": [
                                {
                                    "expireDateTime": "2020-02-20 00:00:00",  #
                                      Optional. Expiry time of the file (ISO 8601 literal format).
                                    "fileName": "str",  # Optional. Name of the
                                      file.
                                    "fileType": "str",  # Optional. File type.
                                      Known values are: "JMX_FILE", "USER_PROPERTIES", and
                                      "ADDITIONAL_ARTIFACTS".
                                    "url": "str",  # Optional. File URL.
                                    "validationFailureDetails": "str",  #
                                      Optional. Validation failure error details.
                                    "validationStatus": "str"  # Optional.
                                      Validation status of the file. Known values are: "NOT_VALIDATED",
                                      "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                                }
                            ],
                            "configFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "inputArtifactsZipFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "testScriptFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "userPropFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        },
                        "outputArtifacts": {
                            "logsFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "resultFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        }
                    },
                    "testId": "str",  # Optional. Associated test Id.
                    "testResult": "str",  # Optional. Test result for pass/Fail criteria used
                      during the test run. Known values are: "PASSED", "NOT_APPLICABLE", and "FAILED".
                    "testRunId": "str",  # Optional. Unique test run name as identifier.
                    "testRunStatistics": {
                        "str": {
                            "errorCount": 0.0,  # Optional. Error count.
                            "errorPct": 0.0,  # Optional. Error percentage.
                            "maxResTime": 0.0,  # Optional. Max response time.
                            "meanResTime": 0.0,  # Optional. Mean response time.
                            "medianResTime": 0.0,  # Optional. Median response time.
                            "minResTime": 0.0,  # Optional. Minimum response time.
                            "pct1ResTime": 0.0,  # Optional. 90 percentile response time.
                            "pct2ResTime": 0.0,  # Optional. 95 percentile response time.
                            "pct3ResTime": 0.0,  # Optional. 99 percentile response time.
                            "receivedKBytesPerSec": 0.0,  # Optional. Received network
                              bytes.
                            "sampleCount": 0.0,  # Optional. Sampler count.
                            "sentKBytesPerSec": 0.0,  # Optional. Send network bytes.
                            "throughput": 0.0,  # Optional. Throughput.
                            "transaction": "str"  # Optional. Transaction name.
                        }
                    },
                    "virtualUsers": 0  # Optional. Number of virtual users, for which test has
                      been run.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._test_run_initial(
                test_run_id=test_run_id,
                body=body,
                old_test_run_id=old_test_run_id,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncLROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_test_run(self, test_run_id: str, **kwargs: Any) -> JSON:
        """Get test run details by name.

        Get test run details by name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test run description.
                    "displayName": "str",  # Optional. Display name of a testRun.
                    "duration": 0,  # Optional. Test run duration in milliseconds.
                    "endDateTime": "2020-02-20 00:00:00",  # Optional. The test run end
                      DateTime(ISO 8601 literal format).
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "errorDetails": [
                        {
                            "message": "str"  # Optional. Error details in case test run
                              was not successfully run.
                        }
                    ],
                    "executedDateTime": "2020-02-20 00:00:00",  # Optional. Test run initiated
                      time.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "portalUrl": "str",  # Optional. Portal url.
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "startDateTime": "2020-02-20 00:00:00",  # Optional. The test run start
                      DateTime(ISO 8601 literal format).
                    "status": "str",  # Optional. The test run status. Known values are:
                      "ACCEPTED", "NOTSTARTED", "PROVISIONING", "PROVISIONED", "CONFIGURING",
                      "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING", "DEPROVISIONED", "DONE",
                      "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
                      "VALIDATION_FAILURE".
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testArtifacts": {
                        "inputArtifacts": {
                            "additionalFileInfo": [
                                {
                                    "expireDateTime": "2020-02-20 00:00:00",  #
                                      Optional. Expiry time of the file (ISO 8601 literal format).
                                    "fileName": "str",  # Optional. Name of the
                                      file.
                                    "fileType": "str",  # Optional. File type.
                                      Known values are: "JMX_FILE", "USER_PROPERTIES", and
                                      "ADDITIONAL_ARTIFACTS".
                                    "url": "str",  # Optional. File URL.
                                    "validationFailureDetails": "str",  #
                                      Optional. Validation failure error details.
                                    "validationStatus": "str"  # Optional.
                                      Validation status of the file. Known values are: "NOT_VALIDATED",
                                      "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                                }
                            ],
                            "configFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "inputArtifactsZipFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "testScriptFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "userPropFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        },
                        "outputArtifacts": {
                            "logsFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "resultFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        }
                    },
                    "testId": "str",  # Optional. Associated test Id.
                    "testResult": "str",  # Optional. Test result for pass/Fail criteria used
                      during the test run. Known values are: "PASSED", "NOT_APPLICABLE", and "FAILED".
                    "testRunId": "str",  # Optional. Unique test run name as identifier.
                    "testRunStatistics": {
                        "str": {
                            "errorCount": 0.0,  # Optional. Error count.
                            "errorPct": 0.0,  # Optional. Error percentage.
                            "maxResTime": 0.0,  # Optional. Max response time.
                            "meanResTime": 0.0,  # Optional. Mean response time.
                            "medianResTime": 0.0,  # Optional. Median response time.
                            "minResTime": 0.0,  # Optional. Minimum response time.
                            "pct1ResTime": 0.0,  # Optional. 90 percentile response time.
                            "pct2ResTime": 0.0,  # Optional. 95 percentile response time.
                            "pct3ResTime": 0.0,  # Optional. 99 percentile response time.
                            "receivedKBytesPerSec": 0.0,  # Optional. Received network
                              bytes.
                            "sampleCount": 0.0,  # Optional. Sampler count.
                            "sentKBytesPerSec": 0.0,  # Optional. Send network bytes.
                            "throughput": 0.0,  # Optional. Throughput.
                            "transaction": "str"  # Optional. Transaction name.
                        }
                    },
                    "virtualUsers": 0  # Optional. Number of virtual users, for which test has
                      been run.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_test_run_get_test_run_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_test_run(  # pylint: disable=inconsistent-return-statements
        self, test_run_id: str, **kwargs: Any
    ) -> None:
        """Delete a test run by its name.

        Delete a test run by its name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_test_run_delete_test_run_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def get_test_run_file(self, test_run_id: str, file_name: str, **kwargs: Any) -> JSON:
        """Get test run file by file name.

        Get test run file by file name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param file_name: Test run file name with file extension. Required.
        :type file_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "expireDateTime": "2020-02-20 00:00:00",  # Optional. Expiry time of the file
                      (ISO 8601 literal format).
                    "fileName": "str",  # Optional. Name of the file.
                    "fileType": "str",  # Optional. File type. Known values are: "JMX_FILE",
                      "USER_PROPERTIES", and "ADDITIONAL_ARTIFACTS".
                    "url": "str",  # Optional. File URL.
                    "validationFailureDetails": "str",  # Optional. Validation failure error
                      details.
                    "validationStatus": "str"  # Optional. Validation status of the file. Known
                      values are: "NOT_VALIDATED", "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_test_run_get_test_run_file_request(
            test_run_id=test_run_id,
            file_name=file_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_test_runs(
        self,
        *,
        orderby: Optional[str] = None,
        search: Optional[str] = None,
        test_id: Optional[str] = None,
        execution_from: Optional[datetime.datetime] = None,
        execution_to: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Get all test runs with given filters.

        Get all test runs with given filters.

        :keyword orderby: Sort on the supported fields in (field asc/desc) format. eg: executedDateTime
         asc. Supported fields - executedDateTime. Default value is None.
        :paramtype orderby: str
        :keyword search: Prefix based, case sensitive search on searchable fields - description,
         executedUser. For example, to search for a test run, with description 500 VUs, the search
         parameter can be 500. Default value is None.
        :paramtype search: str
        :keyword test_id: Unique name of an existing load test. Default value is None.
        :paramtype test_id: str
        :keyword execution_from: Start DateTime(ISO 8601 literal format) of test-run execution time
         filter range. Default value is None.
        :paramtype execution_from: ~datetime.datetime
        :keyword execution_to: End DateTime(ISO 8601 literal format) of test-run execution time filter
         range. Default value is None.
        :paramtype execution_to: ~datetime.datetime
        :keyword status: Comma separated list of test run status. Default value is None.
        :paramtype status: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test run description.
                    "displayName": "str",  # Optional. Display name of a testRun.
                    "duration": 0,  # Optional. Test run duration in milliseconds.
                    "endDateTime": "2020-02-20 00:00:00",  # Optional. The test run end
                      DateTime(ISO 8601 literal format).
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "errorDetails": [
                        {
                            "message": "str"  # Optional. Error details in case test run
                              was not successfully run.
                        }
                    ],
                    "executedDateTime": "2020-02-20 00:00:00",  # Optional. Test run initiated
                      time.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "portalUrl": "str",  # Optional. Portal url.
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "startDateTime": "2020-02-20 00:00:00",  # Optional. The test run start
                      DateTime(ISO 8601 literal format).
                    "status": "str",  # Optional. The test run status. Known values are:
                      "ACCEPTED", "NOTSTARTED", "PROVISIONING", "PROVISIONED", "CONFIGURING",
                      "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING", "DEPROVISIONED", "DONE",
                      "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
                      "VALIDATION_FAILURE".
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testArtifacts": {
                        "inputArtifacts": {
                            "additionalFileInfo": [
                                {
                                    "expireDateTime": "2020-02-20 00:00:00",  #
                                      Optional. Expiry time of the file (ISO 8601 literal format).
                                    "fileName": "str",  # Optional. Name of the
                                      file.
                                    "fileType": "str",  # Optional. File type.
                                      Known values are: "JMX_FILE", "USER_PROPERTIES", and
                                      "ADDITIONAL_ARTIFACTS".
                                    "url": "str",  # Optional. File URL.
                                    "validationFailureDetails": "str",  #
                                      Optional. Validation failure error details.
                                    "validationStatus": "str"  # Optional.
                                      Validation status of the file. Known values are: "NOT_VALIDATED",
                                      "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                                }
                            ],
                            "configFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "inputArtifactsZipFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "testScriptFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "userPropFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        },
                        "outputArtifacts": {
                            "logsFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "resultFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        }
                    },
                    "testId": "str",  # Optional. Associated test Id.
                    "testResult": "str",  # Optional. Test result for pass/Fail criteria used
                      during the test run. Known values are: "PASSED", "NOT_APPLICABLE", and "FAILED".
                    "testRunId": "str",  # Optional. Unique test run name as identifier.
                    "testRunStatistics": {
                        "str": {
                            "errorCount": 0.0,  # Optional. Error count.
                            "errorPct": 0.0,  # Optional. Error percentage.
                            "maxResTime": 0.0,  # Optional. Max response time.
                            "meanResTime": 0.0,  # Optional. Mean response time.
                            "medianResTime": 0.0,  # Optional. Median response time.
                            "minResTime": 0.0,  # Optional. Minimum response time.
                            "pct1ResTime": 0.0,  # Optional. 90 percentile response time.
                            "pct2ResTime": 0.0,  # Optional. 95 percentile response time.
                            "pct3ResTime": 0.0,  # Optional. 99 percentile response time.
                            "receivedKBytesPerSec": 0.0,  # Optional. Received network
                              bytes.
                            "sampleCount": 0.0,  # Optional. Sampler count.
                            "sentKBytesPerSec": 0.0,  # Optional. Send network bytes.
                            "throughput": 0.0,  # Optional. Throughput.
                            "transaction": "str"  # Optional. Transaction name.
                        }
                    },
                    "virtualUsers": 0  # Optional. Number of virtual users, for which test has
                      been run.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_test_run_list_test_runs_request(
                    orderby=orderby,
                    search=search,
                    test_id=test_id,
                    execution_from=execution_from,
                    execution_to=execution_to,
                    status=status,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def stop_test_run(self, test_run_id: str, **kwargs: Any) -> JSON:
        """Stop test run by name.

        Stop test run by name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "certificate": {
                        "name": "str",  # Optional. Name of the certificate.
                        "type": "str",  # Optional. Type of certificate. "AKV_CERT_URI"
                        "value": "str"  # Optional. The value of the certificate for
                          respective type.
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "description": "str",  # Optional. The test run description.
                    "displayName": "str",  # Optional. Display name of a testRun.
                    "duration": 0,  # Optional. Test run duration in milliseconds.
                    "endDateTime": "2020-02-20 00:00:00",  # Optional. The test run end
                      DateTime(ISO 8601 literal format).
                    "environmentVariables": {
                        "str": "str"  # Optional. Environment variables which are defined as
                          a set of <name,value> pairs.
                    },
                    "errorDetails": [
                        {
                            "message": "str"  # Optional. Error details in case test run
                              was not successfully run.
                        }
                    ],
                    "executedDateTime": "2020-02-20 00:00:00",  # Optional. Test run initiated
                      time.
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "loadTestConfiguration": {
                        "engineInstances": 0,  # Optional. The number of engine instances to
                          execute load test. Supported values are in range of 1-45. Required for
                          creating a new test.
                        "optionalLoadTestConfig": {
                            "duration": 0,  # Optional. Test run duration.
                            "endpointUrl": "str",  # Optional. Test URL. Provide the
                              complete HTTP URL. For example,
                              http://contoso-app.azurewebsites.net/login.
                            "rampUpTime": 0,  # Optional. Ramp up time.
                            "virtualUsers": 0  # Optional. No of concurrent virtual
                              users.
                        },
                        "quickStartTest": False,  # Optional. Default value is False. If
                          true, optionalLoadTestConfig is required and JMX script for the load test is
                          not required to upload.
                        "splitAllCSVs": False  # Optional. Default value is False. If false,
                          Azure Load Testing copies and processes your input files unmodified across
                          all test engine instances. If true, Azure Load Testing splits the CSV input
                          data evenly across all engine instances. If you provide multiple CSV files,
                          each file will be split evenly.
                    },
                    "passFailCriteria": {
                        "passFailMetrics": {
                            "str": {
                                "action": "continue",  # Optional. Default value is
                                  "continue". Action taken after the threshold is met. Default is
                                  "u2018continue"u2019. Known values are: "continue" and "stop".
                                "actualValue": 0.0,  # Optional. The actual value of
                                  the client metric for the test run.
                                "aggregate": "str",  # Optional. The aggregation
                                  function to be applied on the client metric. Allowed functions -
                                  "u2018percentage"u2019 - for error metric , "u2018avg"u2019,
                                  "u2018p50"u2019, "u2018p90"u2019, "u2018p95"u2019, "u2018p99"u2019,
                                  "u2018min"u2019, "u2018max"u2019 - for response_time_ms and latency
                                  metric, "u2018avg"u2019 - for requests_per_sec, "u2018count"u2019 -
                                  for requests. Known values are: "count", "percentage", "avg", "p50",
                                  "p90", "p95", "p99", "min", and "max".
                                "clientMetric": "str",  # Optional. The client metric
                                  on which the criteria should be applied. Known values are:
                                  "response_time_ms", "latency", "error", "requests", and
                                  "requests_per_sec".
                                "condition": "str",  # Optional. The comparison
                                  operator. Supported types "u2018>"u2019, "u2018<"u2019.
                                "requestName": "str",  # Optional. Request name for
                                  which the Pass fail criteria has to be applied.
                                "result": "str",  # Optional. Outcome of the test
                                  run. Known values are: "passed", "undetermined", and "failed".
                                "value": 0.0  # Optional. The value to compare with
                                  the client metric. Allowed values - "u2018error : [0.0 , 100.0] unit-
                                  % "u2019, response_time_ms and latency : any integer value unit- ms.
                            }
                        }
                    },
                    "portalUrl": "str",  # Optional. Portal url.
                    "secrets": {
                        "str": {
                            "type": "str",  # Optional. Type of secret. Known values are:
                              "AKV_SECRET_URI" and "SECRET_VALUE".
                            "value": "str"  # Optional. The value of the secret for the
                              respective type.
                        }
                    },
                    "startDateTime": "2020-02-20 00:00:00",  # Optional. The test run start
                      DateTime(ISO 8601 literal format).
                    "status": "str",  # Optional. The test run status. Known values are:
                      "ACCEPTED", "NOTSTARTED", "PROVISIONING", "PROVISIONED", "CONFIGURING",
                      "CONFIGURED", "EXECUTING", "EXECUTED", "DEPROVISIONING", "DEPROVISIONED", "DONE",
                      "CANCELLING", "CANCELLED", "FAILED", "VALIDATION_SUCCESS", and
                      "VALIDATION_FAILURE".
                    "subnetId": "str",  # Optional. Subnet ID on which the load test instances
                      should run.
                    "testArtifacts": {
                        "inputArtifacts": {
                            "additionalFileInfo": [
                                {
                                    "expireDateTime": "2020-02-20 00:00:00",  #
                                      Optional. Expiry time of the file (ISO 8601 literal format).
                                    "fileName": "str",  # Optional. Name of the
                                      file.
                                    "fileType": "str",  # Optional. File type.
                                      Known values are: "JMX_FILE", "USER_PROPERTIES", and
                                      "ADDITIONAL_ARTIFACTS".
                                    "url": "str",  # Optional. File URL.
                                    "validationFailureDetails": "str",  #
                                      Optional. Validation failure error details.
                                    "validationStatus": "str"  # Optional.
                                      Validation status of the file. Known values are: "NOT_VALIDATED",
                                      "VALIDATION_SUCCESS", "VALIDATION_FAILURE",
                                      "VALIDATION_INITIATED", and "VALIDATION_NOT_REQUIRED".
                                }
                            ],
                            "configFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "inputArtifactsZipFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "testScriptFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "userPropFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        },
                        "outputArtifacts": {
                            "logsFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            },
                            "resultFileInfo": {
                                "expireDateTime": "2020-02-20 00:00:00",  # Optional.
                                  Expiry time of the file (ISO 8601 literal format).
                                "fileName": "str",  # Optional. Name of the file.
                                "fileType": "str",  # Optional. File type. Known
                                  values are: "JMX_FILE", "USER_PROPERTIES", and
                                  "ADDITIONAL_ARTIFACTS".
                                "url": "str",  # Optional. File URL.
                                "validationFailureDetails": "str",  # Optional.
                                  Validation failure error details.
                                "validationStatus": "str"  # Optional. Validation
                                  status of the file. Known values are: "NOT_VALIDATED",
                                  "VALIDATION_SUCCESS", "VALIDATION_FAILURE", "VALIDATION_INITIATED",
                                  and "VALIDATION_NOT_REQUIRED".
                            }
                        }
                    },
                    "testId": "str",  # Optional. Associated test Id.
                    "testResult": "str",  # Optional. Test result for pass/Fail criteria used
                      during the test run. Known values are: "PASSED", "NOT_APPLICABLE", and "FAILED".
                    "testRunId": "str",  # Optional. Unique test run name as identifier.
                    "testRunStatistics": {
                        "str": {
                            "errorCount": 0.0,  # Optional. Error count.
                            "errorPct": 0.0,  # Optional. Error percentage.
                            "maxResTime": 0.0,  # Optional. Max response time.
                            "meanResTime": 0.0,  # Optional. Mean response time.
                            "medianResTime": 0.0,  # Optional. Median response time.
                            "minResTime": 0.0,  # Optional. Minimum response time.
                            "pct1ResTime": 0.0,  # Optional. 90 percentile response time.
                            "pct2ResTime": 0.0,  # Optional. 95 percentile response time.
                            "pct3ResTime": 0.0,  # Optional. 99 percentile response time.
                            "receivedKBytesPerSec": 0.0,  # Optional. Received network
                              bytes.
                            "sampleCount": 0.0,  # Optional. Sampler count.
                            "sentKBytesPerSec": 0.0,  # Optional. Send network bytes.
                            "throughput": 0.0,  # Optional. Throughput.
                            "transaction": "str"  # Optional. Transaction name.
                        }
                    },
                    "virtualUsers": 0  # Optional. Number of virtual users, for which test has
                      been run.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_test_run_stop_test_run_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_metric_namespaces(self, test_run_id: str, **kwargs: Any) -> JSON:
        """List the metric namespaces for a load test run.

        List the metric namespaces for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "value": [
                        {
                            "description": "str",  # Optional. The namespace description.
                            "name": "str"  # Optional. The metric namespace name.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_test_run_get_metric_namespaces_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_metric_definitions(self, test_run_id: str, *, metric_namespace: str, **kwargs: Any) -> JSON:
        """List the metric definitions for a load test run.

        List the metric definitions for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "value": [
                        {
                            "description": "str",  # Optional. The metric description.
                            "dimensions": [
                                {
                                    "description": "str",  # Optional. The
                                      description.
                                    "name": "str"  # Optional. The name.
                                }
                            ],
                            "metricAvailabilities": [
                                {
                                    "timeGrain": "str"  # Optional. The time
                                      grain specifies the aggregation interval for the metric.
                                      Expressed as a duration 'PT1M', 'PT1H', etc. Known values are:
                                      "PT5S", "PT10S", "PT1M", "PT5M", and "PT1H".
                                }
                            ],
                            "name": "str",  # Optional. The metric name.
                            "namespace": "str",  # Optional. The namespace the metric
                              belongs to.
                            "primaryAggregationType": "str",  # Optional. The primary
                              aggregation type value defining how to use the values for display. Known
                              values are: "Average", "Count", "None", "Total", "Percentile90",
                              "Percentile95", and "Percentile99".
                            "supportedAggregationTypes": [
                                "str"  # Optional. The collection of what all
                                  aggregation types are supported.
                            ],
                            "unit": "str"  # Optional. The unit of the metric. Known
                              values are: "NotSpecified", "Percent", "Count", "Seconds",
                              "Milliseconds", "Bytes", "BytesPerSecond", and "CountPerSecond".
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_test_run_get_metric_definitions_request(
            test_run_id=test_run_id,
            metric_namespace=metric_namespace,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    def list_metrics(
        self,
        test_run_id: str,
        body: Optional[JSON] = None,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        aggregation: Optional[str] = None,
        interval: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """List the metric values for a load test run.

        List the metric values for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Metric dimension filter. Default value is None.
        :type body: JSON
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword aggregation: The aggregation. Default value is None.
        :paramtype aggregation: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "filters": [
                        {
                            "name": "str",  # Optional. The dimension name.
                            "values": [
                                "str"  # Optional. The dimension values. Maximum
                                  values can be 20.
                            ]
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "data": [
                        {
                            "timestamp": "str",  # Optional. The timestamp for the metric
                              value in ISO 8601 format.
                            "value": 0.0  # Optional. The metric value.
                        }
                    ],
                    "dimensionValues": [
                        {
                            "name": "str",  # Optional. The name of the dimension.
                            "value": "str"  # Optional. The value of the dimension.
                        }
                    ]
                }
        """

    @overload
    def list_metrics(
        self,
        test_run_id: str,
        body: Optional[IO] = None,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        aggregation: Optional[str] = None,
        interval: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """List the metric values for a load test run.

        List the metric values for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Metric dimension filter. Default value is None.
        :type body: IO
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword aggregation: The aggregation. Default value is None.
        :paramtype aggregation: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "data": [
                        {
                            "timestamp": "str",  # Optional. The timestamp for the metric
                              value in ISO 8601 format.
                            "value": 0.0  # Optional. The metric value.
                        }
                    ],
                    "dimensionValues": [
                        {
                            "name": "str",  # Optional. The name of the dimension.
                            "value": "str"  # Optional. The value of the dimension.
                        }
                    ]
                }
        """

    @distributed_trace
    def list_metrics(
        self,
        test_run_id: str,
        body: Optional[Union[JSON, IO]] = None,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        aggregation: Optional[str] = None,
        interval: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """List the metric values for a load test run.

        List the metric values for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Metric dimension filter. Is either a JSON type or a IO type. Default value is
         None.
        :type body: JSON or IO
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword aggregation: The aggregation. Default value is None.
        :paramtype aggregation: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "filters": [
                        {
                            "name": "str",  # Optional. The dimension name.
                            "values": [
                                "str"  # Optional. The dimension values. Maximum
                                  values can be 20.
                            ]
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "data": [
                        {
                            "timestamp": "str",  # Optional. The timestamp for the metric
                              value in ISO 8601 format.
                            "value": 0.0  # Optional. The metric value.
                        }
                    ],
                    "dimensionValues": [
                        {
                            "name": "str",  # Optional. The name of the dimension.
                            "value": "str"  # Optional. The value of the dimension.
                        }
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = body
            else:
                _json = None

        def prepare_request(next_link=None):
            if not next_link:

                request = build_test_run_list_metrics_request(
                    test_run_id=test_run_id,
                    metric_name=metric_name,
                    metric_namespace=metric_namespace,
                    time_interval=time_interval,
                    aggregation=aggregation,
                    interval=interval,
                    content_type=content_type,
                    api_version=self._config.api_version,
                    json=_json,
                    content=_content,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_metric_dimension_values(
        self,
        test_run_id: str,
        name: str,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        interval: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[str]:
        """List the dimension values for the given metric dimension name.

        List the dimension values for the given metric dimension name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param name: Dimension name. Required.
        :type name: str
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str
        :return: An iterator like instance of str
        :rtype: ~azure.core.async_paging.AsyncItemPaged[str]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == "str"  # Optional.
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_test_run_list_metric_dimension_values_request(
                    test_run_id=test_run_id,
                    name=name,
                    metric_name=metric_name,
                    metric_namespace=metric_namespace,
                    time_interval=time_interval,
                    interval=interval,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def create_or_update_app_components(
        self, test_run_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Associate an app component (collection of azure resources) to a test run.

        Associate an app component (collection of azure resources) to a test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: App Component model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testRunId": "str"  # Optional. Test run identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testRunId": "str"  # Optional. Test run identifier.
                }
        """

    @overload
    async def create_or_update_app_components(
        self, test_run_id: str, body: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Associate an app component (collection of azure resources) to a test run.

        Associate an app component (collection of azure resources) to a test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: App Component model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testRunId": "str"  # Optional. Test run identifier.
                }
        """

    @distributed_trace_async
    async def create_or_update_app_components(self, test_run_id: str, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Associate an app component (collection of azure resources) to a test run.

        Associate an app component (collection of azure resources) to a test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: App Component model. Is either a JSON type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testRunId": "str"  # Optional. Test run identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testRunId": "str"  # Optional. Test run identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_test_run_create_or_update_app_components_request(
            test_run_id=test_run_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_app_components(self, test_run_id: str, **kwargs: Any) -> JSON:
        """Get associated app component (collection of azure resources) for the given test run.

        Get associated app component (collection of azure resources) for the given test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "components": {
                        "str": {
                            "displayName": "str",  # Optional. Azure resource display
                              name.
                            "kind": "str",  # Optional. Kind of Azure resource type.
                            "resourceGroup": "str",  # Optional. Resource group name of
                              the Azure resource.
                            "resourceId": "str",  # Optional. fully qualified resource Id
                              e.g
                              subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.
                            "resourceName": "str",  # Optional. Azure resource name,
                              required while creating the app component.
                            "resourceType": "str",  # Optional. Azure resource type,
                              required while creating the app component.
                            "subscriptionId": "str"  # Optional. Subscription Id of the
                              Azure resource.
                        }
                    },
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "testRunId": "str"  # Optional. Test run identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_test_run_get_app_components_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def create_or_update_server_metrics_config(
        self, test_run_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Configure server metrics for a test run.

        Configure server metrics for a test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Server metric configuration model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testRunId": "str"  # Optional. Test run identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testRunId": "str"  # Optional. Test run identifier.
                }
        """

    @overload
    async def create_or_update_server_metrics_config(
        self, test_run_id: str, body: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Configure server metrics for a test run.

        Configure server metrics for a test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Server metric configuration model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testRunId": "str"  # Optional. Test run identifier.
                }
        """

    @distributed_trace_async
    async def create_or_update_server_metrics_config(
        self, test_run_id: str, body: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Configure server metrics for a test run.

        Configure server metrics for a test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Server metric configuration model. Is either a JSON type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testRunId": "str"  # Optional. Test run identifier.
                }

                # response body for status code(s): 200, 201
                response == {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testRunId": "str"  # Optional. Test run identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_test_run_create_or_update_server_metrics_config_request(
            test_run_id=test_run_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_server_metrics_config(self, test_run_id: str, **kwargs: Any) -> JSON:
        """List server metrics configuration for the given test run.

        List server metrics configuration for the given test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdBy": "str",  # Optional. The user that created.
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. The creation
                      datetime(ISO 8601 literal format).
                    "lastModifiedBy": "str",  # Optional. The user that last modified.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. The last Modified
                      datetime(ISO 8601 literal format).
                    "metrics": {
                        "str": {
                            "aggregation": "str",  # Metric aggregation. Required.
                            "metricNamespace": "str",  # Metric name space. Required.
                            "name": "str",  # The invariant value of metric name.
                              Required.
                            "resourceId": "str",  # Azure resource id. Required.
                            "resourceType": "str",  # Azure resource type. Required.
                            "displayDescription": "str",  # Optional. Metric description.
                            "id": "str",  # Optional. Unique name for metric.
                            "unit": "str"  # Optional. Metric unit.
                        }
                    },
                    "testRunId": "str"  # Optional. Test run identifier.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_test_run_get_server_metrics_config_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)
