# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._form_recognizer_client_enums import *


class AnalyzeDocumentRequest(msrest.serialization.Model):
    """Document analysis parameters.

    :param url_source: Document URL to analyze.
    :type url_source: str
    :param base64_source: Base64 encoding of the document to analyze.
    :type base64_source: bytearray
    """

    _attribute_map = {
        'url_source': {'key': 'urlSource', 'type': 'str'},
        'base64_source': {'key': 'base64Source', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        url_source: Optional[str] = None,
        base64_source: Optional[bytearray] = None,
        **kwargs
    ):
        super(AnalyzeDocumentRequest, self).__init__(**kwargs)
        self.url_source = url_source
        self.base64_source = base64_source


class AnalyzeResult(msrest.serialization.Model):
    """Document analysis result.

    All required parameters must be populated in order to send to Azure.

    :param api_version: Required. API version used to produce this result. Possible values include:
     "2021-09-30-preview".
    :type api_version: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.ApiVersion
    :param model_id: Required. Model ID used to produce this result.
    :type model_id: str
    :param string_index_type: Required. Method used to compute string offset and length. Possible
     values include: "textElements", "unicodeCodePoint", "utf16CodeUnit".
    :type string_index_type: str or
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.StringIndexType
    :param content: Required. Concatenate string representation of all textual and visual elements
     in reading order.
    :type content: str
    :param pages: Required. Analyzed pages.
    :type pages: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentPage]
    :param tables: Extracted tables.
    :type tables: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentTable]
    :param key_value_pairs: Extracted key-value pairs.
    :type key_value_pairs:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentKeyValuePair]
    :param entities: Extracted entities.
    :type entities: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentEntity]
    :param styles: Extracted font styles.
    :type styles: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentStyle]
    :param documents: Extracted documents.
    :type documents: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.Document]
    """

    _validation = {
        'api_version': {'required': True},
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'string_index_type': {'required': True},
        'content': {'required': True},
        'pages': {'required': True},
    }

    _attribute_map = {
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'model_id': {'key': 'modelId', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'pages': {'key': 'pages', 'type': '[DocumentPage]'},
        'tables': {'key': 'tables', 'type': '[DocumentTable]'},
        'key_value_pairs': {'key': 'keyValuePairs', 'type': '[DocumentKeyValuePair]'},
        'entities': {'key': 'entities', 'type': '[DocumentEntity]'},
        'styles': {'key': 'styles', 'type': '[DocumentStyle]'},
        'documents': {'key': 'documents', 'type': '[Document]'},
    }

    def __init__(
        self,
        *,
        api_version: Union[str, "ApiVersion"],
        model_id: str,
        string_index_type: Union[str, "StringIndexType"],
        content: str,
        pages: List["DocumentPage"],
        tables: Optional[List["DocumentTable"]] = None,
        key_value_pairs: Optional[List["DocumentKeyValuePair"]] = None,
        entities: Optional[List["DocumentEntity"]] = None,
        styles: Optional[List["DocumentStyle"]] = None,
        documents: Optional[List["Document"]] = None,
        **kwargs
    ):
        super(AnalyzeResult, self).__init__(**kwargs)
        self.api_version = api_version
        self.model_id = model_id
        self.string_index_type = string_index_type
        self.content = content
        self.pages = pages
        self.tables = tables
        self.key_value_pairs = key_value_pairs
        self.entities = entities
        self.styles = styles
        self.documents = documents


class AnalyzeResultOperation(msrest.serialization.Model):
    """Status and result of the analyze operation.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Operation status. Possible values include: "notStarted", "running",
     "failed", "succeeded".
    :type status: str or
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.AnalyzeResultOperationStatus
    :param created_date_time: Required. Date and time (UTC) when the analyze operation was
     submitted.
    :type created_date_time: ~datetime.datetime
    :param last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :type last_updated_date_time: ~datetime.datetime
    :param error: Encountered error during document analysis.
    :type error: ~azure.ai.formrecognizer.v2021_09_30_preview.models.Error
    :param analyze_result: Document analysis result.
    :type analyze_result: ~azure.ai.formrecognizer.v2021_09_30_preview.models.AnalyzeResult
    """

    _validation = {
        'status': {'required': True},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'Error'},
        'analyze_result': {'key': 'analyzeResult', 'type': 'AnalyzeResult'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "AnalyzeResultOperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        error: Optional["Error"] = None,
        analyze_result: Optional["AnalyzeResult"] = None,
        **kwargs
    ):
        super(AnalyzeResultOperation, self).__init__(**kwargs)
        self.status = status
        self.created_date_time = created_date_time
        self.last_updated_date_time = last_updated_date_time
        self.error = error
        self.analyze_result = analyze_result


class AuthorizeCopyRequest(msrest.serialization.Model):
    """Request body to authorize model copy.

    All required parameters must be populated in order to send to Azure.

    :param model_id: Required. Unique model name.
    :type model_id: str
    :param description: Model description.
    :type description: str
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        description: Optional[str] = None,
        **kwargs
    ):
        super(AuthorizeCopyRequest, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description


class AzureBlobContentSource(msrest.serialization.Model):
    """Azure Blob Storage content.

    All required parameters must be populated in order to send to Azure.

    :param container_url: Required. Azure Blob Storage container URL.
    :type container_url: str
    :param prefix: Blob name prefix.
    :type prefix: str
    """

    _validation = {
        'container_url': {'required': True},
    }

    _attribute_map = {
        'container_url': {'key': 'containerUrl', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_url: str,
        prefix: Optional[str] = None,
        **kwargs
    ):
        super(AzureBlobContentSource, self).__init__(**kwargs)
        self.container_url = container_url
        self.prefix = prefix


class BoundingRegion(msrest.serialization.Model):
    """Bounding box on a specific page of the input.

    All required parameters must be populated in order to send to Azure.

    :param page_number: Required. 1-based page number of page containing the bounding region.
    :type page_number: int
    :param bounding_box: Required. Bounding box on the page, or the entire page if not specified.
    :type bounding_box: list[float]
    """

    _validation = {
        'page_number': {'required': True, 'minimum': 1},
        'bounding_box': {'required': True, 'max_items': 8, 'min_items': 8},
    }

    _attribute_map = {
        'page_number': {'key': 'pageNumber', 'type': 'int'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        page_number: int,
        bounding_box: List[float],
        **kwargs
    ):
        super(BoundingRegion, self).__init__(**kwargs)
        self.page_number = page_number
        self.bounding_box = bounding_box


class BuildDocumentModelRequest(msrest.serialization.Model):
    """Request body to build a new custom model.

    All required parameters must be populated in order to send to Azure.

    :param model_id: Required. Unique model name.
    :type model_id: str
    :param description: Model description.
    :type description: str
    :param azure_blob_source: Azure Blob Storage location containing the training data.
    :type azure_blob_source:
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.AzureBlobContentSource
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'azure_blob_source': {'key': 'azureBlobSource', 'type': 'AzureBlobContentSource'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        description: Optional[str] = None,
        azure_blob_source: Optional["AzureBlobContentSource"] = None,
        **kwargs
    ):
        super(BuildDocumentModelRequest, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description
        self.azure_blob_source = azure_blob_source


class ComponentModelInfo(msrest.serialization.Model):
    """A component of a composed model.

    All required parameters must be populated in order to send to Azure.

    :param model_id: Required. Unique model name.
    :type model_id: str
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        **kwargs
    ):
        super(ComponentModelInfo, self).__init__(**kwargs)
        self.model_id = model_id


class ComposeDocumentModelRequest(msrest.serialization.Model):
    """Request body to create a composed model from component models.

    All required parameters must be populated in order to send to Azure.

    :param model_id: Required. Unique model name.
    :type model_id: str
    :param description: Model description.
    :type description: str
    :param component_models: Required. List of component models to compose.
    :type component_models:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.ComponentModelInfo]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
        'component_models': {'required': True, 'unique': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'component_models': {'key': 'componentModels', 'type': '[ComponentModelInfo]'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        component_models: List["ComponentModelInfo"],
        description: Optional[str] = None,
        **kwargs
    ):
        super(ComposeDocumentModelRequest, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description
        self.component_models = component_models


class CopyAuthorization(msrest.serialization.Model):
    """Authorization to copy a model to the specified target resource and modelId.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. ID of the target Azure resource where the model should be
     copied to.
    :type target_resource_id: str
    :param target_resource_region: Required. Location of the target Azure resource where the model
     should be copied to.
    :type target_resource_region: str
    :param target_model_id: Required. Identifier of the target model.
    :type target_model_id: str
    :param target_model_location: Required. URL of the copied model in the target account.
    :type target_model_location: str
    :param access_token: Required. Token used to authorize the request.
    :type access_token: str
    :param expiration_date_time: Required. Date/time when the access token expires.
    :type expiration_date_time: ~datetime.datetime
    """

    _validation = {
        'target_resource_id': {'required': True},
        'target_resource_region': {'required': True},
        'target_model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'target_model_location': {'required': True},
        'access_token': {'required': True},
        'expiration_date_time': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'target_resource_region': {'key': 'targetResourceRegion', 'type': 'str'},
        'target_model_id': {'key': 'targetModelId', 'type': 'str'},
        'target_model_location': {'key': 'targetModelLocation', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        target_resource_region: str,
        target_model_id: str,
        target_model_location: str,
        access_token: str,
        expiration_date_time: datetime.datetime,
        **kwargs
    ):
        super(CopyAuthorization, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.target_resource_region = target_resource_region
        self.target_model_id = target_model_id
        self.target_model_location = target_model_location
        self.access_token = access_token
        self.expiration_date_time = expiration_date_time


class CustomDocumentModelsInfo(msrest.serialization.Model):
    """Info regarding custom document models.

    All required parameters must be populated in order to send to Azure.

    :param count: Required. Number of custom models in the current resource.
    :type count: int
    :param limit: Required. Maximum number of custom models supported in the current resource.
    :type limit: int
    """

    _validation = {
        'count': {'required': True},
        'limit': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        count: int,
        limit: int,
        **kwargs
    ):
        super(CustomDocumentModelsInfo, self).__init__(**kwargs)
        self.count = count
        self.limit = limit


class DocTypeInfo(msrest.serialization.Model):
    """Document type info.

    All required parameters must be populated in order to send to Azure.

    :param description: Model description.
    :type description: str
    :param field_schema: Required. Description of the document semantic schema using a JSON Schema
     style syntax.
    :type field_schema: dict[str,
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentFieldSchema]
    :param field_confidence: Estimated confidence for each field.
    :type field_confidence: dict[str, float]
    """

    _validation = {
        'description': {'max_length': 4096, 'min_length': 0},
        'field_schema': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'field_schema': {'key': 'fieldSchema', 'type': '{DocumentFieldSchema}'},
        'field_confidence': {'key': 'fieldConfidence', 'type': '{float}'},
    }

    def __init__(
        self,
        *,
        field_schema: Dict[str, "DocumentFieldSchema"],
        description: Optional[str] = None,
        field_confidence: Optional[Dict[str, float]] = None,
        **kwargs
    ):
        super(DocTypeInfo, self).__init__(**kwargs)
        self.description = description
        self.field_schema = field_schema
        self.field_confidence = field_confidence


class Document(msrest.serialization.Model):
    """An object describing the location and semantic content of a document.

    All required parameters must be populated in order to send to Azure.

    :param doc_type: Required. Document type.
    :type doc_type: str
    :param bounding_regions: Bounding regions covering the document.
    :type bounding_regions:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.BoundingRegion]
    :param spans: Required. Location of the document in the reading order concatenated content.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    :param fields: Required. Dictionary of named field values.
    :type fields: dict[str, ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentField]
    :param confidence: Required. Confidence of correctly extracting the document.
    :type confidence: float
    """

    _validation = {
        'doc_type': {'required': True, 'max_length': 64, 'min_length': 2},
        'spans': {'required': True},
        'fields': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'doc_type': {'key': 'docType', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'fields': {'key': 'fields', 'type': '{DocumentField}'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        doc_type: str,
        spans: List["DocumentSpan"],
        fields: Dict[str, "DocumentField"],
        confidence: float,
        bounding_regions: Optional[List["BoundingRegion"]] = None,
        **kwargs
    ):
        super(Document, self).__init__(**kwargs)
        self.doc_type = doc_type
        self.bounding_regions = bounding_regions
        self.spans = spans
        self.fields = fields
        self.confidence = confidence


class DocumentEntity(msrest.serialization.Model):
    """An object representing various categories of entities.

    All required parameters must be populated in order to send to Azure.

    :param category: Required. Entity type.
    :type category: str
    :param sub_category: Entity sub type.
    :type sub_category: str
    :param content: Required. Entity content.
    :type content: str
    :param bounding_regions: Bounding regions covering the entity.
    :type bounding_regions:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.BoundingRegion]
    :param spans: Required. Location of the entity in the reading order concatenated content.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    :param confidence: Required. Confidence of correctly extracting the entity.
    :type confidence: float
    """

    _validation = {
        'category': {'required': True},
        'content': {'required': True},
        'spans': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'sub_category': {'key': 'subCategory', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        category: str,
        content: str,
        spans: List["DocumentSpan"],
        confidence: float,
        sub_category: Optional[str] = None,
        bounding_regions: Optional[List["BoundingRegion"]] = None,
        **kwargs
    ):
        super(DocumentEntity, self).__init__(**kwargs)
        self.category = category
        self.sub_category = sub_category
        self.content = content
        self.bounding_regions = bounding_regions
        self.spans = spans
        self.confidence = confidence


class DocumentField(msrest.serialization.Model):
    """An object representing the content and location of a field value.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Data type of the field value. Possible values include: "string", "date",
     "time", "phoneNumber", "number", "integer", "selectionMark", "countryRegion", "signature",
     "array", "object".
    :type type: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentFieldType
    :param value_string: String value.
    :type value_string: str
    :param value_date: Date value in YYYY-MM-DD format (ISO 8601).
    :type value_date: ~datetime.date
    :param value_time: Time value in hh:mm:ss format (ISO 8601).
    :type value_time: ~datetime.time
    :param value_phone_number: Phone number value in E.164 format (ex. +19876543210).
    :type value_phone_number: str
    :param value_number: Floating point value.
    :type value_number: float
    :param value_integer: Integer value.
    :type value_integer: long
    :param value_selection_mark: Selection mark value. Possible values include: "selected",
     "unselected".
    :type value_selection_mark: str or
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.SelectionMarkState
    :param value_signature: Presence of signature. Possible values include: "signed", "unsigned".
    :type value_signature: str or
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSignatureType
    :param value_country_region: 3-letter country code value (ISO 3166-1 alpha-3).
    :type value_country_region: str
    :param value_array: Array of field values.
    :type value_array: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentField]
    :param value_object: Dictionary of named field values.
    :type value_object: dict[str,
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentField]
    :param content: Field content.
    :type content: str
    :param bounding_regions: Bounding regions covering the field.
    :type bounding_regions:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.BoundingRegion]
    :param spans: Location of the field in the reading order concatenated content.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    :param confidence: Confidence of correctly extracting the field.
    :type confidence: float
    """

    _validation = {
        'type': {'required': True},
        'confidence': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value_string': {'key': 'valueString', 'type': 'str'},
        'value_date': {'key': 'valueDate', 'type': 'date'},
        'value_time': {'key': 'valueTime', 'type': 'time'},
        'value_phone_number': {'key': 'valuePhoneNumber', 'type': 'str'},
        'value_number': {'key': 'valueNumber', 'type': 'float'},
        'value_integer': {'key': 'valueInteger', 'type': 'long'},
        'value_selection_mark': {'key': 'valueSelectionMark', 'type': 'str'},
        'value_signature': {'key': 'valueSignature', 'type': 'str'},
        'value_country_region': {'key': 'valueCountryRegion', 'type': 'str'},
        'value_array': {'key': 'valueArray', 'type': '[DocumentField]'},
        'value_object': {'key': 'valueObject', 'type': '{DocumentField}'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "DocumentFieldType"],
        value_string: Optional[str] = None,
        value_date: Optional[datetime.date] = None,
        value_time: Optional[datetime.time] = None,
        value_phone_number: Optional[str] = None,
        value_number: Optional[float] = None,
        value_integer: Optional[int] = None,
        value_selection_mark: Optional[Union[str, "SelectionMarkState"]] = None,
        value_signature: Optional[Union[str, "DocumentSignatureType"]] = None,
        value_country_region: Optional[str] = None,
        value_array: Optional[List["DocumentField"]] = None,
        value_object: Optional[Dict[str, "DocumentField"]] = None,
        content: Optional[str] = None,
        bounding_regions: Optional[List["BoundingRegion"]] = None,
        spans: Optional[List["DocumentSpan"]] = None,
        confidence: Optional[float] = None,
        **kwargs
    ):
        super(DocumentField, self).__init__(**kwargs)
        self.type = type
        self.value_string = value_string
        self.value_date = value_date
        self.value_time = value_time
        self.value_phone_number = value_phone_number
        self.value_number = value_number
        self.value_integer = value_integer
        self.value_selection_mark = value_selection_mark
        self.value_signature = value_signature
        self.value_country_region = value_country_region
        self.value_array = value_array
        self.value_object = value_object
        self.content = content
        self.bounding_regions = bounding_regions
        self.spans = spans
        self.confidence = confidence


class DocumentFieldSchema(msrest.serialization.Model):
    """Description of the field semantic schema using a JSON Schema style syntax.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Semantic data type of the field value. Possible values include:
     "string", "date", "time", "phoneNumber", "number", "integer", "selectionMark", "countryRegion",
     "signature", "array", "object".
    :type type: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentFieldType
    :param description: Field description.
    :type description: str
    :param example: Example field content.
    :type example: str
    :param items: Field type schema of each array element.
    :type items: ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentFieldSchema
    :param properties: Named sub-fields of the object field.
    :type properties: dict[str,
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentFieldSchema]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'example': {'key': 'example', 'type': 'str'},
        'items': {'key': 'items', 'type': 'DocumentFieldSchema'},
        'properties': {'key': 'properties', 'type': '{DocumentFieldSchema}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "DocumentFieldType"],
        description: Optional[str] = None,
        example: Optional[str] = None,
        items: Optional["DocumentFieldSchema"] = None,
        properties: Optional[Dict[str, "DocumentFieldSchema"]] = None,
        **kwargs
    ):
        super(DocumentFieldSchema, self).__init__(**kwargs)
        self.type = type
        self.description = description
        self.example = example
        self.items = items
        self.properties = properties


class DocumentKeyValueElement(msrest.serialization.Model):
    """An object representing the field key or value in a key-value pair.

    All required parameters must be populated in order to send to Azure.

    :param content: Required. Concatenated content of the key-value element in reading order.
    :type content: str
    :param bounding_regions: Bounding regions covering the key-value element.
    :type bounding_regions:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.BoundingRegion]
    :param spans: Required. Location of the key-value element in the reading order concatenated
     content.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        content: str,
        spans: List["DocumentSpan"],
        bounding_regions: Optional[List["BoundingRegion"]] = None,
        **kwargs
    ):
        super(DocumentKeyValueElement, self).__init__(**kwargs)
        self.content = content
        self.bounding_regions = bounding_regions
        self.spans = spans


class DocumentKeyValuePair(msrest.serialization.Model):
    """An object representing a form field with distinct field label (key) and field value (may be empty).

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Field label of the key-value pair.
    :type key: ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentKeyValueElement
    :param value: Field value of the key-value pair.
    :type value: ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentKeyValueElement
    :param confidence: Required. Confidence of correctly extracting the key-value pair.
    :type confidence: float
    """

    _validation = {
        'key': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'DocumentKeyValueElement'},
        'value': {'key': 'value', 'type': 'DocumentKeyValueElement'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: "DocumentKeyValueElement",
        confidence: float,
        value: Optional["DocumentKeyValueElement"] = None,
        **kwargs
    ):
        super(DocumentKeyValuePair, self).__init__(**kwargs)
        self.key = key
        self.value = value
        self.confidence = confidence


class DocumentLine(msrest.serialization.Model):
    """A content line object consisting of an adjacent sequence of content elements, such as words and selection marks.

    All required parameters must be populated in order to send to Azure.

    :param content: Required. Concatenated content of the contained elements in reading order.
    :type content: str
    :param bounding_box: Bounding box of the line.
    :type bounding_box: list[float]
    :param spans: Required. Location of the line in the reading order concatenated content.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'bounding_box': {'max_items': 8, 'min_items': 8},
        'spans': {'required': True},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        content: str,
        spans: List["DocumentSpan"],
        bounding_box: Optional[List[float]] = None,
        **kwargs
    ):
        super(DocumentLine, self).__init__(**kwargs)
        self.content = content
        self.bounding_box = bounding_box
        self.spans = spans


class DocumentPage(msrest.serialization.Model):
    """Content and layout elements extracted from a page from the input.

    All required parameters must be populated in order to send to Azure.

    :param page_number: Required. 1-based page number in the input document.
    :type page_number: int
    :param angle: Required. The general orientation of the content in clockwise direction, measured
     in degrees between (-180, 180].
    :type angle: float
    :param width: Required. The width of the image/PDF in pixels/inches, respectively.
    :type width: float
    :param height: Required. The height of the image/PDF in pixels/inches, respectively.
    :type height: float
    :param unit: Required. The unit used by the width, height, and boundingBox properties. For
     images, the unit is "pixel". For PDF, the unit is "inch". Possible values include: "pixel",
     "inch".
    :type unit: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.LengthUnit
    :param spans: Required. Location of the page in the reading order concatenated content.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    :param words: Required. Extracted words from the page.
    :type words: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentWord]
    :param selection_marks: Extracted selection marks from the page.
    :type selection_marks:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSelectionMark]
    :param lines: Required. Extracted lines from the page, potentially containing both textual and
     visual elements.
    :type lines: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentLine]
    """

    _validation = {
        'page_number': {'required': True, 'minimum': 1},
        'angle': {'required': True, 'maximum': 180, 'minimum_ex': -180},
        'width': {'required': True, 'minimum': 0},
        'height': {'required': True, 'minimum': 0},
        'unit': {'required': True},
        'spans': {'required': True},
        'words': {'required': True},
        'lines': {'required': True},
    }

    _attribute_map = {
        'page_number': {'key': 'pageNumber', 'type': 'int'},
        'angle': {'key': 'angle', 'type': 'float'},
        'width': {'key': 'width', 'type': 'float'},
        'height': {'key': 'height', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'words': {'key': 'words', 'type': '[DocumentWord]'},
        'selection_marks': {'key': 'selectionMarks', 'type': '[DocumentSelectionMark]'},
        'lines': {'key': 'lines', 'type': '[DocumentLine]'},
    }

    def __init__(
        self,
        *,
        page_number: int,
        angle: float,
        width: float,
        height: float,
        unit: Union[str, "LengthUnit"],
        spans: List["DocumentSpan"],
        words: List["DocumentWord"],
        lines: List["DocumentLine"],
        selection_marks: Optional[List["DocumentSelectionMark"]] = None,
        **kwargs
    ):
        super(DocumentPage, self).__init__(**kwargs)
        self.page_number = page_number
        self.angle = angle
        self.width = width
        self.height = height
        self.unit = unit
        self.spans = spans
        self.words = words
        self.selection_marks = selection_marks
        self.lines = lines


class DocumentSelectionMark(msrest.serialization.Model):
    """A selection mark object representing check boxes, radio buttons, and other elements indicating a selection.

    All required parameters must be populated in order to send to Azure.

    :param state: Required. State of the selection mark. Possible values include: "selected",
     "unselected".
    :type state: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.SelectionMarkState
    :param bounding_box: Bounding box of the selection mark.
    :type bounding_box: list[float]
    :param span: Required. Location of the selection mark in the reading order concatenated
     content.
    :type span: ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan
    :param confidence: Required. Confidence of correctly extracting the selection mark.
    :type confidence: float
    """

    _validation = {
        'state': {'required': True},
        'bounding_box': {'max_items': 8, 'min_items': 8},
        'span': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "SelectionMarkState"],
        span: "DocumentSpan",
        confidence: float,
        bounding_box: Optional[List[float]] = None,
        **kwargs
    ):
        super(DocumentSelectionMark, self).__init__(**kwargs)
        self.state = state
        self.bounding_box = bounding_box
        self.span = span
        self.confidence = confidence


class DocumentSpan(msrest.serialization.Model):
    """Contiguous region of the concatenated content property, specified as an offset and length.

    All required parameters must be populated in order to send to Azure.

    :param offset: Required. Zero-based index of the content represented by the span.
    :type offset: int
    :param length: Required. Number of characters in the content represented by the span.
    :type length: int
    """

    _validation = {
        'offset': {'required': True, 'minimum': 0},
        'length': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        offset: int,
        length: int,
        **kwargs
    ):
        super(DocumentSpan, self).__init__(**kwargs)
        self.offset = offset
        self.length = length


class DocumentStyle(msrest.serialization.Model):
    """An object representing observed text styles.

    All required parameters must be populated in order to send to Azure.

    :param is_handwritten: Is content handwritten?.
    :type is_handwritten: bool
    :param spans: Required. Location of the text elements in the concatenated content the style
     applies to.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    :param confidence: Required. Confidence of correctly identifying the style.
    :type confidence: float
    """

    _validation = {
        'spans': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'is_handwritten': {'key': 'isHandwritten', 'type': 'bool'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        spans: List["DocumentSpan"],
        confidence: float,
        is_handwritten: Optional[bool] = None,
        **kwargs
    ):
        super(DocumentStyle, self).__init__(**kwargs)
        self.is_handwritten = is_handwritten
        self.spans = spans
        self.confidence = confidence


class DocumentTable(msrest.serialization.Model):
    """A table object consisting table cells arranged in a rectangular layout.

    All required parameters must be populated in order to send to Azure.

    :param row_count: Required. Number of rows in the table.
    :type row_count: int
    :param column_count: Required. Number of columns in the table.
    :type column_count: int
    :param cells: Required. Cells contained within the table.
    :type cells: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentTableCell]
    :param bounding_regions: Bounding regions covering the table.
    :type bounding_regions:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.BoundingRegion]
    :param spans: Required. Location of the table in the reading order concatenated content.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    """

    _validation = {
        'row_count': {'required': True, 'minimum': 1},
        'column_count': {'required': True, 'minimum': 1},
        'cells': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'row_count': {'key': 'rowCount', 'type': 'int'},
        'column_count': {'key': 'columnCount', 'type': 'int'},
        'cells': {'key': 'cells', 'type': '[DocumentTableCell]'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        row_count: int,
        column_count: int,
        cells: List["DocumentTableCell"],
        spans: List["DocumentSpan"],
        bounding_regions: Optional[List["BoundingRegion"]] = None,
        **kwargs
    ):
        super(DocumentTable, self).__init__(**kwargs)
        self.row_count = row_count
        self.column_count = column_count
        self.cells = cells
        self.bounding_regions = bounding_regions
        self.spans = spans


class DocumentTableCell(msrest.serialization.Model):
    """An object representing the location and content of a table cell.

    All required parameters must be populated in order to send to Azure.

    :param kind: Table cell kind. Possible values include: "content", "rowHeader", "columnHeader",
     "stubHead", "description". Default value: "content".
    :type kind: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentTableCellKind
    :param row_index: Required. Row index of the cell.
    :type row_index: int
    :param column_index: Required. Column index of the cell.
    :type column_index: int
    :param row_span: Number of rows spanned by this cell.
    :type row_span: int
    :param column_span: Number of columns spanned by this cell.
    :type column_span: int
    :param content: Required. Concatenated content of the table cell in reading order.
    :type content: str
    :param bounding_regions: Bounding regions covering the table cell.
    :type bounding_regions:
     list[~azure.ai.formrecognizer.v2021_09_30_preview.models.BoundingRegion]
    :param spans: Required. Location of the table cell in the reading order concatenated content.
    :type spans: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan]
    """

    _validation = {
        'row_index': {'required': True},
        'column_index': {'required': True},
        'row_span': {'minimum': 1},
        'column_span': {'minimum': 1},
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'row_index': {'key': 'rowIndex', 'type': 'int'},
        'column_index': {'key': 'columnIndex', 'type': 'int'},
        'row_span': {'key': 'rowSpan', 'type': 'int'},
        'column_span': {'key': 'columnSpan', 'type': 'int'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        row_index: int,
        column_index: int,
        content: str,
        spans: List["DocumentSpan"],
        kind: Optional[Union[str, "DocumentTableCellKind"]] = "content",
        row_span: Optional[int] = 1,
        column_span: Optional[int] = 1,
        bounding_regions: Optional[List["BoundingRegion"]] = None,
        **kwargs
    ):
        super(DocumentTableCell, self).__init__(**kwargs)
        self.kind = kind
        self.row_index = row_index
        self.column_index = column_index
        self.row_span = row_span
        self.column_span = column_span
        self.content = content
        self.bounding_regions = bounding_regions
        self.spans = spans


class DocumentWord(msrest.serialization.Model):
    """A word object consisting of a contiguous sequence of characters.  For non-space delimited languages, such as Chinese, Japanese, and Korean, each character is represented as its own word.

    All required parameters must be populated in order to send to Azure.

    :param content: Required. Text content of the word.
    :type content: str
    :param bounding_box: Bounding box of the word.
    :type bounding_box: list[float]
    :param span: Required. Location of the word in the reading order concatenated content.
    :type span: ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocumentSpan
    :param confidence: Required. Confidence of correctly extracting the word.
    :type confidence: float
    """

    _validation = {
        'content': {'required': True},
        'bounding_box': {'max_items': 8, 'min_items': 8},
        'span': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        content: str,
        span: "DocumentSpan",
        confidence: float,
        bounding_box: Optional[List[float]] = None,
        **kwargs
    ):
        super(DocumentWord, self).__init__(**kwargs)
        self.content = content
        self.bounding_box = bounding_box
        self.span = span
        self.confidence = confidence


class Error(msrest.serialization.Model):
    """Error info.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    :param target: Target of the error.
    :type target: str
    :param details: List of detailed errors.
    :type details: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.Error]
    :param innererror: Detailed error.
    :type innererror: ~azure.ai.formrecognizer.v2021_09_30_preview.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["Error"]] = None,
        innererror: Optional["InnerError"] = None,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class ErrorResponse(msrest.serialization.Model):
    """Error response object.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. Error info.
    :type error: ~azure.ai.formrecognizer.v2021_09_30_preview.models.Error
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        *,
        error: "Error",
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class GetInfoResponse(msrest.serialization.Model):
    """General information regarding the current resource.

    All required parameters must be populated in order to send to Azure.

    :param custom_document_models: Required. Info regarding custom document models.
    :type custom_document_models:
     ~azure.ai.formrecognizer.v2021_09_30_preview.models.CustomDocumentModelsInfo
    """

    _validation = {
        'custom_document_models': {'required': True},
    }

    _attribute_map = {
        'custom_document_models': {'key': 'customDocumentModels', 'type': 'CustomDocumentModelsInfo'},
    }

    def __init__(
        self,
        *,
        custom_document_models: "CustomDocumentModelsInfo",
        **kwargs
    ):
        super(GetInfoResponse, self).__init__(**kwargs)
        self.custom_document_models = custom_document_models


class GetModelsResponse(msrest.serialization.Model):
    """List Models response object.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of models.
    :type value: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.ModelSummary]
    :param next_link: Link to the next page of models.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ModelSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ModelSummary"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GetModelsResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationInfo(msrest.serialization.Model):
    """Operation info.

    All required parameters must be populated in order to send to Azure.

    :param operation_id: Required. Operation ID.
    :type operation_id: str
    :param status: Required. Operation status. Possible values include: "notStarted", "running",
     "failed", "succeeded", "canceled".
    :type status: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.OperationStatus
    :param percent_completed: Operation progress (0-100).
    :type percent_completed: int
    :param created_date_time: Required. Date and time (UTC) when the operation was created.
    :type created_date_time: ~datetime.datetime
    :param last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :type last_updated_date_time: ~datetime.datetime
    :param kind: Required. Type of operation. Possible values include: "documentModelBuild",
     "documentModelCompose", "documentModelCopyTo".
    :type kind: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.OperationKind
    :param resource_location: Required. URL of the resource targeted by this operation.
    :type resource_location: str
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "OperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        kind: Union[str, "OperationKind"],
        resource_location: str,
        percent_completed: Optional[int] = None,
        **kwargs
    ):
        super(OperationInfo, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status
        self.percent_completed = percent_completed
        self.created_date_time = created_date_time
        self.last_updated_date_time = last_updated_date_time
        self.kind = kind
        self.resource_location = resource_location


class GetOperationResponse(OperationInfo):
    """Get Operation response object.

    All required parameters must be populated in order to send to Azure.

    :param operation_id: Required. Operation ID.
    :type operation_id: str
    :param status: Required. Operation status. Possible values include: "notStarted", "running",
     "failed", "succeeded", "canceled".
    :type status: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.OperationStatus
    :param percent_completed: Operation progress (0-100).
    :type percent_completed: int
    :param created_date_time: Required. Date and time (UTC) when the operation was created.
    :type created_date_time: ~datetime.datetime
    :param last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :type last_updated_date_time: ~datetime.datetime
    :param kind: Required. Type of operation. Possible values include: "documentModelBuild",
     "documentModelCompose", "documentModelCopyTo".
    :type kind: str or ~azure.ai.formrecognizer.v2021_09_30_preview.models.OperationKind
    :param resource_location: Required. URL of the resource targeted by this operation.
    :type resource_location: str
    :param error: Encountered error.
    :type error: ~azure.ai.formrecognizer.v2021_09_30_preview.models.Error
    :param result: Operation result upon success.
    :type result: any
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'result': {'key': 'result', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "OperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        kind: Union[str, "OperationKind"],
        resource_location: str,
        percent_completed: Optional[int] = None,
        error: Optional["Error"] = None,
        result: Optional[Any] = None,
        **kwargs
    ):
        super(GetOperationResponse, self).__init__(operation_id=operation_id, status=status, percent_completed=percent_completed, created_date_time=created_date_time, last_updated_date_time=last_updated_date_time, kind=kind, resource_location=resource_location, **kwargs)
        self.error = error
        self.result = result


class GetOperationsResponse(msrest.serialization.Model):
    """List Operations response object.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of operations.
    :type value: list[~azure.ai.formrecognizer.v2021_09_30_preview.models.OperationInfo]
    :param next_link: Link to the next page of operations.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["OperationInfo"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GetOperationsResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class InnerError(msrest.serialization.Model):
    """Detailed error.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Error message.
    :type message: str
    :param innererror: Detailed error.
    :type innererror: ~azure.ai.formrecognizer.v2021_09_30_preview.models.InnerError
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: Optional[str] = None,
        innererror: Optional["InnerError"] = None,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.innererror = innererror


class ModelSummary(msrest.serialization.Model):
    """Model summary.

    All required parameters must be populated in order to send to Azure.

    :param model_id: Required. Unique model name.
    :type model_id: str
    :param description: Model description.
    :type description: str
    :param created_date_time: Required. Date and time (UTC) when the model was created.
    :type created_date_time: ~datetime.datetime
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        created_date_time: datetime.datetime,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ModelSummary, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description
        self.created_date_time = created_date_time


class ModelInfo(ModelSummary):
    """Model info.

    All required parameters must be populated in order to send to Azure.

    :param model_id: Required. Unique model name.
    :type model_id: str
    :param description: Model description.
    :type description: str
    :param created_date_time: Required. Date and time (UTC) when the model was created.
    :type created_date_time: ~datetime.datetime
    :param doc_types: Supported document types.
    :type doc_types: dict[str, ~azure.ai.formrecognizer.v2021_09_30_preview.models.DocTypeInfo]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}'},
        'description': {'max_length': 4096, 'min_length': 0},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'doc_types': {'key': 'docTypes', 'type': '{DocTypeInfo}'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        created_date_time: datetime.datetime,
        description: Optional[str] = None,
        doc_types: Optional[Dict[str, "DocTypeInfo"]] = None,
        **kwargs
    ):
        super(ModelInfo, self).__init__(model_id=model_id, description=description, created_date_time=created_date_time, **kwargs)
        self.doc_types = doc_types
