# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RetryPolicy(Model):
    """Execution policy for an activity.

    :param count: Maximum ordinary retry attempts. Default is 0. Type: integer
     (or Expression with resultType integer), minimum: 0.
    :type count: object
    :param interval_in_seconds: Interval between retries in seconds. Default
     is 30.
    :type interval_in_seconds: int
    """

    _validation = {
        'interval_in_seconds': {'maximum': 86400, 'minimum': 30},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'object'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RetryPolicy, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
