# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Dimension(Resource):
    """Dimension.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :param description:
    :type description: str
    :param filter_enabled:
    :type filter_enabled: bool
    :param grouping_enabled:
    :type grouping_enabled: bool
    :param data:
    :type data: list[str]
    :param total:
    :type total: int
    :param category:
    :type category: str
    :param usage_start:
    :type usage_start: datetime
    :param usage_end:
    :type usage_end: datetime
    :param next_link:
    :type next_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'filter_enabled': {'key': 'properties.filterEnabled', 'type': 'bool'},
        'grouping_enabled': {'key': 'properties.groupingEnabled', 'type': 'bool'},
        'data': {'key': 'properties.data', 'type': '[str]'},
        'total': {'key': 'properties.total', 'type': 'int'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'usage_start': {'key': 'properties.usageStart', 'type': 'iso-8601'},
        'usage_end': {'key': 'properties.usageEnd', 'type': 'iso-8601'},
        'next_link': {'key': 'properties.nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Dimension, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.filter_enabled = kwargs.get('filter_enabled', None)
        self.grouping_enabled = kwargs.get('grouping_enabled', None)
        self.data = kwargs.get('data', None)
        self.total = kwargs.get('total', None)
        self.category = kwargs.get('category', None)
        self.usage_start = kwargs.get('usage_start', None)
        self.usage_end = kwargs.get('usage_end', None)
        self.next_link = kwargs.get('next_link', None)
