/*----- PROTECTED REGION ID(IfchangeServer.cpp) ENABLED START -----*/
static const char *RcsId = "$Id:  $";
//=============================================================================
//
// file :        IfchangeServer.cpp
//
// description : C++ source for the IfchangeServer class and its commands.
//               The class is derived from Device. It represents the
//               CORBA servant object which will be accessed from the
//               network. All commands which can be executed on the
//               IfchangeServer are implemented in this file.
//
// project :     
//
// This file is part of Tango device class.
// 
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
// 
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <IfchangeServer.h>
#include <IfchangeServerClass.h>

/*----- PROTECTED REGION END -----*/	//	IfchangeServer.cpp

/**
 *  IfchangeServer class description:
 *    
 */

//================================================================
//  The following table gives the correspondence
//  between command and method names.
//
//  Command name    |  Method name
//================================================================
//  State           |  Inherited (no method)
//  Status          |  Inherited (no method)
//  Add_dynamic     |  add_dynamic
//  Delete_Dynamic  |  delete__dynamic
//================================================================

//================================================================
//  Attributes managed is:
//================================================================
//  busy  |  Tango::DevBoolean	Scalar
//================================================================

namespace IfchangeServer_ns
{
/*----- PROTECTED REGION ID(IfchangeServer::namespace_starting) ENABLED START -----*/

//	static initializations

/*----- PROTECTED REGION END -----*/	//	IfchangeServer::namespace_starting

//--------------------------------------------------------
/**
 *	Method      : IfchangeServer::IfchangeServer()
 *	Description : Constructors for a Tango device
 *                implementing the classIfchangeServer
 */
//--------------------------------------------------------
IfchangeServer::IfchangeServer(Tango::DeviceClass *cl, string &s)
 : TANGO_BASE_CLASS(cl, s.c_str())
{
	/*----- PROTECTED REGION ID(IfchangeServer::constructor_1) ENABLED START -----*/
	init_device();
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::constructor_1
}
//--------------------------------------------------------
IfchangeServer::IfchangeServer(Tango::DeviceClass *cl, const char *s)
 : TANGO_BASE_CLASS(cl, s)
{
	/*----- PROTECTED REGION ID(IfchangeServer::constructor_2) ENABLED START -----*/
	init_device();
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::constructor_2
}
//--------------------------------------------------------
IfchangeServer::IfchangeServer(Tango::DeviceClass *cl, const char *s, const char *d)
 : TANGO_BASE_CLASS(cl, s, d)
{
	/*----- PROTECTED REGION ID(IfchangeServer::constructor_3) ENABLED START -----*/
	init_device();
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::constructor_3
}

//--------------------------------------------------------
/**
 *	Method      : IfchangeServer::delete_device()
 *	Description : will be called at device destruction or at init command
 */
//--------------------------------------------------------
void IfchangeServer::delete_device()
{
	DEBUG_STREAM << "IfchangeServer::delete_device() " << device_name << endl;
	/*----- PROTECTED REGION ID(IfchangeServer::delete_device) ENABLED START -----*/
	
	//	Delete device allocated objects
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::delete_device
	delete[] attr_busy_read;
}

//--------------------------------------------------------
/**
 *	Method      : IfchangeServer::init_device()
 *	Description : will be called at device initialization.
 */
//--------------------------------------------------------
void IfchangeServer::init_device()
{
	DEBUG_STREAM << "IfchangeServer::init_device() create device " << device_name << endl;
	/*----- PROTECTED REGION ID(IfchangeServer::init_device_before) ENABLED START -----*/
	
	//	Initialization before get_device_property() call
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::init_device_before
	
	//	No device property to be read from database
	
	attr_busy_read = new Tango::DevBoolean[1];
	/*----- PROTECTED REGION ID(IfchangeServer::init_device) ENABLED START -----*/
	
	set_status("ON");
	set_state(Tango::ON);
	//	Initialize device
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::init_device
}


//--------------------------------------------------------
/**
 *	Method      : IfchangeServer::always_executed_hook()
 *	Description : method always executed before any command is executed
 */
//--------------------------------------------------------
void IfchangeServer::always_executed_hook()
{
	DEBUG_STREAM << "IfchangeServer::always_executed_hook()  " << device_name << endl;
	/*----- PROTECTED REGION ID(IfchangeServer::always_executed_hook) ENABLED START -----*/
	
	//	code always executed before all requests
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::always_executed_hook
}

//--------------------------------------------------------
/**
 *	Method      : IfchangeServer::read_attr_hardware()
 *	Description : Hardware acquisition for attributes
 */
//--------------------------------------------------------
void IfchangeServer::read_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))
{
	DEBUG_STREAM << "IfchangeServer::read_attr_hardware(vector<long> &attr_list) entering... " << endl;
	/*----- PROTECTED REGION ID(IfchangeServer::read_attr_hardware) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::read_attr_hardware
}

//--------------------------------------------------------
/**
 *	Read attribute busy related method
 *	Description: 
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void IfchangeServer::read_busy(Tango::Attribute &attr)
{
	DEBUG_STREAM << "IfchangeServer::read_busy(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(IfchangeServer::read_busy) ENABLED START -----*/
	//	Set the attribute value
	*attr_busy_read = true;
	attr.set_value(attr_busy_read);
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::read_busy
}

//--------------------------------------------------------
/**
 *	Read attribute ioattr related method
 *	Description: 
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void IfchangeServer::read_ioattr(Tango::Attribute &attr)
{
	DEBUG_STREAM << "IfchangeServer::read_ioattr(Tango::Attribute &attr) entering... " << endl;
	Tango::DevDouble	*att_value = get_ioattr_data_ptr(attr.get_name());
	/*----- PROTECTED REGION ID(IfchangeServer::read_ioattr) ENABLED START -----*/
	//	Set the attribute value
	attr.set_value(att_value);
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::read_ioattr
}
//--------------------------------------------------------
/**
 *	Method      : IfchangeServer::add_dynamic_attributes()
 *	Description : Create the dynamic attributes if any
 *                for specified device.
 */
//--------------------------------------------------------
void IfchangeServer::add_dynamic_attributes()
{
	//	Example to add dynamic attribute:
	//	Copy inside the following protected area to create instance(s) at startup.
	//	add_ioattr_dynamic_attribute("MyioattrAttribute");
	
	/*----- PROTECTED REGION ID(IfchangeServer::add_dynamic_attributes) ENABLED START -----*/
	//	Add your own code to create and add dynamic attributes if any
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::add_dynamic_attributes
}

//--------------------------------------------------------
/**
 *	Command Add_dynamic related method
 *	Description: 
 *
 */
//--------------------------------------------------------
void IfchangeServer::add_dynamic()
{
	DEBUG_STREAM << "IfchangeServer::Add_dynamic()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(IfchangeServer::add_dynamic) ENABLED START -----*/
	
	add_iocmd_dynamic_command("test_dynamic_Command", true);
	add_ioattr_dynamic_attribute("test_dynamic_Attribute");
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::add_dynamic
}
//--------------------------------------------------------
/**
 *	Command Delete_Dynamic related method
 *	Description: 
 *
 */
//--------------------------------------------------------
void IfchangeServer::delete__dynamic()
{
	DEBUG_STREAM << "IfchangeServer::Delete_Dynamic()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(IfchangeServer::delete__dynamic) ENABLED START -----*/
	
	remove_iocmd_dynamic_command("test_dynamic_Command");
	remove_ioattr_dynamic_attribute("test_dynamic_Attribute");
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::delete__dynamic
}
//--------------------------------------------------------
/**
 *	Command iocmd related method
 *	Description: 
 *
 */
//--------------------------------------------------------
void IfchangeServer::iocmd(Tango::Command &command)
{
	DEBUG_STREAM << "IfchangeServer::" << command.get_name() << "  - " << device_name << endl;
	/*----- PROTECTED REGION ID(IfchangeServer::iocmd) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::iocmd
}
//--------------------------------------------------------
/**
 *	Method      : IfchangeServer::add_dynamic_commands()
 *	Description : Create the dynamic commands if any
 *                for specified device.
 */
//--------------------------------------------------------
void IfchangeServer::add_dynamic_commands()
{
	//	Example to add dynamic command:
	//	Copy inside the folowing protected area to instanciate at startup.
	//	add_iocmd_dynamic_command("MyiocmdCommand", true);
	
	/*----- PROTECTED REGION ID(IfchangeServer::add_dynamic_commands) ENABLED START -----*/
	
	//	Add your own code to create and add dynamic commands if any
	
	/*----- PROTECTED REGION END -----*/	//	IfchangeServer::add_dynamic_commands
}

/*----- PROTECTED REGION ID(IfchangeServer::namespace_ending) ENABLED START -----*/

//	Additional Methods

/*----- PROTECTED REGION END -----*/	//	IfchangeServer::namespace_ending
} //	namespace
