dnl Process this m4 file to produce 'C' language file.
dnl
dnl If you see this line, you can ignore the next one.
! Do not edit this file. It is produced from the corresponding .m4 source
dnl
!
!  Copyright (C) 2013, Northwestern University and Argonne National Laboratory
!  See COPYRIGHT notice in top-level directory.
!
! $Id: getput_var.m4 2221 2015-12-12 00:39:15Z wkliao $
!

dnl
dnl VAR_SCALAR
dnl
define(`VAR_SCALAR',dnl
`dnl
   function nf90mpi_$1_var_$3$2(ncid, varid, values, start, bufcount, buftype)
     integer,                                                intent( in) :: ncid, varid
     $4 (kind=$3),                                           intent($6)  :: values
     integer (kind=MPI_OFFSET_KIND), dimension(:), optional, intent( in) :: start
     integer (kind=MPI_OFFSET_KIND),               optional, intent( in) :: bufcount
     integer,                                      optional, intent( in) :: buftype

     integer                                                             :: nf90mpi_$1_var_$3$2
     integer (kind=MPI_OFFSET_KIND), dimension(nf90_max_var_dims)        :: localIndex
 
     ! Set local arguments to default values
     localIndex(:) = 1
     if (present(start)) localIndex(:size(start)) = start(:)
 
     if (present(buftype)) then
         nf90mpi_$1_var_$3$2 = nfmpi_$1_var1$2(ncid, varid, localIndex, values, bufcount, buftype)
     else
         nf90mpi_$1_var_$3$2 = nfmpi_$1_var1_$5$2(ncid, varid, localIndex, values)
     endif
   end function nf90mpi_$1_var_$3$2
')dnl

VAR_SCALAR(put,     , OneByteInt,    integer, int1,   in)
VAR_SCALAR(put,     , TwoByteInt,    integer, int2,   INTENTV)
VAR_SCALAR(put,     , FourByteInt,   integer, int,    INTENTV)
VAR_SCALAR(put,     , FourByteReal,  real,    real,   INTENTV)
VAR_SCALAR(put,     , EightByteReal, real,    double, INTENTV)
VAR_SCALAR(put,     , EightByteInt,  integer, int8,   INTENTV)

VAR_SCALAR(put, _all, OneByteInt,    integer, int1,   in)
VAR_SCALAR(put, _all, TwoByteInt,    integer, int2,   INTENTV)
VAR_SCALAR(put, _all, FourByteInt,   integer, int,    INTENTV)
VAR_SCALAR(put, _all, FourByteReal,  real,    real,   INTENTV)
VAR_SCALAR(put, _all, EightByteReal, real,    double, INTENTV)
VAR_SCALAR(put, _all, EightByteInt,  integer, int8,   INTENTV)

VAR_SCALAR(get,     , OneByteInt,    integer, int1,   out)
VAR_SCALAR(get,     , TwoByteInt,    integer, int2,   out)
VAR_SCALAR(get,     , FourByteInt,   integer, int,    out)
VAR_SCALAR(get,     , FourByteReal,  real,    real,   out)
VAR_SCALAR(get,     , EightByteReal, real,    double, out)
VAR_SCALAR(get,     , EightByteInt,  integer, int8,   out)

VAR_SCALAR(get, _all, OneByteInt,    integer, int1,   out)
VAR_SCALAR(get, _all, TwoByteInt,    integer, int2,   out)
VAR_SCALAR(get, _all, FourByteInt,   integer, int,    out)
VAR_SCALAR(get, _all, FourByteReal,  real,    real,   out)
VAR_SCALAR(get, _all, EightByteReal, real,    double, out)
VAR_SCALAR(get, _all, EightByteInt,  integer, int8,   out)

dnl
dnl NBVAR1(ncid, varid, values, start, count, req)
dnl
define(`NBVAR1',dnl
`dnl
   function nf90mpi_$1_var_$2(ncid, varid, values, req, start, bufcount, buftype)
     integer,                                                intent( in) :: ncid, varid
     $3 (kind=$2),                                           intent($5)  :: values
     integer,                                                intent(out) :: req
     integer (kind=MPI_OFFSET_KIND), dimension(:), optional, intent( in) :: start
     integer (kind=MPI_OFFSET_KIND),               optional, intent( in) :: bufcount
     integer,                                      optional, intent( in) :: buftype

     integer                                                             :: nf90mpi_$1_var_$2
     integer (kind=MPI_OFFSET_KIND), dimension(nf90_max_var_dims)        :: localIndex
 
     ! Set local arguments to default values
     localIndex(:) = 1
     if (present(start)) localIndex(:size(start)) = start(:)
 
     if (present(buftype)) then
         nf90mpi_$1_var_$2 = nfmpi_$1_var1(ncid, varid, localIndex, values, bufcount, buftype, req)
     else
         nf90mpi_$1_var_$2 = nfmpi_$1_var1_$4(ncid, varid, localIndex, values, req)
     endif
   end function nf90mpi_$1_var_$2
')dnl

!
! Nonblocking iput APIs
!

NBVAR1(iput, OneByteInt,    integer, int1,   in)
NBVAR1(iput, TwoByteInt,    integer, int2,   INTENTV)
NBVAR1(iput, FourByteInt,   integer, int,    INTENTV)
NBVAR1(iput, FourByteReal,  real,    real,   INTENTV)
NBVAR1(iput, EightByteReal, real,    double, INTENTV)
NBVAR1(iput, EightByteInt,  integer, int8,   INTENTV)

!
! Nonblocking iget APIs
!

NBVAR1(iget, OneByteInt,    integer, int1,   out)
NBVAR1(iget, TwoByteInt,    integer, int2,   out)
NBVAR1(iget, FourByteInt,   integer, int,    out)
NBVAR1(iget, FourByteReal,  real,    real,   out)
NBVAR1(iget, EightByteReal, real,    double, out)
NBVAR1(iget, EightByteInt,  integer, int8,   out)

!
! Nonblocking bput APIs
!

NBVAR1(bput, OneByteInt,    integer, int1,   in)
NBVAR1(bput, TwoByteInt,    integer, int2,   INTENTV)
NBVAR1(bput, FourByteInt,   integer, int,    INTENTV)
NBVAR1(bput, FourByteReal,  real,    real,   INTENTV)
NBVAR1(bput, EightByteReal, real,    double, INTENTV)
NBVAR1(bput, EightByteInt,  integer, int8,   INTENTV)

dnl
dnl VAR(ncid, varid, values, start, count, stride, map)
dnl
define(`VAR',dnl
`dnl
   function nf90mpi_$1_var_$2_$3$8(ncid, varid, values, start, count, stride, map, bufcount, buftype)
     integer,                                                intent( in) :: ncid, varid
     $4 (kind=$3), dimension($6),                            intent( $7) :: values
     integer (kind=MPI_OFFSET_KIND), dimension(:), optional, intent( in) :: start, count, stride, map
     integer (kind=MPI_OFFSET_KIND),               optional, intent( in) :: bufcount
     integer,                                      optional, intent( in) :: buftype
 
     integer                                                             :: nf90mpi_$1_var_$2_$3$8
     integer (kind=MPI_OFFSET_KIND), dimension(nf90_max_var_dims)        :: localStart, localCount, localStride, localMap
     integer                                                             :: numDims, counter
 
     ! Set local arguments to default values
     numDims = substr(`$2', `0', `1')
     localStart (:         ) = 1
     localCount (:numDims  ) = shape(values)
     localCount (numDims+1:) = 1
     localStride(:         ) = 1
     ! localMap   (:numDims  ) = (/ 1, (product(localCount(:counter)), counter = 1, numDims - 1) /)
     localMap(1) = 1
     do counter = 1, numDims - 1
        localMap(counter+1) = localMap(counter) * localCount(counter)
     enddo
 
     if (present(start))  localStart (:size(start) )  = start(:)
     if (present(count))  localCount (:size(count) )  = count(:)
     if (present(stride)) localStride(:size(stride)) = stride(:)
     if (present(map))  then
         localMap   (:size(map))    = map(:)
         if (present(buftype)) then
             nf90mpi_$1_var_$2_$3$8 = &
                nfmpi_$1_varm$8(ncid, varid, localStart, localCount, localStride, localMap, values, bufcount, buftype)
         else
             nf90mpi_$1_var_$2_$3$8 = &
                nfmpi_$1_varm_$5$8(ncid, varid, localStart, localCount, localStride, localMap, values)
         endif
     else if (present(stride)) then
         if (present(buftype)) then
             nf90mpi_$1_var_$2_$3$8 = &
                nfmpi_$1_vars$8(ncid, varid, localStart, localCount, localStride, values, bufcount, buftype)
         else
             nf90mpi_$1_var_$2_$3$8 = &
                nfmpi_$1_vars_$5$8(ncid, varid, localStart, localCount, localStride, values)
         endif
     else
         if (present(buftype)) then
             nf90mpi_$1_var_$2_$3$8 = &
                nfmpi_$1_vara$8(ncid, varid, localStart, localCount, values, bufcount, buftype)
         else
             nf90mpi_$1_var_$2_$3$8 = &
                nfmpi_$1_vara_$5$8(ncid, varid, localStart, localCount, values)
         endif
     end if
   end function nf90mpi_$1_var_$2_$3$8
')dnl

!
! Independent put APIs
!

VAR(put, 1D, OneByteInt, integer, int1,  :,              in)
VAR(put, 2D, OneByteInt, integer, int1, `:,:',           in)
VAR(put, 3D, OneByteInt, integer, int1, `:,:,:',         in)
VAR(put, 4D, OneByteInt, integer, int1, `:,:,:,:',       in)
VAR(put, 5D, OneByteInt, integer, int1, `:,:,:,:,:',     in)
VAR(put, 6D, OneByteInt, integer, int1, `:,:,:,:,:,:',   in)
VAR(put, 7D, OneByteInt, integer, int1, `:,:,:,:,:,:,:', in)

VAR(put, 1D, TwoByteInt, integer, int2,  :,              INTENTV)
VAR(put, 2D, TwoByteInt, integer, int2, `:,:',           INTENTV)
VAR(put, 3D, TwoByteInt, integer, int2, `:,:,:',         INTENTV)
VAR(put, 4D, TwoByteInt, integer, int2, `:,:,:,:',       INTENTV)
VAR(put, 5D, TwoByteInt, integer, int2, `:,:,:,:,:',     INTENTV)
VAR(put, 6D, TwoByteInt, integer, int2, `:,:,:,:,:,:',   INTENTV)
VAR(put, 7D, TwoByteInt, integer, int2, `:,:,:,:,:,:,:', INTENTV)

VAR(put, 1D, FourByteInt, integer, int,  :,              INTENTV)
VAR(put, 2D, FourByteInt, integer, int, `:,:',           INTENTV)
VAR(put, 3D, FourByteInt, integer, int, `:,:,:',         INTENTV)
VAR(put, 4D, FourByteInt, integer, int, `:,:,:,:',       INTENTV)
VAR(put, 5D, FourByteInt, integer, int, `:,:,:,:,:',     INTENTV)
VAR(put, 6D, FourByteInt, integer, int, `:,:,:,:,:,:',   INTENTV)
VAR(put, 7D, FourByteInt, integer, int, `:,:,:,:,:,:,:', INTENTV)

VAR(put, 1D, FourByteReal, real,   real,  :,              INTENTV)
VAR(put, 2D, FourByteReal, real,   real, `:,:',           INTENTV)
VAR(put, 3D, FourByteReal, real,   real, `:,:,:',         INTENTV)
VAR(put, 4D, FourByteReal, real,   real, `:,:,:,:',       INTENTV)
VAR(put, 5D, FourByteReal, real,   real, `:,:,:,:,:',     INTENTV)
VAR(put, 6D, FourByteReal, real,   real, `:,:,:,:,:,:',   INTENTV)
VAR(put, 7D, FourByteReal, real,   real, `:,:,:,:,:,:,:', INTENTV)

VAR(put, 1D, EightByteReal, real, double,  :,              INTENTV)
VAR(put, 2D, EightByteReal, real, double, `:,:',           INTENTV)
VAR(put, 3D, EightByteReal, real, double, `:,:,:',         INTENTV)
VAR(put, 4D, EightByteReal, real, double, `:,:,:,:',       INTENTV)
VAR(put, 5D, EightByteReal, real, double, `:,:,:,:,:',     INTENTV)
VAR(put, 6D, EightByteReal, real, double, `:,:,:,:,:,:',   INTENTV)
VAR(put, 7D, EightByteReal, real, double, `:,:,:,:,:,:,:', INTENTV)

VAR(put, 1D, EightByteInt, integer, int8,  :,              INTENTV)
VAR(put, 2D, EightByteInt, integer, int8, `:,:',           INTENTV)
VAR(put, 3D, EightByteInt, integer, int8, `:,:,:',         INTENTV)
VAR(put, 4D, EightByteInt, integer, int8, `:,:,:,:',       INTENTV)
VAR(put, 5D, EightByteInt, integer, int8, `:,:,:,:,:',     INTENTV)
VAR(put, 6D, EightByteInt, integer, int8, `:,:,:,:,:,:',   INTENTV)
VAR(put, 7D, EightByteInt, integer, int8, `:,:,:,:,:,:,:', INTENTV)

!
! Independent get APIs
!

VAR(get, 1D, OneByteInt, integer, int1,  :,              out)
VAR(get, 2D, OneByteInt, integer, int1, `:,:',           out)
VAR(get, 3D, OneByteInt, integer, int1, `:,:,:',         out)
VAR(get, 4D, OneByteInt, integer, int1, `:,:,:,:',       out)
VAR(get, 5D, OneByteInt, integer, int1, `:,:,:,:,:',     out)
VAR(get, 6D, OneByteInt, integer, int1, `:,:,:,:,:,:',   out)
VAR(get, 7D, OneByteInt, integer, int1, `:,:,:,:,:,:,:', out)

VAR(get, 1D, TwoByteInt, integer, int2,  :,              out)
VAR(get, 2D, TwoByteInt, integer, int2, `:,:',           out)
VAR(get, 3D, TwoByteInt, integer, int2, `:,:,:',         out)
VAR(get, 4D, TwoByteInt, integer, int2, `:,:,:,:',       out)
VAR(get, 5D, TwoByteInt, integer, int2, `:,:,:,:,:',     out)
VAR(get, 6D, TwoByteInt, integer, int2, `:,:,:,:,:,:',   out)
VAR(get, 7D, TwoByteInt, integer, int2, `:,:,:,:,:,:,:', out)

VAR(get, 1D, FourByteInt, integer, int,  :,              out)
VAR(get, 2D, FourByteInt, integer, int, `:,:',           out)
VAR(get, 3D, FourByteInt, integer, int, `:,:,:',         out)
VAR(get, 4D, FourByteInt, integer, int, `:,:,:,:',       out)
VAR(get, 5D, FourByteInt, integer, int, `:,:,:,:,:',     out)
VAR(get, 6D, FourByteInt, integer, int, `:,:,:,:,:,:',   out)
VAR(get, 7D, FourByteInt, integer, int, `:,:,:,:,:,:,:', out)

VAR(get, 1D, FourByteReal, real,   real,  :,              out)
VAR(get, 2D, FourByteReal, real,   real, `:,:',           out)
VAR(get, 3D, FourByteReal, real,   real, `:,:,:',         out)
VAR(get, 4D, FourByteReal, real,   real, `:,:,:,:',       out)
VAR(get, 5D, FourByteReal, real,   real, `:,:,:,:,:',     out)
VAR(get, 6D, FourByteReal, real,   real, `:,:,:,:,:,:',   out)
VAR(get, 7D, FourByteReal, real,   real, `:,:,:,:,:,:,:', out)

VAR(get, 1D, EightByteReal, real, double,  :,              out)
VAR(get, 2D, EightByteReal, real, double, `:,:',           out)
VAR(get, 3D, EightByteReal, real, double, `:,:,:',         out)
VAR(get, 4D, EightByteReal, real, double, `:,:,:,:',       out)
VAR(get, 5D, EightByteReal, real, double, `:,:,:,:,:',     out)
VAR(get, 6D, EightByteReal, real, double, `:,:,:,:,:,:',   out)
VAR(get, 7D, EightByteReal, real, double, `:,:,:,:,:,:,:', out)

VAR(get, 1D, EightByteInt, integer, int8,  :,              out)
VAR(get, 2D, EightByteInt, integer, int8, `:,:',           out)
VAR(get, 3D, EightByteInt, integer, int8, `:,:,:',         out)
VAR(get, 4D, EightByteInt, integer, int8, `:,:,:,:',       out)
VAR(get, 5D, EightByteInt, integer, int8, `:,:,:,:,:',     out)
VAR(get, 6D, EightByteInt, integer, int8, `:,:,:,:,:,:',   out)
VAR(get, 7D, EightByteInt, integer, int8, `:,:,:,:,:,:,:', out)

!
! collective put APIs
!

VAR(put, 1D, OneByteInt, integer, int1,  :,              in, _all)
VAR(put, 2D, OneByteInt, integer, int1, `:,:',           in, _all)
VAR(put, 3D, OneByteInt, integer, int1, `:,:,:',         in, _all)
VAR(put, 4D, OneByteInt, integer, int1, `:,:,:,:',       in, _all)
VAR(put, 5D, OneByteInt, integer, int1, `:,:,:,:,:',     in, _all)
VAR(put, 6D, OneByteInt, integer, int1, `:,:,:,:,:,:',   in, _all)
VAR(put, 7D, OneByteInt, integer, int1, `:,:,:,:,:,:,:', in, _all)

VAR(put, 1D, TwoByteInt, integer, int2,  :,              INTENTV, _all)
VAR(put, 2D, TwoByteInt, integer, int2, `:,:',           INTENTV, _all)
VAR(put, 3D, TwoByteInt, integer, int2, `:,:,:',         INTENTV, _all)
VAR(put, 4D, TwoByteInt, integer, int2, `:,:,:,:',       INTENTV, _all)
VAR(put, 5D, TwoByteInt, integer, int2, `:,:,:,:,:',     INTENTV, _all)
VAR(put, 6D, TwoByteInt, integer, int2, `:,:,:,:,:,:',   INTENTV, _all)
VAR(put, 7D, TwoByteInt, integer, int2, `:,:,:,:,:,:,:', INTENTV, _all)

VAR(put, 1D, FourByteInt, integer, int,  :,              INTENTV, _all)
VAR(put, 2D, FourByteInt, integer, int, `:,:',           INTENTV, _all)
VAR(put, 3D, FourByteInt, integer, int, `:,:,:',         INTENTV, _all)
VAR(put, 4D, FourByteInt, integer, int, `:,:,:,:',       INTENTV, _all)
VAR(put, 5D, FourByteInt, integer, int, `:,:,:,:,:',     INTENTV, _all)
VAR(put, 6D, FourByteInt, integer, int, `:,:,:,:,:,:',   INTENTV, _all)
VAR(put, 7D, FourByteInt, integer, int, `:,:,:,:,:,:,:', INTENTV, _all)

VAR(put, 1D, FourByteReal, real,   real,  :,              INTENTV, _all)
VAR(put, 2D, FourByteReal, real,   real, `:,:',           INTENTV, _all)
VAR(put, 3D, FourByteReal, real,   real, `:,:,:',         INTENTV, _all)
VAR(put, 4D, FourByteReal, real,   real, `:,:,:,:',       INTENTV, _all)
VAR(put, 5D, FourByteReal, real,   real, `:,:,:,:,:',     INTENTV, _all)
VAR(put, 6D, FourByteReal, real,   real, `:,:,:,:,:,:',   INTENTV, _all)
VAR(put, 7D, FourByteReal, real,   real, `:,:,:,:,:,:,:', INTENTV, _all)

VAR(put, 1D, EightByteReal, real, double,  :,              INTENTV, _all)
VAR(put, 2D, EightByteReal, real, double, `:,:',           INTENTV, _all)
VAR(put, 3D, EightByteReal, real, double, `:,:,:',         INTENTV, _all)
VAR(put, 4D, EightByteReal, real, double, `:,:,:,:',       INTENTV, _all)
VAR(put, 5D, EightByteReal, real, double, `:,:,:,:,:',     INTENTV, _all)
VAR(put, 6D, EightByteReal, real, double, `:,:,:,:,:,:',   INTENTV, _all)
VAR(put, 7D, EightByteReal, real, double, `:,:,:,:,:,:,:', INTENTV, _all)

VAR(put, 1D, EightByteInt, integer, int8,  :,              INTENTV, _all)
VAR(put, 2D, EightByteInt, integer, int8, `:,:',           INTENTV, _all)
VAR(put, 3D, EightByteInt, integer, int8, `:,:,:',         INTENTV, _all)
VAR(put, 4D, EightByteInt, integer, int8, `:,:,:,:',       INTENTV, _all)
VAR(put, 5D, EightByteInt, integer, int8, `:,:,:,:,:',     INTENTV, _all)
VAR(put, 6D, EightByteInt, integer, int8, `:,:,:,:,:,:',   INTENTV, _all)
VAR(put, 7D, EightByteInt, integer, int8, `:,:,:,:,:,:,:', INTENTV, _all)
!
! collective get APIs
!

VAR(get, 1D, OneByteInt, integer, int1,  :,              out, _all)
VAR(get, 2D, OneByteInt, integer, int1, `:,:',           out, _all)
VAR(get, 3D, OneByteInt, integer, int1, `:,:,:',         out, _all)
VAR(get, 4D, OneByteInt, integer, int1, `:,:,:,:',       out, _all)
VAR(get, 5D, OneByteInt, integer, int1, `:,:,:,:,:',     out, _all)
VAR(get, 6D, OneByteInt, integer, int1, `:,:,:,:,:,:',   out, _all)
VAR(get, 7D, OneByteInt, integer, int1, `:,:,:,:,:,:,:', out, _all)

VAR(get, 1D, TwoByteInt, integer, int2,  :,              out, _all)
VAR(get, 2D, TwoByteInt, integer, int2, `:,:',           out, _all)
VAR(get, 3D, TwoByteInt, integer, int2, `:,:,:',         out, _all)
VAR(get, 4D, TwoByteInt, integer, int2, `:,:,:,:',       out, _all)
VAR(get, 5D, TwoByteInt, integer, int2, `:,:,:,:,:',     out, _all)
VAR(get, 6D, TwoByteInt, integer, int2, `:,:,:,:,:,:',   out, _all)
VAR(get, 7D, TwoByteInt, integer, int2, `:,:,:,:,:,:,:', out, _all)

VAR(get, 1D, FourByteInt, integer, int,  :,              out, _all)
VAR(get, 2D, FourByteInt, integer, int, `:,:',           out, _all)
VAR(get, 3D, FourByteInt, integer, int, `:,:,:',         out, _all)
VAR(get, 4D, FourByteInt, integer, int, `:,:,:,:',       out, _all)
VAR(get, 5D, FourByteInt, integer, int, `:,:,:,:,:',     out, _all)
VAR(get, 6D, FourByteInt, integer, int, `:,:,:,:,:,:',   out, _all)
VAR(get, 7D, FourByteInt, integer, int, `:,:,:,:,:,:,:', out, _all)

VAR(get, 1D, FourByteReal, real,   real,  :,              out, _all)
VAR(get, 2D, FourByteReal, real,   real, `:,:',           out, _all)
VAR(get, 3D, FourByteReal, real,   real, `:,:,:',         out, _all)
VAR(get, 4D, FourByteReal, real,   real, `:,:,:,:',       out, _all)
VAR(get, 5D, FourByteReal, real,   real, `:,:,:,:,:',     out, _all)
VAR(get, 6D, FourByteReal, real,   real, `:,:,:,:,:,:',   out, _all)
VAR(get, 7D, FourByteReal, real,   real, `:,:,:,:,:,:,:', out, _all)

VAR(get, 1D, EightByteReal, real, double,  :,              out, _all)
VAR(get, 2D, EightByteReal, real, double, `:,:',           out, _all)
VAR(get, 3D, EightByteReal, real, double, `:,:,:',         out, _all)
VAR(get, 4D, EightByteReal, real, double, `:,:,:,:',       out, _all)
VAR(get, 5D, EightByteReal, real, double, `:,:,:,:,:',     out, _all)
VAR(get, 6D, EightByteReal, real, double, `:,:,:,:,:,:',   out, _all)
VAR(get, 7D, EightByteReal, real, double, `:,:,:,:,:,:,:', out, _all)

VAR(get, 1D, EightByteInt, integer, int8,  :,              out, _all)
VAR(get, 2D, EightByteInt, integer, int8, `:,:',           out, _all)
VAR(get, 3D, EightByteInt, integer, int8, `:,:,:',         out, _all)
VAR(get, 4D, EightByteInt, integer, int8, `:,:,:,:',       out, _all)
VAR(get, 5D, EightByteInt, integer, int8, `:,:,:,:,:',     out, _all)
VAR(get, 6D, EightByteInt, integer, int8, `:,:,:,:,:,:',   out, _all)
VAR(get, 7D, EightByteInt, integer, int8, `:,:,:,:,:,:,:', out, _all)

!
! Nonblocking APIs
!

dnl
dnl NBVAR(ncid, varid, values, start, count, stride, map, req)
dnl
define(`NBVAR',dnl
`dnl
   function nf90mpi_$1_var_$2_$3(ncid, varid, values, req, start, count, stride, map, bufcount, buftype)
     integer,                                                intent( in) :: ncid, varid
     $4 (kind=$3), dimension($6),                            intent( $7) :: values
     integer,                                                intent(out) :: req
     integer (kind=MPI_OFFSET_KIND), dimension(:), optional, intent( in) :: start, count, stride, map
     integer (kind=MPI_OFFSET_KIND),               optional, intent( in) :: bufcount
     integer,                                      optional, intent( in) :: buftype
 
     integer                                                             :: nf90mpi_$1_var_$2_$3
     integer (kind=MPI_OFFSET_KIND), dimension(nf90_max_var_dims)        :: localStart, localCount, localStride, localMap
     integer                                                             :: numDims, counter
 
     ! Set local arguments to default values
     numDims = substr(`$2', `0', `1')
     localStart (:         ) = 1
     localCount (:numDims  ) = shape(values)
     localCount (numDims+1:) = 1
     localStride(:         ) = 1
     ! localMap   (:numDims  ) = (/ 1, (product(localCount(:counter)), counter = 1, numDims - 1) /)
     localMap(1) = 1
     do counter = 1, numDims - 1
        localMap(counter+1) = localMap(counter) * localCount(counter)
     enddo
 
     if (present(start))  localStart (:size(start) )  = start(:)
     if (present(count))  localCount (:size(count) )  = count(:)
     if (present(stride)) localStride(:size(stride)) = stride(:)
     if (present(map))  then
         localMap   (:size(map))    = map(:)
         if (present(buftype)) then
             nf90mpi_$1_var_$2_$3 = &
                 nfmpi_$1_varm(ncid, varid, localStart, localCount, localStride, localMap, values, bufcount, buftype, req)
         else
             nf90mpi_$1_var_$2_$3 = &
                 nfmpi_$1_varm_$5(ncid, varid, localStart, localCount, localStride, localMap, values, req)
         endif
     else if (present(stride)) then
         if (present(buftype)) then
             nf90mpi_$1_var_$2_$3 = &
                 nfmpi_$1_vars(ncid, varid, localStart, localCount, localStride, values, bufcount, buftype, req)
         else
             nf90mpi_$1_var_$2_$3 = &
                 nfmpi_$1_vars_$5(ncid, varid, localStart, localCount, localStride, values, req)
         endif
     else
         if (present(buftype)) then
             nf90mpi_$1_var_$2_$3 = &
                 nfmpi_$1_vara(ncid, varid, localStart, localCount, values, bufcount, buftype, req)
         else
             nf90mpi_$1_var_$2_$3 = &
                 nfmpi_$1_vara_$5(ncid, varid, localStart, localCount, values, req)
         endif
     end if
   end function nf90mpi_$1_var_$2_$3
')dnl

!
! iput APIs
!

NBVAR(iput, 1D, OneByteInt, integer, int1,  :,              in)
NBVAR(iput, 2D, OneByteInt, integer, int1, `:,:',           in)
NBVAR(iput, 3D, OneByteInt, integer, int1, `:,:,:',         in)
NBVAR(iput, 4D, OneByteInt, integer, int1, `:,:,:,:',       in)
NBVAR(iput, 5D, OneByteInt, integer, int1, `:,:,:,:,:',     in)
NBVAR(iput, 6D, OneByteInt, integer, int1, `:,:,:,:,:,:',   in)
NBVAR(iput, 7D, OneByteInt, integer, int1, `:,:,:,:,:,:,:', in)

NBVAR(iput, 1D, TwoByteInt, integer, int2,  :,              INTENTV)
NBVAR(iput, 2D, TwoByteInt, integer, int2, `:,:',           INTENTV)
NBVAR(iput, 3D, TwoByteInt, integer, int2, `:,:,:',         INTENTV)
NBVAR(iput, 4D, TwoByteInt, integer, int2, `:,:,:,:',       INTENTV)
NBVAR(iput, 5D, TwoByteInt, integer, int2, `:,:,:,:,:',     INTENTV)
NBVAR(iput, 6D, TwoByteInt, integer, int2, `:,:,:,:,:,:',   INTENTV)
NBVAR(iput, 7D, TwoByteInt, integer, int2, `:,:,:,:,:,:,:', INTENTV)

NBVAR(iput, 1D, FourByteInt, integer, int,  :,              INTENTV)
NBVAR(iput, 2D, FourByteInt, integer, int, `:,:',           INTENTV)
NBVAR(iput, 3D, FourByteInt, integer, int, `:,:,:',         INTENTV)
NBVAR(iput, 4D, FourByteInt, integer, int, `:,:,:,:',       INTENTV)
NBVAR(iput, 5D, FourByteInt, integer, int, `:,:,:,:,:',     INTENTV)
NBVAR(iput, 6D, FourByteInt, integer, int, `:,:,:,:,:,:',   INTENTV)
NBVAR(iput, 7D, FourByteInt, integer, int, `:,:,:,:,:,:,:', INTENTV)

NBVAR(iput, 1D, FourByteReal, real,   real,  :,              INTENTV)
NBVAR(iput, 2D, FourByteReal, real,   real, `:,:',           INTENTV)
NBVAR(iput, 3D, FourByteReal, real,   real, `:,:,:',         INTENTV)
NBVAR(iput, 4D, FourByteReal, real,   real, `:,:,:,:',       INTENTV)
NBVAR(iput, 5D, FourByteReal, real,   real, `:,:,:,:,:',     INTENTV)
NBVAR(iput, 6D, FourByteReal, real,   real, `:,:,:,:,:,:',   INTENTV)
NBVAR(iput, 7D, FourByteReal, real,   real, `:,:,:,:,:,:,:', INTENTV)

NBVAR(iput, 1D, EightByteReal, real, double,  :,              INTENTV)
NBVAR(iput, 2D, EightByteReal, real, double, `:,:',           INTENTV)
NBVAR(iput, 3D, EightByteReal, real, double, `:,:,:',         INTENTV)
NBVAR(iput, 4D, EightByteReal, real, double, `:,:,:,:',       INTENTV)
NBVAR(iput, 5D, EightByteReal, real, double, `:,:,:,:,:',     INTENTV)
NBVAR(iput, 6D, EightByteReal, real, double, `:,:,:,:,:,:',   INTENTV)
NBVAR(iput, 7D, EightByteReal, real, double, `:,:,:,:,:,:,:', INTENTV)

NBVAR(iput, 1D, EightByteInt, integer, int8,  :,              INTENTV)
NBVAR(iput, 2D, EightByteInt, integer, int8, `:,:',           INTENTV)
NBVAR(iput, 3D, EightByteInt, integer, int8, `:,:,:',         INTENTV)
NBVAR(iput, 4D, EightByteInt, integer, int8, `:,:,:,:',       INTENTV)
NBVAR(iput, 5D, EightByteInt, integer, int8, `:,:,:,:,:',     INTENTV)
NBVAR(iput, 6D, EightByteInt, integer, int8, `:,:,:,:,:,:',   INTENTV)
NBVAR(iput, 7D, EightByteInt, integer, int8, `:,:,:,:,:,:,:', INTENTV)

!
! iget APIs
!

NBVAR(iget, 1D, OneByteInt, integer, int1,  :,              out)
NBVAR(iget, 2D, OneByteInt, integer, int1, `:,:',           out)
NBVAR(iget, 3D, OneByteInt, integer, int1, `:,:,:',         out)
NBVAR(iget, 4D, OneByteInt, integer, int1, `:,:,:,:',       out)
NBVAR(iget, 5D, OneByteInt, integer, int1, `:,:,:,:,:',     out)
NBVAR(iget, 6D, OneByteInt, integer, int1, `:,:,:,:,:,:',   out)
NBVAR(iget, 7D, OneByteInt, integer, int1, `:,:,:,:,:,:,:', out)

NBVAR(iget, 1D, TwoByteInt, integer, int2,  :,              out)
NBVAR(iget, 2D, TwoByteInt, integer, int2, `:,:',           out)
NBVAR(iget, 3D, TwoByteInt, integer, int2, `:,:,:',         out)
NBVAR(iget, 4D, TwoByteInt, integer, int2, `:,:,:,:',       out)
NBVAR(iget, 5D, TwoByteInt, integer, int2, `:,:,:,:,:',     out)
NBVAR(iget, 6D, TwoByteInt, integer, int2, `:,:,:,:,:,:',   out)
NBVAR(iget, 7D, TwoByteInt, integer, int2, `:,:,:,:,:,:,:', out)

NBVAR(iget, 1D, FourByteInt, integer, int,  :,              out)
NBVAR(iget, 2D, FourByteInt, integer, int, `:,:',           out)
NBVAR(iget, 3D, FourByteInt, integer, int, `:,:,:',         out)
NBVAR(iget, 4D, FourByteInt, integer, int, `:,:,:,:',       out)
NBVAR(iget, 5D, FourByteInt, integer, int, `:,:,:,:,:',     out)
NBVAR(iget, 6D, FourByteInt, integer, int, `:,:,:,:,:,:',   out)
NBVAR(iget, 7D, FourByteInt, integer, int, `:,:,:,:,:,:,:', out)

NBVAR(iget, 1D, FourByteReal, real,   real,  :,              out)
NBVAR(iget, 2D, FourByteReal, real,   real, `:,:',           out)
NBVAR(iget, 3D, FourByteReal, real,   real, `:,:,:',         out)
NBVAR(iget, 4D, FourByteReal, real,   real, `:,:,:,:',       out)
NBVAR(iget, 5D, FourByteReal, real,   real, `:,:,:,:,:',     out)
NBVAR(iget, 6D, FourByteReal, real,   real, `:,:,:,:,:,:',   out)
NBVAR(iget, 7D, FourByteReal, real,   real, `:,:,:,:,:,:,:', out)

NBVAR(iget, 1D, EightByteReal, real, double,  :,              out)
NBVAR(iget, 2D, EightByteReal, real, double, `:,:',           out)
NBVAR(iget, 3D, EightByteReal, real, double, `:,:,:',         out)
NBVAR(iget, 4D, EightByteReal, real, double, `:,:,:,:',       out)
NBVAR(iget, 5D, EightByteReal, real, double, `:,:,:,:,:',     out)
NBVAR(iget, 6D, EightByteReal, real, double, `:,:,:,:,:,:',   out)
NBVAR(iget, 7D, EightByteReal, real, double, `:,:,:,:,:,:,:', out)

NBVAR(iget, 1D, EightByteInt, integer, int8,  :,              out)
NBVAR(iget, 2D, EightByteInt, integer, int8, `:,:',           out)
NBVAR(iget, 3D, EightByteInt, integer, int8, `:,:,:',         out)
NBVAR(iget, 4D, EightByteInt, integer, int8, `:,:,:,:',       out)
NBVAR(iget, 5D, EightByteInt, integer, int8, `:,:,:,:,:',     out)
NBVAR(iget, 6D, EightByteInt, integer, int8, `:,:,:,:,:,:',   out)
NBVAR(iget, 7D, EightByteInt, integer, int8, `:,:,:,:,:,:,:', out)

!
! bput APIs
!

NBVAR(bput, 1D, OneByteInt, integer, int1,  :,              in)
NBVAR(bput, 2D, OneByteInt, integer, int1, `:,:',           in)
NBVAR(bput, 3D, OneByteInt, integer, int1, `:,:,:',         in)
NBVAR(bput, 4D, OneByteInt, integer, int1, `:,:,:,:',       in)
NBVAR(bput, 5D, OneByteInt, integer, int1, `:,:,:,:,:',     in)
NBVAR(bput, 6D, OneByteInt, integer, int1, `:,:,:,:,:,:',   in)
NBVAR(bput, 7D, OneByteInt, integer, int1, `:,:,:,:,:,:,:', in)

NBVAR(bput, 1D, TwoByteInt, integer, int2,  :,              INTENTV)
NBVAR(bput, 2D, TwoByteInt, integer, int2, `:,:',           INTENTV)
NBVAR(bput, 3D, TwoByteInt, integer, int2, `:,:,:',         INTENTV)
NBVAR(bput, 4D, TwoByteInt, integer, int2, `:,:,:,:',       INTENTV)
NBVAR(bput, 5D, TwoByteInt, integer, int2, `:,:,:,:,:',     INTENTV)
NBVAR(bput, 6D, TwoByteInt, integer, int2, `:,:,:,:,:,:',   INTENTV)
NBVAR(bput, 7D, TwoByteInt, integer, int2, `:,:,:,:,:,:,:', INTENTV)

NBVAR(bput, 1D, FourByteInt, integer, int,  :,              INTENTV)
NBVAR(bput, 2D, FourByteInt, integer, int, `:,:',           INTENTV)
NBVAR(bput, 3D, FourByteInt, integer, int, `:,:,:',         INTENTV)
NBVAR(bput, 4D, FourByteInt, integer, int, `:,:,:,:',       INTENTV)
NBVAR(bput, 5D, FourByteInt, integer, int, `:,:,:,:,:',     INTENTV)
NBVAR(bput, 6D, FourByteInt, integer, int, `:,:,:,:,:,:',   INTENTV)
NBVAR(bput, 7D, FourByteInt, integer, int, `:,:,:,:,:,:,:', INTENTV)

NBVAR(bput, 1D, FourByteReal, real,   real,  :,              INTENTV)
NBVAR(bput, 2D, FourByteReal, real,   real, `:,:',           INTENTV)
NBVAR(bput, 3D, FourByteReal, real,   real, `:,:,:',         INTENTV)
NBVAR(bput, 4D, FourByteReal, real,   real, `:,:,:,:',       INTENTV)
NBVAR(bput, 5D, FourByteReal, real,   real, `:,:,:,:,:',     INTENTV)
NBVAR(bput, 6D, FourByteReal, real,   real, `:,:,:,:,:,:',   INTENTV)
NBVAR(bput, 7D, FourByteReal, real,   real, `:,:,:,:,:,:,:', INTENTV)

NBVAR(bput, 1D, EightByteReal, real, double,  :,              INTENTV)
NBVAR(bput, 2D, EightByteReal, real, double, `:,:',           INTENTV)
NBVAR(bput, 3D, EightByteReal, real, double, `:,:,:',         INTENTV)
NBVAR(bput, 4D, EightByteReal, real, double, `:,:,:,:',       INTENTV)
NBVAR(bput, 5D, EightByteReal, real, double, `:,:,:,:,:',     INTENTV)
NBVAR(bput, 6D, EightByteReal, real, double, `:,:,:,:,:,:',   INTENTV)
NBVAR(bput, 7D, EightByteReal, real, double, `:,:,:,:,:,:,:', INTENTV)

NBVAR(bput, 1D, EightByteInt, integer, int8,  :,              INTENTV)
NBVAR(bput, 2D, EightByteInt, integer, int8, `:,:',           INTENTV)
NBVAR(bput, 3D, EightByteInt, integer, int8, `:,:,:',         INTENTV)
NBVAR(bput, 4D, EightByteInt, integer, int8, `:,:,:,:',       INTENTV)
NBVAR(bput, 5D, EightByteInt, integer, int8, `:,:,:,:,:',     INTENTV)
NBVAR(bput, 6D, EightByteInt, integer, int8, `:,:,:,:,:,:',   INTENTV)
NBVAR(bput, 7D, EightByteInt, integer, int8, `:,:,:,:,:,:,:', INTENTV)

!
! Other nonblocking control APIs
!

   function nf90mpi_wait(ncid, num, req, st)
     integer,               intent(in)    :: ncid, num
     integer, dimension(:), intent(inout) :: req
     integer, dimension(:), intent(out)   :: st
     integer                              :: nf90mpi_wait
 
     nf90mpi_wait = nfmpi_wait(ncid, num, req, st)
   end function nf90mpi_wait

   function nf90mpi_wait_all(ncid, num, req, st)
     integer,               intent(in)    :: ncid, num
     integer, dimension(:), intent(inout) :: req
     integer, dimension(:), intent(out)   :: st
     integer                              :: nf90mpi_wait_all
 
     nf90mpi_wait_all = nfmpi_wait_all(ncid, num, req, st)
   end function nf90mpi_wait_all

   function nf90mpi_cancel(ncid, num, req, st)
     integer,               intent(in)    :: ncid, num
     integer, dimension(:), intent(inout) :: req
     integer, dimension(:), intent(out)   :: st
     integer                              :: nf90mpi_cancel
 
     nf90mpi_cancel = nfmpi_cancel(ncid, num, req, st)
   end function nf90mpi_cancel

   function nf90mpi_buffer_attach(ncid, bufsize)
     integer,                        intent( in) :: ncid
     integer (kind=MPI_OFFSET_KIND), intent( in) :: bufsize
     integer                                     :: nf90mpi_buffer_attach

     nf90mpi_buffer_attach = nfmpi_buffer_attach(ncid, bufsize)
   end function nf90mpi_buffer_attach

   function nf90mpi_inq_buffer_usage(ncid, usage)
     integer,                        intent( in) :: ncid
     integer (kind=MPI_OFFSET_KIND), intent(out) :: usage
     integer                                     :: nf90mpi_inq_buffer_usage

     nf90mpi_inq_buffer_usage = nfmpi_inq_buffer_usage(ncid, usage)
   end function nf90mpi_inq_buffer_usage

   function nf90mpi_inq_buffer_size(ncid, buf_size)
     integer,                        intent( in) :: ncid
     integer (kind=MPI_OFFSET_KIND), intent(out) :: buf_size
     integer                                     :: nf90mpi_inq_buffer_size

     nf90mpi_inq_buffer_size = nfmpi_inq_buffer_usage(ncid, buf_size)
   end function nf90mpi_inq_buffer_size

   function nf90mpi_buffer_detach(ncid)
     integer,                       intent( in) :: ncid
     integer                                    :: nf90mpi_buffer_detach

     nf90mpi_buffer_detach = nfmpi_buffer_detach(ncid)
   end function nf90mpi_buffer_detach

