# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-839-1 (samba)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(65011);
 script_cve_id("CVE-2009-1886", "CVE-2009-1888", "CVE-2009-2813", "CVE-2009-2906", "CVE-2009-2948");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Ubuntu USN-839-1 (samba)");

 desc = "The remote host is missing an update to samba
announced via advisory USN-839-1.

Details follow:

J. David Hester discovered that Samba incorrectly handled users that lack
home directories when the automated [homes] share is enabled. An
authenticated user could connect to that share name and gain access to the
whole filesystem. (CVE-2009-2813)

Tim Prouty discovered that the smbd daemon in Samba incorrectly handled
certain unexpected network replies. A remote attacker could send malicious
replies to the server and cause smbd to use all available CPU, leading to a
denial of service. (CVE-2009-2906)

Ronald Volgers discovered that the mount.cifs utility, when installed as a
setuid program, would not verify user permissions before opening a
credentials file. A local user could exploit this to use or read the
contents of unauthorized credential files. (CVE-2009-2948)

Reinhard Nil discovered that the smbclient utility contained format string
vulnerabilities in its file name handling. Because of security features in
Ubuntu, exploitation of this vulnerability is limited. If a user or
automated system were tricked into processing a specially crafted file
name, smbclient could be made to crash, possibly leading to a denial of
service. This only affected Ubuntu 8.10. (CVE-2009-1886)

Jeremy Allison discovered that the smbd daemon in Samba incorrectly handled
permissions to modify access control lists when dos filemode is enabled. A
remote attacker could exploit this to modify access control lists. This
only affected Ubuntu 8.10 and Ubuntu 9.04. (CVE-2009-1886)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  samba                           3.0.22-1ubuntu3.9
  smbfs                           3.0.22-1ubuntu3.9

Ubuntu 8.04 LTS:
  samba                           3.0.28a-1ubuntu4.9
  smbfs                           3.0.28a-1ubuntu4.9

Ubuntu 8.10:
  samba                           2:3.2.3-1ubuntu3.6
  smbclient                       2:3.2.3-1ubuntu3.6
  smbfs                           2:3.2.3-1ubuntu3.6

Ubuntu 9.04:
  samba                           2:3.3.2-1ubuntu3.2
  smbfs                           2:3.3.2-1ubuntu3.2

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-839-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-839-1 (samba)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-samba", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.0.22-1ubuntu3.9", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.0.28a-1ubuntu4.9", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwbclient0", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-tools", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.2.3-1ubuntu3.6", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwbclient0", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-tools", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.3.2-1ubuntu3.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
