#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
# This script is released under the GNU GPLv2
#

if(description)
{
 script_id(19753);
 script_bugtraq_id(14141);
 script_version ("$Revision: 7518 $");
 script_tag(name:"risk_factor", value:"Low");
 name = "PhpGroupWare Addressbook < 0.9.16 Unspecified Flaw";

 script_name(name);
 
 desc = "
The remote host seems to be running PhpGroupWare, is a multi-user
groupware suite written in PHP. 

This version is prone to an unspecified flaw related to its addressbook. 

Solution : Update to version 0.9.16.000 or newer.
See also : http://www.phpgroupware.org/
Risk factor : Low";

 script_description(desc);
 
 summary = "Checks for PhpGroupWare version";
 
 script_summary(summary);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright("This script is Copyright (C) 2005 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("phpgroupware_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
port = get_http_port(default:80);

kb = get_kb_item("www/" + port + "/phpGroupWare");
if ( ! kb ) exit(0);

matches = eregmatch(pattern:"(.*) under (.*)", string:kb);
if ( ereg(pattern:"^0\.([0-8]\.|9\.([0-9]\.|1[0-5]\.$))", string:matches[1]))
	security_warning(port);
