###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_thunderbird_detect_lin.nasl 302 2008-10-13 18:10:37Z oct $
#
# Mozilla Thunderbird Version Detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800018);
  script_version("$Revision: 1.1 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Mozilla Thunderbird Version Detection (Linux)");
  desc = "
  Overview : This script retrieves Mozilla ThunderBird Version and
  saves it in KB.

  Risk factor : None";

  script_description(desc);
  script_family("General");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_summary("Set Version of Mozilla Thunderbird in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

birdName = find_file(file_name:"thunderbird", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);
foreach binary_birdName (birdName)
{
  binary_name = chomp(binary_birdName);
  birdVer = get_bin_version(full_prog_name:binary_name, version_argv:"-v",
                              ver_pattern:"[0-9].[0-9.]+", sock:sock);
  if(birdVer)
  {
    set_kb_item(name:"Thunderbird/Linux/Ver", value:birdVer[0]);
    security_note(data:"Mozilla Thunderbird version " + birdVer[0] + 
                  " running at location " + binary_birdName + " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
