##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_django_detect_lin.nasl 3797 2009-08-07 10:48:37Z aug $
#
# Django Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800923);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Django Version Detection (Linux)");
  desc = "

  Overview: This script detects the installed version of Django and sets the
  result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of Django in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("version_func.inc");
include("ssh_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_file(file_name:"django-admin.py", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:sock);

foreach binaryFile (getPath)
{
  djangoVer = get_bin_version(full_prog_name:chomp(binaryFile), sock:sock,
                              version_argv:"--version", ver_pattern:"^[0-9.]+");

  if(djangoVer[0] != NULL)
  {
    set_kb_item(name:"Django/Linux/Ver", value:djangoVer[0]);
    security_note(data:"Django version " + djangoVer[0] + " running at location " 
                       + binaryFile + " was detected on the host");
  }
}
ssh_close_connection();
