# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 582-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53274);
 script_bugtraq_id(11526);
 script_cve_id("CVE-2004-0989");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 582-1 (libxml, libxml2)";
 script_name(name);

 desc = "The remote host is missing an update to libxml, libxml2
announced via advisory DSA 582-1.

infamous41md discovered several buffer overflows in libxml and
libxml2, the XML C parser and toolkits for GNOME.  Missing boundary
checks could cause several buffers to be overflown, which may cause
the client to execute arbitrary code.

The following vulnerability matrix lists corrected versions of these
libraries:

For the stable distribution (woody) these problems have been fixed in
version 1.8.17-2woody2 of libxml and in version 2.4.19-4woody2 of
libxml2.

For the unstable distribution (sid) these problems have been fixed in
version 1.8.17-9 of libxml and in version 2.6.11-5 of libxml2.

These problems have also been fixed in version 2.6.15-1 of libxml2 in
the experimental distribution.

We recommend that you upgrade your libxml packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20582-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 582-1 (libxml, libxml2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libxml-dev", ver:"1.8.17-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml1", ver:"1.8.17-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.4.19-4woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.4.19-4woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
