# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 533-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53222);
 script_bugtraq_id(10588);
 script_cve_id("CVE-2004-0591");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 533-1 (courier)";
 script_name(name);

 desc = "The remote host is missing an update to courier
announced via advisory DSA 533-1.

A cross-site scripting vulnerability was discovered in sqwebmail, a
web mail application provided by the courier mail suite, whereby an
attacker could cause web script to be executed within the security
context of the sqwebmail application by injecting it via an email
message.

For the current stable distribution (woody), this problem has been
fixed in version 0.37.3-2.5.

For the unstable distribution (sid), this problem has been fixed in
version 0.45.4-4.

We recommend that you update your courier package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20533-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 533-1 (courier)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"courier-doc", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authdaemon", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-authmysql", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-base", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-debug", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-imap", ver:"1.4.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-ldap", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-maildrop", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mlm", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-mta", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pcp", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-pop", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"courier-webadmin", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sqwebmail", ver:"0.37.3-2.5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
