# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1374-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58595);
 script_cve_id("CVE-2007-3189", "CVE-2007-3190", "CVE-2007-3191", "CVE-2007-3192");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.4");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1374-1 (jffnms)";
 script_name(name);

 desc = "The remote host is missing an update to jffnms
announced via advisory DSA 1374-1.

Several vulnerabilities have been discovered in jffnms, a web-based
Network Management System for IP networks.  The Common Vulnerabilities
and Exposures project identifies the following problems:

CVE-2007-3189

Cross-site scripting (XSS) vulnerability in auth.php, which allows
a remote attacker to inject arbitrary web script or HTML via the
user parameter.

CVE-2007-3190

Multiple SQL injection vulnerabilities in auth.php, which allow
remote attackers to execute arbitrary SQL commands via the
user and password parameters.

CVE-2007-3192

Direct requests to URLs make it possible for remote attackers to
access configuration information, bypassing login restrictions.


For the stable distribution (etch), these problems have been fixed in version
0.8.3dfsg.1-2.1etch1

For the unstable distribution (sid), these problems have been fixed in
version 0.8.3dfsg.1-4.

We recommend that you upgrade your jffnms package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201374-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1374-1 (jffnms)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"jffnms", ver:"0.8.3dfsg.1-2.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
