# Common Modes in OpenRGB

OpenRGB uses "modes" to describe RGB effects built into a device’s firmware.  These effects can be changed by selecting a mode in the OpenRGB interface.  The patterns are generated by the device’s RGB controller, not by OpenRGB, and run independently of the PC.  In the interest of being able to better describe these modes, we are trying to standardize the mode names across all supported devices.

There are several effects that are pretty common across many brands and vendors of RGB hardware.  Manufacturers often use different names for the same mode.  For example, a fade-in/fade-out effect might be called "Fading", "Breathing", or "Breath".  A color-cycling effect might appear as "Cycle", "Spectrum Cycle", "Spectrum", or "Rainbow".  A lot of OpenRGB's existing code simply copies the same names the official software gave to the modes, but these differences in name prevent us from being able to apply what is essentially the same effect across multiple devices when the names don't match.  It also limits our ability to provide clear descriptions of modes through tooltips.  To remedy this, we have compiled a list of common modes and providing names that we can use across all devices for any mode that implements a certain style of effect.  If all devices have their fade on/fade off mode called "Breathing", we can just set "Breathing" across all devices and end up with something that looks at least sort of uniform, if not synchronized in time.

# Common OpenRGB Modes

| Standardized Name | Description | Example GIF |
| ----------------- | ----------- | ----------- |
| Direct            | Direct mode is a mode that allows setting individual LEDs to static colors that does not fade or flicker upon color changes and does not save the updated colors to device memory.  Used for effect engine software to rapidly update the LEDs for PC software driven effects.  Some devices require a continuous packet stream to remain in direct mode, otherwise they revert to built-in effects. | |
| Custom            | Custom mode is a mode that allows setting individual LEDs to static colors, but does not meet the criteria for being a Direct mode.  This means it either flickers, fades, or saves to device memory.  Generally unsuitable for effect engine software. | |
| Static            | Static mode is a mode that sets the entire device or device zones, but not individual LEDs, to a static color.  This mode may fade or flicker and may save to device memory. | |
| Breathing         | Light gradually fades from fully off to fully on over some period of time and then gradually fades back to fully off. | |
| Flashing          | Light abruptly changes from fully off to fully on instantly, then instantly turns back off after a period of time. | |
| Spectrum Cycle    | Light gradually cycles through the entire color spectrum.  All lights on the device are the same color. | |
| Rainbow Wave      | Light gradually cycles through the entire color spectrum.  Lights are staggered as to produce a rainbow pattern that moves. | |
| Reactive          | Generally only available on input devices, this is a mode that lights one or more LEDs when an input (key, mouse button, etc) is pressed. | |
| Off               | All lights are disabled. | |
