/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * Provides the Java 2D classes for defining and performing operations on
 * objects related to two-dimensional geometry. Some important features of the
 * package include:
 * <ul>
 *     <li>classes for manipulating geometry, such as AffineTransform and the
 *     PathIterator interface which is implemented by all Shape objects.</li>
 *     <li>classes that implement the Shape interface, such as CubicCurve2D,
 *     Ellipse2D, Line2D, Rectangle2D, and GeneralShape.</li>
 *     <li>the Area class which provides mechanisms for add (union), subtract,
 *     intersect, and exclusiveOR operations on other Shape objects.</li>
 * </ul>
 *
 * @since 1.2
 */
package java.awt.geom;
