/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_DNSSETTINGDATA_H_
#define OPENDRIM_DNSSETTINGDATA_H_

#include <Instance.h>

const static char* OpenDRIM_DNSSettingData_classnames[] = {"OpenDRIM_DNSSettingData"};
static string OpenDRIM_DNSSettingData_NAMESPACE = _NAMESPACE;

class OpenDRIM_DNSSettingData {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	unsigned short AddressOrigin;
	bool AddressOrigin_isNULL;
	
	string DomainName;
	bool DomainName_isNULL;
	
	string RequestedHostname;
	bool RequestedHostname_isNULL;
	
	bool UseSuffixWhenRegistering;
	bool UseSuffixWhenRegistering_isNULL;
	
	bool RegisterThisConnectionsAddress;
	bool RegisterThisConnectionsAddress_isNULL;
	
	vector<string> DNSServerAddresses;
	bool DNSServerAddresses_isNULL;
	
	vector<unsigned short> DHCPOptionsToUse;
	bool DHCPOptionsToUse_isNULL;
	
	OpenDRIM_DNSSettingData() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		AddressOrigin_isNULL = true;
		DomainName_isNULL = true;
		RequestedHostname_isNULL = true;
		UseSuffixWhenRegistering_isNULL = true;
		RegisterThisConnectionsAddress_isNULL = true;
		DNSServerAddresses_isNULL = true;
		DHCPOptionsToUse_isNULL = true;
	}
	
	~OpenDRIM_DNSSettingData() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getAddressOrigin(unsigned short& value) const {
		if (AddressOrigin_isNULL==true)
			return NOT_FOUND;
		value = AddressOrigin;
		return OK;
	}
	
	int setAddressOrigin(const unsigned short& newValue) {
		AddressOrigin = newValue;
		AddressOrigin_isNULL = false;
		return OK;
	}

	int getDomainName(string& value) const {
		if (DomainName_isNULL==true)
			return NOT_FOUND;
		value = DomainName;
		return OK;
	}
	
	int setDomainName(const string& newValue) {
		DomainName = newValue;
		DomainName_isNULL = false;
		return OK;
	}

	int getRequestedHostname(string& value) const {
		if (RequestedHostname_isNULL==true)
			return NOT_FOUND;
		value = RequestedHostname;
		return OK;
	}
	
	int setRequestedHostname(const string& newValue) {
		RequestedHostname = newValue;
		RequestedHostname_isNULL = false;
		return OK;
	}

	int getUseSuffixWhenRegistering(bool& value) const {
		if (UseSuffixWhenRegistering_isNULL==true)
			return NOT_FOUND;
		value = UseSuffixWhenRegistering;
		return OK;
	}
	
	int setUseSuffixWhenRegistering(const bool& newValue) {
		UseSuffixWhenRegistering = newValue;
		UseSuffixWhenRegistering_isNULL = false;
		return OK;
	}

	int getRegisterThisConnectionsAddress(bool& value) const {
		if (RegisterThisConnectionsAddress_isNULL==true)
			return NOT_FOUND;
		value = RegisterThisConnectionsAddress;
		return OK;
	}
	
	int setRegisterThisConnectionsAddress(const bool& newValue) {
		RegisterThisConnectionsAddress = newValue;
		RegisterThisConnectionsAddress_isNULL = false;
		return OK;
	}

	int getDNSServerAddresses(vector<string>& value) const {
		if (DNSServerAddresses_isNULL==true)
			return NOT_FOUND;
		value = DNSServerAddresses;
		return OK;
	}
	
	int setDNSServerAddresses(const vector<string>& newValue) {
		DNSServerAddresses = newValue;
		DNSServerAddresses_isNULL = false;
		return OK;
	}

	int getDHCPOptionsToUse(vector<unsigned short>& value) const {
		if (DHCPOptionsToUse_isNULL==true)
			return NOT_FOUND;
		value = DHCPOptionsToUse;
		return OK;
	}
	
	int setDHCPOptionsToUse(const vector<unsigned short>& newValue) {
		DHCPOptionsToUse = newValue;
		DHCPOptionsToUse_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_DNSSETTINGDATA_H_*/
