// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BndLib_Add3dCurve_HeaderFile
#define _BndLib_Add3dCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Adaptor3d_Curve;
class Bnd_Box;


//! Computes the bounding box for a curve in 3d. <br>
//! Functions to add a 3D curve to a bounding box. <br>
//! The 3D curve is defined from a Geom curve. <br>
class BndLib_Add3dCurve  {
public:

  DEFINE_STANDARD_ALLOC

  //! Adds to the bounding box B the curve C <br>
//! B is then enlarged by the tolerance value Tol. <br>
//! Note: depending on the type of curve, one of the following <br>
//! representations of the curve C is used to include it in the bounding box B: <br>
//! -   an exact representation if C is built from a line, a circle   or a conic curve, <br>
//! -   the poles of the curve if C is built from a Bezier curve or   a BSpline curve, <br>
//!   if not, the points of an approximation of the curve C. <br>
//! Warning <br>
//! C is an adapted curve, that is, an object which is an interface between: <br>
//! -   the services provided by a 3D curve from the package   Geom <br>
//! -   and those required of the curve by the computation algorithm. <br>
//!  The adapted curve is created in the following way: <br>
//!    Handle(Geom_Curve) mycurve = ... ; <br>
//!    GeomAdaptor_Curve C(mycurve); <br>
//! The bounding box B is then enlarged by adding it: <br>
//!    Bnd_Box B; <br>
//! // ... <br>
//!    Standard_Real Tol = ... ; <br>
//!    Add3dCurve::Add ( C, Tol, B ); <br>
//! Exceptions <br>
//! Standard_Failure if the curve is built from: <br>
//! -   a Geom_Line, or <br>
//! -   a Geom_Parabola, or <br>
//! -   a Geom_Hyperbola, <br>
//! and P1 and P2 are either two negative infinite real <br>
//! numbers, or two positive infinite real numbers. <br>
  Standard_EXPORT   static  void Add(const Adaptor3d_Curve& C,const Standard_Real Tol,Bnd_Box& B) ;
  //! Adds to the bounding box B the curve C <br>
//! the arc of the curve C limited by the two parameter values P1 and P2. <br>
//! Note: depending on the type of curve, one of the following <br>
//! representations of the curve C is used to include it in the bounding box B: <br>
//! -   an exact representation if C is built from a line, a circle   or a conic curve, <br>
//! -   the poles of the curve if C is built from a Bezier curve or   a BSpline curve, <br>
//!   if not, the points of an approximation of the curve C. <br>
//! Warning <br>
//! C is an adapted curve, that is, an object which is an interface between: <br>
//! -   the services provided by a 3D curve from the package   Geom <br>
//! -   and those required of the curve by the computation algorithm. <br>
//!  The adapted curve is created in the following way: <br>
//!    Handle(Geom_Curve) mycurve = ... ; <br>
//!    GeomAdaptor_Curve C(mycurve); <br>
//! The bounding box B is then enlarged by adding it: <br>
//!    Bnd_Box B; <br>
//! // ... <br>
//!    Standard_Real Tol = ... ; <br>
//!    Add3dCurve::Add ( C, Tol, B ); <br>
//! Exceptions <br>
//! Standard_Failure if the curve is built from: <br>
//! -   a Geom_Line, or <br>
//! -   a Geom_Parabola, or <br>
//! -   a Geom_Hyperbola, <br>
//! and P1 and P2 are either two negative infinite real <br>
//! numbers, or two positive infinite real numbers. <br>
  Standard_EXPORT   static  void Add(const Adaptor3d_Curve& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real Tol,Bnd_Box& B) ;





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
