/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TorqueJDBCTransformTask
extends Task {
    protected Properties props;
    protected String xmlSchema;
    protected String dbUrl;
    protected String dbDriver;
    protected String dbUser;
    protected String dbPassword;
    protected DocumentImpl doc;
    protected Node database;
    protected Hashtable primaryKeys;
    protected Hashtable columnTableMap;
    protected Properties sqlTypes;
    XMLSerializer xmlSerializer;

    public void setDbUrl(String v) {
        this.dbUrl = v;
    }

    public void setDbDriver(String v) {
        this.dbDriver = v;
    }

    public void setDbUser(String v) {
        this.dbUser = v;
    }

    public void setDbPassword(String v) {
        this.dbPassword = v;
    }

    public void setOutputFile(String v) {
        this.xmlSchema = v;
    }

    public void execute() throws BuildException {
        this.props = new Properties();
        this.sqlTypes = new Properties();
        System.err.println("Torque - JDBCToXMLSchema starting\n");
        System.err.println("Your DB settings are:");
        System.err.println("driver : " + this.dbDriver);
        System.err.println("URL : " + this.dbUrl);
        System.err.println("user : " + this.dbUser);
        System.err.println("password : " + this.dbPassword);
        this.doc = new DocumentImpl();
        this.doc.appendChild(this.doc.createComment(" Autogenerated by JDBCToXMLSchema! "));
        try {
            this.generateXML();
            this.xmlSerializer = new XMLSerializer(new PrintWriter(new FileOutputStream(this.xmlSchema)), new OutputFormat("xml", null, true));
            this.xmlSerializer.serialize(this.doc);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        System.err.println("\nTorque - JDBCToXMLSchema finished");
    }

    public void generateXML() throws Exception {
        String curTable;
        Class.forName(this.dbDriver);
        System.err.println("DB driver sucessfuly instantiated");
        Connection con = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
        System.err.println("DB connection established");
        DatabaseMetaData dbMetaData = con.getMetaData();
        Vector tableList = this.getTableNames(dbMetaData);
        this.database = this.doc.createElement("database");
        this.columnTableMap = new Hashtable();
        int i = 0;
        while (i < tableList.size()) {
            curTable = (String)tableList.elementAt(i);
            Vector columns = this.getColumns(dbMetaData, curTable);
            int j = 0;
            while (j < columns.size()) {
                Vector v = (Vector)columns.elementAt(j);
                String name = (String)v.elementAt(0);
                this.columnTableMap.put(name, curTable);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < tableList.size()) {
            curTable = (String)tableList.elementAt(i);
            Element table = this.doc.createElement("table");
            table.setAttribute("name", curTable);
            Vector columns = this.getColumns(dbMetaData, curTable);
            List primKeys = this.getPrimaryKeys(dbMetaData, curTable);
            List forgnKeys = this.getForeignKeys(dbMetaData, curTable);
            this.primaryKeys = new Hashtable();
            int k = 0;
            while (k < primKeys.size()) {
                String curPrimaryKey = (String)primKeys.get(k);
                this.primaryKeys.put(curPrimaryKey, curPrimaryKey);
                ++k;
            }
            int l = 0;
            while (l < forgnKeys.size()) {
                String curForeignKey = (String)forgnKeys.get(l);
                String foreignKeyTable = (String)this.columnTableMap.get(curForeignKey);
                System.out.println(curForeignKey + " => " + foreignKeyTable);
                ++l;
            }
            int j = 0;
            while (j < columns.size()) {
                Vector v = (Vector)columns.get(j);
                String name = (String)v.elementAt(0);
                int type = (Integer)v.elementAt(1);
                int size = (Integer)v.elementAt(2);
                Integer nullType = (Integer)v.elementAt(3);
                Element column = this.doc.createElement("column");
                column.setAttribute("name", name);
                column.setAttribute("type", (String)((Hashtable)this.sqlTypes).get(new Integer(type).toString()));
                if (size > 0 && (type == 1 || type == 12 || type == -1)) {
                    column.setAttribute("size", new Integer(size).toString());
                }
                if (nullType == 0) {
                    column.setAttribute("null", "false");
                }
                if (this.primaryKeys.containsKey(name)) {
                    column.setAttribute("primaryKey", "true");
                }
                table.appendChild(column);
                ++j;
            }
            this.database.appendChild(table);
            ++i;
        }
        this.doc.appendChild(this.database);
    }

    public Vector getTableNames(DatabaseMetaData dbMeta) throws SQLException {
        ResultSet tableNames = dbMeta.getTables("", null, "%", null);
        Vector<String> tables = new Vector<String>();
        while (tableNames.next()) {
            String name = tableNames.getString(3);
            String type = tableNames.getString(4);
            if (!type.equals("TABLE")) continue;
            tables.addElement(name);
        }
        return tables;
    }

    public Vector getColumns(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        ResultSet columnSet = dbMeta.getColumns("", null, tableName, null);
        Vector columns = new Vector();
        while (columnSet.next()) {
            String name = columnSet.getString(4);
            Integer sqlType = new Integer(columnSet.getString(5));
            Integer size = new Integer(columnSet.getInt(7));
            Integer nullType = new Integer(columnSet.getInt(11));
            Vector<Object> v = new Vector<Object>();
            v.addElement(name);
            v.addElement(sqlType);
            v.addElement(size);
            v.addElement(nullType);
            columns.addElement(v);
        }
        return columns;
    }

    public List getPrimaryKeys(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        ResultSet parts = dbMeta.getPrimaryKeys("", null, tableName);
        Vector<String> pk = new Vector<String>();
        while (parts.next()) {
            pk.add(parts.getString(4));
        }
        return pk;
    }

    public List getForeignKeys(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        ResultSet foreignKeys = dbMeta.getImportedKeys("", null, tableName);
        Vector<String> keys = new Vector<String>();
        while (foreignKeys.next()) {
            keys.add(foreignKeys.getString(8));
        }
        return keys;
    }
}

