/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.util;

import com.sourceforge.knecs.notification.util.TopicConnectionSingleton;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.TopicSession;

public class TopicSessionSingleton
implements ExceptionListener {
    private static TopicSessionSingleton mInstance = null;
    private TopicSession mSession = null;

    protected TopicSessionSingleton(String mode) throws JMSException {
        if (mInstance == null) {
            TopicConnectionSingleton tcs = TopicConnectionSingleton.getInstance(mode);
            this.mSession = tcs.mConnection.createTopicSession(false, 1);
        }
    }

    public void onException(JMSException ex) {
        mInstance = null;
    }

    public static TopicSessionSingleton getInstance(String mode) {
        if (mInstance == null) {
            try {
                mInstance = new TopicSessionSingleton(mode);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return mInstance;
    }

    public TopicSession getSession() {
        return this.mSession;
    }
}

