C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_vwn2.F 
C> The nwxcm_c_vwn2 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_vwn2 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& \left({\it t_{13}}\,{\it t_{14}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{14}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{16}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_4}+1.06835}}\right)\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left| 0.8414573716781907\,{\it t_3}
C>    +{\it t_8}+11.4813\right| }}\\\\ 
C>   {\it t_{18}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.228344\right)^2\,{\it t_{17}}\right)\\\\ 
C>   {\it t_{19}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{17}}\right)\\\\ 
C>   {\it t_{20}} &=& \arctan \left({{0.0448998886415768}\over{{
C>    \it t_4}+13.072}}\right)\\\\ 
C>   {\it t_{21}} &=& \arctan \left({{1.171685277708971}\over{{
C>    \it t_4}+20.1231}}\right)\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\left| 10.29581201158544\,{\it t_3}
C>    +{\it t_8}+42.7198\right| }}\\\\ 
C>   {\it t_{23}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.409286\right)^2\,{\it t_{22}}\right)\\\\ 
C>   {\it t_{24}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{22}}\right)\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\left| 15.84942278842832\,{\it t_3}
C>    +{\it t_8}+101.578\right| }}\\\\ 
C>   {\it t_{26}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.743294\right)^2\,{\it t_{25}}\right)\\\\ 
C>   {\it t_{27}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{29}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\sqrt{{\it t_{29}}}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{29}}}}\\\\ 
C>   {\it t_{32}} &=& 0.6203504908994001\,{\it t_{31}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\left| {\it t_{32}}
C>    +2.935818660072219\,{\it t_{30}}+12.9352\right| }}\\\\ 
C>   {\it t_{34}} &=& \left| {\it t_{31}}\right| \\\\ 
C>   {\it t_{35}} &=& \log \left(0.6203504908994001\,{\it t_{33}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{36}} &=& 0.7876233178997433\,{\it t_{30}}\\\\ 
C>   {\it t_{37}} &=& \log \left(1.0\,{\it t_{33}}\,\left({\it t_{36}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{38}} &=& 1.575246635799487\,{\it t_{30}}\\\\ 
C>   {\it t_{39}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{38}}+3.72744}}\right)\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\left| {\it t_{32}}
C>    +0.8414573716781907\,{\it t_{30}}+11.4813\right| }}\\\\ 
C>   {\it t_{41}} &=& \log \left(0.6203504908994001\,{\it t_{40}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{42}} &=& \log \left(1.0\,{\it t_{40}}\,\left({\it t_{36}}
C>    +0.228344\right)^2\right)\\\\ 
C>   {\it t_{43}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_{38}}+1.06835}}\right)\\\\ 
C>   {\it t_{44}} &=& {{1}\over{\left| {\it t_{32}}
C>    +10.29581201158544\,{\it t_{30}}+42.7198\right| }}\\\\ 
C>   {\it t_{45}} &=& \log \left(0.6203504908994001\,{\it t_{44}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{46}} &=& {{1}\over{\left| {\it t_{32}}
C>    +15.84942278842832\,{\it t_{30}}+101.578\right| }}\\\\ 
C>   {\it t_{47}} &=& \log \left(0.6203504908994001\,{\it t_{46}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{48}} &=& \log \left(1.0\,{\it t_{44}}\,\left({\it t_{36}}
C>    +0.409286\right)^2\right)\\\\ 
C>   {\it t_{49}} &=& \log \left(1.0\,{\it t_{46}}\,\left({\it t_{36}}
C>    +0.743294\right)^2\right)\\\\ 
C>   {\it t_{50}} &=& \arctan \left({{0.0448998886415768}\over{{
C>    \it t_{38}}+13.072}}\right)\\\\ 
C>   {\it t_{51}} &=& \arctan \left({{1.171685277708971}\over{{
C>    \it t_{38}}+20.1231}}\right)\\\\ 
C>   {\it t_{52}} &=& {{1}\over{\left| {\it t_{32}}
C>    +5.560951426165705\,{\it t_{30}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.923661050931536\,{\it t_{15}}
C>    \,\left(-0.01554535\,{\it t_{27}}-0.002667310007273315\,{
C>    \it t_{26}}+0.0310907\,{\it t_{24}}+0.004431373767749538\,{
C>    \it t_{23}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{28}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{28}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    -0.6188180297906176\,{\it t_{21}}+20.52197293770518\,{
C>    \it t_{20}}+0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_4}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_5}\right)+1.125\,{\it t_{15}}
C>    \,\left({{{\it t_{13}}^4\,\left(1.709920934161365\,
C>    \left(0.01554535\,{\it t_{27}}+0.002667310007273315\,{
C>    \it t_{26}}-0.0310907\,{\it t_{24}}-0.004431373767749538\,{
C>    \it t_{23}}+0.6188180297906176\,{\it t_{21}}-20.52197293770518
C>    \,{\it t_{20}}\right)+0.01688686394038963\,{\it t_{19}}
C>    +3.649033517917767 \times 10^{-4}\,{\it t_{18}}
C>    +0.005458482358638966\,{\it t_{16}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{19}}-3.649033517917767 \times 10^{
C>    -4}\,{\it t_{18}}-0.005458482358638966\,{\it t_{16}}\right)
C>    +0.0310907\,{\it t_{12}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.999999999999999\,\left(-0.6188180297906176
C>    \,{\it t_{51}}+20.52197293770518\,{\it t_{50}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_{38}}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_{39}}-0.002667310007273315\,{\it t_{49}}
C>    +0.004431373767749538\,{\it t_{48}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{52}}\,\left({\it t_{36}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{37}}-0.01554535\,{\it t_{47}}+0.0310907\,{\it t_{45}}
C>    +0.01554535\,\log \left(0.6203504908994001\,{\it t_{52}}\,{
C>    \it t_{34}}\right)-0.0310907\,{\it t_{35}}\right)
C>    +0.5848223622634643\,\left(1.0\,\left(1.709920934161365
C>    \,\left(0.6188180297906176\,{\it t_{51}}-20.52197293770518
C>    \,{\it t_{50}}+0.002667310007273315\,{\it t_{49}}
C>    -0.004431373767749538\,{\it t_{48}}+0.01554535\,{\it t_{47}}
C>    -0.0310907\,{\it t_{45}}\right)+0.005458482358638966\,{
C>    \it t_{43}}+3.649033517917767 \times 10^{-4}\,{\it t_{42}}
C>    +0.01688686394038963\,{\it t_{41}}\right)-0.005458482358638966
C>    \,{\it t_{43}}-3.649033517917767 \times 10^{-4}\,{\it t_{42}}
C>    -0.01688686394038963\,{\it t_{41}}\right)+0.03878329487811301
C>    \,{\it t_{39}}+9.690227711544375 \times 10^{-4}\,{\it t_{37}}
C>    +0.0310907\,{\it t_{35}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="https://doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn2(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = 7.016926042943222d-1*t3+1.0498d-1
            t12 = t11**2
            t13 = 1.4033852085886445d+0*t3+3.72744d+0
            t14 = 1/t7
            t15 = 1/t2**3
            t16 = 1/rhoa**6.666666666666667d-1
            t17 = -2.1795975674590234d-1*t15*t16-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t18 = 1/t8
            t19 = 1/t13**2
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*(6.314467057030004d-2*t14*(-4.9
     1         237251092134837d-1*t10*t17*t18*t7-8.206208515355806d-2*t1
     2         0*t14/rhoa**1.6666666666666666d+0)*t9+9.690227711544375d-
     3         4*(-1.0d+0*t10*t12*t17*t18-1.1694876738238703d-1*t10*t11*
     4         t15*t16)*t9/t12+2.790332964441521d-2*t15*t16*t19/(3.78469
     5         9104639999d+1*t19+1))*wght+1.0d+0*(3.10907d-2*log(4.92372
     6         51092134837d-1*t10*t7)+3.8783294878113006d-2*atan(6.15199
     7         081975908d+0/t13)+9.690227711544375d-4*log(1.0d+0*t10*t12
     8         ))*wght+Amat(iq,D1_RA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+1.0683499999999999d+0
            t25 = atan(6.692072046645942d+0/t24)
            t26 = t8+2.28344d-1
            t27 = t26**2
            t28 = 8.414573716781907d-1*t4+t12+1.14813d+1
            t29 = abs(t28)
            t30 = 1/t29
            t31 = log(1.0d+0*t27*t30)
            t32 = log(6.203504908994001d-1*t17*t30)
            t33 = t19**4
            t34 = 1/t1**4
            t35 = t5+1.3072d+1
            t36 = atan(4.4899888641576796d-2/t35)
            t37 = t5+2.0123100000000002d+1
            t38 = atan(1.171685277708971d+0/t37)
            t39 = t8+4.09286d-1
            t40 = t39**2
            t41 = 1.0295812011585444d+1*t4+t12+4.2719799999999997d+1
            t42 = abs(t41)
            t43 = 1/t42
            t44 = log(1.0d+0*t40*t43)
            t45 = log(6.203504908994001d-1*t17*t43)
            t46 = t8+7.43294d-1
            t47 = t46**2
            t48 = 1.5849422788428325d+1*t4+t12+1.01578d+2
            t49 = abs(t48)
            t50 = 1/t49
            t51 = log(1.0d+0*t47*t50)
            t52 = log(6.203504908994001d-1*t17*t50)
            t53 = 1.709920934161365d+0*(1.554535d-2*t52+2.66731000727331
     1         5d-3*t51-3.10907d-2*t45-4.431373767749538d-3*t44+6.188180
     2         297906176d-1*t38-2.052197293770518d+1*t36)+1.688686394038
     3         963d-2*t32+3.6490335179177674d-4*t31+5.458482358638966d-3
     4         *t25
            t54 = t33*t34*t53-1.688686394038963d-2*t32-3.649033517917767
     1         4d-4*t31-5.458482358638966d-3*t25
            t55 = t5+7.06042d+0
            t56 = t8+3.25d-1
            t57 = t56**2
            t58 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t59 = abs(t58)
            t60 = 1/t59
            t61 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t57*t60)+1.554535d-2*log(6.203504908994001d-1*t17*t6
     2         0)+5.249139316978092d-2*atan(4.7309269095601136d+0/t55)-1
     3         .554535d-2*t52-2.667310007273315d-3*t51+3.10907d-2*t45+4.
     4         431373767749538d-3*t44-6.188180297906176d-1*t38+2.0521972
     5         93770518d+1*t36-3.10907d-2*t18-9.690227711544375d-4*t16
            t62 = 3.8783294878113006d-2*t7+1.923661050931536d+0*t23*t61+
     1         1.1250000000000002d+0*t23*t54+3.10907d-2*t18+9.6902277115
     2         44375d-4*t16
            t63 = 1/t1**6.666666666666667d-1
            t64 = 1/t3**3
            t65 = 1/t6**2
            t66 = 1/(3.784699104639999d+1*t65+1)
            t67 = 6.264085709464389d-2*t63*t64*t65*t66
            t68 = 1/t10
            t69 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t70 = t69-4.8930311001203647d-1*t63*t64
            t71 = 1/t13
            t72 = -2.625411059665811d-1*t15*t63*t64*t9-1.0d+0*t10*t15*t7
     1         0*t71
            t73 = 9.690227711544375d-4*t14*t68*t72
            t74 = 1/t17
            t75 = 1/t1**1.6666666666666666d+0
            t76 = -2.067834969664667d-1*t15*t74*t75-6.203504908994001d-1
     1         *t15*t17*t70*t71
            t77 = 5.011795824473985d-2*t14*t74*t76
            t78 = 1/t55**2
            t79 = 1/t35**2
            t80 = 1/(2.016000000025997d-3*t79+1)
            t81 = 1/t37**2
            t82 = 1/(1.3728463899999485d+0*t81+1)
            t83 = t69-9.26825237694284d-1*t63*t64
            t84 = 1/t58
            t85 = 1/t40
            t86 = t69-1.715968668597574d+0*t63*t64
            t87 = 1/t41
            t88 = -1.0d+0*t40*t43*t86*t87-2.625411059665811d-1*t39*t43*t
     1         63*t64
            t89 = -6.203504908994001d-1*t17*t43*t86*t87-2.06783496966466
     1         7d-1*t43*t74*t75
            t90 = 1/t47
            t91 = t69-2.641570464738054d+0*t63*t64
            t92 = 1/t48
            t93 = -1.0d+0*t47*t50*t91*t92-2.625411059665811d-1*t46*t50*t
     1         63*t64
            t94 = -6.203504908994001d-1*t17*t50*t91*t92-2.06783496966466
     1         7d-1*t50*t74*t75
            t95 = 1.923661050931536d+0*t23*(-2.5058979122369923d-2*t49*t
     1         74*t94-2.667310007273315d-3*t49*t90*t93+5.011795824473985
     2         d-2*t42*t74*t89+4.431373767749538d-3*t42*t85*t88+2.247867
     3         0955426108d-3*t59*(-1.0d+0*t57*t60*t83*t84-2.625411059665
     4         811d-1*t56*t60*t63*t64)/t57+2.5058979122369923d-2*t59*t74
     5         *(-6.203504908994001d-1*t17*t60*t83*t84-2.067834969664667
     6         d-1*t60*t74*t75)-1.9035804775132142d-1*t63*t64*t81*t82+2.
     7         4191438009473537d-1*t63*t64*t79*t80+6.519760588836059d-2*
     8         t63*t64*t78/(2.238166942360001d+1*t78+1)-5.01179582447398
     9         5d-2*t14*t74*t76-9.690227711544375d-4*t14*t68*t72-6.26408
     :         5709464389d-2*t63*t64*t65*t66)
            t96 = 1/t24**2
            t97 = 1/(4.4783828277500004d+1*t96+1)
            t98 = -9.590247809108334d-3*t63*t64*t96*t97
            t99 = 1/t27
            t100 = t69-1.4024289527969844d-1*t63*t64
            t101 = 1/t28
            t102 = -2.625411059665811d-1*t26*t30*t63*t64-1.0d+0*t100*t10
     1         1*t27*t30
            t103 = -3.6490335179177674d-4*t102*t29*t99
            t104 = -2.067834969664667d-1*t30*t74*t75-6.203504908994001d-
     1         1*t100*t101*t17*t30
            t105 = -2.722148880047894d-2*t104*t29*t74
            t106 = t33*t34*(3.6490335179177674d-4*t102*t29*t99+9.5902478
     1         09108334d-3*t63*t64*t96*t97+1.709920934161365d+0*(2.50589
     2         79122369923d-2*t49*t74*t94+2.667310007273315d-3*t49*t90*t
     3         93-5.011795824473985d-2*t42*t74*t89-4.431373767749538d-3*
     4         t42*t85*t88+1.9035804775132142d-1*t63*t64*t81*t82-2.41914
     5         38009473537d-1*t63*t64*t79*t80)+2.722148880047894d-2*t104
     6         *t29*t74)
            t107 = -4*t33*t53/t1**5
            t108 = t19**3
            t109 = 1/t1**2
            t110 = t109*t19
            t111 = -t20
            t112 = t21**3.333333333333333d-1
            t113 = -t109*t19
            t114 = t22**3.333333333333333d-1
            t115 = 1.3333333333333333d+0*t114*(t20+t113)+1.3333333333333
     1         333d+0*(t111+t110)*t112
            t116 = 1.0d+0*t62*wght
            t117 = 1.3333333333333333d+0*t112*(t20+t110)+1.3333333333333
     1         333d+0*(t113+t111)*t114
            fnc(iq) = 1.0d+0*t1*t62*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*(1.1250000000000002d+0*t23*(t98+4
     1         *t108*t34*t53+t107+t106+t105+t103)+t95+t77+t73+t67+1.9236
     2         61050931536d+0*t115*t61+1.1250000000000002d+0*t115*t54)*w
     3         ght+t116+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*(1.1250000000000002d+0*t23*(t98-4
     1         *t108*t34*t53+t107+t106+t105+t103)+t95+t77+t73+t67+1.9236
     2         61050931536d+0*t117*t61+1.1250000000000002d+0*t117*t54)*w
     3         ght+t116+Amat(iq,D1_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.414573716781907d-1*t3+1.14813d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+2.28344d-1
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.0683499999999999d+0
            t26 = atan(6.692072046645942d+0/t25)
            t27 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = log(6.203504908994001d-1*t29*t9)
            t31 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t32 = abs(t31)
            t33 = 1/t32
            t34 = log(6.203504908994001d-1*t33*t9)
            t35 = t11+4.09286d-1
            t36 = t35**2
            t37 = log(1.0d+0*t29*t36)
            t38 = t11+7.43294d-1
            t39 = t38**2
            t40 = log(1.0d+0*t33*t39)
            t41 = t15+1.3072d+1
            t42 = atan(4.4899888641576796d-2/t41)
            t43 = t15+2.0123100000000002d+1
            t44 = atan(1.171685277708971d+0/t43)
            t45 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t46 = abs(t45)
            t47 = 1/t46
            t48 = t11+3.25d-1
            t49 = t48**2
            t50 = t15+7.06042d+0
            t51 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t47*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t50)+2.2478670955426108d-3*log(1.0d+0*t47*t49)-6.18818
     3         0297906176d-1*t44+2.052197293770518d+1*t42-2.667310007273
     4         315d-3*t40+4.431373767749538d-3*t37-1.554535d-2*t34+3.109
     5         07d-2*t30-3.8783294878113006d-2*t17-9.690227711544375d-4*
     6         t14-3.10907d-2*t10)+5.848223622634643d-1*(1.0d+0*(1.70992
     7         0934161365d+0*(6.188180297906176d-1*t44-2.052197293770518
     8         d+1*t42+2.667310007273315d-3*t40-4.431373767749538d-3*t37
     9         +1.554535d-2*t34-3.10907d-2*t30)+5.458482358638966d-3*t26
     :         +3.6490335179177674d-4*t24+1.688686394038963d-2*t21)-5.45
     ;         8482358638966d-3*t26-3.6490335179177674d-4*t24-1.68868639
     <         4038963d-2*t21)+3.8783294878113006d-2*t17+9.6902277115443
     =         75d-4*t14+3.10907d-2*t10
            t52 = 1/t9
            t53 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t54 = 1/t2**3
            t55 = 1/rhoa**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t6
            t58 = 1/rhoa**1.6666666666666666d+0
            t59 = -6.203504908994001d-1*t56*t57*t8*t9-2.067834969664667d
     1         -1*t52*t58*t8
            t60 = 1/t16**2
            t61 = 1/(3.784699104639999d+1*t60+1)
            t62 = 1/t13
            t63 = -1.0d+0*t13*t56*t57*t8-2.625411059665811d-1*t12*t54*t5
     1         5*t8
            t64 = t53-9.26825237694284d-1*t54*t55
            t65 = 1/t45
            t66 = t53-1.715968668597574d+0*t54*t55
            t67 = 1/t27
            t68 = -6.203504908994001d-1*t29*t66*t67*t9-2.067834969664667
     1         d-1*t29*t52*t58
            t69 = t53-2.641570464738054d+0*t54*t55
            t70 = 1/t31
            t71 = -6.203504908994001d-1*t33*t69*t70*t9-2.067834969664667
     1         d-1*t33*t52*t58
            t72 = 1/t50**2
            t73 = 1/t41**2
            t74 = 1/(2.016000000025997d-3*t73+1)
            t75 = 1/t43**2
            t76 = 1/(1.3728463899999485d+0*t75+1)
            t77 = 1/t36
            t78 = -1.0d+0*t29*t36*t66*t67-2.625411059665811d-1*t29*t35*t
     1         54*t55
            t79 = 1/t39
            t80 = -1.0d+0*t33*t39*t69*t70-2.625411059665811d-1*t33*t38*t
     1         54*t55
            t81 = t53-1.4024289527969844d-1*t54*t55
            t82 = 1/t18
            t83 = -6.203504908994001d-1*t20*t81*t82*t9-2.067834969664667
     1         d-1*t20*t52*t58
            t84 = 1/t25**2
            t85 = 1/(4.4783828277500004d+1*t84+1)
            t86 = 1/t23
            t87 = -1.0d+0*t20*t23*t81*t82-2.625411059665811d-1*t20*t22*t
     1         54*t55
            fnc(iq) = 1.0d+0*rhoa*t51*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*(9.99999999999999d-1*(2.5058979
     1         122369923d-2*t46*t52*(-6.203504908994001d-1*t47*t64*t65*t
     2         9-2.067834969664667d-1*t47*t52*t58)-2.667310007273315d-3*
     3         t32*t79*t80+4.431373767749538d-3*t28*t77*t78-1.9035804775
     4         132142d-1*t54*t55*t75*t76+2.4191438009473537d-1*t54*t55*t
     5         73*t74+6.519760588836059d-2*t54*t55*t72/(2.23816694236000
     6         1d+1*t72+1)-2.5058979122369923d-2*t32*t52*t71-9.690227711
     7         544375d-4*t62*t63*t7-5.011795824473985d-2*t52*t59*t7+5.01
     8         1795824473985d-2*t28*t52*t68+2.2478670955426108d-3*t46*(-
     9         1.0d+0*t47*t49*t64*t65-2.625411059665811d-1*t47*t48*t54*t
     :         55)/t49-6.264085709464389d-2*t54*t55*t60*t61)+5.848223622
     ;         634643d-1*(1.0d+0*(3.6490335179177674d-4*t19*t86*t87+9.59
     <         0247809108334d-3*t54*t55*t84*t85+2.722148880047894d-2*t19
     =         *t52*t83+1.709920934161365d+0*(2.667310007273315d-3*t32*t
     >         79*t80-4.431373767749538d-3*t28*t77*t78+1.903580477513214
     ?         2d-1*t54*t55*t75*t76-2.4191438009473537d-1*t54*t55*t73*t7
     @         4+2.5058979122369923d-2*t32*t52*t71-5.011795824473985d-2*
     1         t28*t52*t68))-3.6490335179177674d-4*t19*t86*t87-9.5902478
     2         09108334d-3*t54*t55*t84*t85-2.722148880047894d-2*t19*t52*
     3         t83)+9.690227711544375d-4*t62*t63*t7+5.011795824473985d-2
     4         *t52*t59*t7+6.264085709464389d-2*t54*t55*t60*t61)*wght+1.
     5         0d+0*t51*wght+Amat(iq,D1_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.414573716781907d-1*t3+1.14813d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+2.28344d-1
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.0683499999999999d+0
            t26 = atan(6.692072046645942d+0/t25)
            t27 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = log(6.203504908994001d-1*t29*t9)
            t31 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t32 = abs(t31)
            t33 = 1/t32
            t34 = log(6.203504908994001d-1*t33*t9)
            t35 = t11+4.09286d-1
            t36 = t35**2
            t37 = log(1.0d+0*t29*t36)
            t38 = t11+7.43294d-1
            t39 = t38**2
            t40 = log(1.0d+0*t33*t39)
            t41 = t15+1.3072d+1
            t42 = atan(4.4899888641576796d-2/t41)
            t43 = t15+2.0123100000000002d+1
            t44 = atan(1.171685277708971d+0/t43)
            t45 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t46 = abs(t45)
            t47 = 1/t46
            t48 = t11+3.25d-1
            t49 = t48**2
            t50 = t15+7.06042d+0
            t51 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t47*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t50)+2.2478670955426108d-3*log(1.0d+0*t47*t49)-6.18818
     3         0297906176d-1*t44+2.052197293770518d+1*t42-2.667310007273
     4         315d-3*t40+4.431373767749538d-3*t37-1.554535d-2*t34+3.109
     5         07d-2*t30-3.8783294878113006d-2*t17-9.690227711544375d-4*
     6         t14-3.10907d-2*t10)+5.848223622634643d-1*(1.0d+0*(1.70992
     7         0934161365d+0*(6.188180297906176d-1*t44-2.052197293770518
     8         d+1*t42+2.667310007273315d-3*t40-4.431373767749538d-3*t37
     9         +1.554535d-2*t34-3.10907d-2*t30)+5.458482358638966d-3*t26
     :         +3.6490335179177674d-4*t24+1.688686394038963d-2*t21)-5.45
     ;         8482358638966d-3*t26-3.6490335179177674d-4*t24-1.68868639
     <         4038963d-2*t21)+3.8783294878113006d-2*t17+9.6902277115443
     =         75d-4*t14+3.10907d-2*t10
            t52 = 1/t9
            t53 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t54 = 1/t2**3
            t55 = 1/rhob**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t6
            t58 = 1/rhob**1.6666666666666666d+0
            t59 = -6.203504908994001d-1*t56*t57*t8*t9-2.067834969664667d
     1         -1*t52*t58*t8
            t60 = 1/t16**2
            t61 = 1/(3.784699104639999d+1*t60+1)
            t62 = 1/t13
            t63 = -1.0d+0*t13*t56*t57*t8-2.625411059665811d-1*t12*t54*t5
     1         5*t8
            t64 = t53-9.26825237694284d-1*t54*t55
            t65 = 1/t45
            t66 = t53-1.715968668597574d+0*t54*t55
            t67 = 1/t27
            t68 = -6.203504908994001d-1*t29*t66*t67*t9-2.067834969664667
     1         d-1*t29*t52*t58
            t69 = t53-2.641570464738054d+0*t54*t55
            t70 = 1/t31
            t71 = -6.203504908994001d-1*t33*t69*t70*t9-2.067834969664667
     1         d-1*t33*t52*t58
            t72 = 1/t50**2
            t73 = 1/t41**2
            t74 = 1/(2.016000000025997d-3*t73+1)
            t75 = 1/t43**2
            t76 = 1/(1.3728463899999485d+0*t75+1)
            t77 = 1/t36
            t78 = -1.0d+0*t29*t36*t66*t67-2.625411059665811d-1*t29*t35*t
     1         54*t55
            t79 = 1/t39
            t80 = -1.0d+0*t33*t39*t69*t70-2.625411059665811d-1*t33*t38*t
     1         54*t55
            t81 = t53-1.4024289527969844d-1*t54*t55
            t82 = 1/t18
            t83 = -6.203504908994001d-1*t20*t81*t82*t9-2.067834969664667
     1         d-1*t20*t52*t58
            t84 = 1/t25**2
            t85 = 1/(4.4783828277500004d+1*t84+1)
            t86 = 1/t23
            t87 = -1.0d+0*t20*t23*t81*t82-2.625411059665811d-1*t20*t22*t
     1         54*t55
            fnc(iq) = 1.0d+0*rhob*t51*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*(9.99999999999999d-1*(2.5058979
     1         122369923d-2*t46*t52*(-6.203504908994001d-1*t47*t64*t65*t
     2         9-2.067834969664667d-1*t47*t52*t58)-2.667310007273315d-3*
     3         t32*t79*t80+4.431373767749538d-3*t28*t77*t78-1.9035804775
     4         132142d-1*t54*t55*t75*t76+2.4191438009473537d-1*t54*t55*t
     5         73*t74+6.519760588836059d-2*t54*t55*t72/(2.23816694236000
     6         1d+1*t72+1)-2.5058979122369923d-2*t32*t52*t71-9.690227711
     7         544375d-4*t62*t63*t7-5.011795824473985d-2*t52*t59*t7+5.01
     8         1795824473985d-2*t28*t52*t68+2.2478670955426108d-3*t46*(-
     9         1.0d+0*t47*t49*t64*t65-2.625411059665811d-1*t47*t48*t54*t
     :         55)/t49-6.264085709464389d-2*t54*t55*t60*t61)+5.848223622
     ;         634643d-1*(1.0d+0*(3.6490335179177674d-4*t19*t86*t87+9.59
     <         0247809108334d-3*t54*t55*t84*t85+2.722148880047894d-2*t19
     =         *t52*t83+1.709920934161365d+0*(2.667310007273315d-3*t32*t
     >         79*t80-4.431373767749538d-3*t28*t77*t78+1.903580477513214
     ?         2d-1*t54*t55*t75*t76-2.4191438009473537d-1*t54*t55*t73*t7
     @         4+2.5058979122369923d-2*t32*t52*t71-5.011795824473985d-2*
     1         t28*t52*t68))-3.6490335179177674d-4*t19*t86*t87-9.5902478
     2         09108334d-3*t54*t55*t84*t85-2.722148880047894d-2*t19*t52*
     3         t83)+9.690227711544375d-4*t62*t63*t7+5.011795824473985d-2
     4         *t52*t59*t7+6.264085709464389d-2*t54*t55*t60*t61)*wght+1.
     5         0d+0*t51*wght+Amat(iq,D1_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vwn2 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& \left({\it t_{13}}\,{\it t_{14}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{14}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{16}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_4}+1.06835}}\right)\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left| 0.8414573716781907\,{\it t_3}
C>    +{\it t_8}+11.4813\right| }}\\\\ 
C>   {\it t_{18}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.228344\right)^2\,{\it t_{17}}\right)\\\\ 
C>   {\it t_{19}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{17}}\right)\\\\ 
C>   {\it t_{20}} &=& \arctan \left({{0.0448998886415768}\over{{
C>    \it t_4}+13.072}}\right)\\\\ 
C>   {\it t_{21}} &=& \arctan \left({{1.171685277708971}\over{{
C>    \it t_4}+20.1231}}\right)\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\left| 10.29581201158544\,{\it t_3}
C>    +{\it t_8}+42.7198\right| }}\\\\ 
C>   {\it t_{23}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.409286\right)^2\,{\it t_{22}}\right)\\\\ 
C>   {\it t_{24}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{22}}\right)\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\left| 15.84942278842832\,{\it t_3}
C>    +{\it t_8}+101.578\right| }}\\\\ 
C>   {\it t_{26}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.743294\right)^2\,{\it t_{25}}\right)\\\\ 
C>   {\it t_{27}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{29}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\sqrt{{\it t_{29}}}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{29}}}}\\\\ 
C>   {\it t_{32}} &=& 0.6203504908994001\,{\it t_{31}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\left| {\it t_{32}}
C>    +2.935818660072219\,{\it t_{30}}+12.9352\right| }}\\\\ 
C>   {\it t_{34}} &=& \left| {\it t_{31}}\right| \\\\ 
C>   {\it t_{35}} &=& \log \left(0.6203504908994001\,{\it t_{33}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{36}} &=& 0.7876233178997433\,{\it t_{30}}\\\\ 
C>   {\it t_{37}} &=& \log \left(1.0\,{\it t_{33}}\,\left({\it t_{36}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{38}} &=& 1.575246635799487\,{\it t_{30}}\\\\ 
C>   {\it t_{39}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{38}}+3.72744}}\right)\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\left| {\it t_{32}}
C>    +0.8414573716781907\,{\it t_{30}}+11.4813\right| }}\\\\ 
C>   {\it t_{41}} &=& \log \left(0.6203504908994001\,{\it t_{40}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{42}} &=& \log \left(1.0\,{\it t_{40}}\,\left({\it t_{36}}
C>    +0.228344\right)^2\right)\\\\ 
C>   {\it t_{43}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_{38}}+1.06835}}\right)\\\\ 
C>   {\it t_{44}} &=& {{1}\over{\left| {\it t_{32}}
C>    +10.29581201158544\,{\it t_{30}}+42.7198\right| }}\\\\ 
C>   {\it t_{45}} &=& \log \left(0.6203504908994001\,{\it t_{44}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{46}} &=& {{1}\over{\left| {\it t_{32}}
C>    +15.84942278842832\,{\it t_{30}}+101.578\right| }}\\\\ 
C>   {\it t_{47}} &=& \log \left(0.6203504908994001\,{\it t_{46}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{48}} &=& \log \left(1.0\,{\it t_{44}}\,\left({\it t_{36}}
C>    +0.409286\right)^2\right)\\\\ 
C>   {\it t_{49}} &=& \log \left(1.0\,{\it t_{46}}\,\left({\it t_{36}}
C>    +0.743294\right)^2\right)\\\\ 
C>   {\it t_{50}} &=& \arctan \left({{0.0448998886415768}\over{{
C>    \it t_{38}}+13.072}}\right)\\\\ 
C>   {\it t_{51}} &=& \arctan \left({{1.171685277708971}\over{{
C>    \it t_{38}}+20.1231}}\right)\\\\ 
C>   {\it t_{52}} &=& {{1}\over{\left| {\it t_{32}}
C>    +5.560951426165705\,{\it t_{30}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.923661050931536\,{\it t_{15}}
C>    \,\left(-0.01554535\,{\it t_{27}}-0.002667310007273315\,{
C>    \it t_{26}}+0.0310907\,{\it t_{24}}+0.004431373767749538\,{
C>    \it t_{23}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{28}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{28}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    -0.6188180297906176\,{\it t_{21}}+20.52197293770518\,{
C>    \it t_{20}}+0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_4}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_5}\right)+1.125\,{\it t_{15}}
C>    \,\left({{{\it t_{13}}^4\,\left(1.709920934161365\,
C>    \left(0.01554535\,{\it t_{27}}+0.002667310007273315\,{
C>    \it t_{26}}-0.0310907\,{\it t_{24}}-0.004431373767749538\,{
C>    \it t_{23}}+0.6188180297906176\,{\it t_{21}}-20.52197293770518
C>    \,{\it t_{20}}\right)+0.01688686394038963\,{\it t_{19}}
C>    +3.649033517917767 \times 10^{-4}\,{\it t_{18}}
C>    +0.005458482358638966\,{\it t_{16}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{19}}-3.649033517917767 \times 10^{
C>    -4}\,{\it t_{18}}-0.005458482358638966\,{\it t_{16}}\right)
C>    +0.0310907\,{\it t_{12}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.999999999999999\,\left(-0.6188180297906176
C>    \,{\it t_{51}}+20.52197293770518\,{\it t_{50}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_{38}}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_{39}}-0.002667310007273315\,{\it t_{49}}
C>    +0.004431373767749538\,{\it t_{48}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{52}}\,\left({\it t_{36}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{37}}-0.01554535\,{\it t_{47}}+0.0310907\,{\it t_{45}}
C>    +0.01554535\,\log \left(0.6203504908994001\,{\it t_{52}}\,{
C>    \it t_{34}}\right)-0.0310907\,{\it t_{35}}\right)
C>    +0.5848223622634643\,\left(1.0\,\left(1.709920934161365
C>    \,\left(0.6188180297906176\,{\it t_{51}}-20.52197293770518
C>    \,{\it t_{50}}+0.002667310007273315\,{\it t_{49}}
C>    -0.004431373767749538\,{\it t_{48}}+0.01554535\,{\it t_{47}}
C>    -0.0310907\,{\it t_{45}}\right)+0.005458482358638966\,{
C>    \it t_{43}}+3.649033517917767 \times 10^{-4}\,{\it t_{42}}
C>    +0.01688686394038963\,{\it t_{41}}\right)-0.005458482358638966
C>    \,{\it t_{43}}-3.649033517917767 \times 10^{-4}\,{\it t_{42}}
C>    -0.01688686394038963\,{\it t_{41}}\right)+0.03878329487811301
C>    \,{\it t_{39}}+9.690227711544375 \times 10^{-4}\,{\it t_{37}}
C>    +0.0310907\,{\it t_{35}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="https://doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn2_d2(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = log(4.9237251092134837d-1*t10*t7)
            t12 = 7.016926042943222d-1*t3
            t13 = t12+1.0498d-1
            t14 = t13**2
            t15 = log(1.0d+0*t10*t14)
            t16 = 1.4033852085886445d+0*t3
            t17 = t16+3.72744d+0
            t18 = atan(6.15199081975908d+0/t17)
            t19 = 1/t7
            t20 = 1/t2**3
            t21 = 1/rhoa**6.666666666666667d-1
            t22 = -2.1795975674590234d-1*t20*t21-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t23 = 1/t8
            t24 = 1/rhoa**1.6666666666666666d+0
            t25 = -4.9237251092134837d-1*t10*t22*t23*t7-8.20620851535580
     1         6d-2*t10*t19*t24
            t26 = 1/t17**2
            t27 = 3.784699104639999d+1*t26+1
            t28 = 1/t27
            t29 = 1/t14
            t30 = -1.0d+0*t10*t14*t22*t23-1.1694876738238703d-1*t10*t13*
     1         t20*t21
            t31 = 9.690227711544375d-4*t29*t30*t9+6.314467057030004d-2*t
     1         19*t25*t9+2.790332964441521d-2*t20*t21*t26*t28
            t32 = 2.0d+0*t31*wght
            t33 = 1/rhoa**2.3333333333333334d+0
            t34 = -2.470091445929572d-1*t33/(t17**5*t27**2)
            t35 = 6.526520015557556d-3*t28*t33/t17**3
            t36 = 1/abs(t5+7.496532937978391d-1*t3+1.14813d+1)
            t37 = -1.688686394038963d-2*log(4.9237251092134837d-1*t36*t7
     1         )-3.6490335179177674d-4*log(1.0d+0*(t12+2.28344d-1)**2*t3
     2         6)-5.458482358638966d-3*atan(6.692072046645942d+0/(t16+1.
     3         0683499999999999d+0))
            t38 = 1/rhoa**2
            t39 = 1/abs(t5+4.9542444972117183d+0*t3+1.8057800000000002d+
     1         1)
            t40 = 1/abs(t5+9.17252572333538d+0*t3+4.2719799999999997d+1)
            t41 = 1/abs(t5+1.4120230445475074d+1*t3+1.01578d+2)
            t42 = -1.554535d-2*log(4.9237251092134837d-1*t41*t7)+3.10907
     1         d-2*log(4.9237251092134837d-1*t40*t7)+1.554535d-2*log(4.9
     2         237251092134837d-1*t39*t7)-2.667310007273315d-3*log(1.0d+
     3         0*(t12+7.43294d-1)**2*t41)+4.431373767749538d-3*log(1.0d+
     4         0*(t12+4.09286d-1)**2*t40)+2.2478670955426108d-3*log(1.0d
     5         +0*(t12+3.25d-1)**2*t39)-3.8783294878113006d-2*t18-6.1881
     6         80297906176d-1*atan(1.171685277708971d+0/(t16+2.012310000
     7         0000002d+1))+2.052197293770518d+1*atan(4.4899888641576796
     8         d-2/(t16+1.3072d+1))+5.249139316978092d-2*atan(4.73092690
     9         95601136d+0/(t16+7.06042d+0))-9.690227711544375d-4*t15-3.
     :         10907d-2*t11
            t43 = 1/rhoa**1.6666666666666669d+0
            t44 = -9.301109881471736d-3*t20*t26*t28*t43
            t45 = t22**2
            t46 = 1/t8**2
            t47 = 1/t2**5
            t48 = 1/rhoa**1.3333333333333336d+0
            t49 = 5.448993918647558d-2*t47*t48+7.265325224863413d-2*t20*
     1         t43+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t50 = 6.314467057030004d-2*t19*(-4.9237251092134837d-1*t10*t
     1         23*t49*t7+9.847450218426967d-1*t10*t45*t46*t7+1.641241703
     2         0711612d-1*t10*t19*t22*t23*t24+5.470805676903869d-2*t10*t
     3         19/rhoa**2.6666666666666666d+0)*t9
            t51 = -6.975832411103801d-3*t26*t28*t47*t48
            t52 = 1.0524111761716676d-2*t19*t25*t9/rhoa**9.9999999999999
     1         99d-1
            t53 = 1.1332601865197636d-4*t20*t21*t30*t9/t13**3
            t54 = 9.690227711544375d-4*t29*(-1.0d+0*t10*t14*t23*t49+2.92
     1         3719184559675d-2*t10*t13*t47*t48+2.0d+0*t10*t14*t45*t46+3
     2         .898292246079568d-2*t10*t13*t20*t43+6.838507096129838d-3*
     3         t10*t33+2.3389753476477407d-1*t10*t13*t20*t21*t22*t23)*t9
            t55 = 6.314467057030004d-2*t10*t19*t22*t25*t8
            t56 = 9.690227711544375d-4*t10*t22*t29*t30*t8
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*t31*wght+1.0d+0*(3.878329487811
     1         3006d-2*t18+9.690227711544375d-4*t15+3.10907d-2*t11)*wght
     2         +Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*(t56+t55+t54+t53+t52+t51+t5
     1         0+t44+4.274802335403413d-1*t38*t42+2.5000000000000006d-1*
     2         t37*t38+t35+t34)*wght+t32+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*(t56+t55+t54+t53+t52+t51+t5
     1         0+t44-4.274802335403413d-1*t38*t42-2.5000000000000006d-1*
     2         t37*t38+t35+t34)*wght+t32+Amat2(iq,D2_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+1.0683499999999999d+0
            t25 = atan(6.692072046645942d+0/t24)
            t26 = t8+2.28344d-1
            t27 = t26**2
            t28 = 8.414573716781907d-1*t4+t12+1.14813d+1
            t29 = abs(t28)
            t30 = 1/t29
            t31 = log(1.0d+0*t27*t30)
            t32 = log(6.203504908994001d-1*t17*t30)
            t33 = t19**4
            t34 = 1/t1**4
            t35 = t5+1.3072d+1
            t36 = atan(4.4899888641576796d-2/t35)
            t37 = t5+2.0123100000000002d+1
            t38 = atan(1.171685277708971d+0/t37)
            t39 = t8+4.09286d-1
            t40 = t39**2
            t41 = 1.0295812011585444d+1*t4+t12+4.2719799999999997d+1
            t42 = abs(t41)
            t43 = 1/t42
            t44 = log(1.0d+0*t40*t43)
            t45 = log(6.203504908994001d-1*t17*t43)
            t46 = t8+7.43294d-1
            t47 = t46**2
            t48 = 1.5849422788428325d+1*t4+t12+1.01578d+2
            t49 = abs(t48)
            t50 = 1/t49
            t51 = log(1.0d+0*t47*t50)
            t52 = log(6.203504908994001d-1*t17*t50)
            t53 = 1.709920934161365d+0*(1.554535d-2*t52+2.66731000727331
     1         5d-3*t51-3.10907d-2*t45-4.431373767749538d-3*t44+6.188180
     2         297906176d-1*t38-2.052197293770518d+1*t36)+1.688686394038
     3         963d-2*t32+3.6490335179177674d-4*t31+5.458482358638966d-3
     4         *t25
            t54 = t33*t34*t53-1.688686394038963d-2*t32-3.649033517917767
     1         4d-4*t31-5.458482358638966d-3*t25
            t55 = t5+7.06042d+0
            t56 = t8+3.25d-1
            t57 = t56**2
            t58 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t59 = abs(t58)
            t60 = 1/t59
            t61 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t57*t60)+1.554535d-2*log(6.203504908994001d-1*t17*t6
     2         0)+5.249139316978092d-2*atan(4.7309269095601136d+0/t55)-1
     3         .554535d-2*t52-2.667310007273315d-3*t51+3.10907d-2*t45+4.
     4         431373767749538d-3*t44-6.188180297906176d-1*t38+2.0521972
     5         93770518d+1*t36-3.10907d-2*t18-9.690227711544375d-4*t16
            t62 = 3.8783294878113006d-2*t7+1.923661050931536d+0*t23*t61+
     1         1.1250000000000002d+0*t23*t54+3.10907d-2*t18+9.6902277115
     2         44375d-4*t16
            t63 = 1/t1**6.666666666666667d-1
            t64 = 1/t3**3
            t65 = 1/t6**2
            t66 = 3.784699104639999d+1*t65+1
            t67 = 1/t66
            t68 = 6.264085709464389d-2*t63*t64*t65*t67
            t69 = 1/t10
            t70 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t71 = t70-4.8930311001203647d-1*t63*t64
            t72 = 1/t13
            t73 = -2.625411059665811d-1*t15*t63*t64*t9-1.0d+0*t10*t15*t7
     1         1*t72
            t74 = 9.690227711544375d-4*t14*t69*t73
            t75 = 1/t17
            t76 = 1/t1**1.6666666666666666d+0
            t77 = -2.067834969664667d-1*t15*t75*t76-6.203504908994001d-1
     1         *t15*t17*t71*t72
            t78 = 5.011795824473985d-2*t14*t75*t77
            t79 = 1/t55**2
            t80 = 2.238166942360001d+1*t79+1
            t81 = 1/t80
            t82 = 1/t35**2
            t83 = 2.016000000025997d-3*t82+1
            t84 = 1/t83
            t85 = 1/t37**2
            t86 = 1.3728463899999485d+0*t85+1
            t87 = 1/t86
            t88 = 1/t57
            t89 = t70-9.26825237694284d-1*t63*t64
            t90 = 1/t58
            t91 = -1.0d+0*t57*t60*t89*t90-2.625411059665811d-1*t56*t60*t
     1         63*t64
            t92 = -6.203504908994001d-1*t17*t60*t89*t90-2.06783496966466
     1         7d-1*t60*t75*t76
            t93 = 1/t40
            t94 = t70-1.715968668597574d+0*t63*t64
            t95 = 1/t41
            t96 = -1.0d+0*t40*t43*t94*t95-2.625411059665811d-1*t39*t43*t
     1         63*t64
            t97 = -6.203504908994001d-1*t17*t43*t94*t95-2.06783496966466
     1         7d-1*t43*t75*t76
            t98 = 1/t47
            t99 = t70-2.641570464738054d+0*t63*t64
            t100 = 1/t48
            t101 = -1.0d+0*t100*t47*t50*t99-2.625411059665811d-1*t46*t50
     1         *t63*t64
            t102 = -6.203504908994001d-1*t100*t17*t50*t99-2.067834969664
     1         667d-1*t50*t75*t76
            t103 = -2.667310007273315d-3*t101*t49*t98+5.011795824473985d
     1         -2*t42*t75*t97+4.431373767749538d-3*t42*t93*t96+2.5058979
     2         122369923d-2*t59*t75*t92+2.2478670955426108d-3*t59*t88*t9
     3         1-1.9035804775132142d-1*t63*t64*t85*t87+2.419143800947353
     4         7d-1*t63*t64*t82*t84+6.519760588836059d-2*t63*t64*t79*t81
     5         -5.011795824473985d-2*t14*t75*t77-2.5058979122369923d-2*t
     6         102*t49*t75-9.690227711544375d-4*t14*t69*t73-6.2640857094
     7         64389d-2*t63*t64*t65*t67
            t104 = 1.923661050931536d+0*t103*t23
            t105 = 1/t24**2
            t106 = 4.4783828277500004d+1*t105+1
            t107 = 1/t106
            t108 = -9.590247809108334d-3*t105*t107*t63*t64
            t109 = 1/t27
            t110 = t70-1.4024289527969844d-1*t63*t64
            t111 = 1/t28
            t112 = -2.625411059665811d-1*t26*t30*t63*t64-1.0d+0*t110*t11
     1         1*t27*t30
            t113 = -3.6490335179177674d-4*t109*t112*t29
            t114 = -2.067834969664667d-1*t30*t75*t76-6.203504908994001d-
     1         1*t110*t111*t17*t30
            t115 = -2.722148880047894d-2*t114*t29*t75
            t116 = 1.709920934161365d+0*(2.667310007273315d-3*t101*t49*t
     1         98-5.011795824473985d-2*t42*t75*t97-4.431373767749538d-3*
     2         t42*t93*t96+1.9035804775132142d-1*t63*t64*t85*t87-2.41914
     3         38009473537d-1*t63*t64*t82*t84+2.5058979122369923d-2*t102
     4         *t49*t75)+2.722148880047894d-2*t114*t29*t75+9.59024780910
     5         8334d-3*t105*t107*t63*t64+3.6490335179177674d-4*t109*t112
     6         *t29
            t117 = t116*t33*t34
            t118 = 1/t1**5
            t119 = -4*t118*t33*t53
            t120 = t19**3
            t121 = 4*t120*t34*t53+t119+t117+t115+t113+t108
            t122 = 1/t1**2
            t123 = t122*t19
            t124 = -t20
            t125 = t124+t123
            t126 = t21**3.333333333333333d-1
            t127 = -t122*t19
            t128 = t20+t127
            t129 = t22**3.333333333333333d-1
            t130 = 1.3333333333333333d+0*t128*t129+1.3333333333333333d+0
     1         *t125*t126
            t131 = t78+t74+t68+1.923661050931536d+0*t130*t61+1.125000000
     1         0000002d+0*t130*t54+1.1250000000000002d+0*t121*t23+t104
            t132 = 1.0d+0*t62*wght
            t133 = -4*t120*t34*t53+t119+t117+t115+t113+t108
            t134 = t20+t123
            t135 = t127+t124
            t136 = 1.3333333333333333d+0*t129*t135+1.3333333333333333d+0
     1         *t126*t134
            t137 = t78+t74+t68+1.923661050931536d+0*t136*t61+1.125000000
     1         0000002d+0*t136*t54+1.1250000000000002d+0*t133*t23+t104
            t138 = 1/t1**2.3333333333333334d+0
            t139 = 1/t6**5
            t140 = 1/t66**2
            t141 = -1.2448480831567728d+0*t138*t139*t140
            t142 = 1/t6**3
            t143 = 3.289159980064472d-2*t138*t142*t67
            t144 = 1/t1**1.3333333333333336d+0
            t145 = 1/t3**5
            t146 = -3.1320428547321943d-2*t144*t145*t65*t67
            t147 = 1/t1**1.6666666666666669d+0
            t148 = -4.176057139642926d-2*t147*t64*t65*t67
            t149 = 9.690227711544375d-4*t13*t15*t69*t71*t73
            t150 = 5.011795824473985d-2*t13*t15*t71*t75*t77
            t151 = t71**2
            t152 = 1/t13**2
            t153 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t154 = 3.262020733413577d-1*t147*t64+t153+2.4465155500601823
     1         d-1*t144*t145
            t155 = 5.250822119331622d-1*t15*t63*t64*t71*t72*t9+1.7502740
     1         397772074d-1*t147*t15*t64*t9+1.3127055298329054d-1*t144*t
     2         145*t15*t9-1.0d+0*t10*t15*t154*t72+2.0d+0*t10*t15*t151*t1
     3         52+3.446391616107778d-2*t138*t15
            t156 = 9.690227711544375d-4*t14*t155*t69
            t157 = 1/t9**3
            t158 = 2.544083100456872d-4*t14*t157*t63*t64*t73
            t159 = 1/t1**2.6666666666666666d+0
            t160 = 4.135669939329334d-1*t15*t71*t72*t75*t76+2.7571132928
     1         862224d-1*t15*t159*t75-6.203504908994001d-1*t15*t154*t17*
     2         t72+1.2407009817988002d+0*t15*t151*t152*t17
            t161 = 5.011795824473985d-2*t14*t160*t75
            t162 = 1/t1**9.999999999999999d-1
            t163 = 1.670598608157995d-2*t14*t162*t75*t77
            t164 = 1/t35**5
            t165 = 1/t83**2
            t166 = 1/t35**3
            t167 = 1/t37**5
            t168 = 1/t86**2
            t169 = 1/t37**3
            t170 = t89**2
            t171 = 1/t58**2
            t172 = 6.178834917961894d-1*t147*t64+t153+4.63412618847142d-
     1         1*t144*t145
            t173 = t94**2
            t174 = 1/t41**2
            t175 = 1.1439791123983827d+0*t147*t64+t153+8.57984334298787d
     1         -1*t144*t145
            t176 = 5.250822119331622d-1*t39*t43*t63*t64*t94*t95-1.0d+0*t
     1         175*t40*t43*t95+1.7502740397772074d-1*t147*t39*t43*t64+2.
     2         0d+0*t173*t174*t40*t43+1.3127055298329054d-1*t144*t145*t3
     3         9*t43+3.446391616107778d-2*t138*t43
            t177 = 1/t39**3
            t178 = 4.135669939329334d-1*t43*t75*t76*t94*t95-6.2035049089
     1         94001d-1*t17*t175*t43*t95+2.7571132928862224d-1*t159*t43*
     2         t75+1.2407009817988002d+0*t17*t173*t174*t43
            t179 = t99**2
            t180 = 1/t48**2
            t181 = 1.761046976492036d+0*t147*t64+t153+1.320785232369027d
     1         +0*t144*t145
            t182 = 5.250822119331622d-1*t100*t46*t50*t63*t64*t99+1.75027
     1         40397772074d-1*t147*t46*t50*t64-1.0d+0*t100*t181*t47*t50+
     2         2.0d+0*t179*t180*t47*t50+1.3127055298329054d-1*t144*t145*
     3         t46*t50+3.446391616107778d-2*t138*t50
            t183 = 1/t46**3
            t184 = 4.135669939329334d-1*t100*t50*t75*t76*t99+2.757113292
     1         8862224d-1*t159*t50*t75-6.203504908994001d-1*t100*t17*t18
     2         1*t50+1.2407009817988002d+0*t17*t179*t180*t50
            t185 = 1.923661050931536d+0*t23*(-2.667310007273315d-3*t101*
     1         t48*t50*t98*t99-2.5058979122369923d-2*t102*t48*t50*t75*t9
     2         9-2.667310007273315d-3*t182*t49*t98+5.011795824473985d-2*
     3         t41*t43*t75*t94*t97+1.670598608157995d-2*t162*t42*t75*t97
     4         +4.431373767749538d-3*t41*t43*t93*t94*t96+1.1634177699362
     5         593d-3*t177*t42*t63*t64*t96+4.431373767749538d-3*t176*t42
     6         *t93+2.5058979122369923d-2*t58*t60*t75*t89*t92+8.35299304
     7         0789976d-3*t162*t59*t75*t92+2.2478670955426108d-3*t58*t60
     8         *t88*t89*t91+5.901575133296435d-4*t59*t63*t64*t91/t56**3+
     9         2.5058979122369923d-2*t59*t75*(4.135669939329334d-1*t60*t
     :         75*t76*t89*t90-6.203504908994001d-1*t17*t172*t60*t90+2.75
     ;         71132928862224d-1*t159*t60*t75+1.2407009817988002d+0*t17*
     <         t170*t171*t60)+2.2478670955426108d-3*t59*t88*(5.250822119
     =         331622d-1*t56*t60*t63*t64*t89*t90-1.0d+0*t172*t57*t60*t90
     >         +1.7502740397772074d-1*t147*t56*t60*t64+2.0d+0*t170*t171*
     ?         t57*t60+1.3127055298329054d-1*t144*t145*t56*t60+3.4463916
     @         16107778d-2*t138*t60)+1.2690536516754763d-1*t147*t64*t85*
     1         t87+9.517902387566071d-2*t144*t145*t85*t87-9.995362477254
     2         237d-2*t138*t169*t87-1.6127625339649027d-1*t147*t64*t82*t
     3         84-1.2095719004736769d-1*t144*t145*t82*t84+1.270249377985
     4         834d-1*t138*t166*t84-4.3465070592240396d-2*t147*t64*t79*t
     5         81-3.2598802944180294d-2*t144*t145*t79*t81+3.423410311260
     6         6934d-2*t138*t81/t55**3-7.662163788798045d-1*t138/(t55**5
     7         *t80**2)-5.011795824473985d-2*t13*t15*t71*t75*t77-1.67059
     8         8608157995d-2*t14*t162*t75*t77-2.5058979122369923d-2*t184
     9         *t49*t75-8.352993040789976d-3*t102*t162*t49*t75+5.0117958
     :         24473985d-2*t178*t42*t75-5.011795824473985d-2*t14*t160*t7
     ;         5-9.690227711544375d-4*t13*t15*t69*t71*t73-2.544083100456
     <         872d-4*t14*t157*t63*t64*t73-9.690227711544375d-4*t14*t155
     =         *t69+4.176057139642926d-2*t147*t64*t65*t67+3.132042854732
     >         1943d-2*t144*t145*t65*t67-3.289159980064472d-2*t138*t142*
     ?         t67-7.002785192652656d-4*t101*t183*t49*t63*t64+1.37220972
     @         9363942d-1*t138*t167*t168-2.560822746052464d-4*t138*t164*
     1         t165+1.2448480831567728d+0*t138*t139*t140)
            t186 = 1/t24**5
            t187 = 1/t106**2
            t188 = 2.255165148260897d-1*t138*t186*t187
            t189 = 1/t24**3
            t190 = -5.035668532593766d-3*t107*t138*t189
            t191 = 4.795123904554167d-3*t105*t107*t144*t145
            t192 = 6.393498539405557d-3*t105*t107*t147*t64
            t193 = -3.6490335179177674d-4*t109*t110*t112*t28*t30
            t194 = -2.722148880047894d-2*t110*t114*t28*t30*t75
            t195 = t110**2
            t196 = 1/t28**2
            t197 = 9.349526351979897d-2*t147*t64+t153+7.012144763984922d
     1         -2*t144*t145
            t198 = 5.250822119331622d-1*t110*t111*t26*t30*t63*t64+1.7502
     1         740397772074d-1*t147*t26*t30*t64-1.0d+0*t111*t197*t27*t30
     2         +2.0d+0*t195*t196*t27*t30+1.3127055298329054d-1*t144*t145
     3         *t26*t30+3.446391616107778d-2*t138*t30
            t199 = -3.6490335179177674d-4*t109*t198*t29
            t200 = 1/t26**3
            t201 = -9.580212955032547d-5*t112*t200*t29*t63*t64
            t202 = 4.135669939329334d-1*t110*t111*t30*t75*t76+2.75711329
     1         28862224d-1*t159*t30*t75-6.203504908994001d-1*t111*t17*t1
     2         97*t30+1.2407009817988002d+0*t17*t195*t196*t30
            t203 = -2.722148880047894d-2*t202*t29*t75
            t204 = -9.073829600159646d-3*t114*t162*t29*t75
            t205 = -8*t116*t118*t33
            t206 = t33*t34*(1.709920934161365d+0*(2.667310007273315d-3*t
     1         101*t48*t50*t98*t99+2.5058979122369923d-2*t102*t48*t50*t7
     2         5*t99+2.667310007273315d-3*t182*t49*t98-5.011795824473985
     3         d-2*t41*t43*t75*t94*t97-1.670598608157995d-2*t162*t42*t75
     4         *t97-4.431373767749538d-3*t41*t43*t93*t94*t96-1.163417769
     5         9362593d-3*t177*t42*t63*t64*t96-4.431373767749538d-3*t176
     6         *t42*t93-1.2690536516754763d-1*t147*t64*t85*t87-9.5179023
     7         87566071d-2*t144*t145*t85*t87+9.995362477254237d-2*t138*t
     8         169*t87+1.6127625339649027d-1*t147*t64*t82*t84+1.20957190
     9         04736769d-1*t144*t145*t82*t84-1.270249377985834d-1*t138*t
     :         166*t84+2.5058979122369923d-2*t184*t49*t75+8.352993040789
     ;         976d-3*t102*t162*t49*t75-5.011795824473985d-2*t178*t42*t7
     <         5+7.002785192652656d-4*t101*t183*t49*t63*t64-1.3722097293
     =         63942d-1*t138*t167*t168+2.560822746052464d-4*t138*t164*t1
     >         65)+2.722148880047894d-2*t110*t114*t28*t30*t75+2.72214888
     ?         0047894d-2*t202*t29*t75+9.073829600159646d-3*t114*t162*t2
     @         9*t75+9.580212955032547d-5*t112*t200*t29*t63*t64-6.393498
     1         539405557d-3*t105*t107*t147*t64+3.6490335179177674d-4*t10
     2         9*t110*t112*t28*t30+3.6490335179177674d-4*t109*t198*t29+5
     3         .035668532593766d-3*t107*t138*t189-2.255165148260897d-1*t
     4         138*t186*t187-4.795123904554167d-3*t105*t107*t144*t145)
            t207 = 20*t33*t53/t1**6
            t208 = t19**2
            t209 = 12*t208*t34*t53
            t210 = 1/t21**6.666666666666666d-1
            t211 = 1/t1**3
            t212 = -2*t19*t211
            t213 = 2*t122
            t214 = 1/t22**6.666666666666666d-1
            t215 = 2*t19*t211
            t216 = -2*t122
            t217 = 1.3333333333333333d+0*t129*(t216+t215)+4.444444444444
     1         444d-1*t128**2*t214+1.3333333333333333d+0*t126*(t213+t212
     2         )+4.444444444444444d-1*t125**2*t210
            t218 = 4.444444444444444d-1*t128*t135*t214+2.666666666666666
     1         6d+0*t129*t19*t211-2.6666666666666666d+0*t126*t19*t211+4.
     2         444444444444444d-1*t125*t134*t210
            t219 = 1.3333333333333333d+0*t126*(t216+t212)+1.333333333333
     1         3333d+0*t129*(t215+t213)+4.444444444444444d-1*t135**2*t21
     2         4+4.444444444444444d-1*t134**2*t210
            fnc(iq) = 1.0d+0*t1*t62*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t131*wght+t132+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t137*wght+t132+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*t1*(1.923661050931536d+0*t217*t6
     1         1+1.1250000000000002d+0*t217*t54+1.1250000000000002d+0*t2
     2         3*(-32*t118*t120*t53+8*t116*t120*t34+t209+t207+t206+t205+
     3         t204+t203+t201+t199+t194+t193+t192+t191+t190+t188)+t185+t
     4         163+t161+t158+t156+t150+t149+t148+t146+t143+t141+2.250000
     5         0000000003d+0*t121*t130+3.847322101863072d+0*t103*t130)*w
     6         ght+2.0d+0*t131*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t1*(1.923661050931536d+0*t218*t6
     1         1+1.1250000000000002d+0*t218*t54+1.1250000000000002d+0*t2
     2         3*(-12*t208*t34*t53+t207+t206+t205+t204+t203+t201+t199+t1
     3         94+t193+t192+t191+t190+t188)+t185+t163+t161+t158+t156+t15
     4         0+t149+t148+t146+t143+t141+1.1250000000000002d+0*t121*t13
     5         6+1.923661050931536d+0*t103*t136+1.1250000000000002d+0*t1
     6         30*t133+1.923661050931536d+0*t103*t130)*wght+1.0d+0*t137*
     7         wght+1.0d+0*t131*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*(1.923661050931536d+0*t219*t6
     1         1+1.1250000000000002d+0*t219*t54+1.1250000000000002d+0*t2
     2         3*(32*t118*t120*t53-8*t116*t120*t34+t209+t207+t206+t205+t
     3         204+t203+t201+t199+t194+t193+t192+t191+t190+t188)+t185+t1
     4         63+t161+t158+t156+t150+t149+t148+t146+t143+t141+2.2500000
     5         000000003d+0*t133*t136+3.847322101863072d+0*t103*t136)*wg
     6         ht+2.0d+0*t137*wght+Amat2(iq,D2_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.414573716781907d-1*t3+1.14813d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+2.28344d-1
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.0683499999999999d+0
            t26 = atan(6.692072046645942d+0/t25)
            t27 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = log(6.203504908994001d-1*t29*t9)
            t31 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t32 = abs(t31)
            t33 = 1/t32
            t34 = log(6.203504908994001d-1*t33*t9)
            t35 = t11+4.09286d-1
            t36 = t35**2
            t37 = log(1.0d+0*t29*t36)
            t38 = t11+7.43294d-1
            t39 = t38**2
            t40 = log(1.0d+0*t33*t39)
            t41 = t15+1.3072d+1
            t42 = atan(4.4899888641576796d-2/t41)
            t43 = t15+2.0123100000000002d+1
            t44 = atan(1.171685277708971d+0/t43)
            t45 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t46 = abs(t45)
            t47 = 1/t46
            t48 = t11+3.25d-1
            t49 = t48**2
            t50 = t15+7.06042d+0
            t51 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t47*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t50)+2.2478670955426108d-3*log(1.0d+0*t47*t49)-6.18818
     3         0297906176d-1*t44+2.052197293770518d+1*t42-2.667310007273
     4         315d-3*t40+4.431373767749538d-3*t37-1.554535d-2*t34+3.109
     5         07d-2*t30-3.8783294878113006d-2*t17-9.690227711544375d-4*
     6         t14-3.10907d-2*t10)+5.848223622634643d-1*(1.0d+0*(1.70992
     7         0934161365d+0*(6.188180297906176d-1*t44-2.052197293770518
     8         d+1*t42+2.667310007273315d-3*t40-4.431373767749538d-3*t37
     9         +1.554535d-2*t34-3.10907d-2*t30)+5.458482358638966d-3*t26
     :         +3.6490335179177674d-4*t24+1.688686394038963d-2*t21)-5.45
     ;         8482358638966d-3*t26-3.6490335179177674d-4*t24-1.68868639
     <         4038963d-2*t21)+3.8783294878113006d-2*t17+9.6902277115443
     =         75d-4*t14+3.10907d-2*t10
            t52 = 1/t9
            t53 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t54 = 1/t2**3
            t55 = 1/rhoa**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t6
            t58 = 1/rhoa**1.6666666666666666d+0
            t59 = -6.203504908994001d-1*t56*t57*t8*t9-2.067834969664667d
     1         -1*t52*t58*t8
            t60 = 1/t16**2
            t61 = 3.784699104639999d+1*t60+1
            t62 = 1/t61
            t63 = 1/t13
            t64 = -1.0d+0*t13*t56*t57*t8-2.625411059665811d-1*t12*t54*t5
     1         5*t8
            t65 = t53-9.26825237694284d-1*t54*t55
            t66 = 1/t45
            t67 = -6.203504908994001d-1*t47*t65*t66*t9-2.067834969664667
     1         d-1*t47*t52*t58
            t68 = t53-1.715968668597574d+0*t54*t55
            t69 = 1/t27
            t70 = -6.203504908994001d-1*t29*t68*t69*t9-2.067834969664667
     1         d-1*t29*t52*t58
            t71 = t53-2.641570464738054d+0*t54*t55
            t72 = 1/t31
            t73 = -6.203504908994001d-1*t33*t71*t72*t9-2.067834969664667
     1         d-1*t33*t52*t58
            t74 = 1/t50**2
            t75 = 2.238166942360001d+1*t74+1
            t76 = 1/t75
            t77 = 1/t41**2
            t78 = 2.016000000025997d-3*t77+1
            t79 = 1/t78
            t80 = 1/t43**2
            t81 = 1.3728463899999485d+0*t80+1
            t82 = 1/t81
            t83 = 1/t49
            t84 = -1.0d+0*t47*t49*t65*t66-2.625411059665811d-1*t47*t48*t
     1         54*t55
            t85 = 1/t36
            t86 = -1.0d+0*t29*t36*t68*t69-2.625411059665811d-1*t29*t35*t
     1         54*t55
            t87 = 1/t39
            t88 = -1.0d+0*t33*t39*t71*t72-2.625411059665811d-1*t33*t38*t
     1         54*t55
            t89 = t53-1.4024289527969844d-1*t54*t55
            t90 = 1/t18
            t91 = -6.203504908994001d-1*t20*t89*t9*t90-2.067834969664667
     1         d-1*t20*t52*t58
            t92 = 1/t25**2
            t93 = 4.4783828277500004d+1*t92+1
            t94 = 1/t93
            t95 = 1/t23
            t96 = -1.0d+0*t20*t23*t89*t90-2.625411059665811d-1*t20*t22*t
     1         54*t55
            t97 = 5.848223622634643d-1*(1.0d+0*(3.6490335179177674d-4*t1
     1         9*t95*t96+9.590247809108334d-3*t54*t55*t92*t94+2.72214888
     2         0047894d-2*t19*t52*t91+1.709920934161365d+0*(2.6673100072
     3         73315d-3*t32*t87*t88-4.431373767749538d-3*t28*t85*t86+1.9
     4         035804775132142d-1*t54*t55*t80*t82-2.4191438009473537d-1*
     5         t54*t55*t77*t79+2.5058979122369923d-2*t32*t52*t73-5.01179
     6         5824473985d-2*t28*t52*t70))-3.6490335179177674d-4*t19*t95
     7         *t96-9.590247809108334d-3*t54*t55*t92*t94-2.7221488800478
     8         94d-2*t19*t52*t91)+9.99999999999999d-1*(-2.66731000727331
     9         5d-3*t32*t87*t88+4.431373767749538d-3*t28*t85*t86+2.24786
     :         70955426108d-3*t46*t83*t84-1.9035804775132142d-1*t54*t55*
     ;         t80*t82+2.4191438009473537d-1*t54*t55*t77*t79+6.519760588
     <         836059d-2*t54*t55*t74*t76-2.5058979122369923d-2*t32*t52*t
     =         73+5.011795824473985d-2*t28*t52*t70-9.690227711544375d-4*
     >         t63*t64*t7-5.011795824473985d-2*t52*t59*t7+2.505897912236
     ?         9923d-2*t46*t52*t67-6.264085709464389d-2*t54*t55*t60*t62)
     @         +9.690227711544375d-4*t63*t64*t7+5.011795824473985d-2*t52
     1         *t59*t7+6.264085709464389d-2*t54*t55*t60*t62
            t98 = 1/t61**2
            t99 = 1/t16**5
            t100 = 1/rhoa**2.3333333333333334d+0
            t101 = 1/t16**3
            t102 = 1/rhoa**1.6666666666666669d+0
            t103 = t56**2
            t104 = 1/t6**2
            t105 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t106 = 1/t2**5
            t107 = 1/rhoa**1.3333333333333336d+0
            t108 = 3.262020733413577d-1*t102*t54+2.4465155500601823d-1*t
     1         106*t107+t105
            t109 = 1/rhoa**2.6666666666666666d+0
            t110 = -6.203504908994001d-1*t108*t57*t8*t9+1.24070098179880
     1         02d+0*t103*t104*t8*t9+4.135669939329334d-1*t52*t56*t57*t5
     2         8*t8+2.7571132928862224d-1*t109*t52*t8
            t111 = 1/rhoa**9.999999999999999d-1
            t112 = 1/t12**3
            t113 = 5.250822119331622d-1*t12*t54*t55*t56*t57*t8-1.0d+0*t1
     1         08*t13*t57*t8+1.7502740397772074d-1*t102*t12*t54*t8+2.0d+
     2         0*t103*t104*t13*t8+1.3127055298329054d-1*t106*t107*t12*t8
     3         +3.446391616107778d-2*t100*t8
            t114 = 1/t93**2
            t115 = 1/t25**5
            t116 = 1/t25**3
            t117 = t89**2
            t118 = 1/t18**2
            t119 = 9.349526351979897d-2*t102*t54+7.012144763984922d-2*t1
     1         06*t107+t105
            t120 = -6.203504908994001d-1*t119*t20*t9*t90+4.1356699393293
     1         34d-1*t20*t52*t58*t89*t90+1.2407009817988002d+0*t117*t118
     2         *t20*t9+2.7571132928862224d-1*t109*t20*t52
            t121 = 1/t22**3
            t122 = 5.250822119331622d-1*t20*t22*t54*t55*t89*t90-1.0d+0*t
     1         119*t20*t23*t90+1.7502740397772074d-1*t102*t20*t22*t54+2.
     2         0d+0*t117*t118*t20*t23+1.3127055298329054d-1*t106*t107*t2
     3         0*t22+3.446391616107778d-2*t100*t20
            t123 = 1/t78**2
            t124 = 1/t41**5
            t125 = 1/t41**3
            t126 = 1/t81**2
            t127 = 1/t43**5
            t128 = 1/t43**3
            t129 = t68**2
            t130 = 1/t27**2
            t131 = 1.1439791123983827d+0*t102*t54+8.57984334298787d-1*t1
     1         06*t107+t105
            t132 = -6.203504908994001d-1*t131*t29*t69*t9+1.2407009817988
     1         002d+0*t129*t130*t29*t9+4.135669939329334d-1*t29*t52*t58*
     2         t68*t69+2.7571132928862224d-1*t109*t29*t52
            t133 = t71**2
            t134 = 1/t31**2
            t135 = 1.761046976492036d+0*t102*t54+1.320785232369027d+0*t1
     1         06*t107+t105
            t136 = -6.203504908994001d-1*t135*t33*t72*t9+1.2407009817988
     1         002d+0*t133*t134*t33*t9+4.135669939329334d-1*t33*t52*t58*
     2         t71*t72+2.7571132928862224d-1*t109*t33*t52
            t137 = 1/t35**3
            t138 = 1/t38**3
            t139 = 5.250822119331622d-1*t29*t35*t54*t55*t68*t69-1.0d+0*t
     1         131*t29*t36*t69+1.7502740397772074d-1*t102*t29*t35*t54+2.
     2         0d+0*t129*t130*t29*t36+1.3127055298329054d-1*t106*t107*t2
     3         9*t35+3.446391616107778d-2*t100*t29
            t140 = 5.250822119331622d-1*t33*t38*t54*t55*t71*t72-1.0d+0*t
     1         135*t33*t39*t72+1.7502740397772074d-1*t102*t33*t38*t54+2.
     2         0d+0*t133*t134*t33*t39+1.3127055298329054d-1*t106*t107*t3
     3         3*t38+3.446391616107778d-2*t100*t33
            t141 = t65**2
            t142 = 1/t45**2
            t143 = 6.178834917961894d-1*t102*t54+4.63412618847142d-1*t10
     1         6*t107+t105
            fnc(iq) = 1.0d+0*rhoa*t51*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t97*wght+1.0d+0*t51*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*(9.99999999999999d-1*(1.244
     1         8480831567728d+0*t100*t98*t99+2.5058979122369923d-2*t46*t
     2         52*(-6.203504908994001d-1*t143*t47*t66*t9+1.2407009817988
     3         002d+0*t141*t142*t47*t9+4.135669939329334d-1*t47*t52*t58*
     4         t65*t66+2.7571132928862224d-1*t109*t47*t52)-2.66731000727
     5         3315d-3*t31*t33*t71*t87*t88-7.002785192652656d-4*t138*t32
     6         *t54*t55*t88-2.667310007273315d-3*t140*t32*t87+4.43137376
     7         7749538d-3*t27*t29*t68*t85*t86+1.1634177699362593d-3*t137
     8         *t28*t54*t55*t86+4.431373767749538d-3*t139*t28*t85+2.2478
     9         670955426108d-3*t45*t47*t65*t83*t84+5.901575133296435d-4*
     :         t46*t54*t55*t84/t48**3+2.2478670955426108d-3*t46*(5.25082
     ;         2119331622d-1*t47*t48*t54*t55*t65*t66-1.0d+0*t143*t47*t49
     <         *t66+1.7502740397772074d-1*t102*t47*t48*t54+2.0d+0*t141*t
     =         142*t47*t49+1.3127055298329054d-1*t106*t107*t47*t48+3.446
     >         391616107778d-2*t100*t47)*t83+1.2690536516754763d-1*t102*
     ?         t54*t80*t82+9.517902387566071d-2*t106*t107*t80*t82-9.9953
     @         62477254237d-2*t100*t128*t82-9.690227711544375d-4*t56*t6*
     1         t63*t64*t8-5.011795824473985d-2*t52*t56*t59*t6*t8-1.61276
     2         25339649027d-1*t102*t54*t77*t79-1.2095719004736769d-1*t10
     3         6*t107*t77*t79+1.270249377985834d-1*t100*t125*t79-4.34650
     4         70592240396d-2*t102*t54*t74*t76-3.2598802944180294d-2*t10
     5         6*t107*t74*t76+3.4234103112606934d-2*t100*t76/t50**3-7.66
     6         2163788798045d-1*t100/(t50**5*t75**2)-2.5058979122369923d
     7         -2*t31*t33*t52*t71*t73-8.352993040789976d-3*t111*t32*t52*
     8         t73+5.011795824473985d-2*t27*t29*t52*t68*t70+1.6705986081
     9         57995d-2*t111*t28*t52*t70-2.544083100456872d-4*t112*t54*t
     :         55*t64*t7-9.690227711544375d-4*t113*t63*t7-1.670598608157
     ;         995d-2*t111*t52*t59*t7-5.011795824473985d-2*t110*t52*t7+2
     <         .5058979122369923d-2*t45*t47*t52*t65*t67+8.35299304078997
     =         6d-3*t111*t46*t52*t67+4.176057139642926d-2*t102*t54*t60*t
     >         62+3.1320428547321943d-2*t106*t107*t60*t62-3.289159980064
     ?         472d-2*t100*t101*t62-2.5058979122369923d-2*t136*t32*t52+5
     @         .011795824473985d-2*t132*t28*t52+1.372209729363942d-1*t10
     1         0*t126*t127-2.560822746052464d-4*t100*t123*t124)-1.244848
     2         0831567728d+0*t100*t98*t99+5.848223622634643d-1*(1.0d+0*(
     3         3.6490335179177674d-4*t18*t20*t89*t95*t96+9.5802129550325
     4         47d-5*t121*t19*t54*t55*t96+3.6490335179177674d-4*t122*t19
     5         *t95-6.393498539405557d-3*t102*t54*t92*t94-4.795123904554
     6         167d-3*t106*t107*t92*t94+5.035668532593766d-3*t100*t116*t
     7         94+2.722148880047894d-2*t18*t20*t52*t89*t91+9.07382960015
     8         9646d-3*t111*t19*t52*t91+1.709920934161365d+0*(2.66731000
     9         7273315d-3*t31*t33*t71*t87*t88+7.002785192652656d-4*t138*
     :         t32*t54*t55*t88+2.667310007273315d-3*t140*t32*t87-4.43137
     ;         3767749538d-3*t27*t29*t68*t85*t86-1.1634177699362593d-3*t
     <         137*t28*t54*t55*t86-4.431373767749538d-3*t139*t28*t85-1.2
     =         690536516754763d-1*t102*t54*t80*t82-9.517902387566071d-2*
     >         t106*t107*t80*t82+9.995362477254237d-2*t100*t128*t82+1.61
     ?         27625339649027d-1*t102*t54*t77*t79+1.2095719004736769d-1*
     @         t106*t107*t77*t79-1.270249377985834d-1*t100*t125*t79+2.50
     1         58979122369923d-2*t31*t33*t52*t71*t73+8.352993040789976d-
     2         3*t111*t32*t52*t73-5.011795824473985d-2*t27*t29*t52*t68*t
     3         70-1.670598608157995d-2*t111*t28*t52*t70+2.50589791223699
     4         23d-2*t136*t32*t52-5.011795824473985d-2*t132*t28*t52-1.37
     5         2209729363942d-1*t100*t126*t127+2.560822746052464d-4*t100
     6         *t123*t124)+2.722148880047894d-2*t120*t19*t52-2.255165148
     7         260897d-1*t100*t114*t115)-3.6490335179177674d-4*t18*t20*t
     8         89*t95*t96-9.580212955032547d-5*t121*t19*t54*t55*t96-3.64
     9         90335179177674d-4*t122*t19*t95+6.393498539405557d-3*t102*
     :         t54*t92*t94+4.795123904554167d-3*t106*t107*t92*t94-5.0356
     ;         68532593766d-3*t100*t116*t94-2.722148880047894d-2*t18*t20
     <         *t52*t89*t91-9.073829600159646d-3*t111*t19*t52*t91-2.7221
     =         48880047894d-2*t120*t19*t52+2.255165148260897d-1*t100*t11
     >         4*t115)+9.690227711544375d-4*t56*t6*t63*t64*t8+5.01179582
     ?         4473985d-2*t52*t56*t59*t6*t8+2.544083100456872d-4*t112*t5
     @         4*t55*t64*t7+9.690227711544375d-4*t113*t63*t7+1.670598608
     1         157995d-2*t111*t52*t59*t7+5.011795824473985d-2*t110*t52*t
     2         7-4.176057139642926d-2*t102*t54*t60*t62-3.132042854732194
     3         3d-2*t106*t107*t60*t62+3.289159980064472d-2*t100*t101*t62
     4         )*wght+2.0d+0*t97*wght+Amat2(iq,D2_RA_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.414573716781907d-1*t3+1.14813d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+2.28344d-1
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.0683499999999999d+0
            t26 = atan(6.692072046645942d+0/t25)
            t27 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = log(6.203504908994001d-1*t29*t9)
            t31 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t32 = abs(t31)
            t33 = 1/t32
            t34 = log(6.203504908994001d-1*t33*t9)
            t35 = t11+4.09286d-1
            t36 = t35**2
            t37 = log(1.0d+0*t29*t36)
            t38 = t11+7.43294d-1
            t39 = t38**2
            t40 = log(1.0d+0*t33*t39)
            t41 = t15+1.3072d+1
            t42 = atan(4.4899888641576796d-2/t41)
            t43 = t15+2.0123100000000002d+1
            t44 = atan(1.171685277708971d+0/t43)
            t45 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t46 = abs(t45)
            t47 = 1/t46
            t48 = t11+3.25d-1
            t49 = t48**2
            t50 = t15+7.06042d+0
            t51 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t47*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t50)+2.2478670955426108d-3*log(1.0d+0*t47*t49)-6.18818
     3         0297906176d-1*t44+2.052197293770518d+1*t42-2.667310007273
     4         315d-3*t40+4.431373767749538d-3*t37-1.554535d-2*t34+3.109
     5         07d-2*t30-3.8783294878113006d-2*t17-9.690227711544375d-4*
     6         t14-3.10907d-2*t10)+5.848223622634643d-1*(1.0d+0*(1.70992
     7         0934161365d+0*(6.188180297906176d-1*t44-2.052197293770518
     8         d+1*t42+2.667310007273315d-3*t40-4.431373767749538d-3*t37
     9         +1.554535d-2*t34-3.10907d-2*t30)+5.458482358638966d-3*t26
     :         +3.6490335179177674d-4*t24+1.688686394038963d-2*t21)-5.45
     ;         8482358638966d-3*t26-3.6490335179177674d-4*t24-1.68868639
     <         4038963d-2*t21)+3.8783294878113006d-2*t17+9.6902277115443
     =         75d-4*t14+3.10907d-2*t10
            t52 = 1/t9
            t53 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t54 = 1/t2**3
            t55 = 1/rhob**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t6
            t58 = 1/rhob**1.6666666666666666d+0
            t59 = -6.203504908994001d-1*t56*t57*t8*t9-2.067834969664667d
     1         -1*t52*t58*t8
            t60 = 1/t16**2
            t61 = 3.784699104639999d+1*t60+1
            t62 = 1/t61
            t63 = 1/t13
            t64 = -1.0d+0*t13*t56*t57*t8-2.625411059665811d-1*t12*t54*t5
     1         5*t8
            t65 = t53-9.26825237694284d-1*t54*t55
            t66 = 1/t45
            t67 = -6.203504908994001d-1*t47*t65*t66*t9-2.067834969664667
     1         d-1*t47*t52*t58
            t68 = t53-1.715968668597574d+0*t54*t55
            t69 = 1/t27
            t70 = -6.203504908994001d-1*t29*t68*t69*t9-2.067834969664667
     1         d-1*t29*t52*t58
            t71 = t53-2.641570464738054d+0*t54*t55
            t72 = 1/t31
            t73 = -6.203504908994001d-1*t33*t71*t72*t9-2.067834969664667
     1         d-1*t33*t52*t58
            t74 = 1/t50**2
            t75 = 2.238166942360001d+1*t74+1
            t76 = 1/t75
            t77 = 1/t41**2
            t78 = 2.016000000025997d-3*t77+1
            t79 = 1/t78
            t80 = 1/t43**2
            t81 = 1.3728463899999485d+0*t80+1
            t82 = 1/t81
            t83 = 1/t49
            t84 = -1.0d+0*t47*t49*t65*t66-2.625411059665811d-1*t47*t48*t
     1         54*t55
            t85 = 1/t36
            t86 = -1.0d+0*t29*t36*t68*t69-2.625411059665811d-1*t29*t35*t
     1         54*t55
            t87 = 1/t39
            t88 = -1.0d+0*t33*t39*t71*t72-2.625411059665811d-1*t33*t38*t
     1         54*t55
            t89 = t53-1.4024289527969844d-1*t54*t55
            t90 = 1/t18
            t91 = -6.203504908994001d-1*t20*t89*t9*t90-2.067834969664667
     1         d-1*t20*t52*t58
            t92 = 1/t25**2
            t93 = 4.4783828277500004d+1*t92+1
            t94 = 1/t93
            t95 = 1/t23
            t96 = -1.0d+0*t20*t23*t89*t90-2.625411059665811d-1*t20*t22*t
     1         54*t55
            t97 = 5.848223622634643d-1*(1.0d+0*(3.6490335179177674d-4*t1
     1         9*t95*t96+9.590247809108334d-3*t54*t55*t92*t94+2.72214888
     2         0047894d-2*t19*t52*t91+1.709920934161365d+0*(2.6673100072
     3         73315d-3*t32*t87*t88-4.431373767749538d-3*t28*t85*t86+1.9
     4         035804775132142d-1*t54*t55*t80*t82-2.4191438009473537d-1*
     5         t54*t55*t77*t79+2.5058979122369923d-2*t32*t52*t73-5.01179
     6         5824473985d-2*t28*t52*t70))-3.6490335179177674d-4*t19*t95
     7         *t96-9.590247809108334d-3*t54*t55*t92*t94-2.7221488800478
     8         94d-2*t19*t52*t91)+9.99999999999999d-1*(-2.66731000727331
     9         5d-3*t32*t87*t88+4.431373767749538d-3*t28*t85*t86+2.24786
     :         70955426108d-3*t46*t83*t84-1.9035804775132142d-1*t54*t55*
     ;         t80*t82+2.4191438009473537d-1*t54*t55*t77*t79+6.519760588
     <         836059d-2*t54*t55*t74*t76-2.5058979122369923d-2*t32*t52*t
     =         73+5.011795824473985d-2*t28*t52*t70-9.690227711544375d-4*
     >         t63*t64*t7-5.011795824473985d-2*t52*t59*t7+2.505897912236
     ?         9923d-2*t46*t52*t67-6.264085709464389d-2*t54*t55*t60*t62)
     @         +9.690227711544375d-4*t63*t64*t7+5.011795824473985d-2*t52
     1         *t59*t7+6.264085709464389d-2*t54*t55*t60*t62
            t98 = 1/t61**2
            t99 = 1/t16**5
            t100 = 1/rhob**2.3333333333333334d+0
            t101 = 1/t16**3
            t102 = 1/rhob**1.6666666666666669d+0
            t103 = t56**2
            t104 = 1/t6**2
            t105 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t106 = 1/t2**5
            t107 = 1/rhob**1.3333333333333336d+0
            t108 = 3.262020733413577d-1*t102*t54+2.4465155500601823d-1*t
     1         106*t107+t105
            t109 = 1/rhob**2.6666666666666666d+0
            t110 = -6.203504908994001d-1*t108*t57*t8*t9+1.24070098179880
     1         02d+0*t103*t104*t8*t9+4.135669939329334d-1*t52*t56*t57*t5
     2         8*t8+2.7571132928862224d-1*t109*t52*t8
            t111 = 1/rhob**9.999999999999999d-1
            t112 = 1/t12**3
            t113 = 5.250822119331622d-1*t12*t54*t55*t56*t57*t8-1.0d+0*t1
     1         08*t13*t57*t8+1.7502740397772074d-1*t102*t12*t54*t8+2.0d+
     2         0*t103*t104*t13*t8+1.3127055298329054d-1*t106*t107*t12*t8
     3         +3.446391616107778d-2*t100*t8
            t114 = 1/t93**2
            t115 = 1/t25**5
            t116 = 1/t25**3
            t117 = t89**2
            t118 = 1/t18**2
            t119 = 9.349526351979897d-2*t102*t54+7.012144763984922d-2*t1
     1         06*t107+t105
            t120 = -6.203504908994001d-1*t119*t20*t9*t90+4.1356699393293
     1         34d-1*t20*t52*t58*t89*t90+1.2407009817988002d+0*t117*t118
     2         *t20*t9+2.7571132928862224d-1*t109*t20*t52
            t121 = 1/t22**3
            t122 = 5.250822119331622d-1*t20*t22*t54*t55*t89*t90-1.0d+0*t
     1         119*t20*t23*t90+1.7502740397772074d-1*t102*t20*t22*t54+2.
     2         0d+0*t117*t118*t20*t23+1.3127055298329054d-1*t106*t107*t2
     3         0*t22+3.446391616107778d-2*t100*t20
            t123 = 1/t78**2
            t124 = 1/t41**5
            t125 = 1/t41**3
            t126 = 1/t81**2
            t127 = 1/t43**5
            t128 = 1/t43**3
            t129 = t68**2
            t130 = 1/t27**2
            t131 = 1.1439791123983827d+0*t102*t54+8.57984334298787d-1*t1
     1         06*t107+t105
            t132 = -6.203504908994001d-1*t131*t29*t69*t9+1.2407009817988
     1         002d+0*t129*t130*t29*t9+4.135669939329334d-1*t29*t52*t58*
     2         t68*t69+2.7571132928862224d-1*t109*t29*t52
            t133 = t71**2
            t134 = 1/t31**2
            t135 = 1.761046976492036d+0*t102*t54+1.320785232369027d+0*t1
     1         06*t107+t105
            t136 = -6.203504908994001d-1*t135*t33*t72*t9+1.2407009817988
     1         002d+0*t133*t134*t33*t9+4.135669939329334d-1*t33*t52*t58*
     2         t71*t72+2.7571132928862224d-1*t109*t33*t52
            t137 = 1/t35**3
            t138 = 1/t38**3
            t139 = 5.250822119331622d-1*t29*t35*t54*t55*t68*t69-1.0d+0*t
     1         131*t29*t36*t69+1.7502740397772074d-1*t102*t29*t35*t54+2.
     2         0d+0*t129*t130*t29*t36+1.3127055298329054d-1*t106*t107*t2
     3         9*t35+3.446391616107778d-2*t100*t29
            t140 = 5.250822119331622d-1*t33*t38*t54*t55*t71*t72-1.0d+0*t
     1         135*t33*t39*t72+1.7502740397772074d-1*t102*t33*t38*t54+2.
     2         0d+0*t133*t134*t33*t39+1.3127055298329054d-1*t106*t107*t3
     3         3*t38+3.446391616107778d-2*t100*t33
            t141 = t65**2
            t142 = 1/t45**2
            t143 = 6.178834917961894d-1*t102*t54+4.63412618847142d-1*t10
     1         6*t107+t105
            fnc(iq) = 1.0d+0*rhob*t51*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t97*wght+1.0d+0*t51*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*(9.99999999999999d-1*(1.244
     1         8480831567728d+0*t100*t98*t99+2.5058979122369923d-2*t46*t
     2         52*(-6.203504908994001d-1*t143*t47*t66*t9+1.2407009817988
     3         002d+0*t141*t142*t47*t9+4.135669939329334d-1*t47*t52*t58*
     4         t65*t66+2.7571132928862224d-1*t109*t47*t52)-2.66731000727
     5         3315d-3*t31*t33*t71*t87*t88-7.002785192652656d-4*t138*t32
     6         *t54*t55*t88-2.667310007273315d-3*t140*t32*t87+4.43137376
     7         7749538d-3*t27*t29*t68*t85*t86+1.1634177699362593d-3*t137
     8         *t28*t54*t55*t86+4.431373767749538d-3*t139*t28*t85+2.2478
     9         670955426108d-3*t45*t47*t65*t83*t84+5.901575133296435d-4*
     :         t46*t54*t55*t84/t48**3+2.2478670955426108d-3*t46*(5.25082
     ;         2119331622d-1*t47*t48*t54*t55*t65*t66-1.0d+0*t143*t47*t49
     <         *t66+1.7502740397772074d-1*t102*t47*t48*t54+2.0d+0*t141*t
     =         142*t47*t49+1.3127055298329054d-1*t106*t107*t47*t48+3.446
     >         391616107778d-2*t100*t47)*t83+1.2690536516754763d-1*t102*
     ?         t54*t80*t82+9.517902387566071d-2*t106*t107*t80*t82-9.9953
     @         62477254237d-2*t100*t128*t82-9.690227711544375d-4*t56*t6*
     1         t63*t64*t8-5.011795824473985d-2*t52*t56*t59*t6*t8-1.61276
     2         25339649027d-1*t102*t54*t77*t79-1.2095719004736769d-1*t10
     3         6*t107*t77*t79+1.270249377985834d-1*t100*t125*t79-4.34650
     4         70592240396d-2*t102*t54*t74*t76-3.2598802944180294d-2*t10
     5         6*t107*t74*t76+3.4234103112606934d-2*t100*t76/t50**3-7.66
     6         2163788798045d-1*t100/(t50**5*t75**2)-2.5058979122369923d
     7         -2*t31*t33*t52*t71*t73-8.352993040789976d-3*t111*t32*t52*
     8         t73+5.011795824473985d-2*t27*t29*t52*t68*t70+1.6705986081
     9         57995d-2*t111*t28*t52*t70-2.544083100456872d-4*t112*t54*t
     :         55*t64*t7-9.690227711544375d-4*t113*t63*t7-1.670598608157
     ;         995d-2*t111*t52*t59*t7-5.011795824473985d-2*t110*t52*t7+2
     <         .5058979122369923d-2*t45*t47*t52*t65*t67+8.35299304078997
     =         6d-3*t111*t46*t52*t67+4.176057139642926d-2*t102*t54*t60*t
     >         62+3.1320428547321943d-2*t106*t107*t60*t62-3.289159980064
     ?         472d-2*t100*t101*t62-2.5058979122369923d-2*t136*t32*t52+5
     @         .011795824473985d-2*t132*t28*t52+1.372209729363942d-1*t10
     1         0*t126*t127-2.560822746052464d-4*t100*t123*t124)-1.244848
     2         0831567728d+0*t100*t98*t99+5.848223622634643d-1*(1.0d+0*(
     3         3.6490335179177674d-4*t18*t20*t89*t95*t96+9.5802129550325
     4         47d-5*t121*t19*t54*t55*t96+3.6490335179177674d-4*t122*t19
     5         *t95-6.393498539405557d-3*t102*t54*t92*t94-4.795123904554
     6         167d-3*t106*t107*t92*t94+5.035668532593766d-3*t100*t116*t
     7         94+2.722148880047894d-2*t18*t20*t52*t89*t91+9.07382960015
     8         9646d-3*t111*t19*t52*t91+1.709920934161365d+0*(2.66731000
     9         7273315d-3*t31*t33*t71*t87*t88+7.002785192652656d-4*t138*
     :         t32*t54*t55*t88+2.667310007273315d-3*t140*t32*t87-4.43137
     ;         3767749538d-3*t27*t29*t68*t85*t86-1.1634177699362593d-3*t
     <         137*t28*t54*t55*t86-4.431373767749538d-3*t139*t28*t85-1.2
     =         690536516754763d-1*t102*t54*t80*t82-9.517902387566071d-2*
     >         t106*t107*t80*t82+9.995362477254237d-2*t100*t128*t82+1.61
     ?         27625339649027d-1*t102*t54*t77*t79+1.2095719004736769d-1*
     @         t106*t107*t77*t79-1.270249377985834d-1*t100*t125*t79+2.50
     1         58979122369923d-2*t31*t33*t52*t71*t73+8.352993040789976d-
     2         3*t111*t32*t52*t73-5.011795824473985d-2*t27*t29*t52*t68*t
     3         70-1.670598608157995d-2*t111*t28*t52*t70+2.50589791223699
     4         23d-2*t136*t32*t52-5.011795824473985d-2*t132*t28*t52-1.37
     5         2209729363942d-1*t100*t126*t127+2.560822746052464d-4*t100
     6         *t123*t124)+2.722148880047894d-2*t120*t19*t52-2.255165148
     7         260897d-1*t100*t114*t115)-3.6490335179177674d-4*t18*t20*t
     8         89*t95*t96-9.580212955032547d-5*t121*t19*t54*t55*t96-3.64
     9         90335179177674d-4*t122*t19*t95+6.393498539405557d-3*t102*
     :         t54*t92*t94+4.795123904554167d-3*t106*t107*t92*t94-5.0356
     ;         68532593766d-3*t100*t116*t94-2.722148880047894d-2*t18*t20
     <         *t52*t89*t91-9.073829600159646d-3*t111*t19*t52*t91-2.7221
     =         48880047894d-2*t120*t19*t52+2.255165148260897d-1*t100*t11
     >         4*t115)+9.690227711544375d-4*t56*t6*t63*t64*t8+5.01179582
     ?         4473985d-2*t52*t56*t59*t6*t8+2.544083100456872d-4*t112*t5
     @         4*t55*t64*t7+9.690227711544375d-4*t113*t63*t7+1.670598608
     1         157995d-2*t111*t52*t59*t7+5.011795824473985d-2*t110*t52*t
     2         7-4.176057139642926d-2*t102*t54*t60*t62-3.132042854732194
     3         3d-2*t106*t107*t60*t62+3.289159980064472d-2*t100*t101*t62
     4         )*wght+2.0d+0*t97*wght+Amat2(iq,D2_RB_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vwn2 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{\sqrt{{\it t_2}}}}\\\\ 
C>   {\it t_4} &=& 1.575246635799487\,{\it t_3}\\\\ 
C>   {\it t_5} &=& \arctan \left({{6.15199081975908}\over{{\it t_4}
C>    +3.72744}}\right)\\\\ 
C>   {\it t_6} &=& 0.7876233178997433\,{\it t_3}\\\\ 
C>   {\it t_7} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_8} &=& 0.6203504908994001\,{\it t_7}\\\\ 
C>   {\it t_9} &=& {{1}\over{\left| 2.935818660072219\,{\it t_3}+{
C>    \it t_8}+12.9352\right| }}\\\\ 
C>   {\it t_{10}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.10498\right)^2\,{\it t_9}\right)\\\\ 
C>   {\it t_{11}} &=& \left| {\it t_7}\right| \\\\ 
C>   {\it t_{12}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_9}\right)\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{15}} &=& \left({\it t_{13}}\,{\it t_{14}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{13}}\,{
C>    \it t_{14}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{16}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_4}+1.06835}}\right)\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\left| 0.8414573716781907\,{\it t_3}
C>    +{\it t_8}+11.4813\right| }}\\\\ 
C>   {\it t_{18}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.228344\right)^2\,{\it t_{17}}\right)\\\\ 
C>   {\it t_{19}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{17}}\right)\\\\ 
C>   {\it t_{20}} &=& \arctan \left({{0.0448998886415768}\over{{
C>    \it t_4}+13.072}}\right)\\\\ 
C>   {\it t_{21}} &=& \arctan \left({{1.171685277708971}\over{{
C>    \it t_4}+20.1231}}\right)\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\left| 10.29581201158544\,{\it t_3}
C>    +{\it t_8}+42.7198\right| }}\\\\ 
C>   {\it t_{23}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.409286\right)^2\,{\it t_{22}}\right)\\\\ 
C>   {\it t_{24}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{22}}\right)\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\left| 15.84942278842832\,{\it t_3}
C>    +{\it t_8}+101.578\right| }}\\\\ 
C>   {\it t_{26}} &=& \log \left(1.0\,\left({\it t_6}
C>    +0.743294\right)^2\,{\it t_{25}}\right)\\\\ 
C>   {\it t_{27}} &=& \log \left(0.6203504908994001\,{\it t_{11}}
C>    \,{\it t_{25}}\right)\\\\ 
C>   {\it t_{28}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_3}
C>    +{\it t_8}+18.0578\right| }}\\\\ 
C>   {\it t_{29}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{30}} &=& {{1}\over{\sqrt{{\it t_{29}}}}}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{29}}}}\\\\ 
C>   {\it t_{32}} &=& 0.6203504908994001\,{\it t_{31}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\left| {\it t_{32}}
C>    +2.935818660072219\,{\it t_{30}}+12.9352\right| }}\\\\ 
C>   {\it t_{34}} &=& \left| {\it t_{31}}\right| \\\\ 
C>   {\it t_{35}} &=& \log \left(0.6203504908994001\,{\it t_{33}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{36}} &=& 0.7876233178997433\,{\it t_{30}}\\\\ 
C>   {\it t_{37}} &=& \log \left(1.0\,{\it t_{33}}\,\left({\it t_{36}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{38}} &=& 1.575246635799487\,{\it t_{30}}\\\\ 
C>   {\it t_{39}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{38}}+3.72744}}\right)\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\left| {\it t_{32}}
C>    +0.8414573716781907\,{\it t_{30}}+11.4813\right| }}\\\\ 
C>   {\it t_{41}} &=& \log \left(0.6203504908994001\,{\it t_{40}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{42}} &=& \log \left(1.0\,{\it t_{40}}\,\left({\it t_{36}}
C>    +0.228344\right)^2\right)\\\\ 
C>   {\it t_{43}} &=& \arctan \left({{6.692072046645942}\over{{
C>    \it t_{38}}+1.06835}}\right)\\\\ 
C>   {\it t_{44}} &=& {{1}\over{\left| {\it t_{32}}
C>    +10.29581201158544\,{\it t_{30}}+42.7198\right| }}\\\\ 
C>   {\it t_{45}} &=& \log \left(0.6203504908994001\,{\it t_{44}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{46}} &=& {{1}\over{\left| {\it t_{32}}
C>    +15.84942278842832\,{\it t_{30}}+101.578\right| }}\\\\ 
C>   {\it t_{47}} &=& \log \left(0.6203504908994001\,{\it t_{46}}
C>    \,{\it t_{34}}\right)\\\\ 
C>   {\it t_{48}} &=& \log \left(1.0\,{\it t_{44}}\,\left({\it t_{36}}
C>    +0.409286\right)^2\right)\\\\ 
C>   {\it t_{49}} &=& \log \left(1.0\,{\it t_{46}}\,\left({\it t_{36}}
C>    +0.743294\right)^2\right)\\\\ 
C>   {\it t_{50}} &=& \arctan \left({{0.0448998886415768}\over{{
C>    \it t_{38}}+13.072}}\right)\\\\ 
C>   {\it t_{51}} &=& \arctan \left({{1.171685277708971}\over{{
C>    \it t_{38}}+20.1231}}\right)\\\\ 
C>   {\it t_{52}} &=& {{1}\over{\left| {\it t_{32}}
C>    +5.560951426165705\,{\it t_{30}}+18.0578\right| }}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(1.923661050931536\,{\it t_{15}}
C>    \,\left(-0.01554535\,{\it t_{27}}-0.002667310007273315\,{
C>    \it t_{26}}+0.0310907\,{\it t_{24}}+0.004431373767749538\,{
C>    \it t_{23}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{11}}\,{\it t_{28}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_6}+0.325\right)^2\,{
C>    \it t_{28}}\right)-0.0310907\,{\it t_{12}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{10}}
C>    -0.6188180297906176\,{\it t_{21}}+20.52197293770518\,{
C>    \it t_{20}}+0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_4}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_5}\right)+1.125\,{\it t_{15}}
C>    \,\left({{{\it t_{13}}^4\,\left(1.709920934161365\,
C>    \left(0.01554535\,{\it t_{27}}+0.002667310007273315\,{
C>    \it t_{26}}-0.0310907\,{\it t_{24}}-0.004431373767749538\,{
C>    \it t_{23}}+0.6188180297906176\,{\it t_{21}}-20.52197293770518
C>    \,{\it t_{20}}\right)+0.01688686394038963\,{\it t_{19}}
C>    +3.649033517917767 \times 10^{-4}\,{\it t_{18}}
C>    +0.005458482358638966\,{\it t_{16}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{19}}-3.649033517917767 \times 10^{
C>    -4}\,{\it t_{18}}-0.005458482358638966\,{\it t_{16}}\right)
C>    +0.0310907\,{\it t_{12}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{10}}+0.03878329487811301\,{\it t_5}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.999999999999999\,\left(-0.6188180297906176
C>    \,{\it t_{51}}+20.52197293770518\,{\it t_{50}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_{38}}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_{39}}-0.002667310007273315\,{\it t_{49}}
C>    +0.004431373767749538\,{\it t_{48}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{52}}\,\left({\it t_{36}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{37}}-0.01554535\,{\it t_{47}}+0.0310907\,{\it t_{45}}
C>    +0.01554535\,\log \left(0.6203504908994001\,{\it t_{52}}\,{
C>    \it t_{34}}\right)-0.0310907\,{\it t_{35}}\right)
C>    +0.5848223622634643\,\left(1.0\,\left(1.709920934161365
C>    \,\left(0.6188180297906176\,{\it t_{51}}-20.52197293770518
C>    \,{\it t_{50}}+0.002667310007273315\,{\it t_{49}}
C>    -0.004431373767749538\,{\it t_{48}}+0.01554535\,{\it t_{47}}
C>    -0.0310907\,{\it t_{45}}\right)+0.005458482358638966\,{
C>    \it t_{43}}+3.649033517917767 \times 10^{-4}\,{\it t_{42}}
C>    +0.01688686394038963\,{\it t_{41}}\right)-0.005458482358638966
C>    \,{\it t_{43}}-3.649033517917767 \times 10^{-4}\,{\it t_{42}}
C>    -0.01688686394038963\,{\it t_{41}}\right)+0.03878329487811301
C>    \,{\it t_{39}}+9.690227711544375 \times 10^{-4}\,{\it t_{37}}
C>    +0.0310907\,{\it t_{35}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] SH Vosko, L Wilk, M Nusair, Can.J.Phys. 58, 1200 (1980)  , DOI: 
C> <a href="https://doi.org/10.1139/p80-159 "> 
C> 10.1139/p80-159 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_vwn2_d3(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2,Amat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 4.9237251092134837d-1*t4
            t6 = 1/abs(t5+2.615517080950829d+0*t3+1.29352d+1)
            t7 = abs(t4)
            t8 = t5+2.615517080950828d+0*t3+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = log(4.9237251092134837d-1*t10*t7)
            t12 = 7.016926042943222d-1*t3
            t13 = t12+1.0498d-1
            t14 = t13**2
            t15 = log(1.0d+0*t10*t14)
            t16 = 1.4033852085886445d+0*t3
            t17 = t16+3.72744d+0
            t18 = atan(6.15199081975908d+0/t17)
            t19 = 1/t7
            t20 = -8.206208515355806d-2/rhoa**1.3333333333333333d+0
            t21 = 1/t2**3
            t22 = 1/rhoa**6.666666666666667d-1
            t23 = t20-2.1795975674590234d-1*t21*t22
            t24 = 1/t8
            t25 = 1/rhoa**1.6666666666666666d+0
            t26 = -4.9237251092134837d-1*t10*t23*t24*t7-8.20620851535580
     1         6d-2*t10*t19*t25
            t27 = 1/t17**2
            t28 = 3.784699104639999d+1*t27+1
            t29 = 1/t28
            t30 = 1/t14
            t31 = -1.0d+0*t10*t14*t23*t24-1.1694876738238703d-1*t10*t13*
     1         t21*t22
            t32 = 9.690227711544375d-4*t30*t31*t9+6.314467057030004d-2*t
     1         19*t26*t9+2.790332964441521d-2*t21*t22*t27*t29
            t33 = 2.0d+0*t32*wght
            t34 = 1/t28**2
            t35 = 1/t17**5
            t36 = 1/rhoa**2.3333333333333334d+0
            t37 = -2.470091445929572d-1*t34*t35*t36
            t38 = 1/t17**3
            t39 = 6.526520015557556d-3*t29*t36*t38
            t40 = t5+7.496532937978391d-1*t3+1.14813d+1
            t41 = abs(t40)
            t42 = 1/t41
            t43 = t12+2.28344d-1
            t44 = t43**2
            t45 = t16+1.0683499999999999d+0
            t46 = -1.688686394038963d-2*log(4.9237251092134837d-1*t42*t7
     1         )-5.458482358638966d-3*atan(6.692072046645942d+0/t45)-3.6
     2         490335179177674d-4*log(1.0d+0*t42*t44)
            t47 = 1/rhoa**2
            t48 = t5+4.9542444972117183d+0*t3+1.8057800000000002d+1
            t49 = abs(t48)
            t50 = 1/t49
            t51 = t5+9.17252572333538d+0*t3+4.2719799999999997d+1
            t52 = abs(t51)
            t53 = 1/t52
            t54 = t5+1.4120230445475074d+1*t3+1.01578d+2
            t55 = abs(t54)
            t56 = 1/t55
            t57 = t12+3.25d-1
            t58 = t57**2
            t59 = t12+4.09286d-1
            t60 = t59**2
            t61 = t12+7.43294d-1
            t62 = t61**2
            t63 = t16+7.06042d+0
            t64 = t16+1.3072d+1
            t65 = t16+2.0123100000000002d+1
            t66 = -1.554535d-2*log(4.9237251092134837d-1*t56*t7)+3.10907
     1         d-2*log(4.9237251092134837d-1*t53*t7)+1.554535d-2*log(4.9
     2         237251092134837d-1*t50*t7)-6.188180297906176d-1*atan(1.17
     3         1685277708971d+0/t65)+2.052197293770518d+1*atan(4.4899888
     4         641576796d-2/t64)+5.249139316978092d-2*atan(4.73092690956
     5         01136d+0/t63)-2.667310007273315d-3*log(1.0d+0*t56*t62)+4.
     6         431373767749538d-3*log(1.0d+0*t53*t60)+2.2478670955426108
     7         d-3*log(1.0d+0*t50*t58)-3.8783294878113006d-2*t18-9.69022
     8         7711544375d-4*t15-3.10907d-2*t11
            t67 = 1/rhoa**1.6666666666666669d+0
            t68 = -9.301109881471736d-3*t21*t27*t29*t67
            t69 = t23**2
            t70 = 1/t8**2
            t71 = 1/t2**5
            t72 = 1/rhoa**1.3333333333333336d+0
            t73 = 5.448993918647558d-2*t71*t72+7.265325224863413d-2*t21*
     1         t67+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t74 = 1/rhoa**2.6666666666666666d+0
            t75 = 5.470805676903869d-2*t10*t19*t74-4.9237251092134837d-1
     1         *t10*t24*t7*t73+9.847450218426967d-1*t10*t69*t7*t70+1.641
     2         2417030711612d-1*t10*t19*t23*t24*t25
            t76 = 6.314467057030004d-2*t19*t75*t9
            t77 = -6.975832411103801d-3*t27*t29*t71*t72
            t78 = 1/rhoa**9.999999999999999d-1
            t79 = 1.0524111761716676d-2*t19*t26*t78*t9
            t80 = 1/t13**3
            t81 = 1.1332601865197636d-4*t21*t22*t31*t80*t9
            t82 = -1.0d+0*t10*t14*t24*t73+2.923719184559675d-2*t10*t13*t
     1         71*t72+2.0d+0*t10*t14*t69*t70+3.898292246079568d-2*t10*t1
     2         3*t21*t67+6.838507096129838d-3*t10*t36+2.3389753476477407
     3         d-1*t10*t13*t21*t22*t23*t24
            t83 = 9.690227711544375d-4*t30*t82*t9
            t84 = 6.314467057030004d-2*t10*t19*t23*t26*t8
            t85 = 9.690227711544375d-4*t10*t23*t30*t31*t8
            t86 = t85+t84+t83+t81+t79+t77+t76+t68+4.274802335403413d-1*t
     1         47*t66+2.5000000000000006d-1*t46*t47+t39+t37
            t87 = t85+t84+t83+t81+t79+t77+t76+t68-4.274802335403413d-1*t
     1         47*t66-2.5000000000000006d-1*t46*t47+t39+t37
            t88 = 1/rhoa**3.3333333333333337d+0
            t89 = 4.3226600303767515d-1*t34*t35*t88
            t90 = -1.1421410027225727d-2*t29*t38*t88
            t91 = 1/rhoa**3
            t92 = 1/rhoa**3.0d+0
            t93 = 4.3732069462725337d+0*t21*t92/(t17**8*t28**3)
            t94 = -2.022119049462691d-1*t21*t34*t92/t17**6
            t95 = 2.289805413347801d-3*t21*t29*t92/t17**4
            t96 = 1/rhoa**2.666666666666667d+0
            t97 = 7.750924901226445d-3*t21*t27*t29*t96
            t98 = 6.975832411103802d-3*t27*t29*t36*t71
            t99 = 1.988000729055306d-5*t31*t36*t9/t13**4
            t100 = t20-6.247110781648659d-2*t21*t22
            t101 = 1/t40
            t102 = 1/t45**2
            t103 = -3.429692674920095d-2*t19*t41*(-4.9237251092134837d-1
     1         *t100*t101*t42*t7-8.206208515355806d-2*t19*t25*t42)-3.649
     2         0335179177674d-4*t41*(-1.0d+0*t100*t101*t42*t44-1.1694876
     3         738238703d-1*t21*t22*t42*t43)/t44-4.2719697398914064d-3*t
     4         102*t21*t22/(4.4783828277500004d+1*t102+1)
            t104 = t20-4.128537081009765d-1*t21*t22
            t105 = 1/t48
            t106 = t20-7.643771436112816d-1*t21*t22
            t107 = 1/t51
            t108 = t20-1.1766858704562562d+0*t21*t22
            t109 = 1/t54
            t110 = 1/t63**2
            t111 = 1/t64**2
            t112 = 1/t65**2
            t113 = -9.690227711544375d-4*t30*t31*t9-6.314467057030004d-2
     1         *t19*t26*t9-3.157233528515002d-2*t19*t55*(-4.923725109213
     2         4837d-1*t108*t109*t56*t7-8.206208515355806d-2*t19*t25*t56
     3         )+6.314467057030004d-2*t19*t52*(-4.9237251092134837d-1*t1
     4         06*t107*t53*t7-8.206208515355806d-2*t19*t25*t53)+3.157233
     5         528515002d-2*t19*t49*(-4.9237251092134837d-1*t104*t105*t5
     6         0*t7-8.206208515355806d-2*t19*t25*t50)-2.667310007273315d
     7         -3*t55*(-1.0d+0*t108*t109*t56*t62-1.1694876738238703d-1*t
     8         21*t22*t56*t61)/t62+4.431373767749538d-3*t52*(-1.0d+0*t10
     9         6*t107*t53*t60-1.1694876738238703d-1*t21*t22*t53*t59)/t60
     :         +2.2478670955426108d-3*t49*(-1.0d+0*t104*t105*t50*t58-1.1
     ;         694876738238703d-1*t21*t22*t50*t57)/t58-2.790332964441521
     <         d-2*t21*t22*t27*t29-8.479487036467487d-2*t112*t21*t22/(1.
     =         3728463899999485d+0*t112+1)+1.0776060556305726d-1*t111*t2
     >         1*t22/(2.016000000025997d-3*t111+1)+2.904223175587974d-2*
     ?         t110*t21*t22/(2.238166942360001d+1*t110+1)
            t114 = 1/t2**7
            t115 = 1/rhoa**2.0d+0
            t116 = 2.906596837959916d-3*t114*t115*t27*t29
            t117 = -5.262055880858336d-3*t115*t19*t26*t9
            t118 = 1.7540186269527788d-3*t19*t26*t9/rhoa**1.999999999999
     1         9998d+0
            t119 = -3.7775339550658793d-5*t21*t31*t67*t80*t9
            t120 = t23**3
            t121 = 1/t8**3
            t122 = -6.054437687386176d-2*t21*t96-5.448993918647558d-2*t3
     1         6*t71-2.2704141327698155d-2*t114*t115-6.382606623054516d-
     2         2/rhoa**3.333333333333333d+0
            t123 = 6.314467057030004d-2*t19*(-1.6412417030711612d-1*t10*
     1         t19*t23*t24*t74+2.95423506552809d+0*t10*t23*t7*t70*t73+2.
     2         4618625546067416d-1*t10*t19*t24*t25*t73-4.923725109213483
     3         d-1*t10*t19*t25*t69*t70-4.9237251092134837d-1*t10*t122*t2
     4         4*t7-2.95423506552809d+0*t10*t120*t121*t7-6.3826066230545
     5         15d-2*t10*t19/rhoa**3.6666666666666664d+0)*t9
            t124 = -2.833150466299409d-5*t31*t71*t72*t80*t9
            t125 = 2.1048223523433351d-2*t19*t75*t78*t9
            t126 = 2.1048223523433351d-2*t10*t19*t23*t26*t78*t8
            t127 = 2.2665203730395272d-4*t21*t22*t80*t82*t9
            t128 = 2.2665203730395272d-4*t10*t21*t22*t23*t31*t8*t80
            t129 = 9.690227711544375d-4*t30*t9*(-3.2485768717329727d-2*t
     1         10*t13*t21*t96-1.1967387418227218d-2*t10*t88+6.0d+0*t10*t
     2         14*t23*t70*t73+3.508463021471611d-1*t10*t13*t21*t22*t24*t
     3         73-8.771157553679026d-2*t10*t13*t23*t24*t71*t72-2.9237191
     4         84559675d-2*t10*t13*t36*t71-7.016926042943222d-1*t10*t13*
     5         t21*t22*t69*t70-1.1694876738238703d-1*t10*t13*t21*t23*t24
     6         *t67-2.0515521288389513d-2*t10*t23*t24*t36-1.0d+0*t10*t12
     7         2*t14*t24-6.0d+0*t10*t120*t121*t14-1.2182163268998646d-2*
     8         t10*t114*t115*t13)
            t130 = 6.314467057030004d-2*t10*t19*t26*t73*t8
            t131 = 1.262893411406001d-1*t10*t19*t23*t75*t8
            t132 = 1.938045542308875d-3*t10*t23*t30*t8*t82
            t133 = 9.690227711544375d-4*t10*t30*t31*t73*t8
            fnc(iq) = 2.0d+0*rhoa*(3.10907d-2*log(4.9237251092134837d-1*
     1         t6*t7)+9.690227711544375d-4*log(1.0d+0*(7.016926042943223
     2         d-1*t3+1.0498d-1)**2*t6)+3.8783294878113006d-2*atan(6.151
     3         99081975908d+0/(1.4033852085886447d+0*t3+3.72744d+0)))*wg
     4         ht+fnc(iq)
            Amat(iq,D1_RA) = 2.0d+0*rhoa*t32*wght+1.0d+0*(3.878329487811
     1         3006d-2*t18+9.690227711544375d-4*t15+3.10907d-2*t11)*wght
     2         +Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t86*wght+t33+Amat2(iq,D2_RA
     1         _RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t87*wght+t33+Amat2(iq,D2_RA
     1         _RB)
            Amat3(iq,D3_RA_RA_RA) = 2.0d+0*rhoa*(t99+t98+t97+t95+t94+t93
     1         -1.2824407006210237d+0*t66*t91-7.5d-1*t46*t91+t90+t89+1.2
     2         82440700621024d+0*t113*t47+7.500000000000001d-1*t103*t47+
     3         t133+t132+t131+t130+t129+t128+t127+t126+t125+t124+t123+t1
     4         19+t118+t117+t116)*wght+3.0d+0*t86*wght+Amat3(iq,D3_RA_RA
     5         _RA)
            Amat3(iq,D3_RA_RA_RB) = 2.0d+0*rhoa*(t99+t98+t97+t95+t94+t93
     1         +4.274802335403413d-1*t66*t91+2.5000000000000006d-1*t46*t
     2         91+t90+t89-4.274802335403413d-1*t113*t47-2.50000000000000
     3         06d-1*t103*t47+t133+t132+t131+t130+t129+t128+t127+t126+t1
     4         25+t124+t123+t119+t118+t117+t116)*wght+2.0d+0*t87*wght+1.
     5         0d+0*t86*wght+Amat3(iq,D3_RA_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = t2**5.0d-1
            t4 = 1/t3
            t5 = 1.5752466357994865d+0*t4
            t6 = t5+3.72744d+0
            t7 = atan(6.15199081975908d+0/t6)
            t8 = 7.876233178997433d-1*t4
            t9 = t8+1.0498d-1
            t10 = t9**2
            t11 = 1/t2
            t12 = 6.203504908994001d-1*t11
            t13 = 2.935818660072219d+0*t4+t12+1.29352d+1
            t14 = abs(t13)
            t15 = 1/t14
            t16 = log(1.0d+0*t10*t15)
            t17 = abs(t11)
            t18 = log(6.203504908994001d-1*t15*t17)
            t19 = rhoa-rhob
            t20 = 1/t1
            t21 = 1.0d+0-t19*t20
            t22 = t19*t20+1.0d+0
            t23 = t22**1.3333333333333333d+0+t21**1.3333333333333333d+0-
     1         2.0d+0
            t24 = t5+1.0683499999999999d+0
            t25 = atan(6.692072046645942d+0/t24)
            t26 = t8+2.28344d-1
            t27 = t26**2
            t28 = 8.414573716781907d-1*t4+t12+1.14813d+1
            t29 = abs(t28)
            t30 = 1/t29
            t31 = log(1.0d+0*t27*t30)
            t32 = log(6.203504908994001d-1*t17*t30)
            t33 = t19**4
            t34 = 1/t1**4
            t35 = t5+1.3072d+1
            t36 = atan(4.4899888641576796d-2/t35)
            t37 = t5+2.0123100000000002d+1
            t38 = atan(1.171685277708971d+0/t37)
            t39 = t8+4.09286d-1
            t40 = t39**2
            t41 = 1.0295812011585444d+1*t4+t12+4.2719799999999997d+1
            t42 = abs(t41)
            t43 = 1/t42
            t44 = log(1.0d+0*t40*t43)
            t45 = log(6.203504908994001d-1*t17*t43)
            t46 = t8+7.43294d-1
            t47 = t46**2
            t48 = 1.5849422788428325d+1*t4+t12+1.01578d+2
            t49 = abs(t48)
            t50 = 1/t49
            t51 = log(1.0d+0*t47*t50)
            t52 = log(6.203504908994001d-1*t17*t50)
            t53 = 1.709920934161365d+0*(1.554535d-2*t52+2.66731000727331
     1         5d-3*t51-3.10907d-2*t45-4.431373767749538d-3*t44+6.188180
     2         297906176d-1*t38-2.052197293770518d+1*t36)+1.688686394038
     3         963d-2*t32+3.6490335179177674d-4*t31+5.458482358638966d-3
     4         *t25
            t54 = t33*t34*t53-1.688686394038963d-2*t32-3.649033517917767
     1         4d-4*t31-5.458482358638966d-3*t25
            t55 = t5+7.06042d+0
            t56 = t8+3.25d-1
            t57 = t56**2
            t58 = 5.560951426165704d+0*t4+t12+1.8057800000000002d+1
            t59 = abs(t58)
            t60 = 1/t59
            t61 = -3.8783294878113006d-2*t7+2.2478670955426108d-3*log(1.
     1         0d+0*t57*t60)+1.554535d-2*log(6.203504908994001d-1*t17*t6
     2         0)+5.249139316978092d-2*atan(4.7309269095601136d+0/t55)-1
     3         .554535d-2*t52-2.667310007273315d-3*t51+3.10907d-2*t45+4.
     4         431373767749538d-3*t44-6.188180297906176d-1*t38+2.0521972
     5         93770518d+1*t36-3.10907d-2*t18-9.690227711544375d-4*t16
            t62 = 3.8783294878113006d-2*t7+1.923661050931536d+0*t23*t61+
     1         1.1250000000000002d+0*t23*t54+3.10907d-2*t18+9.6902277115
     2         44375d-4*t16
            t63 = 1/t1**6.666666666666667d-1
            t64 = 1/t3**3
            t65 = 1/t6**2
            t66 = 3.784699104639999d+1*t65+1
            t67 = 1/t66
            t68 = 6.264085709464389d-2*t63*t64*t65*t67
            t69 = 1/t10
            t70 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t71 = t70-4.8930311001203647d-1*t63*t64
            t72 = 1/t13
            t73 = -2.625411059665811d-1*t15*t63*t64*t9-1.0d+0*t10*t15*t7
     1         1*t72
            t74 = 9.690227711544375d-4*t14*t69*t73
            t75 = 1/t17
            t76 = 1/t1**1.6666666666666666d+0
            t77 = -2.067834969664667d-1*t15*t75*t76-6.203504908994001d-1
     1         *t15*t17*t71*t72
            t78 = 5.011795824473985d-2*t14*t75*t77
            t79 = 1/t55**2
            t80 = 2.238166942360001d+1*t79+1
            t81 = 1/t80
            t82 = 1/t35**2
            t83 = 2.016000000025997d-3*t82+1
            t84 = 1/t83
            t85 = 1/t37**2
            t86 = 1.3728463899999485d+0*t85+1
            t87 = 1/t86
            t88 = 1/t57
            t89 = t70-9.26825237694284d-1*t63*t64
            t90 = 1/t58
            t91 = -1.0d+0*t57*t60*t89*t90-2.625411059665811d-1*t56*t60*t
     1         63*t64
            t92 = -6.203504908994001d-1*t17*t60*t89*t90-2.06783496966466
     1         7d-1*t60*t75*t76
            t93 = 1/t40
            t94 = t70-1.715968668597574d+0*t63*t64
            t95 = 1/t41
            t96 = -1.0d+0*t40*t43*t94*t95-2.625411059665811d-1*t39*t43*t
     1         63*t64
            t97 = -6.203504908994001d-1*t17*t43*t94*t95-2.06783496966466
     1         7d-1*t43*t75*t76
            t98 = 1/t47
            t99 = t70-2.641570464738054d+0*t63*t64
            t100 = 1/t48
            t101 = -1.0d+0*t100*t47*t50*t99-2.625411059665811d-1*t46*t50
     1         *t63*t64
            t102 = -6.203504908994001d-1*t100*t17*t50*t99-2.067834969664
     1         667d-1*t50*t75*t76
            t103 = -2.667310007273315d-3*t101*t49*t98+5.011795824473985d
     1         -2*t42*t75*t97+4.431373767749538d-3*t42*t93*t96+2.5058979
     2         122369923d-2*t59*t75*t92+2.2478670955426108d-3*t59*t88*t9
     3         1-1.9035804775132142d-1*t63*t64*t85*t87+2.419143800947353
     4         7d-1*t63*t64*t82*t84+6.519760588836059d-2*t63*t64*t79*t81
     5         -5.011795824473985d-2*t14*t75*t77-2.5058979122369923d-2*t
     6         102*t49*t75-9.690227711544375d-4*t14*t69*t73-6.2640857094
     7         64389d-2*t63*t64*t65*t67
            t104 = 1.923661050931536d+0*t103*t23
            t105 = 1/t24**2
            t106 = 4.4783828277500004d+1*t105+1
            t107 = 1/t106
            t108 = -9.590247809108334d-3*t105*t107*t63*t64
            t109 = 1/t27
            t110 = t70-1.4024289527969844d-1*t63*t64
            t111 = 1/t28
            t112 = -2.625411059665811d-1*t26*t30*t63*t64-1.0d+0*t110*t11
     1         1*t27*t30
            t113 = -3.6490335179177674d-4*t109*t112*t29
            t114 = -2.067834969664667d-1*t30*t75*t76-6.203504908994001d-
     1         1*t110*t111*t17*t30
            t115 = -2.722148880047894d-2*t114*t29*t75
            t116 = 1.709920934161365d+0*(2.667310007273315d-3*t101*t49*t
     1         98-5.011795824473985d-2*t42*t75*t97-4.431373767749538d-3*
     2         t42*t93*t96+1.9035804775132142d-1*t63*t64*t85*t87-2.41914
     3         38009473537d-1*t63*t64*t82*t84+2.5058979122369923d-2*t102
     4         *t49*t75)+2.722148880047894d-2*t114*t29*t75+9.59024780910
     5         8334d-3*t105*t107*t63*t64+3.6490335179177674d-4*t109*t112
     6         *t29
            t117 = t116*t33*t34
            t118 = 1/t1**5
            t119 = -4*t118*t33*t53
            t120 = t19**3
            t121 = 4*t120*t34*t53+t119+t117+t115+t113+t108
            t122 = 1/t1**2
            t123 = t122*t19
            t124 = -t20
            t125 = t124+t123
            t126 = t21**3.333333333333333d-1
            t127 = -t122*t19
            t128 = t20+t127
            t129 = t22**3.333333333333333d-1
            t130 = 1.3333333333333333d+0*t128*t129+1.3333333333333333d+0
     1         *t125*t126
            t131 = t78+t74+t68+1.923661050931536d+0*t130*t61+1.125000000
     1         0000002d+0*t130*t54+1.1250000000000002d+0*t121*t23+t104
            t132 = 1.0d+0*t62*wght
            t133 = -4*t120*t34*t53+t119+t117+t115+t113+t108
            t134 = t20+t123
            t135 = t127+t124
            t136 = 1.3333333333333333d+0*t129*t135+1.3333333333333333d+0
     1         *t126*t134
            t137 = t78+t74+t68+1.923661050931536d+0*t136*t61+1.125000000
     1         0000002d+0*t136*t54+1.1250000000000002d+0*t133*t23+t104
            t138 = 1/t1**2.3333333333333334d+0
            t139 = 1/t6**5
            t140 = 1/t66**2
            t141 = -1.2448480831567728d+0*t138*t139*t140
            t142 = 1/t6**3
            t143 = 3.289159980064472d-2*t138*t142*t67
            t144 = 1/t1**1.3333333333333336d+0
            t145 = 1/t3**5
            t146 = -3.1320428547321943d-2*t144*t145*t65*t67
            t147 = 1/t1**1.6666666666666669d+0
            t148 = -4.176057139642926d-2*t147*t64*t65*t67
            t149 = 9.690227711544375d-4*t13*t15*t69*t71*t73
            t150 = 5.011795824473985d-2*t13*t15*t71*t75*t77
            t151 = t71**2
            t152 = 1/t13**2
            t153 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t154 = 3.262020733413577d-1*t147*t64+t153+2.4465155500601823
     1         d-1*t144*t145
            t155 = 5.250822119331622d-1*t15*t63*t64*t71*t72*t9+1.7502740
     1         397772074d-1*t147*t15*t64*t9+1.3127055298329054d-1*t144*t
     2         145*t15*t9-1.0d+0*t10*t15*t154*t72+2.0d+0*t10*t15*t151*t1
     3         52+3.446391616107778d-2*t138*t15
            t156 = 9.690227711544375d-4*t14*t155*t69
            t157 = 1/t9**3
            t158 = 2.544083100456872d-4*t14*t157*t63*t64*t73
            t159 = 1/t1**2.6666666666666666d+0
            t160 = 4.135669939329334d-1*t15*t71*t72*t75*t76+2.7571132928
     1         862224d-1*t15*t159*t75-6.203504908994001d-1*t15*t154*t17*
     2         t72+1.2407009817988002d+0*t15*t151*t152*t17
            t161 = 5.011795824473985d-2*t14*t160*t75
            t162 = 1/t1**9.999999999999999d-1
            t163 = 1.670598608157995d-2*t14*t162*t75*t77
            t164 = 1/t55**5
            t165 = 1/t80**2
            t166 = 1/t55**3
            t167 = 1/t35**5
            t168 = 1/t83**2
            t169 = 1/t35**3
            t170 = 1/t37**5
            t171 = 1/t86**2
            t172 = 1/t37**3
            t173 = t89**2
            t174 = 1/t58**2
            t175 = 6.178834917961894d-1*t147*t64+t153+4.63412618847142d-
     1         1*t144*t145
            t176 = 5.250822119331622d-1*t56*t60*t63*t64*t89*t90-1.0d+0*t
     1         175*t57*t60*t90+1.7502740397772074d-1*t147*t56*t60*t64+2.
     2         0d+0*t173*t174*t57*t60+1.3127055298329054d-1*t144*t145*t5
     3         6*t60+3.446391616107778d-2*t138*t60
            t177 = 1/t56**3
            t178 = 4.135669939329334d-1*t60*t75*t76*t89*t90-6.2035049089
     1         94001d-1*t17*t175*t60*t90+2.7571132928862224d-1*t159*t60*
     2         t75+1.2407009817988002d+0*t17*t173*t174*t60
            t179 = t94**2
            t180 = 1/t41**2
            t181 = 1.1439791123983827d+0*t147*t64+t153+8.57984334298787d
     1         -1*t144*t145
            t182 = 5.250822119331622d-1*t39*t43*t63*t64*t94*t95-1.0d+0*t
     1         181*t40*t43*t95+1.7502740397772074d-1*t147*t39*t43*t64+2.
     2         0d+0*t179*t180*t40*t43+1.3127055298329054d-1*t144*t145*t3
     3         9*t43+3.446391616107778d-2*t138*t43
            t183 = 1/t39**3
            t184 = 4.135669939329334d-1*t43*t75*t76*t94*t95-6.2035049089
     1         94001d-1*t17*t181*t43*t95+2.7571132928862224d-1*t159*t43*
     2         t75+1.2407009817988002d+0*t17*t179*t180*t43
            t185 = t99**2
            t186 = 1/t48**2
            t187 = 1.761046976492036d+0*t147*t64+t153+1.320785232369027d
     1         +0*t144*t145
            t188 = 5.250822119331622d-1*t100*t46*t50*t63*t64*t99+1.75027
     1         40397772074d-1*t147*t46*t50*t64-1.0d+0*t100*t187*t47*t50+
     2         2.0d+0*t185*t186*t47*t50+1.3127055298329054d-1*t144*t145*
     3         t46*t50+3.446391616107778d-2*t138*t50
            t189 = 1/t46**3
            t190 = 4.135669939329334d-1*t100*t50*t75*t76*t99+2.757113292
     1         8862224d-1*t159*t50*t75-6.203504908994001d-1*t100*t17*t18
     2         7*t50+1.2407009817988002d+0*t17*t185*t186*t50
            t191 = -2.667310007273315d-3*t101*t48*t50*t98*t99-2.50589791
     1         22369923d-2*t102*t48*t50*t75*t99-2.667310007273315d-3*t18
     2         8*t49*t98+5.011795824473985d-2*t41*t43*t75*t94*t97+1.6705
     3         98608157995d-2*t162*t42*t75*t97+4.431373767749538d-3*t41*
     4         t43*t93*t94*t96+1.1634177699362593d-3*t183*t42*t63*t64*t9
     5         6+4.431373767749538d-3*t182*t42*t93+2.5058979122369923d-2
     6         *t58*t60*t75*t89*t92+8.352993040789976d-3*t162*t59*t75*t9
     7         2+2.2478670955426108d-3*t58*t60*t88*t89*t91+5.90157513329
     8         6435d-4*t177*t59*t63*t64*t91+2.2478670955426108d-3*t176*t
     9         59*t88+1.2690536516754763d-1*t147*t64*t85*t87+9.517902387
     :         566071d-2*t144*t145*t85*t87-9.995362477254237d-2*t138*t17
     ;         2*t87-1.6127625339649027d-1*t147*t64*t82*t84-1.2095719004
     <         736769d-1*t144*t145*t82*t84+1.270249377985834d-1*t138*t16
     =         9*t84-4.3465070592240396d-2*t147*t64*t79*t81-3.2598802944
     >         180294d-2*t144*t145*t79*t81+3.4234103112606934d-2*t138*t1
     ?         66*t81-5.011795824473985d-2*t13*t15*t71*t75*t77-1.6705986
     @         08157995d-2*t14*t162*t75*t77+2.5058979122369923d-2*t178*t
     1         59*t75-2.5058979122369923d-2*t190*t49*t75-8.3529930407899
     2         76d-3*t102*t162*t49*t75+5.011795824473985d-2*t184*t42*t75
     3         -5.011795824473985d-2*t14*t160*t75-9.690227711544375d-4*t
     4         13*t15*t69*t71*t73-2.544083100456872d-4*t14*t157*t63*t64*
     5         t73-9.690227711544375d-4*t14*t155*t69+4.176057139642926d-
     6         2*t147*t64*t65*t67+3.1320428547321943d-2*t144*t145*t65*t6
     7         7-3.289159980064472d-2*t138*t142*t67-7.002785192652656d-4
     8         *t101*t189*t49*t63*t64+1.372209729363942d-1*t138*t170*t17
     9         1-2.560822746052464d-4*t138*t167*t168-7.662163788798045d-
     :         1*t138*t164*t165+1.2448480831567728d+0*t138*t139*t140
            t192 = 1.923661050931536d+0*t191*t23
            t193 = 1/t24**5
            t194 = 1/t106**2
            t195 = 2.255165148260897d-1*t138*t193*t194
            t196 = 1/t24**3
            t197 = -5.035668532593766d-3*t107*t138*t196
            t198 = 4.795123904554167d-3*t105*t107*t144*t145
            t199 = 6.393498539405557d-3*t105*t107*t147*t64
            t200 = -3.6490335179177674d-4*t109*t110*t112*t28*t30
            t201 = -2.722148880047894d-2*t110*t114*t28*t30*t75
            t202 = t110**2
            t203 = 1/t28**2
            t204 = 9.349526351979897d-2*t147*t64+t153+7.012144763984922d
     1         -2*t144*t145
            t205 = 5.250822119331622d-1*t110*t111*t26*t30*t63*t64+1.7502
     1         740397772074d-1*t147*t26*t30*t64-1.0d+0*t111*t204*t27*t30
     2         +2.0d+0*t202*t203*t27*t30+1.3127055298329054d-1*t144*t145
     3         *t26*t30+3.446391616107778d-2*t138*t30
            t206 = -3.6490335179177674d-4*t109*t205*t29
            t207 = 1/t26**3
            t208 = -9.580212955032547d-5*t112*t207*t29*t63*t64
            t209 = 4.135669939329334d-1*t110*t111*t30*t75*t76+2.75711329
     1         28862224d-1*t159*t30*t75-6.203504908994001d-1*t111*t17*t2
     2         04*t30+1.2407009817988002d+0*t17*t202*t203*t30
            t210 = -2.722148880047894d-2*t209*t29*t75
            t211 = -9.073829600159646d-3*t114*t162*t29*t75
            t212 = -8*t116*t118*t33
            t213 = 1.709920934161365d+0*(2.667310007273315d-3*t101*t48*t
     1         50*t98*t99+2.5058979122369923d-2*t102*t48*t50*t75*t99+2.6
     2         67310007273315d-3*t188*t49*t98-5.011795824473985d-2*t41*t
     3         43*t75*t94*t97-1.670598608157995d-2*t162*t42*t75*t97-4.43
     4         1373767749538d-3*t41*t43*t93*t94*t96-1.1634177699362593d-
     5         3*t183*t42*t63*t64*t96-4.431373767749538d-3*t182*t42*t93-
     6         1.2690536516754763d-1*t147*t64*t85*t87-9.517902387566071d
     7         -2*t144*t145*t85*t87+9.995362477254237d-2*t138*t172*t87+1
     8         .6127625339649027d-1*t147*t64*t82*t84+1.2095719004736769d
     9         -1*t144*t145*t82*t84-1.270249377985834d-1*t138*t169*t84+2
     :         .5058979122369923d-2*t190*t49*t75+8.352993040789976d-3*t1
     ;         02*t162*t49*t75-5.011795824473985d-2*t184*t42*t75+7.00278
     <         5192652656d-4*t101*t189*t49*t63*t64-1.372209729363942d-1*
     =         t138*t170*t171+2.560822746052464d-4*t138*t167*t168)+2.722
     >         148880047894d-2*t110*t114*t28*t30*t75+2.722148880047894d-
     ?         2*t209*t29*t75+9.073829600159646d-3*t114*t162*t29*t75+9.5
     @         80212955032547d-5*t112*t207*t29*t63*t64-6.393498539405557
     1         d-3*t105*t107*t147*t64+3.6490335179177674d-4*t109*t110*t1
     2         12*t28*t30+3.6490335179177674d-4*t109*t205*t29+5.03566853
     3         2593766d-3*t107*t138*t196-2.255165148260897d-1*t138*t193*
     4         t194-4.795123904554167d-3*t105*t107*t144*t145
            t214 = t213*t33*t34
            t215 = 1/t1**6
            t216 = 20*t215*t33*t53
            t217 = t19**2
            t218 = 12*t217*t34*t53
            t219 = -32*t118*t120*t53+8*t116*t120*t34+t218+t216+t214+t212
     1         +t211+t210+t208+t206+t201+t200+t199+t198+t197+t195
            t220 = t125**2
            t221 = 1/t21**6.666666666666666d-1
            t222 = 1/t1**3
            t223 = -2*t19*t222
            t224 = 2*t122
            t225 = t224+t223
            t226 = t128**2
            t227 = 1/t22**6.666666666666666d-1
            t228 = 2*t19*t222
            t229 = -2*t122
            t230 = t229+t228
            t231 = 1.3333333333333333d+0*t129*t230+4.444444444444444d-1*
     1         t226*t227+1.3333333333333333d+0*t126*t225+4.4444444444444
     2         44d-1*t220*t221
            t232 = 1.923661050931536d+0*t231*t61+1.1250000000000002d+0*t
     1         231*t54+1.1250000000000002d+0*t219*t23+t192+t163+t161+t15
     2         8+t156+t150+t149+t148+t146+t143+t141+2.2500000000000003d+
     3         0*t121*t130+3.847322101863072d+0*t103*t130
            t233 = -12*t217*t34*t53+t216+t214+t212+t211+t210+t208+t206+t
     1         201+t200+t199+t198+t197+t195
            t234 = 4.444444444444444d-1*t128*t135*t227+2.666666666666666
     1         6d+0*t129*t19*t222-2.6666666666666666d+0*t126*t19*t222+4.
     2         444444444444444d-1*t125*t134*t221
            t235 = 1.923661050931536d+0*t234*t61+1.1250000000000002d+0*t
     1         234*t54+1.1250000000000002d+0*t23*t233+t192+t163+t161+t15
     2         8+t156+t150+t149+t148+t146+t143+t141+1.1250000000000002d+
     3         0*t121*t136+1.923661050931536d+0*t103*t136+1.125000000000
     4         0002d+0*t130*t133+1.923661050931536d+0*t103*t130
            t236 = 32*t118*t120*t53-8*t116*t120*t34+t218+t216+t214+t212+
     1         t211+t210+t208+t206+t201+t200+t199+t198+t197+t195
            t237 = t134**2
            t238 = t229+t223
            t239 = t135**2
            t240 = t228+t224
            t241 = 1.3333333333333333d+0*t129*t240+4.444444444444444d-1*
     1         t227*t239+1.3333333333333333d+0*t126*t238+4.4444444444444
     2         44d-1*t221*t237
            t242 = 1.923661050931536d+0*t241*t61+1.1250000000000002d+0*t
     1         241*t54+1.1250000000000002d+0*t23*t236+t192+t163+t161+t15
     2         8+t156+t150+t149+t148+t146+t143+t141+2.2500000000000003d+
     3         0*t133*t136+3.847322101863072d+0*t103*t136
            t243 = 1/t1**3.0d+0
            t244 = 1/t6**8
            t245 = 1/t66**3
            t246 = 4.947718859586276d+1*t243*t244*t245*t64
            t247 = 1/t6**6
            t248 = -2.2877665475865033d+0*t140*t243*t247*t64
            t249 = 1/t1**3.3333333333333337d+0
            t250 = 4.3569682910487045d+0*t139*t140*t249
            t251 = 1/t6**4
            t252 = 2.590619096601433d-2*t243*t251*t64*t67
            t253 = -1.1512059930225654d-1*t142*t249*t67
            t254 = 1/t1**2.0d+0
            t255 = 1/t3**7
            t256 = 2.610035712276828d-2*t254*t255*t65*t67
            t257 = 6.26408570946439d-2*t138*t145*t65*t67
            t258 = 1/t1**2.666666666666667d+0
            t259 = 6.96009523273821d-2*t258*t64*t65*t67
            t260 = 1.938045542308875d-3*t13*t15*t155*t69*t71
            t261 = 5.088166200913744d-4*t13*t15*t157*t63*t64*t71*t73
            t262 = 9.690227711544375d-4*t13*t15*t154*t69*t73
            t263 = 1.002359164894797d-1*t13*t15*t160*t71*t75
            t264 = 5.011795824473985d-2*t13*t15*t154*t75*t77
            t265 = 3.34119721631599d-2*t13*t15*t162*t71*t75*t77
            t266 = t71**3
            t267 = 1/t13**3
            t268 = -6.433264350067851d-1/t1**3.333333333333333d+0
            t269 = -5.436701222355962d-1*t258*t64+t268-2.038762958383485
     1         1d-1*t254*t255-4.893031100120365d-1*t138*t145
            t270 = -5.250822119331622d-1*t147*t15*t64*t71*t72*t9-3.93811
     1         65894987163d-1*t144*t145*t15*t71*t72*t9+7.876233178997433
     2         d-1*t15*t154*t63*t64*t72*t9-1.5752466357994865d+0*t15*t15
     3         1*t152*t63*t64*t9-2.917123399628679d-1*t15*t258*t64*t9-1.
     4         0939212748607545d-1*t15*t254*t255*t9-2.625411059665811d-1
     5         *t138*t145*t15*t9-1.0339174848323335d-1*t138*t15*t71*t72-
     6         1.0d+0*t10*t15*t269*t72+6.0d+0*t10*t15*t152*t154*t71-6.0d
     7         +0*t10*t15*t266*t267-1.2062370656377225d-1*t15*t249
            t271 = 9.690227711544375d-4*t14*t270*t69
            t272 = 5.088166200913744d-4*t14*t155*t157*t63*t64
            t273 = 1/t9**4
            t274 = 1.0018895862972538d-4*t138*t14*t273*t73
            t275 = -1.272041550228436d-4*t14*t144*t145*t157*t73
            t276 = -1.696055400304582d-4*t14*t147*t157*t64*t73
            t277 = 1/t1**3.6666666666666664d+0
            t278 = 6.203504908994001d-1*t15*t154*t72*t75*t76-1.240700981
     1         7988002d+0*t15*t151*t152*t75*t76-8.271339878658668d-1*t15
     2         *t159*t71*t72*t75-6.433264350067852d-1*t15*t277*t75-6.203
     3         504908994001d-1*t15*t17*t269*t72+3.7221029453964005d+0*t1
     4         5*t152*t154*t17*t71-3.7221029453964005d+0*t15*t17*t266*t2
     5         67
            t279 = 5.011795824473985d-2*t14*t278*t75
            t280 = 3.34119721631599d-2*t14*t160*t162*t75
            t281 = -1.6705986081579946d-2*t14*t254*t75*t77
            t282 = 1/t1**1.9999999999999998d+0
            t283 = 5.568662027193316d-3*t14*t282*t75*t77
            t284 = 1/t35**8
            t285 = 1/t83**3
            t286 = 1/t35**6
            t287 = 1/t35**4
            t288 = 1/t37**8
            t289 = 1/t86**3
            t290 = 1/t37**6
            t291 = 1/t37**4
            t292 = t89**3
            t293 = 1/t58**3
            t294 = -1.0298058196603158d+0*t258*t64+t268-3.86177182372618
     1         33d-1*t254*t255-9.26825237694284d-1*t138*t145
            t295 = t94**3
            t296 = 1/t41**3
            t297 = -1.9066318539973046d+0*t258*t64+t268-7.14986945248989
     1         1d-1*t254*t255-1.715968668597574d+0*t138*t145
            t298 = -5.250822119331622d-1*t147*t39*t43*t64*t94*t95-3.9381
     1         165894987163d-1*t144*t145*t39*t43*t94*t95-1.0339174848323
     2         335d-1*t138*t43*t94*t95+7.876233178997433d-1*t181*t39*t43
     3         *t63*t64*t95-1.0d+0*t297*t40*t43*t95+6.0d+0*t180*t181*t40
     4         *t43*t94-1.5752466357994865d+0*t179*t180*t39*t43*t63*t64-
     5         2.917123399628679d-1*t258*t39*t43*t64-6.0d+0*t295*t296*t4
     6         0*t43-1.0939212748607545d-1*t254*t255*t39*t43-2.625411059
     7         665811d-1*t138*t145*t39*t43-1.2062370656377225d-1*t249*t4
     8         3
            t299 = 1/t39**4
            t300 = -8.271339878658668d-1*t159*t43*t75*t94*t95+6.20350490
     1         8994001d-1*t181*t43*t75*t76*t95-6.203504908994001d-1*t17*
     2         t297*t43*t95+3.7221029453964005d+0*t17*t180*t181*t43*t94-
     3         1.2407009817988002d+0*t179*t180*t43*t75*t76-6.43326435006
     4         7852d-1*t277*t43*t75-3.7221029453964005d+0*t17*t295*t296*
     5         t43
            t301 = t99**3
            t302 = 1/t48**3
            t303 = -2.9350782941533937d+0*t258*t64+t268-1.10065436030752
     1         25d+0*t254*t255-2.6415704647380545d+0*t138*t145
            t304 = -5.250822119331622d-1*t100*t147*t46*t50*t64*t99+6.0d+
     1         0*t186*t187*t47*t50*t99-3.9381165894987163d-1*t100*t144*t
     2         145*t46*t50*t99-1.0339174848323335d-1*t100*t138*t50*t99+7
     3         .876233178997433d-1*t100*t187*t46*t50*t63*t64-1.575246635
     4         7994865d+0*t185*t186*t46*t50*t63*t64-2.917123399628679d-1
     5         *t258*t46*t50*t64-1.0d+0*t100*t303*t47*t50-6.0d+0*t301*t3
     6         02*t47*t50-1.0939212748607545d-1*t254*t255*t46*t50-2.6254
     7         11059665811d-1*t138*t145*t46*t50-1.2062370656377225d-1*t2
     8         49*t50
            t305 = 1/t46**4
            t306 = -8.271339878658668d-1*t100*t159*t50*t75*t99+3.7221029
     1         453964005d+0*t17*t186*t187*t50*t99+6.203504908994001d-1*t
     2         100*t187*t50*t75*t76-1.2407009817988002d+0*t185*t186*t50*
     3         t75*t76-6.433264350067852d-1*t277*t50*t75-6.2035049089940
     4         01d-1*t100*t17*t303*t50-3.7221029453964005d+0*t17*t301*t3
     5         02*t50
            t307 = 1.923661050931536d+0*t23*(-5.33462001454663d-3*t188*t
     1         48*t50*t98*t99-5.011795824473985d-2*t190*t48*t50*t75*t99-
     2         1.670598608157995d-2*t102*t162*t48*t50*t75*t99-1.40055703
     3         8530531d-3*t101*t189*t48*t50*t63*t64*t99-2.66731000727331
     4         5d-3*t101*t187*t48*t50*t98-2.667310007273315d-3*t304*t49*
     5         t98+3.34119721631599d-2*t162*t41*t43*t75*t94*t97+5.011795
     6         824473985d-2*t181*t41*t43*t75*t97+5.568662027193316d-3*t2
     7         82*t42*t75*t97-1.6705986081579946d-2*t254*t42*t75*t97+2.3
     8         268355398725185d-3*t183*t41*t43*t63*t64*t94*t96+4.4313737
     9         67749538d-3*t181*t41*t43*t93*t96-7.756118466241728d-4*t14
     :         7*t183*t42*t64*t96+4.5816748203035834d-4*t138*t299*t42*t9
     ;         6-5.817088849681296d-4*t144*t145*t183*t42*t96+8.862747535
     <         499076d-3*t182*t41*t43*t93*t94+1.002359164894797d-1*t184*
     =         t41*t43*t75*t94+4.431373767749538d-3*t298*t42*t93+1.67059
     >         8608157995d-2*t162*t58*t60*t75*t89*t92+2.5058979122369923
     ?         d-2*t175*t58*t60*t75*t92+2.784331013596658d-3*t282*t59*t7
     @         5*t92-8.352993040789973d-3*t254*t59*t75*t92+1.18031502665
     1         92868d-3*t177*t58*t60*t63*t64*t89*t91+2.2478670955426108d
     2         -3*t175*t58*t60*t88*t91-3.934383422197623d-4*t147*t177*t5
     3         9*t64*t91+2.3241090936607786d-4*t138*t59*t91/t56**4-2.950
     4         7875666482175d-4*t144*t145*t177*t59*t91+2.505897912236992
     5         3d-2*t59*t75*(-8.271339878658668d-1*t159*t60*t75*t89*t90+
     6         6.203504908994001d-1*t175*t60*t75*t76*t90-6.2035049089940
     7         01d-1*t17*t294*t60*t90+3.7221029453964005d+0*t17*t174*t17
     8         5*t60*t89-1.2407009817988002d+0*t173*t174*t60*t75*t76-6.4
     9         33264350067852d-1*t277*t60*t75-3.7221029453964005d+0*t17*
     :         t292*t293*t60)+2.2478670955426108d-3*t59*t88*(-5.25082211
     ;         9331622d-1*t147*t56*t60*t64*t89*t90-3.9381165894987163d-1
     <         *t144*t145*t56*t60*t89*t90-1.0339174848323335d-1*t138*t60
     =         *t89*t90+7.876233178997433d-1*t175*t56*t60*t63*t64*t90-1.
     >         0d+0*t294*t57*t60*t90+6.0d+0*t174*t175*t57*t60*t89-1.5752
     ?         466357994865d+0*t173*t174*t56*t60*t63*t64-2.9171233996286
     @         79d-1*t258*t56*t60*t64-6.0d+0*t292*t293*t57*t60-1.0939212
     1         748607545d-1*t254*t255*t56*t60-2.625411059665811d-1*t138*
     2         t145*t56*t60-1.2062370656377225d-1*t249*t60)+4.4957341910
     3         852217d-3*t176*t58*t60*t88*t89+5.011795824473985d-2*t178*
     4         t58*t60*t75*t89-2.1150894194591274d-1*t258*t64*t85*t87-7.
     5         931585322971725d-2*t254*t255*t85*t87-1.9035804775132145d-
     6         1*t138*t145*t85*t87-7.872580557945579d-2*t243*t291*t64*t8
     7         7+3.498376867038983d-1*t172*t249*t87+2.6879375566081715d-
     8         1*t258*t64*t82*t84+1.007976583728064d-1*t254*t255*t82*t84
     9         +2.419143800947354d-1*t138*t145*t82*t84+1.000478029649287
     :         7d-1*t243*t287*t64*t84-4.445872822950419d-1*t169*t249*t84
     ;         +7.244178432040066d-2*t258*t64*t79*t81+2.716566912015024d
     <         -2*t254*t255*t79*t81+6.51976058883606d-2*t138*t145*t79*t8
     =         1+2.69635778788734d-2*t243*t64*t81/t55**4-1.1981936089412
     >         427d-1*t166*t249*t81+1.8009481522035156d+1*t243*t64/(t55*
     ?         *8*t80**3)-3.34119721631599d-2*t13*t15*t162*t71*t75*t77-5
     @         .568662027193316d-3*t14*t282*t75*t77+1.6705986081579946d-
     1         2*t14*t254*t75*t77-5.011795824473985d-2*t13*t15*t154*t75*
     2         t77-1.002359164894797d-1*t13*t15*t160*t71*t75+1.670598608
     3         157995d-2*t162*t178*t59*t75-2.5058979122369923d-2*t102*t1
     4         87*t48*t50*t75-2.5058979122369923d-2*t306*t49*t75-2.78433
     5         1013596658d-3*t102*t282*t49*t75+8.352993040789973d-3*t102
     6         *t254*t49*t75-1.670598608157995d-2*t162*t190*t49*t75+5.01
     7         1795824473985d-2*t300*t42*t75+3.34119721631599d-2*t162*t1
     8         84*t42*t75-5.011795824473985d-2*t14*t278*t75-3.3411972163
     9         1599d-2*t14*t160*t162*t75-5.088166200913744d-4*t13*t15*t1
     :         57*t63*t64*t71*t73-9.690227711544375d-4*t13*t15*t154*t69*
     ;         t73+1.696055400304582d-4*t14*t147*t157*t64*t73-1.00188958
     <         62972538d-4*t138*t14*t273*t73+1.272041550228436d-4*t14*t1
     =         44*t145*t157*t73-1.938045542308875d-3*t13*t15*t155*t69*t7
     >         1-9.690227711544375d-4*t14*t270*t69-6.96009523273821d-2*t
     ?         258*t64*t65*t67-2.610035712276828d-2*t254*t255*t65*t67-6.
     @         26408570946439d-2*t138*t145*t65*t67-2.590619096601433d-2*
     1         t243*t251*t64*t67+1.1512059930225654d-1*t142*t249*t67+1.1
     2         803150266592868d-3*t176*t177*t59*t63*t64-1.40055703853053
     3         1d-3*t188*t189*t49*t63*t64+2.3268355398725185d-3*t182*t18
     4         3*t42*t63*t64-5.088166200913744d-4*t14*t155*t157*t63*t64-
     5         1.4081430686456894d+0*t165*t243*t64/t55**6+4.668523461768
     6         438d-4*t101*t147*t189*t49*t64+2.5218302197571857d-1*t171*
     7         t243*t290*t64-1.97833457907796d-1*t243*t288*t289*t64-4.70
     8         62486515309376d-4*t168*t243*t286*t64+5.421598446633554d-7
     9         *t243*t284*t285*t64+2.2877665475865033d+0*t140*t243*t247*
     :         t64-4.947718859586276d+1*t243*t244*t245*t64-2.75777845398
     ;         8139d-4*t101*t138*t305*t49+3.501392596326328d-4*t101*t144
     <         *t145*t189*t49-4.802734052773798d-1*t170*t171*t249+8.9628
     =         79611183625d-4*t167*t168*t249+2.681757326079316d+0*t164*t
     >         165*t249-4.3569682910487045d+0*t139*t140*t249)
            t308 = 1/t21**1.6666666666666669d+0
            t309 = 6*t19*t34
            t310 = -6*t222
            t311 = 1/t22**1.6666666666666669d+0
            t312 = -6*t19*t34
            t313 = 6*t222
            t314 = 1.3333333333333333d+0*t129*(t313+t312)-2.962962962962
     1         963d-1*t128**3*t311+1.3333333333333333d+0*t126*(t310+t309
     2         )-2.962962962962963d-1*t125**3*t308+1.3333333333333333d+0
     3         *t128*t227*t230+1.3333333333333333d+0*t125*t221*t225
            t315 = 1/t24**8
            t316 = 1/t106**3
            t317 = -1.0606128115063691d+1*t243*t315*t316*t64
            t318 = 1/t24**6
            t319 = 4.1445148651319325d-1*t194*t243*t318*t64
            t320 = -7.89307801891314d-1*t193*t194*t249
            t321 = 1/t24**4
            t322 = -3.9662099574848336d-3*t107*t243*t321*t64
            t323 = 1.762483986407818d-2*t107*t196*t249
            t324 = -3.995936587128472d-3*t105*t107*t254*t255
            t325 = -9.590247809108335d-3*t105*t107*t138*t145
            t326 = -1.0655830899009261d-2*t105*t107*t258*t64
            t327 = -7.298067035835535d-4*t109*t110*t205*t28*t30
            t328 = -1.9160425910065093d-4*t110*t112*t207*t28*t30*t63*t64
            t329 = -3.6490335179177674d-4*t109*t112*t204*t28*t30
            t330 = -5.444297760095788d-2*t110*t209*t28*t30*t75
            t331 = -2.722148880047894d-2*t114*t204*t28*t30*t75
            t332 = -1.8147659200319294d-2*t110*t114*t162*t28*t30*t75
            t333 = t110**3
            t334 = 1/t28**3
            t335 = -1.5582543919966493d-1*t258*t64+t268-5.84345396998743
     1         4d-2*t254*t255-1.4024289527969844d-1*t138*t145
            t336 = 7.876233178997433d-1*t111*t204*t26*t30*t63*t64-1.5752
     1         466357994865d+0*t202*t203*t26*t30*t63*t64-2.9171233996286
     2         79d-1*t258*t26*t30*t64-5.250822119331622d-1*t110*t111*t14
     3         7*t26*t30*t64-1.0d+0*t111*t27*t30*t335-6.0d+0*t27*t30*t33
     4         3*t334+6.0d+0*t110*t203*t204*t27*t30-1.0939212748607545d-
     5         1*t254*t255*t26*t30-3.9381165894987163d-1*t110*t111*t144*
     6         t145*t26*t30-2.625411059665811d-1*t138*t145*t26*t30-1.206
     7         2370656377225d-1*t249*t30-1.0339174848323335d-1*t110*t111
     8         *t138*t30
            t337 = -3.6490335179177674d-4*t109*t29*t336
            t338 = -1.9160425910065093d-4*t205*t207*t29*t63*t64
            t339 = 1/t26**4
            t340 = -3.7727995569144196d-5*t112*t138*t29*t339
            t341 = 4.790106477516273d-5*t112*t144*t145*t207*t29
            t342 = 6.386808636688365d-5*t112*t147*t207*t29*t64
            t343 = 6.203504908994001d-1*t111*t204*t30*t75*t76-1.24070098
     1         17988002d+0*t202*t203*t30*t75*t76-6.433264350067852d-1*t2
     2         77*t30*t75-8.271339878658668d-1*t110*t111*t159*t30*t75-6.
     3         203504908994001d-1*t111*t17*t30*t335-3.7221029453964005d+
     4         0*t17*t30*t333*t334+3.7221029453964005d+0*t110*t17*t203*t
     5         204*t30
            t344 = -2.722148880047894d-2*t29*t343*t75
            t345 = -1.8147659200319294d-2*t162*t209*t29*t75
            t346 = 9.073829600159644d-3*t114*t254*t29*t75
            t347 = -3.024609866719882d-3*t114*t282*t29*t75
            t348 = 60*t116*t215*t33
            t349 = 36*t116*t217*t34
            t350 = t33*t34*(1.709920934161365d+0*(5.33462001454663d-3*t1
     1         88*t48*t50*t98*t99+5.011795824473985d-2*t190*t48*t50*t75*
     2         t99+1.670598608157995d-2*t102*t162*t48*t50*t75*t99+1.4005
     3         57038530531d-3*t101*t189*t48*t50*t63*t64*t99+2.6673100072
     4         73315d-3*t101*t187*t48*t50*t98+2.667310007273315d-3*t304*
     5         t49*t98-3.34119721631599d-2*t162*t41*t43*t75*t94*t97-5.01
     6         1795824473985d-2*t181*t41*t43*t75*t97-5.568662027193316d-
     7         3*t282*t42*t75*t97+1.6705986081579946d-2*t254*t42*t75*t97
     8         -2.3268355398725185d-3*t183*t41*t43*t63*t64*t94*t96-4.431
     9         373767749538d-3*t181*t41*t43*t93*t96+7.756118466241728d-4
     :         *t147*t183*t42*t64*t96-4.5816748203035834d-4*t138*t299*t4
     ;         2*t96+5.817088849681296d-4*t144*t145*t183*t42*t96-8.86274
     <         7535499076d-3*t182*t41*t43*t93*t94-1.002359164894797d-1*t
     =         184*t41*t43*t75*t94-4.431373767749538d-3*t298*t42*t93+2.1
     >         150894194591274d-1*t258*t64*t85*t87+7.931585322971725d-2*
     ?         t254*t255*t85*t87+1.9035804775132145d-1*t138*t145*t85*t87
     @         +7.872580557945579d-2*t243*t291*t64*t87-3.498376867038983
     1         d-1*t172*t249*t87-2.6879375566081715d-1*t258*t64*t82*t84-
     2         1.007976583728064d-1*t254*t255*t82*t84-2.419143800947354d
     3         -1*t138*t145*t82*t84-1.0004780296492877d-1*t243*t287*t64*
     4         t84+4.445872822950419d-1*t169*t249*t84+2.5058979122369923
     5         d-2*t102*t187*t48*t50*t75+2.5058979122369923d-2*t306*t49*
     6         t75+2.784331013596658d-3*t102*t282*t49*t75-8.352993040789
     7         973d-3*t102*t254*t49*t75+1.670598608157995d-2*t162*t190*t
     8         49*t75-5.011795824473985d-2*t300*t42*t75-3.34119721631599
     9         d-2*t162*t184*t42*t75+1.400557038530531d-3*t188*t189*t49*
     :         t63*t64-2.3268355398725185d-3*t182*t183*t42*t63*t64-4.668
     ;         523461768438d-4*t101*t147*t189*t49*t64-2.5218302197571857
     <         d-1*t171*t243*t290*t64+1.97833457907796d-1*t243*t288*t289
     =         *t64+4.7062486515309376d-4*t168*t243*t286*t64-5.421598446
     >         633554d-7*t243*t284*t285*t64+2.757778453988139d-4*t101*t1
     ?         38*t305*t49-3.501392596326328d-4*t101*t144*t145*t189*t49+
     @         4.802734052773798d-1*t170*t171*t249-8.962879611183625d-4*
     1         t167*t168*t249)+2.722148880047894d-2*t29*t343*t75+5.44429
     2         7760095788d-2*t110*t209*t28*t30*t75+2.722148880047894d-2*
     3         t114*t204*t28*t30*t75+1.8147659200319294d-2*t110*t114*t16
     4         2*t28*t30*t75+3.024609866719882d-3*t114*t282*t29*t75-9.07
     5         3829600159644d-3*t114*t254*t29*t75+1.8147659200319294d-2*
     6         t162*t209*t29*t75+1.9160425910065093d-4*t110*t112*t207*t2
     7         8*t30*t63*t64+1.9160425910065093d-4*t205*t207*t29*t63*t64
     8         +3.9662099574848336d-3*t107*t243*t321*t64-4.1445148651319
     9         325d-1*t194*t243*t318*t64+1.0606128115063691d+1*t243*t315
     :         *t316*t64-6.386808636688365d-5*t112*t147*t207*t29*t64+1.0
     ;         655830899009261d-2*t105*t107*t258*t64+3.7727995569144196d
     <         -5*t112*t138*t29*t339+3.6490335179177674d-4*t109*t29*t336
     =         +7.298067035835535d-4*t109*t110*t205*t28*t30+3.6490335179
     >         177674d-4*t109*t112*t204*t28*t30-4.790106477516273d-5*t11
     ?         2*t144*t145*t207*t29+3.995936587128472d-3*t105*t107*t254*
     @         t255-1.762483986407818d-2*t107*t196*t249+7.89307801891314
     1         d-1*t193*t194*t249+9.590247809108335d-3*t105*t107*t138*t1
     2         45)
            t351 = -12*t118*t213*t33
            t352 = -120*t33*t53/t1**7
            t353 = -144*t118*t217*t53
            t354 = 24*t19*t34*t53
            t355 = 2.0d+0*t235*wght
            t356 = 3.847322101863072d+0*t103*t234
            t357 = 1.3333333333333333d+0*t129*(t312+2*t222)-2.9629629629
     1         62963d-1*t135*t226*t311+1.3333333333333333d+0*t126*(t309-
     2         2*t222)-2.962962962962963d-1*t134*t220*t308+4.44444444444
     3         4444d-1*t135*t227*t230+1.7777777777777776d+0*t128*t19*t22
     4         2*t227+4.444444444444444d-1*t134*t221*t225-1.777777777777
     5         7776d+0*t125*t19*t221*t222
            t358 = -12*t116*t217*t34
            t359 = 48*t118*t217*t53
            t360 = -24*t19*t34*t53
            t361 = -8*t129*t19*t34+8*t126*t19*t34-2.962962962962963d-1*t
     1         128*t239*t311-2.962962962962963d-1*t125*t237*t308+4.44444
     2         4444444444d-1*t128*t227*t240+4.444444444444444d-1*t125*t2
     3         21*t238+1.7777777777777776d+0*t135*t19*t222*t227-1.777777
     4         7777777776d+0*t134*t19*t221*t222-2.6666666666666666d+0*t1
     5         29*t222+2.6666666666666666d+0*t126*t222
            t362 = 1.3333333333333333d+0*t126*(t313+t309)+1.333333333333
     1         3333d+0*t129*(t312+t310)-2.962962962962963d-1*t135**3*t31
     2         1-2.962962962962963d-1*t134**3*t308+1.3333333333333333d+0
     3         *t135*t227*t240+1.3333333333333333d+0*t134*t221*t238
            fnc(iq) = 1.0d+0*t1*t62*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t131*wght+t132+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t137*wght+t132+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*t1*t232*wght+2.0d+0*t131*wght+Am
     1         at2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t1*t235*wght+1.0d+0*t137*wght+1.
     1         0d+0*t131*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t242*wght+2.0d+0*t137*wght+Am
     1         at2(iq,D2_RB_RB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*t1*(1.923661050931536d+0*t314
     1         *t61+1.1250000000000002d+0*t314*t54+1.1250000000000002d+0
     2         *t23*(240*t120*t215*t53+t354+t353+t352+t351+t350+t349+t34
     3         8+t347+t346+t345+t344+t342+t341+t340+12*t120*t213*t34+t33
     4         8+t337+t332+t331+t330+t329+t328+t327+t326+t325+t324+t323+
     5         t322+t320+t319+t317-96*t116*t118*t120)+t307+t283+t281+t28
     6         0+t279+t276+t275+t274+t272+t271+t265+t264+t263+t262+t261+
     7         t260+t259+t257+t256+t253+t252+t250+t248+t246+3.3750000000
     8         00001d+0*t121*t231+5.770983152794609d+0*t103*t231+3.37500
     9         0000000001d+0*t130*t219+5.770983152794609d+0*t130*t191)*w
     :         ght+3.0d+0*t232*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*t1*(1.923661050931536d+0*t357
     1         *t61+1.1250000000000002d+0*t357*t54+1.1250000000000002d+0
     2         *t23*(80*t120*t215*t53+t360+t359+t358+t352+t351+t350+t348
     3         +t347+t346+t345+t344+t342+t341+t340+4*t120*t213*t34+t338+
     4         t337+t332+t331+t330+t329+t328+t327+t326+t325+t324+t323+t3
     5         22+t320+t319+t317-32*t116*t118*t120)+t356+t307+t283+t281+
     6         t280+t279+t276+t275+t274+t272+t271+t265+t264+t263+t262+t2
     7         61+t260+t259+t257+t256+t253+t252+t250+t248+t246+2.2500000
     8         000000003d+0*t121*t234+2.2500000000000003d+0*t130*t233+1.
     9         1250000000000002d+0*t133*t231+1.923661050931536d+0*t103*t
     :         231+1.1250000000000002d+0*t136*t219+1.923661050931536d+0*
     ;         t136*t191+3.847322101863072d+0*t130*t191)*wght+1.0d+0*t23
     <         2*wght+t355+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*t1*(1.923661050931536d+0*t361
     1         *t61+1.1250000000000002d+0*t361*t54+1.1250000000000002d+0
     2         *t23*(-80*t120*t215*t53+t359+t358+t354+t352+t351+t350+t34
     3         8+t347+t346+t345+t344+t342+t341+t340-4*t120*t213*t34+t338
     4         +t337+t332+t331+t330+t329+t328+t327+t326+t325+t324+t323+t
     5         322+t320+t319+t317+32*t116*t118*t120)+t356+t307+t283+t281
     6         +t280+t279+t276+t275+t274+t272+t271+t265+t264+t263+t262+t
     7         261+t260+t259+t257+t256+t253+t252+t250+t248+t246+1.125000
     8         0000000002d+0*t121*t241+1.923661050931536d+0*t103*t241+1.
     9         1250000000000002d+0*t130*t236+2.2500000000000003d+0*t133*
     :         t234+2.2500000000000003d+0*t136*t233+3.847322101863072d+0
     ;         *t136*t191+1.923661050931536d+0*t130*t191)*wght+1.0d+0*t2
     <         42*wght+t355+Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*t1*(1.923661050931536d+0*t362
     1         *t61+1.1250000000000002d+0*t362*t54+1.1250000000000002d+0
     2         *t23*(-240*t120*t215*t53+t360+t353+t352+t351+t350+t349+t3
     3         48+t347+t346+t345+t344+t342+t341+t340-12*t120*t213*t34+t3
     4         38+t337+t332+t331+t330+t329+t328+t327+t326+t325+t324+t323
     5         +t322+t320+t319+t317+96*t116*t118*t120)+t307+t283+t281+t2
     6         80+t279+t276+t275+t274+t272+t271+t265+t264+t263+t262+t261
     7         +t260+t259+t257+t256+t253+t252+t250+t248+t246+3.375000000
     8         000001d+0*t133*t241+5.770983152794609d+0*t103*t241+3.3750
     9         00000000001d+0*t136*t236+5.770983152794609d+0*t136*t191)*
     :         wght+3.0d+0*t242*wght+Amat3(iq,D3_RB_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.414573716781907d-1*t3+1.14813d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+2.28344d-1
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.0683499999999999d+0
            t26 = atan(6.692072046645942d+0/t25)
            t27 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = log(6.203504908994001d-1*t29*t9)
            t31 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t32 = abs(t31)
            t33 = 1/t32
            t34 = log(6.203504908994001d-1*t33*t9)
            t35 = t11+4.09286d-1
            t36 = t35**2
            t37 = log(1.0d+0*t29*t36)
            t38 = t11+7.43294d-1
            t39 = t38**2
            t40 = log(1.0d+0*t33*t39)
            t41 = t15+1.3072d+1
            t42 = atan(4.4899888641576796d-2/t41)
            t43 = t15+2.0123100000000002d+1
            t44 = atan(1.171685277708971d+0/t43)
            t45 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t46 = abs(t45)
            t47 = 1/t46
            t48 = t11+3.25d-1
            t49 = t48**2
            t50 = t15+7.06042d+0
            t51 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t47*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t50)+2.2478670955426108d-3*log(1.0d+0*t47*t49)-6.18818
     3         0297906176d-1*t44+2.052197293770518d+1*t42-2.667310007273
     4         315d-3*t40+4.431373767749538d-3*t37-1.554535d-2*t34+3.109
     5         07d-2*t30-3.8783294878113006d-2*t17-9.690227711544375d-4*
     6         t14-3.10907d-2*t10)+5.848223622634643d-1*(1.0d+0*(1.70992
     7         0934161365d+0*(6.188180297906176d-1*t44-2.052197293770518
     8         d+1*t42+2.667310007273315d-3*t40-4.431373767749538d-3*t37
     9         +1.554535d-2*t34-3.10907d-2*t30)+5.458482358638966d-3*t26
     :         +3.6490335179177674d-4*t24+1.688686394038963d-2*t21)-5.45
     ;         8482358638966d-3*t26-3.6490335179177674d-4*t24-1.68868639
     <         4038963d-2*t21)+3.8783294878113006d-2*t17+9.6902277115443
     =         75d-4*t14+3.10907d-2*t10
            t52 = 1/t9
            t53 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t54 = 1/t2**3
            t55 = 1/rhoa**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t6
            t58 = 1/rhoa**1.6666666666666666d+0
            t59 = -6.203504908994001d-1*t56*t57*t8*t9-2.067834969664667d
     1         -1*t52*t58*t8
            t60 = 1/t16**2
            t61 = 3.784699104639999d+1*t60+1
            t62 = 1/t61
            t63 = 1/t13
            t64 = -1.0d+0*t13*t56*t57*t8-2.625411059665811d-1*t12*t54*t5
     1         5*t8
            t65 = t53-9.26825237694284d-1*t54*t55
            t66 = 1/t45
            t67 = -6.203504908994001d-1*t47*t65*t66*t9-2.067834969664667
     1         d-1*t47*t52*t58
            t68 = t53-1.715968668597574d+0*t54*t55
            t69 = 1/t27
            t70 = -6.203504908994001d-1*t29*t68*t69*t9-2.067834969664667
     1         d-1*t29*t52*t58
            t71 = t53-2.641570464738054d+0*t54*t55
            t72 = 1/t31
            t73 = -6.203504908994001d-1*t33*t71*t72*t9-2.067834969664667
     1         d-1*t33*t52*t58
            t74 = 1/t50**2
            t75 = 2.238166942360001d+1*t74+1
            t76 = 1/t75
            t77 = 1/t41**2
            t78 = 2.016000000025997d-3*t77+1
            t79 = 1/t78
            t80 = 1/t43**2
            t81 = 1.3728463899999485d+0*t80+1
            t82 = 1/t81
            t83 = 1/t49
            t84 = -1.0d+0*t47*t49*t65*t66-2.625411059665811d-1*t47*t48*t
     1         54*t55
            t85 = 1/t36
            t86 = -1.0d+0*t29*t36*t68*t69-2.625411059665811d-1*t29*t35*t
     1         54*t55
            t87 = 1/t39
            t88 = -1.0d+0*t33*t39*t71*t72-2.625411059665811d-1*t33*t38*t
     1         54*t55
            t89 = t53-1.4024289527969844d-1*t54*t55
            t90 = 1/t18
            t91 = -6.203504908994001d-1*t20*t89*t9*t90-2.067834969664667
     1         d-1*t20*t52*t58
            t92 = 1/t25**2
            t93 = 4.4783828277500004d+1*t92+1
            t94 = 1/t93
            t95 = 1/t23
            t96 = -1.0d+0*t20*t23*t89*t90-2.625411059665811d-1*t20*t22*t
     1         54*t55
            t97 = 5.848223622634643d-1*(1.0d+0*(3.6490335179177674d-4*t1
     1         9*t95*t96+9.590247809108334d-3*t54*t55*t92*t94+2.72214888
     2         0047894d-2*t19*t52*t91+1.709920934161365d+0*(2.6673100072
     3         73315d-3*t32*t87*t88-4.431373767749538d-3*t28*t85*t86+1.9
     4         035804775132142d-1*t54*t55*t80*t82-2.4191438009473537d-1*
     5         t54*t55*t77*t79+2.5058979122369923d-2*t32*t52*t73-5.01179
     6         5824473985d-2*t28*t52*t70))-3.6490335179177674d-4*t19*t95
     7         *t96-9.590247809108334d-3*t54*t55*t92*t94-2.7221488800478
     8         94d-2*t19*t52*t91)+9.99999999999999d-1*(-2.66731000727331
     9         5d-3*t32*t87*t88+4.431373767749538d-3*t28*t85*t86+2.24786
     :         70955426108d-3*t46*t83*t84-1.9035804775132142d-1*t54*t55*
     ;         t80*t82+2.4191438009473537d-1*t54*t55*t77*t79+6.519760588
     <         836059d-2*t54*t55*t74*t76-2.5058979122369923d-2*t32*t52*t
     =         73+5.011795824473985d-2*t28*t52*t70-9.690227711544375d-4*
     >         t63*t64*t7-5.011795824473985d-2*t52*t59*t7+2.505897912236
     ?         9923d-2*t46*t52*t67-6.264085709464389d-2*t54*t55*t60*t62)
     @         +9.690227711544375d-4*t63*t64*t7+5.011795824473985d-2*t52
     1         *t59*t7+6.264085709464389d-2*t54*t55*t60*t62
            t98 = 1/t61**2
            t99 = 1/t16**5
            t100 = 1/rhoa**2.3333333333333334d+0
            t101 = 1/t16**3
            t102 = 1/rhoa**1.6666666666666669d+0
            t103 = t56**2
            t104 = 1/t6**2
            t105 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t106 = 1/t2**5
            t107 = 1/rhoa**1.3333333333333336d+0
            t108 = 3.262020733413577d-1*t102*t54+2.4465155500601823d-1*t
     1         106*t107+t105
            t109 = 1/rhoa**2.6666666666666666d+0
            t110 = -6.203504908994001d-1*t108*t57*t8*t9+1.24070098179880
     1         02d+0*t103*t104*t8*t9+4.135669939329334d-1*t52*t56*t57*t5
     2         8*t8+2.7571132928862224d-1*t109*t52*t8
            t111 = 1/rhoa**9.999999999999999d-1
            t112 = 1/t12**3
            t113 = 5.250822119331622d-1*t12*t54*t55*t56*t57*t8-1.0d+0*t1
     1         08*t13*t57*t8+1.7502740397772074d-1*t102*t12*t54*t8+2.0d+
     2         0*t103*t104*t13*t8+1.3127055298329054d-1*t106*t107*t12*t8
     3         +3.446391616107778d-2*t100*t8
            t114 = 1/t93**2
            t115 = 1/t25**5
            t116 = 1/t25**3
            t117 = t89**2
            t118 = 1/t18**2
            t119 = 9.349526351979897d-2*t102*t54+7.012144763984922d-2*t1
     1         06*t107+t105
            t120 = -6.203504908994001d-1*t119*t20*t9*t90+4.1356699393293
     1         34d-1*t20*t52*t58*t89*t90+1.2407009817988002d+0*t117*t118
     2         *t20*t9+2.7571132928862224d-1*t109*t20*t52
            t121 = 1/t22**3
            t122 = 5.250822119331622d-1*t20*t22*t54*t55*t89*t90-1.0d+0*t
     1         119*t20*t23*t90+1.7502740397772074d-1*t102*t20*t22*t54+2.
     2         0d+0*t117*t118*t20*t23+1.3127055298329054d-1*t106*t107*t2
     3         0*t22+3.446391616107778d-2*t100*t20
            t123 = 1/t78**2
            t124 = 1/t41**5
            t125 = 1/t41**3
            t126 = 1/t81**2
            t127 = 1/t43**5
            t128 = 1/t43**3
            t129 = t68**2
            t130 = 1/t27**2
            t131 = 1.1439791123983827d+0*t102*t54+8.57984334298787d-1*t1
     1         06*t107+t105
            t132 = -6.203504908994001d-1*t131*t29*t69*t9+1.2407009817988
     1         002d+0*t129*t130*t29*t9+4.135669939329334d-1*t29*t52*t58*
     2         t68*t69+2.7571132928862224d-1*t109*t29*t52
            t133 = t71**2
            t134 = 1/t31**2
            t135 = 1.761046976492036d+0*t102*t54+1.320785232369027d+0*t1
     1         06*t107+t105
            t136 = -6.203504908994001d-1*t135*t33*t72*t9+1.2407009817988
     1         002d+0*t133*t134*t33*t9+4.135669939329334d-1*t33*t52*t58*
     2         t71*t72+2.7571132928862224d-1*t109*t33*t52
            t137 = 1/t35**3
            t138 = 1/t38**3
            t139 = 5.250822119331622d-1*t29*t35*t54*t55*t68*t69-1.0d+0*t
     1         131*t29*t36*t69+1.7502740397772074d-1*t102*t29*t35*t54+2.
     2         0d+0*t129*t130*t29*t36+1.3127055298329054d-1*t106*t107*t2
     3         9*t35+3.446391616107778d-2*t100*t29
            t140 = 5.250822119331622d-1*t33*t38*t54*t55*t71*t72-1.0d+0*t
     1         135*t33*t39*t72+1.7502740397772074d-1*t102*t33*t38*t54+2.
     2         0d+0*t133*t134*t33*t39+1.3127055298329054d-1*t106*t107*t3
     3         3*t38+3.446391616107778d-2*t100*t33
            t141 = 1/t75**2
            t142 = 1/t50**5
            t143 = 1/t50**3
            t144 = t65**2
            t145 = 1/t45**2
            t146 = 6.178834917961894d-1*t102*t54+4.63412618847142d-1*t10
     1         6*t107+t105
            t147 = -6.203504908994001d-1*t146*t47*t66*t9+1.2407009817988
     1         002d+0*t144*t145*t47*t9+4.135669939329334d-1*t47*t52*t58*
     2         t65*t66+2.7571132928862224d-1*t109*t47*t52
            t148 = 1/t48**3
            t149 = 5.250822119331622d-1*t47*t48*t54*t55*t65*t66-1.0d+0*t
     1         146*t47*t49*t66+1.7502740397772074d-1*t102*t47*t48*t54+2.
     2         0d+0*t144*t145*t47*t49+1.3127055298329054d-1*t106*t107*t4
     3         7*t48+3.446391616107778d-2*t100*t47
            t150 = 9.99999999999999d-1*(1.2448480831567728d+0*t100*t98*t
     1         99-2.667310007273315d-3*t31*t33*t71*t87*t88-7.00278519265
     2         2656d-4*t138*t32*t54*t55*t88-2.667310007273315d-3*t140*t3
     3         2*t87+4.431373767749538d-3*t27*t29*t68*t85*t86+1.16341776
     4         99362593d-3*t137*t28*t54*t55*t86+4.431373767749538d-3*t13
     5         9*t28*t85+2.2478670955426108d-3*t45*t47*t65*t83*t84+5.901
     6         575133296435d-4*t148*t46*t54*t55*t84+2.2478670955426108d-
     7         3*t149*t46*t83+1.2690536516754763d-1*t102*t54*t80*t82+9.5
     8         17902387566071d-2*t106*t107*t80*t82-9.995362477254237d-2*
     9         t100*t128*t82-9.690227711544375d-4*t56*t6*t63*t64*t8-5.01
     :         1795824473985d-2*t52*t56*t59*t6*t8-1.6127625339649027d-1*
     ;         t102*t54*t77*t79-1.2095719004736769d-1*t106*t107*t77*t79+
     <         1.270249377985834d-1*t100*t125*t79-4.3465070592240396d-2*
     =         t102*t54*t74*t76-3.2598802944180294d-2*t106*t107*t74*t76+
     >         3.4234103112606934d-2*t100*t143*t76-2.5058979122369923d-2
     ?         *t31*t33*t52*t71*t73-8.352993040789976d-3*t111*t32*t52*t7
     @         3+5.011795824473985d-2*t27*t29*t52*t68*t70+1.670598608157
     1         995d-2*t111*t28*t52*t70-2.544083100456872d-4*t112*t54*t55
     2         *t64*t7-9.690227711544375d-4*t113*t63*t7-1.67059860815799
     3         5d-2*t111*t52*t59*t7-5.011795824473985d-2*t110*t52*t7+2.5
     4         058979122369923d-2*t45*t47*t52*t65*t67+8.352993040789976d
     5         -3*t111*t46*t52*t67+4.176057139642926d-2*t102*t54*t60*t62
     6         +3.1320428547321943d-2*t106*t107*t60*t62-3.28915998006447
     7         2d-2*t100*t101*t62+2.5058979122369923d-2*t147*t46*t52-2.5
     8         058979122369923d-2*t136*t32*t52+5.011795824473985d-2*t132
     9         *t28*t52-7.662163788798045d-1*t100*t141*t142+1.3722097293
     :         63942d-1*t100*t126*t127-2.560822746052464d-4*t100*t123*t1
     ;         24)-1.2448480831567728d+0*t100*t98*t99+5.848223622634643d
     <         -1*(1.0d+0*(3.6490335179177674d-4*t18*t20*t89*t95*t96+9.5
     =         80212955032547d-5*t121*t19*t54*t55*t96+3.6490335179177674
     >         d-4*t122*t19*t95-6.393498539405557d-3*t102*t54*t92*t94-4.
     ?         795123904554167d-3*t106*t107*t92*t94+5.035668532593766d-3
     @         *t100*t116*t94+2.722148880047894d-2*t18*t20*t52*t89*t91+9
     1         .073829600159646d-3*t111*t19*t52*t91+1.709920934161365d+0
     2         *(2.667310007273315d-3*t31*t33*t71*t87*t88+7.002785192652
     3         656d-4*t138*t32*t54*t55*t88+2.667310007273315d-3*t140*t32
     4         *t87-4.431373767749538d-3*t27*t29*t68*t85*t86-1.163417769
     5         9362593d-3*t137*t28*t54*t55*t86-4.431373767749538d-3*t139
     6         *t28*t85-1.2690536516754763d-1*t102*t54*t80*t82-9.5179023
     7         87566071d-2*t106*t107*t80*t82+9.995362477254237d-2*t100*t
     8         128*t82+1.6127625339649027d-1*t102*t54*t77*t79+1.20957190
     9         04736769d-1*t106*t107*t77*t79-1.270249377985834d-1*t100*t
     :         125*t79+2.5058979122369923d-2*t31*t33*t52*t71*t73+8.35299
     ;         3040789976d-3*t111*t32*t52*t73-5.011795824473985d-2*t27*t
     <         29*t52*t68*t70-1.670598608157995d-2*t111*t28*t52*t70+2.50
     =         58979122369923d-2*t136*t32*t52-5.011795824473985d-2*t132*
     >         t28*t52-1.372209729363942d-1*t100*t126*t127+2.56082274605
     ?         2464d-4*t100*t123*t124)+2.722148880047894d-2*t120*t19*t52
     @         -2.255165148260897d-1*t100*t114*t115)-3.6490335179177674d
     1         -4*t18*t20*t89*t95*t96-9.580212955032547d-5*t121*t19*t54*
     2         t55*t96-3.6490335179177674d-4*t122*t19*t95+6.393498539405
     3         557d-3*t102*t54*t92*t94+4.795123904554167d-3*t106*t107*t9
     4         2*t94-5.035668532593766d-3*t100*t116*t94-2.72214888004789
     5         4d-2*t18*t20*t52*t89*t91-9.073829600159646d-3*t111*t19*t5
     6         2*t91-2.722148880047894d-2*t120*t19*t52+2.255165148260897
     7         d-1*t100*t114*t115)+9.690227711544375d-4*t56*t6*t63*t64*t
     8         8+5.011795824473985d-2*t52*t56*t59*t6*t8+2.54408310045687
     9         2d-4*t112*t54*t55*t64*t7+9.690227711544375d-4*t113*t63*t7
     :         +1.670598608157995d-2*t111*t52*t59*t7+5.011795824473985d-
     ;         2*t110*t52*t7-4.176057139642926d-2*t102*t54*t60*t62-3.132
     <         0428547321943d-2*t106*t107*t60*t62+3.289159980064472d-2*t
     =         100*t101*t62
            t151 = 1/rhoa**3.3333333333333337d+0
            t152 = 1/t61**3
            t153 = 1/t16**8
            t154 = 1/rhoa**3.0d+0
            t155 = 1/t16**6
            t156 = 1/t16**4
            t157 = 1/rhoa**2.666666666666667d+0
            t158 = 1/t12**4
            t159 = 1/t2**7
            t160 = 1/rhoa**2.0d+0
            t161 = 1/rhoa**1.9999999999999998d+0
            t162 = t56**3
            t163 = 1/t6**3
            t164 = -6.433264350067851d-1/rhoa**3.333333333333333d+0
            t165 = -5.436701222355962d-1*t157*t54+t164-2.038762958383485
     1         1d-1*t159*t160-4.893031100120365d-1*t100*t106
            t166 = 1/rhoa**3.6666666666666664d+0
            t167 = -6.203504908994001d-1*t165*t57*t8*t9+3.72210294539640
     1         05d+0*t104*t108*t56*t8*t9-3.7221029453964005d+0*t162*t163
     2         *t8*t9+6.203504908994001d-1*t108*t52*t57*t58*t8-1.2407009
     3         817988002d+0*t103*t104*t52*t58*t8-8.271339878658668d-1*t1
     4         09*t52*t56*t57*t8-6.433264350067852d-1*t166*t52*t8
            t168 = -5.250822119331622d-1*t102*t12*t54*t56*t57*t8-3.93811
     1         65894987163d-1*t106*t107*t12*t56*t57*t8-1.033917484832333
     2         5d-1*t100*t56*t57*t8+7.876233178997433d-1*t108*t12*t54*t5
     3         5*t57*t8-1.0d+0*t13*t165*t57*t8+6.0d+0*t104*t108*t13*t56*
     4         t8-1.5752466357994865d+0*t103*t104*t12*t54*t55*t8-2.91712
     5         3399628679d-1*t12*t157*t54*t8-6.0d+0*t13*t162*t163*t8-1.0
     6         939212748607545d-1*t12*t159*t160*t8-1.2062370656377223d-1
     7         *t151*t8-2.625411059665811d-1*t100*t106*t12*t8
            t169 = 1/t93**3
            t170 = 1/t25**8
            t171 = 1/t25**6
            t172 = 1/t25**4
            t173 = 1/t22**4
            t174 = t89**3
            t175 = 1/t18**3
            t176 = -1.5582543919966493d-1*t157*t54+t164-5.84345396998743
     1         4d-2*t159*t160-1.4024289527969844d-1*t100*t106
            t177 = -6.203504908994001d-1*t176*t20*t9*t90-8.2713398786586
     1         68d-1*t109*t20*t52*t89*t90+6.203504908994001d-1*t119*t20*
     2         t52*t58*t90+3.7221029453964005d+0*t118*t119*t20*t89*t9-3.
     3         7221029453964005d+0*t174*t175*t20*t9-1.2407009817988002d+
     4         0*t117*t118*t20*t52*t58-6.433264350067852d-1*t166*t20*t52
            t178 = -5.250822119331622d-1*t102*t20*t22*t54*t89*t90-3.9381
     1         165894987163d-1*t106*t107*t20*t22*t89*t90-1.0339174848323
     2         335d-1*t100*t20*t89*t90+7.876233178997433d-1*t119*t20*t22
     3         *t54*t55*t90-1.0d+0*t176*t20*t23*t90+6.0d+0*t118*t119*t20
     4         *t23*t89-1.5752466357994865d+0*t117*t118*t20*t22*t54*t55-
     5         2.917123399628679d-1*t157*t20*t22*t54-6.0d+0*t174*t175*t2
     6         0*t23-1.0939212748607545d-1*t159*t160*t20*t22-2.625411059
     7         665811d-1*t100*t106*t20*t22-1.2062370656377223d-1*t151*t2
     8         0
            t179 = 1/t78**3
            t180 = 1/t41**8
            t181 = 1/t41**6
            t182 = 1/t41**4
            t183 = 1/t81**3
            t184 = 1/t43**8
            t185 = 1/t43**6
            t186 = 1/t43**4
            t187 = 1/t35**4
            t188 = 1/t38**4
            t189 = t68**3
            t190 = 1/t27**3
            t191 = -1.9066318539973046d+0*t157*t54+t164-7.14986945248989
     1         1d-1*t159*t160-1.715968668597574d+0*t100*t106
            t192 = -6.203504908994001d-1*t191*t29*t69*t9+3.7221029453964
     1         005d+0*t130*t131*t29*t68*t9-3.7221029453964005d+0*t189*t1
     2         90*t29*t9-8.271339878658668d-1*t109*t29*t52*t68*t69+6.203
     3         504908994001d-1*t131*t29*t52*t58*t69-1.2407009817988002d+
     4         0*t129*t130*t29*t52*t58-6.433264350067852d-1*t166*t29*t52
            t193 = t71**3
            t194 = 1/t31**3
            t195 = -2.9350782941533937d+0*t157*t54+t164-1.10065436030752
     1         25d+0*t159*t160-2.6415704647380545d+0*t100*t106
            t196 = -6.203504908994001d-1*t195*t33*t72*t9+3.7221029453964
     1         005d+0*t134*t135*t33*t71*t9-3.7221029453964005d+0*t193*t1
     2         94*t33*t9-8.271339878658668d-1*t109*t33*t52*t71*t72+6.203
     3         504908994001d-1*t135*t33*t52*t58*t72-1.2407009817988002d+
     4         0*t133*t134*t33*t52*t58-6.433264350067852d-1*t166*t33*t52
            t197 = -5.250822119331622d-1*t102*t29*t35*t54*t68*t69-3.9381
     1         165894987163d-1*t106*t107*t29*t35*t68*t69-1.0339174848323
     2         335d-1*t100*t29*t68*t69+7.876233178997433d-1*t131*t29*t35
     3         *t54*t55*t69-1.0d+0*t191*t29*t36*t69+6.0d+0*t130*t131*t29
     4         *t36*t68-1.5752466357994865d+0*t129*t130*t29*t35*t54*t55-
     5         2.917123399628679d-1*t157*t29*t35*t54-6.0d+0*t189*t190*t2
     6         9*t36-1.0939212748607545d-1*t159*t160*t29*t35-2.625411059
     7         665811d-1*t100*t106*t29*t35-1.2062370656377223d-1*t151*t2
     8         9
            t198 = -5.250822119331622d-1*t102*t33*t38*t54*t71*t72-3.9381
     1         165894987163d-1*t106*t107*t33*t38*t71*t72-1.0339174848323
     2         335d-1*t100*t33*t71*t72+7.876233178997433d-1*t135*t33*t38
     3         *t54*t55*t72-1.0d+0*t195*t33*t39*t72+6.0d+0*t134*t135*t33
     4         *t39*t71-1.5752466357994865d+0*t133*t134*t33*t38*t54*t55-
     5         2.917123399628679d-1*t157*t33*t38*t54-6.0d+0*t193*t194*t3
     6         3*t39-1.0939212748607545d-1*t159*t160*t33*t38-2.625411059
     7         665811d-1*t100*t106*t33*t38-1.2062370656377223d-1*t151*t3
     8         3
            t199 = t65**3
            t200 = 1/t45**3
            t201 = -1.0298058196603158d+0*t157*t54+t164-3.86177182372618
     1         33d-1*t159*t160-9.26825237694284d-1*t100*t106
            fnc(iq) = 1.0d+0*rhoa*t51*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t97*wght+1.0d+0*t51*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t97*wght+1.0d+0*rhoa*t150*wght+A
     1         mat2(iq,D2_RA_RA)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*rhoa*(9.99999999999999d-1*(-4
     1         .356968291048705d+0*t151*t98*t99+2.2877665475865033d+0*t1
     2         54*t155*t54*t98+2.5058979122369923d-2*t46*t52*(-6.2035049
     3         08994001d-1*t201*t47*t66*t9+3.7221029453964005d+0*t145*t1
     4         46*t47*t65*t9-3.7221029453964005d+0*t199*t200*t47*t9-8.27
     5         1339878658668d-1*t109*t47*t52*t65*t66+6.203504908994001d-
     6         1*t146*t47*t52*t58*t66-1.2407009817988002d+0*t144*t145*t4
     7         7*t52*t58-6.433264350067852d-1*t166*t47*t52)-2.6673100072
     8         73315d-3*t135*t31*t33*t87*t88-1.400557038530531d-3*t138*t
     9         31*t33*t54*t55*t71*t88+4.668523461768438d-4*t102*t138*t32
     :         *t54*t88-2.757778453988139d-4*t100*t188*t32*t88+3.5013925
     ;         96326328d-4*t106*t107*t138*t32*t88-5.33462001454663d-3*t1
     <         40*t31*t33*t71*t87-2.667310007273315d-3*t198*t32*t87+4.43
     =         1373767749538d-3*t131*t27*t29*t85*t86+2.3268355398725185d
     >         -3*t137*t27*t29*t54*t55*t68*t86-7.756118466241728d-4*t102
     ?         *t137*t28*t54*t86+4.5816748203035834d-4*t100*t187*t28*t86
     @         -5.817088849681296d-4*t106*t107*t137*t28*t86+8.8627475354
     1         99076d-3*t139*t27*t29*t68*t85+4.431373767749538d-3*t197*t
     2         28*t85+2.2478670955426108d-3*t146*t45*t47*t83*t84+1.18031
     3         50266592868d-3*t148*t45*t47*t54*t55*t65*t84-3.93438342219
     4         7623d-4*t102*t148*t46*t54*t84+2.3241090936607786d-4*t100*
     5         t46*t84/t48**4-2.9507875666482175d-4*t106*t107*t148*t46*t
     6         84+2.2478670955426108d-3*t46*(-5.250822119331622d-1*t102*
     7         t47*t48*t54*t65*t66-3.9381165894987163d-1*t106*t107*t47*t
     8         48*t65*t66-1.0339174848323335d-1*t100*t47*t65*t66+7.87623
     9         3178997433d-1*t146*t47*t48*t54*t55*t66-1.0d+0*t201*t47*t4
     :         9*t66+6.0d+0*t145*t146*t47*t49*t65-1.5752466357994865d+0*
     ;         t144*t145*t47*t48*t54*t55-2.917123399628679d-1*t157*t47*t
     <         48*t54-6.0d+0*t199*t200*t47*t49-1.0939212748607545d-1*t15
     =         9*t160*t47*t48-2.625411059665811d-1*t100*t106*t47*t48-1.2
     >         062370656377223d-1*t151*t47)*t83+4.4957341910852217d-3*t1
     ?         49*t45*t47*t65*t83-2.1150894194591274d-1*t157*t54*t80*t82
     @         -7.931585322971725d-2*t159*t160*t80*t82-1.903580477513214
     1         5d-1*t100*t106*t80*t82-7.872580557945579d-2*t154*t186*t54
     2         *t82+3.498376867038983d-1*t128*t151*t82-9.690227711544375
     3         d-4*t108*t6*t63*t64*t8-5.088166200913744d-4*t112*t54*t55*
     4         t56*t6*t64*t8-1.938045542308875d-3*t113*t56*t6*t63*t8-3.3
     5         4119721631599d-2*t111*t52*t56*t59*t6*t8-5.011795824473985
     6         d-2*t108*t52*t59*t6*t8-1.002359164894797d-1*t110*t52*t56*
     7         t6*t8+2.6879375566081715d-1*t157*t54*t77*t79+1.0079765837
     8         28064d-1*t159*t160*t77*t79+2.419143800947354d-1*t100*t106
     9         *t77*t79+1.0004780296492877d-1*t154*t182*t54*t79-4.445872
     :         822950419d-1*t125*t151*t79+7.244178432040066d-2*t157*t54*
     ;         t74*t76+2.716566912015024d-2*t159*t160*t74*t76+6.51976058
     <         883606d-2*t100*t106*t74*t76+2.69635778788734d-2*t154*t54*
     =         t76/t50**4-1.1981936089412427d-1*t143*t151*t76+1.80094815
     >         22035156d+1*t154*t54/(t50**8*t75**3)-1.670598608157995d-2
     ?         *t111*t31*t33*t52*t71*t73-2.5058979122369923d-2*t135*t31*
     @         t33*t52*t73-2.784331013596658d-3*t161*t32*t52*t73+8.35299
     1         3040789973d-3*t160*t32*t52*t73-5.011795824473985d-2*t136*
     2         t31*t33*t52*t71+3.34119721631599d-2*t111*t27*t29*t52*t68*
     3         t70+5.011795824473985d-2*t131*t27*t29*t52*t70+5.568662027
     4         193316d-3*t161*t28*t52*t70-1.6705986081579946d-2*t160*t28
     5         *t52*t70+1.696055400304582d-4*t102*t112*t54*t64*t7-1.0018
     6         895862972538d-4*t100*t158*t64*t7+1.272041550228436d-4*t10
     7         6*t107*t112*t64*t7-9.690227711544375d-4*t168*t63*t7-5.568
     8         662027193316d-3*t161*t52*t59*t7+1.6705986081579946d-2*t16
     9         0*t52*t59*t7-5.088166200913744d-4*t112*t113*t54*t55*t7-5.
     :         011795824473985d-2*t167*t52*t7-3.34119721631599d-2*t110*t
     ;         111*t52*t7+1.002359164894797d-1*t132*t27*t29*t52*t68+1.67
     <         0598608157995d-2*t111*t45*t47*t52*t65*t67+2.5058979122369
     =         923d-2*t146*t45*t47*t52*t67+2.784331013596658d-3*t161*t46
     >         *t52*t67-8.352993040789973d-3*t160*t46*t52*t67+5.01179582
     ?         4473985d-2*t147*t45*t47*t52*t65-6.96009523273821d-2*t157*
     @         t54*t60*t62-2.610035712276828d-2*t159*t160*t60*t62-6.2640
     1         8570946439d-2*t100*t106*t60*t62-2.590619096601433d-2*t154
     2         *t156*t54*t62+1.1512059930225654d-1*t101*t151*t62+1.18031
     3         50266592868d-3*t148*t149*t46*t54*t55-1.400557038530531d-3
     4         *t138*t140*t32*t54*t55+2.3268355398725185d-3*t137*t139*t2
     5         8*t54*t55-1.4081430686456894d+0*t141*t154*t54/t50**6+2.52
     6         18302197571857d-1*t126*t154*t185*t54-1.97833457907796d-1*
     7         t154*t183*t184*t54-4.7062486515309376d-4*t123*t154*t181*t
     8         54+5.421598446633554d-7*t154*t179*t180*t54-4.947718859586
     9         276d+1*t152*t153*t154*t54+1.670598608157995d-2*t111*t147*
     :         t46*t52-2.5058979122369923d-2*t196*t32*t52-1.670598608157
     ;         995d-2*t111*t136*t32*t52+5.011795824473985d-2*t192*t28*t5
     <         2+3.34119721631599d-2*t111*t132*t28*t52+2.681757326079316
     =         d+0*t141*t142*t151-4.802734052773798d-1*t126*t127*t151+8.
     >         962879611183625d-4*t123*t124*t151)+4.356968291048705d+0*t
     ?         151*t98*t99-2.2877665475865033d+0*t154*t155*t54*t98+5.848
     @         223622634643d-1*(1.0d+0*(3.6490335179177674d-4*t119*t18*t
     1         20*t95*t96+1.9160425910065093d-4*t121*t18*t20*t54*t55*t89
     2         *t96-6.386808636688365d-5*t102*t121*t19*t54*t96+3.7727995
     3         569144196d-5*t100*t173*t19*t96-4.790106477516273d-5*t106*
     4         t107*t121*t19*t96+7.298067035835535d-4*t122*t18*t20*t89*t
     5         95+3.6490335179177674d-4*t178*t19*t95+1.0655830899009261d
     6         -2*t157*t54*t92*t94+3.995936587128472d-3*t159*t160*t92*t9
     7         4+9.590247809108335d-3*t100*t106*t92*t94+3.96620995748483
     8         36d-3*t154*t172*t54*t94-1.7624839864078184d-2*t116*t151*t
     9         94+1.8147659200319294d-2*t111*t18*t20*t52*t89*t91+2.72214
     :         8880047894d-2*t119*t18*t20*t52*t91+3.024609866719882d-3*t
     ;         161*t19*t52*t91-9.073829600159644d-3*t160*t19*t52*t91+5.4
     <         44297760095788d-2*t120*t18*t20*t52*t89+1.709920934161365d
     =         +0*(2.667310007273315d-3*t135*t31*t33*t87*t88+1.400557038
     >         530531d-3*t138*t31*t33*t54*t55*t71*t88-4.668523461768438d
     ?         -4*t102*t138*t32*t54*t88+2.757778453988139d-4*t100*t188*t
     @         32*t88-3.501392596326328d-4*t106*t107*t138*t32*t88+5.3346
     1         2001454663d-3*t140*t31*t33*t71*t87+2.667310007273315d-3*t
     2         198*t32*t87-4.431373767749538d-3*t131*t27*t29*t85*t86-2.3
     3         268355398725185d-3*t137*t27*t29*t54*t55*t68*t86+7.7561184
     4         66241728d-4*t102*t137*t28*t54*t86-4.5816748203035834d-4*t
     5         100*t187*t28*t86+5.817088849681296d-4*t106*t107*t137*t28*
     6         t86-8.862747535499076d-3*t139*t27*t29*t68*t85-4.431373767
     7         749538d-3*t197*t28*t85+2.1150894194591274d-1*t157*t54*t80
     8         *t82+7.931585322971725d-2*t159*t160*t80*t82+1.90358047751
     9         32145d-1*t100*t106*t80*t82+7.872580557945579d-2*t154*t186
     :         *t54*t82-3.498376867038983d-1*t128*t151*t82-2.68793755660
     ;         81715d-1*t157*t54*t77*t79-1.007976583728064d-1*t159*t160*
     <         t77*t79-2.419143800947354d-1*t100*t106*t77*t79-1.00047802
     =         96492877d-1*t154*t182*t54*t79+4.445872822950419d-1*t125*t
     >         151*t79+1.670598608157995d-2*t111*t31*t33*t52*t71*t73+2.5
     ?         058979122369923d-2*t135*t31*t33*t52*t73+2.784331013596658
     @         d-3*t161*t32*t52*t73-8.352993040789973d-3*t160*t32*t52*t7
     1         3+5.011795824473985d-2*t136*t31*t33*t52*t71-3.34119721631
     2         599d-2*t111*t27*t29*t52*t68*t70-5.011795824473985d-2*t131
     3         *t27*t29*t52*t70-5.568662027193316d-3*t161*t28*t52*t70+1.
     4         6705986081579946d-2*t160*t28*t52*t70-1.002359164894797d-1
     5         *t132*t27*t29*t52*t68+1.400557038530531d-3*t138*t140*t32*
     6         t54*t55-2.3268355398725185d-3*t137*t139*t28*t54*t55-2.521
     7         8302197571857d-1*t126*t154*t185*t54+1.97833457907796d-1*t
     8         154*t183*t184*t54+4.7062486515309376d-4*t123*t154*t181*t5
     9         4-5.421598446633554d-7*t154*t179*t180*t54+2.5058979122369
     :         923d-2*t196*t32*t52+1.670598608157995d-2*t111*t136*t32*t5
     ;         2-5.011795824473985d-2*t192*t28*t52-3.34119721631599d-2*t
     <         111*t132*t28*t52+4.802734052773798d-1*t126*t127*t151-8.96
     =         2879611183625d-4*t123*t124*t151)+1.9160425910065093d-4*t1
     >         21*t122*t19*t54*t55-4.1445148651319325d-1*t114*t154*t171*
     ?         t54+1.0606128115063691d+1*t154*t169*t170*t54+2.7221488800
     @         47894d-2*t177*t19*t52+1.8147659200319294d-2*t111*t120*t19
     1         *t52+7.89307801891314d-1*t114*t115*t151)-3.64903351791776
     2         74d-4*t119*t18*t20*t95*t96-1.9160425910065093d-4*t121*t18
     3         *t20*t54*t55*t89*t96+6.386808636688365d-5*t102*t121*t19*t
     4         54*t96-3.7727995569144196d-5*t100*t173*t19*t96+4.79010647
     5         7516273d-5*t106*t107*t121*t19*t96-7.298067035835535d-4*t1
     6         22*t18*t20*t89*t95-3.6490335179177674d-4*t178*t19*t95-1.0
     7         655830899009261d-2*t157*t54*t92*t94-3.995936587128472d-3*
     8         t159*t160*t92*t94-9.590247809108335d-3*t100*t106*t92*t94-
     9         3.9662099574848336d-3*t154*t172*t54*t94+1.762483986407818
     :         4d-2*t116*t151*t94-1.8147659200319294d-2*t111*t18*t20*t52
     ;         *t89*t91-2.722148880047894d-2*t119*t18*t20*t52*t91-3.0246
     <         09866719882d-3*t161*t19*t52*t91+9.073829600159644d-3*t160
     =         *t19*t52*t91-5.444297760095788d-2*t120*t18*t20*t52*t89-1.
     >         9160425910065093d-4*t121*t122*t19*t54*t55+4.1445148651319
     ?         325d-1*t114*t154*t171*t54-1.0606128115063691d+1*t154*t169
     @         *t170*t54-2.722148880047894d-2*t177*t19*t52-1.81476592003
     1         19294d-2*t111*t120*t19*t52-7.89307801891314d-1*t114*t115*
     2         t151)+9.690227711544375d-4*t108*t6*t63*t64*t8+5.088166200
     3         913744d-4*t112*t54*t55*t56*t6*t64*t8+1.938045542308875d-3
     4         *t113*t56*t6*t63*t8+3.34119721631599d-2*t111*t52*t56*t59*
     5         t6*t8+5.011795824473985d-2*t108*t52*t59*t6*t8+1.002359164
     6         894797d-1*t110*t52*t56*t6*t8-1.696055400304582d-4*t102*t1
     7         12*t54*t64*t7+1.0018895862972538d-4*t100*t158*t64*t7-1.27
     8         2041550228436d-4*t106*t107*t112*t64*t7+9.690227711544375d
     9         -4*t168*t63*t7+5.568662027193316d-3*t161*t52*t59*t7-1.670
     :         5986081579946d-2*t160*t52*t59*t7+5.088166200913744d-4*t11
     ;         2*t113*t54*t55*t7+5.011795824473985d-2*t167*t52*t7+3.3411
     <         9721631599d-2*t110*t111*t52*t7+6.96009523273821d-2*t157*t
     =         54*t60*t62+2.610035712276828d-2*t159*t160*t60*t62+6.26408
     >         570946439d-2*t100*t106*t60*t62+2.590619096601433d-2*t154*
     ?         t156*t54*t62-1.1512059930225654d-1*t101*t151*t62+4.947718
     @         859586276d+1*t152*t153*t154*t54)*wght+3.0d+0*t150*wght+Am
     1         at3(iq,D3_RA_RA_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 6.203504908994001d-1*t4
            t6 = t5+2.935818660072219d+0*t3+1.29352d+1
            t7 = abs(t6)
            t8 = 1/t7
            t9 = abs(t4)
            t10 = log(6.203504908994001d-1*t8*t9)
            t11 = 7.876233178997433d-1*t3
            t12 = t11+1.0498d-1
            t13 = t12**2
            t14 = log(1.0d+0*t13*t8)
            t15 = 1.5752466357994865d+0*t3
            t16 = t15+3.72744d+0
            t17 = atan(6.15199081975908d+0/t16)
            t18 = t5+8.414573716781907d-1*t3+1.14813d+1
            t19 = abs(t18)
            t20 = 1/t19
            t21 = log(6.203504908994001d-1*t20*t9)
            t22 = t11+2.28344d-1
            t23 = t22**2
            t24 = log(1.0d+0*t20*t23)
            t25 = t15+1.0683499999999999d+0
            t26 = atan(6.692072046645942d+0/t25)
            t27 = t5+1.0295812011585444d+1*t3+4.2719799999999997d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = log(6.203504908994001d-1*t29*t9)
            t31 = t5+1.5849422788428325d+1*t3+1.01578d+2
            t32 = abs(t31)
            t33 = 1/t32
            t34 = log(6.203504908994001d-1*t33*t9)
            t35 = t11+4.09286d-1
            t36 = t35**2
            t37 = log(1.0d+0*t29*t36)
            t38 = t11+7.43294d-1
            t39 = t38**2
            t40 = log(1.0d+0*t33*t39)
            t41 = t15+1.3072d+1
            t42 = atan(4.4899888641576796d-2/t41)
            t43 = t15+2.0123100000000002d+1
            t44 = atan(1.171685277708971d+0/t43)
            t45 = t5+5.560951426165704d+0*t3+1.8057800000000002d+1
            t46 = abs(t45)
            t47 = 1/t46
            t48 = t11+3.25d-1
            t49 = t48**2
            t50 = t15+7.06042d+0
            t51 = 9.99999999999999d-1*(1.554535d-2*log(6.203504908994001
     1         d-1*t47*t9)+5.249139316978092d-2*atan(4.7309269095601136d
     2         +0/t50)+2.2478670955426108d-3*log(1.0d+0*t47*t49)-6.18818
     3         0297906176d-1*t44+2.052197293770518d+1*t42-2.667310007273
     4         315d-3*t40+4.431373767749538d-3*t37-1.554535d-2*t34+3.109
     5         07d-2*t30-3.8783294878113006d-2*t17-9.690227711544375d-4*
     6         t14-3.10907d-2*t10)+5.848223622634643d-1*(1.0d+0*(1.70992
     7         0934161365d+0*(6.188180297906176d-1*t44-2.052197293770518
     8         d+1*t42+2.667310007273315d-3*t40-4.431373767749538d-3*t37
     9         +1.554535d-2*t34-3.10907d-2*t30)+5.458482358638966d-3*t26
     :         +3.6490335179177674d-4*t24+1.688686394038963d-2*t21)-5.45
     ;         8482358638966d-3*t26-3.6490335179177674d-4*t24-1.68868639
     <         4038963d-2*t21)+3.8783294878113006d-2*t17+9.6902277115443
     =         75d-4*t14+3.10907d-2*t10
            t52 = 1/t9
            t53 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t54 = 1/t2**3
            t55 = 1/rhob**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t6
            t58 = 1/rhob**1.6666666666666666d+0
            t59 = -6.203504908994001d-1*t56*t57*t8*t9-2.067834969664667d
     1         -1*t52*t58*t8
            t60 = 1/t16**2
            t61 = 3.784699104639999d+1*t60+1
            t62 = 1/t61
            t63 = 1/t13
            t64 = -1.0d+0*t13*t56*t57*t8-2.625411059665811d-1*t12*t54*t5
     1         5*t8
            t65 = t53-9.26825237694284d-1*t54*t55
            t66 = 1/t45
            t67 = -6.203504908994001d-1*t47*t65*t66*t9-2.067834969664667
     1         d-1*t47*t52*t58
            t68 = t53-1.715968668597574d+0*t54*t55
            t69 = 1/t27
            t70 = -6.203504908994001d-1*t29*t68*t69*t9-2.067834969664667
     1         d-1*t29*t52*t58
            t71 = t53-2.641570464738054d+0*t54*t55
            t72 = 1/t31
            t73 = -6.203504908994001d-1*t33*t71*t72*t9-2.067834969664667
     1         d-1*t33*t52*t58
            t74 = 1/t50**2
            t75 = 2.238166942360001d+1*t74+1
            t76 = 1/t75
            t77 = 1/t41**2
            t78 = 2.016000000025997d-3*t77+1
            t79 = 1/t78
            t80 = 1/t43**2
            t81 = 1.3728463899999485d+0*t80+1
            t82 = 1/t81
            t83 = 1/t49
            t84 = -1.0d+0*t47*t49*t65*t66-2.625411059665811d-1*t47*t48*t
     1         54*t55
            t85 = 1/t36
            t86 = -1.0d+0*t29*t36*t68*t69-2.625411059665811d-1*t29*t35*t
     1         54*t55
            t87 = 1/t39
            t88 = -1.0d+0*t33*t39*t71*t72-2.625411059665811d-1*t33*t38*t
     1         54*t55
            t89 = t53-1.4024289527969844d-1*t54*t55
            t90 = 1/t18
            t91 = -6.203504908994001d-1*t20*t89*t9*t90-2.067834969664667
     1         d-1*t20*t52*t58
            t92 = 1/t25**2
            t93 = 4.4783828277500004d+1*t92+1
            t94 = 1/t93
            t95 = 1/t23
            t96 = -1.0d+0*t20*t23*t89*t90-2.625411059665811d-1*t20*t22*t
     1         54*t55
            t97 = 5.848223622634643d-1*(1.0d+0*(3.6490335179177674d-4*t1
     1         9*t95*t96+9.590247809108334d-3*t54*t55*t92*t94+2.72214888
     2         0047894d-2*t19*t52*t91+1.709920934161365d+0*(2.6673100072
     3         73315d-3*t32*t87*t88-4.431373767749538d-3*t28*t85*t86+1.9
     4         035804775132142d-1*t54*t55*t80*t82-2.4191438009473537d-1*
     5         t54*t55*t77*t79+2.5058979122369923d-2*t32*t52*t73-5.01179
     6         5824473985d-2*t28*t52*t70))-3.6490335179177674d-4*t19*t95
     7         *t96-9.590247809108334d-3*t54*t55*t92*t94-2.7221488800478
     8         94d-2*t19*t52*t91)+9.99999999999999d-1*(-2.66731000727331
     9         5d-3*t32*t87*t88+4.431373767749538d-3*t28*t85*t86+2.24786
     :         70955426108d-3*t46*t83*t84-1.9035804775132142d-1*t54*t55*
     ;         t80*t82+2.4191438009473537d-1*t54*t55*t77*t79+6.519760588
     <         836059d-2*t54*t55*t74*t76-2.5058979122369923d-2*t32*t52*t
     =         73+5.011795824473985d-2*t28*t52*t70-9.690227711544375d-4*
     >         t63*t64*t7-5.011795824473985d-2*t52*t59*t7+2.505897912236
     ?         9923d-2*t46*t52*t67-6.264085709464389d-2*t54*t55*t60*t62)
     @         +9.690227711544375d-4*t63*t64*t7+5.011795824473985d-2*t52
     1         *t59*t7+6.264085709464389d-2*t54*t55*t60*t62
            t98 = 1/t61**2
            t99 = 1/t16**5
            t100 = 1/rhob**2.3333333333333334d+0
            t101 = 1/t16**3
            t102 = 1/rhob**1.6666666666666669d+0
            t103 = t56**2
            t104 = 1/t6**2
            t105 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t106 = 1/t2**5
            t107 = 1/rhob**1.3333333333333336d+0
            t108 = 3.262020733413577d-1*t102*t54+2.4465155500601823d-1*t
     1         106*t107+t105
            t109 = 1/rhob**2.6666666666666666d+0
            t110 = -6.203504908994001d-1*t108*t57*t8*t9+1.24070098179880
     1         02d+0*t103*t104*t8*t9+4.135669939329334d-1*t52*t56*t57*t5
     2         8*t8+2.7571132928862224d-1*t109*t52*t8
            t111 = 1/rhob**9.999999999999999d-1
            t112 = 1/t12**3
            t113 = 5.250822119331622d-1*t12*t54*t55*t56*t57*t8-1.0d+0*t1
     1         08*t13*t57*t8+1.7502740397772074d-1*t102*t12*t54*t8+2.0d+
     2         0*t103*t104*t13*t8+1.3127055298329054d-1*t106*t107*t12*t8
     3         +3.446391616107778d-2*t100*t8
            t114 = 1/t93**2
            t115 = 1/t25**5
            t116 = 1/t25**3
            t117 = t89**2
            t118 = 1/t18**2
            t119 = 9.349526351979897d-2*t102*t54+7.012144763984922d-2*t1
     1         06*t107+t105
            t120 = -6.203504908994001d-1*t119*t20*t9*t90+4.1356699393293
     1         34d-1*t20*t52*t58*t89*t90+1.2407009817988002d+0*t117*t118
     2         *t20*t9+2.7571132928862224d-1*t109*t20*t52
            t121 = 1/t22**3
            t122 = 5.250822119331622d-1*t20*t22*t54*t55*t89*t90-1.0d+0*t
     1         119*t20*t23*t90+1.7502740397772074d-1*t102*t20*t22*t54+2.
     2         0d+0*t117*t118*t20*t23+1.3127055298329054d-1*t106*t107*t2
     3         0*t22+3.446391616107778d-2*t100*t20
            t123 = 1/t78**2
            t124 = 1/t41**5
            t125 = 1/t41**3
            t126 = 1/t81**2
            t127 = 1/t43**5
            t128 = 1/t43**3
            t129 = t68**2
            t130 = 1/t27**2
            t131 = 1.1439791123983827d+0*t102*t54+8.57984334298787d-1*t1
     1         06*t107+t105
            t132 = -6.203504908994001d-1*t131*t29*t69*t9+1.2407009817988
     1         002d+0*t129*t130*t29*t9+4.135669939329334d-1*t29*t52*t58*
     2         t68*t69+2.7571132928862224d-1*t109*t29*t52
            t133 = t71**2
            t134 = 1/t31**2
            t135 = 1.761046976492036d+0*t102*t54+1.320785232369027d+0*t1
     1         06*t107+t105
            t136 = -6.203504908994001d-1*t135*t33*t72*t9+1.2407009817988
     1         002d+0*t133*t134*t33*t9+4.135669939329334d-1*t33*t52*t58*
     2         t71*t72+2.7571132928862224d-1*t109*t33*t52
            t137 = 1/t35**3
            t138 = 1/t38**3
            t139 = 5.250822119331622d-1*t29*t35*t54*t55*t68*t69-1.0d+0*t
     1         131*t29*t36*t69+1.7502740397772074d-1*t102*t29*t35*t54+2.
     2         0d+0*t129*t130*t29*t36+1.3127055298329054d-1*t106*t107*t2
     3         9*t35+3.446391616107778d-2*t100*t29
            t140 = 5.250822119331622d-1*t33*t38*t54*t55*t71*t72-1.0d+0*t
     1         135*t33*t39*t72+1.7502740397772074d-1*t102*t33*t38*t54+2.
     2         0d+0*t133*t134*t33*t39+1.3127055298329054d-1*t106*t107*t3
     3         3*t38+3.446391616107778d-2*t100*t33
            t141 = 1/t75**2
            t142 = 1/t50**5
            t143 = 1/t50**3
            t144 = t65**2
            t145 = 1/t45**2
            t146 = 6.178834917961894d-1*t102*t54+4.63412618847142d-1*t10
     1         6*t107+t105
            t147 = -6.203504908994001d-1*t146*t47*t66*t9+1.2407009817988
     1         002d+0*t144*t145*t47*t9+4.135669939329334d-1*t47*t52*t58*
     2         t65*t66+2.7571132928862224d-1*t109*t47*t52
            t148 = 1/t48**3
            t149 = 5.250822119331622d-1*t47*t48*t54*t55*t65*t66-1.0d+0*t
     1         146*t47*t49*t66+1.7502740397772074d-1*t102*t47*t48*t54+2.
     2         0d+0*t144*t145*t47*t49+1.3127055298329054d-1*t106*t107*t4
     3         7*t48+3.446391616107778d-2*t100*t47
            t150 = 9.99999999999999d-1*(1.2448480831567728d+0*t100*t98*t
     1         99-2.667310007273315d-3*t31*t33*t71*t87*t88-7.00278519265
     2         2656d-4*t138*t32*t54*t55*t88-2.667310007273315d-3*t140*t3
     3         2*t87+4.431373767749538d-3*t27*t29*t68*t85*t86+1.16341776
     4         99362593d-3*t137*t28*t54*t55*t86+4.431373767749538d-3*t13
     5         9*t28*t85+2.2478670955426108d-3*t45*t47*t65*t83*t84+5.901
     6         575133296435d-4*t148*t46*t54*t55*t84+2.2478670955426108d-
     7         3*t149*t46*t83+1.2690536516754763d-1*t102*t54*t80*t82+9.5
     8         17902387566071d-2*t106*t107*t80*t82-9.995362477254237d-2*
     9         t100*t128*t82-9.690227711544375d-4*t56*t6*t63*t64*t8-5.01
     :         1795824473985d-2*t52*t56*t59*t6*t8-1.6127625339649027d-1*
     ;         t102*t54*t77*t79-1.2095719004736769d-1*t106*t107*t77*t79+
     <         1.270249377985834d-1*t100*t125*t79-4.3465070592240396d-2*
     =         t102*t54*t74*t76-3.2598802944180294d-2*t106*t107*t74*t76+
     >         3.4234103112606934d-2*t100*t143*t76-2.5058979122369923d-2
     ?         *t31*t33*t52*t71*t73-8.352993040789976d-3*t111*t32*t52*t7
     @         3+5.011795824473985d-2*t27*t29*t52*t68*t70+1.670598608157
     1         995d-2*t111*t28*t52*t70-2.544083100456872d-4*t112*t54*t55
     2         *t64*t7-9.690227711544375d-4*t113*t63*t7-1.67059860815799
     3         5d-2*t111*t52*t59*t7-5.011795824473985d-2*t110*t52*t7+2.5
     4         058979122369923d-2*t45*t47*t52*t65*t67+8.352993040789976d
     5         -3*t111*t46*t52*t67+4.176057139642926d-2*t102*t54*t60*t62
     6         +3.1320428547321943d-2*t106*t107*t60*t62-3.28915998006447
     7         2d-2*t100*t101*t62+2.5058979122369923d-2*t147*t46*t52-2.5
     8         058979122369923d-2*t136*t32*t52+5.011795824473985d-2*t132
     9         *t28*t52-7.662163788798045d-1*t100*t141*t142+1.3722097293
     :         63942d-1*t100*t126*t127-2.560822746052464d-4*t100*t123*t1
     ;         24)-1.2448480831567728d+0*t100*t98*t99+5.848223622634643d
     <         -1*(1.0d+0*(3.6490335179177674d-4*t18*t20*t89*t95*t96+9.5
     =         80212955032547d-5*t121*t19*t54*t55*t96+3.6490335179177674
     >         d-4*t122*t19*t95-6.393498539405557d-3*t102*t54*t92*t94-4.
     ?         795123904554167d-3*t106*t107*t92*t94+5.035668532593766d-3
     @         *t100*t116*t94+2.722148880047894d-2*t18*t20*t52*t89*t91+9
     1         .073829600159646d-3*t111*t19*t52*t91+1.709920934161365d+0
     2         *(2.667310007273315d-3*t31*t33*t71*t87*t88+7.002785192652
     3         656d-4*t138*t32*t54*t55*t88+2.667310007273315d-3*t140*t32
     4         *t87-4.431373767749538d-3*t27*t29*t68*t85*t86-1.163417769
     5         9362593d-3*t137*t28*t54*t55*t86-4.431373767749538d-3*t139
     6         *t28*t85-1.2690536516754763d-1*t102*t54*t80*t82-9.5179023
     7         87566071d-2*t106*t107*t80*t82+9.995362477254237d-2*t100*t
     8         128*t82+1.6127625339649027d-1*t102*t54*t77*t79+1.20957190
     9         04736769d-1*t106*t107*t77*t79-1.270249377985834d-1*t100*t
     :         125*t79+2.5058979122369923d-2*t31*t33*t52*t71*t73+8.35299
     ;         3040789976d-3*t111*t32*t52*t73-5.011795824473985d-2*t27*t
     <         29*t52*t68*t70-1.670598608157995d-2*t111*t28*t52*t70+2.50
     =         58979122369923d-2*t136*t32*t52-5.011795824473985d-2*t132*
     >         t28*t52-1.372209729363942d-1*t100*t126*t127+2.56082274605
     ?         2464d-4*t100*t123*t124)+2.722148880047894d-2*t120*t19*t52
     @         -2.255165148260897d-1*t100*t114*t115)-3.6490335179177674d
     1         -4*t18*t20*t89*t95*t96-9.580212955032547d-5*t121*t19*t54*
     2         t55*t96-3.6490335179177674d-4*t122*t19*t95+6.393498539405
     3         557d-3*t102*t54*t92*t94+4.795123904554167d-3*t106*t107*t9
     4         2*t94-5.035668532593766d-3*t100*t116*t94-2.72214888004789
     5         4d-2*t18*t20*t52*t89*t91-9.073829600159646d-3*t111*t19*t5
     6         2*t91-2.722148880047894d-2*t120*t19*t52+2.255165148260897
     7         d-1*t100*t114*t115)+9.690227711544375d-4*t56*t6*t63*t64*t
     8         8+5.011795824473985d-2*t52*t56*t59*t6*t8+2.54408310045687
     9         2d-4*t112*t54*t55*t64*t7+9.690227711544375d-4*t113*t63*t7
     :         +1.670598608157995d-2*t111*t52*t59*t7+5.011795824473985d-
     ;         2*t110*t52*t7-4.176057139642926d-2*t102*t54*t60*t62-3.132
     <         0428547321943d-2*t106*t107*t60*t62+3.289159980064472d-2*t
     =         100*t101*t62
            t151 = 1/rhob**3.3333333333333337d+0
            t152 = 1/t61**3
            t153 = 1/t16**8
            t154 = 1/rhob**3.0d+0
            t155 = 1/t16**6
            t156 = 1/t16**4
            t157 = 1/rhob**2.666666666666667d+0
            t158 = 1/t12**4
            t159 = 1/t2**7
            t160 = 1/rhob**2.0d+0
            t161 = 1/rhob**1.9999999999999998d+0
            t162 = t56**3
            t163 = 1/t6**3
            t164 = -6.433264350067851d-1/rhob**3.333333333333333d+0
            t165 = -5.436701222355962d-1*t157*t54+t164-2.038762958383485
     1         1d-1*t159*t160-4.893031100120365d-1*t100*t106
            t166 = 1/rhob**3.6666666666666664d+0
            t167 = -6.203504908994001d-1*t165*t57*t8*t9+3.72210294539640
     1         05d+0*t104*t108*t56*t8*t9-3.7221029453964005d+0*t162*t163
     2         *t8*t9+6.203504908994001d-1*t108*t52*t57*t58*t8-1.2407009
     3         817988002d+0*t103*t104*t52*t58*t8-8.271339878658668d-1*t1
     4         09*t52*t56*t57*t8-6.433264350067852d-1*t166*t52*t8
            t168 = -5.250822119331622d-1*t102*t12*t54*t56*t57*t8-3.93811
     1         65894987163d-1*t106*t107*t12*t56*t57*t8-1.033917484832333
     2         5d-1*t100*t56*t57*t8+7.876233178997433d-1*t108*t12*t54*t5
     3         5*t57*t8-1.0d+0*t13*t165*t57*t8+6.0d+0*t104*t108*t13*t56*
     4         t8-1.5752466357994865d+0*t103*t104*t12*t54*t55*t8-2.91712
     5         3399628679d-1*t12*t157*t54*t8-6.0d+0*t13*t162*t163*t8-1.0
     6         939212748607545d-1*t12*t159*t160*t8-1.2062370656377223d-1
     7         *t151*t8-2.625411059665811d-1*t100*t106*t12*t8
            t169 = 1/t93**3
            t170 = 1/t25**8
            t171 = 1/t25**6
            t172 = 1/t25**4
            t173 = 1/t22**4
            t174 = t89**3
            t175 = 1/t18**3
            t176 = -1.5582543919966493d-1*t157*t54+t164-5.84345396998743
     1         4d-2*t159*t160-1.4024289527969844d-1*t100*t106
            t177 = -6.203504908994001d-1*t176*t20*t9*t90-8.2713398786586
     1         68d-1*t109*t20*t52*t89*t90+6.203504908994001d-1*t119*t20*
     2         t52*t58*t90+3.7221029453964005d+0*t118*t119*t20*t89*t9-3.
     3         7221029453964005d+0*t174*t175*t20*t9-1.2407009817988002d+
     4         0*t117*t118*t20*t52*t58-6.433264350067852d-1*t166*t20*t52
            t178 = -5.250822119331622d-1*t102*t20*t22*t54*t89*t90-3.9381
     1         165894987163d-1*t106*t107*t20*t22*t89*t90-1.0339174848323
     2         335d-1*t100*t20*t89*t90+7.876233178997433d-1*t119*t20*t22
     3         *t54*t55*t90-1.0d+0*t176*t20*t23*t90+6.0d+0*t118*t119*t20
     4         *t23*t89-1.5752466357994865d+0*t117*t118*t20*t22*t54*t55-
     5         2.917123399628679d-1*t157*t20*t22*t54-6.0d+0*t174*t175*t2
     6         0*t23-1.0939212748607545d-1*t159*t160*t20*t22-2.625411059
     7         665811d-1*t100*t106*t20*t22-1.2062370656377223d-1*t151*t2
     8         0
            t179 = 1/t78**3
            t180 = 1/t41**8
            t181 = 1/t41**6
            t182 = 1/t41**4
            t183 = 1/t81**3
            t184 = 1/t43**8
            t185 = 1/t43**6
            t186 = 1/t43**4
            t187 = 1/t35**4
            t188 = 1/t38**4
            t189 = t68**3
            t190 = 1/t27**3
            t191 = -1.9066318539973046d+0*t157*t54+t164-7.14986945248989
     1         1d-1*t159*t160-1.715968668597574d+0*t100*t106
            t192 = -6.203504908994001d-1*t191*t29*t69*t9+3.7221029453964
     1         005d+0*t130*t131*t29*t68*t9-3.7221029453964005d+0*t189*t1
     2         90*t29*t9-8.271339878658668d-1*t109*t29*t52*t68*t69+6.203
     3         504908994001d-1*t131*t29*t52*t58*t69-1.2407009817988002d+
     4         0*t129*t130*t29*t52*t58-6.433264350067852d-1*t166*t29*t52
            t193 = t71**3
            t194 = 1/t31**3
            t195 = -2.9350782941533937d+0*t157*t54+t164-1.10065436030752
     1         25d+0*t159*t160-2.6415704647380545d+0*t100*t106
            t196 = -6.203504908994001d-1*t195*t33*t72*t9+3.7221029453964
     1         005d+0*t134*t135*t33*t71*t9-3.7221029453964005d+0*t193*t1
     2         94*t33*t9-8.271339878658668d-1*t109*t33*t52*t71*t72+6.203
     3         504908994001d-1*t135*t33*t52*t58*t72-1.2407009817988002d+
     4         0*t133*t134*t33*t52*t58-6.433264350067852d-1*t166*t33*t52
            t197 = -5.250822119331622d-1*t102*t29*t35*t54*t68*t69-3.9381
     1         165894987163d-1*t106*t107*t29*t35*t68*t69-1.0339174848323
     2         335d-1*t100*t29*t68*t69+7.876233178997433d-1*t131*t29*t35
     3         *t54*t55*t69-1.0d+0*t191*t29*t36*t69+6.0d+0*t130*t131*t29
     4         *t36*t68-1.5752466357994865d+0*t129*t130*t29*t35*t54*t55-
     5         2.917123399628679d-1*t157*t29*t35*t54-6.0d+0*t189*t190*t2
     6         9*t36-1.0939212748607545d-1*t159*t160*t29*t35-2.625411059
     7         665811d-1*t100*t106*t29*t35-1.2062370656377223d-1*t151*t2
     8         9
            t198 = -5.250822119331622d-1*t102*t33*t38*t54*t71*t72-3.9381
     1         165894987163d-1*t106*t107*t33*t38*t71*t72-1.0339174848323
     2         335d-1*t100*t33*t71*t72+7.876233178997433d-1*t135*t33*t38
     3         *t54*t55*t72-1.0d+0*t195*t33*t39*t72+6.0d+0*t134*t135*t33
     4         *t39*t71-1.5752466357994865d+0*t133*t134*t33*t38*t54*t55-
     5         2.917123399628679d-1*t157*t33*t38*t54-6.0d+0*t193*t194*t3
     6         3*t39-1.0939212748607545d-1*t159*t160*t33*t38-2.625411059
     7         665811d-1*t100*t106*t33*t38-1.2062370656377223d-1*t151*t3
     8         3
            t199 = t65**3
            t200 = 1/t45**3
            t201 = -1.0298058196603158d+0*t157*t54+t164-3.86177182372618
     1         33d-1*t159*t160-9.26825237694284d-1*t100*t106
            fnc(iq) = 1.0d+0*rhob*t51*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t97*wght+1.0d+0*t51*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 2.0d+0*t97*wght+1.0d+0*rhob*t150*wght+A
     1         mat2(iq,D2_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*rhob*(9.99999999999999d-1*(-4
     1         .356968291048705d+0*t151*t98*t99+2.2877665475865033d+0*t1
     2         54*t155*t54*t98+2.5058979122369923d-2*t46*t52*(-6.2035049
     3         08994001d-1*t201*t47*t66*t9+3.7221029453964005d+0*t145*t1
     4         46*t47*t65*t9-3.7221029453964005d+0*t199*t200*t47*t9-8.27
     5         1339878658668d-1*t109*t47*t52*t65*t66+6.203504908994001d-
     6         1*t146*t47*t52*t58*t66-1.2407009817988002d+0*t144*t145*t4
     7         7*t52*t58-6.433264350067852d-1*t166*t47*t52)-2.6673100072
     8         73315d-3*t135*t31*t33*t87*t88-1.400557038530531d-3*t138*t
     9         31*t33*t54*t55*t71*t88+4.668523461768438d-4*t102*t138*t32
     :         *t54*t88-2.757778453988139d-4*t100*t188*t32*t88+3.5013925
     ;         96326328d-4*t106*t107*t138*t32*t88-5.33462001454663d-3*t1
     <         40*t31*t33*t71*t87-2.667310007273315d-3*t198*t32*t87+4.43
     =         1373767749538d-3*t131*t27*t29*t85*t86+2.3268355398725185d
     >         -3*t137*t27*t29*t54*t55*t68*t86-7.756118466241728d-4*t102
     ?         *t137*t28*t54*t86+4.5816748203035834d-4*t100*t187*t28*t86
     @         -5.817088849681296d-4*t106*t107*t137*t28*t86+8.8627475354
     1         99076d-3*t139*t27*t29*t68*t85+4.431373767749538d-3*t197*t
     2         28*t85+2.2478670955426108d-3*t146*t45*t47*t83*t84+1.18031
     3         50266592868d-3*t148*t45*t47*t54*t55*t65*t84-3.93438342219
     4         7623d-4*t102*t148*t46*t54*t84+2.3241090936607786d-4*t100*
     5         t46*t84/t48**4-2.9507875666482175d-4*t106*t107*t148*t46*t
     6         84+2.2478670955426108d-3*t46*(-5.250822119331622d-1*t102*
     7         t47*t48*t54*t65*t66-3.9381165894987163d-1*t106*t107*t47*t
     8         48*t65*t66-1.0339174848323335d-1*t100*t47*t65*t66+7.87623
     9         3178997433d-1*t146*t47*t48*t54*t55*t66-1.0d+0*t201*t47*t4
     :         9*t66+6.0d+0*t145*t146*t47*t49*t65-1.5752466357994865d+0*
     ;         t144*t145*t47*t48*t54*t55-2.917123399628679d-1*t157*t47*t
     <         48*t54-6.0d+0*t199*t200*t47*t49-1.0939212748607545d-1*t15
     =         9*t160*t47*t48-2.625411059665811d-1*t100*t106*t47*t48-1.2
     >         062370656377223d-1*t151*t47)*t83+4.4957341910852217d-3*t1
     ?         49*t45*t47*t65*t83-2.1150894194591274d-1*t157*t54*t80*t82
     @         -7.931585322971725d-2*t159*t160*t80*t82-1.903580477513214
     1         5d-1*t100*t106*t80*t82-7.872580557945579d-2*t154*t186*t54
     2         *t82+3.498376867038983d-1*t128*t151*t82-9.690227711544375
     3         d-4*t108*t6*t63*t64*t8-5.088166200913744d-4*t112*t54*t55*
     4         t56*t6*t64*t8-1.938045542308875d-3*t113*t56*t6*t63*t8-3.3
     5         4119721631599d-2*t111*t52*t56*t59*t6*t8-5.011795824473985
     6         d-2*t108*t52*t59*t6*t8-1.002359164894797d-1*t110*t52*t56*
     7         t6*t8+2.6879375566081715d-1*t157*t54*t77*t79+1.0079765837
     8         28064d-1*t159*t160*t77*t79+2.419143800947354d-1*t100*t106
     9         *t77*t79+1.0004780296492877d-1*t154*t182*t54*t79-4.445872
     :         822950419d-1*t125*t151*t79+7.244178432040066d-2*t157*t54*
     ;         t74*t76+2.716566912015024d-2*t159*t160*t74*t76+6.51976058
     <         883606d-2*t100*t106*t74*t76+2.69635778788734d-2*t154*t54*
     =         t76/t50**4-1.1981936089412427d-1*t143*t151*t76+1.80094815
     >         22035156d+1*t154*t54/(t50**8*t75**3)-1.670598608157995d-2
     ?         *t111*t31*t33*t52*t71*t73-2.5058979122369923d-2*t135*t31*
     @         t33*t52*t73-2.784331013596658d-3*t161*t32*t52*t73+8.35299
     1         3040789973d-3*t160*t32*t52*t73-5.011795824473985d-2*t136*
     2         t31*t33*t52*t71+3.34119721631599d-2*t111*t27*t29*t52*t68*
     3         t70+5.011795824473985d-2*t131*t27*t29*t52*t70+5.568662027
     4         193316d-3*t161*t28*t52*t70-1.6705986081579946d-2*t160*t28
     5         *t52*t70+1.696055400304582d-4*t102*t112*t54*t64*t7-1.0018
     6         895862972538d-4*t100*t158*t64*t7+1.272041550228436d-4*t10
     7         6*t107*t112*t64*t7-9.690227711544375d-4*t168*t63*t7-5.568
     8         662027193316d-3*t161*t52*t59*t7+1.6705986081579946d-2*t16
     9         0*t52*t59*t7-5.088166200913744d-4*t112*t113*t54*t55*t7-5.
     :         011795824473985d-2*t167*t52*t7-3.34119721631599d-2*t110*t
     ;         111*t52*t7+1.002359164894797d-1*t132*t27*t29*t52*t68+1.67
     <         0598608157995d-2*t111*t45*t47*t52*t65*t67+2.5058979122369
     =         923d-2*t146*t45*t47*t52*t67+2.784331013596658d-3*t161*t46
     >         *t52*t67-8.352993040789973d-3*t160*t46*t52*t67+5.01179582
     ?         4473985d-2*t147*t45*t47*t52*t65-6.96009523273821d-2*t157*
     @         t54*t60*t62-2.610035712276828d-2*t159*t160*t60*t62-6.2640
     1         8570946439d-2*t100*t106*t60*t62-2.590619096601433d-2*t154
     2         *t156*t54*t62+1.1512059930225654d-1*t101*t151*t62+1.18031
     3         50266592868d-3*t148*t149*t46*t54*t55-1.400557038530531d-3
     4         *t138*t140*t32*t54*t55+2.3268355398725185d-3*t137*t139*t2
     5         8*t54*t55-1.4081430686456894d+0*t141*t154*t54/t50**6+2.52
     6         18302197571857d-1*t126*t154*t185*t54-1.97833457907796d-1*
     7         t154*t183*t184*t54-4.7062486515309376d-4*t123*t154*t181*t
     8         54+5.421598446633554d-7*t154*t179*t180*t54-4.947718859586
     9         276d+1*t152*t153*t154*t54+1.670598608157995d-2*t111*t147*
     :         t46*t52-2.5058979122369923d-2*t196*t32*t52-1.670598608157
     ;         995d-2*t111*t136*t32*t52+5.011795824473985d-2*t192*t28*t5
     <         2+3.34119721631599d-2*t111*t132*t28*t52+2.681757326079316
     =         d+0*t141*t142*t151-4.802734052773798d-1*t126*t127*t151+8.
     >         962879611183625d-4*t123*t124*t151)+4.356968291048705d+0*t
     ?         151*t98*t99-2.2877665475865033d+0*t154*t155*t54*t98+5.848
     @         223622634643d-1*(1.0d+0*(3.6490335179177674d-4*t119*t18*t
     1         20*t95*t96+1.9160425910065093d-4*t121*t18*t20*t54*t55*t89
     2         *t96-6.386808636688365d-5*t102*t121*t19*t54*t96+3.7727995
     3         569144196d-5*t100*t173*t19*t96-4.790106477516273d-5*t106*
     4         t107*t121*t19*t96+7.298067035835535d-4*t122*t18*t20*t89*t
     5         95+3.6490335179177674d-4*t178*t19*t95+1.0655830899009261d
     6         -2*t157*t54*t92*t94+3.995936587128472d-3*t159*t160*t92*t9
     7         4+9.590247809108335d-3*t100*t106*t92*t94+3.96620995748483
     8         36d-3*t154*t172*t54*t94-1.7624839864078184d-2*t116*t151*t
     9         94+1.8147659200319294d-2*t111*t18*t20*t52*t89*t91+2.72214
     :         8880047894d-2*t119*t18*t20*t52*t91+3.024609866719882d-3*t
     ;         161*t19*t52*t91-9.073829600159644d-3*t160*t19*t52*t91+5.4
     <         44297760095788d-2*t120*t18*t20*t52*t89+1.709920934161365d
     =         +0*(2.667310007273315d-3*t135*t31*t33*t87*t88+1.400557038
     >         530531d-3*t138*t31*t33*t54*t55*t71*t88-4.668523461768438d
     ?         -4*t102*t138*t32*t54*t88+2.757778453988139d-4*t100*t188*t
     @         32*t88-3.501392596326328d-4*t106*t107*t138*t32*t88+5.3346
     1         2001454663d-3*t140*t31*t33*t71*t87+2.667310007273315d-3*t
     2         198*t32*t87-4.431373767749538d-3*t131*t27*t29*t85*t86-2.3
     3         268355398725185d-3*t137*t27*t29*t54*t55*t68*t86+7.7561184
     4         66241728d-4*t102*t137*t28*t54*t86-4.5816748203035834d-4*t
     5         100*t187*t28*t86+5.817088849681296d-4*t106*t107*t137*t28*
     6         t86-8.862747535499076d-3*t139*t27*t29*t68*t85-4.431373767
     7         749538d-3*t197*t28*t85+2.1150894194591274d-1*t157*t54*t80
     8         *t82+7.931585322971725d-2*t159*t160*t80*t82+1.90358047751
     9         32145d-1*t100*t106*t80*t82+7.872580557945579d-2*t154*t186
     :         *t54*t82-3.498376867038983d-1*t128*t151*t82-2.68793755660
     ;         81715d-1*t157*t54*t77*t79-1.007976583728064d-1*t159*t160*
     <         t77*t79-2.419143800947354d-1*t100*t106*t77*t79-1.00047802
     =         96492877d-1*t154*t182*t54*t79+4.445872822950419d-1*t125*t
     >         151*t79+1.670598608157995d-2*t111*t31*t33*t52*t71*t73+2.5
     ?         058979122369923d-2*t135*t31*t33*t52*t73+2.784331013596658
     @         d-3*t161*t32*t52*t73-8.352993040789973d-3*t160*t32*t52*t7
     1         3+5.011795824473985d-2*t136*t31*t33*t52*t71-3.34119721631
     2         599d-2*t111*t27*t29*t52*t68*t70-5.011795824473985d-2*t131
     3         *t27*t29*t52*t70-5.568662027193316d-3*t161*t28*t52*t70+1.
     4         6705986081579946d-2*t160*t28*t52*t70-1.002359164894797d-1
     5         *t132*t27*t29*t52*t68+1.400557038530531d-3*t138*t140*t32*
     6         t54*t55-2.3268355398725185d-3*t137*t139*t28*t54*t55-2.521
     7         8302197571857d-1*t126*t154*t185*t54+1.97833457907796d-1*t
     8         154*t183*t184*t54+4.7062486515309376d-4*t123*t154*t181*t5
     9         4-5.421598446633554d-7*t154*t179*t180*t54+2.5058979122369
     :         923d-2*t196*t32*t52+1.670598608157995d-2*t111*t136*t32*t5
     ;         2-5.011795824473985d-2*t192*t28*t52-3.34119721631599d-2*t
     <         111*t132*t28*t52+4.802734052773798d-1*t126*t127*t151-8.96
     =         2879611183625d-4*t123*t124*t151)+1.9160425910065093d-4*t1
     >         21*t122*t19*t54*t55-4.1445148651319325d-1*t114*t154*t171*
     ?         t54+1.0606128115063691d+1*t154*t169*t170*t54+2.7221488800
     @         47894d-2*t177*t19*t52+1.8147659200319294d-2*t111*t120*t19
     1         *t52+7.89307801891314d-1*t114*t115*t151)-3.64903351791776
     2         74d-4*t119*t18*t20*t95*t96-1.9160425910065093d-4*t121*t18
     3         *t20*t54*t55*t89*t96+6.386808636688365d-5*t102*t121*t19*t
     4         54*t96-3.7727995569144196d-5*t100*t173*t19*t96+4.79010647
     5         7516273d-5*t106*t107*t121*t19*t96-7.298067035835535d-4*t1
     6         22*t18*t20*t89*t95-3.6490335179177674d-4*t178*t19*t95-1.0
     7         655830899009261d-2*t157*t54*t92*t94-3.995936587128472d-3*
     8         t159*t160*t92*t94-9.590247809108335d-3*t100*t106*t92*t94-
     9         3.9662099574848336d-3*t154*t172*t54*t94+1.762483986407818
     :         4d-2*t116*t151*t94-1.8147659200319294d-2*t111*t18*t20*t52
     ;         *t89*t91-2.722148880047894d-2*t119*t18*t20*t52*t91-3.0246
     <         09866719882d-3*t161*t19*t52*t91+9.073829600159644d-3*t160
     =         *t19*t52*t91-5.444297760095788d-2*t120*t18*t20*t52*t89-1.
     >         9160425910065093d-4*t121*t122*t19*t54*t55+4.1445148651319
     ?         325d-1*t114*t154*t171*t54-1.0606128115063691d+1*t154*t169
     @         *t170*t54-2.722148880047894d-2*t177*t19*t52-1.81476592003
     1         19294d-2*t111*t120*t19*t52-7.89307801891314d-1*t114*t115*
     2         t151)+9.690227711544375d-4*t108*t6*t63*t64*t8+5.088166200
     3         913744d-4*t112*t54*t55*t56*t6*t64*t8+1.938045542308875d-3
     4         *t113*t56*t6*t63*t8+3.34119721631599d-2*t111*t52*t56*t59*
     5         t6*t8+5.011795824473985d-2*t108*t52*t59*t6*t8+1.002359164
     6         894797d-1*t110*t52*t56*t6*t8-1.696055400304582d-4*t102*t1
     7         12*t54*t64*t7+1.0018895862972538d-4*t100*t158*t64*t7-1.27
     8         2041550228436d-4*t106*t107*t112*t64*t7+9.690227711544375d
     9         -4*t168*t63*t7+5.568662027193316d-3*t161*t52*t59*t7-1.670
     :         5986081579946d-2*t160*t52*t59*t7+5.088166200913744d-4*t11
     ;         2*t113*t54*t55*t7+5.011795824473985d-2*t167*t52*t7+3.3411
     <         9721631599d-2*t110*t111*t52*t7+6.96009523273821d-2*t157*t
     =         54*t60*t62+2.610035712276828d-2*t159*t160*t60*t62+6.26408
     >         570946439d-2*t100*t106*t60*t62+2.590619096601433d-2*t154*
     ?         t156*t54*t62-1.1512059930225654d-1*t101*t151*t62+4.947718
     @         859586276d+1*t152*t153*t154*t54)*wght+3.0d+0*t150*wght+Am
     1         at3(iq,D3_RB_RB_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
