/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.chefproject.core.Realm;
import org.chefproject.core.RealmEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseDbSingleStorage;
import org.chefproject.service.component.BaseRealmService;

public class DbRealmService
extends BaseRealmService {
    protected String m_realmTableName = "CHEF_REALM";
    protected boolean m_locksInDb = true;

    public void init() throws InitializationException {
        this.m_realmTableName = this.getProperties().getProperty("realmTable", this.m_realmTableName);
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        super.init();
        Log.info("chef", this + ".init(): realm table: " + this.m_realmTableName);
    }

    protected BaseRealmService.Storage newStorage() {
        return new DbStorage(this);
    }

    protected class DbStorage
    extends BaseDbSingleStorage
    implements BaseRealmService.Storage {
        public DbStorage(StorageUser user) {
            super(DbRealmService.this.m_realmTableName, "REALM_ID", null, DbRealmService.this.m_locksInDb, "realm", user);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public Realm get(String id) {
            return (Realm)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public RealmEdit put(String id) {
            return (RealmEdit)super.putResource(id, null);
        }

        public RealmEdit edit(String id) {
            return (RealmEdit)super.editResource(id);
        }

        public void commit(RealmEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(RealmEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(RealmEdit edit) {
            super.removeResource(edit);
        }
    }
}

