/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.turbine.util.Log;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericMessageService;
import org.chefproject.util.Sql;
import org.chefproject.util.SqlReader;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Validator;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MessageContextConverter
implements Runnable {
    private String m_channelTableName = null;
    private String m_messageTableName = null;
    private GenericMessageService m_service = null;

    public MessageContextConverter(String channelTableName, String messageTableName, GenericMessageService service) {
        this.m_channelTableName = channelTableName;
        this.m_messageTableName = messageTableName;
        this.m_service = service;
    }

    private void convertChannels() {
        String sql = "select XML from " + this.m_channelTableName;
        List records = Sql.dbRead(sql);
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String oldId = null;
            String context = null;
            String id = null;
            try {
                String xml = (String)it.next();
                Document doc = Xml.readDocumentFromString(xml);
                Element root = doc.getDocumentElement();
                oldId = StringUtil.trimToNull(root.getAttribute("id"));
                context = StringUtil.trimToNull(root.getAttribute("context"));
                if (context != null) continue;
                String[] parts = StringUtil.splitFirst(oldId, "-");
                if (parts.length == 2) {
                    if ("group".equals(parts[0])) {
                        context = parts[1];
                        id = "main";
                    } else if ("user".equals(parts[0])) {
                        context = "~" + parts[1];
                        id = "main";
                    } else {
                        context = "!" + parts[0];
                        id = parts[1];
                    }
                } else {
                    context = "!site";
                    id = oldId;
                }
                Log.info("chef", " ** channel: old id: " + oldId + " new context: " + context + " new id: " + id);
                root.setAttribute("id", id);
                root.setAttribute("context", context);
                xml = Xml.writeDocumentToString(doc);
                String ref = this.m_service.channelReference(context, id);
                String statement = "update " + this.m_channelTableName + " set" + " CHANNEL_ID = '" + Validator.escapeSql(ref) + "'," + " XML = ?" + " where ( CHANNEL_ID = '" + Validator.escapeSql(oldId) + "' )";
                boolean ok = Sql.dbWrite(statement, xml);
                if (ok) {
                    Log.info("chef", " ** channel: " + ref + " record updated.");
                    continue;
                }
                Log.info("chef", " ** channel: " + ref + " ERROR updating record.");
            }
            catch (Exception e) {
                Log.warn("chef", " ** exception while converting: " + oldId + " : " + e);
            }
        }
    }

    private void convertMessages() {
        String sql = "select CHANNEL_ID, MESSAGE_ID from " + this.m_messageTableName;
        List records = Sql.dbRead(sql, null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                try {
                    String ch = result.getString(1);
                    String m = result.getString(2);
                    return new MessageId(ch, m);
                }
                catch (SQLException ignore) {
                    return null;
                }
            }
        });
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String id = null;
            String context = null;
            MessageId mid = (MessageId)it.next();
            if (mid == null || mid.channelId.startsWith("/")) continue;
            try {
                String[] parts = StringUtil.splitFirst(mid.channelId, "-");
                if (parts.length == 2) {
                    if ("group".equals(parts[0])) {
                        context = parts[1];
                        id = "main";
                    } else if ("user".equals(parts[0])) {
                        context = "~" + parts[1];
                        id = "main";
                    } else {
                        context = "!" + parts[0];
                        id = parts[1];
                    }
                } else {
                    context = "!site";
                    id = mid.channelId;
                }
                Log.info("chef", " ** message: old channel id: " + mid.channelId + " new context: " + context + " new id: " + id);
                String ref = this.m_service.channelReference(context, id);
                String statement = "update " + this.m_messageTableName + " set" + " CHANNEL_ID = '" + Validator.escapeSql(ref) + "'" + " where ( CHANNEL_ID = '" + Validator.escapeSql(mid.channelId) + "'" + " and MESSAGE_ID = '" + Validator.escapeSql(mid.messageId) + "' )";
                boolean ok = Sql.dbWrite(statement);
                if (ok) {
                    Log.info("chef", " ** message: " + mid.messageId + " channel: " + ref + " record updated.");
                    continue;
                }
                Log.info("chef", " ** message: " + mid.messageId + " channel: " + ref + " ERROR updating record.");
            }
            catch (Exception e) {
                Log.warn("chef", " ** exception while converting message: " + mid.channelId + " : " + mid.messageId + " : " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log.info("chef", " ** Converting message channels for context **");
        UsageSessionService.loginThreadUser("admin");
        try {
            this.convertChannels();
            this.convertMessages();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            UsageSessionService.logoutThreadUser();
            throw throwable;
        }
        UsageSessionService.logoutThreadUser();
    }

    public static void convert(String channelTableName, String messageTableName, GenericMessageService service) {
        MessageContextConverter converter = new MessageContextConverter(channelTableName, messageTableName, service);
        Thread thread = new Thread((Runnable)converter, "MessageContextConverter");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    private class MessageId {
        public String channelId;
        public String messageId;

        public MessageId(String ch, String m) {
            this.channelId = ch;
            this.messageId = m;
        }
    }
}

