/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject.test;

import com.sourceforge.knecs.dsm.resourceobject.DataRequest;
import com.sourceforge.knecs.dsm.resourceobject.RISConnection;
import com.sourceforge.knecs.dsm.resourceobject.RISConnectionFactory;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.security.jaas.CMCSNameHandler;
import com.sourceforge.knecs.security.jaas.JAASUtils;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import java.net.PasswordAuthentication;
import java.util.logging.Logger;
import javax.security.auth.login.LoginContext;

public class RISTest {
    private RISTest(String[] args) {
        Logger mlog = LoggerUtils.getLogger(this);
        mlog.info("Starting RISTest logging");
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String context = props.getProperty("logincontext");
        String account = props.getProperty("portalid");
        String pop = props.getProperty("portalobjects");
        String mHoststr = svr + pop;
        try {
            JAASUtils.initLoginConfig(this.getClass());
        }
        catch (SecurityException se) {
            System.out.println("Unable to initialize JAAS config " + se.getMessage());
            System.exit(-1);
        }
        try {
            LoginContext lc = new LoginContext(context, new CMCSNameHandler(account));
            lc.login();
            PasswordAuthentication pa = JAASUtils.subjectToDSICredentials(lc.getSubject());
            RISConnection ris = RISConnectionFactory.getRISConnection(mHoststr);
            ris.connect(pa.getUserName(), new String(pa.getPassword()));
            DataRequest dr = new DataRequest();
            dr.setOwnerId("bdidier");
            dr.setCommonName("btd data request");
            String[] recipients = new String[]{"brett.didier@pnl.gov"};
            dr.setRecipients(recipients);
            String[] speciesName = new String[]{"vinoxy"};
            dr.setSpeciesName(speciesName);
            String[] chemProperties = new String[]{"Molecular Geometry", "Entropy"};
            dr.setChemProperties(chemProperties);
            dr.setPriority("Medium");
            dr.setContent("my xml goes here");
            String ctxName = ris.save(dr);
            String xml = dr.toXML();
            System.out.println("DataRequest XML->\n " + xml);
            ResourceObject ro = ris.getResourceObject(ctxName);
            if (ro != null) {
                mlog.info("getobject result XML" + ro.toXML());
            }
            if ((ro = ris.getResourceObject(ctxName = ris.save(dr))) != null) {
                mlog.info("getobject result XML" + ro.toXML());
            }
            String[] newName = new String[]{"methanol"};
            dr.setSpeciesName(newName);
            dr.setMessage("Need the data fast");
            ctxName = ris.replace(ro, dr);
            ro = ris.getResourceObject(ctxName);
            if (ro != null) {
                mlog.info("getobject result XML" + ro.toXML());
            }
            ris.close();
            lc.logout();
        }
        catch (Exception ex) {
            mlog.severe("Caught Exception during RISTest: " + ex.toString() + "\n" + "Trace:\n" + ex.getStackTrace().toString());
        }
    }

    public static void main(String[] args) {
        RISTest st = new RISTest(args);
    }
}

